/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.vo.thirdapp;

import com.jeecg.dingtalk.api.department.vo.Department;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.BeanUtils;

public class JdtDepartmentTreeVo
extends Department {
    private List<JdtDepartmentTreeVo> children;

    public List<JdtDepartmentTreeVo> getChildren() {
        return this.children;
    }

    public JdtDepartmentTreeVo setChildren(List<JdtDepartmentTreeVo> children) {
        this.children = children;
        return this;
    }

    public JdtDepartmentTreeVo(Department department) {
        BeanUtils.copyProperties((Object)department, (Object)((Object)this));
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public String toString() {
        return "JwDepartmentTree{children=" + this.children + "} " + super.toString();
    }

    public static List<JdtDepartmentTreeVo> listToTree(List<Department> allDepartment) {
        List<JdtDepartmentTreeVo> treeList = JdtDepartmentTreeVo.getByParentId(1, allDepartment);
        Optional<Department> departmentOptional = allDepartment.stream().filter(item -> item.getParent_id() == null).findAny();
        Department department = new Department();
        if (departmentOptional.isPresent()) {
            department = departmentOptional.get();
        }
        JdtDepartmentTreeVo.getChildrenRecursion(treeList, allDepartment);
        JdtDepartmentTreeVo treeVo = new JdtDepartmentTreeVo(department);
        treeVo.setChildren(treeList);
        ArrayList<JdtDepartmentTreeVo> list = new ArrayList<JdtDepartmentTreeVo>();
        list.add(treeVo);
        return list;
    }

    private static List<JdtDepartmentTreeVo> getByParentId(Integer parentId, List<Department> allDepartment) {
        ArrayList<JdtDepartmentTreeVo> list = new ArrayList<JdtDepartmentTreeVo>();
        for (Department department : allDepartment) {
            if (!parentId.equals(department.getParent_id())) continue;
            list.add(new JdtDepartmentTreeVo(department));
        }
        return list;
    }

    private static void getChildrenRecursion(List<JdtDepartmentTreeVo> treeList, List<Department> allDepartment) {
        for (JdtDepartmentTreeVo departmentTree : treeList) {
            List<JdtDepartmentTreeVo> children = JdtDepartmentTreeVo.getByParentId(departmentTree.getDept_id(), allDepartment);
            if (children.size() <= 0) continue;
            departmentTree.setChildren(children);
            JdtDepartmentTreeVo.getChildrenRecursion(children, allDepartment);
        }
    }
}

