/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.util;

import java.util.List;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysRoleIndex;
import org.jeecg.modules.system.service.ISysRoleIndexService;

public class PermissionDataUtil {
    private static final String PATH_VIEWS = "views/";
    private static final String PATH_SRC_VIEWS = "src/views/";
    private static final String VUE_SUFFIX = ".vue";

    public static SysPermission intelligentProcessData(SysPermission permission) {
        if (permission == null) {
            return null;
        }
        if (oConvertUtils.isNotEmpty((Object)permission.getComponent())) {
            String component = permission.getComponent();
            if (component.startsWith("/")) {
                component = component.substring(1);
            }
            if (component.startsWith(PATH_VIEWS)) {
                component = component.replaceFirst(PATH_VIEWS, "");
            }
            if (component.startsWith(PATH_SRC_VIEWS)) {
                component = component.replaceFirst(PATH_SRC_VIEWS, "");
            }
            if (component.endsWith(VUE_SUFFIX)) {
                component = component.replace(VUE_SUFFIX, "");
            }
            permission.setComponent(component);
        }
        if (oConvertUtils.isNotEmpty((Object)permission.getUrl())) {
            String url = permission.getUrl();
            if (url.endsWith(VUE_SUFFIX)) {
                url = url.replace(VUE_SUFFIX, "");
            }
            if (!(url.startsWith("http") || url.startsWith("/") || url.trim().startsWith("{{"))) {
                url = "/" + url;
            }
            permission.setUrl(url);
        }
        if (0 == permission.getMenuType() && oConvertUtils.isEmpty((Object)permission.getComponent())) {
            permission.setComponent("layouts/RouteView");
        }
        return permission;
    }

    public static void addIndexPage(List<SysPermission> metaList) {
        boolean hasIndexMenu = false;
        SysRoleIndex defIndexCfg = PermissionDataUtil.getDefIndexConfig();
        for (SysPermission sysPermission : metaList) {
            if (!defIndexCfg.getUrl().equals(sysPermission.getUrl())) continue;
            hasIndexMenu = true;
            break;
        }
        if (!hasIndexMenu) {
            metaList.add(0, new SysPermission(true));
        }
    }

    public static boolean hasIndexPage(List<SysPermission> metaList, SysRoleIndex defIndexCfg) {
        boolean hasIndexMenu = false;
        for (SysPermission sysPermission : metaList) {
            if (!defIndexCfg.getUrl().equals(sysPermission.getUrl())) continue;
            hasIndexMenu = true;
            break;
        }
        return hasIndexMenu;
    }

    public static boolean hasMenuById(List<SysPermission> metaList, String id) {
        for (SysPermission sysPermission : metaList) {
            if (!id.equals(sysPermission.getId())) continue;
            return true;
        }
        return false;
    }

    public static SysRoleIndex getDefIndexConfig() {
        ISysRoleIndexService sysRoleIndexService = (ISysRoleIndexService)SpringContextUtils.getBean(ISysRoleIndexService.class);
        return sysRoleIndexService.queryDefaultIndex();
    }
}

