/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.DySmsEnum;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.constant.enums.RoleIndexConfigEnum;
import org.jeecg.common.constant.enums.SysAnnmentTypeEnum;
import org.jeecg.common.desensitization.annotation.SensitiveEncode;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.DySmsHelper;
import org.jeecg.common.util.DySmsLimit;
import org.jeecg.common.util.FillRuleUtil;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.message.handle.impl.SystemSendMsgHandle;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysDepartRoleUser;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysPosition;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.entity.SysRoleIndex;
import org.jeecg.modules.system.entity.SysTenant;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.entity.SysUserPosition;
import org.jeecg.modules.system.entity.SysUserRole;
import org.jeecg.modules.system.entity.SysUserTenant;
import org.jeecg.modules.system.mapper.SysDepartMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleUserMapper;
import org.jeecg.modules.system.mapper.SysPermissionMapper;
import org.jeecg.modules.system.mapper.SysPositionMapper;
import org.jeecg.modules.system.mapper.SysRoleMapper;
import org.jeecg.modules.system.mapper.SysTenantMapper;
import org.jeecg.modules.system.mapper.SysThirdAccountMapper;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserPositionMapper;
import org.jeecg.modules.system.mapper.SysUserRoleMapper;
import org.jeecg.modules.system.mapper.SysUserTenantMapper;
import org.jeecg.modules.system.model.SysUserSysDepartModel;
import org.jeecg.modules.system.service.ISysRoleIndexService;
import org.jeecg.modules.system.service.ISysThirdAccountService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.impl.ThirdAppDingtalkServiceImpl;
import org.jeecg.modules.system.service.impl.ThirdAppWechatEnterpriseServiceImpl;
import org.jeecg.modules.system.vo.SysUserDepVo;
import org.jeecg.modules.system.vo.SysUserPositionVo;
import org.jeecg.modules.system.vo.UserAvatar;
import org.jeecg.modules.system.vo.lowapp.AppExportUserVo;
import org.jeecg.modules.system.vo.lowapp.DepartAndUserInfo;
import org.jeecg.modules.system.vo.lowapp.DepartInfo;
import org.jeecg.modules.system.vo.lowapp.UpdateDepartInfo;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@Service
public class SysUserServiceImpl
extends ServiceImpl<SysUserMapper, SysUser>
implements ISysUserService {
    private static final Logger log = LoggerFactory.getLogger(SysUserServiceImpl.class);
    @Autowired
    private SysUserMapper userMapper;
    @Autowired
    private SysPermissionMapper sysPermissionMapper;
    @Autowired
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private SysUserDepartMapper sysUserDepartMapper;
    @Autowired
    private SysDepartMapper sysDepartMapper;
    @Autowired
    private SysRoleMapper sysRoleMapper;
    @Autowired
    private SysDepartRoleUserMapper departRoleUserMapper;
    @Autowired
    private SysDepartRoleMapper sysDepartRoleMapper;
    @Resource
    private BaseCommonService baseCommonService;
    @Autowired
    private SysThirdAccountMapper sysThirdAccountMapper;
    @Autowired
    ThirdAppWechatEnterpriseServiceImpl wechatEnterpriseService;
    @Autowired
    ThirdAppDingtalkServiceImpl dingtalkService;
    @Autowired
    ISysRoleIndexService sysRoleIndexService;
    @Autowired
    SysTenantMapper sysTenantMapper;
    @Autowired
    private SysUserTenantMapper relationMapper;
    @Autowired
    private SysUserTenantMapper userTenantMapper;
    @Autowired
    private SysUserPositionMapper sysUserPositionMapper;
    @Autowired
    private SysPositionMapper sysPositionMapper;
    @Autowired
    private SystemSendMsgHandle systemSendMsgHandle;
    @Autowired
    private ISysThirdAccountService sysThirdAccountService;
    @Autowired
    private RedisUtil redisUtil;

    @Override
    public Result<IPage<SysUser>> queryPageList(HttpServletRequest req, QueryWrapper<SysUser> queryWrapper, Integer pageSize, Integer pageNo) {
        String status;
        String code;
        Result result = new Result();
        String departId = req.getParameter("departId");
        if (oConvertUtils.isNotEmpty((Object)departId)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysUserDepart::getDepId, (Object)departId);
            List list = this.sysUserDepartMapper.selectList((Wrapper)query);
            List userIds = list.stream().map(SysUserDepart::getUserId).collect(Collectors.toList());
            if (oConvertUtils.listIsNotEmpty(userIds)) {
                queryWrapper.in((Object)"id", userIds);
            } else {
                return Result.OK();
            }
        }
        if (oConvertUtils.isNotEmpty((Object)(code = req.getParameter("code")))) {
            queryWrapper.in((Object)"id", Arrays.asList(code.split(",")));
            pageSize = code.split(",").length;
        }
        if (oConvertUtils.isNotEmpty((Object)(status = req.getParameter("status")))) {
            queryWrapper.eq((Object)"status", (Object)Integer.parseInt(status));
        }
        String tenantId = TokenUtils.getTenantIdByRequest((HttpServletRequest)req);
        String lowAppId = TokenUtils.getLowAppIdByRequest((HttpServletRequest)req);
        queryWrapper.ne((Object)"username", (Object)"_reserve_user_external");
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.page((IPage)page, (Wrapper)queryWrapper);
        List<String> userIds = pageList.getRecords().stream().map(SysUser::getId).collect(Collectors.toList());
        if (userIds != null && userIds.size() > 0) {
            Map<String, String> useDepNames = this.getDepNamesByUserIds(userIds);
            pageList.getRecords().forEach(item -> {
                item.setOrgCodeTxt((String)useDepNames.get(item.getId()));
                List<Integer> list = this.userTenantMapper.getTenantIdsByUserId(item.getId());
                if (oConvertUtils.isNotEmpty(list)) {
                    item.setRelTenantIds(StringUtils.join((Object[])list.toArray(), (String)","));
                } else {
                    item.setRelTenantIds("");
                }
                Integer posTenantId = null;
                if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                    posTenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
                }
                List<String> positionList = this.sysUserPositionMapper.getPositionIdByUserTenantId(item.getId(), posTenantId);
                item.setPost(CommonUtils.getSplitText(positionList, (String)","));
                if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                    LambdaQueryWrapper query = new LambdaQueryWrapper();
                    query.eq(SysThirdAccount::getSysUserId, (Object)item.getId());
                    query.eq(SysThirdAccount::getTenantId, (Object)tenantId);
                    query.eq(SysThirdAccount::getThirdType, (Object)MessageTypeEnum.DD.getType());
                    List account = this.sysThirdAccountService.list((Wrapper)query);
                    if (CollectionUtil.isNotEmpty((Collection)account)) {
                        item.setIzBindThird(true);
                    }
                }
            });
        }
        result.setSuccess(true);
        result.setResult((Object)pageList);
        return result;
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public Result<?> resetPassword(String username, String oldpassword, String newpassword, String confirmpassword) {
        SysUser user = this.userMapper.getUserByName(username);
        String passwordEncode = PasswordUtil.encrypt((String)username, (String)oldpassword, (String)user.getSalt());
        if (!user.getPassword().equals(passwordEncode)) {
            return Result.error((String)"\u65e7\u5bc6\u7801\u8f93\u5165\u9519\u8bef!");
        }
        if (oConvertUtils.isEmpty((Object)newpassword)) {
            return Result.error((String)"\u65b0\u5bc6\u7801\u4e0d\u5141\u8bb8\u4e3a\u7a7a!");
        }
        if (!newpassword.equals(confirmpassword)) {
            return Result.error((String)"\u4e24\u6b21\u8f93\u5165\u5bc6\u7801\u4e0d\u4e00\u81f4!");
        }
        String password = PasswordUtil.encrypt((String)username, (String)newpassword, (String)user.getSalt());
        this.userMapper.update(new SysUser().setPassword(password), (Wrapper)new LambdaQueryWrapper().eq(SysUser::getId, (Object)user.getId()));
        return Result.ok((String)"\u5bc6\u7801\u91cd\u7f6e\u6210\u529f!");
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public Result<?> changePassword(SysUser sysUser) {
        String salt = oConvertUtils.randomGen((int)8);
        sysUser.setSalt(salt);
        String password = sysUser.getPassword();
        String passwordEncode = PasswordUtil.encrypt((String)sysUser.getUsername(), (String)password, (String)salt);
        sysUser.setPassword(passwordEncode);
        this.userMapper.updateById(sysUser);
        return Result.ok((String)"\u5bc6\u7801\u4fee\u6539\u6210\u529f!");
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteUser(String userId) {
        this.removeById((Serializable)((Object)userId));
        return false;
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteBatchUsers(String userIds) {
        this.removeByIds(Arrays.asList(userIds.split(",")));
        return false;
    }

    @Override
    public SysUser getUserByName(String username) {
        SysUser sysUser = this.userMapper.getUserByName(username);
        if (sysUser != null) {
            List<Integer> list = this.userTenantMapper.getTenantIdsByUserId(sysUser.getId());
            if (oConvertUtils.isNotEmpty(list)) {
                sysUser.setRelTenantIds(StringUtils.join((Object[])list.toArray(), (String)","));
            } else {
                sysUser.setRelTenantIds("");
            }
        }
        return sysUser;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUserWithRole(SysUser user, String roles) {
        this.save(user);
        if (oConvertUtils.isNotEmpty((Object)roles)) {
            String[] arr;
            for (String roleId : arr = roles.split(",")) {
                SysUserRole userRole = new SysUserRole(user.getId(), roleId);
                this.sysUserRoleMapper.insert(userRole);
            }
        }
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void editUserWithRole(SysUser user, String roles) {
        this.updateById(user);
        this.sysUserRoleMapper.delete((Wrapper)new QueryWrapper().lambda().eq(SysUserRole::getUserId, (Object)user.getId()));
        if (oConvertUtils.isNotEmpty((Object)roles)) {
            String[] arr;
            for (String roleId : arr = roles.split(",")) {
                SysUserRole userRole = new SysUserRole(user.getId(), roleId);
                this.sysUserRoleMapper.insert(userRole);
            }
        }
    }

    @Override
    public List<String> getRole(String username) {
        return this.sysUserRoleMapper.getRoleByUserName(username);
    }

    @Override
    public SysRoleIndex getDynamicIndexByUserRole(String username, String version) {
        List<String> roles = this.sysUserRoleMapper.getRoleByUserName(username);
        String componentUrl = RoleIndexConfigEnum.getIndexByRoles(roles);
        SysRoleIndex roleIndex = new SysRoleIndex(componentUrl);
        boolean isV3 = "v3".equals(version);
        if (isV3 && CollectionUtils.isNotEmpty(roles)) {
            LambdaQueryWrapper routeIndexQuery = new LambdaQueryWrapper();
            routeIndexQuery.in(SysRoleIndex::getRoleCode, roles);
            routeIndexQuery.eq(SysRoleIndex::getStatus, (Object)"1");
            routeIndexQuery.orderByAsc(SysRoleIndex::getPriority);
            List list = this.sysRoleIndexService.list((Wrapper)routeIndexQuery);
            if (CollectionUtils.isNotEmpty((Collection)list)) {
                roleIndex = (SysRoleIndex)list.get(0);
            }
        }
        if (oConvertUtils.isEmpty((Object)roleIndex.getComponent())) {
            if (isV3) {
                return this.sysRoleIndexService.queryDefaultIndex();
            }
            return null;
        }
        return roleIndex;
    }

    @Override
    public Set<String> getUserRolesSet(String username) {
        List<String> roles = this.sysUserRoleMapper.getRoleByUserName(username);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------username\uff1a " + username + ",Roles size: " + (roles == null ? 0 : roles.size()));
        return new HashSet<String>(roles);
    }

    @Override
    public Set<String> getUserRoleSetById(String userId) {
        List<String> roles = this.sysUserRoleMapper.getRoleCodeByUserId(userId);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------userId\uff1a " + userId + ",Roles size: " + (roles == null ? 0 : roles.size()));
        return new HashSet<String>(roles);
    }

    @Override
    public Set<String> getUserPermissionsSet(String userId) {
        HashSet<String> permissionSet = new HashSet<String>();
        List<SysPermission> permissionList = this.sysPermissionMapper.queryByUser(userId);
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            if (permissionList == null) {
                permissionList = new ArrayList<SysPermission>();
            }
            List<SysPermission> testRoleList = this.sysPermissionMapper.queryPermissionByTestRoleId();
            permissionList.addAll(testRoleList);
        }
        for (SysPermission po : permissionList) {
            if (!oConvertUtils.isNotEmpty((Object)po.getPerms())) continue;
            permissionSet.add(po.getPerms());
        }
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u6743\u9650Perms------userId\uff1a " + userId + ",Perms size: " + (permissionSet == null ? 0 : permissionSet.size()));
        return permissionSet;
    }

    @Override
    public SysUserCacheInfo getCacheUser(String username) {
        SysUserCacheInfo info = new SysUserCacheInfo();
        info.setOneDepart(true);
        if (oConvertUtils.isEmpty((Object)username)) {
            return null;
        }
        SysUser sysUser = this.userMapper.getUserByName(username);
        if (sysUser != null) {
            info.setSysUserCode(sysUser.getUsername());
            info.setSysUserName(sysUser.getRealname());
            info.setSysOrgCode(sysUser.getOrgCode());
        }
        List<SysDepart> list = this.sysDepartMapper.queryUserDeparts(sysUser.getId());
        ArrayList<String> sysMultiOrgCode = new ArrayList<String>();
        if (list != null && list.size() != 0) {
            if (list.size() == 1) {
                sysMultiOrgCode.add(list.get(0).getOrgCode());
            } else {
                info.setOneDepart(false);
                for (SysDepart dpt : list) {
                    sysMultiOrgCode.add(dpt.getOrgCode());
                }
            }
        }
        info.setSysMultiOrgCode(sysMultiOrgCode);
        return info;
    }

    @Override
    public IPage<SysUser> getUserByDepId(Page<SysUser> page, String departId, String username) {
        return this.userMapper.getUserByDepId(page, departId, username);
    }

    @Override
    public IPage<SysUser> getUserByDepIds(Page<SysUser> page, List<String> departIds, String username) {
        return this.userMapper.getUserByDepIds(page, departIds, username);
    }

    @Override
    public Map<String, String> getDepNamesByUserIds(List<String> userIds) {
        List<SysUserDepVo> list = ((SysUserMapper)this.baseMapper).getDepNamesByUserIds(userIds);
        HashMap<String, String> res = new HashMap<String, String>(5);
        list.forEach(item -> {
            if (res.get(item.getUserId()) == null) {
                res.put(item.getUserId(), item.getDepartName());
            } else {
                res.put(item.getUserId(), (String)res.get(item.getUserId()) + "," + item.getDepartName());
            }
        });
        return res;
    }

    @Override
    public IPage<SysUserSysDepartModel> queryUserByOrgCode(String orgCode, SysUser userParams, IPage page) {
        List<SysUserSysDepartModel> list = ((SysUserMapper)this.baseMapper).getUserByOrgCode(page, orgCode, userParams);
        for (SysUserSysDepartModel model : list) {
            List<String> positionList = this.sysUserPositionMapper.getPositionIdByUserId(model.getId());
            model.setPost(CommonUtils.getSplitText(positionList, (String)","));
        }
        Integer total = ((SysUserMapper)this.baseMapper).getUserByOrgCodeTotal(orgCode, userParams);
        Page result = new Page(page.getCurrent(), page.getSize(), (long)total.intValue());
        result.setRecords(list);
        return result;
    }

    @Override
    public IPage<SysUser> getUserByRoleId(Page<SysUser> page, String roleId, String username) {
        IPage<SysUser> userRoleList = this.userMapper.getUserByRoleId(page, roleId, username);
        List records = userRoleList.getRecords();
        if (null != records && records.size() > 0) {
            List<String> userIds = records.stream().map(SysUser::getId).collect(Collectors.toList());
            Map<String, String> useDepNames = this.getDepNamesByUserIds(userIds);
            for (SysUser sysUser : userRoleList.getRecords()) {
                sysUser.setOrgCodeTxt(useDepNames.get(sysUser.getId()));
                this.userPositionId(sysUser);
            }
        }
        return userRoleList;
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, key="#username")
    public void updateUserDepart(String username, String orgCode, Integer loginTenantId) {
        ((SysUserMapper)this.baseMapper).updateUserDepart(username, orgCode, loginTenantId);
    }

    @Override
    public SysUser getUserByPhone(String phone) {
        return this.userMapper.getUserByPhone(phone);
    }

    @Override
    public SysUser getUserByEmail(String email) {
        return this.userMapper.getUserByEmail(email);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void addUserWithDepart(SysUser user, String selectedParts) {
        if (oConvertUtils.isNotEmpty((Object)selectedParts)) {
            String[] arr;
            for (String deaprtId : arr = selectedParts.split(",")) {
                SysUserDepart userDeaprt = new SysUserDepart(user.getId(), deaprtId);
                this.sysUserDepartMapper.insert(userDeaprt);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public void editUserWithDepart(SysUser user, String departs) {
        List userDepartList;
        this.updateById(user);
        String[] arr = new String[]{};
        if (oConvertUtils.isNotEmpty((Object)departs)) {
            arr = departs.split(",");
        }
        if ((userDepartList = this.sysUserDepartMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(SysUserDepart::getUserId, (Object)user.getId()))) != null && userDepartList.size() > 0) {
            for (SysUserDepart depart : userDepartList) {
                List sysDepartRoleList;
                List roleIds;
                if (Arrays.asList(arr).contains(depart.getDepId()) || (roleIds = (sysDepartRoleList = this.sysDepartRoleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(SysDepartRole::getDepartId, (Object)depart.getDepId()))).stream().map(SysDepartRole::getId).collect(Collectors.toList())) == null || roleIds.size() <= 0) continue;
                this.departRoleUserMapper.delete((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysDepartRoleUser::getUserId, (Object)user.getId())).in(SysDepartRoleUser::getDroleId, roleIds));
            }
        }
        this.sysUserDepartMapper.delete((Wrapper)new QueryWrapper().lambda().eq(SysUserDepart::getUserId, (Object)user.getId()));
        if (oConvertUtils.isNotEmpty((Object)departs)) {
            for (String departId : arr) {
                SysUserDepart userDepart = new SysUserDepart(user.getId(), departId);
                this.sysUserDepartMapper.insert(userDepart);
            }
        }
    }

    public Result<?> checkUserIsEffective(SysUser sysUser) {
        Result result = new Result();
        if (sysUser == null) {
            result.error500("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u6ce8\u518c");
            this.baseCommonService.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u4e0d\u5b58\u5728\uff01", Integer.valueOf(1), null);
            return result;
        }
        if (CommonConstant.DEL_FLAG_1.equals(sysUser.getDelFlag())) {
            this.baseCommonService.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + sysUser.getUsername() + "\u5df2\u6ce8\u9500\uff01", Integer.valueOf(1), null);
            result.error500("\u8be5\u7528\u6237\u5df2\u6ce8\u9500");
            return result;
        }
        if (CommonConstant.USER_FREEZE.equals(sysUser.getStatus())) {
            this.baseCommonService.addLog("\u7528\u6237\u767b\u5f55\u5931\u8d25\uff0c\u7528\u6237\u540d:" + sysUser.getUsername() + "\u5df2\u51bb\u7ed3\uff01", Integer.valueOf(1), null);
            result.error500("\u8be5\u7528\u6237\u5df2\u51bb\u7ed3");
            return result;
        }
        return result;
    }

    @Override
    public List<SysUser> queryLogicDeleted() {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.ne(SysUser::getStatus, (Object)CommonConstant.USER_QUIT);
        return this.queryLogicDeleted((LambdaQueryWrapper<SysUser>)wrapper);
    }

    @Override
    public List<SysUser> queryLogicDeleted(LambdaQueryWrapper<SysUser> wrapper) {
        if (wrapper == null) {
            wrapper = new LambdaQueryWrapper();
        }
        wrapper.eq(SysUser::getDelFlag, (Object)CommonConstant.DEL_FLAG_1);
        return this.userMapper.selectLogicDeleted((Wrapper<SysUser>)wrapper);
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public boolean revertLogicDeleted(List<String> userIds, SysUser updateEntity) {
        return this.userMapper.revertLogicDeleted(userIds, updateEntity) > 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean removeLogicDeleted(List<String> userIds) {
        int line = this.userMapper.deleteLogicDeleted(userIds);
        line += this.sysUserDepartMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserDepart::getUserId, userIds));
        line += this.sysUserRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserRole::getUserId, userIds));
        try {
            this.dingtalkService.removeThirdAppUser(userIds);
            this.wechatEnterpriseService.removeThirdAppUser(userIds);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u5220\u9664\u7b2c\u4e09\u65b9App\u7684\u7528\u6237\u5931\u8d25\uff1a", (Throwable)e);
        }
        line += this.sysThirdAccountMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysThirdAccount::getSysUserId, userIds));
        return (line += this.userTenantMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserTenant::getUserId, userIds))) != 0;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean updateNullPhoneEmail() {
        this.userMapper.updateNullByEmptyString("email");
        this.userMapper.updateNullByEmptyString("phone");
        return true;
    }

    @Override
    public void saveThirdUser(SysUser sysUser) {
        String userid = UUIDGenerator.generate();
        sysUser.setId(userid);
        ((SysUserMapper)this.baseMapper).insert(sysUser);
        SysRole sysRole = (SysRole)this.sysRoleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysRole::getRoleCode, (Object)"third_role"));
        SysUserRole userRole = new SysUserRole();
        userRole.setRoleId(sysRole.getId());
        userRole.setUserId(userid);
        this.sysUserRoleMapper.insert(userRole);
    }

    @Override
    public List<SysUser> queryByDepIds(List<String> departIds, String username) {
        return this.userMapper.queryByDepIds(departIds, username);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveUser(SysUser user, String selectedRoles, String selectedDeparts, String relTenantIds) {
        String[] arr;
        this.save(user);
        this.saveUserTenant(user.getId(), relTenantIds);
        if (oConvertUtils.isNotEmpty((Object)selectedRoles)) {
            for (String roleId : arr = selectedRoles.split(",")) {
                SysUserRole userRole = new SysUserRole(user.getId(), roleId);
                this.sysUserRoleMapper.insert(userRole);
            }
        }
        if (oConvertUtils.isNotEmpty((Object)selectedDeparts)) {
            for (String deaprtId : arr = selectedDeparts.split(",")) {
                SysUserDepart userDeaprt = new SysUserDepart(user.getId(), deaprtId);
                this.sysUserDepartMapper.insert(userDeaprt);
            }
        }
        this.saveUserPosition(user.getId(), user.getPost());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public void editUser(SysUser user, String roles, String departs, String relTenantIds, String updateFromPage) {
        List userDepartList;
        String[] arr;
        this.editUserTenants(user.getId(), relTenantIds);
        this.updateById(user);
        if (oConvertUtils.isEmpty((Object)updateFromPage) || !"deptUsers".equalsIgnoreCase(updateFromPage)) {
            this.sysUserRoleMapper.delete((Wrapper)new QueryWrapper().lambda().eq(SysUserRole::getUserId, (Object)user.getId()));
            if (oConvertUtils.isNotEmpty((Object)roles)) {
                for (String roleId : arr = roles.split(",")) {
                    SysUserRole userRole = new SysUserRole(user.getId(), roleId);
                    this.sysUserRoleMapper.insert(userRole);
                }
            }
        }
        arr = new String[]{};
        if (oConvertUtils.isNotEmpty((Object)departs)) {
            arr = departs.split(",");
        }
        if ((userDepartList = this.sysUserDepartMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(SysUserDepart::getUserId, (Object)user.getId()))) != null && userDepartList.size() > 0) {
            for (SysUserDepart depart : userDepartList) {
                List sysDepartRoleList;
                List roleIds;
                if (Arrays.asList(arr).contains(depart.getDepId()) || (roleIds = (sysDepartRoleList = this.sysDepartRoleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(SysDepartRole::getDepartId, (Object)depart.getDepId()))).stream().map(SysDepartRole::getId).collect(Collectors.toList())) == null || roleIds.size() <= 0) continue;
                this.departRoleUserMapper.delete((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysDepartRoleUser::getUserId, (Object)user.getId())).in(SysDepartRoleUser::getDroleId, roleIds));
            }
        }
        this.sysUserDepartMapper.delete((Wrapper)new QueryWrapper().lambda().eq(SysUserDepart::getUserId, (Object)user.getId()));
        if (oConvertUtils.isNotEmpty((Object)departs)) {
            for (String departId : arr) {
                SysUserDepart userDepart = new SysUserDepart(user.getId(), departId);
                this.sysUserDepartMapper.insert(userDepart);
            }
        }
        this.userMapper.updateNullByEmptyString("email");
        this.userMapper.updateNullByEmptyString("phone");
        this.editUserPosition(user.getId(), user.getPost());
    }

    @Override
    public List<String> userIdToUsername(Collection<String> userIdList) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUser::getId, userIdList);
        List userList = super.list((Wrapper)queryWrapper);
        return userList.stream().map(SysUser::getUsername).collect(Collectors.toList());
    }

    @Override
    @Cacheable(cacheNames={"sys:cache:encrypt:user"}, key="#username")
    @SensitiveEncode
    public LoginUser getEncodeUserInfo(String username) {
        if (oConvertUtils.isEmpty((Object)username)) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        SysUser sysUser = this.userMapper.getUserByName(username);
        this.setUserTenantIds(sysUser);
        this.userPositionId(sysUser);
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)sysUser, (Object)loginUser);
        loginUser.setOrgId(this.getDepartIdByOrCode(sysUser.getOrgCode()));
        loginUser.setRoleCode(this.getJoinRoleCodeByUserId(sysUser.getId()));
        return loginUser;
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    @Transactional(rollbackFor={Exception.class})
    public void userQuit(String username) {
        SysUser sysUser = this.userMapper.getUserByName(username);
        if (null == sysUser) {
            throw new JeecgBootException("\u79bb\u804c\u5931\u8d25\uff0c\u8be5\u7528\u6237\u5df2\u4e0d\u5b58\u5728");
        }
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        if (tenantId == 0) {
            throw new JeecgBootException("\u79bb\u804c\u5931\u8d25\uff0c\u79df\u6237\u4e0d\u5b58\u5728");
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserTenant::getUserId, (Object)sysUser.getId());
        query.eq(SysUserTenant::getTenantId, (Object)tenantId);
        SysUserTenant userTenant = new SysUserTenant();
        userTenant.setStatus("2");
        this.userTenantMapper.update(userTenant, (Wrapper)query);
    }

    @Override
    public List<SysUser> getQuitList(Integer tenantId) {
        return this.userMapper.getTenantQuitList(tenantId);
    }

    @Override
    public void updateStatusAndFlag(List<String> userIds, SysUser sysUser) {
        this.userMapper.updateStatusAndFlag(userIds, sysUser);
    }

    @Override
    public Result<JSONObject> setLoginTenant(SysUser sysUser, JSONObject obj, String username, Result<JSONObject> result) {
        List<SysTenant> tenantList = this.relationMapper.getTenantNoCancel(sysUser.getId());
        obj.put("tenantList", tenantList);
        if (tenantList != null && tenantList.size() > 0) {
            if (tenantList.size() == 1) {
                sysUser.setLoginTenantId(tenantList.get(0).getId());
            } else {
                List listAfterFilter = tenantList.stream().filter(s -> s.getId().equals(sysUser.getLoginTenantId())).collect(Collectors.toList());
                if (listAfterFilter == null || listAfterFilter.size() == 0) {
                    sysUser.setLoginTenantId(tenantList.get(0).getId());
                }
            }
        } else {
            sysUser.setLoginTenantId(0);
        }
        this.updateUserDepart(username, null, sysUser.getLoginTenantId());
        log.info(" \u767b\u5f55\u63a5\u53e3\u7528\u6237\u7684\u79df\u6237ID = {}", (Object)sysUser.getLoginTenantId());
        if (sysUser.getLoginTenantId() != null) {
            TenantContext.setTenant((String)(sysUser.getLoginTenantId() + ""));
        }
        return null;
    }

    private void setUserTenantIds(SysUser sysUser) {
        if (ObjectUtils.isNotEmpty((Object)sysUser)) {
            List<Integer> list = this.relationMapper.getTenantIdsNoStatus(sysUser.getId());
            if (null != list && list.size() > 0) {
                sysUser.setRelTenantIds(StringUtils.join((Object[])list.toArray(), (String)","));
            } else {
                sysUser.setRelTenantIds("");
            }
        }
    }

    private void saveUserTenant(String userId, String relTenantIds) {
        Integer count;
        String tenantId;
        if (oConvertUtils.isNotEmpty((Object)relTenantIds)) {
            String[] tenantIds;
            for (String tenantId2 : tenantIds = relTenantIds.split(",")) {
                SysUserTenant relation = new SysUserTenant();
                relation.setUserId(userId);
                relation.setTenantId(Integer.valueOf(tenantId2));
                relation.setStatus("1");
                LambdaQueryWrapper sysUserTenantQueryWrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserTenant::getUserId, (Object)userId)).eq(SysUserTenant::getTenantId, (Object)Integer.valueOf(tenantId2));
                SysUserTenant tenantPresent = (SysUserTenant)this.relationMapper.selectOne((Wrapper)sysUserTenantQueryWrapper);
                if (tenantPresent != null) {
                    tenantPresent.setStatus("1");
                    this.relationMapper.updateById(tenantPresent);
                    continue;
                }
                this.relationMapper.insert(relation);
            }
        } else if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && oConvertUtils.isNotEmpty((Object)(tenantId = TenantContext.getTenant())) && (count = this.relationMapper.userTenantIzExist(userId, Integer.parseInt(tenantId))) == 0) {
            SysUserTenant relation = new SysUserTenant();
            relation.setUserId(userId);
            relation.setTenantId(Integer.parseInt(tenantId));
            relation.setStatus("1");
            this.relationMapper.insert(relation);
        }
    }

    private void editUserTenants(String userId, String relTenantIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserTenant::getUserId, (Object)userId);
        List<Integer> oldTenantIds = this.relationMapper.getTenantIdsByUserId(userId);
        if (oConvertUtils.isEmpty((Object)relTenantIds) && CollectionUtils.isNotEmpty(oldTenantIds)) {
            this.deleteTenantByUserId(userId, null);
        } else if (oConvertUtils.isNotEmpty((Object)relTenantIds) && CollectionUtils.isEmpty(oldTenantIds)) {
            this.saveUserTenant(userId, relTenantIds);
        } else if (oConvertUtils.isNotEmpty((Object)relTenantIds) && CollectionUtils.isNotEmpty(oldTenantIds)) {
            String[] relTenantIdArray = relTenantIds.split(",");
            List<String> relTenantIdList = Arrays.asList(relTenantIdArray);
            List deleteTenantIdList = oldTenantIds.stream().filter(item -> !relTenantIdList.contains(item.toString())).collect(Collectors.toList());
            for (Integer tenantId : deleteTenantIdList) {
                this.deleteTenantByUserId(userId, tenantId);
            }
            String tenantIds = relTenantIdList.stream().filter(item -> !oldTenantIds.contains(Integer.valueOf(item))).collect(Collectors.joining(","));
            this.saveUserTenant(userId, tenantIds);
        }
    }

    private void deleteTenantByUserId(String userId, Integer tenantId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserTenant::getUserId, (Object)userId);
        if (oConvertUtils.isNotEmpty((Object)tenantId)) {
            query.eq(SysUserTenant::getTenantId, (Object)tenantId);
        }
        this.relationMapper.delete((Wrapper)query);
    }

    @Override
    public void batchEditUsers(JSONObject json) {
        String userIds = json.getString("userIds");
        List idList = JSONArray.parseArray((String)userIds, String.class);
        String selecteddeparts = json.getString("selecteddeparts");
        String post = json.getString("post");
        String workAddress = json.getString("workAddress");
        if (oConvertUtils.isNotEmpty((Object)post)) {
            for (String userId : idList) {
                this.editUserPosition(userId, post);
            }
        }
        if (oConvertUtils.isNotEmpty((Object)selecteddeparts)) {
            String[] arr;
            Integer currentTenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
            LambdaQueryWrapper departQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysDepart::getTenantId, (Object)currentTenantId);
            List departList = this.sysDepartMapper.selectList((Wrapper)departQuery);
            if (departList == null || departList.size() == 0) {
                log.error("batchEditUsers \u6839\u636e\u79df\u6237ID\u6ca1\u6709\u627e\u5230\u90e8\u95e8>" + currentTenantId);
                return;
            }
            ArrayList<String> departIdList = new ArrayList<String>();
            for (SysDepart depart : departList) {
                String id;
                if (depart == null || !oConvertUtils.isNotEmpty((Object)(id = depart.getId()))) continue;
                departIdList.add(id);
            }
            LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().in(SysUserDepart::getUserId, (Collection)idList)).in(SysUserDepart::getDepId, departIdList);
            this.sysUserDepartMapper.delete((Wrapper)query);
            for (String deaprtId : arr = selecteddeparts.split(",")) {
                for (String userId : idList) {
                    SysUserDepart userDepart = new SysUserDepart(userId, deaprtId);
                    this.sysUserDepartMapper.insert(userDepart);
                }
            }
        }
    }

    @Override
    public DepartAndUserInfo searchByKeyword(String keyword) {
        DepartAndUserInfo departAndUserInfo = new DepartAndUserInfo();
        if (oConvertUtils.isNotEmpty((Object)keyword)) {
            List list2;
            List list1;
            LambdaQueryWrapper query1 = (LambdaQueryWrapper)new LambdaQueryWrapper().like(SysUser::getRealname, (Object)keyword);
            String str = oConvertUtils.getString((String)TenantContext.getTenant(), (String)"0");
            Integer tenantId = Integer.valueOf(str);
            if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                List<String> userIds = this.userTenantMapper.getUserIdsByTenantId(tenantId);
                if (oConvertUtils.listIsNotEmpty(userIds)) {
                    query1.in(SysUser::getId, userIds);
                } else {
                    query1.eq(SysUser::getId, (Object)"");
                }
            }
            if ((list1 = ((SysUserMapper)this.baseMapper).selectList((Wrapper)query1)) != null && list1.size() > 0) {
                List<UserAvatar> userList = list1.stream().map(v -> new UserAvatar((SysUser)v)).collect(Collectors.toList());
                departAndUserInfo.setUserList(userList);
            }
            LambdaQueryWrapper query2 = (LambdaQueryWrapper)new LambdaQueryWrapper().like(SysDepart::getDepartName, (Object)keyword);
            if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                query2.eq(SysDepart::getTenantId, (Object)tenantId);
            }
            if ((list2 = this.sysDepartMapper.selectList((Wrapper)query2)) != null && list2.size() > 0) {
                ArrayList<DepartInfo> departList = new ArrayList<DepartInfo>();
                for (SysDepart depart : list2) {
                    ArrayList<String> orgName = new ArrayList<String>();
                    ArrayList<String> orgId = new ArrayList<String>();
                    this.getParentDepart(depart, orgName, orgId);
                    DepartInfo departInfo = new DepartInfo();
                    departInfo.setId(depart.getId());
                    departInfo.setOrgId(orgId);
                    departInfo.setOrgName(orgName);
                    departList.add(departInfo);
                }
                departAndUserInfo.setDepartList(departList);
            }
        }
        return departAndUserInfo;
    }

    @Override
    public UpdateDepartInfo getUpdateDepartInfo(String departId) {
        SysDepart depart = (SysDepart)this.sysDepartMapper.selectById((Serializable)((Object)departId));
        if (depart != null) {
            LambdaQueryWrapper query;
            List userList;
            UpdateDepartInfo info = new UpdateDepartInfo(depart);
            List<SysDepart> subList = this.sysDepartMapper.queryDeptByPid(departId);
            if (subList != null && subList.size() > 0) {
                info.setHasSub(true);
            }
            if ((userList = ((SysUserMapper)this.baseMapper).selectList((Wrapper)(query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUser::getUserIdentity, (Object)2)).like(SysUser::getDepartIds, (Object)depart.getId())))) != null && userList.size() > 0) {
                List<String> idList = userList.stream().map(i -> i.getId()).collect(Collectors.toList());
                info.setChargePersonList(idList);
            }
            return info;
        }
        return null;
    }

    @Override
    public void doUpdateDepartInfo(UpdateDepartInfo info) {
        String departId = info.getDepartId();
        SysDepart depart = (SysDepart)this.sysDepartMapper.selectById((Serializable)((Object)departId));
        if (depart != null) {
            String pid;
            SysDepart parentDepart;
            if (!depart.getParentId().equals(info.getParentId()) && (parentDepart = (SysDepart)this.sysDepartMapper.selectById((Serializable)((Object)(pid = info.getParentId())))) != null) {
                String orgCode = this.getNextOrgCode(pid);
                depart.setOrgCode(orgCode);
                depart.setParentId(pid);
            }
            depart.setDepartName(info.getDepartName());
            this.sysDepartMapper.updateById(depart);
            List<SysUser> departChargeUsers = this.queryDepartChargePersons(departId);
            List<String> departChargeUserIdList = departChargeUsers.stream().map(i -> i.getId()).collect(Collectors.toList());
            List<String> userIdList = info.getChargePersonList();
            if (userIdList != null && userIdList.size() > 0) {
                for (String userId : userIdList) {
                    SysUser user = (SysUser)((SysUserMapper)this.baseMapper).selectById((Serializable)((Object)userId));
                    if (user == null) continue;
                    departChargeUserIdList.remove(user.getId());
                    user.setUserIdentity(2);
                    String departIds = user.getDepartIds();
                    if (oConvertUtils.isEmpty((Object)departIds)) {
                        user.setDepartIds(departId);
                    } else {
                        ArrayList<String> list = new ArrayList<String>(Arrays.asList(departIds.split(",")));
                        if (list.indexOf(departId) >= 0) continue;
                        list.add(departId);
                        String newDepartIds = String.join((CharSequence)",", list);
                        user.setDepartIds(newDepartIds);
                    }
                    ((SysUserMapper)this.baseMapper).updateById(user);
                }
                this.removeDepartmentManager(departChargeUserIdList, departChargeUsers, departId);
            } else if (CollectionUtil.isNotEmpty(departChargeUsers)) {
                this.removeDepartmentManager(departChargeUserIdList, departChargeUsers, departId);
            }
        }
    }

    private List<SysUser> queryDepartChargePersons(String departId) {
        ArrayList<SysUser> result = new ArrayList<SysUser>();
        LambdaQueryWrapper userQuery = new LambdaQueryWrapper();
        userQuery.like(SysUser::getDepartIds, (Object)departId);
        List userList = this.userMapper.selectList((Wrapper)userQuery);
        if (userList != null && userList.size() > 0) {
            for (SysUser user : userList) {
                Integer identity = user.getUserIdentity();
                String deps = user.getDepartIds();
                if (identity == null || identity != 2 || !oConvertUtils.isNotEmpty((Object)deps) || deps.indexOf(departId) < 0) continue;
                result.add(user);
            }
        }
        return result;
    }

    private String getNextOrgCode(String parentId) {
        JSONObject formData = new JSONObject();
        formData.put("parentId", (Object)parentId);
        String[] codeArray = (String[])FillRuleUtil.executeRule((String)"org_num_role", (JSONObject)formData);
        return codeArray[0];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void changeDepartChargePerson(JSONObject json) {
        String userId = json.getString("userId");
        String departId = json.getString("departId");
        boolean status = json.getBoolean("status");
        SysUser user = (SysUser)this.getById((Serializable)((Object)userId));
        if (user != null) {
            String ids = user.getDepartIds();
            if (status) {
                if (oConvertUtils.isEmpty((Object)ids)) {
                    user.setUserIdentity(CommonConstant.USER_IDENTITY_2);
                    user.setDepartIds(departId);
                } else {
                    ArrayList<String> list = new ArrayList<String>(Arrays.asList(ids.split(",")));
                    if (list.indexOf(departId) < 0) {
                        list.add(departId);
                        String string = String.join((CharSequence)",", list);
                        user.setUserIdentity(CommonConstant.USER_IDENTITY_2);
                        user.setDepartIds(string);
                    }
                }
            } else if (oConvertUtils.isNotEmpty((Object)ids)) {
                void var8_13;
                ArrayList<String> list = new ArrayList<String>();
                for (String temp : ids.split(",")) {
                    if (oConvertUtils.isEmpty((Object)temp) || temp.equals(departId)) continue;
                    list.add(temp);
                }
                String string = "";
                if (list.size() > 0) {
                    String string2 = String.join((CharSequence)",", list);
                } else {
                    user.setUserIdentity(CommonConstant.USER_IDENTITY_1);
                }
                user.setDepartIds((String)var8_13);
            }
            this.updateById(user);
        }
    }

    private void getParentDepart(SysDepart depart, List<String> orgName, List<String> orgId) {
        String pid = depart.getParentId();
        orgName.add(0, depart.getDepartName());
        orgId.add(0, depart.getId());
        if (oConvertUtils.isNotEmpty((Object)pid)) {
            SysDepart temp = (SysDepart)this.sysDepartMapper.selectById((Serializable)((Object)pid));
            this.getParentDepart(temp, orgName, orgId);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public void editTenantUser(SysUser sysUser, String tenantId, String departs, String roles) {
        SysUser user = new SysUser();
        user.setWorkNo(sysUser.getWorkNo());
        user.setId(sysUser.getId());
        this.updateById(user);
        if (oConvertUtils.isEmpty((Object)departs)) {
            this.sysUserDepartMapper.deleteUserDepart(user.getId(), tenantId);
        } else {
            this.updateTenantDepart(user, tenantId, departs);
        }
        this.editUserPosition(sysUser.getId(), sysUser.getPost());
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public void updateStatus(String id, String status) {
        this.userMapper.update(new SysUser().setStatus(Integer.parseInt(status)), (Wrapper)new UpdateWrapper().lambda().eq(SysUser::getId, (Object)id));
    }

    public void updateTenantDepart(SysUser user, String tenantId, String departs) {
        List<Object> departList = new ArrayList();
        long startTime = System.currentTimeMillis();
        if (oConvertUtils.isNotEmpty((Object)departs)) {
            departList = this.sysUserDepartMapper.getTenantDepart(Arrays.asList(departs.split(",")), tenantId);
        }
        long endTime = System.currentTimeMillis();
        System.out.println("\u67e5\u8be2\u7528\u6237\u90e8\u95e8\u7528\u65f6\uff1a" + (endTime - startTime) + "ms");
        List<SysUserDepart> userDepartList = this.sysUserDepartMapper.getTenantUserDepart(user.getId(), tenantId);
        if (userDepartList != null && userDepartList.size() > 0 && departList.size() > 0) {
            for (SysUserDepart depart : userDepartList) {
                Object sysDepartRoleList;
                List list;
                if (departList.contains(depart.getDepId()) || (list = (sysDepartRoleList = this.sysDepartRoleMapper.selectList((Wrapper)new QueryWrapper().lambda().eq(SysDepartRole::getDepartId, (Object)depart.getDepId()))).stream().map(SysDepartRole::getId).collect(Collectors.toList())).size() <= 0) continue;
                this.departRoleUserMapper.delete((Wrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(SysDepartRoleUser::getUserId, (Object)user.getId())).in(SysDepartRoleUser::getDroleId, list));
            }
        }
        long endTime1 = System.currentTimeMillis();
        System.out.println("\u4fee\u6539\u90e8\u95e8\u89d2\u8272\u7528\u65f6\uff1a" + (endTime1 - startTime) + "ms");
        if (departList.size() > 0) {
            this.sysUserDepartMapper.deleteUserDepart(user.getId(), tenantId);
            for (String string : departList) {
                SysUserDepart userDepart = new SysUserDepart(user.getId(), string);
                this.sysUserDepartMapper.insert(userDepart);
            }
        }
        long endTime2 = System.currentTimeMillis();
        System.out.println("\u4fee\u6539\u7528\u6237\u90e8\u95e8\u7528\u65f6\uff1a" + (endTime2 - startTime) + "ms");
    }

    private void saveUserPosition(String userId, String positionIds) {
        if (oConvertUtils.isNotEmpty((Object)positionIds)) {
            String[] positionIdArray;
            for (String postId : positionIdArray = positionIds.split(",")) {
                SysUserPosition userPosition = new SysUserPosition();
                userPosition.setUserId(userId);
                userPosition.setPositionId(postId);
                this.sysUserPositionMapper.insert(userPosition);
            }
        }
    }

    private void editUserPosition(String userId, String positionIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserPosition::getUserId, (Object)userId);
        this.sysUserPositionMapper.delete((Wrapper)query);
        this.saveUserPosition(userId, positionIds);
    }

    private void userPositionId(SysUser sysUser) {
        if (null != sysUser) {
            List<String> positionList = this.sysUserPositionMapper.getPositionIdByUserId(sysUser.getId());
            sysUser.setPost(CommonUtils.getSplitText(positionList, (String)","));
        }
    }

    @Nullable
    private String getDepartIdByOrCode(String orgCode) {
        if (oConvertUtils.isEmpty((Object)orgCode)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysDepart::getOrgCode, (Object)orgCode);
        queryWrapper.select((Object[])new SFunction[]{SysDepart::getId});
        SysDepart depart = (SysDepart)this.sysDepartMapper.selectOne((Wrapper)queryWrapper);
        if (depart == null || oConvertUtils.isEmpty((Object)depart.getId())) {
            return null;
        }
        return depart.getId();
    }

    @Nullable
    private String getJoinRoleCodeByUserId(String userId) {
        List<SysRole> roleList;
        if (oConvertUtils.isEmpty((Object)userId)) {
            return null;
        }
        Integer tenantId = null;
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)-1);
        }
        if (CollectionUtils.isEmpty(roleList = this.sysRoleMapper.getRoleCodeListByUserId(userId, tenantId))) {
            return null;
        }
        return roleList.stream().map(SysRole::getRoleCode).collect(Collectors.joining(","));
    }

    private void removeDepartmentManager(List<String> departChargeUserIdList, List<SysUser> departChargeUsers, String departId) {
        block0: for (String chargeUserId : departChargeUserIdList) {
            for (SysUser chargeUser : departChargeUsers) {
                if (!chargeUser.getId().equals(chargeUserId)) continue;
                String departIds = chargeUser.getDepartIds();
                ArrayList<String> list = new ArrayList<String>(Arrays.asList(departIds.split(",")));
                list.remove(departId);
                String newDepartIds = String.join((CharSequence)",", list);
                chargeUser.setDepartIds(newDepartIds);
                ((SysUserMapper)this.baseMapper).updateById(chargeUser);
                continue block0;
            }
        }
    }

    @Override
    public ModelAndView exportAppUser(HttpServletRequest request) {
        Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant());
        String departIds = request.getParameter("departIds");
        List<String> list = new ArrayList<String>();
        if (oConvertUtils.isNotEmpty((Object)departIds)) {
            list = Arrays.asList(departIds.split(","));
        }
        List<SysUser> userList = this.userMapper.getUserByDepartsTenantId(list, tenantId);
        List<SysUserDepVo> userDepVos = this.sysDepartMapper.getUserDepartByTenantUserId(userList, tenantId);
        List<SysUserPositionVo> positionVos = this.sysUserPositionMapper.getPositionIdByUsersTenantId(userList, tenantId);
        ArrayList<AppExportUserVo> exportUserVoList = new ArrayList<AppExportUserVo>();
        for (SysUser sysUser : userList) {
            AppExportUserVo exportUserVo = new AppExportUserVo();
            BeanUtils.copyProperties((Object)sysUser, (Object)exportUserVo);
            String departNames = userDepVos.stream().filter(item -> item.getUserId().equals(sysUser.getId())).map(SysUserDepVo::getDepartName).collect(Collectors.joining(";"));
            exportUserVo.setDepart(departNames);
            String posNames = positionVos.stream().filter(item -> item.getUserId().equals(sysUser.getId())).map(SysUserPositionVo::getName).collect(Collectors.joining(";"));
            exportUserVo.setPosition(posNames);
            exportUserVoList.add(exportUserVo);
        }
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        mv.addObject("fileName", (Object)"\u7528\u6237\u5217\u8868");
        mv.addObject("entity", AppExportUserVo.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        ExportParams exportParams = new ExportParams("\u5bfc\u5165\u89c4\u5219\uff1a\n1\u3001\u5b58\u5728\u7528\u6237\u7f16\u53f7\u65f6\uff0c\u6570\u636e\u4f1a\u6839\u636e\u7528\u6237\u7f16\u53f7\u8fdb\u884c\u5339\u914d\uff0c\u5339\u914d\u6210\u529f\u540e\u53ea\u4f1a\u66f4\u65b0\u804c\u4f4d\u548c\u5de5\u53f7;\n2\u3001\u4e0d\u5b58\u5728\u7528\u6237\u7f16\u53f7\u65f6\uff0c\u652f\u6301\u624b\u673a\u53f7\u3001\u90ae\u7bb1\u3001\u59d3\u540d\u3001\u90e8\u4eec\u3001\u804c\u4f4d\u3001\u5de5\u53f7\u5bfc\u5165,\u5176\u4e2d\u624b\u673a\u53f7\u5fc5\u586b;\n3\u3001\u4e0a\u4e0b\u7ea7\u90e8\u95e8\u7528\u82f1\u6587\u5b57\u7b26 / \u8fde\u63a5\uff0c\u5982 \u8d22\u52a1\u90e8/\u8d22\u52a1\u4e00\u90e8\uff0c\u591a\u4e2a\u90e8\u95e8\u6216\u8005\u804c\u4f4d\u7528\u82f1\u6587\u5b57\u7b26 ; \u8fdb\u884c\u8fde\u63a5,\u5982 \u8d22\u52a1\u90e8;\u7814\u53d1\u90e8", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f");
        mv.addObject("params", (Object)exportParams);
        mv.addObject("data", exportUserVoList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Result<?> importAppUser(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        Integer tenantId = oConvertUtils.getInt((String)TenantContext.getTenant());
        SysTenant sysTenant = (SysTenant)this.sysTenantMapper.selectById(tenantId);
        ArrayList<String> errorMessage = new ArrayList<String>();
        int successLines = 0;
        int errorLines = 0;
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            HashMap<String, String> positionMap = new HashMap<String, String>();
            HashMap<String, SysDepart> departMap = new HashMap<String, SysDepart>();
            try {
                List listSysUsers = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), AppExportUserVo.class, (ImportParams)params);
                for (int i = 0; i < listSysUsers.size(); ++i) {
                    int lineNumber = i + 1;
                    boolean isEdit = false;
                    AppExportUserVo sysUserExcel = (AppExportUserVo)listSysUsers.get(i);
                    String id = sysUserExcel.getId();
                    String workNo = sysUserExcel.getWorkNo();
                    String email = sysUserExcel.getEmail();
                    String phone = sysUserExcel.getPhone();
                    String realname = sysUserExcel.getRealname();
                    String depart = sysUserExcel.getDepart();
                    String position = sysUserExcel.getPosition();
                    SysUser sysUser = new SysUser();
                    if (oConvertUtils.isNotEmpty((Object)id)) {
                        SysUser user = (SysUser)this.userMapper.selectById((Serializable)((Object)id));
                        if (null == user) {
                            ++errorLines;
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u67e5\u770b\u7f16\u53f7\u662f\u5426\u5df2\u4fee\u6539\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                            continue;
                        }
                        isEdit = true;
                        sysUser.setId(id);
                    } else {
                        isEdit = false;
                    }
                    if (oConvertUtils.isNotEmpty((Object)workNo)) {
                        sysUser.setWorkNo(workNo);
                    }
                    try {
                        if (isEdit) {
                            this.userMapper.updateById(sysUser);
                        } else {
                            if (oConvertUtils.isEmpty((Object)phone)) {
                                errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u624b\u673a\u53f7\u4e3a\u7a7a\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                                ++errorLines;
                                continue;
                            }
                            SysUser userByPhone = this.userMapper.getUserByPhone(phone);
                            if (null != userByPhone) {
                                Integer tenantCount = this.userTenantMapper.userTenantIzExist(userByPhone.getId(), tenantId);
                                if (tenantCount > 0) {
                                    errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u6210\u5458\u5df2\u5b58\u5728\u8be5\u7ec4\u7ec7\u4e2d\uff0c\u5982\u679c\u5217\u8868\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u786e\u8ba4\u8be5\u6210\u5458\u662f\u5426\u5728\u5ba1\u6838\u4e2d\u6216\u8005\u5df2\u79bb\u804c\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                                    ++errorLines;
                                    continue;
                                }
                                sysUser.setId(userByPhone.getId());
                                this.userMapper.updateById(sysUser);
                                this.addUserTenant(sysUser.getId(), tenantId, userByPhone.getUsername(), sysTenant.getName());
                            } else {
                                String password = sysTenant.getHouseNumber() + phone;
                                String salt = oConvertUtils.randomGen((int)8);
                                sysUser.setSalt(salt);
                                String passwordEncode = PasswordUtil.encrypt((String)phone, (String)password, (String)salt);
                                sysUser.setPassword(passwordEncode);
                                sysUser.setUsername(phone);
                                sysUser.setRealname(oConvertUtils.getString((String)realname, (String)phone));
                                sysUser.setEmail(email);
                                sysUser.setPhone(phone);
                                sysUser.setStatus(CommonConstant.DEL_FLAG_1);
                                sysUser.setDelFlag(CommonConstant.DEL_FLAG_0);
                                sysUser.setCreateTime(new Date());
                                this.userMapper.insert(sysUser);
                                this.addUserTenant(sysUser.getId(), tenantId, sysUser.getUsername(), sysTenant.getName());
                            }
                        }
                        if (oConvertUtils.isNotEmpty((Object)position)) {
                            this.addOrEditPosition(sysUser.getId(), position, isEdit, tenantId, positionMap);
                        }
                        if (!isEdit) {
                            this.addOrEditDepart(sysUser.getId(), depart, tenantId, departMap);
                        }
                        ++successLines;
                        continue;
                    }
                    catch (Exception e) {
                        ++errorLines;
                        String message = e.getMessage().toLowerCase();
                        if (message.contains("uniq_sys_user_username")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u7528\u6237\u540d\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                            continue;
                        }
                        if (message.contains("uniq_sys_user_work_no")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u5de5\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                            continue;
                        }
                        if (message.contains("uniq_sys_user_phone")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u624b\u673a\u53f7\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                            continue;
                        }
                        if (message.contains("uniq_sys_user_email")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u7535\u5b50\u90ae\u4ef6\u5df2\u7ecf\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165\u3002");
                            continue;
                        }
                        if (message.contains("\u552f\u4e00\u6027\u7ea6\u675f")) {
                            errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u8fdd\u53cd\u8868\u552f\u4e00\u6027\u7ea6\u675f\u3002");
                            continue;
                        }
                        errorMessage.add("\u7b2c " + lineNumber + " \u884c\uff1a\u672a\u77e5\u9519\u8bef\uff0c\u5ffd\u7565\u5bfc\u5165");
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
            catch (Exception e) {
                errorMessage.add("\u53d1\u751f\u5f02\u5e38\uff1a" + e.getMessage());
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        }
        try {
            return ImportExcelUtil.imporReturnRes((int)errorLines, (int)successLines, errorMessage);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void addOrEditPosition(String userId, String position, Boolean isEdit, Integer tenantId, Map<String, String> positionMap) {
        Page page = new Page(1L, 1L);
        String[] positions = position.split(";");
        List<String> positionList = Arrays.asList(positions);
        positionList = positionList.stream().distinct().collect(Collectors.toList());
        this.sysUserPositionMapper.deleteUserPosByNameAndTenantId(positionList, tenantId, userId);
        for (String pos : positionList) {
            String posId = "";
            if (positionMap.containsKey(pos)) {
                posId = positionMap.get(pos);
            } else {
                List<String> namePage = this.sysPositionMapper.getPositionIdByName(pos, tenantId, (Page<SysPosition>)page);
                if (CollectionUtil.isNotEmpty(namePage)) {
                    posId = namePage.get(0);
                    positionMap.put(pos, posId);
                }
            }
            if (oConvertUtils.isNotEmpty((Object)posId)) {
                this.addSysUserPosition(userId, posId);
                continue;
            }
            if (isEdit.booleanValue()) continue;
            SysPosition sysPosition = new SysPosition();
            sysPosition.setName(pos);
            sysPosition.setCode(RandomUtil.randomString((int)10));
            sysPosition.setTenantId(tenantId);
            this.sysPositionMapper.insert(sysPosition);
            positionMap.put(pos, sysPosition.getId());
            this.addSysUserPosition(userId, sysPosition.getId());
        }
    }

    private void addSysUserPosition(String userId, String positionId) {
        Long count = this.sysUserPositionMapper.getUserPositionCount(userId, positionId);
        if (count == 0L) {
            SysUserPosition userPosition = new SysUserPosition();
            userPosition.setUserId(userId);
            userPosition.setPositionId(positionId);
            this.sysUserPositionMapper.insert(userPosition);
        }
    }

    private void addOrEditDepart(String userId, String depart, Integer tenantId, Map<String, SysDepart> departMap) {
        if (StringUtils.isNotEmpty((String)depart)) {
            Page page = new Page(1L, 1L);
            String[] departNames = depart.split(";");
            List<String> departNameList = Arrays.asList(departNames);
            departNameList = departNameList.stream().distinct().collect(Collectors.toList());
            String parentId = "";
            for (String departName : departNameList) {
                String[] names = departName.split("/");
                String nameStr = "";
                for (int i = 0; i < names.length; ++i) {
                    Long count;
                    String name = names[i];
                    nameStr = oConvertUtils.isNotEmpty((Object)nameStr) ? nameStr + "/" + name : name;
                    SysDepart sysDepart = null;
                    if (departMap.containsKey(nameStr)) {
                        sysDepart = departMap.get(nameStr);
                    } else {
                        List<SysDepart> departPageByName = this.sysDepartMapper.getDepartPageByName((Page<SysDepart>)page, name, tenantId, parentId);
                        if (CollectionUtil.isEmpty(departPageByName)) {
                            JSONObject formData = new JSONObject();
                            formData.put("parentId", (Object)parentId);
                            String[] codeArray = (String[])FillRuleUtil.executeRule((String)"org_num_role", (JSONObject)formData);
                            sysDepart = new SysDepart();
                            sysDepart.setParentId(parentId);
                            sysDepart.setOrgCode(codeArray[0]);
                            sysDepart.setOrgType(codeArray[1]);
                            sysDepart.setTenantId(tenantId);
                            sysDepart.setDepartName(name);
                            sysDepart.setIzLeaf(CommonConstant.IS_LEAF);
                            sysDepart.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
                            sysDepart.setStatus("1");
                            this.sysDepartMapper.insert(sysDepart);
                        } else {
                            sysDepart = departPageByName.get(0);
                        }
                        if (oConvertUtils.isNotEmpty((Object)parentId)) {
                            this.sysDepartMapper.setMainLeaf(parentId, CommonConstant.NOT_LEAF);
                        }
                        parentId = sysDepart.getId();
                        departMap.put(nameStr, sysDepart);
                    }
                    if (i != names.length - 1 || (count = this.sysUserDepartMapper.getCountByDepartIdAndUserId(userId, sysDepart.getId())) != 0L) continue;
                    SysUserDepart userDepart = new SysUserDepart(userId, sysDepart.getId());
                    this.sysUserDepartMapper.insert(userDepart);
                }
            }
        }
    }

    private void addUserTenant(String userId, Integer tenantId, String invitedUsername, String tenantName) {
        SysUserTenant userTenant = new SysUserTenant();
        userTenant.setTenantId(tenantId);
        userTenant.setUserId(userId);
        userTenant.setStatus("5");
        this.userTenantMapper.insert(userTenant);
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        MessageDTO messageDTO = new MessageDTO();
        String title = sysUser.getRealname() + " \u9080\u8bf7\u60a8\u52a0\u5165 " + tenantName + "\u3002";
        messageDTO.setTitle(title);
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("NOTICE_MSG_BUS_TYPE", SysAnnmentTypeEnum.TENANT_INVITE.getType());
        messageDTO.setData(data);
        messageDTO.setContent(title);
        messageDTO.setToUser(invitedUsername);
        messageDTO.setFromUser("system");
        this.systemSendMsgHandle.sendMessage(messageDTO);
    }

    @Override
    public void checkUserAdminRejectDel(String userIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(SysUser::getId, Arrays.asList(userIds.split(",")));
        query.eq(SysUser::getUsername, (Object)"admin");
        Long adminRoleCount = ((SysUserMapper)this.baseMapper).selectCount((Wrapper)query);
        if (adminRoleCount > 0L) {
            throw new JeecgBootException("admin\u7528\u6237\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
    }

    @Override
    public void changePhone(JSONObject json, String username) {
        String smscode = json.getString("smscode");
        String phone = json.getString("phone");
        String type = json.getString("type");
        if (oConvertUtils.isEmpty((Object)phone)) {
            throw new JeecgBootException("\u8bf7\u586b\u5199\u539f\u624b\u673a\u53f7\uff01");
        }
        if (oConvertUtils.isEmpty((Object)smscode)) {
            throw new JeecgBootException("\u8bf7\u586b\u5199\u9a8c\u8bc1\u7801\uff01");
        }
        SysUser sysUser = this.userMapper.getUserByNameAndPhone(phone, username);
        if (null == sysUser) {
            throw new JeecgBootException("\u539f\u624b\u673a\u53f7\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u4fee\u6539\u5bc6\u7801\uff01");
        }
        if ("verifyOriginalPhone".equals(type)) {
            this.verifyPhone(phone, smscode);
        } else if ("updatePhone".equals(type)) {
            String newPhone = json.getString("newPhone");
            if (newPhone.equals(phone)) {
                throw new JeecgBootException("\u65b0\u624b\u673a\u53f7\u4e0e\u539f\u624b\u673a\u53f7\u4e00\u81f4\uff0c\u65e0\u6cd5\u4fee\u6539\uff01");
            }
            this.verifyPhone(newPhone, smscode);
            sysUser.setPhone(newPhone);
            this.userMapper.updateById(sysUser);
        }
    }

    public void verifyPhone(String phone, String smsCode) {
        String phoneKey = "sys:cache:phone:change_phone_msg:" + phone;
        Object phoneCode = this.redisUtil.get(phoneKey);
        if (null == phoneCode) {
            throw new JeecgBootException("\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u8bf7\u91cd\u65b0\u53d1\u9001\u9a8c\u8bc1\u7801\uff01");
        }
        if (!smsCode.equals(phoneCode.toString())) {
            throw new JeecgBootException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u4e0d\u5339\u914d\uff01");
        }
        this.redisUtil.removeAll(phoneKey);
    }

    @Override
    public void sendChangePhoneSms(JSONObject jsonObject, String username, String ipAddress) {
        SysUser userByPhone;
        String type = jsonObject.getString("type");
        String phone = jsonObject.getString("phone");
        if (oConvertUtils.isEmpty((Object)phone)) {
            throw new JeecgBootException("\u8bf7\u586b\u5199\u624b\u673a\u53f7\uff01");
        }
        if ("verifyOriginalPhone".equals(type)) {
            SysUser sysUser = this.userMapper.getUserByNameAndPhone(phone, username);
            if (null == sysUser) {
                throw new JeecgBootException("\u65e7\u624b\u673a\u53f7\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u4fee\u6539\u624b\u673a\u53f7\uff01");
            }
        } else if ("updatePhone".equals(type) && null != (userByPhone = this.userMapper.getUserByPhone(phone))) {
            throw new JeecgBootException("\u624b\u673a\u53f7\u5df2\u88ab\u6ce8\u518c\uff0c\u8bf7\u5c1d\u8bd5\u5176\u4ed6\u624b\u673a\u53f7\uff01");
        }
        String redisKey = "sys:cache:phone:change_phone_msg:" + phone;
        this.sendPhoneSms(phone, ipAddress, redisKey);
    }

    @Override
    public void sendLogOffPhoneSms(JSONObject jsonObject, String username, String ipAddress) {
        String phone = jsonObject.getString("phone");
        SysUser userByNameAndPhone = this.userMapper.getUserByNameAndPhone(phone, username);
        if (null == userByNameAndPhone) {
            throw new JeecgBootException("\u5f53\u524d\u7528\u6237\u624b\u673a\u53f7\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u4fee\u6539\uff01");
        }
        String code = "sys:cache:phone:qqy_log_off_user_msg:" + phone;
        this.sendPhoneSms(phone, ipAddress, code);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void userLogOff(JSONObject jsonObject, String username) {
        String phone = jsonObject.getString("phone");
        String smsCode = jsonObject.getString("smscode");
        SysUser userByNameAndPhone = this.userMapper.getUserByNameAndPhone(phone, username);
        if (null == userByNameAndPhone) {
            throw new JeecgBootException("\u5f53\u524d\u7528\u6237\u624b\u673a\u53f7\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u6ce8\u9500\uff01");
        }
        String code = "sys:cache:phone:qqy_log_off_user_msg:" + phone;
        Object redisSmdCode = this.redisUtil.get(code);
        if (null == redisSmdCode) {
            throw new JeecgBootException("\u9a8c\u8bc1\u7801\u5931\u6548\uff0c\u65e0\u6cd5\u6ce8\u9500\uff01");
        }
        if (!redisSmdCode.toString().equals(smsCode)) {
            throw new JeecgBootException("\u9a8c\u8bc1\u7801\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u6ce8\u9500\uff01");
        }
        this.deleteUser(userByNameAndPhone.getId());
        this.redisUtil.removeAll(code);
        this.redisUtil.removeAll("sys:cache:encrypt:user" + phone);
    }

    private void sendPhoneSms(String phone, String clientIp, String redisKey) {
        Object object = this.redisUtil.get(redisKey);
        if (object != null) {
            throw new JeecgBootException("\u9a8c\u8bc1\u780110\u5206\u949f\u5185\uff0c\u4ecd\u7136\u6709\u6548\uff01");
        }
        if (!DySmsLimit.canSendSms((String)clientIp)) {
            log.warn("--------[\u8b66\u544a] IP\u5730\u5740:{}, \u77ed\u4fe1\u63a5\u53e3\u8bf7\u6c42\u592a\u591a-------", (Object)clientIp);
            throw new JeecgBootException("\u77ed\u4fe1\u63a5\u53e3\u8bf7\u6c42\u592a\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01", CommonConstant.PHONE_SMS_FAIL_CODE.intValue());
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)captcha);
        try {
            boolean sendSmsSuccess = DySmsHelper.sendSms((String)phone, (JSONObject)obj, (DySmsEnum)DySmsEnum.LOGIN_TEMPLATE_CODE);
            if (!sendSmsSuccess) {
                throw new JeecgBootException("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5\uff01");
            }
            this.redisUtil.set(redisKey, (Object)captcha, 600L);
        }
        catch (ClientException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JeecgBootException("\u77ed\u4fe1\u63a5\u53e3\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
        }
    }
}

