/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.jeecg.dingtalk.api.base.JdtBaseAPI;
import com.jeecg.dingtalk.api.core.response.Response;
import com.jeecg.dingtalk.api.core.vo.AccessToken;
import com.jeecg.dingtalk.api.user.JdtUserAPI;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.UUIDGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.entity.SysThirdAccount;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserRole;
import org.jeecg.modules.system.mapper.SysRoleMapper;
import org.jeecg.modules.system.mapper.SysThirdAccountMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserRoleMapper;
import org.jeecg.modules.system.model.ThirdLoginModel;
import org.jeecg.modules.system.service.ISysThirdAccountService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class SysThirdAccountServiceImpl
extends ServiceImpl<SysThirdAccountMapper, SysThirdAccount>
implements ISysThirdAccountService {
    private static final Logger log = LoggerFactory.getLogger(SysThirdAccountServiceImpl.class);
    @Autowired
    private SysThirdAccountMapper sysThirdAccountMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysRoleMapper sysRoleMapper;
    @Autowired
    private SysUserRoleMapper sysUserRoleMapper;
    @Value(value="${justauth.type.DINGTALK.client-id:}")
    private String dingTalkClientId;
    @Value(value="${justauth.type.DINGTALK.client-secret:}")
    private String dingTalkClientSecret;

    @Override
    public void updateThirdUserId(SysUser sysUser, String thirdUserUuid) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysThirdAccount::getThirdUserUuid, (Object)thirdUserUuid);
        query.eq(SysThirdAccount::getTenantId, (Object)CommonConstant.TENANT_ID_DEFAULT_VALUE);
        SysThirdAccount account = (SysThirdAccount)this.sysThirdAccountMapper.selectOne((Wrapper)query);
        SysThirdAccount sysThirdAccount = new SysThirdAccount();
        sysThirdAccount.setSysUserId(sysUser.getId());
        LambdaQueryWrapper thirdQuery = new LambdaQueryWrapper();
        thirdQuery.eq(SysThirdAccount::getSysUserId, (Object)sysUser.getId());
        thirdQuery.eq(SysThirdAccount::getThirdType, (Object)account.getThirdType());
        thirdQuery.eq(SysThirdAccount::getThirdUserUuid, (Object)thirdUserUuid);
        thirdQuery.eq(SysThirdAccount::getTenantId, (Object)CommonConstant.TENANT_ID_DEFAULT_VALUE);
        SysThirdAccount sysThirdAccounts = (SysThirdAccount)this.sysThirdAccountMapper.selectOne((Wrapper)thirdQuery);
        if (sysThirdAccounts != null) {
            sysThirdAccount.setThirdUserId(sysThirdAccounts.getThirdUserId());
            this.sysThirdAccountMapper.deleteById((Serializable)((Object)sysThirdAccounts.getId()));
        }
        this.sysThirdAccountMapper.update(sysThirdAccount, (Wrapper)query);
    }

    @Override
    public SysUser createUser(String phone, String thirdUserUuid, Integer tenantId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysThirdAccount::getThirdUserUuid, (Object)thirdUserUuid);
        query.eq(SysThirdAccount::getTenantId, (Object)tenantId);
        SysThirdAccount account = (SysThirdAccount)this.sysThirdAccountMapper.selectOne((Wrapper)query);
        SysUser userByName = this.sysUserMapper.getUserByName(thirdUserUuid);
        if (null != userByName) {
            String format = ((SimpleDateFormat)DateUtils.yyyymmddhhmmss.get()).format(new Date());
            thirdUserUuid = thirdUserUuid + format;
        }
        SysUser user = new SysUser();
        user.setActivitiSync(CommonConstant.ACT_SYNC_1);
        user.setDelFlag(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setUsername(thirdUserUuid);
        user.setPhone(phone);
        String salt = oConvertUtils.randomGen((int)8);
        user.setSalt(salt);
        String passwordEncode = PasswordUtil.encrypt((String)user.getUsername(), (String)"123456", (String)salt);
        user.setPassword(passwordEncode);
        user.setRealname(account.getRealname());
        user.setAvatar(account.getAvatar());
        String s = this.saveThirdUser(user);
        SysThirdAccount sysThirdAccount = new SysThirdAccount();
        sysThirdAccount.setSysUserId(s);
        sysThirdAccount.setTenantId(tenantId);
        this.sysThirdAccountMapper.update(sysThirdAccount, (Wrapper)query);
        return user;
    }

    public String saveThirdUser(SysUser sysUser) {
        String userid = UUIDGenerator.generate();
        sysUser.setId(userid);
        this.sysUserMapper.insert(sysUser);
        SysRole sysRole = (SysRole)this.sysRoleMapper.selectOne((Wrapper)new LambdaQueryWrapper().eq(SysRole::getRoleCode, (Object)"third_role"));
        SysUserRole userRole = new SysUserRole();
        userRole.setRoleId(sysRole.getId());
        userRole.setUserId(userid);
        this.sysUserRoleMapper.insert(userRole);
        return userid;
    }

    @Override
    public SysThirdAccount getOneBySysUserId(String sysUserId, String thirdType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        log.info("getSysUserId: {} ,getThirdType: {}", (Object)sysUserId, (Object)thirdType);
        queryWrapper.eq(SysThirdAccount::getSysUserId, (Object)sysUserId);
        queryWrapper.eq(SysThirdAccount::getThirdType, (Object)thirdType);
        return (SysThirdAccount)super.getOne((Wrapper)queryWrapper);
    }

    @Override
    public SysThirdAccount getOneByThirdUserId(String thirdUserId, String thirdType) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThirdAccount::getThirdUserId, (Object)thirdUserId);
        queryWrapper.eq(SysThirdAccount::getThirdType, (Object)thirdType);
        return (SysThirdAccount)super.getOne((Wrapper)queryWrapper);
    }

    @Override
    public List<SysThirdAccount> listThirdUserIdByUsername(String[] sysUsernameArr, String thirdType, Integer tenantId) {
        return this.sysThirdAccountMapper.selectThirdIdsByUsername(sysUsernameArr, thirdType, tenantId);
    }

    @Override
    public SysThirdAccount saveThirdUser(ThirdLoginModel tlm, Integer tenantId) {
        SysThirdAccount user = new SysThirdAccount();
        user.setDelFlag(CommonConstant.DEL_FLAG_0);
        user.setStatus(1);
        user.setThirdType(tlm.getSource());
        user.setAvatar(tlm.getAvatar());
        user.setRealname(tlm.getUsername());
        user.setThirdUserUuid(tlm.getUuid());
        user.setTenantId(tenantId);
        if ("DINGTALK".toLowerCase().equals(tlm.getSource())) {
            AccessToken accessToken = JdtBaseAPI.getAccessToken((String)this.dingTalkClientId, (String)this.dingTalkClientSecret);
            Response getUserIdRes = JdtUserAPI.getUseridByUnionid((String)tlm.getUuid(), (String)accessToken.getAccessToken());
            if (getUserIdRes.isSuccess()) {
                user.setThirdUserId((String)getUserIdRes.getResult());
            } else {
                user.setThirdUserId(tlm.getUuid());
            }
        } else {
            user.setThirdUserId(tlm.getUuid());
        }
        super.save((Object)user);
        return user;
    }

    @Override
    public SysThirdAccount bindThirdAppAccountByUserId(SysThirdAccount sysThirdAccount) {
        String thirdUserUuid = sysThirdAccount.getThirdUserUuid();
        String thirdType = sysThirdAccount.getThirdType();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        SysThirdAccount oneByThirdUserId = this.getOneByUuidAndThirdType(thirdUserUuid, thirdType, CommonConstant.TENANT_ID_DEFAULT_VALUE, null);
        if (null != oneByThirdUserId) {
            if (oConvertUtils.isNotEmpty((Object)oneByThirdUserId.getSysUserId()) && oneByThirdUserId.getSysUserId().equals(sysUser.getId())) {
                return oneByThirdUserId;
            }
            if (oConvertUtils.isNotEmpty((Object)oneByThirdUserId.getSysUserId())) {
                throw new JeecgBootException("\u8be5\u6572\u6572\u4e91\u8d26\u53f7\u5df2\u88ab\u5176\u5b83\u7b2c\u4e09\u65b9\u8d26\u53f7\u7ed1\u5b9a,\u8bf7\u89e3\u7ed1\u6216\u7ed1\u5b9a\u5176\u5b83\u6572\u6572\u4e91\u8d26\u53f7");
            }
            oneByThirdUserId.setSysUserId(sysUser.getId());
            oneByThirdUserId.setThirdType(thirdType);
            this.sysThirdAccountMapper.updateById(oneByThirdUserId);
            return oneByThirdUserId;
        }
        throw new JeecgBootException("\u8d26\u53f7\u7ed1\u5b9a\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
    }

    @Override
    public SysThirdAccount getOneByUuidAndThirdType(String unionid, String thirdType, Integer tenantId, String thirdUserId) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysThirdAccount::getThirdType, (Object)thirdType);
        if (oConvertUtils.isNotEmpty((Object)thirdUserId)) {
            queryWrapper.and(wrapper -> ((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(SysThirdAccount::getThirdUserUuid, (Object)unionid)).or()).eq(SysThirdAccount::getThirdUserId, (Object)thirdUserId));
        } else {
            queryWrapper.eq(SysThirdAccount::getThirdUserUuid, (Object)unionid);
        }
        queryWrapper.eq(SysThirdAccount::getTenantId, (Object)tenantId);
        return (SysThirdAccount)super.getOne((Wrapper)queryWrapper);
    }
}

