/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import cn.hutool.core.util.RandomUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.message.BusMessageDTO;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.SysAnnmentTypeEnum;
import org.jeecg.common.exception.JeecgBootBizTipException;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DateUtils;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.aop.TenantLog;
import org.jeecg.modules.system.entity.SysTenant;
import org.jeecg.modules.system.entity.SysTenantPack;
import org.jeecg.modules.system.entity.SysTenantPackUser;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.entity.SysUserTenant;
import org.jeecg.modules.system.mapper.SysPackPermissionMapper;
import org.jeecg.modules.system.mapper.SysTenantMapper;
import org.jeecg.modules.system.mapper.SysTenantPackMapper;
import org.jeecg.modules.system.mapper.SysTenantPackUserMapper;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.mapper.SysUserTenantMapper;
import org.jeecg.modules.system.service.ISysTenantPackService;
import org.jeecg.modules.system.service.ISysTenantService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.vo.tenant.TenantDepartAuthInfo;
import org.jeecg.modules.system.vo.tenant.TenantPackModel;
import org.jeecg.modules.system.vo.tenant.TenantPackUser;
import org.jeecg.modules.system.vo.tenant.TenantPackUserCount;
import org.jeecg.modules.system.vo.tenant.UserDepart;
import org.jeecg.modules.system.vo.tenant.UserPosition;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.stereotype.Service;

@Service(value="sysTenantServiceImpl")
public class SysTenantServiceImpl
extends ServiceImpl<SysTenantMapper, SysTenant>
implements ISysTenantService {
    private static final Logger log = LoggerFactory.getLogger(SysTenantServiceImpl.class);
    @Autowired
    ISysUserService userService;
    @Autowired
    private SysUserTenantMapper userTenantMapper;
    @Autowired
    private SysTenantMapper tenantMapper;
    @Autowired
    private ISysTenantPackService sysTenantPackService;
    @Autowired
    private SysTenantPackUserMapper sysTenantPackUserMapper;
    @Autowired
    private ISysBaseAPI sysBaseApi;
    @Autowired
    private SysUserDepartMapper sysUserDepartMapper;
    @Autowired
    private SysTenantPackMapper sysTenantPackMapper;
    @Autowired
    private SysPackPermissionMapper sysPackPermissionMapper;

    @Override
    public List<SysTenant> queryEffectiveTenant(Collection<Integer> idList) {
        if (oConvertUtils.listIsEmpty(idList)) {
            return null;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysTenant::getId, idList);
        queryWrapper.eq(SysTenant::getStatus, (Object)Integer.valueOf("1"));
        return super.list((Wrapper)queryWrapper);
    }

    @Override
    public Long countUserLinkTenant(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserTenant::getTenantId, (Object)id);
        query.eq(SysUserTenant::getStatus, (Object)"1");
        return this.userTenantMapper.selectCount((Wrapper)query);
    }

    @Override
    public boolean removeTenantById(String id) {
        return super.removeById((Serializable)Integer.valueOf(Integer.parseInt(id)));
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public void invitationUserJoin(String ids, String phone) {
        String[] idArray = ids.split(",");
        SysUser userByPhone = this.userService.getUserByPhone(phone);
        if (null == userByPhone) {
            throw new JeecgBootException("\u5f53\u524d\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5bf9\u624b\u673a\u53f7");
        }
        String userId = userByPhone.getId();
        for (String id : idArray) {
            SysUserTenant userTenant = this.userTenantMapper.getUserTenantByTenantId(userId, Integer.valueOf(id));
            if (null != userTenant) {
                String tenantErrorInfo = this.getTenantErrorInfo(userTenant.getStatus());
                String errMsg = "\u624b\u673a\u53f7\u7528\u6237:" + userByPhone.getPhone() + " \u6635\u79f0\uff1a" + userByPhone.getRealname() + "\uff0c" + tenantErrorInfo;
                throw new JeecgBootException(errMsg);
            }
            SysUserTenant relation = new SysUserTenant();
            relation.setUserId(userId);
            relation.setTenantId(Integer.valueOf(id));
            relation.setStatus("1");
            this.userTenantMapper.insert(relation);
        }
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public void leaveTenant(String userIds, String tenantId) {
        String[] userIdArray;
        for (String userId : userIdArray = userIds.split(",")) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.eq(SysUserTenant::getTenantId, (Object)tenantId);
            query.eq(SysUserTenant::getUserId, (Object)userId);
            this.userTenantMapper.delete((Wrapper)query);
        }
        this.sysTenantPackUserMapper.deletePackUserByTenantId(Integer.valueOf(tenantId), Arrays.asList(userIds.split(",")));
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public Integer saveTenantJoinUser(SysTenant sysTenant, String userId) {
        this.saveTenant(sysTenant);
        Integer tenantId = sysTenant.getId();
        this.sysTenantPackService.addDefaultTenantPack(tenantId);
        return tenantId;
    }

    @Override
    public void saveTenant(SysTenant sysTenant) {
        sysTenant.setId(this.tenantIdGenerate());
        sysTenant.setHouseNumber(RandomUtil.randomStringUpper((int)6));
        sysTenant.setDelFlag(CommonConstant.DEL_FLAG_0);
        this.save(sysTenant);
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.saveTenantRelation(sysTenant.getId(), loginUser.getId());
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public Integer joinTenantByHouseNumber(SysTenant sysTenant, String userId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysTenant::getHouseNumber, (Object)sysTenant.getHouseNumber());
        SysTenant one = (SysTenant)this.getOne((Wrapper)query);
        if (null == one) {
            return 0;
        }
        LambdaQueryWrapper relationQuery = new LambdaQueryWrapper();
        relationQuery.eq(SysUserTenant::getTenantId, (Object)one.getId());
        relationQuery.eq(SysUserTenant::getUserId, (Object)userId);
        SysUserTenant relation = (SysUserTenant)this.userTenantMapper.selectOne((Wrapper)relationQuery);
        if (relation != null) {
            String msg = "";
            if ("3".equals(relation.getStatus())) {
                msg = ",\u72b6\u6001:\u5ba1\u6838\u4e2d";
            } else {
                if ("4".equals(relation.getStatus())) {
                    throw new JeecgBootBizTipException("\u7ba1\u7406\u5458\u5df2\u62d2\u7edd\u60a8\u52a0\u5165\u79df\u6237,\u8bf7\u8054\u7cfb\u79df\u6237\u7ba1\u7406\u5458");
                }
                if ("2".equals(relation.getStatus())) {
                    msg = ",\u72b6\u6001:\u5df2\u79bb\u804c";
                }
            }
            throw new JeecgBootBizTipException("\u60a8\u5df2\u662f\u8be5\u79df\u6237\u6210\u5458" + msg);
        }
        SysUserTenant tenant = new SysUserTenant();
        tenant.setTenantId(one.getId());
        tenant.setUserId(userId);
        tenant.setStatus("3");
        this.userTenantMapper.insert(tenant);
        this.sendMsgForApplyJoinTenant(userId, one);
        return tenant.getTenantId();
    }

    @Override
    public Integer countCreateTenantNum(String userId) {
        return this.userTenantMapper.countCreateTenantNum(userId);
    }

    @Override
    public IPage<SysTenant> getRecycleBinPageList(Page<SysTenant> page, SysTenant sysTenant) {
        return page.setRecords(this.tenantMapper.getRecycleBinPageList(page, sysTenant));
    }

    @Override
    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public void deleteTenantLogic(String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String id : idArray) {
            list.add(Integer.valueOf(id));
        }
        this.tenantMapper.deleteByTenantId(list);
        this.userTenantMapper.deleteUserByTenantId(list);
        this.deleteTenantPackByTenantId(list);
    }

    @Override
    public void revertTenantLogic(String ids) {
        String[] idArray = ids.split(",");
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (String id : idArray) {
            list.add(Integer.valueOf(id));
        }
        this.tenantMapper.revertTenantLogic(list);
    }

    @CacheEvict(value={"sys:cache:encrypt:user"}, allEntries=true)
    public Integer saveTenantRelation(Integer tenantId, String userId) {
        SysUserTenant relation = new SysUserTenant();
        relation.setTenantId(tenantId);
        relation.setUserId(userId);
        relation.setStatus("1");
        this.userTenantMapper.insert(relation);
        return relation.getTenantId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int tenantIdGenerate() {
        SysTenantServiceImpl sysTenantServiceImpl = this;
        synchronized (sysTenantServiceImpl) {
            int maxTenantId = oConvertUtils.getInt((Object)this.tenantMapper.getMaxTenantId(), (int)0);
            if (maxTenantId >= 1000) {
                return maxTenantId + 1;
            }
            return 1000;
        }
    }

    @Override
    public void exitUserTenant(String userId, String username, String tenantId) {
        int tId = Integer.parseInt(tenantId);
        List<String> userIdsByTenantId = this.userTenantMapper.getUserIdsByTenantId(tId);
        SysTenant sysTenant = (SysTenant)this.tenantMapper.selectById(Integer.valueOf(tId));
        if (username.equals(sysTenant.getCreateBy())) {
            if (null != userIdsByTenantId && userIdsByTenantId.size() > 1) {
                throw new JeecgBootException("assignedOwen");
            }
            if (null != userIdsByTenantId && userIdsByTenantId.size() == 1) {
                throw new JeecgBootException("cancelTenant");
            }
            throw new JeecgBootException("\u9000\u51fa\u79df\u6237\u5931\u8d25\uff0c\u79df\u6237\u4fe1\u606f\u5df2\u4e0d\u5b58\u5728");
        }
        this.leaveTenant(userId, tenantId);
        this.leveUserProcess(userId, tenantId);
    }

    @Override
    public void changeOwenUserTenant(String userId, String tId) {
        int tenantId = oConvertUtils.getInt((String)tId, (int)0);
        SysTenant sysTenant = (SysTenant)this.tenantMapper.selectById(Integer.valueOf(tenantId));
        if (null == sysTenant) {
            throw new JeecgBootException("\u9000\u51fa\u79df\u6237\u5931\u8d25\uff0c\u4e0d\u5b58\u5728\u6b64\u79df\u6237");
        }
        String createBy = sysTenant.getCreateBy();
        Integer count = this.userTenantMapper.userTenantIzExist(userId, tenantId);
        if (count == 0) {
            throw new JeecgBootException("\u9000\u51fa\u79df\u6237\u5931\u8d25\uff0c\u6b64\u79df\u6237\u4e0b\u6ca1\u6709\u8be5\u7528\u6237");
        }
        SysUser user = (SysUser)this.userService.getById((Serializable)((Object)userId));
        SysTenant tenant = new SysTenant();
        tenant.setCreateBy(user.getUsername());
        tenant.setId(tenantId);
        this.tenantMapper.updateById(tenant);
        SysUser userByName = this.userService.getUserByName(createBy);
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysUserTenant::getUserId, (Object)userByName.getId());
        query.eq(SysUserTenant::getTenantId, (Object)tenantId);
        SysUserTenant userTenant = new SysUserTenant();
        userTenant.setStatus("2");
        this.userTenantMapper.update(userTenant, (Wrapper)query);
        this.leveUserProcess(userId, String.valueOf(tenantId));
    }

    private void leveUserProcess(String userId, String tenantId) {
        LoginUser userInfo = new LoginUser();
        SysUser user = (SysUser)this.userService.getById((Serializable)((Object)userId));
    }

    @Override
    public Result<String> invitationUser(String phone, String departId) {
        Result result = new Result();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        SysUser userByPhone = this.userService.getUserByPhone(phone);
        if (null == userByPhone) {
            result.setSuccess(false);
            result.setMessage("\u7528\u6237\u4e0d\u5b58\u5728");
            return result;
        }
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        Integer userCount = this.userTenantMapper.userTenantIzExist(sysUser.getId(), tenantId);
        if (userCount == 0) {
            result.setSuccess(false);
            result.setMessage("\u5f53\u524d\u7ba1\u7406\u5458\u6ca1\u6709\u9080\u8bf7\u6743\u9650");
            return result;
        }
        SysUserTenant sysUserTenant = this.userTenantMapper.getUserTenantByTenantId(userByPhone.getId(), tenantId);
        if (null != sysUserTenant) {
            result.setSuccess(false);
            String tenantErrorInfo = this.getTenantErrorInfo(sysUserTenant.getStatus());
            String msg = "\u624b\u673a\u53f7\u7528\u6237:" + userByPhone.getPhone() + " \u6635\u79f0\uff1a" + userByPhone.getRealname() + "\uff0c" + tenantErrorInfo;
            result.setMessage(msg);
            return result;
        }
        String status = "5";
        SysUserTenant tenant = new SysUserTenant();
        tenant.setTenantId(tenantId);
        tenant.setUserId(userByPhone.getId());
        tenant.setStatus(status);
        this.userTenantMapper.insert(tenant);
        result.setSuccess(true);
        result.setMessage("\u9080\u8bf7\u6210\u5458\u6210\u529f\uff0c\u6210\u5458\u540c\u610f\u540e\u65b9\u53ef\u52a0\u5165");
        if (oConvertUtils.isNotEmpty((Object)departId)) {
            this.saveUserDepart(userByPhone.getId(), departId);
        }
        this.sendMsgForInvitation(userByPhone, tenantId, sysUser.getRealname());
        return result;
    }

    @Override
    public TenantDepartAuthInfo getTenantDepartAuthInfo(Integer tenantId) {
        SysTenant sysTenant = (SysTenant)this.getById(tenantId);
        if (sysTenant == null) {
            return null;
        }
        TenantDepartAuthInfo info = new TenantDepartAuthInfo();
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        boolean superAdmin = false;
        List<String> packCodeList = ((SysTenantMapper)this.baseMapper).queryUserPackCode(tenantId, userId);
        if (packCodeList == null || packCodeList.size() == 0) {
            if (sysTenant.getCreateBy().equals(sysUser.getUsername())) {
                this.sysTenantPackService.addDefaultTenantPack(tenantId);
                superAdmin = true;
            } else {
                superAdmin = false;
            }
        }
        if (!superAdmin) {
            List<TenantPackUserCount> packCountList = ((SysTenantMapper)this.baseMapper).queryTenantPackUserCount(tenantId);
            info.setPackCountList(packCountList);
        }
        info.setSysTenant(sysTenant);
        info.setSuperAdmin(superAdmin);
        info.setPackCodes(packCodeList);
        return info;
    }

    @Override
    public List<TenantPackUserCount> queryTenantPackUserCount(Integer tenantId) {
        return ((SysTenantMapper)this.baseMapper).queryTenantPackUserCount(tenantId);
    }

    @Override
    public TenantPackModel queryTenantPack(TenantPackModel model) {
        String packCode;
        Integer tenantId = model.getTenantId();
        SysTenantPack sysTenantPack = this.sysTenantPackService.getSysTenantPack(tenantId, packCode = model.getPackCode());
        if (sysTenantPack != null) {
            TenantPackModel tenantPackModel = new TenantPackModel();
            tenantPackModel.setPackName(sysTenantPack.getPackName());
            tenantPackModel.setPackId(sysTenantPack.getId());
            List<TenantPackUser> userList = this.getTenantPackUserList(tenantId, sysTenantPack.getId(), 1);
            tenantPackModel.setUserList(userList);
            return tenantPackModel;
        }
        return null;
    }

    @Override
    public void addBatchTenantPackUser(SysTenantPackUser sysTenantPackUser) {
        String userIds = sysTenantPackUser.getUserId();
        if (oConvertUtils.isNotEmpty((Object)userIds)) {
            ISysTenantService currentService = (ISysTenantService)SpringContextUtils.getApplicationContext().getBean(ISysTenantService.class);
            String realNames = sysTenantPackUser.getRealname();
            String[] userIdArray = userIds.split(",");
            String[] realNameArray = realNames.split(",");
            for (int i = 0; i < userIdArray.length; ++i) {
                String userId = userIdArray[i];
                String realName = realNameArray[i];
                SysTenantPackUser entity = new SysTenantPackUser(sysTenantPackUser, userId, realName);
                LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantPackUser::getTenantId, (Object)entity.getTenantId())).eq(SysTenantPackUser::getPackId, (Object)entity.getPackId())).eq(SysTenantPackUser::getUserId, (Object)entity.getUserId());
                SysTenantPackUser packUser = (SysTenantPackUser)this.sysTenantPackUserMapper.selectOne((Wrapper)query);
                if (packUser == null || packUser.getId() == null) {
                    currentService.addTenantPackUser(entity);
                    continue;
                }
                if (packUser.getStatus() != 0) continue;
                packUser.setPackName(entity.getPackName());
                packUser.setRealname(realName);
                currentService.addTenantPackUser(packUser);
            }
        }
    }

    @Override
    @TenantLog(value=2)
    public void addTenantPackUser(SysTenantPackUser sysTenantPackUser) {
        if (sysTenantPackUser.getId() == null) {
            this.sysTenantPackUserMapper.insert(sysTenantPackUser);
        } else {
            sysTenantPackUser.setStatus(1);
            this.sysTenantPackUserMapper.updateById(sysTenantPackUser);
        }
    }

    @Override
    @TenantLog(value=4)
    public void deleteTenantPackUser(SysTenantPackUser sysTenantPackUser) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantPackUser::getUserId, (Object)sysTenantPackUser.getUserId())).eq(SysTenantPackUser::getPackId, (Object)sysTenantPackUser.getPackId());
        this.sysTenantPackUserMapper.delete((Wrapper)query);
        this.sendMsgForDelete(sysTenantPackUser);
    }

    @Override
    public List<TenantPackUser> getTenantPackApplyUsers(Integer tenantId) {
        return this.getTenantPackUserList(tenantId, null, 0);
    }

    private List<TenantPackUser> getTenantPackUserList(Integer tenantId, String packId, Integer packUserStatus) {
        List<TenantPackUser> userList = ((SysTenantMapper)this.baseMapper).queryPackUserList(tenantId, packId, packUserStatus);
        if (userList != null && userList.size() > 0) {
            List<String> userIdList = userList.stream().map(i -> i.getId()).collect(Collectors.toList());
            List<UserDepart> depList = ((SysTenantMapper)this.baseMapper).queryUserDepartList(userIdList);
            for (TenantPackUser user : userList) {
                for (UserDepart dep : depList) {
                    if (!user.getId().equals(dep.getUserId())) continue;
                    user.addDepart(dep.getDepartName());
                }
            }
        }
        return userList;
    }

    @Override
    public void doApplyTenantPackUser(SysTenantPackUser sysTenantPackUser) {
        LambdaQueryWrapper query1 = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantPack::getTenantId, (Object)sysTenantPackUser.getTenantId())).eq(SysTenantPack::getPackCode, (Object)sysTenantPackUser.getPackCode());
        SysTenantPack pack = (SysTenantPack)this.sysTenantPackService.getOne((Wrapper)query1);
        if (pack != null) {
            sysTenantPackUser.setStatus(0);
            sysTenantPackUser.setPackId(pack.getId());
            LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantPackUser::getTenantId, (Object)sysTenantPackUser.getTenantId())).eq(SysTenantPackUser::getPackId, (Object)sysTenantPackUser.getPackId())).eq(SysTenantPackUser::getUserId, (Object)sysTenantPackUser.getUserId());
            Long count = this.sysTenantPackUserMapper.selectCount((Wrapper)query);
            if (count == null || count == 0L) {
                this.sysTenantPackUserMapper.insert(sysTenantPackUser);
            }
            this.sendMsgForApply(sysTenantPackUser.getUserId(), pack);
        }
    }

    private void sendMsgForApply(String userId, SysTenantPack pack) {
        SysUser user = (SysUser)this.userService.getById((Serializable)((Object)userId));
        Integer tenantId = pack.getTenantId();
        SysTenant sysTenant = ((SysTenantMapper)this.baseMapper).querySysTenant(tenantId);
        String packCode = pack.getPackCode();
        List<String> packCodeList = Arrays.asList(packCode.split(","));
        List<String> userList = this.sysTenantPackUserMapper.queryTenantPackUserNameList(tenantId, packCodeList);
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setToAll(Boolean.valueOf(false));
        messageDTO.setToUser(String.join((CharSequence)",", userList));
        messageDTO.setFromUser("system");
        String title = user.getRealname() + " \u7533\u8bf7\u52a0\u5165 " + sysTenant.getName() + " \u7684" + pack.getPackName() + "\u7684\u6210\u5458\u3002";
        messageDTO.setTitle(title);
        HashMap data = new HashMap();
        messageDTO.setData(data);
        messageDTO.setContent(title);
        messageDTO.setType("system");
        this.sysBaseApi.sendTemplateMessage(messageDTO);
    }

    private void sendMsgForDelete(SysTenantPackUser sysTenantPackUser) {
        SysUser user = (SysUser)this.userService.getById((Serializable)((Object)sysTenantPackUser.getUserId()));
        SysTenant sysTenant = ((SysTenantMapper)this.baseMapper).querySysTenant(sysTenantPackUser.getTenantId());
        LoginUser loginUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setToAll(Boolean.valueOf(false));
        messageDTO.setToUser(user.getUsername());
        String title = "\u60a8\u5df2\u88ab " + loginUser.getRealname() + " \u4ece " + sysTenant.getName() + "\u7684" + sysTenantPackUser.getPackName() + "\u4e2d\u79fb\u9664\u3002";
        messageDTO.setTitle(title);
        messageDTO.setFromUser("system");
        HashMap<String, String> data = new HashMap<String, String>();
        data.put("realname", loginUser.getRealname());
        data.put("tenantName", sysTenant.getName());
        data.put("packName", sysTenantPackUser.getPackName());
        messageDTO.setData(data);
        messageDTO.setType("system");
        messageDTO.setContent(title);
        this.sysBaseApi.sendTemplateMessage(messageDTO);
    }

    private void sendMsgForApplyJoinTenant(String userId, SysTenant sysTenant) {
        SysUser user = (SysUser)this.userService.getById((Serializable)((Object)userId));
        String codes = "superAdmin,accountAdmin";
        List<String> packCodeList = Arrays.asList(codes.split(","));
        List<String> userList = this.sysTenantPackUserMapper.queryTenantPackUserNameList(sysTenant.getId(), packCodeList);
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setToAll(Boolean.valueOf(false));
        messageDTO.setToUser(String.join((CharSequence)",", userList));
        messageDTO.setFromUser("system");
        String title = user.getRealname() + " \u7533\u8bf7\u52a0\u5165 " + sysTenant.getName() + "\u3002";
        messageDTO.setTitle(title);
        HashMap data = new HashMap();
        messageDTO.setData(data);
        messageDTO.setType("system");
        messageDTO.setContent(title);
        this.sysBaseApi.sendTemplateMessage(messageDTO);
    }

    private void sendMsgForInvitation(SysUser user, Integer tenantId, String realname) {
        SysTenant sysTenant = ((SysTenantMapper)this.baseMapper).querySysTenant(tenantId);
        BusMessageDTO messageDTO = new BusMessageDTO();
        messageDTO.setToAll(Boolean.valueOf(false));
        messageDTO.setToUser(user.getUsername());
        messageDTO.setFromUser("system");
        String title = realname + " \u9080\u8bf7\u60a8\u52a0\u5165 " + sysTenant.getName() + "\u3002";
        messageDTO.setTitle(title);
        HashMap data = new HashMap();
        messageDTO.setData(data);
        messageDTO.setContent(title);
        messageDTO.setType("system");
        messageDTO.setCategory("1");
        messageDTO.setBusType(SysAnnmentTypeEnum.TENANT_INVITE.getType());
        this.sysBaseApi.sendBusAnnouncement(messageDTO);
    }

    @Override
    public void passApply(SysTenantPackUser sysTenantPackUser) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantPackUser::getTenantId, (Object)sysTenantPackUser.getTenantId())).eq(SysTenantPackUser::getPackId, (Object)sysTenantPackUser.getPackId())).eq(SysTenantPackUser::getUserId, (Object)sysTenantPackUser.getUserId());
        SysTenantPackUser packUser = (SysTenantPackUser)this.sysTenantPackUserMapper.selectOne((Wrapper)query);
        if (packUser != null && packUser.getId() != null && packUser.getStatus() == 0) {
            ISysTenantService currentService = (ISysTenantService)SpringContextUtils.getApplicationContext().getBean(ISysTenantService.class);
            packUser.setPackName(sysTenantPackUser.getPackName());
            packUser.setRealname(sysTenantPackUser.getRealname());
            currentService.addTenantPackUser(packUser);
            SysTenant sysTenant = (SysTenant)this.tenantMapper.selectById(sysTenantPackUser.getTenantId());
            String content = " \u60a8\u5df2\u6210\u529f\u52a0\u5165" + sysTenant.getName() + "\u7684\u8d85\u7ea7\u7ba1\u7406\u5458\u7684\u6210\u5458\u3002";
            SysUser sysUser = (SysUser)this.userService.getById((Serializable)((Object)sysTenantPackUser.getUserId()));
            this.sendMsgForAgreeAndRefuseJoin(sysUser, content);
        }
    }

    @Override
    public void deleteApply(SysTenantPackUser sysTenantPackUser) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysTenantPackUser::getTenantId, (Object)sysTenantPackUser.getTenantId())).eq(SysTenantPackUser::getPackId, (Object)sysTenantPackUser.getPackId())).eq(SysTenantPackUser::getUserId, (Object)sysTenantPackUser.getUserId());
        SysTenantPackUser packUser = (SysTenantPackUser)this.sysTenantPackUserMapper.selectOne((Wrapper)query);
        if (packUser != null && packUser.getId() != null && packUser.getStatus() == 0) {
            this.sysTenantPackUserMapper.deleteById((Serializable)((Object)packUser.getId()));
            SysTenant sysTenant = (SysTenant)this.tenantMapper.selectById(sysTenantPackUser.getTenantId());
            String content = " \u7ba1\u7406\u5458\u5df2\u62d2\u7edd\u60a8\u52a0\u5165" + sysTenant.getName() + "\u7684\u8d85\u7ea7\u7ba1\u7406\u5458\u7684\u6210\u5458\u8bf7\u6c42\u3002";
            SysUser sysUser = (SysUser)this.userService.getById((Serializable)((Object)sysTenantPackUser.getUserId()));
            this.sendMsgForAgreeAndRefuseJoin(sysUser, content);
        }
    }

    @Override
    public IPage<TenantPackUser> queryTenantPackUserList(String tenantId, String packId, Integer status, Page<TenantPackUser> page) {
        List<TenantPackUser> userList = ((SysTenantMapper)this.baseMapper).queryTenantPackUserList(page, tenantId, packId, status);
        userList = this.getPackUserPositionAndDepart(userList);
        return page.setRecords(userList);
    }

    private List<TenantPackUser> getPackUserPositionAndDepart(List<TenantPackUser> userList) {
        if (userList != null && userList.size() > 0) {
            List<String> userIdList = userList.stream().map(i -> i.getId()).collect(Collectors.toList());
            List<UserDepart> depList = ((SysTenantMapper)this.baseMapper).queryUserDepartList(userIdList);
            List<UserPosition> userPositions = ((SysTenantMapper)this.baseMapper).queryUserPositionList(userIdList);
            for (TenantPackUser user : userList) {
                for (UserDepart dep : depList) {
                    if (!user.getId().equals(dep.getUserId())) continue;
                    user.addDepart(dep.getDepartName());
                }
                for (UserPosition userPosition : userPositions) {
                    if (!user.getId().equals(userPosition.getUserId())) continue;
                    user.addPosition(userPosition.getPositionName());
                }
            }
        }
        return userList;
    }

    private void saveUserDepart(String userId, String departId) {
        Long count = this.sysUserDepartMapper.getCountByDepartIdAndUserId(userId, departId);
        if (count == 0L) {
            SysUserDepart sysUserDepart = new SysUserDepart(userId, departId);
            this.sysUserDepartMapper.insert(sysUserDepart);
        }
    }

    @Override
    public Long getApplySuperAdminCount() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        return ((SysTenantMapper)this.baseMapper).getApplySuperAdminCount(sysUser.getId(), tenantId);
    }

    @Override
    public void sendMsgForAgreeAndRefuseJoin(SysUser user, String content) {
        MessageDTO messageDTO = new MessageDTO();
        messageDTO.setToAll(Boolean.valueOf(false));
        messageDTO.setToUser(user.getUsername());
        messageDTO.setFromUser("system");
        messageDTO.setTitle(content);
        HashMap data = new HashMap();
        messageDTO.setData(data);
        messageDTO.setContent(content);
        messageDTO.setType("system");
        this.sysBaseApi.sendTemplateMessage(messageDTO);
    }

    private String getTenantErrorInfo(String status) {
        String content = "\u5df2\u5728\u79df\u6237\u4e2d\uff0c\u65e0\u9700\u9080\u8bf7\uff01";
        if ("2".equals(status)) {
            content = "\u5df2\u79bb\u804c\uff01";
        } else if ("3".equals(status)) {
            content = "\u79df\u6237\u7ba1\u7406\u5458\u5ba1\u6838\u4e2d\uff01";
        } else if ("4".equals(status)) {
            content = "\u79df\u6237\u7ba1\u7406\u5458\u5df2\u62d2\u7edd\uff01";
        } else if ("5".equals(status)) {
            content = "\u5df2\u88ab\u9080\u8bf7\uff0c\u5f85\u7528\u6237\u540c\u610f\uff01";
        }
        return content;
    }

    private void deleteTenantPackByTenantId(List<Integer> tenantIdList) {
        this.sysTenantPackUserMapper.deletePackUserByTenantIds(tenantIdList);
        this.sysPackPermissionMapper.deletePackPermByTenantIds(tenantIdList);
        this.sysTenantPackMapper.deletePackByTenantIds(tenantIdList);
    }

    @Override
    public void deleteUserByPassword(SysUser sysUser, Integer tenantId) {
        String userId = sysUser.getId();
        String password = sysUser.getPassword();
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        Long isHaveAdmin = this.sysTenantPackUserMapper.izHaveBuyAuth(user.getId(), tenantId);
        if (null == isHaveAdmin || 0L == isHaveAdmin) {
            throw new JeecgBootException("\u60a8\u4e0d\u662f\u5f53\u524d\u7ec4\u7ec7\u7684\u7ba1\u7406\u5458\uff0c\u65e0\u6cd5\u5220\u9664\u7528\u6237\uff01");
        }
        SysUserTenant sysUserTenant = this.userTenantMapper.getUserTenantByTenantId(userId, tenantId);
        if (null == sysUserTenant || !"2".equals(sysUserTenant.getStatus())) {
            throw new JeecgBootException("\u7528\u6237\u6ca1\u6709\u79bb\u804c\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
        List<Integer> tenantIdsByUserId = this.userTenantMapper.getTenantIdsByUserId(userId);
        if (CollectionUtils.isNotEmpty(tenantIdsByUserId) && tenantIdsByUserId.size() > 0) {
            throw new JeecgBootException("\u7528\u6237\u5c1a\u6709\u672a\u9000\u51fa\u7684\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        SysUser sysUserData = (SysUser)this.userService.getById((Serializable)((Object)userId));
        if (!sysUserData.getCreateBy().equals(user.getUsername())) {
            throw new JeecgBootException("\u60a8\u4e0d\u662f\u8be5\u7528\u6237\u7684\u521b\u5efa\u4eba\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        Date createTime = sysUserData.getCreateTime();
        boolean sameDay = DateUtils.isSameDay((Date)createTime, (Date)new Date());
        if (!sameDay) {
            throw new JeecgBootException("\u7528\u6237\u4e0d\u662f\u4eca\u5929\u521b\u5efa\u7684\uff0c\u65e0\u6cd5\u5220\u9664\uff01");
        }
        String passwordEncode = PasswordUtil.encrypt((String)sysUserData.getUsername(), (String)password, (String)sysUserData.getSalt());
        if (!passwordEncode.equals(sysUserData.getPassword())) {
            throw new JeecgBootException("\u60a8\u8f93\u5165\u7684\u5bc6\u7801\u4e0d\u6b63\u786e\uff0c\u65e0\u6cd5\u5220\u9664\u8be5\u7528\u6237\uff01");
        }
        this.userService.deleteUser(userId);
        this.userService.removeLogicDeleted(Collections.singletonList(userId));
    }

    @Override
    public List<SysTenant> getTenantListByUserId(String userId) {
        return this.tenantMapper.getTenantListByUserId(userId);
    }
}

