/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.mapper.SysRoleMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.service.ISysRoleService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class SysRoleServiceImpl
extends ServiceImpl<SysRoleMapper, SysRole>
implements ISysRoleService {
    @Autowired
    SysRoleMapper sysRoleMapper;
    @Autowired
    SysUserMapper sysUserMapper;

    @Override
    public Page<SysRole> listAllSysRole(Page<SysRole> page, SysRole role) {
        return page.setRecords(this.sysRoleMapper.listAllSysRole(page, role));
    }

    @Override
    public SysRole getRoleNoTenant(String roleCode) {
        return this.sysRoleMapper.getRoleNoTenant(roleCode);
    }

    @Override
    public Result importExcelCheckRoleCode(MultipartFile file, ImportParams params) throws Exception {
        List listSysRoles = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), SysRole.class, (ImportParams)params);
        int totalCount = listSysRoles.size();
        ArrayList<String> errorStrs = new ArrayList<String>();
        block0: for (int i = 0; i < listSysRoles.size(); ++i) {
            String roleCodeI = ((SysRole)listSysRoles.get(i)).getRoleCode();
            for (int j = i + 1; j < listSysRoles.size(); ++j) {
                String roleCodeJ = ((SysRole)listSysRoles.get(j)).getRoleCode();
                if (!roleCodeI.equals(roleCodeJ)) continue;
                errorStrs.add("\u7b2c " + (j + 1) + " \u884c\u7684 roleCode \u503c\uff1a" + roleCodeI + " \u5df2\u5b58\u5728\uff0c\u5ffd\u7565\u5bfc\u5165");
                listSysRoles.remove(j);
                continue block0;
            }
        }
        Integer errorLines = 0;
        Integer successLines = 0;
        List list = ImportExcelUtil.importDateSave((List)listSysRoles, ISysRoleService.class, errorStrs, (String)"uniq_sys_role_role_code");
        errorLines = errorLines + list.size();
        successLines = successLines + (listSysRoles.size() - errorLines);
        return ImportExcelUtil.imporReturnRes((int)errorLines, (int)successLines, (List)list);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteRole(String roleid) {
        this.sysRoleMapper.deleteRoleUserRelation(roleid);
        this.sysRoleMapper.deleteRolePermissionRelation(roleid);
        this.removeById((Serializable)((Object)roleid));
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean deleteBatchRole(String[] roleIds) {
        this.sysUserMapper.deleteBathRoleUserRelation(roleIds);
        this.sysUserMapper.deleteBathRolePermissionRelation(roleIds);
        this.removeByIds(Arrays.asList(roleIds));
        return true;
    }

    @Override
    public Long getRoleCountByTenantId(String id, Integer tenantId) {
        return this.sysRoleMapper.getRoleCountByTenantId(id, tenantId);
    }

    @Override
    public void checkAdminRoleRejectDel(String ids) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(SysRole::getId, Arrays.asList(ids.split(",")));
        query.eq(SysRole::getRoleCode, (Object)"admin");
        Long adminRoleCount = this.sysRoleMapper.selectCount((Wrapper)query);
        if (adminRoleCount > 0L) {
            throw new JeecgBootException("admin\u89d2\u8272\uff0c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
        }
    }
}

