/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.modules.system.entity.SysRoleIndex;
import org.jeecg.modules.system.mapper.SysRoleIndexMapper;
import org.jeecg.modules.system.service.ISysRoleIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service(value="sysRoleIndexServiceImpl")
public class SysRoleIndexServiceImpl
extends ServiceImpl<SysRoleIndexMapper, SysRoleIndex>
implements ISysRoleIndexService {
    @Autowired
    private RedisUtil redisUtil;

    @Override
    @Cacheable(cacheNames={"sys:cache:def_index"}, key="'DEF_INDEX_ALL'")
    public SysRoleIndex queryDefaultIndex() {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleIndex::getRoleCode, (Object)"DEF_INDEX_ALL");
        SysRoleIndex entity = (SysRoleIndex)super.getOne((Wrapper)queryWrapper);
        if (entity == null) {
            entity = this.initDefaultIndex();
        }
        return entity;
    }

    @Override
    public boolean updateDefaultIndex(String url, String component, boolean isRoute) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysRoleIndex::getRoleCode, (Object)"DEF_INDEX_ALL");
        SysRoleIndex entity = (SysRoleIndex)super.getOne((Wrapper)queryWrapper);
        boolean success = false;
        if (entity == null) {
            entity = this.newDefIndexConfig(url, component, isRoute);
            success = super.save((Object)entity);
        } else {
            entity.setUrl(url);
            entity.setComponent(component);
            entity.setRoute(isRoute);
            success = super.updateById((Object)entity);
        }
        if (success) {
            this.cleanDefaultIndexCache();
        }
        return success;
    }

    @Override
    public SysRoleIndex initDefaultIndex() {
        return this.newDefIndexConfig("/dashboard/analysis", "dashboard/Analysis", true);
    }

    private SysRoleIndex newDefIndexConfig(String indexUrl, String indexComponent, boolean isRoute) {
        SysRoleIndex entity = new SysRoleIndex();
        entity.setRoleCode("DEF_INDEX_ALL");
        entity.setUrl(indexUrl);
        entity.setComponent(indexComponent);
        entity.setRoute(isRoute);
        entity.setStatus("1");
        return entity;
    }

    @Override
    public void cleanDefaultIndexCache() {
        this.redisUtil.del(new String[]{"sys:cache:def_index::DEF_INDEX_ALL"});
    }
}

