/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.entity.SysRoleIndex;
import org.jeecg.modules.system.mapper.SysDepartPermissionMapper;
import org.jeecg.modules.system.mapper.SysDepartRolePermissionMapper;
import org.jeecg.modules.system.mapper.SysPermissionMapper;
import org.jeecg.modules.system.mapper.SysRolePermissionMapper;
import org.jeecg.modules.system.model.TreeModel;
import org.jeecg.modules.system.service.ISysPermissionDataRuleService;
import org.jeecg.modules.system.service.ISysPermissionService;
import org.jeecg.modules.system.service.ISysRoleIndexService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysPermissionServiceImpl
extends ServiceImpl<SysPermissionMapper, SysPermission>
implements ISysPermissionService {
    @Resource
    private SysPermissionMapper sysPermissionMapper;
    @Resource
    private ISysPermissionDataRuleService permissionDataRuleService;
    @Resource
    private SysRolePermissionMapper sysRolePermissionMapper;
    @Resource
    private SysDepartPermissionMapper sysDepartPermissionMapper;
    @Resource
    private SysDepartRolePermissionMapper sysDepartRolePermissionMapper;
    @Autowired
    private ISysRoleIndexService roleIndexService;

    @Override
    public void switchVue3Menu() {
        this.sysPermissionMapper.backupVue2Menu();
        this.sysPermissionMapper.changeVue3Menu();
    }

    @Override
    public List<TreeModel> queryListByParentId(String parentId) {
        return this.sysPermissionMapper.queryListByParentId(parentId);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void deletePermission(String id) throws JeecgBootException {
        Long count;
        SysPermission sysPermission = (SysPermission)this.getById((Serializable)((Object)id));
        if (sysPermission == null) {
            throw new JeecgBootException("\u672a\u627e\u5230\u83dc\u5355\u4fe1\u606f");
        }
        String pid = sysPermission.getParentId();
        if (oConvertUtils.isNotEmpty((Object)pid) && (count = Long.valueOf(this.count((Wrapper)new QueryWrapper().lambda().eq(SysPermission::getParentId, (Object)pid)))) == 1L) {
            this.sysPermissionMapper.setMenuLeaf(pid, 1);
        }
        this.sysPermissionMapper.deleteById((Serializable)((Object)id));
        this.removeChildrenBy(sysPermission.getId());
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("permission_id", id);
        this.deletePermRuleByPermId(id);
        this.sysRolePermissionMapper.deleteByMap(map);
        this.sysDepartPermissionMapper.deleteByMap(map);
        this.sysDepartRolePermissionMapper.deleteByMap(map);
    }

    public void removeChildrenBy(String parentId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysPermission::getParentId, (Object)parentId);
        List permissionList = this.list((Wrapper)query);
        if (permissionList != null && permissionList.size() > 0) {
            String id = "";
            Long num = 0L;
            this.remove((Wrapper)query);
            int len = permissionList.size();
            for (int i = 0; i < len; ++i) {
                id = ((SysPermission)permissionList.get(i)).getId();
                HashMap<String, String> map = new HashMap<String, String>(5);
                map.put("permission_id", id);
                this.deletePermRuleByPermId(id);
                this.sysRolePermissionMapper.deleteByMap(map);
                this.sysDepartPermissionMapper.deleteByMap(map);
                this.sysDepartRolePermissionMapper.deleteByMap(map);
                num = this.count((Wrapper)new LambdaQueryWrapper().eq(SysPermission::getParentId, (Object)id));
                if (num <= 0L) continue;
                this.removeChildrenBy(id);
            }
        }
    }

    @Override
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void deletePermissionLogical(String id) throws JeecgBootException {
        SysPermission sysPermission = (SysPermission)this.getById((Serializable)((Object)id));
        if (sysPermission == null) {
            throw new JeecgBootException("\u672a\u627e\u5230\u83dc\u5355\u4fe1\u606f");
        }
        String pid = sysPermission.getParentId();
        Long count = this.count((Wrapper)new QueryWrapper().lambda().eq(SysPermission::getParentId, (Object)pid));
        if (count == 1L) {
            this.sysPermissionMapper.setMenuLeaf(pid, 1);
        }
        sysPermission.setDelFlag(1);
        this.updateById(sysPermission);
    }

    @Override
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void addPermission(SysPermission sysPermission) throws JeecgBootException {
        String pid;
        if (CommonConstant.MENU_TYPE_0.equals(sysPermission.getMenuType())) {
            sysPermission.setParentId(null);
        }
        if (oConvertUtils.isNotEmpty((Object)(pid = sysPermission.getParentId()))) {
            this.sysPermissionMapper.setMenuLeaf(pid, 0);
        }
        sysPermission.setCreateTime(new Date());
        sysPermission.setDelFlag(0);
        sysPermission.setLeaf(true);
        this.save(sysPermission);
    }

    @Override
    @CacheEvict(value={"sys:cache:permission:datarules"}, allEntries=true)
    public void editPermission(SysPermission sysPermission) throws JeecgBootException {
        SysRoleIndex defIndexCfg;
        boolean isDefIndex;
        boolean flag;
        Long count;
        SysPermission p = (SysPermission)this.getById((Serializable)((Object)sysPermission.getId()));
        if (p == null) {
            throw new JeecgBootException("\u672a\u627e\u5230\u83dc\u5355\u4fe1\u606f");
        }
        sysPermission.setUpdateTime(new Date());
        if (CommonConstant.MENU_TYPE_0.equals(sysPermission.getMenuType())) {
            sysPermission.setParentId("");
        }
        if ((count = Long.valueOf(this.count((Wrapper)new QueryWrapper().lambda().eq(SysPermission::getParentId, (Object)sysPermission.getId())))) == 0L) {
            sysPermission.setLeaf(true);
        }
        this.updateById(sysPermission);
        String pid = sysPermission.getParentId();
        boolean bl = flag = oConvertUtils.isNotEmpty((Object)pid) && !pid.equals(p.getParentId()) || oConvertUtils.isEmpty((Object)pid) && oConvertUtils.isNotEmpty((Object)p.getParentId());
        if (flag) {
            this.sysPermissionMapper.setMenuLeaf(pid, 0);
            Long cc = this.count((Wrapper)new QueryWrapper().lambda().eq(SysPermission::getParentId, (Object)p.getParentId()));
            if (cc == 0L && oConvertUtils.isNotEmpty((Object)p.getParentId())) {
                this.sysPermissionMapper.setMenuLeaf(p.getParentId(), 1);
            }
        }
        if (isDefIndex = (defIndexCfg = this.roleIndexService.queryDefaultIndex()).getUrl().equals(p.getUrl())) {
            this.roleIndexService.updateDefaultIndex(sysPermission.getUrl(), sysPermission.getComponent(), sysPermission.isRoute());
        }
    }

    @Override
    public List<SysPermission> queryByUser(String userId) {
        List<SysPermission> permissionList = this.sysPermissionMapper.queryByUser(userId);
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            if (permissionList == null) {
                permissionList = new ArrayList<SysPermission>();
            }
            List<SysPermission> testRoleList = this.sysPermissionMapper.queryPermissionByTestRoleId();
            for (SysPermission permission : testRoleList) {
                boolean hasPerm = permissionList.stream().anyMatch(a -> a.getId().equals(permission.getId()));
                if (hasPerm) continue;
                permissionList.add(permission);
            }
        }
        return permissionList;
    }

    @Override
    public void deletePermRuleByPermId(String id) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysPermissionDataRule::getPermissionId, (Object)id);
        Long countValue = this.permissionDataRuleService.count((Wrapper)query);
        if (countValue > 0L) {
            this.permissionDataRuleService.remove((Wrapper)query);
        }
    }

    @Override
    @Cacheable(value={"sys:cache:permission:datarules"})
    public List<String> queryPermissionUrlWithStar() {
        return ((SysPermissionMapper)this.baseMapper).queryPermissionUrlWithStar();
    }

    @Override
    public boolean hasPermission(String username, SysPermission sysPermission) {
        int count = ((SysPermissionMapper)this.baseMapper).queryCountByUsername(username, sysPermission);
        return count > 0;
    }

    @Override
    public boolean hasPermission(String username, String url) {
        SysPermission sysPermission = new SysPermission();
        sysPermission.setUrl(url);
        int count = ((SysPermissionMapper)this.baseMapper).queryCountByUsername(username, sysPermission);
        return count > 0;
    }

    @Override
    public List<SysPermission> queryDepartPermissionList(String departId) {
        return this.sysPermissionMapper.queryDepartPermissionList(departId);
    }

    @Override
    public boolean checkPermDuplication(String id, String url, Boolean alwaysShow) {
        QueryWrapper qw = new QueryWrapper();
        ((LambdaQueryWrapper)((LambdaQueryWrapper)qw.lambda().eq(true, SysPermission::getUrl, (Object)url)).ne(oConvertUtils.isNotEmpty((Object)id), SysPermission::getId, (Object)id)).eq(true, SysPermission::isAlwaysShow, (Object)alwaysShow);
        return this.count((Wrapper)qw) == 0L;
    }
}

