/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.util.ArrayUtil;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import io.netty.util.internal.StringUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.FillRuleUtil;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.common.util.YouBianCodeUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDepartPermission;
import org.jeecg.modules.system.entity.SysDepartRole;
import org.jeecg.modules.system.entity.SysDepartRolePermission;
import org.jeecg.modules.system.entity.SysDepartRoleUser;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.mapper.SysDepartMapper;
import org.jeecg.modules.system.mapper.SysDepartPermissionMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleMapper;
import org.jeecg.modules.system.mapper.SysDepartRolePermissionMapper;
import org.jeecg.modules.system.mapper.SysDepartRoleUserMapper;
import org.jeecg.modules.system.mapper.SysUserDepartMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.model.DepartIdModel;
import org.jeecg.modules.system.model.SysDepartTreeModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.util.FindsDepartsChildrenUtil;
import org.jeecg.modules.system.vo.SysDepartExportVo;
import org.jeecg.modules.system.vo.lowapp.ExportDepartVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysDepartServiceImpl
extends ServiceImpl<SysDepartMapper, SysDepart>
implements ISysDepartService {
    @Autowired
    private SysUserDepartMapper userDepartMapper;
    @Autowired
    private SysDepartRoleMapper sysDepartRoleMapper;
    @Autowired
    private SysDepartPermissionMapper departPermissionMapper;
    @Autowired
    private SysDepartRolePermissionMapper departRolePermissionMapper;
    @Autowired
    private SysDepartRoleUserMapper departRoleUserMapper;
    @Autowired
    private SysUserMapper sysUserMapper;
    @Autowired
    private SysDepartMapper departMapper;

    @Override
    public List<SysDepartTreeModel> queryMyDeptTreeList(String departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        Object[] codeArr = this.getMyDeptParentOrgCode(departIds);
        if (ArrayUtil.isEmpty((Object[])codeArr)) {
            return null;
        }
        for (int i = 0; i < codeArr.length; ++i) {
            ((LambdaQueryWrapper)query.or()).likeRight(SysDepart::getOrgCode, codeArr[i]);
        }
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            query.eq(SysDepart::getTenantId, (Object)oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        query.orderByAsc(SysDepart::getDepartOrder);
        List listDepts = this.list((Wrapper)query);
        for (int i = 0; i < codeArr.length; ++i) {
            for (SysDepart dept : listDepts) {
                if (!dept.getOrgCode().equals(codeArr[i])) continue;
                dept.setParentId(null);
            }
        }
        List<SysDepartTreeModel> listResult = FindsDepartsChildrenUtil.wrapTreeDataToTreeList(listDepts);
        return listResult;
    }

    @Override
    public List<SysDepartTreeModel> queryTreeList() {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            query.eq(SysDepart::getTenantId, (Object)oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)query);
        this.setUserIdsByDepList(list);
        List<SysDepartTreeModel> listResult = FindsDepartsChildrenUtil.wrapTreeDataToTreeList(list);
        return listResult;
    }

    @Override
    public List<SysDepartTreeModel> queryTreeList(String ids) {
        ArrayList<SysDepartTreeModel> listResult = new ArrayList<SysDepartTreeModel>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        if (oConvertUtils.isNotEmpty((Object)ids)) {
            query.in(true, SysDepart::getId, (Object[])ids.split(","));
        }
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            query.eq(SysDepart::getTenantId, (Object)oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        query.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)query);
        for (SysDepart depart : list) {
            listResult.add(new SysDepartTreeModel(depart));
        }
        return listResult;
    }

    @Override
    public List<DepartIdModel> queryDepartIdTreeList() {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            query.eq(SysDepart::getTenantId, (Object)oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        query.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)query);
        List<DepartIdModel> listResult = FindsDepartsChildrenUtil.wrapTreeDataToDepartIdTreeList(list);
        return listResult;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveDepartData(SysDepart sysDepart, String username) {
        if (sysDepart != null && username != null) {
            if (oConvertUtils.isEmpty((Object)sysDepart.getParentId())) {
                sysDepart.setParentId("");
            } else {
                this.departMapper.setMainLeaf(sysDepart.getParentId(), CommonConstant.NOT_LEAF);
            }
            sysDepart.setId(IdWorker.getIdStr((Object)sysDepart));
            String parentId = sysDepart.getParentId();
            JSONObject formData = new JSONObject();
            formData.put("parentId", (Object)parentId);
            String[] codeArray = (String[])FillRuleUtil.executeRule((String)"org_num_role", (JSONObject)formData);
            sysDepart.setOrgCode(codeArray[0]);
            String orgType = codeArray[1];
            sysDepart.setOrgType(String.valueOf(orgType));
            sysDepart.setCreateTime(new Date());
            sysDepart.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
            sysDepart.setIzLeaf(CommonConstant.IS_LEAF);
            if (oConvertUtils.isEmpty((Object)sysDepart.getOrgCategory())) {
                if (oConvertUtils.isEmpty((Object)sysDepart.getParentId())) {
                    sysDepart.setOrgCategory("1");
                } else {
                    sysDepart.setOrgCategory("2");
                }
            }
            this.save(sysDepart);
            if (oConvertUtils.isNotEmpty((Object)sysDepart.getDirectorUserIds())) {
                this.addDepartByUserIds(sysDepart, sysDepart.getDirectorUserIds());
            }
        }
    }

    private String[] generateOrgCode(String parentId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        LambdaQueryWrapper query1 = new LambdaQueryWrapper();
        String[] strArray = new String[2];
        List departList = new ArrayList();
        String newOrgCode = "";
        String oldOrgCode = "";
        String orgType = "";
        if (StringUtil.isNullOrEmpty((String)parentId)) {
            ((LambdaQueryWrapper)((LambdaQueryWrapper)query1.eq(SysDepart::getParentId, (Object)"")).or()).isNull(SysDepart::getParentId);
            query1.orderByDesc(SysDepart::getOrgCode);
            departList = this.list((Wrapper)query1);
            if (departList == null || departList.size() == 0) {
                strArray[0] = YouBianCodeUtil.getNextYouBianCode(null);
                strArray[1] = "1";
                return strArray;
            }
            SysDepart depart = (SysDepart)departList.get(0);
            oldOrgCode = depart.getOrgCode();
            orgType = depart.getOrgType();
            newOrgCode = YouBianCodeUtil.getNextYouBianCode((String)oldOrgCode);
        } else {
            query.eq(SysDepart::getParentId, (Object)parentId);
            query.orderByDesc(SysDepart::getOrgCode);
            List parentList = this.list((Wrapper)query);
            SysDepart depart = (SysDepart)this.getById((Serializable)((Object)parentId));
            String parentCode = depart.getOrgCode();
            orgType = String.valueOf(Integer.valueOf(depart.getOrgType()) + 1);
            if (parentList == null || parentList.size() == 0) {
                newOrgCode = YouBianCodeUtil.getSubYouBianCode((String)parentCode, null);
            } else {
                String subCode = ((SysDepart)parentList.get(0)).getOrgCode();
                newOrgCode = YouBianCodeUtil.getSubYouBianCode((String)parentCode, (String)subCode);
            }
        }
        strArray[0] = newOrgCode;
        strArray[1] = orgType;
        return strArray;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean updateDepartDataById(SysDepart sysDepart, String username) {
        if (sysDepart != null && username != null) {
            sysDepart.setUpdateTime(new Date());
            sysDepart.setUpdateBy(username);
            this.updateById(sysDepart);
            this.updateChargeDepart(sysDepart);
            return true;
        }
        return false;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatchWithChildren(List<String> ids) {
        ArrayList<String> idList = new ArrayList<String>();
        ArrayList<String> parentIdList = new ArrayList<String>();
        for (String id : ids) {
            idList.add(id);
            this.checkChildrenExists(id, idList);
            SysDepart depart = this.getDepartById(id);
            if (!oConvertUtils.isNotEmpty((Object)depart.getParentId()) || parentIdList.contains(depart.getParentId())) continue;
            parentIdList.add(depart.getParentId());
        }
        this.removeByIds(idList);
        this.setParentDepartIzLeaf(parentIdList);
        ArrayList<String> roleIdList = new ArrayList<String>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)query.select((Object[])new SFunction[]{SysDepartRole::getId})).in(SysDepartRole::getDepartId, idList);
        List depRoleList = this.sysDepartRoleMapper.selectList((Wrapper)query);
        for (SysDepartRole deptRole : depRoleList) {
            roleIdList.add(deptRole.getId());
        }
        this.userDepartMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserDepart::getDepId, idList));
        this.departPermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartPermission::getDepartId, idList));
        this.sysDepartRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRole::getDepartId, idList));
        if (roleIdList != null && roleIdList.size() > 0) {
            this.departRolePermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRolePermission::getRoleId, roleIdList));
            this.departRoleUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRoleUser::getDroleId, roleIdList));
        }
    }

    @Override
    public List<String> getSubDepIdsByDepId(String departId) {
        return ((SysDepartMapper)this.baseMapper).getSubDepIdsByDepId(departId);
    }

    @Override
    public List<String> getMySubDepIdsByDepId(String departIds) {
        String[] codeArr = this.getMyDeptParentOrgCode(departIds);
        if (codeArr == null || codeArr.length == 0) {
            return null;
        }
        return ((SysDepartMapper)this.baseMapper).getSubDepIdsByOrgCodes(codeArr);
    }

    @Override
    public List<SysDepartTreeModel> searchByKeyWord(String keyWord, String myDeptSearch, String departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        ArrayList<SysDepartTreeModel> newList = new ArrayList<SysDepartTreeModel>();
        if (!StringUtil.isNullOrEmpty((String)myDeptSearch)) {
            if (StringUtil.isNullOrEmpty((String)departIds)) {
                return newList;
            }
            String[] codeArr = this.getMyDeptParentOrgCode(departIds);
            if (codeArr != null && codeArr.length > 0) {
                query.nested(i -> {
                    for (String s : codeArr) {
                        ((LambdaQueryWrapper)i.or()).likeRight(SysDepart::getOrgCode, (Object)s);
                    }
                });
            }
            query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        }
        query.like(SysDepart::getDepartName, (Object)keyWord);
        SysDepartTreeModel model = new SysDepartTreeModel();
        List departList = this.list((Wrapper)query);
        if (departList.size() > 0) {
            for (SysDepart depart : departList) {
                model = new SysDepartTreeModel(depart);
                model.setChildren(null);
                newList.add(model);
            }
            return newList;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean delete(String id) {
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        this.checkChildrenExists(id, idList);
        boolean ok = this.removeByIds(idList);
        ArrayList<String> roleIdList = new ArrayList<String>();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)query.select((Object[])new SFunction[]{SysDepartRole::getId})).in(SysDepartRole::getDepartId, idList);
        List depRoleList = this.sysDepartRoleMapper.selectList((Wrapper)query);
        for (SysDepartRole deptRole : depRoleList) {
            roleIdList.add(deptRole.getId());
        }
        this.userDepartMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysUserDepart::getDepId, idList));
        this.departPermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartPermission::getDepartId, idList));
        this.sysDepartRoleMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRole::getDepartId, idList));
        if (roleIdList != null && roleIdList.size() > 0) {
            this.departRolePermissionMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRolePermission::getRoleId, roleIdList));
            this.departRoleUserMapper.delete((Wrapper)new LambdaQueryWrapper().in(SysDepartRoleUser::getDroleId, roleIdList));
        }
        return ok;
    }

    private void checkChildrenExists(String id, List<String> idList) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getParentId, (Object)id);
        List departList = this.list((Wrapper)query);
        if (departList != null && departList.size() > 0) {
            for (SysDepart depart : departList) {
                idList.add(depart.getId());
                this.checkChildrenExists(depart.getId(), idList);
            }
        }
    }

    @Override
    public List<SysDepart> queryUserDeparts(String userId) {
        return ((SysDepartMapper)this.baseMapper).queryUserDeparts(userId);
    }

    @Override
    public List<SysDepart> queryDepartsByUsername(String username) {
        return ((SysDepartMapper)this.baseMapper).queryDepartsByUsername(username);
    }

    @Override
    public List<String> queryDepartsByUserId(String userId) {
        List<String> list = ((SysDepartMapper)this.baseMapper).queryDepartsByUserId(userId);
        return list;
    }

    private String[] getMyDeptParentOrgCode(String departIds) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        if (oConvertUtils.isNotEmpty((Object)departIds)) {
            query.in(SysDepart::getId, Arrays.asList(departIds.split(",")));
        }
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            query.eq(SysDepart::getTenantId, (Object)oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        query.orderByAsc(SysDepart::getOrgCode);
        List list = this.list((Wrapper)query);
        if (list == null || list.size() == 0) {
            return null;
        }
        String orgCode = this.getMyDeptParentNode(list);
        String[] codeArr = orgCode.split(",");
        return codeArr;
    }

    private String getMyDeptParentNode(List<SysDepart> list) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        for (SysDepart dept : list) {
            String code = dept.getOrgCode().substring(0, 3);
            if (map.containsKey(code)) {
                String mapCode = (String)map.get(code) + "," + dept.getOrgCode();
                map.put(code, mapCode);
                continue;
            }
            map.put(code, dept.getOrgCode());
        }
        StringBuffer parentOrgCode = new StringBuffer();
        for (String str : map.values()) {
            String[] arrStr = str.split(",");
            parentOrgCode.append(",").append(this.getMinLengthNode(arrStr));
        }
        return parentOrgCode.substring(1);
    }

    private String getMinLengthNode(String[] str) {
        int min = str[0].length();
        StringBuilder orgCodeBuilder = new StringBuilder(str[0]);
        for (int i = 1; i < str.length; ++i) {
            if (str[i].length() > min) continue;
            min = str[i].length();
            orgCodeBuilder.append(",").append(str[i]);
        }
        return orgCodeBuilder.toString();
    }

    @Override
    public List<SysDepartTreeModel> queryTreeByKeyWord(String keyWord) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        query.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)query);
        List<SysDepartTreeModel> listResult = FindsDepartsChildrenUtil.wrapTreeDataToTreeList(list);
        ArrayList<SysDepartTreeModel> treelist = new ArrayList<SysDepartTreeModel>();
        if (!StringUtils.isNotBlank((String)keyWord)) {
            return listResult;
        }
        this.getTreeByKeyWord(keyWord, listResult, treelist);
        return treelist;
    }

    @Override
    public List<SysDepartTreeModel> queryTreeListByPid(String parentId, String ids, String primaryKey) {
        Consumer<LambdaQueryWrapper> square = i -> {
            if (oConvertUtils.isNotEmpty((Object)ids)) {
                if ("orgCode".equals(primaryKey)) {
                    i.in(SysDepart::getOrgCode, (Object[])ids.split(","));
                } else {
                    i.in(SysDepart::getId, (Object[])ids.split(","));
                }
            } else if (oConvertUtils.isEmpty((Object)parentId)) {
                i.and(q -> ((LambdaQueryWrapper)((LambdaQueryWrapper)q.isNull(true, SysDepart::getParentId)).or()).eq(true, SysDepart::getParentId, (Object)""));
            } else {
                i.eq(true, SysDepart::getParentId, (Object)parentId);
            }
        };
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            lqw.eq(SysDepart::getTenantId, (Object)oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0));
        }
        lqw.eq(true, SysDepart::getDelFlag, (Object)CommonConstant.DEL_FLAG_0.toString());
        lqw.func(square);
        lqw.orderByAsc(SysDepart::getDepartOrder);
        List list = this.list((Wrapper)lqw);
        this.setUserIdsByDepList(list);
        ArrayList<SysDepartTreeModel> records = new ArrayList<SysDepartTreeModel>();
        for (int i2 = 0; i2 < list.size(); ++i2) {
            SysDepart depart = (SysDepart)list.get(i2);
            SysDepartTreeModel treeModel = new SysDepartTreeModel(depart);
            records.add(treeModel);
        }
        return records;
    }

    @Override
    public JSONObject queryAllParentIdByDepartId(String departId) {
        JSONObject result = new JSONObject();
        for (String id : departId.split(",")) {
            JSONObject all = this.queryAllParentId("id", id);
            result.put(id, (Object)all);
        }
        return result;
    }

    @Override
    public JSONObject queryAllParentIdByOrgCode(String orgCode) {
        JSONObject result = new JSONObject();
        for (String code : orgCode.split(",")) {
            JSONObject all = this.queryAllParentId("org_code", code);
            result.put(code, (Object)all);
        }
        return result;
    }

    private JSONObject queryAllParentId(String fieldName, String value) {
        JSONObject data = new JSONObject();
        data.put("parentIds", (Object)new JSONArray());
        data.put("parentMap", (Object)new JSONObject());
        this.queryAllParentIdRecursion(fieldName, value, data);
        return data;
    }

    private void queryAllParentIdRecursion(String fieldName, String value, JSONObject data) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)fieldName, (Object)value);
        SysDepart depart = (SysDepart)super.getOne((Wrapper)queryWrapper);
        if (depart != null) {
            data.getJSONArray("parentIds").add(0, (Object)depart.getId());
            data.getJSONObject("parentMap").put(depart.getId(), (Object)depart);
            if (oConvertUtils.isNotEmpty((Object)depart.getParentId())) {
                this.queryAllParentIdRecursion("id", depart.getParentId(), data);
            }
        }
    }

    @Override
    public SysDepart queryCompByOrgCode(String orgCode) {
        int length = 3;
        String compyOrgCode = orgCode.substring(0, length);
        return ((SysDepartMapper)this.baseMapper).queryCompByOrgCode(compyOrgCode);
    }

    @Override
    public List<SysDepart> queryDeptByPid(String pid) {
        return ((SysDepartMapper)this.baseMapper).queryDeptByPid(pid);
    }

    public void getTreeByKeyWord(String keyWord, List<SysDepartTreeModel> allResult, List<SysDepartTreeModel> newResult) {
        for (SysDepartTreeModel model : allResult) {
            if (model.getDepartName().contains(keyWord)) {
                newResult.add(model);
                continue;
            }
            if (model.getChildren() == null) continue;
            this.getTreeByKeyWord(keyWord, model.getChildren(), newResult);
        }
    }

    public void addDepartByUserIds(SysDepart sysDepart, String userIds) {
        String[] userIdArray;
        String departId = sysDepart.getId();
        for (String userId : userIdArray = userIds.split(",")) {
            SysUser sysUser = (SysUser)this.sysUserMapper.selectById((Serializable)((Object)userId));
            if (oConvertUtils.isNotEmpty((Object)sysUser.getDepartIds())) {
                if (!sysUser.getDepartIds().contains(departId)) {
                    sysUser.setDepartIds(sysUser.getDepartIds() + "," + departId);
                }
            } else {
                sysUser.setDepartIds(departId);
            }
            sysUser.setUserIdentity(CommonConstant.USER_IDENTITY_2);
            this.sysUserMapper.updateById(sysUser);
            List<SysUserDepart> userDepartList = this.userDepartMapper.getUserDepartByUid(userId);
            boolean isExistDepId = userDepartList.stream().anyMatch(item -> departId.equals(item.getDepId()));
            if (isExistDepId) continue;
            this.userDepartMapper.insert(new SysUserDepart(userId, departId));
        }
    }

    private void updateChargeDepart(SysDepart sysDepart) {
        String directorIds = sysDepart.getDirectorUserIds();
        String oldDirectorIds = sysDepart.getOldDirectorUserIds();
        String departId = sysDepart.getId();
        if (oConvertUtils.isEmpty((Object)directorIds)) {
            this.deleteChargeDepId(departId, null);
        } else if (oConvertUtils.isNotEmpty((Object)directorIds) && oConvertUtils.isEmpty((Object)oldDirectorIds)) {
            this.addDepartByUserIds(sysDepart, directorIds);
        } else {
            List userIdList = Arrays.stream(oldDirectorIds.split(",")).filter(item -> !directorIds.contains((CharSequence)item)).collect(Collectors.toList());
            for (String userId : userIdList) {
                this.deleteChargeDepId(departId, userId);
            }
            String addUserIds = Arrays.stream(directorIds.split(",")).filter(item -> !oldDirectorIds.contains((CharSequence)item)).collect(Collectors.joining(","));
            if (oConvertUtils.isNotEmpty((Object)addUserIds)) {
                this.addDepartByUserIds(sysDepart, addUserIds);
            }
        }
    }

    private void deleteChargeDepId(String departId, String userId) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.like(SysUser::getDepartIds, (Object)departId);
        if (oConvertUtils.isNotEmpty((Object)userId)) {
            query.eq(SysUser::getId, (Object)userId);
        }
        List userList = this.sysUserMapper.selectList((Wrapper)query);
        for (SysUser sysUser : userList) {
            String departIds = sysUser.getDepartIds();
            ArrayList<String> list = new ArrayList<String>(Arrays.asList(departIds.split(",")));
            list.remove(departId);
            String newDepartIds = String.join((CharSequence)",", list);
            sysUser.setDepartIds(newDepartIds);
            this.sysUserMapper.updateById(sysUser);
        }
    }

    private void setUserIdsByDepList(List<SysDepart> departList) {
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.isNotNull(SysUser::getDepartIds);
        List users = this.sysUserMapper.selectList((Wrapper)query);
        HashMap<String, String> map = new HashMap<String, String>(5);
        for (SysUser user : users) {
            String[] departIdArray;
            String departIds = user.getDepartIds();
            for (String departId : departIdArray = departIds.split(",")) {
                if (map.containsKey(departId)) {
                    String userIds = map.get(departId) + "," + user.getId();
                    map.put(departId, userIds);
                    continue;
                }
                map.put(departId, user.getId());
            }
        }
        for (SysDepart sysDepart : departList) {
            if (!map.containsKey(sysDepart.getId())) continue;
            sysDepart.setDirectorUserIds(map.get(sysDepart.getId()).toString());
        }
    }

    @Override
    public List<SysDepart> getMyDepartList() {
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = user.getId();
        ArrayList<String> list = new ArrayList<String>();
        List<SysDepart> sysDepartList = ((SysDepartMapper)this.baseMapper).queryUserDeparts(userId);
        for (SysDepart sysDepart : sysDepartList) {
            String orgCode = sysDepart.getOrgCode();
            if (3 > orgCode.length()) continue;
            int length = 3;
            String companyOrgCode = orgCode.substring(0, length);
            list.add(companyOrgCode);
        }
        if (oConvertUtils.isNotEmpty(list)) {
            LambdaQueryWrapper query = new LambdaQueryWrapper();
            query.select((Object[])new SFunction[]{SysDepart::getDepartName, SysDepart::getId, SysDepart::getOrgCode});
            query.eq(SysDepart::getDelFlag, (Object)String.valueOf(CommonConstant.DEL_FLAG_0));
            query.in(SysDepart::getOrgCode, list);
            return ((SysDepartMapper)this.baseMapper).selectList((Wrapper)query);
        }
        return null;
    }

    @Override
    public void deleteDepart(String id) {
        this.setIzLeaf(id);
        this.delete(id);
        LambdaQueryWrapper query = (LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysUserDepart::getDepId, (Object)id);
        this.userDepartMapper.delete((Wrapper)query);
    }

    @Override
    public List<SysDepartTreeModel> queryBookDepTreeSync(String parentId, Integer tenantId, String departName) {
        List<SysDepart> list = this.departMapper.queryBookDepTreeSync(parentId, tenantId, departName);
        ArrayList<SysDepartTreeModel> records = new ArrayList<SysDepartTreeModel>();
        for (int i = 0; i < list.size(); ++i) {
            SysDepart depart = list.get(i);
            SysDepartTreeModel treeModel = new SysDepartTreeModel(depart);
            records.add(treeModel);
        }
        return records;
    }

    @Override
    public SysDepart getDepartById(String id) {
        return this.departMapper.getDepartById(id);
    }

    @Override
    public IPage<SysDepart> getMaxCodeDepart(Page<SysDepart> page, String parentId) {
        return page.setRecords(this.departMapper.getMaxCodeDepart(page, parentId));
    }

    @Override
    public void updateIzLeaf(String id, Integer izLeaf) {
        this.departMapper.setMainLeaf(id, izLeaf);
    }

    private void setIzLeaf(String id) {
        Long count;
        SysDepart depart = this.getDepartById(id);
        String parentId = depart.getParentId();
        if (oConvertUtils.isNotEmpty((Object)parentId) && (count = Long.valueOf(this.count((Wrapper)new QueryWrapper().lambda().eq(SysDepart::getParentId, (Object)parentId)))) == 1L) {
            this.departMapper.setMainLeaf(parentId, CommonConstant.IS_LEAF);
        }
    }

    @Override
    public List<ExportDepartVo> getExcelDepart(int tenantId) {
        List<ExportDepartVo> parentDepart = this.departMapper.getDepartList("", tenantId);
        ArrayList<ExportDepartVo> childrenDepart = new ArrayList<ExportDepartVo>();
        ArrayList<ExportDepartVo> exportDepartVoList = new ArrayList<ExportDepartVo>();
        ArrayList<String> departIdList = new ArrayList<String>();
        for (ExportDepartVo departVo : parentDepart) {
            departIdList.add(departVo.getId());
            departVo.setDepartNameUrl(departVo.getDepartName());
            exportDepartVoList.add(departVo);
            ArrayList<String> path = new ArrayList<String>();
            path.add(departVo.getDepartName());
            this.findPath(departVo, path, tenantId, childrenDepart, departIdList);
            path.clear();
        }
        exportDepartVoList.addAll(childrenDepart);
        childrenDepart.clear();
        departIdList.clear();
        return exportDepartVoList;
    }

    private void findPath(ExportDepartVo departVo, List<String> path, Integer tenantId, List<ExportDepartVo> childrenDepart, List<String> departIdList) {
        List<ExportDepartVo> departList = this.departMapper.getDepartList(departVo.getId(), tenantId);
        if (departList == null || departList.size() <= 0) {
            if (!departIdList.contains(departVo.getId())) {
                departVo.setDepartNameUrl(String.join((CharSequence)"/", path));
                childrenDepart.add(departVo);
            }
            return;
        }
        for (int i = 0; i < departList.size(); ++i) {
            ExportDepartVo exportDepartVo = departList.get(i);
            ArrayList<String> cPath = new ArrayList<String>();
            cPath.addAll(path);
            cPath.add(exportDepartVo.getDepartName());
            if (!departIdList.contains(departVo.getId())) {
                departIdList.add(departVo.getId());
                departVo.setDepartNameUrl(String.join((CharSequence)"/", path));
                childrenDepart.add(departVo);
            }
            this.findPath(exportDepartVo, cPath, tenantId, childrenDepart, departIdList);
        }
    }

    @Override
    public void importExcel(List<ExportDepartVo> listSysDeparts, List<String> errorMessageList) {
        int num = 0;
        int tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        Collections.sort(listSysDeparts, new Comparator<ExportDepartVo>(){

            @Override
            public int compare(ExportDepartVo o1, ExportDepartVo o2) {
                if (oConvertUtils.isNotEmpty((Object)o1.getDepartNameUrl()) && oConvertUtils.isNotEmpty((Object)o2.getDepartNameUrl())) {
                    int oldLength = o1.getDepartNameUrl().split("/").length;
                    int newLength = o2.getDepartNameUrl().split("/").length;
                    return oldLength - newLength;
                }
                return 0;
            }
        });
        HashMap<String, SysDepart> departMap = new HashMap<String, SysDepart>();
        for (ExportDepartVo exportDepartVo : listSysDeparts) {
            SysDepart sysDepart = new SysDepart();
            int codeLength = 3;
            Boolean izExport = false;
            try {
                izExport = this.addDepartByName(exportDepartVo.getDepartNameUrl(), exportDepartVo.getDepartName(), sysDepart, errorMessageList, tenantId, departMap, num);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (izExport.booleanValue()) {
                sysDepart.setOrgType(sysDepart.getOrgCode().length() / codeLength + "");
                sysDepart.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
                sysDepart.setOrgCategory("1");
                sysDepart.setTenantId(tenantId);
                ImportExcelUtil.importDateSaveOne((Object)sysDepart, ISysDepartService.class, errorMessageList, (int)num, (String)"uniq_depart_org_code");
                departMap.put(exportDepartVo.getDepartNameUrl(), sysDepart);
            }
            ++num;
        }
    }

    private Boolean addDepartByName(String departNameUrl, String departName, SysDepart sysDepart, List<String> errorMessageList, Integer tenantId, Map<String, SysDepart> departMap, int num) {
        int lineNumber = num + 1;
        if (oConvertUtils.isEmpty((Object)departNameUrl) && oConvertUtils.isEmpty((Object)departName)) {
            errorMessageList.add("\u7b2c " + lineNumber + " \u884c\uff1a\u8bb0\u5f55\u90e8\u95e8\u8def\u5f84\u6216\u8005\u90e8\u95e8\u540d\u79f0\u4e3a\u7a7a\u7981\u6b62\u5bfc\u5165");
            return false;
        }
        String name = "";
        name = departNameUrl.contains("/") ? departNameUrl.substring(departNameUrl.lastIndexOf("/") + 1) : departNameUrl;
        if (!name.equals(departName)) {
            errorMessageList.add("\u7b2c " + lineNumber + " \u884c\uff1a\u8bb0\u5f55\u90e8\u95e8\u8def\u5f84:\u201d" + departNameUrl + "\u201c\u548c\u90e8\u95e8\u540d\u79f0\uff1a\u201c" + departName + "\u201c\u4e0d\u4e00\u81f4\uff0c\u8bf7\u68c0\u67e5\uff01");
            return false;
        }
        String parentId = "";
        if (departNameUrl.contains("/")) {
            String departNames = departNameUrl.substring(0, departNameUrl.lastIndexOf("/"));
            if (departMap.containsKey(departNames)) {
                SysDepart depart = departMap.get(departNames);
                if (null != depart) {
                    parentId = depart.getId();
                }
            } else {
                String[] departNameUrls = departNameUrl.split("/");
                String departUrlName = departNameUrls[0];
                int count = 0;
                SysDepart depart = new SysDepart();
                depart.setId("");
                String parentIdByName = this.getDepartListByName(departUrlName, tenantId, depart, departNameUrls, count, departNameUrls.length - 1, name, departMap);
                if (oConvertUtils.isNotEmpty((Object)parentIdByName)) {
                    parentId = parentIdByName;
                } else {
                    errorMessageList.add("\u7b2c " + lineNumber + " \u884c\uff1a\u8bb0\u5f55\u90e8\u95e8\u540d\u79f0\u201c" + departName + "\u201d\u4e0a\u7ea7\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
                    return false;
                }
            }
        }
        SysDepart parentDept = null;
        List<SysDepart> sysDepartList = this.departMapper.getDepartByName(departName, tenantId, parentId);
        if (CollectionUtil.isNotEmpty(sysDepartList)) {
            parentDept = sysDepartList.get(0);
        }
        if (null != parentDept) {
            errorMessageList.add("\u7b2c " + lineNumber + " \u884c\uff1a\u8bb0\u5f55\u90e8\u95e8\u540d\u79f0\u201c" + departName + "\u201d\u5df2\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
            return false;
        }
        Page page = new Page(1L, 1L);
        List<SysDepart> records = this.departMapper.getMaxCodeDepart((Page<SysDepart>)page, parentId);
        String newOrgCode = "";
        if (CollectionUtil.isNotEmpty(records)) {
            newOrgCode = YouBianCodeUtil.getNextYouBianCode((String)records.get(0).getOrgCode());
        } else if (oConvertUtils.isNotEmpty((Object)parentId)) {
            SysDepart departById = this.departMapper.getDepartById(parentId);
            newOrgCode = YouBianCodeUtil.getSubYouBianCode((String)departById.getOrgCode(), null);
        } else {
            newOrgCode = YouBianCodeUtil.getNextYouBianCode(null);
        }
        if (oConvertUtils.isNotEmpty((Object)parentId)) {
            this.updateIzLeaf(parentId, CommonConstant.NOT_LEAF);
            sysDepart.setParentId(parentId);
        }
        sysDepart.setOrgCode(newOrgCode);
        sysDepart.setDepartName(departName);
        return true;
    }

    private String getDepartListByName(String departName, Integer tenantId, SysDepart sysDepart, String[] departNameUrls, int count, int departNum, String name, Map<String, SysDepart> departMap) {
        SysDepart parentDept = null;
        List<SysDepart> departList = this.departMapper.getDepartByName(departName, tenantId, sysDepart.getId());
        if (CollectionUtil.isNotEmpty(departList)) {
            parentDept = departList.get(0);
        }
        name = oConvertUtils.isNotEmpty((Object)name) ? name + "/" + departName : departName;
        if (null != parentDept) {
            if (!departMap.containsKey(name)) {
                departMap.put(name, parentDept);
            }
            if (parentDept.getDepartName().equals(departNameUrls[count])) {
                if (++count == departNum) {
                    return parentDept.getId();
                }
                return this.getDepartListByName(departNameUrls[count], tenantId, parentDept, departNameUrls, count, departNum, name, departMap);
            }
            return "";
        }
        return "";
    }

    private void setParentDepartIzLeaf(List<String> parentIdList) {
        if (CollectionUtil.isNotEmpty(parentIdList)) {
            for (String parentId : parentIdList) {
                LambdaQueryWrapper query = new LambdaQueryWrapper();
                query.eq(SysDepart::getParentId, (Object)parentId);
                Long count = this.departMapper.selectCount((Wrapper)query);
                if (count != 0L) continue;
                this.departMapper.setMainLeaf(parentId, CommonConstant.IS_LEAF);
            }
        }
    }

    @Override
    public List<SysDepartExportVo> getExportDepart(Integer tenantId, List<String> idList) {
        List<SysDepartExportVo> parentDepart = this.departMapper.getSysDepartList("", tenantId, idList);
        ArrayList<SysDepartExportVo> childrenDepart = new ArrayList<SysDepartExportVo>();
        ArrayList<SysDepartExportVo> exportDepartVoList = new ArrayList<SysDepartExportVo>();
        ArrayList<String> departIdList = new ArrayList<String>();
        for (SysDepartExportVo sysDepart : parentDepart) {
            departIdList.add(sysDepart.getId());
            sysDepart.setDepartNameUrl(sysDepart.getDepartName());
            exportDepartVoList.add(sysDepart);
            ArrayList<String> path = new ArrayList<String>();
            path.add(sysDepart.getDepartName());
            this.findSysDepartPath(sysDepart, path, tenantId, childrenDepart, departIdList, idList);
            path.clear();
        }
        exportDepartVoList.addAll(childrenDepart);
        childrenDepart.clear();
        departIdList.clear();
        return exportDepartVoList;
    }

    @Override
    public void importSysDepart(List<SysDepartExportVo> listSysDeparts, List<String> errorMessageList) {
        int num = 0;
        int tenantId = 0;
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            tenantId = oConvertUtils.getInt((String)TenantContext.getTenant(), (int)0);
        }
        Collections.sort(listSysDeparts, new Comparator<SysDepartExportVo>(){

            @Override
            public int compare(SysDepartExportVo o1, SysDepartExportVo o2) {
                if (oConvertUtils.isNotEmpty((Object)o1.getDepartNameUrl()) && oConvertUtils.isNotEmpty((Object)o2.getDepartNameUrl())) {
                    int oldLength = o1.getDepartNameUrl().split("/").length;
                    int newLength = o2.getDepartNameUrl().split("/").length;
                    return oldLength - newLength;
                }
                return 0;
            }
        });
        HashMap<String, SysDepart> departMap = new HashMap<String, SysDepart>();
        int codeLength = 3;
        for (SysDepartExportVo departExportVo : listSysDeparts) {
            SysDepart sysDepart = new SysDepart();
            boolean izExport = false;
            try {
                izExport = this.addDepartByName(departExportVo.getDepartNameUrl(), departExportVo.getDepartName(), sysDepart, errorMessageList, tenantId, departMap, num);
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (izExport) {
                if (oConvertUtils.isNotEmpty((Object)departExportVo.getOrgCode())) {
                    SysDepart depart = ((SysDepartMapper)this.baseMapper).queryCompByOrgCode(departExportVo.getOrgCode());
                    if (null != depart) {
                        if (oConvertUtils.isNotEmpty((Object)sysDepart.getParentId())) {
                            this.updateIzLeaf(sysDepart.getParentId(), CommonConstant.IS_LEAF);
                        }
                        errorMessageList.add("\u7b2c " + num + " \u884c\uff1a\u8bb0\u5f55\u90e8\u95e8\u540d\u79f0\u201c" + departExportVo.getDepartName() + "\u201d\u90e8\u95e8\u7f16\u7801\u91cd\u590d\uff0c\u8bf7\u68c0\u67e5\uff01");
                        continue;
                    }
                    String departNameUrl = departExportVo.getDepartNameUrl();
                    if (departNameUrl.contains("/") && !sysDepart.getOrgCode().equals(departExportVo.getOrgCode())) {
                        if (oConvertUtils.isNotEmpty((Object)sysDepart.getParentId())) {
                            this.updateIzLeaf(sysDepart.getParentId(), CommonConstant.IS_LEAF);
                        }
                        errorMessageList.add("\u7b2c " + num + " \u884c\uff1a\u8bb0\u5f55\u90e8\u95e8\u540d\u79f0\u201c" + departExportVo.getDepartName() + "\u201d\u90e8\u95e8\u7f16\u7801\u89c4\u5219\u4e0d\u5339\u914d\uff0c\u8bf7\u68c0\u67e5\uff01");
                        continue;
                    }
                    sysDepart.setOrgCode(departExportVo.getOrgCode());
                    if (oConvertUtils.isNotEmpty((Object)sysDepart.getParentId())) {
                        sysDepart.setOrgType("2");
                    } else {
                        sysDepart.setOrgType("1");
                    }
                } else {
                    sysDepart.setOrgType(sysDepart.getOrgCode().length() / codeLength + "");
                }
                sysDepart.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
                sysDepart.setDepartNameEn(departExportVo.getDepartNameEn());
                sysDepart.setDepartOrder(departExportVo.getDepartOrder());
                sysDepart.setOrgCategory(oConvertUtils.getString((String)departExportVo.getOrgCategory(), (String)"1"));
                sysDepart.setMobile(departExportVo.getMobile());
                sysDepart.setFax(departExportVo.getFax());
                sysDepart.setAddress(departExportVo.getAddress());
                sysDepart.setMemo(departExportVo.getMemo());
                ImportExcelUtil.importDateSaveOne((Object)sysDepart, ISysDepartService.class, errorMessageList, (int)num, (String)"uniq_depart_org_code");
                departMap.put(departExportVo.getDepartNameUrl(), sysDepart);
            }
            ++num;
        }
    }

    private void findSysDepartPath(SysDepartExportVo departVo, List<String> path, Integer tenantId, List<SysDepartExportVo> childrenDepart, List<String> departIdList, List<String> idList) {
        List<SysDepartExportVo> departList = this.departMapper.getSysDepartList(departVo.getId(), tenantId, idList);
        if (departList == null || departList.size() <= 0) {
            if (!departIdList.contains(departVo.getId())) {
                departVo.setDepartNameUrl(String.join((CharSequence)"/", path));
                childrenDepart.add(departVo);
            }
            return;
        }
        for (SysDepartExportVo exportDepartVo : departList) {
            ArrayList<String> cPath = new ArrayList<String>(path);
            cPath.add(exportDepartVo.getDepartName());
            if (!departIdList.contains(departVo.getId())) {
                departIdList.add(departVo.getId());
                departVo.setDepartNameUrl(String.join((CharSequence)"/", path));
                childrenDepart.add(departVo);
            }
            this.findSysDepartPath(exportDepartVo, cPath, tenantId, childrenDepart, departIdList, idList);
        }
    }
}

