/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.FillRuleUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.system.entity.SysCategory;
import org.jeecg.modules.system.mapper.SysCategoryMapper;
import org.jeecg.modules.system.model.TreeSelectModel;
import org.jeecg.modules.system.service.ISysCategoryService;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class SysCategoryServiceImpl
extends ServiceImpl<SysCategoryMapper, SysCategory>
implements ISysCategoryService {
    @Override
    public void addSysCategory(SysCategory sysCategory) {
        String categoryCode = "";
        String categoryPid = "0";
        String parentCode = null;
        if (oConvertUtils.isNotEmpty((Object)sysCategory.getPid()) && !"0".equals(categoryPid = sysCategory.getPid())) {
            SysCategory parent = (SysCategory)((SysCategoryMapper)this.baseMapper).selectById((Serializable)((Object)categoryPid));
            parentCode = parent.getCode();
            if (parent != null && !"1".equals(parent.getHasChild())) {
                parent.setHasChild("1");
                ((SysCategoryMapper)this.baseMapper).updateById(parent);
            }
        }
        JSONObject formData = new JSONObject();
        formData.put("pid", (Object)categoryPid);
        categoryCode = (String)FillRuleUtil.executeRule((String)"category_code_rule", (JSONObject)formData);
        sysCategory.setCode(categoryCode);
        sysCategory.setPid(categoryPid);
        ((SysCategoryMapper)this.baseMapper).insert(sysCategory);
    }

    @Override
    public void updateSysCategory(SysCategory sysCategory) {
        if (oConvertUtils.isEmpty((Object)sysCategory.getPid())) {
            sysCategory.setPid("0");
        } else {
            SysCategory parent = (SysCategory)((SysCategoryMapper)this.baseMapper).selectById((Serializable)((Object)sysCategory.getPid()));
            if (parent != null && !"1".equals(parent.getHasChild())) {
                parent.setHasChild("1");
                ((SysCategoryMapper)this.baseMapper).updateById(parent);
            }
        }
        ((SysCategoryMapper)this.baseMapper).updateById(sysCategory);
    }

    @Override
    public List<TreeSelectModel> queryListByCode(String pcode) throws JeecgBootException {
        String pid = "0";
        if (oConvertUtils.isNotEmpty((Object)pcode)) {
            List list = ((SysCategoryMapper)this.baseMapper).selectList((Wrapper)new LambdaQueryWrapper().eq(SysCategory::getCode, (Object)pcode));
            if (list == null || list.size() == 0) {
                throw new JeecgBootException("\u8be5\u7f16\u7801\u3010" + pcode + "\u3011\u4e0d\u5b58\u5728\uff0c\u8bf7\u6838\u5b9e!");
            }
            if (list.size() > 1) {
                throw new JeecgBootException("\u8be5\u7f16\u7801\u3010" + pcode + "\u3011\u5b58\u5728\u591a\u4e2a\uff0c\u8bf7\u6838\u5b9e!");
            }
            pid = ((SysCategory)list.get(0)).getId();
        }
        return ((SysCategoryMapper)this.baseMapper).queryListByPid(pid, null);
    }

    @Override
    public List<TreeSelectModel> queryListByPid(String pid) {
        if (oConvertUtils.isEmpty((Object)pid)) {
            pid = "0";
        }
        return ((SysCategoryMapper)this.baseMapper).queryListByPid(pid, null);
    }

    @Override
    public List<TreeSelectModel> queryListByPid(String pid, Map<String, String> condition) {
        if (oConvertUtils.isEmpty((Object)pid)) {
            pid = "0";
        }
        return ((SysCategoryMapper)this.baseMapper).queryListByPid(pid, condition);
    }

    @Override
    public String queryIdByCode(String code) {
        return ((SysCategoryMapper)this.baseMapper).queryIdByCode(code);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteSysCategory(String ids) {
        String allIds = this.queryTreeChildIds(ids);
        String pids = this.queryTreePids(ids);
        ((SysCategoryMapper)this.baseMapper).deleteBatchIds(Arrays.asList(allIds.split(",")));
        if (oConvertUtils.isNotEmpty((Object)pids)) {
            LambdaUpdateWrapper updateWrapper = (LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().in(SysCategory::getId, Arrays.asList(pids.split(",")))).set(SysCategory::getHasChild, (Object)"0");
            this.update((Wrapper)updateWrapper);
        }
    }

    private String queryTreeChildIds(String ids) {
        String[] idArr = ids.split(",");
        StringBuffer sb = new StringBuffer();
        for (String pidVal : idArr) {
            if (pidVal == null || sb.toString().contains(pidVal)) continue;
            if (sb.toString().length() > 0) {
                sb.append(",");
            }
            sb.append(pidVal);
            this.getTreeChildIds(pidVal, sb);
        }
        return sb.toString();
    }

    private String queryTreePids(String ids) {
        String[] idArr;
        StringBuffer sb = new StringBuffer();
        for (String id : idArr = ids.split(",")) {
            boolean flag;
            if (id == null) continue;
            SysCategory category = (SysCategory)((SysCategoryMapper)this.baseMapper).selectById((Serializable)((Object)id));
            String metaPid = category.getPid();
            LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
            queryWrapper.eq(SysCategory::getPid, (Object)metaPid);
            queryWrapper.notIn(SysCategory::getId, Arrays.asList(idArr));
            List dataList = ((SysCategoryMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
            boolean bl = flag = (dataList == null || dataList.size() == 0) && !Arrays.asList(idArr).contains(metaPid) && !sb.toString().contains(metaPid);
            if (!flag) continue;
            sb.append(metaPid).append(",");
        }
        if (sb.toString().endsWith(",")) {
            sb = sb.deleteCharAt(sb.length() - 1);
        }
        return sb.toString();
    }

    private StringBuffer getTreeChildIds(String pidVal, StringBuffer sb) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysCategory::getPid, (Object)pidVal);
        List dataList = ((SysCategoryMapper)this.baseMapper).selectList((Wrapper)queryWrapper);
        if (dataList != null && dataList.size() > 0) {
            for (SysCategory category : dataList) {
                if (!sb.toString().contains(category.getId())) {
                    sb.append(",").append(category.getId());
                }
                this.getTreeChildIds(category.getId(), sb);
            }
        }
        return sb;
    }

    @Override
    public List<String> loadDictItem(String ids) {
        return this.loadDictItem(ids, true);
    }

    @Override
    public List<String> loadDictItem(String ids, boolean delNotExist) {
        ArrayList<String> textList;
        String[] idArray = ids.split(",");
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.in(SysCategory::getId, Arrays.asList(idArray));
        List list = super.list((Wrapper)query);
        if (delNotExist) {
            textList = list.stream().map(SysCategory::getName).collect(Collectors.toList());
        } else {
            textList = new ArrayList();
            for (String id : idArray) {
                List res = list.stream().filter(i -> id.equals(i.getId())).collect(Collectors.toList());
                textList.add(res.size() > 0 ? ((SysCategory)res.get(0)).getName() : id);
            }
        }
        return textList;
    }

    @Override
    public List<String> loadDictItemByNames(String names, boolean delNotExist) {
        List<String> nameList = Arrays.asList(names.split(","));
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.select((Object[])new SFunction[]{SysCategory::getId, SysCategory::getName});
        query.in(SysCategory::getName, nameList);
        List list = super.list((Wrapper)query);
        return nameList.stream().map(name -> {
            SysCategory res = list.stream().filter(i -> name.equals(i.getName())).findFirst().orElse(null);
            if (res == null) {
                return delNotExist ? null : name;
            }
            return res.getId();
        }).filter(Objects::nonNull).collect(Collectors.toList());
    }
}

