/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.google.common.base.Joiner;
import freemarker.core.TemplateClassResolver;
import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.sql.DataSource;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.dto.DataLogDTO;
import org.jeecg.common.api.dto.OnlineAuthDTO;
import org.jeecg.common.api.dto.message.BusMessageDTO;
import org.jeecg.common.api.dto.message.BusTemplateMessageDTO;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.dto.message.TemplateDTO;
import org.jeecg.common.api.dto.message.TemplateMessageDTO;
import org.jeecg.common.aspect.UrlMatchEnum;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.EmailTemplateEnum;
import org.jeecg.common.constant.enums.MessageTypeEnum;
import org.jeecg.common.constant.enums.SysAnnmentTypeEnum;
import org.jeecg.common.desensitization.util.SensitiveInfoUtil;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.query.QueryCondition;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.vo.ComboModel;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.system.vo.DynamicDataSourceModel;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.system.vo.SysCategoryModel;
import org.jeecg.common.system.vo.SysDepartModel;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.system.vo.UserAccountInfo;
import org.jeecg.common.util.HTMLUtils;
import org.jeecg.common.util.dynamic.db.FreemarkerParseFactory;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.firewall.SqlInjection.IDictTableWhiteListHandler;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.message.entity.SysMessageTemplate;
import org.jeecg.modules.message.handle.impl.DdSendMsgHandle;
import org.jeecg.modules.message.handle.impl.EmailSendMsgHandle;
import org.jeecg.modules.message.handle.impl.QywxSendMsgHandle;
import org.jeecg.modules.message.handle.impl.SystemSendMsgHandle;
import org.jeecg.modules.message.service.ISysMessageTemplateService;
import org.jeecg.modules.message.websocket.WebSocket;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.entity.SysDataLog;
import org.jeecg.modules.system.entity.SysDataSource;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysDict;
import org.jeecg.modules.system.entity.SysPermission;
import org.jeecg.modules.system.entity.SysPermissionDataRule;
import org.jeecg.modules.system.entity.SysRole;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.entity.SysUserDepart;
import org.jeecg.modules.system.entity.SysUserPosition;
import org.jeecg.modules.system.entity.SysUserRole;
import org.jeecg.modules.system.mapper.SysAnnouncementMapper;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.mapper.SysCategoryMapper;
import org.jeecg.modules.system.mapper.SysDepartMapper;
import org.jeecg.modules.system.mapper.SysPermissionMapper;
import org.jeecg.modules.system.mapper.SysRoleMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.mapper.SysUserRoleMapper;
import org.jeecg.modules.system.service.ISysCategoryService;
import org.jeecg.modules.system.service.ISysDataLogService;
import org.jeecg.modules.system.service.ISysDataSourceService;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysDictService;
import org.jeecg.modules.system.service.ISysPermissionDataRuleService;
import org.jeecg.modules.system.service.ISysRoleService;
import org.jeecg.modules.system.service.ISysUserDepartService;
import org.jeecg.modules.system.service.ISysUserPositionService;
import org.jeecg.modules.system.service.ISysUserRoleService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.ISysUserTenantService;
import org.jeecg.modules.system.service.impl.ThirdAppDingtalkServiceImpl;
import org.jeecg.modules.system.service.impl.ThirdAppWechatEnterpriseServiceImpl;
import org.jeecg.modules.system.util.SecurityUtil;
import org.jeecg.modules.system.vo.lowapp.SysDictVo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;
import org.springframework.util.AntPathMatcher;
import org.springframework.util.CollectionUtils;

@Service
public class SysBaseApiImpl
implements ISysBaseAPI {
    private static final Logger log = LoggerFactory.getLogger(SysBaseApiImpl.class);
    private static String DB_TYPE = "";
    @Autowired
    private ISysMessageTemplateService sysMessageTemplateService;
    @Resource
    private SysUserMapper userMapper;
    @Resource
    private SysUserRoleMapper sysUserRoleMapper;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysDictService sysDictService;
    @Resource
    private SysAnnouncementMapper sysAnnouncementMapper;
    @Resource
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;
    @Resource
    private WebSocket webSocket;
    @Resource
    private SysRoleMapper roleMapper;
    @Resource
    private SysDepartMapper departMapper;
    @Resource
    private SysCategoryMapper categoryMapper;
    @Autowired
    private ISysDataSourceService dataSourceService;
    @Autowired
    private ISysUserDepartService sysUserDepartService;
    @Resource
    private SysPermissionMapper sysPermissionMapper;
    @Autowired
    private ISysPermissionDataRuleService sysPermissionDataRuleService;
    @Autowired
    private ThirdAppWechatEnterpriseServiceImpl wechatEnterpriseService;
    @Autowired
    private ThirdAppDingtalkServiceImpl dingtalkService;
    @Autowired
    ISysCategoryService sysCategoryService;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysDataLogService sysDataLogService;
    @Autowired
    private ISysRoleService sysRoleService;
    @Autowired
    private ISysUserTenantService sysUserTenantService;
    @Autowired
    private ISysUserRoleService sysUserRoleService;
    @Autowired
    private ISysUserPositionService sysUserPositionService;
    @Autowired
    private IDictTableWhiteListHandler dictTableWhiteListHandler;
    @Autowired
    private QywxSendMsgHandle qywxSendMsgHandle;
    @Autowired
    private SystemSendMsgHandle systemSendMsgHandle;
    @Autowired
    private EmailSendMsgHandle emailSendMsgHandle;
    @Autowired
    private DdSendMsgHandle ddSendMsgHandle;

    public LoginUser getUserByName(String username) {
        if (oConvertUtils.isEmpty((Object)username)) {
            return null;
        }
        LoginUser user = this.sysUserService.getEncodeUserInfo(username);
        try {
            SensitiveInfoUtil.handlerObject((Object)user, (boolean)false);
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        return user;
    }

    @Cacheable(cacheNames={"sys:cache:user:id_mapping"}, key="#username")
    public String getUserIdByName(String username) {
        if (oConvertUtils.isEmpty((Object)username)) {
            return null;
        }
        String userId = this.userMapper.getUserIdByName(username);
        return userId;
    }

    public String translateDictFromTable(String table, String text, String code, String key) {
        return this.sysDictService.queryTableDictTextByKey(table, text, code, key);
    }

    public String translateDict(String code, String key) {
        return this.sysDictService.queryDictTextByKey(code, key);
    }

    public List<SysPermissionDataRuleModel> queryPermissionDataRule(String component, String requestPath, String username) {
        LambdaQueryWrapper query;
        List currentSyspermission = null;
        if (oConvertUtils.isNotEmpty((Object)component)) {
            query = new LambdaQueryWrapper();
            query.eq(SysPermission::getDelFlag, (Object)0);
            query.eq(SysPermission::getComponent, (Object)component);
            currentSyspermission = this.sysPermissionMapper.selectList((Wrapper)query);
        } else {
            String regUrl;
            query = new LambdaQueryWrapper();
            query.eq(SysPermission::getMenuType, (Object)2);
            query.eq(SysPermission::getDelFlag, (Object)0);
            List<String> allPossiblePaths = this.getOnlinePossiblePaths(requestPath);
            log.info("\u83b7\u53d6\u7684\u83dc\u5355\u5730\u5740= {}", (Object)allPossiblePaths.toString());
            if (allPossiblePaths.size() == 1) {
                query.eq(SysPermission::getUrl, (Object)requestPath);
            } else {
                query.in(SysPermission::getUrl, allPossiblePaths);
            }
            currentSyspermission = this.sysPermissionMapper.selectList((Wrapper)query);
            if (currentSyspermission == null || currentSyspermission.size() == 0) {
                String userMatchUrl = UrlMatchEnum.getMatchResultByUrl((String)requestPath);
                LambdaQueryWrapper queryQserMatch = new LambdaQueryWrapper();
                queryQserMatch.eq(SysPermission::getDelFlag, (Object)0);
                queryQserMatch.eq(SysPermission::getUrl, (Object)userMatchUrl);
                if (oConvertUtils.isNotEmpty((Object)userMatchUrl)) {
                    currentSyspermission = this.sysPermissionMapper.selectList((Wrapper)queryQserMatch);
                }
            }
            if ((currentSyspermission == null || currentSyspermission.size() == 0) && (regUrl = this.getRegexpUrl(requestPath)) != null) {
                currentSyspermission = this.sysPermissionMapper.selectList((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(SysPermission::getMenuType, (Object)2)).eq(SysPermission::getUrl, (Object)regUrl)).eq(SysPermission::getDelFlag, (Object)0));
            }
        }
        if (currentSyspermission != null && currentSyspermission.size() > 0) {
            List<Object> dataRules = new ArrayList<SysPermissionDataRuleModel>();
            for (SysPermission sysPermission : currentSyspermission) {
                List<SysPermissionDataRule> temp = this.sysPermissionDataRuleService.queryPermissionDataRules(username, sysPermission.getId());
                if (temp == null || temp.size() <= 0) continue;
                dataRules = oConvertUtils.entityListToModelList(temp, SysPermissionDataRuleModel.class);
            }
            return dataRules;
        }
        return null;
    }

    private String getRegexpUrl(String url) {
        List<String> list = this.sysPermissionMapper.queryPermissionUrlWithStar();
        if (list != null && list.size() > 0) {
            Iterator<String> iterator = list.iterator();
            while (iterator.hasNext()) {
                AntPathMatcher matcher = new AntPathMatcher();
                String p = iterator.next();
                if (!matcher.match(p, url)) continue;
                return p;
            }
        }
        return null;
    }

    public SysUserCacheInfo getCacheUser(String username) {
        SysUserCacheInfo info = new SysUserCacheInfo();
        info.setOneDepart(true);
        LoginUser user = this.getUserByName(username);
        if (user == null) {
            return null;
        }
        info.setSysUserId(user.getId());
        info.setSysUserCode(user.getUsername());
        info.setSysUserName(user.getRealname());
        info.setSysOrgCode(user.getOrgCode());
        info.setSysOrgId(user.getOrgId());
        info.setSysRoleCode(user.getRoleCode());
        List<SysDepart> list = this.departMapper.queryUserDeparts(user.getId());
        ArrayList<String> sysMultiOrgCode = new ArrayList<String>();
        if (list != null && list.size() != 0) {
            if (list.size() == 1) {
                sysMultiOrgCode.add(list.get(0).getOrgCode());
            } else {
                info.setOneDepart(false);
                for (SysDepart dpt : list) {
                    sysMultiOrgCode.add(dpt.getOrgCode());
                }
            }
        }
        info.setSysMultiOrgCode(sysMultiOrgCode);
        return info;
    }

    public LoginUser getUserById(String id) {
        if (oConvertUtils.isEmpty((Object)id)) {
            return null;
        }
        LoginUser loginUser = new LoginUser();
        SysUser sysUser = (SysUser)this.userMapper.selectById((Serializable)((Object)id));
        if (sysUser == null) {
            return null;
        }
        BeanUtils.copyProperties((Object)sysUser, (Object)loginUser);
        loginUser.setPassword(null);
        loginUser.setRelTenantIds(null);
        loginUser.setDepartIds(null);
        return loginUser;
    }

    public List<String> getRolesByUsername(String username) {
        return this.sysUserRoleMapper.getRoleByUserName(username);
    }

    public List<String> getRolesByUserId(String userId) {
        return this.sysUserRoleMapper.getRoleCodeByUserId(userId);
    }

    public List<String> getDepartIdsByUsername(String username) {
        List<SysDepart> list = this.sysDepartService.queryDepartsByUsername(username);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (SysDepart depart : list) {
            result.add(depart.getId());
        }
        return result;
    }

    public List<String> getDepartIdsByUserId(String userId) {
        return this.sysDepartService.queryDepartsByUserId(userId);
    }

    public Set<String> getDepartParentIdsByUsername(String username) {
        List<SysDepart> list = this.sysDepartService.queryDepartsByUsername(username);
        HashSet<String> result = new HashSet<String>(list.size());
        for (SysDepart depart : list) {
            result.add(depart.getParentId());
        }
        return result;
    }

    public Set<String> getDepartParentIdsByDepIds(Set<String> depIds) {
        LambdaQueryWrapper departQuery = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysDepart::getId, depIds);
        List departList = this.departMapper.selectList((Wrapper)departQuery);
        if (CollectionUtils.isEmpty((Collection)departList)) {
            return null;
        }
        Set<String> parentIds = departList.stream().map(SysDepart::getParentId).collect(Collectors.toSet());
        return parentIds;
    }

    public List<String> getDepartNamesByUsername(String username) {
        List<SysDepart> list = this.sysDepartService.queryDepartsByUsername(username);
        ArrayList<String> result = new ArrayList<String>(list.size());
        for (SysDepart depart : list) {
            result.add(depart.getDepartName());
        }
        return result;
    }

    public DictModel getParentDepartId(String departId) {
        SysDepart depart = this.departMapper.getParentDepartId(departId);
        DictModel model = new DictModel(depart.getId(), depart.getParentId());
        return model;
    }

    @Cacheable(value={"sys:cache:dict"}, key="#code", unless="#result == null ")
    public List<DictModel> queryDictItemsByCode(String code) {
        return this.sysDictService.queryDictItemsByCode(code);
    }

    @Cacheable(value={"sys:cache:dictEnable"}, key="#code", unless="#result == null ")
    public List<DictModel> queryEnableDictItemsByCode(String code) {
        return this.sysDictService.queryEnableDictItemsByCode(code);
    }

    public List<DictModel> queryTableDictItemsByCode(String tableFilterSql, String text, String code) {
        if (tableFilterSql.indexOf("#{") >= 0) {
            tableFilterSql = QueryGenerator.getSqlRuleValue((String)tableFilterSql);
        }
        return this.sysDictService.queryTableDictItemsByCode(tableFilterSql, text, code);
    }

    public List<DictModel> queryAllDepartBackDictModel() {
        return this.sysDictService.queryAllDepartBackDictModel();
    }

    public void sendSysAnnouncement(MessageDTO message) {
        this.sendSysAnnouncement(message.getFromUser(), message.getToUser(), message.getTitle(), message.getContent(), message.getCategory());
        try {
            this.wechatEnterpriseService.sendMessage(message, true);
            this.dingtalkService.sendMessage(message, true);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u53d1\u9001\u7b2c\u4e09\u65b9APP\u6d88\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void sendBusAnnouncement(BusMessageDTO message) {
        this.sendBusAnnouncement(message.getFromUser(), message.getToUser(), message.getTitle(), message.getContent(), message.getCategory(), message.getBusType(), message.getBusId());
        try {
            this.wechatEnterpriseService.sendMessage((MessageDTO)message, true);
            this.dingtalkService.sendMessage((MessageDTO)message, true);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u53d1\u9001\u7b2c\u4e09\u65b9APP\u6d88\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void sendTemplateAnnouncement(TemplateMessageDTO message) {
        String templateCode = message.getTemplateCode();
        String title = message.getTitle();
        Map tmplateParam = message.getTemplateParam();
        String fromUser = message.getFromUser();
        String toUser = message.getToUser();
        List<SysMessageTemplate> sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        if (sysSmsTemplates == null || sysSmsTemplates.size() == 0) {
            throw new JeecgBootException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u7801\uff1a" + templateCode);
        }
        SysMessageTemplate sysSmsTemplate = sysSmsTemplates.get(0);
        title = title == null ? sysSmsTemplate.getTemplateName() : title;
        String content = sysSmsTemplate.getTemplateContent();
        if (tmplateParam != null) {
            for (Map.Entry entry : tmplateParam.entrySet()) {
                String str = "${" + (String)entry.getKey() + "}";
                if (oConvertUtils.isNotEmpty((Object)title)) {
                    title = title.replace(str, (CharSequence)entry.getValue());
                }
                content = content.replace(str, (CharSequence)entry.getValue());
            }
        }
        String mobileOpenUrl = null;
        if (tmplateParam != null && oConvertUtils.isNotEmpty(tmplateParam.get("url"))) {
            mobileOpenUrl = (String)tmplateParam.get("url");
        }
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(content);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory("2");
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        this.sysAnnouncementMapper.insert(announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag(CommonConstant.NO_READ_FLAG);
            this.sysAnnouncementSendMapper.insert(announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        }
        try {
            this.dingtalkService.sendActionCardMessage(announcement, mobileOpenUrl, true);
            this.wechatEnterpriseService.sendTextCardMessage(announcement, true);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u53d1\u9001\u7b2c\u4e09\u65b9APP\u6d88\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public void sendBusTemplateAnnouncement(BusTemplateMessageDTO message) {
        String templateCode = message.getTemplateCode();
        String title = message.getTitle();
        Map tmplateParam = message.getTemplateParam();
        String fromUser = message.getFromUser();
        String toUser = message.getToUser();
        String busId = message.getBusId();
        String busType = message.getBusType();
        List<SysMessageTemplate> sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        if (sysSmsTemplates == null || sysSmsTemplates.size() == 0) {
            throw new JeecgBootException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u7801\uff1a" + templateCode);
        }
        SysMessageTemplate sysSmsTemplate = sysSmsTemplates.get(0);
        title = title == null ? sysSmsTemplate.getTemplateName() : title;
        String content = sysSmsTemplate.getTemplateContent();
        if (tmplateParam != null) {
            for (Map.Entry entry : tmplateParam.entrySet()) {
                String str = "${" + (String)entry.getKey() + "}";
                if (entry.getValue() == null) continue;
                title = title.replace(str, (CharSequence)entry.getValue());
                content = content.replace(str, (CharSequence)entry.getValue());
            }
        }
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(content);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        if (tmplateParam != null && oConvertUtils.isNotEmpty(tmplateParam.get("msg_abstract"))) {
            announcement.setMsgAbstract((String)tmplateParam.get("msg_abstract"));
        }
        String mobileOpenUrl = null;
        if (tmplateParam != null && oConvertUtils.isNotEmpty(tmplateParam.get("url"))) {
            mobileOpenUrl = (String)tmplateParam.get("url");
        }
        announcement.setMsgCategory("2");
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        announcement.setBusId(busId);
        announcement.setBusType(busType);
        announcement.setOpenType(SysAnnmentTypeEnum.getByType((String)busType).getOpenType());
        announcement.setOpenPage(SysAnnmentTypeEnum.getByType((String)busType).getOpenPage());
        this.sysAnnouncementMapper.insert(announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag(CommonConstant.NO_READ_FLAG);
            this.sysAnnouncementSendMapper.insert(announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        }
        try {
            this.dingtalkService.sendActionCardMessage(announcement, mobileOpenUrl, true);
            this.wechatEnterpriseService.sendTextCardMessage(announcement, true);
        }
        catch (Exception e) {
            log.error("\u540c\u6b65\u53d1\u9001\u7b2c\u4e09\u65b9APP\u6d88\u606f\u5931\u8d25\uff01", (Throwable)e);
        }
    }

    public String parseTemplateByCode(TemplateDTO templateDTO) {
        String templateCode = templateDTO.getTemplateCode();
        Map map = templateDTO.getTemplateParam();
        List<SysMessageTemplate> sysSmsTemplates = this.sysMessageTemplateService.selectByCode(templateCode);
        if (sysSmsTemplates == null || sysSmsTemplates.size() == 0) {
            throw new JeecgBootException("\u6d88\u606f\u6a21\u677f\u4e0d\u5b58\u5728\uff0c\u6a21\u677f\u7f16\u7801\uff1a" + templateCode);
        }
        SysMessageTemplate sysSmsTemplate = sysSmsTemplates.get(0);
        String content = sysSmsTemplate.getTemplateContent();
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                String str = "${" + (String)entry.getKey() + "}";
                content = content.replace(str, (CharSequence)entry.getValue());
            }
        }
        return content;
    }

    public void updateSysAnnounReadFlag(String busType, String busId) {
        SysAnnouncement announcement = (SysAnnouncement)this.sysAnnouncementMapper.selectOne((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"bus_type", (Object)busType)).eq((Object)"bus_id", (Object)busId));
        if (announcement != null) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            String userId = sysUser.getId();
            LambdaUpdateWrapper updateWrapper = new UpdateWrapper().lambda();
            updateWrapper.set(SysAnnouncementSend::getReadFlag, (Object)CommonConstant.HAS_READ_FLAG);
            updateWrapper.set(SysAnnouncementSend::getReadTime, (Object)new Date());
            updateWrapper.eq(SysAnnouncementSend::getAnntId, (Object)announcement.getId());
            updateWrapper.eq(SysAnnouncementSend::getUserId, (Object)userId);
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            this.sysAnnouncementSendMapper.update(announcementSend, (Wrapper)updateWrapper);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getDatabaseTypeByDataSource(DataSource dataSource) throws SQLException {
        if ("".equals(DB_TYPE)) {
            try (Connection connection = dataSource.getConnection();){
                DatabaseMetaData md = connection.getMetaData();
                String dbType = md.getDatabaseProductName().toLowerCase();
                if (dbType.indexOf("MYSQL".toLowerCase()) >= 0) {
                    DB_TYPE = "MYSQL";
                } else if (dbType.indexOf("ORACLE".toLowerCase()) >= 0) {
                    DB_TYPE = "ORACLE";
                } else if (dbType.indexOf("SQLSERVER".toLowerCase()) >= 0 || dbType.indexOf("sql server") >= 0) {
                    DB_TYPE = "SQLSERVER";
                } else if (dbType.indexOf("POSTGRESQL".toLowerCase()) >= 0) {
                    DB_TYPE = "POSTGRESQL";
                } else if (dbType.indexOf("MARIADB".toLowerCase()) >= 0) {
                    DB_TYPE = "MARIADB";
                } else {
                    log.error("\u6570\u636e\u5e93\u7c7b\u578b:[" + dbType + "]\u4e0d\u8bc6\u522b!");
                }
            }
        }
        return DB_TYPE;
    }

    public List<DictModel> queryAllDict() {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.orderByAsc((Object)"create_time");
        List dicts = this.sysDictService.list((Wrapper)queryWrapper);
        ArrayList<DictModel> list = new ArrayList<DictModel>();
        for (SysDict dict : dicts) {
            list.add(new DictModel(dict.getDictCode(), dict.getDictName()));
        }
        return list;
    }

    public List<SysCategoryModel> queryAllSysCategory() {
        List ls = this.categoryMapper.selectList(null);
        List res = oConvertUtils.entityListToModelList((List)ls, SysCategoryModel.class);
        return res;
    }

    public List<DictModel> queryFilterTableDictInfo(String table, String text, String code, String filterSql) {
        return this.sysDictService.queryTableDictItemsByCodeAndFilter(table, text, code, filterSql);
    }

    public List<String> queryTableDictByKeys(String table, String text, String code, String[] keyArray) {
        return this.sysDictService.queryTableDictByKeys(table, text, code, Joiner.on((String)",").join((Object[])keyArray));
    }

    public List<ComboModel> queryAllUserBackCombo() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List userList = this.userMapper.selectList((Wrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0));
        for (SysUser user : userList) {
            ComboModel model = new ComboModel();
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            model.setUsername(user.getUsername());
            list.add(model);
        }
        return list;
    }

    public JSONObject queryAllUser(String userIds, Integer pageNo, Integer pageSize) {
        JSONObject json = new JSONObject();
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.userMapper.selectPage((IPage)page, (Wrapper)queryWrapper);
        for (SysUser user : pageList.getRecords()) {
            ComboModel model = new ComboModel();
            model.setUsername(user.getUsername());
            model.setTitle(user.getRealname());
            model.setId(user.getId());
            model.setEmail(user.getEmail());
            if (oConvertUtils.isNotEmpty((Object)userIds)) {
                String[] temp = userIds.split(",");
                for (int i = 0; i < temp.length; ++i) {
                    if (!temp[i].equals(user.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        json.put("list", list);
        json.put("total", (Object)pageList.getTotal());
        return json;
    }

    public List<ComboModel> queryAllRole() {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (SysRole role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            list.add(model);
        }
        return list;
    }

    public List<ComboModel> queryAllRole(String[] roleIds) {
        ArrayList<ComboModel> list = new ArrayList<ComboModel>();
        List roleList = this.roleMapper.selectList((Wrapper)new QueryWrapper());
        for (SysRole role : roleList) {
            ComboModel model = new ComboModel();
            model.setTitle(role.getRoleName());
            model.setId(role.getId());
            model.setRoleCode(role.getRoleCode());
            if (oConvertUtils.isNotEmpty((Object)roleIds)) {
                for (int i = 0; i < roleIds.length; ++i) {
                    if (!roleIds[i].equals(role.getId())) continue;
                    model.setChecked(true);
                }
            }
            list.add(model);
        }
        return list;
    }

    public List<String> getRoleIdsByUsername(String username) {
        return this.sysUserRoleMapper.getRoleIdByUserName(username);
    }

    public String getDepartIdsByOrgCode(String orgCode) {
        return this.departMapper.queryDepartIdByOrgCode(orgCode);
    }

    public List<SysDepartModel> getAllSysDepart() {
        ArrayList<SysDepartModel> departModelList = new ArrayList<SysDepartModel>();
        List departList = this.departMapper.selectList((Wrapper)new QueryWrapper().eq((Object)"del_flag", (Object)"0"));
        for (SysDepart depart : departList) {
            SysDepartModel model = new SysDepartModel();
            BeanUtils.copyProperties((Object)depart, (Object)model);
            departModelList.add(model);
        }
        return departModelList;
    }

    public DynamicDataSourceModel getDynamicDbSourceById(String dbSourceId) {
        SysDataSource dbSource = (SysDataSource)this.dataSourceService.getById((Serializable)((Object)dbSourceId));
        if (dbSource != null && StringUtils.isNotBlank((String)dbSource.getDbPassword())) {
            String dbPassword = dbSource.getDbPassword();
            String decodedStr = SecurityUtil.jiemi(dbPassword);
            dbSource.setDbPassword(decodedStr);
        }
        return new DynamicDataSourceModel((Object)dbSource);
    }

    public DynamicDataSourceModel getDynamicDbSourceByCode(String dbSourceCode) {
        SysDataSource dbSource = (SysDataSource)this.dataSourceService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysDataSource::getCode, (Object)dbSourceCode));
        if (dbSource != null && StringUtils.isNotBlank((String)dbSource.getDbPassword())) {
            String dbPassword = dbSource.getDbPassword();
            String decodedStr = SecurityUtil.jiemi(dbPassword);
            dbSource.setDbPassword(decodedStr);
        }
        return new DynamicDataSourceModel((Object)dbSource);
    }

    public List<String> getDeptHeadByDepId(String deptId) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        if (oConvertUtils.isNotEmpty((Object)deptId) && deptId.contains(",")) {
            String[] vals = deptId.split(",");
            queryWrapper.and(andWrapper -> {
                for (int i = 0; i < vals.length; ++i) {
                    andWrapper.like((Object)"depart_ids", (Object)vals[i]);
                    andWrapper.or();
                }
            });
        } else {
            queryWrapper.like((Object)"depart_ids", (Object)deptId);
        }
        List userList = this.userMapper.selectList((Wrapper)queryWrapper);
        ArrayList<String> list = new ArrayList<String>();
        for (SysUser user : userList) {
            list.add(user.getUsername());
        }
        return list;
    }

    public void sendWebSocketMsg(String[] userIds, String cmd) {
        JSONObject obj = new JSONObject();
        obj.put("cmd", (Object)cmd);
        this.webSocket.sendMessage(userIds, obj.toJSONString());
    }

    public List<UserAccountInfo> queryAllUserByIds(String[] userIds) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        queryWrapper.in((Object)"id", (Object[])userIds);
        ArrayList<UserAccountInfo> loginUsers = new ArrayList<UserAccountInfo>();
        List sysUsers = this.userMapper.selectList((Wrapper)queryWrapper);
        for (SysUser user : sysUsers) {
            UserAccountInfo loginUser = new UserAccountInfo();
            BeanUtils.copyProperties((Object)user, (Object)loginUser);
            loginUsers.add(loginUser);
        }
        return loginUsers;
    }

    public void meetingSignWebsocket(String userId) {
        JSONObject obj = new JSONObject();
        obj.put("cmd", (Object)"sign");
        obj.put("userId", (Object)userId);
        this.webSocket.sendMessage(obj.toJSONString());
    }

    public List<UserAccountInfo> queryUserByNames(String[] userNames) {
        QueryWrapper queryWrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"status", (Object)1)).eq((Object)"del_flag", (Object)0);
        queryWrapper.in((Object)"username", (Object[])userNames);
        ArrayList<UserAccountInfo> loginUsers = new ArrayList<UserAccountInfo>();
        List sysUsers = this.userMapper.selectList((Wrapper)queryWrapper);
        for (SysUser user : sysUsers) {
            UserAccountInfo loginUser = new UserAccountInfo();
            BeanUtils.copyProperties((Object)user, (Object)loginUser);
            loginUsers.add(loginUser);
        }
        return loginUsers;
    }

    public List<JSONObject> queryUserBySuperQuery(String superQuery, String matchType) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("superQueryMatchType", new String[]{matchType});
        parameterMap.put("superQueryParams", new String[]{superQuery});
        SysUser sysUser = new SysUser();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysUser, parameterMap);
        List list = this.sysUserService.list((Wrapper)queryWrapper);
        if (ObjectUtils.isNotEmpty((Object)list)) {
            String departKey = "depart";
            QueryCondition departCondition = null;
            try {
                String temp = URLDecoder.decode(superQuery, "UTF-8");
                List conditions = JSON.parseArray((String)temp, QueryCondition.class);
                for (QueryCondition condition : conditions) {
                    if (!departKey.equals(condition.getField())) continue;
                    departCondition = condition;
                    break;
                }
            }
            catch (UnsupportedEncodingException e) {
                log.error("\u67e5\u8be2\u7528\u6237\u4fe1\u606f\uff0c\u67e5\u8be2\u6761\u4ef6json\u8f6c\u5316\u5931\u8d25", (Throwable)e);
            }
            for (SysUser user : list) {
                boolean flag;
                JSONObject userJson = JSONObject.parseObject((String)JSONObject.toJSONString((Object)user));
                List<SysDepart> departList = this.sysDepartService.queryDepartsByUsername(user.getUsername());
                List departIds = null;
                if (departList != null && departList.size() > 0) {
                    departIds = departList.stream().map(i -> i.getId()).collect(Collectors.toList());
                    List departNames = departList.stream().map(i -> i.getDepartName()).collect(Collectors.toList());
                    userJson.put(departKey, (Object)oConvertUtils.list2JSONArray(departIds));
                    userJson.put(departKey + "_dictText", (Object)String.join((CharSequence)",", departNames));
                }
                if (!(flag = this.getDepartConditionResult(departCondition, departIds))) continue;
                result.add(userJson);
            }
        }
        return result;
    }

    private boolean getDepartConditionResult(QueryCondition departCondition, List<String> departIds) {
        if (departCondition == null) {
            return true;
        }
        QueryRuleEnum rule = QueryRuleEnum.getByValue((String)departCondition.getRule());
        String conditionVal = departCondition.getVal();
        if (rule == QueryRuleEnum.EMPTY) {
            if (departIds == null || departIds.size() == 0) {
                return true;
            }
        } else if (rule == QueryRuleEnum.NOT_EMPTY) {
            if (departIds != null && departIds.size() > 0) {
                return true;
            }
        } else {
            if (oConvertUtils.isEmpty((Object)conditionVal)) {
                return false;
            }
            if (departIds == null || departIds.size() == 0) {
                return false;
            }
            ArrayList<String> conditionList = conditionVal.startsWith("[") && conditionVal.endsWith("]") ? JSONArray.parseArray((String)conditionVal, String.class) : new ArrayList<String>(Arrays.asList(conditionVal.split(",")));
            if (rule == QueryRuleEnum.EQ ? oConvertUtils.isEqList(conditionList, departIds) : (rule == QueryRuleEnum.NE ? !oConvertUtils.isEqList(conditionList, departIds) : (rule == QueryRuleEnum.IN ? oConvertUtils.isInList(departIds, conditionList) : rule == QueryRuleEnum.NOT_IN && !oConvertUtils.isInList(departIds, conditionList)))) {
                return true;
            }
        }
        return false;
    }

    public JSONObject queryUserById(String id) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.lambda().eq(true, SysUser::getId, (Object)id);
        SysUser sysUser = (SysUser)this.sysUserService.getOne((Wrapper)queryWrapper);
        if (ObjectUtils.isNotEmpty((Object)sysUser)) {
            return JSONObject.parseObject((String)JSONObject.toJSONString((Object)sysUser));
        }
        return null;
    }

    public List<JSONObject> queryDeptBySuperQuery(String superQuery, String matchType) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("superQueryMatchType", new String[]{matchType});
        parameterMap.put("superQueryParams", new String[]{superQuery});
        SysDepart sysDepart = new SysDepart();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDepart, parameterMap);
        List list = this.sysDepartService.list((Wrapper)queryWrapper);
        if (ObjectUtils.isNotEmpty((Object)list)) {
            for (SysDepart depart : list) {
                result.add(JSONObject.parseObject((String)JSONObject.toJSONString((Object)depart)));
            }
        }
        return result;
    }

    public List<JSONObject> queryRoleBySuperQuery(String superQuery, String matchType) {
        ArrayList<JSONObject> result = new ArrayList<JSONObject>();
        HashMap<String, String[]> parameterMap = new HashMap<String, String[]>();
        parameterMap.put("superQueryMatchType", new String[]{matchType});
        parameterMap.put("superQueryParams", new String[]{superQuery});
        SysRole sysDepart = new SysRole();
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysDepart, parameterMap);
        List list = this.sysRoleService.list((Wrapper)queryWrapper);
        if (ObjectUtils.isNotEmpty((Object)list)) {
            for (SysRole role : list) {
                result.add(JSONObject.parseObject((String)JSONObject.toJSONString((Object)role)));
            }
        }
        return result;
    }

    public List<String> selectUserIdByTenantId(String tenantId) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.select(new Object[]{"user_id"});
        queryWrapper.eq((Object)"tenant_id", (Object)tenantId);
        return this.sysUserTenantService.listObjs((Wrapper)queryWrapper, e -> e.toString());
    }

    public SysDepartModel selectAllById(String id) {
        SysDepart sysDepart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)id));
        SysDepartModel sysDepartModel = new SysDepartModel();
        BeanUtils.copyProperties((Object)sysDepart, (Object)sysDepartModel);
        return sysDepartModel;
    }

    public List<String> queryDeptUsersByUserId(String userId) {
        ArrayList<String> userIds = new ArrayList<String>();
        List userDepartList = this.sysUserDepartService.list((Wrapper)new QueryWrapper().eq((Object)"user_id", (Object)userId));
        if (userDepartList != null) {
            String orgCodes = "";
            StringBuilder orgCodesBuilder = new StringBuilder();
            orgCodesBuilder.append(orgCodes);
            for (SysUserDepart userDepart : userDepartList) {
                SysDepart depart = (SysDepart)this.sysDepartService.getById((Serializable)((Object)userDepart.getDepId()));
                int length = 3;
                String compyOrgCode = "";
                if (depart == null || depart.getOrgCode() == null || orgCodes.indexOf(compyOrgCode = depart.getOrgCode().substring(0, length)) != -1) continue;
                orgCodesBuilder.append(",").append(compyOrgCode);
            }
            orgCodes = orgCodesBuilder.toString();
            if (oConvertUtils.isNotEmpty((Object)orgCodes)) {
                orgCodes = orgCodes.substring(1);
                List<String> listIds = this.departMapper.getSubDepIdsByOrgCodes(orgCodes.split(","));
                List userList = this.sysUserDepartService.list((Wrapper)new QueryWrapper().in((Object)"dep_id", listIds));
                for (SysUserDepart userDepart : userList) {
                    if (userIds.contains(userDepart.getUserId())) continue;
                    userIds.add(userDepart.getUserId());
                }
            }
        }
        return userIds;
    }

    public Set<String> getUserRoleSet(String username) {
        List<String> roles = this.sysUserRoleMapper.getRoleByUserName(username);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------username\uff1a " + username + ",Roles size: " + (roles == null ? 0 : roles.size()));
        return new HashSet<String>(roles);
    }

    public Set<String> getUserRoleSetById(String useId) {
        List<String> roles = this.sysUserRoleMapper.getRoleCodeByUserId(useId);
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u89d2\u8272Rules------useId\uff1a " + useId + ",Roles size: " + (roles == null ? 0 : roles.size()));
        return new HashSet<String>(roles);
    }

    public Set<String> getUserPermissionSet(String userId) {
        HashSet<String> permissionSet = new HashSet<String>();
        List<SysPermission> permissionList = this.sysPermissionMapper.queryByUser(userId);
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
            if (permissionList == null) {
                permissionList = new ArrayList<SysPermission>();
            }
            List<SysPermission> testRoleList = this.sysPermissionMapper.queryPermissionByTestRoleId();
            permissionList.addAll(testRoleList);
        }
        for (SysPermission po : permissionList) {
            if (!oConvertUtils.isNotEmpty((Object)po.getPerms())) continue;
            permissionSet.add(po.getPerms());
        }
        log.info("-------\u901a\u8fc7\u6570\u636e\u5e93\u8bfb\u53d6\u7528\u6237\u62e5\u6709\u7684\u6743\u9650Perms------userId\uff1a " + userId + ",Perms size: " + (permissionSet == null ? 0 : permissionSet.size()));
        return permissionSet;
    }

    public boolean hasOnlineAuth(OnlineAuthDTO onlineAuthDTO) {
        String username = onlineAuthDTO.getUsername();
        List possibleUrl = onlineAuthDTO.getPossibleUrl();
        String onlineFormUrl = onlineAuthDTO.getOnlineFormUrl();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(SysPermission::getDelFlag, (Object)0);
        query.in(SysPermission::getUrl, (Collection)possibleUrl);
        List permissionList = this.sysPermissionMapper.selectList((Wrapper)query);
        if (permissionList == null || permissionList.size() == 0) {
            SysPermission sysPermission = new SysPermission();
            sysPermission.setUrl(onlineFormUrl);
            int count = this.sysPermissionMapper.queryCountByUsername(username, sysPermission);
            if (count <= 0) {
                sysPermission.setUrl(onlineAuthDTO.getOnlineWorkOrderUrl());
                count = this.sysPermissionMapper.queryCountByUsername(username, sysPermission);
                if (count <= 0) {
                    return false;
                }
            }
        } else {
            boolean has = false;
            for (SysPermission p : permissionList) {
                int count = this.sysPermissionMapper.queryCountByUsername(username, p);
                has = has || count > 0;
            }
            return has;
        }
        return true;
    }

    public Set<String> queryUserRoles(String username) {
        return this.getUserRoleSet(username);
    }

    public Set<String> queryUserRolesById(String userId) {
        return this.getUserRoleSetById(userId);
    }

    public Set<String> queryUserAuths(String userId) {
        return this.getUserPermissionSet(userId);
    }

    public List<JSONObject> queryUsersByUsernames(String usernames) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUser::getUsername, (Object[])usernames.split(","));
        return JSON.parseArray((String)JSON.toJSONString((Object)this.userMapper.selectList((Wrapper)queryWrapper))).toJavaList(JSONObject.class);
    }

    public List<JSONObject> queryUsersByIds(String ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysUser::getId, (Object[])ids.split(","));
        return JSON.parseArray((String)JSON.toJSONString((Object)this.userMapper.selectList((Wrapper)queryWrapper))).toJavaList(JSONObject.class);
    }

    public List<JSONObject> queryDepartsByOrgcodes(String orgCodes) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysDepart::getOrgCode, (Object[])orgCodes.split(","));
        return JSON.parseArray((String)JSON.toJSONString((Object)this.sysDepartService.list((Wrapper)queryWrapper))).toJavaList(JSONObject.class);
    }

    public List<JSONObject> queryDepartsByIds(String ids) {
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysDepart::getId, (Object[])ids.split(","));
        return JSON.parseArray((String)JSON.toJSONString((Object)this.sysDepartService.list((Wrapper)queryWrapper))).toJavaList(JSONObject.class);
    }

    private void sendSysAnnouncement(String fromUser, String toUser, String title, String msgContent, String setMsgCategory) {
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(msgContent);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory(setMsgCategory);
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        this.sysAnnouncementMapper.insert(announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag(CommonConstant.NO_READ_FLAG);
            this.sysAnnouncementSendMapper.insert(announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        }
    }

    private void sendBusAnnouncement(String fromUser, String toUser, String title, String msgContent, String setMsgCategory, String busType, String busId) {
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(msgContent);
        announcement.setSender(fromUser);
        announcement.setPriority("M");
        announcement.setMsgType("USER");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setMsgCategory(setMsgCategory);
        announcement.setDelFlag(String.valueOf(CommonConstant.DEL_FLAG_0));
        announcement.setBusId(busId);
        announcement.setBusType(busType);
        announcement.setOpenType(SysAnnmentTypeEnum.getByType((String)busType).getOpenType());
        announcement.setOpenPage(SysAnnmentTypeEnum.getByType((String)busType).getOpenPage());
        this.sysAnnouncementMapper.insert(announcement);
        String userId = toUser;
        String[] userIds = userId.split(",");
        String anntId = announcement.getId();
        for (int i = 0; i < userIds.length; ++i) {
            SysUser sysUser;
            if (!oConvertUtils.isNotEmpty((Object)userIds[i]) || (sysUser = this.userMapper.getUserByName(userIds[i])) == null) continue;
            SysAnnouncementSend announcementSend = new SysAnnouncementSend();
            announcementSend.setAnntId(anntId);
            announcementSend.setUserId(sysUser.getId());
            announcementSend.setReadFlag(CommonConstant.NO_READ_FLAG);
            this.sysAnnouncementSendMapper.insert(announcementSend);
            JSONObject obj = new JSONObject();
            obj.put("cmd", (Object)"user");
            obj.put("userId", (Object)sysUser.getId());
            obj.put("msgId", (Object)announcement.getId());
            obj.put("msgTxt", (Object)announcement.getTitile());
            this.webSocket.sendMessage(sysUser.getId(), obj.toJSONString());
        }
    }

    public void sendEmailMsg(String email, String title, String content) {
        EmailSendMsgHandle emailHandle = new EmailSendMsgHandle();
        emailHandle.sendMsg(email, title, content);
    }

    public void sendHtmlTemplateEmail(String email, String title, EmailTemplateEnum emailTemplateEnum, JSONObject params) {
        EmailSendMsgHandle emailHandle = new EmailSendMsgHandle();
        String htmlText = "";
        try {
            Configuration configuration = new Configuration(Configuration.DEFAULT_INCOMPATIBLE_IMPROVEMENTS);
            String url = emailTemplateEnum.getUrl();
            configuration.setClassForTemplateLoading(this.getClass(), url.substring(0, url.lastIndexOf("/")));
            configuration.setDefaultEncoding("UTF-8");
            configuration.setClassicCompatible(true);
            configuration.setNewBuiltinClassResolver(TemplateClassResolver.SAFER_RESOLVER);
            Template template = configuration.getTemplate(url.substring(url.lastIndexOf("/")));
            htmlText = FreeMarkerTemplateUtils.processTemplateIntoString((Template)template, (Object)params);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (TemplateException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("Email Html Text\uff1a{}", (Object)htmlText);
        emailHandle.sendMsg(email, title, htmlText);
    }

    public List<Map> getDeptUserByOrgCode(String orgCode) {
        SysDepart comp = this.sysDepartService.queryCompByOrgCode(orgCode);
        if (comp != null) {
            List<SysDepart> departs = this.sysDepartService.queryDeptByPid(comp.getId());
            ArrayList<Map> list = new ArrayList<Map>();
            for (SysDepart dept : departs) {
                HashMap<String, Object> map = new HashMap<String, Object>(5);
                String departName = dept.getDepartName();
                List<String> listIds = this.departMapper.getSubDepIdsByDepId(dept.getId());
                List userList = this.sysUserDepartService.list((Wrapper)new QueryWrapper().in((Object)"dep_id", listIds));
                ArrayList<String> userIds = new ArrayList<String>();
                for (SysUserDepart userDepart : userList) {
                    if (userIds.contains(userDepart.getUserId())) continue;
                    userIds.add(userDepart.getUserId());
                }
                map.put("name", departName);
                map.put("ids", userIds);
                list.add(map);
            }
            return list;
        }
        return null;
    }

    public List<String> loadCategoryDictItem(String ids) {
        return this.sysCategoryService.loadDictItem(ids, false);
    }

    public List<String> loadCategoryDictItemByNames(String names, boolean delNotExist) {
        return this.sysCategoryService.loadDictItemByNames(names, delNotExist);
    }

    public List<String> loadDictItem(String dictCode, String keys) {
        String[] params = dictCode.split(",");
        return this.sysDictService.queryTableDictByKeys(params[0], params[1], params[2], keys, false);
    }

    public Map<String, String> copyLowAppDict(String originalAppId, String appId, String tenantId) {
        HashMap<String, String> dictCodeMapping = new HashMap<String, String>();
        List<SysDictVo> ls = this.sysDictService.getDictListByLowAppId(originalAppId);
        for (SysDictVo vo : ls) {
            vo.setId(null);
            vo.setLowAppId(appId);
            vo.setTenantId(oConvertUtils.getInt((String)tenantId, null));
            String newDictCode = this.sysDictService.addDictByLowAppId(vo);
            dictCodeMapping.put(vo.getDictCode(), newDictCode);
        }
        log.info(" --- \u6279\u91cf\u590d\u5236\u5e94\u7528\u4e0b\u7684\u5b57\u5178\u5230\u65b0\u79df\u6237\u4e0b \u2014\u2014 \u539f\u5e94\u7528ID:{}\uff0c\u65b0\u5e94\u7528ID:{}\uff0c\u65b0\u79df\u6237ID\uff1a{}\uff0c\u5b57\u5178\u4e2a\u6570\uff1a{} --- ", new Object[]{originalAppId, appId, tenantId, dictCodeMapping.size()});
        return dictCodeMapping;
    }

    public List<DictModel> getDictItems(String dictCode) {
        List<DictModel> ls = this.sysDictService.getDictItems(dictCode);
        if (ls == null) {
            ls = new ArrayList<DictModel>();
        }
        return ls;
    }

    public Map<String, List<DictModel>> getManyDictItems(List<String> dictCodeList) {
        return this.sysDictService.queryDictItemsByCodeList(dictCodeList);
    }

    public List<DictModel> loadDictItemByKeyword(String dictCode, String keyword, Integer pageNo, Integer pageSize) {
        return this.sysDictService.loadDict(dictCode, keyword, pageNo, pageSize);
    }

    public Map<String, List<DictModel>> translateManyDict(String dictCodes, String keys) {
        List<String> dictCodeList = Arrays.asList(dictCodes.split(","));
        List<String> values = Arrays.asList(keys.split(","));
        return this.sysDictService.queryManyDictByKeys(dictCodeList, values);
    }

    public List<DictModel> translateDictFromTableByKeys(String table, String text, String code, String keys, String dataSource) {
        return this.sysDictService.queryTableDictTextByKeys(table, text, code, Arrays.asList(keys.split(",")), dataSource);
    }

    public void sendTemplateMessage(MessageDTO message) {
        String messageType = message.getType();
        log.debug(" \u3010\u4e07\u80fd\u901a\u7528\u3011\u63a8\u9001\u6d88\u606f messageType = {}", (Object)messageType);
        String templateCode = message.getTemplateCode();
        if (oConvertUtils.isNotEmpty((Object)templateCode)) {
            SysMessageTemplate templateEntity = this.getTemplateEntity(templateCode);
            boolean isMarkdown = "5".equals(templateEntity.getTemplateType());
            String content = templateEntity.getTemplateContent();
            if (oConvertUtils.isNotEmpty((Object)content) && null != message.getData()) {
                content = FreemarkerParseFactory.parseTemplateContent((String)content, (Map)message.getData(), (boolean)isMarkdown);
            }
            message.setIsMarkdown(isMarkdown);
            message.setContent(content);
        }
        if (oConvertUtils.isEmpty((Object)message.getContent())) {
            log.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25,\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a\uff01");
            throw new JeecgBootException("\u53d1\u9001\u6d88\u606f\u5931\u8d25,\u6d88\u606f\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        if (MessageTypeEnum.XT.getType().equals(messageType)) {
            if (message.isMarkdown()) {
                message.setContent(HTMLUtils.parseMarkdown((String)message.getContent()));
            }
            this.systemSendMsgHandle.sendMessage(message);
        } else if (MessageTypeEnum.YJ.getType().equals(messageType)) {
            if (message.isMarkdown()) {
                message.setContent(HTMLUtils.parseMarkdown((String)message.getContent()));
            }
            if (message.getIsTimeJob() != null && message.getIsTimeJob().booleanValue()) {
                this.emailSendMsgHandle.sendEmailMessage(message);
            } else {
                this.emailSendMsgHandle.sendMessage(message);
            }
        } else if (MessageTypeEnum.DD.getType().equals(messageType)) {
            this.ddSendMsgHandle.sendMessage(message);
        } else if (MessageTypeEnum.QYWX.getType().equals(messageType)) {
            this.qywxSendMsgHandle.sendMessage(message);
        }
    }

    public String getTemplateContent(String code) {
        List<SysMessageTemplate> list = this.sysMessageTemplateService.selectByCode(code);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0).getTemplateContent();
    }

    public SysMessageTemplate getTemplateEntity(String code) {
        List<SysMessageTemplate> list = this.sysMessageTemplateService.selectByCode(code);
        if (list == null || list.size() == 0) {
            return null;
        }
        return list.get(0);
    }

    public void saveDataLog(DataLogDTO dataLogDto) {
        try {
            SysDataLog entity = new SysDataLog();
            entity.setDataTable(dataLogDto.getTableName());
            entity.setDataId(dataLogDto.getDataId());
            entity.setDataContent(dataLogDto.getContent());
            entity.setType(dataLogDto.getType());
            entity.setDataVersion("1");
            if (oConvertUtils.isNotEmpty((Object)dataLogDto.getCreateName())) {
                entity.setCreateBy(dataLogDto.getCreateName());
            } else {
                entity.autoSetCreateName();
            }
            this.sysDataLogService.save(entity);
        }
        catch (Exception e) {
            log.warn(e.getMessage(), (Throwable)e);
        }
    }

    public void updateAvatar(LoginUser loginUser) {
        SysUser sysUser = new SysUser();
        UpdateWrapper updateWrapper = new UpdateWrapper();
        updateWrapper.eq((Object)"id", (Object)loginUser.getId());
        sysUser.setAvatar(loginUser.getAvatar());
        this.sysUserService.update(sysUser, (Wrapper)updateWrapper);
    }

    public void sendAppChatSocket(String userId) {
        JSONObject obj = new JSONObject();
        obj.put("cmd", (Object)"chat");
        obj.put("userId", (Object)userId);
        this.webSocket.sendMessage(userId, obj.toJSONString());
    }

    public String getRoleCodeById(String id) {
        SysRole role = (SysRole)this.roleMapper.selectById((Serializable)((Object)id));
        if (role != null) {
            return role.getRoleCode();
        }
        return null;
    }

    public List<DictModel> queryRoleDictByCode(String roleCodes) {
        if (oConvertUtils.isEmpty((Object)roleCodes)) {
            return new ArrayList<DictModel>();
        }
        List<String> codeList = Arrays.asList(roleCodes.split(","));
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.in(SysRole::getRoleCode, codeList);
        List list = this.roleMapper.selectList((Wrapper)queryWrapper);
        return list.stream().map(sysRole -> {
            DictModel model = new DictModel();
            model.setText(sysRole.getRoleName());
            model.setValue(sysRole.getRoleCode());
            return model;
        }).collect(Collectors.toList());
    }

    public List<String> queryUserIdsByDeptIds(List<String> deptIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().select((Object[])new SFunction[]{SysUserDepart::getUserId})).in(true, SysUserDepart::getDepId, deptIds);
        return this.sysUserDepartService.listObjs((Wrapper)queryWrapper, e -> e.toString());
    }

    public List<String> queryUserAccountsByDeptIds(List<String> deptIds) {
        return this.departMapper.queryUserAccountByDepartIds(deptIds);
    }

    public List<String> queryUserIdsByRoleds(List<String> roleCodes) {
        LambdaQueryWrapper query = (LambdaQueryWrapper)new LambdaQueryWrapper().in(SysRole::getRoleCode, roleCodes);
        List roleList = this.sysRoleService.list((Wrapper)query);
        if (roleList != null && roleList.size() > 0) {
            List idList = roleList.stream().map(role -> role.getId()).collect(Collectors.toList());
            QueryWrapper queryWrapper = new QueryWrapper();
            ((LambdaQueryWrapper)queryWrapper.lambda().select((Object[])new SFunction[]{SysUserRole::getUserId})).in(true, SysUserRole::getRoleId, idList);
            return this.sysUserRoleService.listObjs((Wrapper)queryWrapper, e -> e.toString());
        }
        return null;
    }

    public List<String> queryUserIdsByPositionIds(List<String> positionIds) {
        QueryWrapper queryWrapper = new QueryWrapper();
        ((LambdaQueryWrapper)queryWrapper.lambda().select((Object[])new SFunction[]{SysUserPosition::getUserId})).in(true, SysUserPosition::getPositionId, positionIds);
        return this.sysUserPositionService.listObjs((Wrapper)queryWrapper, e -> e.toString());
    }

    private List<String> getOnlinePossiblePaths(String path) {
        List<String> result = new ArrayList<String>();
        log.info(" path = " + path);
        if (path.indexOf("?") >= 0 && (path.contains("/online/cgreport/") || path.contains("/online/cgformList/") || path.contains("/online/graphreport/"))) {
            String[] pathArray = path.split("\\?");
            if (oConvertUtils.isNotEmpty((Object)pathArray[1])) {
                String[] params = pathArray[1].split("&");
                if (params.length == 1) {
                    result.add(path);
                } else {
                    result = this.anm(pathArray[0], Arrays.asList(params));
                }
            } else {
                result.add(path);
            }
        } else {
            result.add(path);
        }
        return result;
    }

    private List<String> anm(String baseUrl, List<String> list) {
        int len = list.size();
        int[] destArray = new int[len];
        for (int i = 0; i < len; ++i) {
            destArray[i] = i;
        }
        int[] temp = new int[len];
        ArrayList<String> result = new ArrayList<String>();
        while (temp[0] < len) {
            int n = temp.length - 1;
            temp[n] = temp[n] + 1;
            for (int i = temp.length - 1; i > 0; --i) {
                if (temp[i] != len) continue;
                temp[i] = 0;
                int n2 = i - 1;
                temp[n2] = temp[n2] + 1;
            }
            int[] tt = (int[])temp.clone();
            Arrays.sort(tt);
            if (!Arrays.equals(tt, destArray)) continue;
            String str = "";
            for (int i = 0; i < len; ++i) {
                if (i > 0) {
                    str = str + "&";
                }
                str = str + list.get(temp[i]);
            }
            result.add(baseUrl + "?" + str);
        }
        return result;
    }

    public List<String> getUserAccountsByDepCode(String orgCode) {
        return this.userMapper.getUserAccountsByDepCode(orgCode);
    }

    public boolean dictTableWhiteListCheckBySql(String selectSql) {
        return this.dictTableWhiteListHandler.isPassBySql(selectSql);
    }

    public boolean dictTableWhiteListCheckByDict(String tableOrDictCode, String ... fields) {
        if (fields == null || fields.length == 0) {
            return this.dictTableWhiteListHandler.isPassByDict(tableOrDictCode);
        }
        return this.dictTableWhiteListHandler.isPassByDict(tableOrDictCode, fields);
    }
}

