/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.jeecg.modules.system.entity.SysAnnouncement;
import org.jeecg.modules.system.entity.SysAnnouncementSend;
import org.jeecg.modules.system.mapper.SysAnnouncementMapper;
import org.jeecg.modules.system.mapper.SysAnnouncementSendMapper;
import org.jeecg.modules.system.mapper.SysUserMapper;
import org.jeecg.modules.system.service.ISysAnnouncementSendService;
import org.jeecg.modules.system.service.ISysAnnouncementService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service
public class SysAnnouncementServiceImpl
extends ServiceImpl<SysAnnouncementMapper, SysAnnouncement>
implements ISysAnnouncementService {
    private static final Logger log = LoggerFactory.getLogger(SysAnnouncementServiceImpl.class);
    public static ExecutorService completeNoteThreadPool = new ThreadPoolExecutor(0, 1024, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>());
    @Resource
    private SysAnnouncementMapper sysAnnouncementMapper;
    @Resource
    private SysUserMapper sysUserMapper;
    @Resource
    private SysAnnouncementSendMapper sysAnnouncementSendMapper;
    @Autowired
    private ISysAnnouncementSendService sysAnnouncementSendService;

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void saveAnnouncement(SysAnnouncement sysAnnouncement) {
        if (sysAnnouncement.getMsgType().equals("ALL")) {
            this.sysAnnouncementMapper.insert(sysAnnouncement);
        } else {
            this.sysAnnouncementMapper.insert(sysAnnouncement);
            String userId = sysAnnouncement.getUserIds();
            if (StringUtils.isNotBlank((CharSequence)userId) && userId.endsWith(",")) {
                userId = userId.substring(0, userId.length() - 1);
            }
            String[] userIds = userId.split(",");
            String anntId = sysAnnouncement.getId();
            Date refDate = new Date();
            for (int i = 0; i < userIds.length; ++i) {
                SysAnnouncementSend announcementSend = new SysAnnouncementSend();
                announcementSend.setAnntId(anntId);
                announcementSend.setUserId(userIds[i]);
                announcementSend.setReadFlag(CommonConstant.NO_READ_FLAG);
                announcementSend.setReadTime(refDate);
                this.sysAnnouncementSendMapper.insert(announcementSend);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public boolean upDateAnnouncement(SysAnnouncement sysAnnouncement) {
        this.sysAnnouncementMapper.updateById(sysAnnouncement);
        String userId = sysAnnouncement.getUserIds();
        if (oConvertUtils.isNotEmpty((Object)userId) && sysAnnouncement.getMsgType().equals("USER")) {
            LambdaQueryWrapper queryWrapper;
            String[] userIds = userId.substring(0, userId.length() - 1).split(",");
            String anntId = sysAnnouncement.getId();
            Date refDate = new Date();
            for (int i = 0; i < userIds.length; ++i) {
                queryWrapper = new LambdaQueryWrapper();
                queryWrapper.eq(SysAnnouncementSend::getAnntId, (Object)anntId);
                queryWrapper.eq(SysAnnouncementSend::getUserId, (Object)userIds[i]);
                List announcementSends = this.sysAnnouncementSendMapper.selectList((Wrapper)queryWrapper);
                if (announcementSends.size() > 0) continue;
                SysAnnouncementSend announcementSend = new SysAnnouncementSend();
                announcementSend.setAnntId(anntId);
                announcementSend.setUserId(userIds[i]);
                announcementSend.setReadFlag(CommonConstant.NO_READ_FLAG);
                announcementSend.setReadTime(refDate);
                this.sysAnnouncementSendMapper.insert(announcementSend);
            }
            List<String> delUserIds = Arrays.asList(userIds);
            queryWrapper = new LambdaQueryWrapper();
            queryWrapper.notIn(SysAnnouncementSend::getUserId, delUserIds);
            queryWrapper.eq(SysAnnouncementSend::getAnntId, (Object)anntId);
            this.sysAnnouncementSendMapper.delete((Wrapper)queryWrapper);
        }
        return true;
    }

    @Override
    public void saveSysAnnouncement(String title, String msgContent) {
        SysAnnouncement announcement = new SysAnnouncement();
        announcement.setTitile(title);
        announcement.setMsgContent(msgContent);
        announcement.setSender("JEECG BOOT");
        announcement.setPriority("L");
        announcement.setMsgType("ALL");
        announcement.setSendStatus("1");
        announcement.setSendTime(new Date());
        announcement.setDelFlag(CommonConstant.DEL_FLAG_0.toString());
        this.sysAnnouncementMapper.insert(announcement);
    }

    @Override
    public Page<SysAnnouncement> querySysCementPageByUserId(Page<SysAnnouncement> page, String userId, String msgCategory, Integer tenantId, Date beginDate) {
        if (page.getSize() == -1L) {
            return page.setRecords(this.sysAnnouncementMapper.querySysCementListByUserId(null, userId, msgCategory, tenantId, beginDate));
        }
        return page.setRecords(this.sysAnnouncementMapper.querySysCementListByUserId(page, userId, msgCategory, tenantId, beginDate));
    }

    @Override
    public Integer getUnreadMessageCountByUserId(String userId, Date beginDate) {
        return this.sysAnnouncementMapper.getUnreadMessageCountByUserId(userId, beginDate);
    }

    @Override
    public void completeAnnouncementSendInfo() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String userId = sysUser.getId();
        List<String> announcementIds = this.getNotSendedAnnouncementlist(userId);
        ArrayList<SysAnnouncementSend> sysAnnouncementSendList = new ArrayList<SysAnnouncementSend>();
        if (!CollectionUtils.isEmpty(announcementIds)) {
            for (String commentId : announcementIds) {
                SysAnnouncementSend announcementSend = new SysAnnouncementSend();
                announcementSend.setAnntId(commentId);
                announcementSend.setUserId(userId);
                announcementSend.setReadFlag(CommonConstant.NO_READ_FLAG);
                sysAnnouncementSendList.add(announcementSend);
            }
        }
        if (!CollectionUtils.isEmpty(sysAnnouncementSendList)) {
            this.sysAnnouncementSendService.saveBatch(sysAnnouncementSendList);
        }
    }

    @Override
    public void batchInsertSysAnnouncementSend(String commentId, Integer tenantId) {
        if (MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() && oConvertUtils.isNotEmpty((Object)tenantId)) {
            log.info("\u8865\u5168\u516c\u544a\u4e0e\u7528\u6237\u7684\u5173\u7cfb\u6570\u636e\uff0c\u79df\u6237ID = {}", (Object)tenantId);
        } else {
            tenantId = null;
        }
        List<String> userIdList = this.sysUserMapper.getTenantUserIdList(tenantId);
        ArrayList<SysAnnouncementSend> sysAnnouncementSendList = new ArrayList<SysAnnouncementSend>();
        if (!CollectionUtils.isEmpty(userIdList)) {
            for (String userId : userIdList) {
                SysAnnouncementSend announcementSend = new SysAnnouncementSend();
                announcementSend.setAnntId(commentId);
                announcementSend.setUserId(userId);
                announcementSend.setReadFlag(CommonConstant.NO_READ_FLAG);
                sysAnnouncementSendList.add(announcementSend);
            }
        }
        if (!CollectionUtils.isEmpty(sysAnnouncementSendList)) {
            log.info("\u8865\u5168\u516c\u544a\u4e0e\u7528\u6237\u7684\u5173\u7cfb\u6570\u636e\uff0csysAnnouncementSendList size = {}", (Object)sysAnnouncementSendList.size());
            this.sysAnnouncementSendService.saveBatch(sysAnnouncementSendList);
        }
    }

    @Override
    public List<SysAnnouncement> querySysMessageList(int pageSize, int pageNo, String fromUser, String starFlag, Date beginDate, Date endDate) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        log.info(" \u83b7\u53d6\u767b\u5f55\u4eba LoginUser id: {}", (Object)sysUser.getId());
        Page page = new Page((long)pageNo, (long)pageSize);
        List<SysAnnouncement> list = ((SysAnnouncementMapper)this.baseMapper).queryAllMessageList((Page<SysAnnouncement>)page, sysUser.getId(), fromUser, starFlag, beginDate, endDate);
        return list;
    }

    @Override
    public void updateReaded(List<String> annoceIdList) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.sysAnnouncementSendMapper.updateReaded(sysUser.getId(), annoceIdList);
    }

    @Override
    public void clearAllUnReadMessage() {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        this.sysAnnouncementSendMapper.clearAllUnReadMessage(sysUser.getId());
    }

    @Override
    public List<String> getNotSendedAnnouncementlist(String userId) {
        return this.sysAnnouncementMapper.getNotSendedAnnouncementlist(new Date(), userId);
    }
}

