/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.interceptor;

import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.util.IpUtils;
import org.jeecg.modules.system.service.ISysValidIpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class IpValidInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(IpValidInterceptor.class);
    @Autowired
    private ISysValidIpService sysValidIpService;
    @Value(value="${ht.validIp}")
    protected boolean validIp;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (this.validIp) {
            String ip = IpUtils.getIpAddr((HttpServletRequest)request);
            log.info("\u8bbf\u95eeIP: {}", (Object)ip);
            boolean isValid = this.sysValidIpService.isIpValid(ip);
            if (!isValid) {
                log.warn("IP: {} \u4e0d\u5728\u767d\u540d\u5355\u4e2d\uff0c\u62d2\u7edd\u8bbf\u95ee", (Object)ip);
                this.responseError(response, "\u60a8\u7684IP\u4e0d\u5728\u767d\u540d\u5355\u4e2d\uff0c\u65e0\u6cd5\u8bbf\u95ee\u7cfb\u7edf");
                return false;
            }
        }
        return true;
    }

    private void responseError(HttpServletResponse response, String message) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        out.println("{\"code\":403,\"success\":false,\"message\":\"" + message + "\"}");
        out.flush();
        out.close();
    }
}

