/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.interceptor;

import com.alibaba.fastjson.JSONObject;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.impl.SysBaseApiImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.web.servlet.HandlerInterceptor;

@Component
public class DepartPortInterceptor
implements HandlerInterceptor {
    private static final Logger log = LoggerFactory.getLogger(DepartPortInterceptor.class);
    @Autowired
    private SysBaseApiImpl sysBaseApi;
    @Autowired
    private ISysDepartService sysDepartService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String token = request.getHeader("X-Access-Token");
        if (StringUtils.isEmpty((CharSequence)token)) {
            return true;
        }
        String username = JwtUtil.getUsername((String)token);
        if (username == null || username.equals("admin")) {
            return true;
        }
        LoginUser loginUser = this.sysBaseApi.getUserByName(username);
        if (loginUser == null) {
            return true;
        }
        List<SysDepart> sysDepartList = this.sysDepartService.queryDepartsByUsername(username);
        if (sysDepartList == null || sysDepartList.isEmpty()) {
            return false;
        }
        String requestPort = request.getHeader("X-Forwarded-Port");
        if (StringUtils.isEmpty((CharSequence)requestPort)) {
            requestPort = String.valueOf(request.getServerPort());
        }
        boolean isAllRootDepart = true;
        boolean hasMatchedPort = false;
        for (SysDepart depart : sysDepartList) {
            if (!StringUtils.isNotEmpty((CharSequence)depart.getParentId()) || "0".equals(depart.getParentId())) continue;
            isAllRootDepart = false;
            String allowedPort = depart.getMemo();
            if (!StringUtils.isNotEmpty((CharSequence)allowedPort) || !allowedPort.trim().equals(requestPort)) continue;
            hasMatchedPort = true;
            break;
        }
        if (isAllRootDepart) {
            return true;
        }
        if (!hasMatchedPort) {
            log.warn("\u7528\u6237 [{}] \u5c1d\u8bd5\u4ece\u975e\u6cd5\u7aef\u53e3 [{}] \u8bbf\u95ee\u7cfb\u7edf\uff0c\u6240\u5c5e\u90e8\u95e8\u672a\u6388\u6743\u8be5\u7aef\u53e3", (Object)username, (Object)requestPort);
            this.responseError(response, "\u975e\u6cd5\u8bbf\u95ee\uff1a\u5f53\u524d\u7aef\u53e3\u4e0e\u60a8\u6240\u5c5e\u7684\u54c1\u724c(\u90e8\u95e8)\u4e0d\u5339\u914d\uff01");
            return false;
        }
        return true;
    }

    private void responseError(HttpServletResponse response, String message) throws IOException {
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/json; charset=utf-8");
        PrintWriter out = response.getWriter();
        JSONObject res = new JSONObject();
        res.put("code", (Object)500);
        res.put("success", (Object)false);
        res.put("message", (Object)message);
        out.println(res.toJSONString());
        out.flush();
        out.close();
    }
}

