/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Date;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.IpUtils;
import org.jeecg.modules.system.entity.SysValidIp;
import org.jeecg.modules.system.service.ISysValidIpService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"IP\u767d\u540d\u5355\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/sys/validip"})
public class SysValidIpController
extends JeecgController<SysValidIp, ISysValidIpService> {
    private static final Logger log = LoggerFactory.getLogger(SysValidIpController.class);
    @Autowired
    private ISysValidIpService sysValidIpService;
    @Value(value="${ht.validIp}")
    protected boolean validIp;

    @AutoLog(value="IP\u767d\u540d\u5355-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="IP\u767d\u540d\u5355-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="IP\u767d\u540d\u5355-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<IPage<SysValidIp>> queryPageList(SysValidIp sysValidIp, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysValidIp, (Map)req.getParameterMap());
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        if (!sysUser.getUsername().equals("admin")) {
            queryWrapper.ne((Object)"username", (Object)"admin");
        }
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysValidIpService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="IP\u767d\u540d\u5355-\u6dfb\u52a0")
    @ApiOperation(value="IP\u767d\u540d\u5355-\u6dfb\u52a0", notes="IP\u767d\u540d\u5355-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<SysValidIp> add(@RequestBody SysValidIp sysValidIp) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        sysValidIp.setCreateBy(sysUser.getUsername());
        sysValidIp.setCreateTime(new Date());
        boolean success = this.sysValidIpService.addValidIp(sysValidIp);
        if (success) {
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)sysValidIp);
        }
        return Result.error((String)"\u6dfb\u52a0\u5931\u8d25\uff01");
    }

    @AutoLog(value="IP\u767d\u540d\u5355-\u7f16\u8f91")
    @ApiOperation(value="IP\u767d\u540d\u5355-\u7f16\u8f91", notes="IP\u767d\u540d\u5355-\u7f16\u8f91")
    @PutMapping(value={"/edit"})
    public Result<SysValidIp> edit(@RequestBody SysValidIp sysValidIp) {
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        sysValidIp.setUpdateBy(sysUser.getUsername());
        sysValidIp.setUpdateTime(new Date());
        boolean success = this.sysValidIpService.updateById(sysValidIp);
        if (success) {
            return Result.OK((String)"\u7f16\u8f91\u6210\u529f!", (Object)sysValidIp);
        }
        return Result.error((String)"\u7f16\u8f91\u5931\u8d25!");
    }

    @AutoLog(value="IP\u767d\u540d\u5355-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="IP\u767d\u540d\u5355-\u901a\u8fc7id\u5220\u9664", notes="IP\u767d\u540d\u5355-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestBody Map<String, Object> params) {
        String id = params.get("id").toString();
        boolean success = this.sysValidIpService.deleteValidIp(id);
        if (success) {
            return Result.OK((String)"\u5220\u9664\u6210\u529f!");
        }
        return Result.error((String)"\u5220\u9664\u5931\u8d25!");
    }

    @AutoLog(value="IP\u767d\u540d\u5355-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="IP\u767d\u540d\u5355-\u6279\u91cf\u5220\u9664", notes="IP\u767d\u540d\u5355-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestBody Map<String, Object> params) {
        String ids = params.get("ids").toString();
        boolean success = this.sysValidIpService.removeByIds(Arrays.asList(ids.split(",")));
        if (success) {
            return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f!");
        }
        return Result.error((String)"\u6279\u91cf\u5220\u9664\u5931\u8d25!");
    }

    @AutoLog(value="IP\u767d\u540d\u5355-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="IP\u767d\u540d\u5355-\u901a\u8fc7id\u67e5\u8be2", notes="IP\u767d\u540d\u5355-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<SysValidIp> queryById(@RequestBody Map<String, Object> params) {
        String id = params.get("id").toString();
        SysValidIp sysValidIp = (SysValidIp)this.sysValidIpService.getById((Serializable)((Object)id));
        if (sysValidIp == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        return Result.OK((Object)sysValidIp);
    }

    @AutoLog(value="IP\u767d\u540d\u5355-\u68c0\u67e5\u5f53\u524dIP")
    @ApiOperation(value="IP\u767d\u540d\u5355-\u68c0\u67e5\u5f53\u524dIP", notes="\u68c0\u67e5\u5f53\u524d\u8bbf\u95eeIP\u662f\u5426\u5728\u767d\u540d\u5355\u4e2d")
    @GetMapping(value={"/checkIp"})
    public Result<Boolean> checkIp(HttpServletRequest request) {
        boolean passValid = true;
        if (this.validIp) {
            String ip = IpUtils.getIpAddr((HttpServletRequest)request);
            passValid = this.sysValidIpService.isIpValid(ip);
        }
        return Result.OK((Object)passValid);
    }
}

