/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.modules.system.entity.SysRoleIndex;
import org.jeecg.modules.system.service.ISysRoleIndexService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u89d2\u8272\u9996\u9875\u914d\u7f6e"})
@RestController
@RequestMapping(value={"/sys/sysRoleIndex"})
public class SysRoleIndexController
extends JeecgController<SysRoleIndex, ISysRoleIndexService> {
    private static final Logger log = LoggerFactory.getLogger(SysRoleIndexController.class);
    @Autowired
    private ISysRoleIndexService sysRoleIndexService;

    @AutoLog(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SysRoleIndex sysRoleIndex, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysRoleIndex, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysRoleIndexService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @RequiresPermissions(value={"system:roleindex:add"})
    @AutoLog(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u6dfb\u52a0")
    @ApiOperation(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u6dfb\u52a0", notes="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SysRoleIndex sysRoleIndex, HttpServletRequest request) {
        this.sysRoleIndexService.save(sysRoleIndex);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @RequiresPermissions(value={"system:roleindex:edit"})
    @AutoLog(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u7f16\u8f91")
    @ApiOperation(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u7f16\u8f91", notes="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<?> edit(@RequestBody SysRoleIndex sysRoleIndex, HttpServletRequest request) {
        this.sysRoleIndexService.updateById(sysRoleIndex);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664", notes="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysRoleIndexService.removeById((Serializable)((Object)id));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u6279\u91cf\u5220\u9664", notes="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysRoleIndexService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @AutoLog(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2", notes="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SysRoleIndex sysRoleIndex = (SysRoleIndex)this.sysRoleIndexService.getById((Serializable)((Object)id));
        return Result.OK((Object)sysRoleIndex);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysRoleIndex sysRoleIndex) {
        return super.exportXls(request, (Object)sysRoleIndex, SysRoleIndex.class, "\u89d2\u8272\u9996\u9875\u914d\u7f6e");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysRoleIndex.class);
    }

    @AutoLog(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u901a\u8fc7code\u67e5\u8be2")
    @ApiOperation(value="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u901a\u8fc7code\u67e5\u8be2", notes="\u89d2\u8272\u9996\u9875\u914d\u7f6e-\u901a\u8fc7code\u67e5\u8be2")
    @GetMapping(value={"/queryByCode"})
    public Result<?> queryByCode(@RequestParam(name="roleCode", required=true) String roleCode, HttpServletRequest request) {
        SysRoleIndex sysRoleIndex = (SysRoleIndex)this.sysRoleIndexService.getOne((Wrapper)new LambdaQueryWrapper().eq(SysRoleIndex::getRoleCode, (Object)roleCode));
        return Result.OK((Object)sysRoleIndex);
    }

    @GetMapping(value={"/queryDefIndex"})
    public Result<SysRoleIndex> queryDefIndex() {
        SysRoleIndex defIndexCfg = this.sysRoleIndexService.queryDefaultIndex();
        return Result.OK((Object)defIndexCfg);
    }

    @RequiresPermissions(value={"system:permission:setDefIndex"})
    @PutMapping(value={"/updateDefIndex"})
    public Result<?> updateDefIndex(@RequestParam(value="url") String url, @RequestParam(value="component") String component, @RequestParam(value="isRoute") Boolean isRoute) {
        boolean success = this.sysRoleIndexService.updateDefaultIndex(url, component, isRoute);
        if (success) {
            return Result.OK((String)"\u8bbe\u7f6e\u6210\u529f");
        }
        return Result.error((String)"\u8bbe\u7f6e\u5931\u8d25");
    }
}

