/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.FillRuleUtil;
import org.jeecg.modules.system.entity.SysFillRule;
import org.jeecg.modules.system.service.ISysFillRuleService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@Api(tags={"\u586b\u503c\u89c4\u5219"})
@RestController
@RequestMapping(value={"/sys/fillRule"})
public class SysFillRuleController
extends JeecgController<SysFillRule, ISysFillRuleService> {
    private static final Logger log = LoggerFactory.getLogger(SysFillRuleController.class);
    @Autowired
    private ISysFillRuleService sysFillRuleService;

    @AutoLog(value="\u586b\u503c\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u586b\u503c\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u586b\u503c\u89c4\u5219-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SysFillRule sysFillRule, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)sysFillRule, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysFillRuleService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @GetMapping(value={"/testFillRule"})
    public Result testFillRule(@RequestParam(value="ruleCode") String ruleCode) {
        Object result = FillRuleUtil.executeRule((String)ruleCode, (JSONObject)new JSONObject());
        return Result.ok((Object)result);
    }

    @AutoLog(value="\u586b\u503c\u89c4\u5219-\u6dfb\u52a0")
    @ApiOperation(value="\u586b\u503c\u89c4\u5219-\u6dfb\u52a0", notes="\u586b\u503c\u89c4\u5219-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SysFillRule sysFillRule) {
        this.sysFillRuleService.save(sysFillRule);
        return Result.ok((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u586b\u503c\u89c4\u5219-\u7f16\u8f91")
    @ApiOperation(value="\u586b\u503c\u89c4\u5219-\u7f16\u8f91", notes="\u586b\u503c\u89c4\u5219-\u7f16\u8f91")
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<?> edit(@RequestBody SysFillRule sysFillRule) {
        this.sysFillRuleService.updateById(sysFillRule);
        return Result.ok((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u586b\u503c\u89c4\u5219-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u586b\u503c\u89c4\u5219-\u901a\u8fc7id\u5220\u9664", notes="\u586b\u503c\u89c4\u5219-\u901a\u8fc7id\u5220\u9664")
    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysFillRuleService.removeById((Serializable)((Object)id));
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u586b\u503c\u89c4\u5219-\u6279\u91cf\u5220\u9664")
    @ApiOperation(value="\u586b\u503c\u89c4\u5219-\u6279\u91cf\u5220\u9664", notes="\u586b\u503c\u89c4\u5219-\u6279\u91cf\u5220\u9664")
    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysFillRuleService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.ok((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @AutoLog(value="\u586b\u503c\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u586b\u503c\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2", notes="\u586b\u503c\u89c4\u5219-\u901a\u8fc7id\u67e5\u8be2")
    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SysFillRule sysFillRule = (SysFillRule)this.sysFillRuleService.getById((Serializable)((Object)id));
        return Result.ok((Object)sysFillRule);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysFillRule sysFillRule) {
        return super.exportXls(request, (Object)sysFillRule, SysFillRule.class, "\u586b\u503c\u89c4\u5219");
    }

    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysFillRule.class);
    }

    @PutMapping(value={"/executeRuleByCode/{ruleCode}"})
    public Result executeByRuleCode(@PathVariable(value="ruleCode") String ruleCode, @RequestBody JSONObject formData) {
        Object result = FillRuleUtil.executeRule((String)ruleCode, (JSONObject)formData);
        return Result.ok((Object)result);
    }

    @PutMapping(value={"/executeRuleByCodeBatch"})
    public Result executeByRuleCodeBatch(@RequestBody JSONObject ruleData) {
        JSONObject commonFormData = ruleData.getJSONObject("commonFormData");
        JSONArray rules = ruleData.getJSONArray("rules");
        JSONArray results = new JSONArray(rules.size());
        for (int i = 0; i < rules.size(); ++i) {
            JSONObject rule = rules.getJSONObject(i);
            String ruleCode = rule.getString("ruleCode");
            JSONObject formData = rule.getJSONObject("formData");
            if (formData == null) {
                formData = commonFormData;
            }
            Object result = FillRuleUtil.executeRule((String)ruleCode, (JSONObject)formData);
            JSONObject obj = new JSONObject(rules.size());
            obj.put("ruleCode", (Object)ruleCode);
            obj.put("result", result);
            results.add((Object)obj);
        }
        return Result.ok((Object)results);
    }
}

