/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.controller;

import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSONObject;
import com.aliyuncs.exceptions.ClientException;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresRoles;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.constant.enums.DySmsEnum;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.DySmsHelper;
import org.jeecg.common.util.DySmsLimit;
import org.jeecg.common.util.IpUtils;
import org.jeecg.common.util.Md5Util;
import org.jeecg.common.util.PasswordUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.encryption.EncryptedString;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.jeecg.modules.base.service.BaseCommonService;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysRoleIndex;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.model.SysLoginModel;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysDictService;
import org.jeecg.modules.system.service.ISysLogService;
import org.jeecg.modules.system.service.ISysPermissionService;
import org.jeecg.modules.system.service.ISysUserService;
import org.jeecg.modules.system.service.impl.SysBaseApiImpl;
import org.jeecg.modules.system.util.RandImageUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys"})
@Api(tags={"\u7528\u6237\u767b\u5f55"})
public class LoginController {
    private static final Logger log = LoggerFactory.getLogger(LoginController.class);
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysPermissionService sysPermissionService;
    @Autowired
    private SysBaseApiImpl sysBaseApi;
    @Autowired
    private ISysLogService logService;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private ISysDictService sysDictService;
    @Resource
    private BaseCommonService baseCommonService;
    @Autowired
    private JeecgBaseConfig jeecgBaseConfig;
    private final String BASE_CHECK_CODES = "qwertyuiplkjhgfdsazxcvbnmQWERTYUPLKJHGFDSAZXCVBNM1234567890";

    @ApiOperation(value="\u767b\u5f55\u63a5\u53e3")
    @RequestMapping(value={"/login"}, method={RequestMethod.POST})
    public Result<JSONObject> login(@RequestBody SysLoginModel sysLoginModel, HttpServletRequest request) {
        Result result = new Result();
        String username = sysLoginModel.getUsername();
        String password = sysLoginModel.getPassword();
        if (this.isLoginFailOvertimes(username)) {
            return result.error500("\u8be5\u7528\u6237\u767b\u5f55\u5931\u8d25\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u4e8e10\u5206\u949f\u540e\u518d\u6b21\u767b\u5f55\uff01");
        }
        String captcha = sysLoginModel.getCaptcha();
        if (captcha == null) {
            result.error500("\u9a8c\u8bc1\u7801\u65e0\u6548");
            return result;
        }
        String lowerCaseCaptcha = captcha.toLowerCase();
        String origin = lowerCaseCaptcha + sysLoginModel.getCheckKey() + this.jeecgBaseConfig.getSignatureSecret();
        String realKey = Md5Util.md5Encode((String)origin, (String)"utf-8");
        Object checkCode = this.redisUtil.get(realKey);
        if (checkCode == null || !checkCode.toString().equals(lowerCaseCaptcha)) {
            log.warn("\u9a8c\u8bc1\u7801\u9519\u8bef\uff0ckey= {} , Ui checkCode= {}, Redis checkCode = {}", new Object[]{sysLoginModel.getCheckKey(), lowerCaseCaptcha, checkCode});
            result.error500("\u9a8c\u8bc1\u7801\u9519\u8bef");
            result.setCode(Integer.valueOf(HttpStatus.PRECONDITION_FAILED.value()));
            return result;
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(SysUser::getUsername, (Object)username);
        SysUser sysUser = (SysUser)this.sysUserService.getOne((Wrapper)queryWrapper);
        result = this.sysUserService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        String userpassword = PasswordUtil.encrypt((String)username, (String)password, (String)sysUser.getSalt());
        String syspassword = sysUser.getPassword();
        if (!syspassword.equals(userpassword)) {
            this.addLoginFailOvertimes(username);
            result.error500("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return result;
        }
        if (!sysUser.getUsername().equals("admin")) {
            List<SysDepart> sysDepartList = this.sysDepartService.queryDepartsByUsername(username);
            if (sysDepartList == null || sysDepartList.isEmpty()) {
                result.error500("\u7528\u6237\u65e0\u54c1\u724c\u4e0d\u5b58\u5728");
                return result;
            }
            String requestPort = request.getHeader("X-Forwarded-Port");
            if (StringUtils.isEmpty((CharSequence)requestPort)) {
                requestPort = String.valueOf(request.getServerPort());
            }
            boolean isAllRootDepart = true;
            boolean hasMatchedPort = false;
            String pinpaiCode = "";
            for (SysDepart depart : sysDepartList) {
                if (!StringUtils.isNotEmpty((CharSequence)depart.getParentId()) || "0".equals(depart.getParentId())) continue;
                isAllRootDepart = false;
                String allowedPort = depart.getMemo();
                pinpaiCode = depart.getFax();
                if (!StringUtils.isNotEmpty((CharSequence)allowedPort) || !allowedPort.trim().equals(requestPort)) continue;
                hasMatchedPort = true;
                break;
            }
            if (!isAllRootDepart && !hasMatchedPort) {
                log.warn("\u7528\u6237 [{}] \u5c1d\u8bd5\u4ece\u975e\u6cd5\u7aef\u53e3 [{}] \u8bbf\u95ee\u7cfb\u7edf\uff0c\u6240\u5c5e\u54c1\u724c\u672a\u6388\u6743\u8be5\u7aef\u53e3", (Object)username, (Object)requestPort);
                result.error500("\u975e\u6cd5\u8bbf\u95ee\uff1a\u5f53\u524d\u7aef\u53e3\u4e0e\u60a8\u6240\u5c5e\u7684\u54c1\u724c\u4e0d\u5339\u914d\uff01");
                return result;
            }
            this.redisUtil.set("pinpai_code:" + sysUser.getUsername(), (Object)pinpaiCode);
        }
        this.userInfo(sysUser, (Result<JSONObject>)result, request);
        this.redisUtil.del(new String[]{realKey});
        this.redisUtil.del(new String[]{"LOGIN_FAIL_" + username});
        LoginUser loginUser = new LoginUser();
        BeanUtils.copyProperties((Object)sysUser, (Object)loginUser);
        this.baseCommonService.addLog("\u7528\u6237\u540d: " + username + ",\u767b\u5f55\u6210\u529f\uff01", Integer.valueOf(1), null, loginUser);
        log.info(result.toString());
        return result;
    }

    @GetMapping(value={"/user/getUserInfo"})
    public Result<JSONObject> getUserInfo(HttpServletRequest request) {
        long start = System.currentTimeMillis();
        Result result = new Result();
        String username = JwtUtil.getUserNameByToken((HttpServletRequest)request);
        if (oConvertUtils.isNotEmpty((Object)username)) {
            SysUser sysUser = this.sysUserService.getUserByName(username);
            JSONObject obj = new JSONObject();
            log.info("1 \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8017\u65f6\uff08\u7528\u6237\u57fa\u7840\u4fe1\u606f\uff09" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
            String vue3Version = request.getHeader("X-Version");
            SysRoleIndex roleIndex = this.sysUserService.getDynamicIndexByUserRole(username, vue3Version);
            if (oConvertUtils.isNotEmpty((Object)vue3Version) && roleIndex != null && oConvertUtils.isNotEmpty((Object)roleIndex.getUrl())) {
                String homePath = roleIndex.getUrl();
                if (!homePath.startsWith("/")) {
                    homePath = "/" + homePath;
                }
                sysUser.setHomePath(homePath);
            }
            log.info("2 \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8017\u65f6 (\u9996\u9875\u9762\u914d\u7f6e)" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
            obj.put("userInfo", (Object)sysUser);
            obj.put("sysAllDictItems", this.sysDictService.queryAllDictItems());
            log.info("3 \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8017\u65f6 (\u5b57\u5178\u6570\u636e)" + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
            result.setResult((Object)obj);
            result.success("");
        }
        log.info("end \u83b7\u53d6\u7528\u6237\u4fe1\u606f\u8017\u65f6 " + (System.currentTimeMillis() - start) + "\u6beb\u79d2");
        return result;
    }

    @RequestMapping(value={"/logout"})
    public Result<Object> logout(HttpServletRequest request, HttpServletResponse response) {
        String token = request.getHeader("X-Access-Token");
        if (oConvertUtils.isEmpty((Object)token)) {
            return Result.error((String)"\u9000\u51fa\u767b\u5f55\u5931\u8d25\uff01");
        }
        String username = JwtUtil.getUsername((String)token);
        LoginUser sysUser = this.sysBaseApi.getUserByName(username);
        if (sysUser != null) {
            this.baseCommonService.addLog("\u7528\u6237\u540d: " + sysUser.getRealname() + ",\u9000\u51fa\u6210\u529f\uff01", Integer.valueOf(1), null, sysUser);
            log.info(" \u7528\u6237\u540d:  " + sysUser.getRealname() + ",\u9000\u51fa\u6210\u529f\uff01 ");
            this.redisUtil.del(new String[]{"prefix_user_token:" + token});
            this.redisUtil.del(new String[]{"shiro:cache:org.jeecg.config.shiro.ShiroRealm.authorizationCache:" + sysUser.getId()});
            this.redisUtil.del(new String[]{String.format("%s::%s", "sys:cache:encrypt:user", sysUser.getUsername())});
            SecurityUtils.getSubject().logout();
            return Result.ok((String)"\u9000\u51fa\u767b\u5f55\u6210\u529f\uff01");
        }
        return Result.error((String)"Token\u65e0\u6548!");
    }

    @GetMapping(value={"loginfo"})
    public Result<JSONObject> loginfo() {
        Result result = new Result();
        JSONObject obj = new JSONObject();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        Date dayStart = calendar.getTime();
        ((Calendar)calendar).add(5, 1);
        Date dayEnd = calendar.getTime();
        Long totalVisitCount = this.logService.findTotalVisitCount();
        obj.put("totalVisitCount", (Object)totalVisitCount);
        Long todayVisitCount = this.logService.findTodayVisitCount(dayStart, dayEnd);
        obj.put("todayVisitCount", (Object)todayVisitCount);
        Long todayIp = this.logService.findTodayIp(dayStart, dayEnd);
        obj.put("todayIp", (Object)todayIp);
        result.setResult((Object)obj);
        result.success("\u767b\u5f55\u6210\u529f");
        return result;
    }

    @GetMapping(value={"/visitInfo"})
    public Result<List<Map<String, Object>>> visitInfo() {
        Result result = new Result();
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.set(11, 0);
        calendar.set(12, 0);
        calendar.set(13, 0);
        calendar.set(14, 0);
        ((Calendar)calendar).add(5, 1);
        Date dayEnd = calendar.getTime();
        ((Calendar)calendar).add(5, -7);
        Date dayStart = calendar.getTime();
        List<Map<String, Object>> list = this.logService.findVisitCount(dayStart, dayEnd);
        result.setResult((Object)oConvertUtils.toLowerCasePageList(list));
        return result;
    }

    @RequestMapping(value={"/selectDepart"}, method={RequestMethod.PUT})
    public Result<JSONObject> selectDepart(@RequestBody SysUser user) {
        Result result = new Result();
        String username = user.getUsername();
        if (oConvertUtils.isEmpty((Object)username)) {
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            username = sysUser.getUsername();
        }
        String orgCode = user.getOrgCode();
        Integer tenantId = user.getLoginTenantId();
        this.sysUserService.updateUserDepart(username, orgCode, tenantId);
        SysUser sysUser = this.sysUserService.getUserByName(username);
        JSONObject obj = new JSONObject();
        obj.put("userInfo", (Object)sysUser);
        result.setResult((Object)obj);
        return result;
    }

    @PostMapping(value={"/sms"})
    public Result<String> sms(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        Result result = new Result();
        String clientIp = IpUtils.getIpAddr((HttpServletRequest)request);
        String mobile = jsonObject.get((Object)"mobile").toString();
        String smsmode = jsonObject.get((Object)"smsmode").toString();
        log.info("-------- IP:{}, \u624b\u673a\u53f7\uff1a{}\uff0c\u83b7\u53d6\u7ed1\u5b9a\u9a8c\u8bc1\u7801", (Object)clientIp, (Object)mobile);
        if (oConvertUtils.isEmpty((Object)mobile)) {
            result.setMessage("\u624b\u673a\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            result.setSuccess(false);
            return result;
        }
        String redisKey = "phone_msg" + mobile;
        Object object = this.redisUtil.get(redisKey);
        if (object != null) {
            result.setMessage("\u9a8c\u8bc1\u780110\u5206\u949f\u5185\uff0c\u4ecd\u7136\u6709\u6548\uff01");
            result.setSuccess(false);
            return result;
        }
        if (!DySmsLimit.canSendSms((String)clientIp)) {
            log.warn("--------[\u8b66\u544a] IP\u5730\u5740:{}, \u77ed\u4fe1\u63a5\u53e3\u8bf7\u6c42\u592a\u591a-------", (Object)clientIp);
            result.setMessage("\u77ed\u4fe1\u63a5\u53e3\u8bf7\u6c42\u592a\u591a\uff0c\u8bf7\u7a0d\u540e\u518d\u8bd5\uff01");
            result.setCode(CommonConstant.PHONE_SMS_FAIL_CODE);
            result.setSuccess(false);
            return result;
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)captcha);
        try {
            boolean b = false;
            if ("1".equals(smsmode)) {
                SysUser sysUser = this.sysUserService.getUserByPhone(mobile);
                if (sysUser != null) {
                    result.error500(" \u624b\u673a\u53f7\u5df2\u7ecf\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55\uff01");
                    this.baseCommonService.addLog("\u624b\u673a\u53f7\u5df2\u7ecf\u6ce8\u518c\uff0c\u8bf7\u76f4\u63a5\u767b\u5f55\uff01", Integer.valueOf(1), null);
                    return result;
                }
                b = DySmsHelper.sendSms((String)mobile, (JSONObject)obj, (DySmsEnum)DySmsEnum.REGISTER_TEMPLATE_CODE);
            } else {
                SysUser sysUser = this.sysUserService.getUserByPhone(mobile);
                result = this.sysUserService.checkUserIsEffective(sysUser);
                if (!result.isSuccess()) {
                    String userNotExist = "\u8be5\u7528\u6237\u4e0d\u5b58\u5728\uff0c\u8bf7\u6ce8\u518c";
                    String message = result.getMessage();
                    if (userNotExist.equals(message)) {
                        result.error500("\u8be5\u7528\u6237\u4e0d\u5b58\u5728\u6216\u672a\u7ed1\u5b9a\u624b\u673a\u53f7");
                    }
                    return result;
                }
                if ("0".equals(smsmode)) {
                    b = DySmsHelper.sendSms((String)mobile, (JSONObject)obj, (DySmsEnum)DySmsEnum.LOGIN_TEMPLATE_CODE);
                } else if ("2".equals(smsmode)) {
                    b = DySmsHelper.sendSms((String)mobile, (JSONObject)obj, (DySmsEnum)DySmsEnum.FORGET_PASSWORD_TEMPLATE_CODE);
                }
            }
            if (!b) {
                result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                result.setSuccess(false);
                return result;
            }
            this.redisUtil.set(redisKey, (Object)captcha, 600L);
            result.setSuccess(true);
        }
        catch (ClientException e) {
            e.printStackTrace();
            result.error500(" \u77ed\u4fe1\u63a5\u53e3\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return result;
        }
        return result;
    }

    @ApiOperation(value="\u624b\u673a\u53f7\u767b\u5f55\u63a5\u53e3")
    @PostMapping(value={"/phoneLogin"})
    public Result<JSONObject> phoneLogin(@RequestBody JSONObject jsonObject, HttpServletRequest request) {
        String redisKey;
        Object code;
        Result result = new Result();
        String phone = jsonObject.getString("mobile");
        if (this.isLoginFailOvertimes(phone)) {
            return result.error500("\u8be5\u7528\u6237\u767b\u5f55\u5931\u8d25\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u4e8e10\u5206\u949f\u540e\u518d\u6b21\u767b\u5f55\uff01");
        }
        SysUser sysUser = this.sysUserService.getUserByPhone(phone);
        result = this.sysUserService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        String smscode = jsonObject.getString("captcha");
        if (!smscode.equals(code = this.redisUtil.get(redisKey = "phone_msg" + phone))) {
            this.addLoginFailOvertimes(phone);
            return Result.error((String)"\u624b\u673a\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        this.userInfo(sysUser, (Result<JSONObject>)result, request);
        this.baseCommonService.addLog("\u7528\u6237\u540d: " + sysUser.getUsername() + ",\u767b\u5f55\u6210\u529f\uff01", Integer.valueOf(1), null);
        return result;
    }

    private Result<JSONObject> userInfo(SysUser sysUser, Result<JSONObject> result, HttpServletRequest request) {
        String username = sysUser.getUsername();
        String syspassword = sysUser.getPassword();
        JSONObject obj = new JSONObject(new LinkedHashMap());
        String token = JwtUtil.sign((String)username, (String)syspassword);
        this.redisUtil.set("prefix_user_token:" + token, (Object)token);
        this.redisUtil.expire("prefix_user_token:" + token, 604800L);
        obj.put("token", (Object)token);
        Result<JSONObject> loginTenantError = this.sysUserService.setLoginTenant(sysUser, obj, username, result);
        if (loginTenantError != null) {
            return loginTenantError;
        }
        obj.put("userInfo", (Object)sysUser);
        List<SysDepart> departs = this.sysDepartService.queryUserDeparts(sysUser.getId());
        obj.put("departs", departs);
        if (departs == null || departs.size() == 0) {
            obj.put("multi_depart", (Object)0);
        } else if (departs.size() == 1) {
            this.sysUserService.updateUserDepart(username, departs.get(0).getOrgCode(), null);
            obj.put("multi_depart", (Object)1);
        } else {
            SysUser sysUserById = (SysUser)this.sysUserService.getById((Serializable)((Object)sysUser.getId()));
            if (oConvertUtils.isEmpty((Object)sysUserById.getOrgCode())) {
                this.sysUserService.updateUserDepart(username, departs.get(0).getOrgCode(), null);
            }
            obj.put("multi_depart", (Object)2);
        }
        String vue3Version = request.getHeader("X-Version");
        if (oConvertUtils.isEmpty((Object)vue3Version)) {
            obj.put("sysAllDictItems", this.sysDictService.queryAllDictItems());
        }
        result.setResult((Object)obj);
        result.success("\u767b\u5f55\u6210\u529f");
        return result;
    }

    @GetMapping(value={"/getEncryptedString"})
    public Result<Map<String, String>> getEncryptedString() {
        Result result = new Result();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put("key", EncryptedString.key);
        map.put("iv", EncryptedString.iv);
        result.setResult(map);
        return result;
    }

    @ApiOperation(value="\u83b7\u53d6\u9a8c\u8bc1\u7801")
    @GetMapping(value={"/randomImage/{key}"})
    public Result<String> randomImage(HttpServletResponse response, @PathVariable(value="key") String key) {
        Result res = new Result();
        try {
            String code = RandomUtil.randomString((String)"qwertyuiplkjhgfdsazxcvbnmQWERTYUPLKJHGFDSAZXCVBNM1234567890", (int)4);
            String lowerCaseCode = code.toLowerCase();
            String origin = lowerCaseCode + key + this.jeecgBaseConfig.getSignatureSecret();
            String realKey = Md5Util.md5Encode((String)origin, (String)"utf-8");
            this.redisUtil.set(realKey, (Object)lowerCaseCode, 60L);
            log.info("\u83b7\u53d6\u9a8c\u8bc1\u7801\uff0cRedis key = {}\uff0ccheckCode = {}", (Object)realKey, (Object)code);
            String base64 = RandImageUtil.generate(code);
            res.setSuccess(true);
            res.setResult((Object)base64);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            res.error500("\u83b7\u53d6\u9a8c\u8bc1\u7801\u5931\u8d25,\u8bf7\u68c0\u67e5redis\u914d\u7f6e!");
            return res;
        }
        return res;
    }

    @RequiresRoles(value={"admin"})
    @GetMapping(value={"/switchVue3Menu"})
    public Result<String> switchVue3Menu(HttpServletResponse response) {
        Result res = new Result();
        this.sysPermissionService.switchVue3Menu();
        return res;
    }

    @RequestMapping(value={"/mLogin"}, method={RequestMethod.POST})
    public Result<JSONObject> mLogin(@RequestBody SysLoginModel sysLoginModel) throws Exception {
        Result<JSONObject> loginTenantError;
        List<SysDepart> departs;
        Result result = new Result();
        String username = sysLoginModel.getUsername();
        String password = sysLoginModel.getPassword();
        JSONObject obj = new JSONObject();
        if (this.isLoginFailOvertimes(username)) {
            return result.error500("\u8be5\u7528\u6237\u767b\u5f55\u5931\u8d25\u6b21\u6570\u8fc7\u591a\uff0c\u8bf7\u4e8e10\u5206\u949f\u540e\u518d\u6b21\u767b\u5f55\uff01");
        }
        SysUser sysUser = this.sysUserService.getUserByName(username);
        result = this.sysUserService.checkUserIsEffective(sysUser);
        if (!result.isSuccess()) {
            return result;
        }
        String userpassword = PasswordUtil.encrypt((String)username, (String)password, (String)sysUser.getSalt());
        String syspassword = sysUser.getPassword();
        if (!syspassword.equals(userpassword)) {
            this.addLoginFailOvertimes(username);
            result.error500("\u7528\u6237\u540d\u6216\u5bc6\u7801\u9519\u8bef");
            return result;
        }
        String orgCode = sysUser.getOrgCode();
        if (oConvertUtils.isEmpty((Object)orgCode) && (departs = this.sysDepartService.queryUserDeparts(sysUser.getId())) != null && departs.size() != 0) {
            orgCode = departs.get(0).getOrgCode();
            sysUser.setOrgCode(orgCode);
            this.sysUserService.updateUserDepart(username, orgCode, null);
        }
        if ((loginTenantError = this.sysUserService.setLoginTenant(sysUser, obj, username, (Result<JSONObject>)result)) != null) {
            return loginTenantError;
        }
        obj.put("userInfo", (Object)sysUser);
        String token = JwtUtil.sign((String)username, (String)syspassword);
        this.redisUtil.set("prefix_user_token:" + token, (Object)token);
        this.redisUtil.expire("prefix_user_token:" + token, 604800L);
        obj.put("token", (Object)token);
        result.setResult((Object)obj);
        result.setSuccess(true);
        result.setCode(Integer.valueOf(200));
        this.baseCommonService.addLog("\u7528\u6237\u540d: " + username + ",\u767b\u5f55\u6210\u529f[\u79fb\u52a8\u7aef]\uff01", Integer.valueOf(1), null);
        return result;
    }

    @RequestMapping(value={"/checkCaptcha"}, method={RequestMethod.POST})
    public Result<?> checkCaptcha(@RequestBody SysLoginModel sysLoginModel) {
        String captcha = sysLoginModel.getCaptcha();
        String checkKey = sysLoginModel.getCheckKey();
        if (captcha == null) {
            return Result.error((String)"\u9a8c\u8bc1\u7801\u65e0\u6548");
        }
        String lowerCaseCaptcha = captcha.toLowerCase();
        String realKey = Md5Util.md5Encode((String)(lowerCaseCaptcha + checkKey), (String)"utf-8");
        Object checkCode = this.redisUtil.get(realKey);
        if (checkCode == null || !checkCode.equals(lowerCaseCaptcha)) {
            return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        return Result.ok();
    }

    @ApiOperation(value="\u767b\u5f55\u4e8c\u7ef4\u7801", notes="\u767b\u5f55\u4e8c\u7ef4\u7801")
    @GetMapping(value={"/getLoginQrcode"})
    public Result<?> getLoginQrcode() {
        String qrcodeId = "QRCODELOGIN:" + IdWorker.getIdStr();
        HashMap<String, String> params = new HashMap<String, String>(5);
        params.put("qrcodeId", qrcodeId);
        this.redisUtil.set("LQ:" + qrcodeId, (Object)qrcodeId, 30L);
        return Result.OK(params);
    }

    @ApiOperation(value="\u626b\u7801\u767b\u5f55\u4e8c\u7ef4\u7801", notes="\u626b\u7801\u767b\u5f55\u4e8c\u7ef4\u7801")
    @PostMapping(value={"/scanLoginQrcode"})
    public Result<?> scanLoginQrcode(@RequestParam String qrcodeId, @RequestParam String token) {
        Object check = this.redisUtil.get("LQ:" + qrcodeId);
        if (!oConvertUtils.isNotEmpty((Object)check)) {
            return Result.error((String)"\u4e8c\u7ef4\u7801\u5df2\u8fc7\u671f,\u8bf7\u5237\u65b0\u540e\u91cd\u8bd5");
        }
        this.redisUtil.set("LQT:" + qrcodeId, (Object)token, 60L);
        return Result.OK((String)"\u626b\u7801\u6210\u529f");
    }

    @ApiOperation(value="\u83b7\u53d6\u7528\u6237\u626b\u7801\u540e\u4fdd\u5b58\u7684token", notes="\u83b7\u53d6\u7528\u6237\u626b\u7801\u540e\u4fdd\u5b58\u7684token")
    @GetMapping(value={"/getQrcodeToken"})
    public Result getQrcodeToken(@RequestParam String qrcodeId) {
        Object token = this.redisUtil.get("LQT:" + qrcodeId);
        HashMap<String, Object> result = new HashMap<String, Object>(5);
        Object qrcodeIdExpire = this.redisUtil.get("LQ:" + qrcodeId);
        if (oConvertUtils.isEmpty((Object)qrcodeIdExpire)) {
            result.put("token", "-2");
            return Result.OK(result);
        }
        if (oConvertUtils.isNotEmpty((Object)token)) {
            result.put("success", true);
            result.put("token", token);
        } else {
            result.put("token", "-1");
        }
        return Result.OK(result);
    }

    private boolean isLoginFailOvertimes(String username) {
        Integer val;
        String key = "LOGIN_FAIL_" + username;
        Object failTime = this.redisUtil.get(key);
        return failTime != null && (val = Integer.valueOf(Integer.parseInt(failTime.toString()))) > 5;
    }

    private void addLoginFailOvertimes(String username) {
        String key = "LOGIN_FAIL_" + username;
        Object failTime = this.redisUtil.get(key);
        Integer val = 0;
        if (failTime != null) {
            val = Integer.parseInt(failTime.toString());
        }
        val = val + 1;
        this.redisUtil.set(key, (Object)val, 600L);
    }

    @PostMapping(value={"/sendChangePwdSms"})
    public Result<String> sendSms(@RequestBody JSONObject jsonObject) {
        Result result = new Result();
        String mobile = jsonObject.get((Object)"mobile").toString();
        if (oConvertUtils.isEmpty((Object)mobile)) {
            result.setMessage("\u624b\u673a\u53f7\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff01");
            result.setSuccess(false);
            return result;
        }
        LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        String username = sysUser.getUsername();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        ((LambdaQueryWrapper)query.eq(SysUser::getUsername, (Object)username)).eq(SysUser::getPhone, (Object)mobile);
        SysUser user = (SysUser)this.sysUserService.getOne((Wrapper)query);
        if (null == user) {
            return Result.error((String)"\u5f53\u524d\u767b\u5f55\u7528\u6237\u548c\u7ed1\u5b9a\u7684\u624b\u673a\u53f7\u4e0d\u5339\u914d\uff0c\u65e0\u6cd5\u4fee\u6539\u5bc6\u7801\uff01");
        }
        String redisKey = "phone_msg" + mobile;
        Object object = this.redisUtil.get(redisKey);
        if (object != null) {
            result.setMessage("\u9a8c\u8bc1\u780110\u5206\u949f\u5185\uff0c\u4ecd\u7136\u6709\u6548\uff01");
            result.setSuccess(false);
            return result;
        }
        String captcha = RandomUtil.randomNumbers((int)6);
        JSONObject obj = new JSONObject();
        obj.put("code", (Object)captcha);
        try {
            boolean b = DySmsHelper.sendSms((String)mobile, (JSONObject)obj, (DySmsEnum)DySmsEnum.CHANGE_PASSWORD_TEMPLATE_CODE);
            if (!b) {
                result.setMessage("\u77ed\u4fe1\u9a8c\u8bc1\u7801\u53d1\u9001\u5931\u8d25,\u8bf7\u7a0d\u540e\u91cd\u8bd5");
                result.setSuccess(false);
                return result;
            }
            this.redisUtil.set(redisKey, (Object)captcha, 300L);
            result.setSuccess(true);
        }
        catch (ClientException e) {
            e.printStackTrace();
            result.error500(" \u77ed\u4fe1\u63a5\u53e3\u672a\u914d\u7f6e\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\uff01");
            return result;
        }
        return result;
    }

    @RequestMapping(value={"/smsCheckCaptcha"}, method={RequestMethod.POST})
    public Result<?> smsCheckCaptcha(@RequestBody SysLoginModel sysLoginModel, HttpServletRequest request) {
        String captcha = sysLoginModel.getCaptcha();
        String checkKey = sysLoginModel.getCheckKey();
        if (captcha == null) {
            return Result.error((String)"\u9a8c\u8bc1\u7801\u65e0\u6548");
        }
        String lowerCaseCaptcha = captcha.toLowerCase();
        String realKey = Md5Util.md5Encode((String)(lowerCaseCaptcha + checkKey + this.jeecgBaseConfig.getSignatureSecret()), (String)"utf-8");
        Object checkCode = this.redisUtil.get(realKey);
        if (checkCode == null || !checkCode.equals(lowerCaseCaptcha)) {
            return Result.error((String)"\u9a8c\u8bc1\u7801\u9519\u8bef");
        }
        String clientIp = IpUtils.getIpAddr((HttpServletRequest)request);
        DySmsLimit.clearSendSmsCount((String)clientIp);
        this.redisUtil.removeAll(realKey);
        return Result.ok();
    }
}

