/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.system.cache;

import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import me.zhyd.oauth.cache.AuthCacheConfig;
import me.zhyd.oauth.cache.AuthStateCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.ValueOperations;

public class AuthStateRedisCache
implements AuthStateCache {
    @Autowired
    private RedisTemplate<String, String> redisTemplate;
    private ValueOperations<String, String> valueOperations;

    @PostConstruct
    public void init() {
        this.valueOperations = this.redisTemplate.opsForValue();
    }

    public void cache(String key, String value) {
        this.valueOperations.set((Object)key, (Object)value, AuthCacheConfig.timeout, TimeUnit.MILLISECONDS);
    }

    public void cache(String key, String value, long timeout) {
        this.valueOperations.set((Object)key, (Object)value, timeout, TimeUnit.MILLISECONDS);
    }

    public String get(String key) {
        return (String)this.valueOperations.get((Object)key);
    }

    public boolean containsKey(String key) {
        return this.redisTemplate.hasKey((Object)key);
    }
}

