/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.quartz.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.shiro.SecurityUtils;
import org.apache.shiro.authz.annotation.RequiresPermissions;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.ImportExcelUtil;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.quartz.entity.QuartzJob;
import org.jeecg.modules.quartz.service.IQuartzJobService;
import org.jeecgframework.poi.excel.ExcelImportUtil;
import org.jeecgframework.poi.excel.entity.ExportParams;
import org.jeecgframework.poi.excel.entity.ImportParams;
import org.jeecgframework.poi.excel.view.JeecgEntityExcelView;
import org.quartz.Scheduler;
import org.quartz.SchedulerException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;

@RestController
@RequestMapping(value={"/sys/quartzJob"})
@Api(tags={"\u5b9a\u65f6\u4efb\u52a1\u63a5\u53e3"})
public class QuartzJobController {
    private static final Logger log = LoggerFactory.getLogger(QuartzJobController.class);
    @Autowired
    private IQuartzJobService quartzJobService;
    @Autowired
    private Scheduler scheduler;

    @RequestMapping(value={"/list"}, method={RequestMethod.GET})
    public Result<?> queryPageList(QuartzJob quartzJob, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)quartzJob, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.quartzJobService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @RequiresPermissions(value={"system:quartzJob:add"})
    @RequestMapping(value={"/add"}, method={RequestMethod.POST})
    public Result<?> add(@RequestBody QuartzJob quartzJob) {
        this.quartzJobService.saveAndScheduleJob(quartzJob);
        return Result.ok((String)"\u521b\u5efa\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @RequiresPermissions(value={"system:quartzJob:edit"})
    @RequestMapping(value={"/edit"}, method={RequestMethod.PUT, RequestMethod.POST})
    public Result<?> eidt(@RequestBody QuartzJob quartzJob) {
        try {
            this.quartzJobService.editAndScheduleJob(quartzJob);
        }
        catch (SchedulerException e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)"\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u5931\u8d25!");
        }
        return Result.ok((String)"\u66f4\u65b0\u5b9a\u65f6\u4efb\u52a1\u6210\u529f!");
    }

    @RequiresPermissions(value={"system:quartzJob:delete"})
    @RequestMapping(value={"/delete"}, method={RequestMethod.DELETE})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        QuartzJob quartzJob = (QuartzJob)this.quartzJobService.getById((Serializable)((Object)id));
        if (quartzJob == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        this.quartzJobService.deleteAndStopJob(quartzJob);
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @RequiresPermissions(value={"system:quartzJob:deleteBatch"})
    @RequestMapping(value={"/deleteBatch"}, method={RequestMethod.DELETE})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        if (ids == null || "".equals(ids.trim())) {
            return Result.error((String)"\u53c2\u6570\u4e0d\u8bc6\u522b\uff01");
        }
        for (String id : Arrays.asList(ids.split(","))) {
            QuartzJob job = (QuartzJob)this.quartzJobService.getById((Serializable)((Object)id));
            this.quartzJobService.deleteAndStopJob(job);
        }
        return Result.ok((String)"\u5220\u9664\u5b9a\u65f6\u4efb\u52a1\u6210\u529f!");
    }

    @RequiresPermissions(value={"system:quartzJob:pause"})
    @GetMapping(value={"/pause"})
    @ApiOperation(value="\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1")
    public Result<Object> pauseJob(@RequestParam(name="id") String id) {
        QuartzJob job = (QuartzJob)this.quartzJobService.getById((Serializable)((Object)id));
        if (job == null) {
            return Result.error((String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        this.quartzJobService.pause(job);
        return Result.ok((String)"\u505c\u6b62\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @RequiresPermissions(value={"system:quartzJob:resume"})
    @GetMapping(value={"/resume"})
    @ApiOperation(value="\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1")
    public Result<Object> resumeJob(@RequestParam(name="id") String id) {
        QuartzJob job = (QuartzJob)this.quartzJobService.getById((Serializable)((Object)id));
        if (job == null) {
            return Result.error((String)"\u5b9a\u65f6\u4efb\u52a1\u4e0d\u5b58\u5728\uff01");
        }
        this.quartzJobService.resumeJob(job);
        return Result.ok((String)"\u542f\u52a8\u5b9a\u65f6\u4efb\u52a1\u6210\u529f");
    }

    @RequestMapping(value={"/queryById"}, method={RequestMethod.GET})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        QuartzJob quartzJob = (QuartzJob)this.quartzJobService.getById((Serializable)((Object)id));
        return Result.ok((Object)quartzJob);
    }

    @RequestMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, QuartzJob quartzJob) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)quartzJob, (Map)request.getParameterMap());
        String selections = request.getParameter("selections");
        if (oConvertUtils.isNotEmpty((Object)selections)) {
            List<String> selectionList = Arrays.asList(selections.split(","));
            queryWrapper.in((Object)"id", selectionList);
        }
        ModelAndView mv = new ModelAndView((View)new JeecgEntityExcelView());
        List pageList = this.quartzJobService.list((Wrapper)queryWrapper);
        mv.addObject("fileName", (Object)"\u5b9a\u65f6\u4efb\u52a1\u5217\u8868");
        mv.addObject("entity", QuartzJob.class);
        LoginUser user = (LoginUser)SecurityUtils.getSubject().getPrincipal();
        mv.addObject("params", (Object)new ExportParams("\u5b9a\u65f6\u4efb\u52a1\u5217\u8868\u6570\u636e", "\u5bfc\u51fa\u4eba:" + user.getRealname(), "\u5bfc\u51fa\u4fe1\u606f"));
        mv.addObject("data", (Object)pageList);
        return mv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/importExcel"}, method={RequestMethod.POST})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        ArrayList errorMessage = new ArrayList();
        int successLines = 0;
        int errorLines = 0;
        for (Map.Entry entity : fileMap.entrySet()) {
            MultipartFile file = (MultipartFile)entity.getValue();
            ImportParams params = new ImportParams();
            params.setTitleRows(2);
            params.setHeadRows(1);
            params.setNeedSave(true);
            try {
                List listQuartzJobs = ExcelImportUtil.importExcel((InputStream)file.getInputStream(), QuartzJob.class, (ImportParams)params);
                for (QuartzJob job : listQuartzJobs) {
                    job.setStatus(CommonConstant.STATUS_DISABLE);
                }
                List list = ImportExcelUtil.importDateSave((List)listQuartzJobs, IQuartzJobService.class, errorMessage, (String)"uniq_job_class_name");
                successLines += listQuartzJobs.size() - (errorLines += list.size());
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                Result result = Result.error((String)"\u6587\u4ef6\u5bfc\u5165\u5931\u8d25\uff01");
                return result;
            }
            finally {
                try {
                    file.getInputStream().close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        return ImportExcelUtil.imporReturnRes((int)errorLines, (int)successLines, errorMessage);
    }

    @RequiresPermissions(value={"system:quartzJob:execute"})
    @GetMapping(value={"/execute"})
    public Result<?> execute(@RequestParam(name="id", required=true) String id) {
        QuartzJob quartzJob = (QuartzJob)this.quartzJobService.getById((Serializable)((Object)id));
        if (quartzJob == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u5b9e\u4f53");
        }
        try {
            this.quartzJobService.execute(quartzJob);
        }
        catch (Exception e) {
            log.info("\u5b9a\u65f6\u4efb\u52a1 \u7acb\u5373\u6267\u884c\u5931\u8d25>>" + e.getMessage());
            return Result.error((String)"\u6267\u884c\u5931\u8d25!");
        }
        return Result.ok((String)"\u6267\u884c\u6210\u529f!");
    }
}

