/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.openapi.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.fasterxml.classmate.TypeResolver;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.constant.CommonConstant;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.modules.openapi.entity.OpenApi;
import org.jeecg.modules.openapi.entity.OpenApiAuth;
import org.jeecg.modules.openapi.entity.OpenApiHeader;
import org.jeecg.modules.openapi.entity.OpenApiParam;
import org.jeecg.modules.openapi.generator.PathGenerator;
import org.jeecg.modules.openapi.service.OpenApiAuthService;
import org.jeecg.modules.openapi.service.OpenApiHeaderService;
import org.jeecg.modules.openapi.service.OpenApiParamService;
import org.jeecg.modules.openapi.service.OpenApiService;
import org.jeecg.modules.openapi.swagger.SwaggerDefinition;
import org.jeecg.modules.openapi.swagger.SwaggerDefinitionProperties;
import org.jeecg.modules.openapi.swagger.SwaggerInfo;
import org.jeecg.modules.openapi.swagger.SwaggerInfoContact;
import org.jeecg.modules.openapi.swagger.SwaggerInfoLicense;
import org.jeecg.modules.openapi.swagger.SwaggerModel;
import org.jeecg.modules.openapi.swagger.SwaggerOperation;
import org.jeecg.modules.openapi.swagger.SwaggerOperationParameter;
import org.jeecg.modules.openapi.swagger.SwaggerOperationResponse;
import org.jeecg.modules.openapi.swagger.SwaggerTag;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.service.ISysUserService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.util.CollectionUtils;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import springfox.documentation.spring.web.DocumentationCache;

@RestController
@RequestMapping(value={"/openapi"})
public class OpenApiController
extends JeecgController<OpenApi, OpenApiService> {
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private OpenApiParamService openApiParamService;
    @Autowired
    private OpenApiHeaderService openApiHeaderService;
    @Autowired
    private DocumentationCache documentationCache;
    @Autowired
    private TypeResolver typeResolver;
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private OpenApiAuthService openApiAuthService;

    @GetMapping(value={"/list"})
    public Result<?> queryPageList(OpenApi openApi, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)openApi, (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = ((OpenApiService)this.service).page((IPage)page, (Wrapper)queryWrapper);
        for (OpenApi api : pageList.getRecords()) {
            api.setParams(this.openApiParamService.findByApiId(api.getId()));
            api.setHeaders(this.openApiHeaderService.findByApiId(api.getId()));
        }
        return Result.ok((Object)pageList);
    }

    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody OpenApi openApi) {
        if (((OpenApiService)this.service).save(openApi)) {
            if (!CollectionUtils.isEmpty(openApi.getHeaders())) {
                this.openApiHeaderService.saveBatch(openApi.getHeaders());
            }
            if (!CollectionUtils.isEmpty(openApi.getParams())) {
                this.openApiParamService.saveBatch(openApi.getParams());
            }
        }
        return Result.ok((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @PutMapping(value={"/edit"})
    public Result<?> edit(@RequestBody OpenApi openApi) {
        if (((OpenApiService)this.service).updateById(openApi)) {
            this.openApiHeaderService.deleteByApiId(openApi.getId());
            this.openApiParamService.deleteByApiId(openApi.getId());
            if (!CollectionUtils.isEmpty(openApi.getHeaders())) {
                this.openApiHeaderService.saveBatch(openApi.getHeaders());
            }
            if (!CollectionUtils.isEmpty(openApi.getParams())) {
                this.openApiParamService.saveBatch(openApi.getParams());
            }
        }
        return Result.ok((String)"\u4fee\u6539\u6210\u529f!");
    }

    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        ((OpenApiService)this.service).removeById((Serializable)((Object)id));
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        ((OpenApiService)this.service).removeByIds(Arrays.asList(ids.split(",")));
        return Result.ok((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        OpenApi OpenApi2 = (OpenApi)((OpenApiService)this.service).getById((Serializable)((Object)id));
        return Result.ok((Object)OpenApi2);
    }

    @RequestMapping(value={"/call/{path}"}, method={RequestMethod.GET, RequestMethod.POST})
    public Result<?> call(@PathVariable String path, @RequestBody(required=false) String json, HttpServletRequest request) {
        OpenApi openApi = ((OpenApiService)this.service).findByPath(path);
        if (Objects.isNull(openApi)) {
            HashMap<String, Integer> result = new HashMap<String, Integer>();
            result.put("code", 404);
            result.put("data", null);
            return Result.error((String)"\u5931\u8d25", result);
        }
        List<OpenApiHeader> headers = this.openApiHeaderService.findByApiId(openApi.getId());
        String url = openApi.getOriginUrl();
        String method = openApi.getRequestMethod();
        HttpHeaders httpHeaders = new HttpHeaders();
        for (OpenApiHeader header : headers) {
            httpHeaders.put(header.getHeaderKey(), (List)Lists.newArrayList((Object[])new String[]{request.getHeader(header.getHeaderKey())}));
        }
        String appkey = request.getHeader("appkey");
        OpenApiAuth openApiAuth = this.openApiAuthService.getByAppkey(appkey);
        SysUser systemUser = (SysUser)this.sysUserService.getById((Serializable)((Object)openApiAuth.getSystemUserId()));
        String token = JwtUtil.sign((String)systemUser.getUsername(), (String)systemUser.getPassword());
        httpHeaders.put("X-Access-Token", (List)Lists.newArrayList((Object[])new String[]{token}));
        HttpEntity httpEntity = new HttpEntity((Object)json, (MultiValueMap)httpHeaders);
        return (Result)this.restTemplate.exchange(url, HttpMethod.resolve((String)method), httpEntity, Result.class, request.getParameterMap()).getBody();
    }

    @GetMapping(value={"/json"})
    public SwaggerModel swaggerModel() {
        SwaggerModel swaggerModel = new SwaggerModel();
        swaggerModel.setSwagger("2.0");
        swaggerModel.setInfo(this.swaggerInfo());
        swaggerModel.setHost("jeecg.com");
        swaggerModel.setBasePath("/jeecg-boot");
        swaggerModel.setSchemes(Lists.newArrayList((Object[])new String[]{"http", "https"}));
        SwaggerTag swaggerTag = new SwaggerTag();
        swaggerTag.setName("openapi");
        swaggerModel.setTags(Lists.newArrayList((Object[])new SwaggerTag[]{swaggerTag}));
        this.pathsAndDefinitions(swaggerModel);
        return swaggerModel;
    }

    private void pathsAndDefinitions(SwaggerModel swaggerModel) {
        HashMap<String, Map<String, SwaggerOperation>> paths = new HashMap<String, Map<String, SwaggerOperation>>();
        HashMap<String, SwaggerDefinition> definitions = new HashMap<String, SwaggerDefinition>();
        List openapis = ((OpenApiService)this.service).list();
        for (OpenApi openApi : openapis) {
            HashMap<String, SwaggerOperation> operations = new HashMap<String, SwaggerOperation>();
            SwaggerOperation operation = new SwaggerOperation();
            operation.setTags(Lists.newArrayList((Object[])new String[]{"openapi"}));
            operation.setSummary(openApi.getName());
            operation.setDescription(openApi.getName());
            operation.setOperationId(openApi.getRequestUrl() + "Using" + openApi.getRequestMethod());
            operation.setProduces(Lists.newArrayList((Object[])new String[]{"application/json"}));
            this.parameters(operation, openApi);
            if (StringUtils.hasText((String)openApi.getBody())) {
                SwaggerDefinition definition = new SwaggerDefinition();
                definition.setType("object");
                HashMap<String, SwaggerDefinitionProperties> definitionProperties = new HashMap<String, SwaggerDefinitionProperties>();
                definition.setProperties(definitionProperties);
                JSONObject jsonObject = JSONObject.parseObject((String)openApi.getBody());
                for (Map.Entry properties : jsonObject.entrySet()) {
                    SwaggerDefinitionProperties swaggerDefinitionProperties = new SwaggerDefinitionProperties();
                    swaggerDefinitionProperties.setType("string");
                    swaggerDefinitionProperties.setDescription(properties.getValue() + "");
                    definitionProperties.put((String)properties.getKey(), swaggerDefinitionProperties);
                }
                definitions.put(openApi.getRequestUrl() + "Using" + openApi.getRequestMethod() + "body", definition);
                SwaggerOperationParameter bodyParameter = new SwaggerOperationParameter();
                bodyParameter.setDescription(openApi.getName() + " body");
                bodyParameter.setIn("body");
                bodyParameter.setName(openApi.getName() + " body");
                bodyParameter.setRequired(true);
                HashMap<String, String> bodySchema = new HashMap<String, String>();
                bodySchema.put("$ref", "#/definitions/" + openApi.getRequestUrl() + "Using" + openApi.getRequestMethod() + "body");
                bodyParameter.setSchema(bodySchema);
                operation.getParameters().add(bodyParameter);
            }
            HashMap<String, SwaggerOperationResponse> responses = new HashMap<String, SwaggerOperationResponse>();
            SwaggerOperationResponse resp200 = new SwaggerOperationResponse();
            resp200.setDescription("OK");
            HashMap<String, String> respSchema = new HashMap<String, String>();
            respSchema.put("$ref", "#/definitions/OpenApiResult");
            resp200.setSchema(respSchema);
            responses.put("200", resp200);
            HashMap<String, String> emptySchema = new HashMap<String, String>();
            SwaggerOperationResponse resp201 = new SwaggerOperationResponse();
            resp201.setDescription("Created");
            resp201.setSchema(emptySchema);
            responses.put("201", resp201);
            SwaggerOperationResponse resp401 = new SwaggerOperationResponse();
            resp401.setDescription("Unauthorized");
            resp401.setSchema(emptySchema);
            responses.put("401", resp401);
            SwaggerOperationResponse resp403 = new SwaggerOperationResponse();
            resp403.setDescription("Forbidden");
            resp403.setSchema(emptySchema);
            responses.put("403", resp403);
            SwaggerOperationResponse resp404 = new SwaggerOperationResponse();
            resp404.setDescription("Not Found");
            resp404.setSchema(emptySchema);
            responses.put("404", resp404);
            SwaggerDefinition respDefinition = new SwaggerDefinition();
            respDefinition.setType("object");
            HashMap<String, SwaggerDefinitionProperties> definitionProperties = new HashMap<String, SwaggerDefinitionProperties>();
            respDefinition.setProperties(definitionProperties);
            SwaggerDefinitionProperties codeProperties = new SwaggerDefinitionProperties();
            codeProperties.setType("integer");
            codeProperties.setDescription("\u8fd4\u56de\u4ee3\u7801");
            definitionProperties.put("code", codeProperties);
            SwaggerDefinitionProperties messageProperties = new SwaggerDefinitionProperties();
            messageProperties.setType("string");
            messageProperties.setDescription("\u8fd4\u56de\u5904\u7406\u6d88\u606f");
            definitionProperties.put("message", messageProperties);
            SwaggerDefinitionProperties resultProperties = new SwaggerDefinitionProperties();
            resultProperties.setType("object");
            resultProperties.setDescription("\u8fd4\u56de\u6570\u636e\u5bf9\u8c61");
            definitionProperties.put("result", resultProperties);
            SwaggerDefinitionProperties successProperties = new SwaggerDefinitionProperties();
            successProperties.setType("boolean");
            successProperties.setDescription("\u6210\u529f\u6807\u5fd7");
            definitionProperties.put("success", successProperties);
            SwaggerDefinitionProperties timestampProperties = new SwaggerDefinitionProperties();
            timestampProperties.setType("integer");
            timestampProperties.setDescription("\u65f6\u95f4\u6233");
            definitionProperties.put("timestamp", timestampProperties);
            definitions.put("OpenApiResult", respDefinition);
            operation.setResponses(responses);
            operations.put(openApi.getRequestMethod().toLowerCase(), operation);
            paths.put("/openapi/call/" + openApi.getRequestUrl(), operations);
        }
        swaggerModel.setDefinitions(definitions);
        swaggerModel.setPaths(paths);
    }

    private void parameters(SwaggerOperation operation, OpenApi openApi) {
        SwaggerOperationParameter parameter;
        ArrayList<SwaggerOperationParameter> parameters = new ArrayList<SwaggerOperationParameter>();
        for (OpenApiParam openApiParam : this.openApiParamService.findByApiId(openApi.getId())) {
            parameter = new SwaggerOperationParameter();
            parameter.setIn("path");
            parameter.setName(openApiParam.getParamKey());
            parameter.setRequired(openApiParam.getRequired() == 1);
            parameter.setDescription(openApiParam.getNote());
            parameters.add(parameter);
        }
        for (OpenApiHeader openApiHeader : this.openApiHeaderService.findByApiId(openApi.getId())) {
            parameter = new SwaggerOperationParameter();
            parameter.setIn("header");
            parameter.setName(openApiHeader.getHeaderKey());
            parameter.setRequired(openApiHeader.getRequired() == 1);
            parameter.setDescription(openApiHeader.getNote());
            parameters.add(parameter);
        }
        operation.setParameters(parameters);
    }

    private SwaggerInfo swaggerInfo() {
        SwaggerInfo info = new SwaggerInfo();
        info.setDescription("OpenAPI \u63a5\u53e3\u5217\u8868");
        info.setVersion("3.7.1");
        info.setTitle("OpenAPI \u63a5\u53e3\u5217\u8868");
        info.setTermsOfService("https://jeecg.com");
        SwaggerInfoContact contact = new SwaggerInfoContact();
        contact.setName("jeecg@qq.com");
        info.setContact(contact);
        SwaggerInfoLicense license = new SwaggerInfoLicense();
        license.setName("Apache 2.0");
        license.setUrl("http://www.apache.org/licenses/LICENSE-2.0.html");
        info.setLicense(license);
        return info;
    }

    @GetMapping(value={"genPath"})
    public Result<String> genPath() {
        Result r = new Result();
        r.setSuccess(true);
        r.setCode(CommonConstant.SC_OK_200);
        r.setResult((Object)PathGenerator.genPath());
        return r;
    }
}

