/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.message.websocket;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.jeecg.common.base.BaseMap;
import org.jeecg.common.modules.redis.client.JeecgRedisClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
@ServerEndpoint(value="/websocket/{userId}")
public class WebSocket {
    private static final Logger log = LoggerFactory.getLogger(WebSocket.class);
    private static ConcurrentHashMap<String, Session> sessionPool = new ConcurrentHashMap();
    public static final String REDIS_TOPIC_NAME = "socketHandler";
    private static JeecgRedisClient jeecgRedisClient;

    @Autowired
    private void setJeecgRedisClient(JeecgRedisClient jeecgRedisClient) {
        WebSocket.jeecgRedisClient = jeecgRedisClient;
    }

    @OnOpen
    public void onOpen(Session session, @PathParam(value="userId") String userId) {
        try {
            sessionPool.put(userId, session);
            log.debug("\u3010\u7cfb\u7edf WebSocket\u3011\u6709\u65b0\u7684\u8fde\u63a5\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @OnClose
    public void onClose(@PathParam(value="userId") String userId) {
        try {
            sessionPool.remove(userId);
            log.debug("\u3010\u7cfb\u7edf WebSocket\u3011\u8fde\u63a5\u65ad\u5f00\uff0c\u603b\u6570\u4e3a:" + sessionPool.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void pushMessage(String userId, String message) {
        for (Map.Entry<String, Session> item : sessionPool.entrySet()) {
            if (!item.getKey().contains(userId)) continue;
            Session session = item.getValue();
            try {
                Session session2 = session;
                synchronized (session2) {
                    log.debug("\u3010\u7cfb\u7edf WebSocket\u3011\u63a8\u9001\u5355\u4eba\u6d88\u606f:" + message);
                    session.getBasicRemote().sendText(message);
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public void pushMessage(String message) {
        try {
            for (Map.Entry<String, Session> item : sessionPool.entrySet()) {
                try {
                    item.getValue().getAsyncRemote().sendText(message);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            log.debug("\u3010\u7cfb\u7edf WebSocket\u3011\u7fa4\u53d1\u6d88\u606f:" + message);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    @OnMessage
    public void onMessage(String message, @PathParam(value="userId") String userId) {
        if (!"ping".equals(message) && !"heartcheck".equals(message)) {
            log.debug("\u3010\u7cfb\u7edf WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
        } else {
            log.debug("\u3010\u7cfb\u7edf WebSocket\u3011\u6536\u5230\u5ba2\u6237\u7aef\u6d88\u606f:" + message);
            this.sendMessage(userId, "ping");
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        log.warn("\u3010\u7cfb\u7edf WebSocket\u3011\u6d88\u606f\u51fa\u73b0\u9519\u8bef");
        t.printStackTrace();
    }

    public void sendMessage(String message) {
        BaseMap baseMap = new BaseMap();
        baseMap.put("userId", (Object)"");
        baseMap.put("message", (Object)message);
        jeecgRedisClient.sendMessage(REDIS_TOPIC_NAME, baseMap);
    }

    public void sendMessage(String userId, String message) {
        BaseMap baseMap = new BaseMap();
        baseMap.put("userId", (Object)userId);
        baseMap.put("message", (Object)message);
        jeecgRedisClient.sendMessage(REDIS_TOPIC_NAME, baseMap);
    }

    public void sendMessage(String[] userIds, String message) {
        for (String userId : userIds) {
            this.sendMessage(userId, message);
        }
    }
}

