/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.message.enums;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.jeecg.common.system.annotation.EnumDict;
import org.jeecg.common.system.vo.DictModel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@EnumDict(value="rangeDate")
public enum RangeDateEnum {
    JT("jt", "\u4eca\u5929"),
    ZT("zt", "\u6628\u5929"),
    QT("qt", "\u524d\u5929"),
    BZ("bz", "\u672c\u5468"),
    SZ("sz", "\u4e0a\u5468"),
    BY("by", "\u672c\u6708"),
    SY("sy", "\u4e0a\u6708"),
    SEVENDAYS("7day", "7\u65e5"),
    ZDY("zdy", "\u81ea\u5b9a\u4e49\u65e5\u671f");

    private static final Logger log;
    String key;
    String title;

    private RangeDateEnum(String key, String title) {
        this.key = key;
        this.title = title;
    }

    public static List<DictModel> getDictList() {
        ArrayList<DictModel> list = new ArrayList<DictModel>();
        DictModel dictModel = null;
        for (RangeDateEnum e : RangeDateEnum.values()) {
            dictModel = new DictModel();
            dictModel.setValue(e.key);
            dictModel.setText(e.title);
            list.add(dictModel);
        }
        return list;
    }

    public static Date[] getRangeArray(String key) {
        Calendar calendar1 = Calendar.getInstance();
        Calendar calendar2 = Calendar.getInstance();
        Date[] array = new Date[2];
        boolean flag = false;
        if (!RangeDateEnum.JT.key.equals(key)) {
            if (RangeDateEnum.ZT.key.equals(key)) {
                calendar1.add(6, -1);
                calendar2.add(6, -1);
            } else if (RangeDateEnum.QT.key.equals(key)) {
                calendar1.add(6, -2);
                calendar2.add(6, -2);
            } else if (RangeDateEnum.BZ.key.equals(key)) {
                calendar1.set(7, 2);
                calendar2.add(4, 1);
                calendar2.add(7, -1);
            } else if (RangeDateEnum.SZ.key.equals(key)) {
                calendar1.set(7, 2);
                calendar1.add(4, -1);
                calendar2.set(7, 2);
                calendar2.add(7, -1);
            } else if (RangeDateEnum.BY.key.equals(key)) {
                calendar1.set(5, 1);
                calendar2.set(5, 1);
                calendar2.add(2, 1);
                calendar2.add(5, -1);
            } else if (RangeDateEnum.SY.key.equals(key)) {
                calendar1.set(5, 1);
                calendar1.add(2, -1);
                calendar2.set(5, 1);
                calendar2.add(5, -1);
            } else if (RangeDateEnum.SEVENDAYS.key.equals(key)) {
                calendar1.setTime(new Date());
                calendar1.add(5, -7);
            } else {
                flag = true;
            }
        }
        if (flag) {
            return null;
        }
        calendar1.set(10, 0);
        calendar1.set(12, 0);
        calendar1.set(13, 0);
        calendar1.set(14, 0);
        calendar2.set(10, 23);
        calendar2.set(12, 59);
        calendar2.set(13, 59);
        calendar2.set(14, 999);
        array[0] = calendar1.getTime();
        array[1] = calendar2.getTime();
        return array;
    }

    public String getKey() {
        return this.key;
    }

    static {
        log = LoggerFactory.getLogger(RangeDateEnum.class);
    }
}

