/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.message.controller;

import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.dto.message.MessageDTO;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.api.ISysBaseAPI;
import org.jeecg.common.system.base.controller.JeecgController;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.modules.message.entity.MsgParams;
import org.jeecg.modules.message.entity.SysMessageTemplate;
import org.jeecg.modules.message.service.ISysMessageTemplateService;
import org.jeecg.modules.message.util.PushMsgUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
@RequestMapping(value={"/sys/message/sysMessageTemplate"})
public class SysMessageTemplateController
extends JeecgController<SysMessageTemplate, ISysMessageTemplateService> {
    private static final Logger log = LoggerFactory.getLogger(SysMessageTemplateController.class);
    @Autowired
    private ISysMessageTemplateService sysMessageTemplateService;
    @Autowired
    private PushMsgUtil pushMsgUtil;
    @Autowired
    private ISysBaseAPI sysBaseApi;

    @GetMapping(value={"/list"})
    public Result<?> queryPageList(SysMessageTemplate sysMessageTemplate, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = QueryGenerator.initQueryWrapper((Object)((Object)sysMessageTemplate), (Map)req.getParameterMap());
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.sysMessageTemplateService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.ok((Object)pageList);
    }

    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody SysMessageTemplate sysMessageTemplate) {
        this.sysMessageTemplateService.save((Object)sysMessageTemplate);
        return Result.ok((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @PutMapping(value={"/edit"})
    public Result<?> edit(@RequestBody SysMessageTemplate sysMessageTemplate) {
        this.sysMessageTemplateService.updateById((Object)sysMessageTemplate);
        return Result.ok((String)"\u66f4\u65b0\u6210\u529f\uff01");
    }

    @DeleteMapping(value={"/delete"})
    public Result<?> delete(@RequestParam(name="id", required=true) String id) {
        this.sysMessageTemplateService.removeById((Serializable)((Object)id));
        return Result.ok((String)"\u5220\u9664\u6210\u529f!");
    }

    @DeleteMapping(value={"/deleteBatch"})
    public Result<?> deleteBatch(@RequestParam(name="ids", required=true) String ids) {
        this.sysMessageTemplateService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.ok((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @GetMapping(value={"/queryById"})
    public Result<?> queryById(@RequestParam(name="id", required=true) String id) {
        SysMessageTemplate sysMessageTemplate = (SysMessageTemplate)((Object)this.sysMessageTemplateService.getById((Serializable)((Object)id)));
        return Result.ok((Object)((Object)sysMessageTemplate));
    }

    @GetMapping(value={"/exportXls"})
    public ModelAndView exportXls(HttpServletRequest request, SysMessageTemplate sysMessageTemplate) {
        return super.exportXls(request, (Object)sysMessageTemplate, SysMessageTemplate.class, "\u63a8\u9001\u6d88\u606f\u6a21\u677f");
    }

    @PostMapping(value={"/importExcel"})
    public Result<?> importExcel(HttpServletRequest request, HttpServletResponse response) {
        return super.importExcel(request, response, SysMessageTemplate.class);
    }

    @PostMapping(value={"/sendMsg"})
    public Result<SysMessageTemplate> sendMessage(@RequestBody MsgParams msgParams) {
        Result result = new Result();
        try {
            MessageDTO md = new MessageDTO();
            md.setToAll(Boolean.valueOf(false));
            md.setTitle("\u6d88\u606f\u53d1\u9001\u6d4b\u8bd5");
            md.setTemplateCode(msgParams.getTemplateCode());
            md.setToUser(msgParams.getReceiver());
            md.setType(msgParams.getMsgType());
            String testData = msgParams.getTestData();
            if (oConvertUtils.isNotEmpty((Object)testData)) {
                Map data = (Map)JSON.parseObject((String)testData, Map.class);
                md.setData(data);
            }
            this.sysBaseApi.sendTemplateMessage(md);
            return result.success("\u6d88\u606f\u53d1\u9001\u6210\u529f\uff01");
        }
        catch (Exception e) {
            log.error("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff1a" + e.getMessage(), (Throwable)e);
            return result.error500("\u53d1\u9001\u6d88\u606f\u51fa\u9519\uff01");
        }
    }
}

