/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.cas.controller;

import com.alibaba.fastjson.JSONObject;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.modules.cas.util.CasServiceUtil;
import org.jeecg.modules.cas.util.XmlUtils;
import org.jeecg.modules.system.entity.SysDepart;
import org.jeecg.modules.system.entity.SysUser;
import org.jeecg.modules.system.service.ISysDepartService;
import org.jeecg.modules.system.service.ISysUserService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/sys/cas/client"})
public class CasClientController {
    private static final Logger log = LoggerFactory.getLogger(CasClientController.class);
    @Autowired
    private ISysUserService sysUserService;
    @Autowired
    private ISysDepartService sysDepartService;
    @Autowired
    private RedisUtil redisUtil;
    @Value(value="${cas.prefixUrl}")
    private String prefixUrl;

    @GetMapping(value={"/validateLogin"})
    public Object validateLogin(@RequestParam(name="ticket") String ticket, @RequestParam(name="service") String service, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Result result = new Result();
        log.info("Rest api login.");
        try {
            String validateUrl = this.prefixUrl + "/p3/serviceValidate";
            String res = CasServiceUtil.getStValidate(validateUrl, ticket, service);
            log.info("res." + res);
            String error = XmlUtils.getTextForElement(res, "authenticationFailure");
            if (StringUtils.isNotEmpty((String)error)) {
                throw new Exception(error);
            }
            String principal = XmlUtils.getTextForElement(res, "user");
            if (StringUtils.isEmpty((String)principal)) {
                throw new Exception("No principal was found in the response from the CAS server.");
            }
            log.info("-------token----username---" + principal);
            SysUser sysUser = this.sysUserService.getUserByName(principal);
            result = this.sysUserService.checkUserIsEffective(sysUser);
            if (!result.isSuccess()) {
                return result;
            }
            String token = JwtUtil.sign((String)sysUser.getUsername(), (String)sysUser.getPassword());
            this.redisUtil.set("prefix_user_token:" + token, (Object)token);
            this.redisUtil.expire("prefix_user_token:" + token, 604800L);
            JSONObject obj = new JSONObject();
            List<SysDepart> departs = this.sysDepartService.queryUserDeparts(sysUser.getId());
            obj.put("departs", departs);
            if (departs == null || departs.size() == 0) {
                obj.put("multi_depart", (Object)0);
            } else if (departs.size() == 1) {
                this.sysUserService.updateUserDepart(principal, departs.get(0).getOrgCode(), null);
                obj.put("multi_depart", (Object)1);
            } else {
                obj.put("multi_depart", (Object)2);
            }
            obj.put("token", (Object)token);
            obj.put("userInfo", (Object)sysUser);
            result.setResult((Object)obj);
            result.success("\u767b\u5f55\u6210\u529f");
        }
        catch (Exception e) {
            result.error500(e.getMessage());
        }
        return new HttpEntity((Object)result);
    }
}

