/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.init;

import cn.hutool.core.io.FileUtil;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.context.event.ApplicationReadyEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.stereotype.Component;

@Component
public class CodeTemplateInitListener
implements ApplicationListener<ApplicationReadyEvent> {
    private static final Logger log = LoggerFactory.getLogger(CodeTemplateInitListener.class);

    public void onApplicationEvent(ApplicationReadyEvent event) {
        try {
            log.info(" Init Code Generate Template [ \u68c0\u6d4b\u5982\u679c\u662fJAR\u542f\u52a8\u73af\u5883\uff0cCopy\u6a21\u677f\u5230config\u76ee\u5f55 ] ");
            this.initJarConfigCodeGeneratorTemplate();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void initJarConfigCodeGeneratorTemplate() throws Exception {
        Resource[] resources;
        String configPath = System.getProperty("user.dir") + File.separator + "config" + File.separator;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        for (Resource re : resources = resolver.getResources("classpath*:jeecg/code-template-online/**/*")) {
            URL url = re.getURL();
            String filepath = url.getPath();
            filepath = URLDecoder.decode(filepath, "utf-8");
            String createFilePath = configPath + filepath.substring(filepath.indexOf("jeecg/code-template-online"));
            if (!filepath.contains(".jar!/BOOT-INF/lib/") || !createFilePath.contains(".") || FileUtil.exist((String)createFilePath)) continue;
            log.info("create file codeTemplate = " + createFilePath);
            FileUtil.writeString((String)IOUtils.toString((URL)url, (Charset)StandardCharsets.UTF_8), (String)createFilePath, (String)"UTF-8");
        }
    }
}

