/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.quartz.job;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.jeecg.common.util.DateUtils;
import org.jeecg.modules.htvideo.entity.HostSslReplaceRecord;
import org.jeecg.modules.htvideo.entity.HtJumpDomains;
import org.jeecg.modules.htvideo.entity.HtSiteGroup;
import org.jeecg.modules.htvideo.service.IHostSslReplaceRecordService;
import org.jeecg.modules.htvideo.service.IHtJumpDomainsService;
import org.jeecg.modules.htvideo.service.IHtSiteGroupService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class JumpDomainsJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(JumpDomainsJob.class);
    @Value(value="${jeecg.path.upload}")
    private String uploadPath;
    @Value(value="${ht.syncPath}")
    protected String syncPath;
    @Autowired
    private IHtSiteGroupService htSiteGroupService;
    @Autowired
    private IHtJumpDomainsService jumpDomainsService;
    @Autowired
    private IHostSslReplaceRecordService sslReplaceRecordService;
    @Value(value="${spring.resource.static-locations}")
    private String staticLocations;
    private String parameter;

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        log.info("\u5f00\u59cb\u6267\u884c\u8df3\u8f6c\u57df\u540d\u548cSSL\u8bc1\u4e66\u6570\u636e\u751f\u6210\u4efb\u52a1\uff0cJob Execution key\uff1a" + String.valueOf(jobExecutionContext.getJobDetail().getKey()));
        try {
            JSONObject jsonData = this.generateJsonData();
            this.saveJsonToStaticFolder(jsonData);
            log.info("\u8df3\u8f6c\u57df\u540d\u548cSSL\u8bc1\u4e66\u6570\u636e\u751f\u6210\u4efb\u52a1\u6267\u884c\u6210\u529f\uff01\u65f6\u95f4: " + DateUtils.now());
        }
        catch (Exception e) {
            log.error("\u8df3\u8f6c\u57df\u540d\u548cSSL\u8bc1\u4e66\u6570\u636e\u751f\u6210\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }

    private JSONObject generateJsonData() {
        JSONObject result = new JSONObject();
        List allDomains = this.jumpDomainsService.list();
        Map<String, List<HtJumpDomains>> domainsByChannel = allDomains.stream().filter(domain -> domain.getUsefull() == 1).collect(Collectors.groupingBy(HtJumpDomains::getChannelId));
        JSONArray jumpDomainsArray = new JSONArray();
        for (Map.Entry<String, List<HtJumpDomains>> entry : domainsByChannel.entrySet()) {
            String channelId = entry.getKey();
            List<HtJumpDomains> domains = entry.getValue();
            if (domains.isEmpty()) continue;
            JSONObject channelObj = new JSONObject();
            channelObj.put("channel_id", (Object)channelId);
            HtSiteGroup htSiteGroup = (HtSiteGroup)this.htSiteGroupService.getById((Serializable)((Object)channelId));
            if (htSiteGroup == null) continue;
            channelObj.put("domain", (Object)htSiteGroup.getDomainName());
            String originalJumpDomains = htSiteGroup.getJumpDomains();
            String[] jumpDomains = new String[]{};
            if (originalJumpDomains != null && !originalJumpDomains.isEmpty()) {
                jumpDomains = originalJumpDomains.split("\\s*\\R\\s*");
            }
            channelObj.put("jump_domains", (Object)jumpDomains);
            jumpDomainsArray.add((Object)channelObj);
        }
        result.put("jump_domains", (Object)jumpDomainsArray);
        List allSslRecords = this.sslReplaceRecordService.list();
        JSONArray sslArray = new JSONArray();
        for (HostSslReplaceRecord record : allSslRecords) {
            if (record.getSslFullchain() == null || record.getSslFullchain().isEmpty()) continue;
            JSONObject sslObj = new JSONObject();
            sslObj.put("host", (Object)record.getHost());
            sslObj.put("private_key", (Object)record.getPrivateKey());
            sslObj.put("fullchain_crt", (Object)record.getSslFullchain());
            sslArray.add((Object)sslObj);
        }
        result.put("ssl", (Object)sslArray);
        return result;
    }

    private void saveJsonToStaticFolder(JSONObject jsonData) throws IOException {
        String jsonFilePath = this.uploadPath + "/conf/domains_config.json";
        File directory = new File(this.uploadPath + "/conf");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File jsonFile = new File(jsonFilePath);
        try (FileWriter writer = new FileWriter(jsonFile);){
            writer.write(jsonData.toJSONString());
        }
        log.info("JSON\u6587\u4ef6\u5df2\u4fdd\u5b58\u5230: " + jsonFile.getAbsolutePath());
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", this.syncPath + "sync_conf.sh");
            processBuilder.redirectErrorStream(true);
            processBuilder.start();
        }
        catch (Exception e) {
            log.info("sync_conf.sh\u6267\u884c\u51fa\u9519\u4e86: " + e.toString());
        }
    }
}

