/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.quartz.job;

import cn.hutool.core.date.DateTime;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.htvideo.controller.monitor.MonitorUtils;
import org.jeecg.modules.htvideo.entity.HtMonitorRecord;
import org.jeecg.modules.htvideo.service.IHtMonitorRecordService;
import org.quartz.Job;
import org.quartz.JobExecutionContext;
import org.quartz.JobExecutionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AsyncMonitorDomainsJob
implements Job {
    private static final Logger log = LoggerFactory.getLogger(AsyncMonitorDomainsJob.class);
    @Autowired
    private MonitorUtils monitorUtils;
    @Autowired
    private IHtMonitorRecordService htMonitorRecordService;
    private String parameter;

    public void setParameter(String parameter) {
        this.parameter = parameter;
    }

    public void execute(JobExecutionContext jobExecutionContext) throws JobExecutionException {
        try {
            Result<?> result = this.monitorUtils.getDomains();
            if (result.getCode() != 200) {
                return;
            }
            Object data = result.getResult();
            if (data == null) {
                return;
            }
            if (!(data instanceof List)) {
                return;
            }
            List list = (List)data;
            for (Object item : list) {
                Map obj = (Map)item;
                HtMonitorRecord record = new HtMonitorRecord();
                record.setUrl((String)obj.get("domainName"));
                record.setGid((String)obj.get("groupName"));
                record.setRemark((String)obj.get("remark"));
                record.setTelegramGroupId((String)obj.get("telegramGroupId"));
                record.setHttpStatus((String)obj.get("httpStatus"));
                record.setDelayMs(obj.get("delayMs") != null ? Integer.valueOf(((Number)obj.get("delayMs")).intValue()) : null);
                record.setNodeCount(obj.get("nodeCount") != null ? Integer.valueOf(((Number)obj.get("nodeCount")).intValue()) : null);
                record.setNodeAvailableCount(obj.get("nodeAvailableCount") != null ? Integer.valueOf(((Number)obj.get("nodeAvailableCount")).intValue()) : null);
                record.setNodeAvailability(String.valueOf(obj.get("nodeAvailability")));
                record.setWarningAvailability(String.valueOf(obj.get("warningAvailability")));
                record.setWarningFrequency(String.valueOf(obj.get("warningFrequency")));
                record.setHttpStatusDefault((String)obj.get("httpStatusDefault"));
                record.setStatus(obj.get("status") != null ? Integer.valueOf(((Number)obj.get("status")).intValue()) : null);
                if (obj.get("createDate") != null) {
                    record.setCreateDate((Date)new DateTime((CharSequence)obj.get("createDate").toString()));
                }
                if (obj.get("updateDate") != null) {
                    record.setUpdateDate((Date)new DateTime((CharSequence)obj.get("updateDate").toString()));
                }
                UpdateWrapper wrapper = new UpdateWrapper();
                wrapper.eq((Object)"url", (Object)record.getUrl());
                this.htMonitorRecordService.update(record, (Wrapper)wrapper);
            }
        }
        catch (Exception e) {
            log.error("\u8df3\u8f6c\u57df\u540d\u548cSSL\u8bc1\u4e66\u6570\u636e\u751f\u6210\u4efb\u52a1\u6267\u884c\u5931\u8d25", (Throwable)e);
            throw new JobExecutionException((Throwable)e);
        }
    }
}

