/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.RestUtil;
import org.jeecg.modules.htvideo.controller.ApiConfig;
import org.jeecg.modules.htvideo.controller.BaseController;
import org.jeecg.modules.htvideo.dto.SiteGroupDTO;
import org.jeecg.modules.htvideo.entity.HostSslReplaceRecord;
import org.jeecg.modules.htvideo.entity.HtCloudFlareRecord;
import org.jeecg.modules.htvideo.entity.HtJumpDomains;
import org.jeecg.modules.htvideo.entity.HtSiteGroup;
import org.jeecg.modules.htvideo.groups.UpdateGroup;
import org.jeecg.modules.htvideo.service.IHostSslReplaceRecordService;
import org.jeecg.modules.htvideo.service.IHtCloudFlareRecordService;
import org.jeecg.modules.htvideo.service.IHtJumpDomainsService;
import org.jeecg.modules.htvideo.service.IHtSiteGroupService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u7ad9\u5206\u7ec4\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/ht/sitegroup"})
public class HtSiteGroupController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(HtSiteGroupController.class);
    @Autowired
    private IHtSiteGroupService htSiteGroupService;
    @Autowired
    private IHtJumpDomainsService htJumpDomainsService;
    @Autowired
    private IHtCloudFlareRecordService htCloudFlareRecordService;
    @Autowired
    private IHostSslReplaceRecordService hostSslReplaceRecordService;
    @Value(value="${jeecg.path.upload}")
    private String uploadPath;
    @Value(value="${jeecg.path.webapp}")
    protected String jsPath;
    @Value(value="${ht.syncPath}")
    protected String syncPath;

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<IPage<HtSiteGroup>> queryPageList(@RequestBody Map<String, Object> params) {
        Page page = new Page((long)Integer.parseInt(params.getOrDefault("pageNo", 1).toString()), (long)Integer.parseInt(params.getOrDefault("pageSize", 10).toString()));
        String keyword = (String)params.get("keyword");
        QueryWrapper queryWrapper = new QueryWrapper();
        if (keyword != null && !keyword.isEmpty()) {
            queryWrapper.and(wq -> ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)wq.like((Object)"channel_name", (Object)keyword)).or()).like((Object)"site_name", (Object)keyword)).or()).like((Object)"domain_name", (Object)keyword));
        }
        if (params.get("status") != null) {
            queryWrapper.eq((Object)"status", (Object)Integer.valueOf(params.get("status").toString()));
        }
        queryWrapper.orderByDesc((Object)"update_time");
        IPage pageList = this.htSiteGroupService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u6dfb\u52a0")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u6dfb\u52a0", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<HtSiteGroup> add(@RequestBody @Validated SiteGroupDTO siteGroupDTO) {
        try {
            HtSiteGroup htSiteGroup = new HtSiteGroup();
            BeanUtils.copyProperties((Object)siteGroupDTO, (Object)htSiteGroup);
            String originalDomainName = htSiteGroup.getDomainName();
            CharSequence[] domains = new String[]{};
            if (originalDomainName != null && !originalDomainName.isEmpty()) {
                domains = originalDomainName.split("\\s*\\R\\s*");
                String commaSeparatedDomains = String.join((CharSequence)",", domains);
                htSiteGroup.setDomainName(commaSeparatedDomains);
            }
            String originalJumpDomains = htSiteGroup.getJumpDomains();
            CharSequence[] jumpDomains = new String[]{};
            if (originalJumpDomains != null && !originalJumpDomains.isEmpty()) {
                jumpDomains = originalJumpDomains.split("\\s*\\R\\s*");
                String commaSeparatedDomains = String.join((CharSequence)",", jumpDomains);
                htSiteGroup.setJumpDomains(commaSeparatedDomains);
            }
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            htSiteGroup.setCreateTime(new Date());
            htSiteGroup.setCreateBy(sysUser.getUsername());
            htSiteGroup.setUpdateTime(new Date());
            htSiteGroup.setUpdateBy(sysUser.getUsername());
            this.htSiteGroupService.save(htSiteGroup);
            if (domains.length > 0) {
                for (CharSequence domain : domains) {
                    HtCloudFlareRecord cloudFlareRecord;
                    long _count2;
                    long _count;
                    CharSequence host = "";
                    int port = 80;
                    if (((String)domain).contains(":")) {
                        String[] parts = ((String)domain).split(":");
                        host = parts[0];
                        try {
                            port = Integer.parseInt(parts[1]);
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else {
                        host = domain;
                    }
                    if ((_count = this.htJumpDomainsService.count((Wrapper)new QueryWrapper().eq((Object)"domain", (Object)host))) == 0L) {
                        HtJumpDomains htJumpDomains = new HtJumpDomains();
                        htJumpDomains.setDomain((String)host);
                        htJumpDomains.setPort(port);
                        htJumpDomains.setChannelId(htSiteGroup.getId().toString());
                        htJumpDomains.setUsefull(1);
                        this.htJumpDomainsService.save(htJumpDomains);
                    }
                    if ((_count2 = this.hostSslReplaceRecordService.count((Wrapper)new QueryWrapper().eq((Object)"host", (Object)host))) != 0L || (cloudFlareRecord = (HtCloudFlareRecord)this.htCloudFlareRecordService.getOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)htSiteGroup.getCloudFlare()))) == null) continue;
                    HostSslReplaceRecord hostSslReplaceRecord = new HostSslReplaceRecord();
                    hostSslReplaceRecord.setHost((String)host);
                    hostSslReplaceRecord.setCfAccountId(cloudFlareRecord.getCfAccountId());
                    hostSslReplaceRecord.setCfApiKey(cloudFlareRecord.getCfApiKey());
                    hostSslReplaceRecord.setCfToken(cloudFlareRecord.getCfToken());
                    hostSslReplaceRecord.setZerosslApi(cloudFlareRecord.getZerosslApi());
                    this.hostSslReplaceRecordService.save(hostSslReplaceRecord);
                }
            }
            JSONObject jsonData = this.generateJsonData();
            this.saveJsonToStaticFolder(jsonData);
            JSONObject params = new JSONObject();
            params.put("oriChannelId", (Object)5);
            params.put("newChannelId", (Object)htSiteGroup.getId());
            RestUtil.post((String)(this.apiPath + ApiConfig.addAdvByBaseChannel), null, (JSONObject)this.baseBodyParams(params));
            RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
            return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01", (Object)htSiteGroup);
        }
        catch (Exception e) {
            log.error(e.toString());
            return Result.error((String)"\u6dfb\u52a0\u5931\u8d25");
        }
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u7f16\u8f91")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u7f16\u8f91", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<HtSiteGroup> edit(@RequestBody @Validated(value={UpdateGroup.class}) SiteGroupDTO siteGroupDTO) {
        try {
            HtSiteGroup htSiteGroup = (HtSiteGroup)this.htSiteGroupService.getById(siteGroupDTO.getId());
            if (htSiteGroup == null) {
                return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f");
            }
            String originalDomainName = siteGroupDTO.getDomainName();
            CharSequence[] domains = new String[]{};
            if (originalDomainName != null && !originalDomainName.isEmpty()) {
                domains = originalDomainName.split("\\s*\\R\\s*");
                String commaSeparatedDomains = String.join((CharSequence)",", domains);
                htSiteGroup.setDomainName(commaSeparatedDomains);
            }
            String originalJumpDomains = siteGroupDTO.getJumpDomains();
            CharSequence[] jumpDomains = new String[]{};
            if (originalJumpDomains != null && !originalJumpDomains.isEmpty()) {
                jumpDomains = originalJumpDomains.split("\\s*\\R\\s*");
                String commaSeparatedDomains = String.join((CharSequence)",", jumpDomains);
                htSiteGroup.setJumpDomains(commaSeparatedDomains);
            }
            BeanUtils.copyProperties((Object)siteGroupDTO, (Object)htSiteGroup, (String[])new String[]{"domainName", "jumpDomains"});
            LoginUser sysUser = (LoginUser)SecurityUtils.getSubject().getPrincipal();
            htSiteGroup.setUpdateTime(new Date());
            htSiteGroup.setUpdateBy(sysUser.getUsername());
            this.htSiteGroupService.updateById(htSiteGroup);
            if (domains.length > 0) {
                for (CharSequence domain : domains) {
                    HtCloudFlareRecord cloudFlareRecord;
                    long _count2;
                    long _count;
                    CharSequence host = "";
                    int port = 80;
                    if (((String)domain).contains(":")) {
                        String[] parts = ((String)domain).split(":");
                        host = parts[0];
                        try {
                            port = Integer.parseInt(parts[1]);
                        }
                        catch (NumberFormatException e) {
                            System.out.println("\u7aef\u53e3\u683c\u5f0f\u9519\u8bef");
                        }
                    } else {
                        host = domain;
                    }
                    if ((_count = this.htJumpDomainsService.count((Wrapper)new QueryWrapper().eq((Object)"domain", (Object)host))) == 0L) {
                        HtJumpDomains htJumpDomains = new HtJumpDomains();
                        htJumpDomains.setDomain((String)host);
                        htJumpDomains.setPort(port);
                        htJumpDomains.setChannelId(htSiteGroup.getId().toString());
                        htJumpDomains.setUsefull(1);
                        this.htJumpDomainsService.save(htJumpDomains);
                    }
                    if ((_count2 = this.hostSslReplaceRecordService.count((Wrapper)new QueryWrapper().eq((Object)"host", (Object)domain))) != 0L || (cloudFlareRecord = (HtCloudFlareRecord)this.htCloudFlareRecordService.getOne((Wrapper)new QueryWrapper().eq((Object)"id", (Object)htSiteGroup.getCloudFlare()))) == null) continue;
                    HostSslReplaceRecord hostSslReplaceRecord = new HostSslReplaceRecord();
                    hostSslReplaceRecord.setHost((String)domain);
                    hostSslReplaceRecord.setCfAccountId(cloudFlareRecord.getCfAccountId());
                    hostSslReplaceRecord.setCfApiKey(cloudFlareRecord.getCfApiKey());
                    hostSslReplaceRecord.setCfToken(cloudFlareRecord.getCfToken());
                    hostSslReplaceRecord.setZerosslApi(cloudFlareRecord.getZerosslApi());
                    this.hostSslReplaceRecordService.save(hostSslReplaceRecord);
                }
            }
            JSONObject jsonData = this.generateJsonData();
            this.saveJsonToStaticFolder(jsonData);
            RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
            return Result.OK((String)"\u7f16\u8f91\u6210\u529f!", (Object)htSiteGroup);
        }
        catch (Exception e) {
            log.error(e.toString());
            return Result.error((String)"\u7f16\u8f91\u5931\u8d25");
        }
    }

    private JSONObject generateJsonData() {
        JSONObject result = new JSONObject();
        List allDomains = this.htJumpDomainsService.list();
        Map<String, List<HtJumpDomains>> domainsByChannel = allDomains.stream().filter(domain -> domain.getUsefull() == 1).collect(Collectors.groupingBy(HtJumpDomains::getChannelId));
        JSONArray jumpDomainsArray = new JSONArray();
        for (Map.Entry<String, List<HtJumpDomains>> entry : domainsByChannel.entrySet()) {
            String channelId = entry.getKey();
            List<HtJumpDomains> domains = entry.getValue();
            if (domains.isEmpty()) continue;
            JSONObject channelObj = new JSONObject();
            channelObj.put("channel_id", (Object)channelId);
            HtSiteGroup htSiteGroup = (HtSiteGroup)this.htSiteGroupService.getById((Serializable)((Object)channelId));
            if (htSiteGroup == null) continue;
            channelObj.put("domain", (Object)htSiteGroup.getDomainName());
            String originalJumpDomains = htSiteGroup.getJumpDomains();
            String[] jumpDomains = new String[]{};
            if (originalJumpDomains != null && !originalJumpDomains.isEmpty()) {
                jumpDomains = originalJumpDomains.split("\\s*\\R\\s*");
            }
            channelObj.put("jump_domains", (Object)jumpDomains);
            jumpDomainsArray.add((Object)channelObj);
        }
        result.put("jump_domains", (Object)jumpDomainsArray);
        List allSslRecords = this.hostSslReplaceRecordService.list();
        JSONArray sslArray = new JSONArray();
        for (HostSslReplaceRecord record : allSslRecords) {
            if (record.getSslFullchain() == null || record.getSslFullchain().isEmpty()) continue;
            JSONObject sslObj = new JSONObject();
            sslObj.put("host", (Object)record.getHost());
            sslObj.put("private_key", (Object)record.getPrivateKey());
            sslObj.put("fullchain_crt", (Object)record.getSslFullchain());
            sslArray.add((Object)sslObj);
        }
        result.put("ssl", (Object)sslArray);
        return result;
    }

    private void saveJsonToStaticFolder(JSONObject jsonData) throws IOException {
        String jsonFilePath = this.uploadPath + "/conf/domains_config.json";
        File directory = new File(this.uploadPath + "/conf");
        if (!directory.exists()) {
            directory.mkdirs();
        }
        File jsonFile = new File(jsonFilePath);
        try (FileWriter writer = new FileWriter(jsonFile);){
            writer.write(jsonData.toJSONString());
        }
        log.info("JSON\u6587\u4ef6\u5df2\u4fdd\u5b58\u5230: " + jsonFile.getAbsolutePath());
        try {
            ProcessBuilder processBuilder = new ProcessBuilder("/bin/bash", this.syncPath + "sync_conf.sh");
            processBuilder.redirectErrorStream(true);
            processBuilder.start();
        }
        catch (Exception e) {
            log.info("sync_conf.sh\u6267\u884c\u51fa\u9519\u4e86: " + e.toString());
        }
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        this.htSiteGroupService.removeById(id);
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u67e5\u8be2")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u67e5\u8be2", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u901a\u8fc7id\u67e5\u8be2")
    @PostMapping(value={"/queryById"})
    public Result<HtSiteGroup> queryById(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        HtSiteGroup htSiteGroup = (HtSiteGroup)this.htSiteGroupService.getById(id);
        if (htSiteGroup == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f");
        }
        return Result.OK((Object)htSiteGroup);
    }

    @ApiOperation(value="\u751f\u6210hm.js\u548cconf.js", notes="\u6839\u636eid\u751f\u6210js\u6587\u4ef6")
    @PostMapping(value={"/generateJsFile"})
    public Result<?> generateJsFile(@RequestBody Map<String, Integer> params) {
        Integer id = params.get("id");
        if (id == null) {
            return Result.error((String)"\u7f3a\u5c11\u53c2\u6570id");
        }
        HtSiteGroup htSiteGroup = (HtSiteGroup)this.htSiteGroupService.getById(id);
        if (htSiteGroup == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f");
        }
        String domainName = htSiteGroup.getDomainName();
        String statisticsCode = htSiteGroup.getStatisticsCode();
        String statisticsScript = htSiteGroup.getStatisticsScript();
        Integer cid = htSiteGroup.getId();
        String siteName = htSiteGroup.getSiteName();
        if (StringUtils.isNotBlank((String)domainName)) {
            String[] domainList;
            for (String domain : domainList = domainName.split(",")) {
                if (!StringUtils.isNotBlank((String)domain)) continue;
                domain = domain.replace(":", "-");
                String tjDir = this.uploadPath + "/tj";
                File tjdir = new File(tjDir);
                if (!tjdir.exists()) {
                    tjdir.mkdirs();
                }
                File tjJs = new File(tjdir, domain + ".js");
                try (FileWriter writer = new FileWriter(tjJs, false);){
                    writer.write("var __xyz_cid_=\"" + cid + "\";");
                    writer.write("var __xyz_sn_=\"" + siteName + "\";");
                    writer.write(statisticsCode != null ? statisticsCode : "");
                }
                catch (IOException e) {
                    log.error("\u751f\u6210\u6e20\u9053[{}]\u7684\u7edf\u8ba1\u4ee3\u7801\u5931\u8d25", (Object)siteName, (Object)e);
                    return Result.error((String)("\u751f\u6210\u7edf\u8ba1\u4ee3\u7801\u5931\u8d25: " + e.getMessage()));
                }
                String baseDir = this.jsPath + "/" + domain;
                File dir = new File(baseDir);
                if (!dir.exists()) {
                    dir.mkdirs();
                }
                File hmHtml = new File(dir, "hm.html");
                try (FileWriter writer = new FileWriter(hmHtml, false);){
                    writer.write(statisticsScript != null ? statisticsScript : "");
                }
                catch (IOException e) {
                    log.error("\u751f\u6210\u6e20\u9053[{}]\u7684hm.html\u5931\u8d25", (Object)siteName, (Object)e);
                    return Result.error((String)("\u751f\u6210hm.html\u5931\u8d25: " + e.getMessage()));
                }
                File confJs = new File(dir, "conf.js");
                try (FileWriter writer = new FileWriter(confJs, false);){
                    writer.write("var __xyz_cid_=\"" + cid + "\";");
                    writer.write("var __xyz_sn_=\"" + siteName + "\";");
                }
                catch (IOException e) {
                    return Result.error((String)("\u751f\u6210conf.js\u5931\u8d25: " + e.getMessage()));
                }
            }
        }
        return Result.OK((String)"\u751f\u6210js\u6587\u4ef6\u6210\u529f\uff01");
    }

    @AutoLog(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u67e5\u8be2\u5168\u90e8")
    @ApiOperation(value="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u67e5\u8be2\u5168\u90e8", notes="\u7f51\u7ad9\u5206\u7ec4\u4fe1\u606f-\u67e5\u8be2\u5168\u90e8")
    @PostMapping(value={"/listAll"})
    public Result<List<HtSiteGroup>> queryAllList(@RequestParam(name="channelName", required=false) String channelName, @RequestParam(name="siteName", required=false) String siteName, @RequestParam(name="domainName", required=false) String domainName) {
        HtSiteGroup record = new HtSiteGroup();
        record.setChannelName(channelName);
        record.setSiteName(siteName);
        record.setDomainName(domainName);
        QueryWrapper queryWrapper = new QueryWrapper((Object)record);
        List list = this.htSiteGroupService.list((Wrapper)queryWrapper);
        return Result.OK((Object)list);
    }
}

