/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.controller;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.util.IpUtils;
import org.jeecg.modules.htvideo.entity.HtPushServers;
import org.jeecg.modules.htvideo.service.IHtPushServersService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u63a8\u9001\u670d\u52a1\u5668\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/ht/pushservers"})
public class HtNodeServersController {
    private static final Logger log = LoggerFactory.getLogger(HtNodeServersController.class);
    @Autowired
    private IHtPushServersService htPushServersService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<IPage<HtPushServers>> list(HtPushServers record, @RequestParam(name="pageNo", defaultValue="1") Integer pageNo, @RequestParam(name="pageSize", defaultValue="10") Integer pageSize, HttpServletRequest req) {
        QueryWrapper queryWrapper = new QueryWrapper((Object)record);
        Page page = new Page((long)pageNo.intValue(), (long)pageSize.intValue());
        IPage pageList = this.htPushServersService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u63a8\u9001\u670d\u52a1\u5668")
    @PostMapping(value={"/listAll"})
    public Result<List<HtPushServers>> getAll() {
        List list = this.htPushServersService.list();
        return Result.OK((Object)list);
    }

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody HtPushServers record) {
        this.htPushServersService.save(record);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<String> edit(@RequestBody HtPushServers record) {
        this.htPushServersService.updateById(record);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<String> delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        this.htPushServersService.removeById(id);
        return Result.OK((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u901a\u8fc7id\u4fee\u6539checked\u7684\u72b6\u6001")
    @PostMapping(value={"/editChecked"})
    public Result<String> editChecked(@RequestBody Map<String, Object> params, HttpServletRequest request) {
        Integer checked = (Integer)params.get("checked");
        String ip = IpUtils.getIpAddr((HttpServletRequest)request);
        log.info("\u8bf7\u6c42IP: {}", (Object)ip);
        HtPushServers record = (HtPushServers)this.htPushServersService.getOne((Wrapper)new QueryWrapper().eq((Object)"host", (Object)ip));
        if (record != null) {
            record.setChecked(checked);
            this.htPushServersService.updateById(record);
            return Result.OK((String)"\u4fee\u6539\u6210\u529f\uff01");
        }
        return Result.error((String)"\u53c2\u6570\u9519\u8bef");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestBody Map<String, Object> params) {
        String ids = params.get("ids").toString();
        this.htPushServersService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2")
    @PostMapping(value={"/queryById"})
    public Result<HtPushServers> queryById(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        HtPushServers record = (HtPushServers)this.htPushServersService.getById(id);
        return Result.OK((Object)record);
    }
}

