/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.controller;

import cn.hutool.core.date.DateTime;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.htvideo.controller.monitor.MonitorUtils;
import org.jeecg.modules.htvideo.entity.HtMonitorRecord;
import org.jeecg.modules.htvideo.entity.HtSiteChannelDomain;
import org.jeecg.modules.htvideo.service.IHtMonitorRecordService;
import org.jeecg.modules.htvideo.service.IHtSiteChannelDomainService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u76d1\u63a7\u8bb0\u5f55\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/ht/monitor/record"})
public class HtMonitorRecordController {
    @Autowired
    private MonitorUtils monitorUtils;
    @Autowired
    private IHtMonitorRecordService htMonitorRecordService;
    @Autowired
    private IHtSiteChannelDomainService domainService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<IPage<HtMonitorRecord>> list(@RequestBody Map<String, Object> params) {
        Page page = new Page((long)Integer.parseInt(params.getOrDefault("pageNo", 1).toString()), (long)Integer.parseInt(params.getOrDefault("pageSize", 10).toString()));
        QueryWrapper queryWrapper = new QueryWrapper();
        if (params.get("url") != null) {
            queryWrapper.eq((Object)"url", params.get("url"));
        }
        if (params.get("gid") != null) {
            queryWrapper.eq((Object)"gid", params.get("gid"));
        }
        if (params.get("httpStatus") != null) {
            queryWrapper.eq((Object)"httpStatus", params.get("httpStatus"));
        }
        IPage pageList = this.htMonitorRecordService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody HtMonitorRecord record) {
        JSONObject json = new JSONObject();
        json.put("groupName", (Object)record.getGid());
        json.put("domainName", (Object)record.getUrl());
        json.put("remark", (Object)record.getRemark());
        json.put("telegramGroupId", (Object)"");
        Result<?> result = this.monitorUtils.domainSave(json);
        if (result.getCode() != 200 && result.getCode() != 409) {
            return Result.error((String)result.getMessage());
        }
        HtMonitorRecord exist = (HtMonitorRecord)((LambdaQueryChainWrapper)this.htMonitorRecordService.lambdaQuery().eq(HtMonitorRecord::getUrl, (Object)record.getUrl())).one();
        if (exist != null) {
            return Result.error((String)"\u8be5 URL \u5df2\u5b58\u5728\uff0c\u4e0d\u80fd\u91cd\u590d\u6dfb\u52a0");
        }
        this.htMonitorRecordService.save(record);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<String> edit(@RequestBody HtMonitorRecord record) {
        this.htMonitorRecordService.updateById(record);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<String> delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        String url = params.get("url").toString();
        String gid = params.get("gid").toString();
        JSONObject json = new JSONObject();
        json.put("groupName", (Object)gid);
        json.put("domainName", (Object)url);
        Result<?> result = this.monitorUtils.domainDel(json);
        if (result.getCode() != 200) {
            return Result.error((String)result.getMessage());
        }
        HtSiteChannelDomain exist = (HtSiteChannelDomain)((LambdaQueryChainWrapper)this.domainService.lambdaQuery().eq(HtSiteChannelDomain::getChildDomain, (Object)url.replace("https://", ""))).one();
        if (exist != null) {
            exist.setMonitorFlag(0);
            this.domainService.updateById(exist);
        }
        this.htMonitorRecordService.removeById(id);
        return Result.OK((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestBody Map<String, Object> params) {
        String ids = params.get("ids").toString();
        List<String> idsArray = Arrays.asList(ids.split(","));
        this.htMonitorRecordService.removeByIds(idsArray);
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2")
    @PostMapping(value={"/queryById"})
    public Result<HtMonitorRecord> queryById(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        HtMonitorRecord record = (HtMonitorRecord)this.htMonitorRecordService.getById(id);
        return Result.OK((Object)record);
    }

    @ApiOperation(value="\u540c\u6b65\u76d1\u63a7\u6570\u636e")
    @PostMapping(value={"/async"})
    public Result<String> asyncMonitor() {
        Result<?> result = this.monitorUtils.getDomains();
        if (result.getCode() != 200) {
            return Result.error((String)result.getMessage());
        }
        Object data = result.getResult();
        if (data == null) {
            return Result.error((String)"\u6ca1\u6709\u9700\u8981\u540c\u6b65\u7684\u6570\u636e");
        }
        if (!(data instanceof List)) {
            return Result.error((String)"\u8fd4\u56de\u6570\u636e\u683c\u5f0f\u5f02\u5e38");
        }
        List list = (List)data;
        for (Object item : list) {
            Map obj = (Map)item;
            HtMonitorRecord record = new HtMonitorRecord();
            record.setUrl((String)obj.get("domainName"));
            record.setGid((String)obj.get("groupName"));
            record.setRemark((String)obj.get("remark"));
            record.setTelegramGroupId((String)obj.get("telegramGroupId"));
            record.setHttpStatus((String)obj.get("httpStatus"));
            record.setDelayMs(obj.get("delayMs") != null ? Integer.valueOf(((Number)obj.get("delayMs")).intValue()) : null);
            record.setNodeCount(obj.get("nodeCount") != null ? Integer.valueOf(((Number)obj.get("nodeCount")).intValue()) : null);
            record.setNodeAvailableCount(obj.get("nodeAvailableCount") != null ? Integer.valueOf(((Number)obj.get("nodeAvailableCount")).intValue()) : null);
            record.setNodeAvailability(String.valueOf(obj.get("nodeAvailability")));
            record.setWarningAvailability(String.valueOf(obj.get("warningAvailability")));
            record.setWarningFrequency(String.valueOf(obj.get("warningFrequency")));
            record.setHttpStatusDefault((String)obj.get("httpStatusDefault"));
            record.setStatus(obj.get("status") != null ? Integer.valueOf(((Number)obj.get("status")).intValue()) : null);
            if (obj.get("createDate") != null) {
                record.setCreateDate((Date)new DateTime((CharSequence)obj.get("createDate").toString()));
            }
            if (obj.get("updateDate") != null) {
                record.setUpdateDate((Date)new DateTime((CharSequence)obj.get("updateDate").toString()));
            }
            UpdateWrapper wrapper = new UpdateWrapper();
            wrapper.eq((Object)"url", (Object)record.getUrl());
            this.htMonitorRecordService.update(record, (Wrapper)wrapper);
        }
        return Result.OK((String)"\u540c\u6b65\u6210\u529f\uff01");
    }
}

