/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jeecg.common.api.vo.Result;
import org.jeecg.modules.htvideo.controller.monitor.MonitorUtils;
import org.jeecg.modules.htvideo.entity.HtMonitorGroup;
import org.jeecg.modules.htvideo.service.IHtMonitorGroupService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u76d1\u63a7\u5206\u7ec4\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/ht/monitor/group"})
public class HtMonitorGroupController {
    @Autowired
    private MonitorUtils monitorUtils;
    @Autowired
    private IHtMonitorGroupService htMonitorGroupService;

    @ApiOperation(value="\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<IPage<HtMonitorGroup>> list(@RequestBody Map<String, Object> params) {
        Page page = new Page((long)Integer.parseInt(params.getOrDefault("pageNo", 1).toString()), (long)Integer.parseInt(params.getOrDefault("pageSize", 10).toString()));
        QueryWrapper queryWrapper = new QueryWrapper();
        if (params.get("group") != null) {
            queryWrapper.eq((Object)"group", params.get("group"));
        }
        IPage pageList = this.htMonitorGroupService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @ApiOperation(value="\u83b7\u53d6\u5168\u90e8\u8df3\u8f6c\u57df\u540d")
    @PostMapping(value={"/listAll"})
    public Result<?> getAll() {
        List list = this.htMonitorGroupService.list();
        JSONObject json = new JSONObject();
        json.put("groups", (Object)list);
        return Result.OK((Object)json);
    }

    @ApiOperation(value="\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<String> add(@RequestBody HtMonitorGroup record) {
        JSONObject json = new JSONObject();
        json.put("groupName", (Object)record.getGroupName());
        Result<?> result = this.monitorUtils.groupCreate(json);
        if (result.getCode() != 200) {
            return Result.error((String)result.getMessage());
        }
        this.htMonitorGroupService.save(record);
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<String> edit(@RequestBody HtMonitorGroup record) {
        this.htMonitorGroupService.updateById(record);
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<String> delete(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        this.htMonitorGroupService.removeById(id);
        return Result.OK((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u6279\u91cf\u5220\u9664")
    @PostMapping(value={"/deleteBatch"})
    public Result<String> deleteBatch(@RequestBody Map<String, Object> params) {
        String ids = params.get("ids").toString();
        this.htMonitorGroupService.removeByIds(Arrays.asList(ids.split(",")));
        return Result.OK((String)"\u6279\u91cf\u5220\u9664\u6210\u529f\uff01");
    }

    @ApiOperation(value="\u901a\u8fc7id\u67e5\u8be2")
    @PostMapping(value={"/queryById"})
    public Result<HtMonitorGroup> queryById(@RequestBody Map<String, Object> params) {
        Integer id = (Integer)params.get("id");
        HtMonitorGroup record = (HtMonitorGroup)this.htMonitorGroupService.getById(id);
        return Result.OK((Object)record);
    }
}

