/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.jeecg.common.api.vo.Result;
import org.jeecg.common.aspect.annotation.AutoLog;
import org.jeecg.common.util.RestUtil;
import org.jeecg.modules.htvideo.controller.ApiConfig;
import org.jeecg.modules.htvideo.controller.BaseController;
import org.jeecg.modules.htvideo.controller.monitor.MonitorUtils;
import org.jeecg.modules.htvideo.entity.HtMonitorRecord;
import org.jeecg.modules.htvideo.entity.HtSiteChannel;
import org.jeecg.modules.htvideo.entity.HtSiteChannelDomain;
import org.jeecg.modules.htvideo.service.IHtMonitorRecordService;
import org.jeecg.modules.htvideo.service.IHtSiteChannelDomainService;
import org.jeecg.modules.htvideo.service.IHtSiteChannelService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"\u7f51\u7ad9\u6e20\u9053\u7ba1\u7406"})
@RestController
@RequestMapping(value={"/ht/channel"})
public class HtChannelDomainController
extends BaseController {
    private static final Logger log = LoggerFactory.getLogger(HtChannelDomainController.class);
    @Value(value="${jeecg.path.webapp}")
    protected String jsPath;
    @Autowired
    private MonitorUtils monitorUtils;
    @Autowired
    private IHtSiteChannelService channelService;
    @Autowired
    private IHtSiteChannelDomainService domainService;
    @Autowired
    private IHtMonitorRecordService htMonitorRecordService;

    @AutoLog(value="\u7f51\u7ad9\u6e20\u9053-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u7f51\u7ad9\u6e20\u9053-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u7f51\u7ad9\u6e20\u9053-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/list"})
    public Result<?> queryPageList(@RequestBody Map<String, Object> params) {
        Page page = new Page((long)Integer.parseInt(params.getOrDefault("pageNo", 1).toString()), (long)Integer.parseInt(params.getOrDefault("pageSize", 10).toString()));
        QueryWrapper queryWrapper = new QueryWrapper();
        if (params.get("siteName") != null) {
            queryWrapper.like((Object)"site_name", params.get("siteName"));
        }
        if (params.get("domain") != null) {
            queryWrapper.like((Object)"domain", params.get("domain"));
        }
        if (params.get("remark") != null) {
            queryWrapper.like((Object)"remark", params.get("remark"));
        }
        if (params.get("status") != null) {
            queryWrapper.eq((Object)"status", params.get("status"));
        }
        queryWrapper.orderByDesc((Object)"create_time");
        IPage pageList = this.channelService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u7f51\u7ad9\u6e20\u9053-\u67e5\u8be2\u5168\u90e8")
    @ApiOperation(value="\u7f51\u7ad9\u6e20\u9053-\u67e5\u8be2\u5168\u90e8", notes="\u7f51\u7ad9\u6e20\u9053-\u67e5\u8be2\u5168\u90e8\u5217\u8868")
    @PostMapping(value={"/listAll"})
    public Result<?> listAll() {
        List list = this.channelService.list();
        return Result.OK((Object)list);
    }

    @AutoLog(value="\u7f51\u7ad9\u6e20\u9053-\u6dfb\u52a0")
    @ApiOperation(value="\u7f51\u7ad9\u6e20\u9053-\u6dfb\u52a0", notes="\u7f51\u7ad9\u6e20\u9053-\u6dfb\u52a0")
    @PostMapping(value={"/add"})
    public Result<?> add(@RequestBody Map<String, Object> params) {
        HtSiteChannel channel = new HtSiteChannel();
        channel.setSiteName(params.get("siteName").toString());
        channel.setDomain(params.get("domain").toString());
        channel.setStatus(Integer.parseInt(params.getOrDefault("status", 1).toString()));
        channel.setStatisticsScript(params.get("statisticsScript") != null ? params.get("statisticsScript").toString() : null);
        channel.setStatisticsCode(params.get("statisticsCode") != null ? params.get("statisticsCode").toString() : null);
        channel.setStatisticsCode2(params.get("statisticsCode2") != null ? params.get("statisticsCode2").toString() : null);
        channel.setShareDomain(params.get("shareDomain") != null ? params.get("shareDomain").toString() : null);
        channel.setRemark(params.get("remark") != null ? params.get("remark").toString() : null);
        channel.setCreateTime(new Date());
        this.channelService.save(channel);
        RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u7f51\u7ad9\u6e20\u9053-\u7f16\u8f91")
    @ApiOperation(value="\u7f51\u7ad9\u6e20\u9053-\u7f16\u8f91", notes="\u7f51\u7ad9\u6e20\u9053-\u7f16\u8f91")
    @PostMapping(value={"/edit"})
    public Result<?> edit(@RequestBody Map<String, Object> params) {
        HtSiteChannel channel = (HtSiteChannel)this.channelService.getById((Serializable)((Object)params.get("cid").toString()));
        if (channel == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        channel.setSiteName(params.get("siteName").toString());
        channel.setDomain(params.get("domain").toString());
        channel.setStatus(Integer.parseInt(params.getOrDefault("status", 1).toString()));
        channel.setStatisticsScript(params.get("statisticsScript") != null ? params.get("statisticsScript").toString() : null);
        channel.setStatisticsCode(params.get("statisticsCode") != null ? params.get("statisticsCode").toString() : null);
        channel.setStatisticsCode2(params.get("statisticsCode2") != null ? params.get("statisticsCode2").toString() : null);
        channel.setShareDomain(params.get("shareDomain") != null ? params.get("shareDomain").toString() : null);
        channel.setRemark(params.get("remark") != null ? params.get("remark").toString() : null);
        this.channelService.updateById(channel);
        RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u7f51\u7ad9\u6e20\u9053-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u7f51\u7ad9\u6e20\u9053-\u901a\u8fc7id\u5220\u9664", notes="\u7f51\u7ad9\u6e20\u9053-\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<?> delete(@RequestBody Map<String, Object> params) {
        this.channelService.removeById((Serializable)((Object)params.get("cid").toString()));
        RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    @AutoLog(value="\u6e20\u9053\u57df\u540d-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @ApiOperation(value="\u6e20\u9053\u57df\u540d-\u5206\u9875\u5217\u8868\u67e5\u8be2", notes="\u6e20\u9053\u57df\u540d-\u5206\u9875\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/domain/list"})
    public Result<?> queryDomainPageList(@RequestBody Map<String, Object> params) {
        Page page = new Page((long)Integer.parseInt(params.getOrDefault("pageNo", 1).toString()), (long)Integer.parseInt(params.getOrDefault("pageSize", 10).toString()));
        QueryWrapper queryWrapper = new QueryWrapper();
        if (params.get("cid") != null) {
            queryWrapper.eq((Object)"cid", params.get("cid"));
        }
        if (params.get("childDomain") != null) {
            queryWrapper.like((Object)"child_domain", params.get("childDomain"));
        }
        if (params.get("status") != null) {
            queryWrapper.eq((Object)"status", params.get("status"));
        }
        queryWrapper.orderByDesc((Object)"create_time");
        IPage pageList = this.domainService.page((IPage)page, (Wrapper)queryWrapper);
        return Result.OK((Object)pageList);
    }

    @AutoLog(value="\u6e20\u9053\u57df\u540d-\u6dfb\u52a0")
    @ApiOperation(value="\u6e20\u9053\u57df\u540d-\u6dfb\u52a0", notes="\u6e20\u9053\u57df\u540d-\u6dfb\u52a0")
    @PostMapping(value={"/domain/add"})
    public Result<?> addDomain(@RequestBody Map<String, Object> params) {
        HtSiteChannelDomain domain = new HtSiteChannelDomain();
        domain.setCid(Integer.parseInt(params.get("cid").toString()));
        domain.setChildDomain(params.get("childDomain").toString());
        domain.setRemark(params.get("remark") != null ? params.get("remark").toString() : null);
        domain.setStatus(Integer.parseInt(params.getOrDefault("status", 1).toString()));
        domain.setCreateTime(new Date());
        this.domainService.save(domain);
        RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
        return Result.OK((String)"\u6dfb\u52a0\u6210\u529f\uff01");
    }

    @AutoLog(value="\u6e20\u9053\u57df\u540d-\u6279\u91cf\u6dfb\u52a0")
    @ApiOperation(value="\u6e20\u9053\u57df\u540d-\u6279\u91cf\u6dfb\u52a0", notes="\u6e20\u9053\u57df\u540d-\u6279\u91cf\u6dfb\u52a0")
    @PostMapping(value={"/domain/batchAdd"})
    @Transactional
    public Result<?> batchAddDomain(@RequestBody Map<String, Object> params) {
        Integer cid = Integer.parseInt(params.get("cid").toString());
        String domainsString = params.get("childDomains").toString();
        Integer status = Integer.parseInt(params.getOrDefault("status", 1).toString());
        String[] domainArray = domainsString.split("\r?\n");
        ArrayList<HtSiteChannelDomain> domainsToSave = new ArrayList<HtSiteChannelDomain>();
        ArrayList<String> existingDomainsFeedback = new ArrayList<String>();
        ArrayList<CallSite> invalidFormatDomainsFeedback = new ArrayList<CallSite>();
        ArrayList<String> candidateDomains = new ArrayList<String>();
        int processedCount = 0;
        for (String childDomain : domainArray) {
            ++processedCount;
            if (childDomain != null && !childDomain.trim().isEmpty()) {
                candidateDomains.add(childDomain.trim());
                continue;
            }
            invalidFormatDomainsFeedback.add((CallSite)((Object)("\u7b2c " + processedCount + " \u884c\u4e3a\u7a7a\u6216\u65e0\u6548\u683c\u5f0f")));
        }
        List distinctCandidateDomains = candidateDomains.stream().distinct().collect(Collectors.toList());
        if (distinctCandidateDomains.isEmpty()) {
            return Result.OK((String)"\u6ca1\u6709\u63d0\u4f9b\u6709\u6548\u7684\u57df\u540d\u8fdb\u884c\u5904\u7406\u3002");
        }
        QueryWrapper checkExistingWrapper = new QueryWrapper();
        checkExistingWrapper.eq((Object)"cid", (Object)cid);
        checkExistingWrapper.in((Object)"child_domain", distinctCandidateDomains);
        checkExistingWrapper.select((Object[])new String[]{"child_domain"});
        List existingDbDomains = this.domainService.list((Wrapper)checkExistingWrapper);
        Set existingDbDomainNames = existingDbDomains.stream().map(HtSiteChannelDomain::getChildDomain).collect(Collectors.toSet());
        for (String trimmedDomain : distinctCandidateDomains) {
            if (!existingDbDomainNames.contains(trimmedDomain)) {
                HtSiteChannelDomain domain = new HtSiteChannelDomain();
                domain.setCid(cid);
                domain.setChildDomain(trimmedDomain);
                domain.setRemark(null);
                domain.setStatus(status);
                domain.setCreateTime(new Date());
                domainsToSave.add(domain);
                continue;
            }
            existingDomainsFeedback.add(trimmedDomain);
        }
        int successCount = 0;
        if (!domainsToSave.isEmpty()) {
            try {
                boolean saveResult = this.domainService.saveBatch(domainsToSave);
                if (!saveResult) {
                    log.error("\u6279\u91cf\u4fdd\u5b58\u57df\u540d\u5931\u8d25\uff0c\u4f46\u672a\u629b\u51fa\u5f02\u5e38\u3002domainsToSave: {}", domainsToSave);
                    return Result.error((String)"\u6279\u91cf\u4fdd\u5b58\u90e8\u5206\u57df\u540d\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u65e5\u5fd7\u3002");
                }
                successCount = domainsToSave.size();
            }
            catch (Exception e) {
                log.error("\u6279\u91cf\u4fdd\u5b58\u57df\u540d\u65f6\u53d1\u751f\u5f02\u5e38: cid={}, domains={}", new Object[]{cid, domainsToSave, e});
                throw new RuntimeException("\u6279\u91cf\u4fdd\u5b58\u57df\u540d\u5931\u8d25\uff0c\u64cd\u4f5c\u5df2\u56de\u6eda: " + e.getMessage(), e);
            }
        }
        StringBuilder feedbackMessage = new StringBuilder();
        feedbackMessage.append("\u6279\u91cf\u6dfb\u52a0\u64cd\u4f5c\u5b8c\u6210\uff01");
        feedbackMessage.append("\u6210\u529f\u6dfb\u52a0 ").append(successCount).append(" \u4e2a\u57df\u540d\u3002");
        if (!existingDomainsFeedback.isEmpty()) {
            feedbackMessage.append("\u5df2\u5b58\u5728 ").append(existingDomainsFeedback.size()).append(" \u4e2a\u57df\u540d\u3002");
        }
        if (!invalidFormatDomainsFeedback.isEmpty()) {
            feedbackMessage.append("\u68c0\u6d4b\u5230 ").append(invalidFormatDomainsFeedback.size()).append(" \u4e2a\u65e0\u6548\u683c\u5f0f\u7684\u884c\u3002");
        }
        RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
        return Result.OK((String)feedbackMessage.toString());
    }

    @AutoLog(value="\u6e20\u9053\u57df\u540d-\u7f16\u8f91")
    @ApiOperation(value="\u6e20\u9053\u57df\u540d-\u7f16\u8f91", notes="\u6e20\u9053\u57df\u540d-\u7f16\u8f91")
    @PostMapping(value={"/domain/edit"})
    public Result<?> editDomain(@RequestBody Map<String, Object> params) {
        HtSiteChannelDomain domain = (HtSiteChannelDomain)this.domainService.getById((Serializable)((Object)params.get("id").toString()));
        if (domain == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        domain.setCid(Integer.parseInt(params.get("cid").toString()));
        domain.setChildDomain(params.get("childDomain").toString());
        domain.setRemark(params.get("remark") != null ? params.get("remark").toString() : null);
        domain.setStatus(Integer.parseInt(params.getOrDefault("status", 1).toString()));
        this.domainService.updateById(domain);
        RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
        return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
    }

    @AutoLog(value="\u6e20\u9053\u57df\u540d-\u76d1\u63a7")
    @ApiOperation(value="\u6e20\u9053\u57df\u540d-\u76d1\u63a7", notes="\u6e20\u9053\u57df\u540d-\u76d1\u63a7")
    @PostMapping(value={"/domain/editmonitor"})
    public Result<?> editDomainMonitor(@RequestBody Map<String, Object> params) {
        HtSiteChannelDomain domain = (HtSiteChannelDomain)this.domainService.getById((Serializable)((Object)params.get("id").toString()));
        if (domain == null) {
            return Result.error((String)"\u672a\u627e\u5230\u5bf9\u5e94\u6570\u636e");
        }
        int monitorFlag = Integer.parseInt(params.getOrDefault("monitorFlag", 0).toString());
        String url = "https://" + domain.getChildDomain();
        JSONObject json = new JSONObject();
        String msg = "";
        HtMonitorRecord exist = (HtMonitorRecord)((LambdaQueryChainWrapper)this.htMonitorRecordService.lambdaQuery().eq(HtMonitorRecord::getUrl, (Object)url)).one();
        if (monitorFlag == 1) {
            json.put("groupName", (Object)"site");
            json.put("domainName", (Object)url);
            json.put("remark", (Object)domain.getRemark());
            json.put("telegramGroupId", (Object)"");
            Result<?> result = this.monitorUtils.domainSave(json);
            if (result.getCode() != 200 && result.getCode() != 409) {
                msg = result.getMessage();
            } else if (exist == null) {
                exist = new HtMonitorRecord();
                exist.setGid("site");
                exist.setUrl(url);
                exist.setRemark(domain.getRemark());
                this.htMonitorRecordService.save(exist);
            }
        } else {
            json.put("groupName", (Object)"site");
            json.put("domainName", (Object)domain.getChildDomain());
            Result<?> result = this.monitorUtils.domainDel(json);
            if (result.getCode() != 200 && result.getCode() != 404) {
                msg = result.getMessage();
            } else if (exist != null) {
                this.htMonitorRecordService.removeById(exist.getId());
            }
        }
        if (msg.isEmpty()) {
            domain.setMonitorFlag(monitorFlag);
            this.domainService.updateById(domain);
            return Result.OK((String)"\u7f16\u8f91\u6210\u529f!");
        }
        return Result.error((String)msg);
    }

    @AutoLog(value="\u6e20\u9053\u57df\u540d-\u6279\u91cf\u76d1\u63a7")
    @ApiOperation(value="\u6e20\u9053\u57df\u540d-\u6279\u91cf\u76d1\u63a7", notes="\u6e20\u9053\u57df\u540d-\u6279\u91cf\u76d1\u63a7")
    @PostMapping(value={"/domain/batchMonitor"})
    @Transactional
    public Result<?> batchMonitor(@RequestBody Map<String, Object> params) {
        String[] idArray;
        String idsString = params.get("ids").toString();
        Integer monitorFlag = Integer.parseInt(params.getOrDefault("monitorFlag", 0).toString());
        for (String id : idArray = idsString.split(",")) {
            HtSiteChannelDomain domain = (HtSiteChannelDomain)this.domainService.getById((Serializable)((Object)id));
            if (domain != null) {
                domain.setMonitorFlag(monitorFlag);
            }
            JSONObject json = new JSONObject();
            json.put("groupName", (Object)"site");
            json.put("domainName", (Object)domain.getChildDomain());
            json.put("remark", (Object)domain.getRemark());
            json.put("telegramGroupId", (Object)"");
            this.monitorUtils.domainSave(json);
            this.domainService.updateById(domain);
        }
        return Result.OK((String)"\u6279\u91cf\u76d1\u63a7\u64cd\u4f5c\u5b8c\u6210");
    }

    @AutoLog(value="\u6e20\u9053\u57df\u540d-\u901a\u8fc7id\u5220\u9664")
    @ApiOperation(value="\u6e20\u9053\u57df\u540d-\u901a\u8fc7id\u5220\u9664", notes="\u6e20\u9053\u57df\u540d-\u901a\u8fc7id\u5220\u9664")
    @PostMapping(value={"/domain/delete"})
    public Result<?> deleteDomain(@RequestBody Map<String, Object> params) {
        this.domainService.removeById((Serializable)((Object)params.get("id").toString()));
        RestUtil.post((String)(this.apiPath + ApiConfig.refreshConfig), null, (JSONObject)this.baseBodyParams(null));
        return Result.OK((String)"\u5220\u9664\u6210\u529f!");
    }

    private String normalizeDomainNameForPath(String domainName) {
        long dotCount;
        if (domainName == null || domainName.isEmpty()) {
            return domainName;
        }
        Object hostPart = domainName;
        String portPart = "";
        int colonIndex = domainName.lastIndexOf(58);
        if (colonIndex != -1) {
            hostPart = domainName.substring(0, colonIndex);
            portPart = domainName.substring(colonIndex);
        }
        if ((dotCount = ((String)hostPart).chars().filter(ch -> ch == 46).count()) == 1L && !((String)hostPart).toLowerCase().startsWith("www.")) {
            hostPart = "www." + (String)hostPart;
        }
        String normalizedDomain = (String)hostPart + portPart;
        return normalizedDomain.replace(":", "-");
    }

    @ApiOperation(value="\u751f\u6210\u6240\u6709\u6e20\u9053\u7684js\u6587\u4ef6", notes="\u4e3a\u6240\u6709\u6e20\u9053\u751f\u6210hm.js\u548cconf.js\u6587\u4ef6")
    @PostMapping(value={"/generateAllJsFiles"})
    public Result<?> generateAllJsFiles() {
        List channels = this.channelService.list();
        if (channels == null || channels.isEmpty()) {
            return Result.error((String)"\u6ca1\u6709\u627e\u5230\u4efb\u4f55\u6e20\u9053\u4fe1\u606f");
        }
        StringBuilder resultMsg = new StringBuilder();
        int failCount = 0;
        for (HtSiteChannel channel : channels) {
            try {
                String originalDomainName = channel.getDomain();
                String processedDomainName = this.normalizeDomainNameForPath(originalDomainName);
                String statisticsScript = channel.getStatisticsScript();
                String statisticsCode = channel.getStatisticsCode();
                String statisticsCode2 = channel.getStatisticsCode2();
                Integer cid = channel.getCid();
                String shareDomain = channel.getShareDomain();
                String siteName = channel.getSiteName();
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"cid", (Object)cid);
                queryWrapper.eq((Object)"status", (Object)1);
                List domainList = this.domainService.list((Wrapper)queryWrapper);
                if (processedDomainName != null && !processedDomainName.isEmpty()) {
                    String baseDir = this.jsPath + "/" + processedDomainName;
                    File dir = new File(baseDir);
                    if (!dir.exists()) {
                        dir.mkdirs();
                    }
                    File hmJs = new File(dir, "sc.js");
                    try (FileWriter writer = new FileWriter(hmJs, false);){
                        writer.write("var __xyz_cid_=\"" + cid + "\";");
                        writer.write("var __xyz_sn_=\"" + siteName + "\";");
                        writer.write("var __xyz_share_domain_=\"" + (shareDomain != null ? shareDomain : "") + "\";");
                        writer.write(statisticsCode != null ? statisticsCode : "");
                    }
                    catch (IOException e) {
                        log.error("\u751f\u6210\u6e20\u9053[{}]\u7684hm.js\u5931\u8d25", (Object)channel.getSiteName(), (Object)e);
                        throw e;
                    }
                    File hm2Js = new File(dir, "ss.js");
                    try (FileWriter writer = new FileWriter(hm2Js, false);){
                        writer.write(statisticsCode2 != null ? statisticsCode2 : "");
                    }
                    catch (IOException e) {
                        log.error("\u751f\u6210\u6e20\u9053[{}]\u7684hm2.js\u5931\u8d25", (Object)channel.getSiteName(), (Object)e);
                        throw e;
                    }
                }
                if (domainList == null || domainList.isEmpty()) continue;
                for (HtSiteChannelDomain domain : domainList) {
                    String originalSubDomain = domain.getChildDomain();
                    String processedSubDomain = this.normalizeDomainNameForPath(originalSubDomain);
                    if (processedSubDomain == null || processedSubDomain.isEmpty()) continue;
                    try {
                        String subDomainDir = this.jsPath + "/" + processedSubDomain;
                        File subDir = new File(subDomainDir);
                        if (!subDir.exists()) {
                            subDir.mkdirs();
                        }
                        File subHmJs = new File(subDir, "sc.js");
                        try (FileWriter writer = new FileWriter(subHmJs, false);){
                            writer.write("var __xyz_cid_=\"" + cid + "\";");
                            writer.write("var __xyz_sn_=\"" + siteName + "\";");
                            writer.write("var __xyz_share_domain_=\"" + (shareDomain != null ? shareDomain : "") + "\";");
                            writer.write(statisticsCode != null ? statisticsCode : "");
                        }
                        File subHmJs2 = new File(subDir, "ss.js");
                        try (FileWriter writer = new FileWriter(subHmJs2, false);){
                            writer.write(statisticsCode2 != null ? statisticsCode2 : "");
                        }
                    }
                    catch (IOException e) {
                        log.error("\u751f\u6210\u5b50\u57df\u540d[{}]\u7684\u6587\u4ef6\u5931\u8d25", (Object)domain.getChildDomain(), (Object)e);
                        throw e;
                    }
                }
            }
            catch (Exception e) {
                ++failCount;
                resultMsg.append("\u6e20\u9053[").append(channel.getSiteName()).append("]\u751f\u6210\u5931\u8d25; ");
            }
        }
        if (failCount > 0) {
            log.error(resultMsg.toString());
            return Result.error((String)("\u751f\u6210\u5931\u8d25, \u5931\u8d25\u539f\u56e0: " + resultMsg.toString()));
        }
        return Result.OK((String)"\u751f\u6210\u6210\u529f");
    }
}

