/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.sign.util;

import com.alibaba.fastjson.JSONObject;
import java.io.UnsupportedEncodingException;
import java.util.SortedMap;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.JeecgBaseConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.DigestUtils;
import org.springframework.util.StringUtils;

public class SignUtil {
    private static final Logger log = LoggerFactory.getLogger(SignUtil.class);
    public static final String X_PATH_VARIABLE = "x-path-variable";

    public static boolean verifySign(SortedMap<String, String> params, String headerSign) {
        if (params == null || StringUtils.isEmpty((Object)headerSign)) {
            return false;
        }
        String paramsSign = SignUtil.getParamsSign(params);
        log.info("Param Sign : {}", (Object)paramsSign);
        return !StringUtils.isEmpty((Object)paramsSign) && headerSign.equals(paramsSign);
    }

    public static String getParamsSign(SortedMap<String, String> params) {
        params.remove("_t");
        String paramsJsonStr = JSONObject.toJSONString(params);
        log.info("Param paramsJsonStr : {}", (Object)paramsJsonStr);
        JeecgBaseConfig jeecgBaseConfig = SpringContextUtils.getBean(JeecgBaseConfig.class);
        String signatureSecret = jeecgBaseConfig.getSignatureSecret();
        String curlyBracket = "${";
        if (oConvertUtils.isEmpty(signatureSecret) || signatureSecret.contains(curlyBracket)) {
            throw new JeecgBootException("\u7b7e\u540d\u5bc6\u94a5 ${jeecg.signatureSecret} \u7f3a\u5c11\u914d\u7f6e \uff01\uff01");
        }
        try {
            return DigestUtils.md5DigestAsHex((byte[])(paramsJsonStr + signatureSecret).getBytes("UTF-8")).toUpperCase();
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }
}

