/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.mybatis.aspect;

import java.lang.reflect.Method;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.aspect.annotation.DynamicTable;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.config.mybatis.ThreadLocalDataHelper;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class DynamicTableAspect {
    @Pointcut(value="@annotation(org.jeecg.common.aspect.annotation.DynamicTable)")
    public void dynamicTable() {
    }

    @Around(value="dynamicTable()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        DynamicTable dynamicTable = method.getAnnotation(DynamicTable.class);
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        String version = request.getHeader("X-Version");
        ThreadLocalDataHelper.put("X-Version", version);
        ThreadLocalDataHelper.put("DYNAMIC_TABLE_NAME", dynamicTable.value());
        Object result = point.proceed();
        ThreadLocalDataHelper.clear();
        return result;
    }
}

