/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.mybatis;

import java.lang.reflect.Field;
import java.util.Date;
import java.util.Properties;
import org.apache.ibatis.binding.MapperMethod;
import org.apache.ibatis.executor.Executor;
import org.apache.ibatis.mapping.MappedStatement;
import org.apache.ibatis.mapping.SqlCommandType;
import org.apache.ibatis.plugin.Interceptor;
import org.apache.ibatis.plugin.Intercepts;
import org.apache.ibatis.plugin.Invocation;
import org.apache.ibatis.plugin.Plugin;
import org.apache.ibatis.plugin.Signature;
import org.apache.shiro.SecurityUtils;
import org.jeecg.common.config.TenantContext;
import org.jeecg.common.system.vo.LoginUser;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.config.mybatis.MybatisPlusSaasConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Intercepts(value={@Signature(type=Executor.class, method="update", args={MappedStatement.class, Object.class})})
public class MybatisInterceptor
implements Interceptor {
    private static final Logger log = LoggerFactory.getLogger(MybatisInterceptor.class);

    public Object intercept(Invocation invocation) throws Throwable {
        Field[] fields;
        LoginUser sysUser;
        MappedStatement mappedStatement = (MappedStatement)invocation.getArgs()[0];
        String sqlId = mappedStatement.getId();
        log.debug("------sqlId------" + sqlId);
        SqlCommandType sqlCommandType = mappedStatement.getSqlCommandType();
        Object parameter = invocation.getArgs()[1];
        log.debug("------sqlCommandType------" + sqlCommandType);
        if (parameter == null) {
            return invocation.proceed();
        }
        if (SqlCommandType.INSERT == sqlCommandType) {
            sysUser = this.getLoginUser();
            for (Field field : fields = oConvertUtils.getAllFields(parameter)) {
                log.debug("------field.name------" + field.getName());
                try {
                    if ("createBy".equals(field.getName())) {
                        field.setAccessible(true);
                        Object localCreateBy = field.get(parameter);
                        field.setAccessible(false);
                        if ((localCreateBy == null || "".equals(localCreateBy)) && sysUser != null) {
                            field.setAccessible(true);
                            field.set(parameter, sysUser.getUsername());
                            field.setAccessible(false);
                        }
                    }
                    if ("createTime".equals(field.getName())) {
                        field.setAccessible(true);
                        Object localCreateDate = field.get(parameter);
                        field.setAccessible(false);
                        if (localCreateDate == null || "".equals(localCreateDate)) {
                            field.setAccessible(true);
                            field.set(parameter, new Date());
                            field.setAccessible(false);
                        }
                    }
                    if ("sysOrgCode".equals(field.getName())) {
                        field.setAccessible(true);
                        Object localSysOrgCode = field.get(parameter);
                        field.setAccessible(false);
                        if ((localSysOrgCode == null || "".equals(localSysOrgCode)) && sysUser != null) {
                            field.setAccessible(true);
                            field.set(parameter, sysUser.getOrgCode());
                            field.setAccessible(false);
                        }
                    }
                    if (!MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue() || !"tenantId".equals(field.getName())) continue;
                    field.setAccessible(true);
                    Object localTenantId = field.get(parameter);
                    field.setAccessible(false);
                    if (localTenantId != null) continue;
                    field.setAccessible(true);
                    String tenantId = TenantContext.getTenant();
                    if (oConvertUtils.isEmpty(tenantId) && MybatisPlusSaasConfig.OPEN_SYSTEM_TENANT_CONTROL.booleanValue()) {
                        try {
                            tenantId = TokenUtils.getTenantIdByRequest(SpringContextUtils.getHttpServletRequest());
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    if (field.getType().equals(String.class)) {
                        field.set(parameter, tenantId);
                    } else {
                        field.set(parameter, oConvertUtils.getInt(tenantId, 0));
                    }
                    field.setAccessible(false);
                }
                catch (Exception localTenantId) {
                    // empty catch block
                }
            }
        }
        if (SqlCommandType.UPDATE == sqlCommandType) {
            sysUser = this.getLoginUser();
            fields = null;
            if (parameter instanceof MapperMethod.ParamMap) {
                MapperMethod.ParamMap p = (MapperMethod.ParamMap)parameter;
                String et = "et";
                if ((parameter = p.containsKey((Object)et) ? p.get((Object)et) : p.get((Object)"param1")) == null) {
                    return invocation.proceed();
                }
                fields = oConvertUtils.getAllFields(parameter);
            } else {
                fields = oConvertUtils.getAllFields(parameter);
            }
            for (Field field : fields) {
                log.debug("------field.name------" + field.getName());
                try {
                    if ("updateBy".equals(field.getName()) && sysUser != null) {
                        field.setAccessible(true);
                        field.set(parameter, sysUser.getUsername());
                        field.setAccessible(false);
                    }
                    if (!"updateTime".equals(field.getName())) continue;
                    field.setAccessible(true);
                    field.set(parameter, new Date());
                    field.setAccessible(false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return invocation.proceed();
    }

    public Object plugin(Object target) {
        return Plugin.wrap((Object)target, (Interceptor)this);
    }

    public void setProperties(Properties properties) {
    }

    private LoginUser getLoginUser() {
        LoginUser sysUser = null;
        try {
            sysUser = SecurityUtils.getSubject().getPrincipal() != null ? (LoginUser)SecurityUtils.getSubject().getPrincipal() : null;
        }
        catch (Exception e) {
            sysUser = null;
        }
        return sysUser;
    }
}

