/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.firewall.SqlInjection;

import java.util.HashSet;
import java.util.Set;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SysDictTableWhite {
    private static final Logger log = LoggerFactory.getLogger(SysDictTableWhite.class);
    private String name;
    private String alias;
    private Set<String> fields;
    private boolean all;

    public SysDictTableWhite() {
    }

    public SysDictTableWhite(String name, String alias) {
        this.name = name;
        this.alias = alias;
        this.all = false;
        this.fields = new HashSet<String>();
    }

    public void addField(String field) {
        this.fields.add(field);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getFields() {
        return new HashSet<String>(this.fields);
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setFields(Set<String> fields) {
        this.fields = fields;
    }

    public String getAlias() {
        return this.alias;
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public boolean isAll() {
        return this.all;
    }

    public void setAll(boolean all) {
        this.all = all;
    }

    public boolean isAllFieldsValid(String fieldControlString) {
        String[] controlFields = fieldControlString.split(",");
        if (oConvertUtils.isEmpty(fieldControlString)) {
            return false;
        }
        for (String queryField : this.fields) {
            if (!oConvertUtils.isIn(queryField, controlFields)) continue;
            log.warn("\u5b57\u5178\u8868\u767d\u540d\u5355\u6821\u9a8c\uff0c\u8868\u3010" + this.name + "\u3011\u4e2d\u5b57\u6bb5\u3010" + queryField + "\u3011\u65e0\u6743\u9650\u67e5\u8be2");
            return false;
        }
        return true;
    }

    public String toString() {
        return "QueryTable{name='" + this.name + '\'' + ", alias='" + this.alias + '\'' + ", fields=" + this.fields + ", all=" + this.all + '}';
    }
}

