/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.config.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.util.RedisUtil;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.TokenUtils;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WebsocketFilter
implements Filter {
    private static final Logger log = LoggerFactory.getLogger(WebsocketFilter.class);
    private static final String TOKEN_KEY = "Sec-WebSocket-Protocol";
    private static CommonAPI commonApi;
    private static RedisUtil redisUtil;

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        if (commonApi == null) {
            commonApi = SpringContextUtils.getBean(CommonAPI.class);
        }
        if (redisUtil == null) {
            redisUtil = SpringContextUtils.getBean(RedisUtil.class);
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        String token = request.getHeader(TOKEN_KEY);
        log.debug("Websocket\u8fde\u63a5 Token\u5b89\u5168\u6821\u9a8c\uff0cPath = {}\uff0ctoken:{}", (Object)request.getRequestURI(), (Object)token);
        try {
            TokenUtils.verifyToken(token, commonApi, redisUtil);
        }
        catch (Exception exception) {
            log.debug("Websocket\u8fde\u63a5 Token\u5b89\u5168\u6821\u9a8c\u5931\u8d25\uff0cIP:{}, Token:{}, Path = {}\uff0c\u5f02\u5e38\uff1a{}", new Object[]{oConvertUtils.getIpAddrByRequest(request), token, request.getRequestURI(), exception.getMessage()});
            return;
        }
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        response.setHeader(TOKEN_KEY, token);
        filterChain.doFilter(servletRequest, servletResponse);
    }
}

