/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.sqlparse;

import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.expression.Alias;
import net.sf.jsqlparser.expression.DateValue;
import net.sf.jsqlparser.expression.DoubleValue;
import net.sf.jsqlparser.expression.Expression;
import net.sf.jsqlparser.expression.Function;
import net.sf.jsqlparser.expression.HexValue;
import net.sf.jsqlparser.expression.LongValue;
import net.sf.jsqlparser.expression.NullValue;
import net.sf.jsqlparser.expression.StringValue;
import net.sf.jsqlparser.expression.TimeValue;
import net.sf.jsqlparser.expression.TimestampValue;
import net.sf.jsqlparser.parser.CCJSqlParserManager;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.schema.Table;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.select.AllColumns;
import net.sf.jsqlparser.statement.select.AllTableColumns;
import net.sf.jsqlparser.statement.select.FromItem;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import net.sf.jsqlparser.statement.select.SelectExpressionItem;
import net.sf.jsqlparser.statement.select.SelectItem;
import net.sf.jsqlparser.statement.select.SetOperationList;
import net.sf.jsqlparser.statement.select.SubSelect;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.util.oConvertUtils;
import org.jeecg.common.util.sqlparse.JSqlParserAllTableManager;
import org.jeecg.common.util.sqlparse.vo.SelectSqlInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JSqlParserUtils {
    private static final Logger log = LoggerFactory.getLogger(JSqlParserUtils.class);

    public static Map<String, SelectSqlInfo> parseAllSelectTable(String selectSql) throws JSQLParserException {
        if (oConvertUtils.isEmpty(selectSql)) {
            return null;
        }
        JSqlParserAllTableManager allTableManager = new JSqlParserAllTableManager(selectSql);
        return allTableManager.parse();
    }

    public static SelectSqlInfo parseSelectSqlInfo(String selectSql) throws JSQLParserException {
        if (oConvertUtils.isEmpty(selectSql)) {
            return null;
        }
        CCJSqlParserManager mgr = new CCJSqlParserManager();
        Statement stmt = mgr.parse((Reader)new StringReader(selectSql));
        if (stmt instanceof Select) {
            Select selectStatement = (Select)stmt;
            return JSqlParserUtils.parseBySelectBody(selectStatement.getSelectBody());
        }
        throw new JeecgBootException("\u975e select \u67e5\u8be2sql\uff0c\u4e0d\u505a\u5904\u7406");
    }

    private static SelectSqlInfo parseBySelectBody(SelectBody selectBody) {
        if (selectBody instanceof SetOperationList) {
            List selectBodyList = ((SetOperationList)selectBody).getSelects();
            return JSqlParserUtils.parseBySelectBody((SelectBody)selectBodyList.get(0));
        }
        if (selectBody instanceof PlainSelect) {
            SelectSqlInfo sqlInfo = new SelectSqlInfo(selectBody);
            PlainSelect plainSelect = (PlainSelect)selectBody;
            FromItem fromItem = plainSelect.getFromItem();
            if (fromItem.getAlias() != null) {
                sqlInfo.setFromTableAliasName(fromItem.getAlias().getName());
            }
            if (fromItem instanceof Table) {
                Table fromTable = (Table)fromItem;
                sqlInfo.setFromTableName(fromTable.getName());
            } else if (fromItem instanceof SubSelect) {
                SubSelect fromSubSelect = (SubSelect)fromItem;
                SelectSqlInfo subSqlInfo = JSqlParserUtils.parseBySelectBody(fromSubSelect.getSelectBody());
                sqlInfo.setFromSubSelect(subSqlInfo);
            }
            List selectItems = plainSelect.getSelectItems();
            for (SelectItem selectItem : selectItems) {
                if (selectItem instanceof AllColumns || selectItem instanceof AllTableColumns) {
                    sqlInfo.setSelectAll(true);
                    sqlInfo.setSelectFields(null);
                    sqlInfo.setRealSelectFields(null);
                    break;
                }
                if (!(selectItem instanceof SelectExpressionItem)) continue;
                SelectExpressionItem selectExpressionItem = (SelectExpressionItem)selectItem;
                Expression expression = selectExpressionItem.getExpression();
                Alias alias = selectExpressionItem.getAlias();
                JSqlParserUtils.handleExpression(sqlInfo, expression, alias);
            }
            return sqlInfo;
        }
        log.warn("\u6682\u65f6\u5c1a\u672a\u5904\u7406\u8be5\u7c7b\u578b\u7684 SelectBody: {}", (Object)selectBody.getClass().getName());
        throw new JeecgBootException("\u6682\u65f6\u5c1a\u672a\u5904\u7406\u8be5\u7c7b\u578b\u7684 SelectBody");
    }

    private static void handleExpression(SelectSqlInfo sqlInfo, Expression expression, Alias alias) {
        String selectField;
        if (expression instanceof Function) {
            JSqlParserUtils.handleFunctionExpression((Function)expression, sqlInfo);
            return;
        }
        if (expression instanceof SubSelect) {
            SubSelect subSelect = (SubSelect)expression;
            SelectSqlInfo subSqlInfo = JSqlParserUtils.parseBySelectBody(subSelect.getSelectBody());
            sqlInfo.getSelectFields().addAll(subSqlInfo.getSelectFields());
            sqlInfo.getRealSelectFields().addAll(subSqlInfo.getAllRealSelectFields());
            return;
        }
        if (expression instanceof StringValue || expression instanceof NullValue || expression instanceof LongValue || expression instanceof DoubleValue || expression instanceof HexValue || expression instanceof DateValue || expression instanceof TimestampValue || expression instanceof TimeValue) {
            return;
        }
        String realSelectField = selectField = expression.toString();
        if (alias != null) {
            selectField = alias.getName();
        }
        if (expression instanceof Column) {
            Column column = (Column)expression;
            realSelectField = column.getColumnName();
        }
        sqlInfo.addSelectField(selectField, realSelectField);
    }

    private static void handleFunctionExpression(Function functionExp, SelectSqlInfo sqlInfo) {
        List expressions = functionExp.getParameters().getExpressions();
        for (Expression expression : expressions) {
            JSqlParserUtils.handleExpression(sqlInfo, expression, null);
        }
    }
}

