/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.sqlInjection.parse;

import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import java.lang.reflect.InvocationTargetException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jsqlparser.JSQLParserException;
import net.sf.jsqlparser.parser.CCJSqlParser;
import net.sf.jsqlparser.parser.CCJSqlParserUtil;
import net.sf.jsqlparser.parser.CCJSqlParserVisitor;
import net.sf.jsqlparser.parser.Provider;
import net.sf.jsqlparser.parser.SimpleNode;
import net.sf.jsqlparser.parser.StringProvider;
import net.sf.jsqlparser.schema.Column;
import net.sf.jsqlparser.statement.Statement;
import net.sf.jsqlparser.statement.StatementVisitor;
import net.sf.jsqlparser.statement.select.PlainSelect;
import net.sf.jsqlparser.statement.select.Select;
import net.sf.jsqlparser.statement.select.SelectBody;
import org.jeecg.common.exception.JeecgBootException;
import org.jeecg.common.exception.JeecgSqlInjectionException;
import org.jeecg.common.util.sqlInjection.parse.SqlSyntaxNormalizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ParserSupport {
    private static final Logger log = LoggerFactory.getLogger(ParserSupport.class);

    public static Select parseSelect(String sql) {
        Statement stmt;
        try {
            stmt = CCJSqlParserUtil.parse((String)((String)Preconditions.checkNotNull((Object)sql, (Object)"sql is null")));
        }
        catch (JSQLParserException e) {
            throw new JeecgBootException(e);
        }
        Preconditions.checkArgument((boolean)(stmt instanceof Select), (String)"%s is not  SELECT statment", (Object)sql);
        Select select = (Select)stmt;
        SelectBody selectBody = select.getSelectBody();
        Preconditions.checkArgument((boolean)(selectBody instanceof PlainSelect), (String)"ONLY SUPPORT plain select statement %s", (Object)sql);
        return (Select)stmt;
    }

    public static Select parseSelectUnchecked(String sql) {
        try {
            return ParserSupport.parseSelect(sql);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Statement parse(String sql, CCJSqlParserVisitor visitor, SqlSyntaxNormalizer sqlSyntaxNormalizer) throws JSQLParserException {
        return ParserSupport.parse0((String)sql, (CCJSqlParserVisitor)visitor, (SqlSyntaxNormalizer)sqlSyntaxNormalizer).statement;
    }

    public static SqlParserInfo parse0(String sql, CCJSqlParserVisitor visitor, SqlSyntaxNormalizer sqlSyntaxAnalyzer) throws JeecgSqlInjectionException {
        Statement stmt;
        if (!sql.toLowerCase().trim().startsWith("select ")) {
            log.warn("\u4f20\u5165sql \u975eselect\u5f00\u5934\uff0c\u4e0d\u652f\u6301\u975eselect\u5f00\u5934\u7684\u8bed\u53e5\u89e3\u6790\uff01");
            return null;
        }
        if (sql.toLowerCase().trim().startsWith("call ")) {
            log.warn("\u4f20\u5165call \u5f00\u5934\u5b58\u50a8\u8fc7\u7a0b\uff0c\u4e0d\u652f\u6301\u5b58\u50a8\u8fc7\u7a0b\u89e3\u6790\uff01");
            return null;
        }
        String specialCharacters = "[:$#]";
        Pattern pattern = Pattern.compile(specialCharacters);
        Matcher matcher = pattern.matcher(sql);
        if (matcher.find()) {
            sql = sql.replaceAll("[:$#]", "@");
        }
        Preconditions.checkArgument((null != sql ? 1 : 0) != 0, (Object)"sql is null");
        boolean allowComplexParsing = CCJSqlParserUtil.getNestingDepth((String)sql) <= 10;
        CCJSqlParser parser = (CCJSqlParser)CCJSqlParserUtil.newParser((String)sql).withAllowComplexParsing(allowComplexParsing);
        try {
            stmt = parser.Statement();
        }
        catch (Exception ex) {
            log.error("\u8bf7\u6ce8\u610f\uff0cSQL\u8bed\u6cd5\u53ef\u80fd\u5b58\u5728\u95ee\u9898---> {}", (Object)ex.getMessage());
            throw new JeecgSqlInjectionException("\u8bf7\u6ce8\u610f\uff0cSQL\u8bed\u6cd5\u53ef\u80fd\u5b58\u5728\u95ee\u9898:" + sql);
        }
        if (null != visitor) {
            parser.getASTRoot().jjtAccept(visitor, null);
        }
        if (null != sqlSyntaxAnalyzer) {
            stmt.accept((StatementVisitor)sqlSyntaxAnalyzer.resetChanged());
        }
        return new SqlParserInfo(stmt.toString(), stmt, (SimpleNode)parser.getASTRoot());
    }

    public static <T> T parseComponent(String input, String method, Class<T> targetType) {
        try {
            CCJSqlParser parser = new CCJSqlParser((Provider)new StringProvider(input));
            try {
                return ((Class)Preconditions.checkNotNull(targetType, (Object)"targetType is null")).cast(parser.getClass().getMethod(method, new Class[0]).invoke((Object)parser, new Object[0]));
            }
            catch (InvocationTargetException e) {
                Throwables.throwIfUnchecked((Throwable)e.getTargetException());
                throw new RuntimeException(e.getTargetException());
            }
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException e) {
            Throwables.throwIfUnchecked((Throwable)e);
            throw new RuntimeException(e);
        }
    }

    public static boolean isBoolean(Column column) {
        return null != column && null == column.getTable() && Pattern.compile("(true|false)", 2).matcher(column.getColumnName()).matches();
    }

    public static class SqlParserInfo {
        public String nativeSql;
        public Statement statement;
        public SimpleNode simpleNode;

        SqlParserInfo(String nativeSql, Statement statement, SimpleNode simpleNode) {
            this.nativeSql = nativeSql;
            this.statement = statement;
            this.simpleNode = simpleNode;
        }
    }
}

