/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util.oss;

import com.aliyun.oss.ClientConfiguration;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.common.auth.CredentialsProvider;
import com.aliyun.oss.common.auth.DefaultCredentialProvider;
import com.aliyun.oss.model.CannedAccessControlList;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.PutObjectResult;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import java.util.UUID;
import org.apache.commons.fileupload.FileItemStream;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.filter.SsrfFileTypeFilter;
import org.jeecg.common.util.filter.StrAttackFilter;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.multipart.MultipartFile;

public class OssBootUtil {
    private static final Logger log = LoggerFactory.getLogger(OssBootUtil.class);
    private static String endPoint;
    private static String accessKeyId;
    private static String accessKeySecret;
    private static String bucketName;
    private static String staticDomain;
    private static OSSClient ossClient;

    public static void setEndPoint(String endPoint) {
        OssBootUtil.endPoint = endPoint;
    }

    public static void setAccessKeyId(String accessKeyId) {
        OssBootUtil.accessKeyId = accessKeyId;
    }

    public static void setAccessKeySecret(String accessKeySecret) {
        OssBootUtil.accessKeySecret = accessKeySecret;
    }

    public static void setBucketName(String bucketName) {
        OssBootUtil.bucketName = bucketName;
    }

    public static void setStaticDomain(String staticDomain) {
        OssBootUtil.staticDomain = staticDomain;
    }

    public static String getStaticDomain() {
        return staticDomain;
    }

    public static String getEndPoint() {
        return endPoint;
    }

    public static String getAccessKeyId() {
        return accessKeyId;
    }

    public static String getAccessKeySecret() {
        return accessKeySecret;
    }

    public static String getBucketName() {
        return bucketName;
    }

    public static OSSClient getOssClient() {
        return ossClient;
    }

    public static String upload(MultipartFile file, String fileDir, String customBucket) throws Exception {
        SsrfFileTypeFilter.checkUploadFileType(file);
        String filePath = null;
        OssBootUtil.initOss(endPoint, accessKeyId, accessKeySecret);
        StringBuilder fileUrl = new StringBuilder();
        String newBucket = bucketName;
        if (oConvertUtils.isNotEmpty(customBucket)) {
            newBucket = customBucket;
        }
        try {
            String fileName;
            String orgName;
            if (!ossClient.doesBucketExist(newBucket)) {
                ossClient.createBucket(newBucket);
            }
            if ("" == (orgName = file.getOriginalFilename())) {
                orgName = file.getName();
            }
            String string = fileName = (orgName = CommonUtils.getFileName(orgName)).indexOf(".") == -1 ? orgName + "_" + System.currentTimeMillis() : orgName.substring(0, orgName.lastIndexOf(".")) + "_" + System.currentTimeMillis() + orgName.substring(orgName.lastIndexOf("."));
            if (!fileDir.endsWith("/")) {
                fileDir = fileDir.concat("/");
            }
            fileDir = StrAttackFilter.filter(fileDir);
            fileUrl = fileUrl.append(fileDir + fileName);
            filePath = oConvertUtils.isNotEmpty(staticDomain) && staticDomain.toLowerCase().startsWith("http") ? staticDomain + "/" + fileUrl : "https://" + newBucket + "." + endPoint + "/" + fileUrl;
            PutObjectResult result = ossClient.putObject(newBucket, fileUrl.toString(), file.getInputStream());
            if (result != null) {
                log.info("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + fileUrl);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
        return filePath;
    }

    public static String getOriginalUrl(String url) {
        String originalDomain = "https://" + bucketName + "." + endPoint;
        if (oConvertUtils.isNotEmpty(staticDomain) && url.indexOf(staticDomain) != -1) {
            url = url.replace(staticDomain, originalDomain);
        }
        return url;
    }

    public static String upload(MultipartFile file, String fileDir) throws Exception {
        return OssBootUtil.upload(file, fileDir, null);
    }

    public static String upload(FileItemStream file, String fileDir) {
        String filePath = null;
        OssBootUtil.initOss(endPoint, accessKeyId, accessKeySecret);
        StringBuilder fileUrl = new StringBuilder();
        try {
            String suffix = file.getName().substring(file.getName().lastIndexOf(46));
            String fileName = UUID.randomUUID().toString().replace("-", "") + suffix;
            if (!fileDir.endsWith("/")) {
                fileDir = fileDir.concat("/");
            }
            fileDir = StrAttackFilter.filter(fileDir);
            fileUrl = fileUrl.append(fileDir + fileName);
            filePath = oConvertUtils.isNotEmpty(staticDomain) && staticDomain.toLowerCase().startsWith("http") ? staticDomain + "/" + fileUrl : "https://" + bucketName + "." + endPoint + "/" + fileUrl;
            PutObjectResult result = ossClient.putObject(bucketName, fileUrl.toString(), file.openStream());
            ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
            if (result != null) {
                log.info("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + fileUrl);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return filePath;
    }

    public static void deleteUrl(String url) {
        OssBootUtil.deleteUrl(url, null);
    }

    public static void deleteUrl(String url, String bucket) {
        String newBucket = bucketName;
        if (oConvertUtils.isNotEmpty(bucket)) {
            newBucket = bucket;
        }
        String bucketUrl = "";
        bucketUrl = oConvertUtils.isNotEmpty(staticDomain) && staticDomain.toLowerCase().startsWith("http") ? staticDomain + "/" : "https://" + newBucket + "." + endPoint + "/";
        url = url.replace(bucketUrl, "");
        ossClient.deleteObject(newBucket, url);
    }

    public static void delete(String fileName) {
        ossClient.deleteObject(bucketName, fileName);
    }

    public static InputStream getOssFile(String objectName, String bucket) {
        BufferedInputStream inputStream = null;
        try {
            String newBucket = bucketName;
            if (oConvertUtils.isNotEmpty(bucket)) {
                newBucket = bucket;
            }
            OssBootUtil.initOss(endPoint, accessKeyId, accessKeySecret);
            objectName = OssBootUtil.replacePrefix(objectName, bucket);
            OSSObject ossObject = ossClient.getObject(newBucket, objectName);
            inputStream = new BufferedInputStream(ossObject.getObjectContent());
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u83b7\u53d6\u5931\u8d25" + e.getMessage());
        }
        return inputStream;
    }

    public static String getObjectUrl(String bucketName, String objectName, Date expires) {
        OssBootUtil.initOss(endPoint, accessKeyId, accessKeySecret);
        try {
            objectName = OssBootUtil.replacePrefix(objectName, bucketName);
            if (ossClient.doesObjectExist(bucketName, objectName)) {
                URL url = ossClient.generatePresignedUrl(bucketName, objectName, expires);
                return url.toString();
            }
        }
        catch (Exception e) {
            log.info("\u6587\u4ef6\u8def\u5f84\u83b7\u53d6\u5931\u8d25" + e.getMessage());
        }
        return null;
    }

    private static OSSClient initOss(String endpoint, String accessKeyId, String accessKeySecret) {
        if (ossClient == null) {
            ossClient = new OSSClient(endpoint, (CredentialsProvider)new DefaultCredentialProvider(accessKeyId, accessKeySecret), new ClientConfiguration());
        }
        return ossClient;
    }

    public static String upload(InputStream stream, String relativePath) {
        String filePath = null;
        String fileUrl = relativePath;
        OssBootUtil.initOss(endPoint, accessKeyId, accessKeySecret);
        filePath = oConvertUtils.isNotEmpty(staticDomain) && staticDomain.toLowerCase().startsWith("http") ? staticDomain + "/" + relativePath : "https://" + bucketName + "." + endPoint + "/" + fileUrl;
        PutObjectResult result = ossClient.putObject(bucketName, fileUrl.toString(), stream);
        ossClient.setBucketAcl(bucketName, CannedAccessControlList.PublicRead);
        if (result != null) {
            log.info("------OSS\u6587\u4ef6\u4e0a\u4f20\u6210\u529f------" + fileUrl);
        }
        return filePath;
    }

    private static String replacePrefix(String objectName, String customBucket) {
        log.info("------replacePrefix---\u66ff\u6362\u524d---objectName:{}", (Object)objectName);
        if (oConvertUtils.isNotEmpty(staticDomain)) {
            objectName = objectName.replace(staticDomain + "/", "");
        } else {
            String newBucket = bucketName;
            if (oConvertUtils.isNotEmpty(customBucket)) {
                newBucket = customBucket;
            }
            String path = "https://" + newBucket + "." + endPoint + "/";
            objectName = objectName.replace(path, "");
        }
        log.info("------replacePrefix---\u66ff\u6362\u540e---objectName:{}", (Object)objectName);
        return objectName;
    }

    static {
        ossClient = null;
    }
}

