/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.FilenameUtils;
import org.jeecg.common.exception.JeecgBootException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileDownloadUtils {
    private static final Logger log = LoggerFactory.getLogger(FileDownloadUtils.class);

    public static void downloadFile(HttpServletResponse response, String storePath, String fileName) {
        response.setCharacterEncoding("UTF-8");
        File file = new File(storePath);
        if (!file.exists()) {
            throw new NullPointerException("Specified file not found");
        }
        if (fileName == null || fileName.isEmpty()) {
            throw new NullPointerException("The file name can not null");
        }
        response.setHeader("content-type", "application/octet-stream");
        response.setContentType("application/octet-stream");
        try {
            response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(fileName, "UTF-8"));
            response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        }
        catch (UnsupportedEncodingException e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        byte[] buffer = new byte[1024];
        try (FileInputStream fis = new FileInputStream(file);
             BufferedInputStream bis = new BufferedInputStream(fis);){
            ServletOutputStream os = response.getOutputStream();
            int i = bis.read(buffer);
            while (i != -1) {
                os.write(buffer, 0, i);
                i = bis.read(buffer);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
    }

    public static void downloadFileMulti(HttpServletResponse response, List<String> filesPath, String zipFileName) throws IOException {
        String downloadName = zipFileName + ".zip";
        response.setCharacterEncoding("UTF-8");
        response.setHeader("content-type", "application/octet-stream");
        response.setContentType("application/octet-stream");
        response.setHeader("Content-Disposition", "attachment;filename=" + URLEncoder.encode(downloadName, "UTF-8"));
        response.setHeader("Access-Control-Expose-Headers", "Content-Disposition");
        log.info("\u5f00\u59cb\u538b\u7f29\u6587\u4ef6:" + filesPath);
        try (ZipOutputStream zipOut = new ZipOutputStream(new BufferedOutputStream((OutputStream)response.getOutputStream()));
             DataOutputStream os = new DataOutputStream(zipOut);){
            zipOut.setMethod(8);
            for (String filePath : filesPath) {
                int length;
                File file = new File(filePath);
                if (!file.exists()) continue;
                String fileName = file.getName();
                zipOut.putNextEntry(new ZipEntry(fileName));
                InputStream is = Files.newInputStream(file.toPath(), new OpenOption[0]);
                byte[] b = new byte[1024];
                while ((length = is.read(b)) != -1) {
                    os.write(b, 0, length);
                }
                is.close();
                zipOut.closeEntry();
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JeecgBootException(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static String download2DiskFromNet(String fileUrl, String storePath) {
        try {
            URL url = new URL(fileUrl);
            URLConnection conn = url.openConnection();
            conn.setConnectTimeout(3000);
            conn.setRequestProperty("User-Agent", "Mozilla/4.0 (compatible; MSIE 5.0; Windows NT; DigExt)");
            File file = FileDownloadUtils.ensureDestFileDir(storePath);
            try (InputStream inStream = conn.getInputStream();){
                String string;
                try (FileOutputStream fs = new FileOutputStream(file);){
                    int byteread;
                    byte[] buffer = new byte[1204];
                    while ((byteread = inStream.read(buffer)) != -1) {
                        fs.write(buffer, 0, byteread);
                    }
                    string = storePath;
                }
                return string;
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new JeecgBootException(e);
            }
        }
        catch (IOException e) {
            log.error(e.getMessage(), (Throwable)e);
            throw new JeecgBootException(e);
        }
    }

    public static File getUniqueFile(File file) {
        if (!file.exists()) {
            return file;
        }
        File tmpFile = new File(file.getAbsolutePath());
        File parentDir = tmpFile.getParentFile();
        int count = 1;
        String extension = FilenameUtils.getExtension((String)tmpFile.getName());
        String baseName = FilenameUtils.getBaseName((String)tmpFile.getName());
        while ((tmpFile = new File(parentDir, baseName + "(" + count++ + ")." + extension)).exists()) {
        }
        return tmpFile;
    }

    private static File ensureDestFileDir(String destFilePath) {
        File destFile = new File(destFilePath);
        FileDownloadUtils.checkDirAndCreate(destFile.getParentFile());
        return destFile;
    }

    public static void checkDirAndCreate(File dir) {
        if (!dir.exists()) {
            dir.mkdirs();
        }
    }
}

