/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.util;

import java.util.ArrayList;
import org.jeecg.common.system.query.QueryGenerator;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.util.CommonUtils;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SqlConcatUtil {
    private static final Logger log = LoggerFactory.getLogger(SqlConcatUtil.class);

    public static String getSingleSqlByRule(QueryRuleEnum rule, String field, Object value, boolean isString) {
        return SqlConcatUtil.getSingleSqlByRule(rule, field, value, isString, null);
    }

    public static String getSingleQueryConditionSql(String field, String alias, Object value, boolean isString, String dataBaseType) {
        if (value == null) {
            return "";
        }
        field = alias + oConvertUtils.camelToUnderline(field);
        QueryRuleEnum rule = QueryGenerator.convert2Rule(value);
        return SqlConcatUtil.getSingleSqlByRule(rule, field, value, isString, dataBaseType);
    }

    private static String getSingleSqlByRule(QueryRuleEnum rule, String field, Object value, boolean isString, String dataBaseType) {
        String res = "";
        switch (rule) {
            case GT: {
                res = field + rule.getValue() + SqlConcatUtil.getFieldConditionValue(value, isString, dataBaseType);
                break;
            }
            case GE: {
                res = field + rule.getValue() + SqlConcatUtil.getFieldConditionValue(value, isString, dataBaseType);
                break;
            }
            case LT: {
                res = field + rule.getValue() + SqlConcatUtil.getFieldConditionValue(value, isString, dataBaseType);
                break;
            }
            case LE: {
                res = field + rule.getValue() + SqlConcatUtil.getFieldConditionValue(value, isString, dataBaseType);
                break;
            }
            case EQ: {
                res = field + rule.getValue() + SqlConcatUtil.getFieldConditionValue(value, isString, dataBaseType);
                break;
            }
            case EQ_WITH_ADD: {
                res = field + " = " + SqlConcatUtil.getFieldConditionValue(value, isString, dataBaseType);
                break;
            }
            case NE: {
                res = field + " <> " + SqlConcatUtil.getFieldConditionValue(value, isString, dataBaseType);
                break;
            }
            case IN: {
                res = field + " in " + SqlConcatUtil.getInConditionValue(value, isString);
                break;
            }
            case LIKE: {
                res = field + " like " + SqlConcatUtil.getLikeConditionValue(value, QueryRuleEnum.LIKE);
                break;
            }
            case LEFT_LIKE: {
                res = field + " like " + SqlConcatUtil.getLikeConditionValue(value, QueryRuleEnum.LEFT_LIKE);
                break;
            }
            case RIGHT_LIKE: {
                res = field + " like " + SqlConcatUtil.getLikeConditionValue(value, QueryRuleEnum.RIGHT_LIKE);
                break;
            }
            default: {
                res = field + " = " + SqlConcatUtil.getFieldConditionValue(value, isString, dataBaseType);
            }
        }
        return res;
    }

    private static String getFieldConditionValue(Object value, boolean isString, String dataBaseType) {
        String str = value.toString().trim();
        if (str.startsWith("!")) {
            str = str.substring(1);
        } else if (str.startsWith(QueryRuleEnum.GE.getValue())) {
            str = str.substring(2);
        } else if (str.startsWith(QueryRuleEnum.LE.getValue())) {
            str = str.substring(2);
        } else if (str.startsWith(QueryRuleEnum.GT.getValue())) {
            str = str.substring(1);
        } else if (str.startsWith(QueryRuleEnum.LT.getValue())) {
            str = str.substring(1);
        } else if (str.indexOf("++") > 0) {
            str = str.replaceAll("\\+\\+", ",");
        }
        if (dataBaseType == null) {
            dataBaseType = SqlConcatUtil.getDbType();
        }
        if (isString) {
            if ("SQLSERVER".equals(dataBaseType)) {
                return " N'" + str + "' ";
            }
            return " '" + str + "' ";
        }
        if ("SQLSERVER".equals(dataBaseType) && str.endsWith("'") && str.startsWith("'")) {
            return " N" + str;
        }
        return value.toString();
    }

    private static String getInConditionValue(Object value, boolean isString) {
        String[] temp = value.toString().split(",");
        if (temp.length == 0) {
            return "('')";
        }
        if (isString) {
            ArrayList<String> res = new ArrayList<String>();
            for (String string : temp) {
                if ("SQLSERVER".equals(SqlConcatUtil.getDbType())) {
                    res.add("N'" + string + "'");
                    continue;
                }
                res.add("'" + string + "'");
            }
            return "(" + String.join((CharSequence)",", res) + ")";
        }
        return "(" + value.toString() + ")";
    }

    private static String getLikeConditionValue(Object value, QueryRuleEnum ruleEnum) {
        String str = value.toString().trim();
        if (str.startsWith("*") && str.endsWith("*")) {
            if ("SQLSERVER".equals(SqlConcatUtil.getDbType())) {
                return "N'%" + str.substring(1, str.length() - 1) + "%'";
            }
            return "'%" + str.substring(1, str.length() - 1) + "%'";
        }
        if (str.startsWith("*")) {
            if ("SQLSERVER".equals(SqlConcatUtil.getDbType())) {
                return "N'%" + str.substring(1) + "'";
            }
            return "'%" + str.substring(1) + "'";
        }
        if (str.endsWith("*")) {
            if ("SQLSERVER".equals(SqlConcatUtil.getDbType())) {
                return "N'" + str.substring(0, str.length() - 1) + "%'";
            }
            return "'" + str.substring(0, str.length() - 1) + "%'";
        }
        if (str.indexOf("%") >= 0) {
            if ("SQLSERVER".equals(SqlConcatUtil.getDbType())) {
                if (str.startsWith("'") && str.endsWith("'")) {
                    return "N" + str;
                }
                return "N'" + str + "'";
            }
            if (str.startsWith("'") && str.endsWith("'")) {
                return str;
            }
            return "'" + str + "'";
        }
        if (ruleEnum == QueryRuleEnum.LEFT_LIKE) {
            if ("SQLSERVER".equals(SqlConcatUtil.getDbType())) {
                return "N'%" + str + "'";
            }
            return "'%" + str + "'";
        }
        if (ruleEnum == QueryRuleEnum.RIGHT_LIKE) {
            if ("SQLSERVER".equals(SqlConcatUtil.getDbType())) {
                return "N'" + str + "%'";
            }
            return "'" + str + "%'";
        }
        if ("SQLSERVER".equals(SqlConcatUtil.getDbType())) {
            return "N'%" + str + "%'";
        }
        return "'%" + str + "%'";
    }

    private static String getDbType() {
        return CommonUtils.getDatabaseType();
    }
}

