/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.system.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jeecg.common.system.annotation.EnumDict;
import org.jeecg.common.system.vo.DictModel;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import org.springframework.core.type.classreading.CachingMetadataReaderFactory;
import org.springframework.core.type.classreading.MetadataReader;
import org.springframework.util.ClassUtils;

public class ResourceUtil {
    private static final Logger log = LoggerFactory.getLogger(ResourceUtil.class);
    private static final Map<String, List<DictModel>> enumDictData = new HashMap<String, List<DictModel>>(5);
    private static final String CLASS_PATTERN = "/**/*.class";
    private static final String CLASS_ENUM_PATTERN = "/**/*Enum.class";
    private static final String BASE_PACKAGE = "org.jeecg";
    private static final String METHOD_NAME = "getDictList";

    public static Map<String, List<DictModel>> getEnumDictData() {
        if (enumDictData.keySet().size() > 0) {
            return enumDictData;
        }
        PathMatchingResourcePatternResolver resourcePatternResolver = new PathMatchingResourcePatternResolver();
        String pattern = "classpath*:" + ClassUtils.convertClassNameToResourcePath((String)BASE_PACKAGE) + CLASS_ENUM_PATTERN;
        try {
            Resource[] resources = resourcePatternResolver.getResources(pattern);
            CachingMetadataReaderFactory readerFactory = new CachingMetadataReaderFactory((ResourceLoader)resourcePatternResolver);
            for (Resource resource : resources) {
                EnumDict annotation;
                String key;
                MetadataReader reader = readerFactory.getMetadataReader(resource);
                String classname = reader.getClassMetadata().getClassName();
                Class<?> clazz = Class.forName(classname);
                EnumDict enumDict = clazz.getAnnotation(EnumDict.class);
                if (enumDict == null || !oConvertUtils.isNotEmpty(key = (annotation = clazz.getAnnotation(EnumDict.class)).value())) continue;
                List list = (List)clazz.getDeclaredMethod(METHOD_NAME, new Class[0]).invoke(null, new Object[0]);
                enumDictData.put(key, list);
            }
        }
        catch (Exception e) {
            log.error("\u83b7\u53d6\u679a\u4e3e\u7c7b\u5b57\u5178\u6570\u636e\u5f02\u5e38", (Object)e.getMessage());
        }
        return enumDictData;
    }

    public static Map<String, List<DictModel>> queryManyDictByKeys(List<String> dictCodeList, List<String> keys) {
        if (enumDictData.keySet().size() == 0) {
            ResourceUtil.getEnumDictData();
        }
        HashMap<String, List<DictModel>> map = new HashMap<String, List<DictModel>>();
        block0: for (String code : enumDictData.keySet()) {
            if (dictCodeList.indexOf(code) < 0) continue;
            List<DictModel> dictItemList = enumDictData.get(code);
            for (DictModel dm : dictItemList) {
                String value = dm.getValue();
                if (keys.indexOf(value) < 0) continue;
                ArrayList<DictModel> list = new ArrayList<DictModel>();
                list.add(new DictModel(value, dm.getText()));
                map.put(code, list);
                continue block0;
            }
        }
        return map;
    }

    public static Object getImplementationClass(String classPath) {
        try {
            Class<?> aClass = Class.forName(classPath);
            return SpringContextUtils.getBean(aClass);
        }
        catch (ClassNotFoundException e) {
            log.error("\u7c7b\u6ca1\u6709\u627e\u5230", (Throwable)e);
            return null;
        }
        catch (NoSuchBeanDefinitionException e) {
            log.error(classPath + "\u6ca1\u6709\u5b9e\u73b0", (Throwable)e);
            return null;
        }
    }
}

