/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.desensitization.util;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.util.Collections;
import java.util.List;
import org.jeecg.common.desensitization.annotation.SensitiveField;
import org.jeecg.common.desensitization.enums.SensitiveEnum;
import org.jeecg.common.util.encryption.AesEncryptUtil;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SensitiveInfoUtil {
    private static final Logger log = LoggerFactory.getLogger(SensitiveInfoUtil.class);

    public static void handleNestedObject(Object obj, Class entity, boolean isEncode) throws IllegalAccessException {
        Field[] fields;
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            ParameterizedType pt;
            if (field.getType().isPrimitive()) continue;
            if (field.getType().equals(entity)) {
                field.setAccessible(true);
                Object nestedObject = field.get(obj);
                SensitiveInfoUtil.handlerObject(nestedObject, isEncode);
                break;
            }
            if (!(field.getGenericType() instanceof ParameterizedType) || !(pt = (ParameterizedType)field.getGenericType()).getRawType().equals(List.class) || !pt.getActualTypeArguments()[0].equals(entity)) continue;
            field.setAccessible(true);
            Object nestedObject = field.get(obj);
            SensitiveInfoUtil.handleList(nestedObject, entity, isEncode);
            break;
        }
    }

    public static Object handlerObject(Object obj, boolean isEncode) throws IllegalAccessException {
        Field[] fields;
        if (oConvertUtils.isEmpty(obj)) {
            return obj;
        }
        long startTime = System.currentTimeMillis();
        log.debug(" obj --> " + obj.toString());
        for (Field field : fields = obj.getClass().getDeclaredFields()) {
            String value;
            boolean isSensitiveField = field.isAnnotationPresent(SensitiveField.class);
            if (!isSensitiveField || !field.getType().isAssignableFrom(String.class)) continue;
            field.setAccessible(true);
            String realValue = (String)field.get(obj);
            if (realValue == null || "".equals(realValue)) continue;
            SensitiveField sf = field.getAnnotation(SensitiveField.class);
            if (isEncode) {
                value = SensitiveInfoUtil.getEncodeData(realValue, sf.type());
                field.set(obj, value);
                continue;
            }
            if (!sf.type().equals((Object)SensitiveEnum.ENCODE)) continue;
            value = SensitiveInfoUtil.getDecodeData(realValue);
            field.set(obj, value);
        }
        return obj;
    }

    public static void handleList(Object obj, Class entity, boolean isEncode) {
        Object first;
        List list = (List)obj;
        if (list.size() > 0 && (first = list.get(0)).getClass().equals(entity)) {
            for (int i = 0; i < list.size(); ++i) {
                Object temp = list.get(i);
                try {
                    SensitiveInfoUtil.handlerObject(temp, isEncode);
                    continue;
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static String getDecodeData(String data) {
        String result = null;
        try {
            result = AesEncryptUtil.desEncrypt(data);
        }
        catch (Exception exception) {
            log.debug("\u6570\u636e\u89e3\u5bc6\u9519\u8bef\uff0c\u539f\u6570\u636e:" + data);
        }
        if (oConvertUtils.isEmpty(result) && oConvertUtils.isNotEmpty(data)) {
            result = data;
        }
        return result;
    }

    public static String getEncodeData(String data, SensitiveEnum sensitiveEnum) {
        String result;
        switch (sensitiveEnum) {
            case ENCODE: {
                try {
                    result = AesEncryptUtil.encrypt(data);
                }
                catch (Exception exception) {
                    log.error("\u6570\u636e\u52a0\u5bc6\u9519\u8bef", (Object)exception.getMessage());
                    result = data;
                }
                break;
            }
            case CHINESE_NAME: {
                result = SensitiveInfoUtil.chineseName(data);
                break;
            }
            case ID_CARD: {
                result = SensitiveInfoUtil.idCardNum(data);
                break;
            }
            case FIXED_PHONE: {
                result = SensitiveInfoUtil.fixedPhone(data);
                break;
            }
            case MOBILE_PHONE: {
                result = SensitiveInfoUtil.mobilePhone(data);
                break;
            }
            case ADDRESS: {
                result = SensitiveInfoUtil.address(data, 3);
                break;
            }
            case EMAIL: {
                result = SensitiveInfoUtil.email(data);
                break;
            }
            case BANK_CARD: {
                result = SensitiveInfoUtil.bankCard(data);
                break;
            }
            case CNAPS_CODE: {
                result = SensitiveInfoUtil.cnapsCode(data);
                break;
            }
            default: {
                result = data;
            }
        }
        return result;
    }

    public static String chineseName(String fullName) {
        if (oConvertUtils.isEmpty(fullName)) {
            return "";
        }
        return SensitiveInfoUtil.formatRight(fullName, 1);
    }

    public static String chineseName(String familyName, String firstName) {
        if (oConvertUtils.isEmpty(familyName) || oConvertUtils.isEmpty(firstName)) {
            return "";
        }
        return SensitiveInfoUtil.chineseName(familyName + firstName);
    }

    public static String idCardNum(String id) {
        if (oConvertUtils.isEmpty(id)) {
            return "";
        }
        return SensitiveInfoUtil.formatLeft(id, 4);
    }

    public static String fixedPhone(String num) {
        if (oConvertUtils.isEmpty(num)) {
            return "";
        }
        return SensitiveInfoUtil.formatLeft(num, 4);
    }

    public static String mobilePhone(String num) {
        if (oConvertUtils.isEmpty(num)) {
            return "";
        }
        int len = num.length();
        if (len < 11) {
            return num;
        }
        return SensitiveInfoUtil.formatBetween(num, 3, 4);
    }

    public static String address(String address, int sensitiveSize) {
        if (oConvertUtils.isEmpty(address)) {
            return "";
        }
        int len = address.length();
        if (len < sensitiveSize) {
            return address;
        }
        return SensitiveInfoUtil.formatRight(address, sensitiveSize);
    }

    public static String email(String email) {
        if (oConvertUtils.isEmpty(email)) {
            return "";
        }
        int index = email.indexOf("@");
        if (index <= 1) {
            return email;
        }
        String begin = email.substring(0, 1);
        String end = email.substring(index);
        String stars = "**";
        return begin + stars + end;
    }

    public static String bankCard(String cardNum) {
        if (oConvertUtils.isEmpty(cardNum)) {
            return "";
        }
        return SensitiveInfoUtil.formatBetween(cardNum, 6, 4);
    }

    public static String cnapsCode(String code) {
        if (oConvertUtils.isEmpty(code)) {
            return "";
        }
        return SensitiveInfoUtil.formatRight(code, 2);
    }

    public static String formatRight(String str, int reservedLength) {
        String name = str.substring(0, reservedLength);
        String stars = String.join((CharSequence)"", Collections.nCopies(str.length() - reservedLength, "*"));
        return name + stars;
    }

    public static String formatLeft(String str, int reservedLength) {
        int len = str.length();
        String show = str.substring(len - reservedLength);
        String stars = String.join((CharSequence)"", Collections.nCopies(len - reservedLength, "*"));
        return stars + show;
    }

    public static String formatBetween(String str, int beginLen, int endLen) {
        int len = str.length();
        String begin = str.substring(0, beginLen);
        String end = str.substring(len - endLen);
        String stars = String.join((CharSequence)"", Collections.nCopies(len - beginLen - endLen, "*"));
        return begin + stars + end;
    }
}

