/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.desensitization.aspect;

import java.lang.reflect.Method;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.desensitization.annotation.SensitiveDecode;
import org.jeecg.common.desensitization.annotation.SensitiveEncode;
import org.jeecg.common.desensitization.util.SensitiveInfoUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class SensitiveDataAspect {
    private static final Logger log = LoggerFactory.getLogger(SensitiveDataAspect.class);

    @Pointcut(value="@annotation(org.jeecg.common.desensitization.annotation.SensitiveEncode) || @annotation(org.jeecg.common.desensitization.annotation.SensitiveDecode)")
    public void sensitivePointCut() {
    }

    @Around(value="sensitivePointCut()")
    public Object around(ProceedingJoinPoint point) throws Throwable {
        Object result = point.proceed();
        if (result == null) {
            return result;
        }
        Class<?> resultClass = result.getClass();
        log.debug(" resultClass  = {}", resultClass);
        if (resultClass.isPrimitive()) {
            return result;
        }
        boolean isEncode = true;
        Class entity = null;
        MethodSignature methodSignature = (MethodSignature)point.getSignature();
        Method method = methodSignature.getMethod();
        SensitiveEncode encode = method.getAnnotation(SensitiveEncode.class);
        if (encode == null) {
            SensitiveDecode decode = method.getAnnotation(SensitiveDecode.class);
            if (decode != null) {
                entity = decode.entity();
                isEncode = false;
            }
        } else {
            entity = encode.entity();
        }
        long startTime = System.currentTimeMillis();
        if (resultClass.equals(entity) || entity.equals(Object.class)) {
            SensitiveInfoUtil.handlerObject(result, isEncode);
        } else if (result instanceof List) {
            SensitiveInfoUtil.handleList(result, entity, isEncode);
        } else {
            SensitiveInfoUtil.handleNestedObject(result, entity, isEncode);
        }
        long endTime = System.currentTimeMillis();
        log.info((isEncode ? "\u52a0\u5bc6\u64cd\u4f5c\uff0c" : "\u89e3\u5bc6\u64cd\u4f5c\uff0c") + "Aspect\u7a0b\u5e8f\u8017\u65f6\uff1a" + (endTime - startTime) + "ms");
        return result;
    }
}

