/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.common.aspect;

import java.lang.reflect.Method;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.jeecg.common.api.CommonAPI;
import org.jeecg.common.aspect.UrlMatchEnum;
import org.jeecg.common.aspect.annotation.PermissionData;
import org.jeecg.common.system.query.QueryRuleEnum;
import org.jeecg.common.system.util.JeecgDataAutorUtils;
import org.jeecg.common.system.util.JwtUtil;
import org.jeecg.common.system.vo.SysPermissionDataRuleModel;
import org.jeecg.common.system.vo.SysUserCacheInfo;
import org.jeecg.common.util.SpringContextUtils;
import org.jeecg.common.util.oConvertUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Component;

@Aspect
@Component
public class PermissionDataAspect {
    private static final Logger log = LoggerFactory.getLogger(PermissionDataAspect.class);
    @Lazy
    @Autowired
    private CommonAPI commonApi;
    private static final String SPOT_DO = ".do";

    @Pointcut(value="@annotation(org.jeecg.common.aspect.annotation.PermissionData)")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object arround(ProceedingJoinPoint point) throws Throwable {
        String urlParamString;
        HttpServletRequest request = SpringContextUtils.getHttpServletRequest();
        MethodSignature signature = (MethodSignature)point.getSignature();
        Method method = signature.getMethod();
        PermissionData pd = method.getAnnotation(PermissionData.class);
        String component = pd.pageComponent();
        String requestMethod = request.getMethod();
        String requestPath = request.getRequestURI().substring(request.getContextPath().length());
        if (((requestPath = this.filterUrl(requestPath)).indexOf(UrlMatchEnum.CGREPORT_DATA.getMatchUrl()) >= 0 || requestPath.indexOf(UrlMatchEnum.CGREPORT_ONLY_DATA.getMatchUrl()) >= 0) && oConvertUtils.isNotEmpty(urlParamString = request.getParameter("onlRepUrlParamStr"))) {
            requestPath = requestPath + "?" + urlParamString;
        }
        log.debug("\u62e6\u622a\u8bf7\u6c42 >> {} ; \u8bf7\u6c42\u7c7b\u578b >> {} . ", (Object)requestPath, (Object)requestMethod);
        String username = JwtUtil.getUserNameByToken(request);
        List<SysPermissionDataRuleModel> dataRules = this.commonApi.queryPermissionDataRule(component, requestPath, username);
        if (dataRules != null && dataRules.size() > 0) {
            JeecgDataAutorUtils.installDataSearchConditon(request, dataRules);
            SysUserCacheInfo userinfo = this.commonApi.getCacheUser(username);
            JeecgDataAutorUtils.installUserInfo(request, userinfo);
        }
        return point.proceed();
    }

    private String filterUrl(String requestPath) {
        String url = "";
        if (oConvertUtils.isNotEmpty(requestPath)) {
            url = requestPath.replace("\\", "/");
            if ((url = url.replace("//", "/")).indexOf("//") >= 0) {
                url = this.filterUrl(url);
            }
        }
        return url;
    }

    @Deprecated
    private String getJgAuthRequsetPath(HttpServletRequest request) {
        String queryString = request.getQueryString();
        String requestPath = request.getRequestURI();
        if (oConvertUtils.isNotEmpty(queryString)) {
            requestPath = requestPath + "?" + queryString;
        }
        if (requestPath.indexOf("&") > -1) {
            requestPath = requestPath.substring(0, requestPath.indexOf("&"));
        }
        if (requestPath.indexOf(QueryRuleEnum.EQ.getValue()) != -1) {
            requestPath = requestPath.indexOf(SPOT_DO) != -1 ? requestPath.substring(0, requestPath.indexOf(SPOT_DO) + 3) : requestPath.substring(0, requestPath.indexOf("?"));
        }
        requestPath = requestPath.substring(request.getContextPath().length() + 1);
        return this.filterUrl(requestPath);
    }

    @Deprecated
    private boolean moHuContain(List<String> list, String key) {
        for (String str : list) {
            if (!key.contains(str)) continue;
            return true;
        }
        return false;
    }
}

