-- 新功能支持共享数据集
ALTER TABLE jimu_report_db
    ADD COLUMN iz_shared_source int(1) NULL COMMENT '是否为共享数据源(0 否 1 是)' AFTER api_convert;
ALTER TABLE jimu_report_db
    ADD COLUMN jimu_shared_source_id varchar(32) NULL COMMENT '指向共享数据集的id' AFTER iz_shared_source;

ALTER TABLE `onl_drag_page`
    ADD COLUMN `del_flag` int(11) NULL COMMENT '删除状态( 0未删除 1已删除)' AFTER `visits_num`;
UPDATE `onl_drag_page` SET `del_flag` = 0 WHERE `del_flag` IS NULL;

CREATE TABLE `onl_drag_share` (
                                  `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '主键',
                                  `drag_id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '在线仪表盘设计器id',
                                  `preview_url` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '预览地址',
                                  `preview_lock` varchar(4) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '密码锁',
                                  `last_update_time` datetime DEFAULT NULL COMMENT '最后更新时间',
                                  `term_of_validity` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '有效期(0:永久有效，1:1天，7:7天)',
                                  `status` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否过期(0未过期，1已过期)',
                                  `preview_lock_status` varchar(1) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '是否为密码锁(0 否,1是)',
                                  `share_token` varchar(32) COLLATE utf8mb4_general_ci DEFAULT NULL COMMENT '分享token',
                                  PRIMARY KEY (`id`) USING BTREE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci ROW_FORMAT=DYNAMIC COMMENT='仪表盘预览分享表';

ALTER TABLE `onl_drag_share`
    ADD UNIQUE INDEX `uniq_ods_drag_id`(`drag_id`) USING BTREE COMMENT '仪表盘id唯一索引';

INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1501109939736690691', '200', '统计进度图', 'JTotalProgress', 'ri:bar-chart-horizontal-line', 7, NULL, '{\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": -1,\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"value\": 50\n    }\n  ],\n  \"option\": {\r\n   \"targetValue\":{},\n    \"series\": [\n      {\n        \"barWidth\": 19,\n        \"label\": {\n          \"show\": true,\n          \"position\": \"right\",\n          \"offset\": [\n            0,\n            -40\n          ],\n          \"formatter\": \"{c}{a}\",\n          \"color\": \"black\",\n          \"fontSize\": 24\n        },\n        \"itemStyle\": {\n          \"normal\": {\n            \"barBorderRadius\": 10\n          }\n        },\n        \"color\": \"#151B87\",\n        \"zlevel\": 1\n      },\n      {\n        \"type\": \"bar\",\n        \"barGap\": \"-100%\",\n        \"color\": \"#eeeeee\",\n        \"barWidth\": 19,\n        \"itemStyle\": {\n          \"normal\": {\n            \"barBorderRadius\": 10\n          }\n        }\n      }\n    ]\n  }\n}', '1', 'jeecg', '2022-03-08 16:17:54', 'admin', '2022-04-28 20:58:49');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1501109939736690693', '200', '字符云', 'JWordCloud', 'ri:bar-chart-horizontal-line', 7, NULL, '{\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": -1,\n  \"linkageConfig\": [],\n  \"dataMapping\": [\r\n    {\r\n      \"filed\": \"维度\",\r\n      \"mapping\": \"\"\r\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\r\n      \"name\":\"手机\",\n      \"value\": 50\n    }\n  ],\n  \"option\": {\r\n   \"minSize\": 12,\r\n    \"maxSize\": 60,\n    \"series\": [\n      {\n        \"type\": \"wordCloud\",\r\n        \"shape\": \"circle\"\n      }\n    ]\n  }\n}', '1', 'jeecg', '2022-03-08 16:17:54', 'admin', '2022-04-28 20:58:49');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008904673035976704', '1009728871115423744', '翻牌器', 'JCountTo', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/42/nav\",\n  \"timeOut\": 0,\n  \"background\": \"#4A90E2\",\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"chartData\": \"10000\",\n  \"option\": {\n    \"whole\": false,\n    \"boxWidth\":50,\r\n   \"boxHeight\":50,\n    \"fontSize\": 16,\n    \"color\": \"#fff\",\n    \"fontWeight\": \"normal\",\n    \"prefixFontSize\": 16,\n    \"prefixColor\": \"#fff\",\n    \"prefixFontWeight\": \"normal\",\n    \"suffix\": \"\",\n    \"suffixFontSize\": 16,\n    \"suffixColor\": \"#fff\",\n    \"suffixFontWeight\": \"normal\",\n    \"prefix\": \"\",\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"body\": {\n      \"text\": \"\",\n      \"color\": \"#FFFFFF\",\n      \"fontWeight\": \"bold\",\n      \"marginLeft\": 0,\n      \"marginTop\": 0\n    }\n  }\n}', '1', 'admin', '2024-10-23 11:13:49', 'admin', '2024-10-23 11:55:21');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1009335943687733248', '1009728871115423744', '男女占比', 'JGender', NULL, 100, NULL, '{\n  \"w\": 8,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/26/pictogram\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"男\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"女\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"man\": 50,\n      \"woman\": 35\n    }\n  ],\n  \"option\": {\n    \"title\": {\n      \"show\": true,\n      \"text\": \"男女占比\"\n    },\n    \"grid\": {\n      \"bottom\": 115\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"series\": []\n  }\n}', '1', 'admin', '2024-10-24 15:47:32', 'admin', '2024-10-24 15:48:01');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1009345312659767296', '1009728871115423744', '颜色块', 'JColorBlock', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/42/nav\",\n  \"timeOut\": 0,\n  \"background\": \"#4A90E2\",\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"前缀\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"后缀\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"颜色\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"chartData\": [\n    {\n      \"backgroundColor\": \"#67C23A\",\n      \"prefix\": \"朝阳总销售额\",\n      \"value\": \"12345\",\n      \"suffix\": \"亿\"\n    },\n    {\n      \"backgroundColor\": \"#409EFF\",\n      \"prefix\": \"昌平总销售额\",\n      \"value\": \"12345\",\n      \"suffix\": \"亿\"\n    },\n    {\n      \"backgroundColor\": \"#E6A23C\",\n      \"prefix\": \"海淀总销售额\",\n      \"value\": \"12345\",\n      \"suffix\": \"亿\"\n    },\n    {\n      \"backgroundColor\": \"#F56C6C\",\n      \"prefix\": \"西城总销售额\",\n      \"value\": \"12345\",\n      \"suffix\": \"亿\"\n    }\n  ],\n  \"option\": {\n    \"whole\": false,\n    \"width\": 50,\n    \"height\": 50,\n    \"lineNum\": 2,\n    \"borderSplitx\": 20,\n    \"borderSplity\": 20,\n    \"fontSize\": 16,\n    \"color\": \"#fff\",\n    \"fontWeight\": \"normal\",\n    \"textAlign\": \"center\",\n    \"padding\": 5,\n    \"prefixFontSize\": 16,\n    \"prefixColor\": \"#fff\",\n    \"prefixFontWeight\": \"normal\",\n    \"prefixSplitx\": 0,\n    \"prefixSplity\": 0,\n    \"suffix\": \"\",\n    \"suffixSplitx\": 0,\n    \"suffixFontSize\": 16,\n    \"suffixColor\": \"#fff\",\n    \"suffixFontWeight\": \"normal\",\n    \"prefix\": \"\",\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"body\": {\n      \"text\": \"\",\n      \"color\": \"#FFFFFF\",\n      \"fontWeight\": \"bold\",\n      \"marginLeft\": 0,\n      \"marginTop\": 0\n    }\n  }\n}', '1', 'admin', '2024-10-24 16:24:45', 'admin', '2024-10-24 16:24:56');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1009386233476579328', '1009728871115423744', '胶囊图', 'JCapsuleChart', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": \"苹果\",\n      \"value\": 1000879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"三星\",\n      \"value\": 3400879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"小米\",\n      \"value\": 2300879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"oppo\",\n      \"value\": 5400879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"vivo\",\n      \"value\": 3400879,\n      \"type\": \"手机品牌\"\n    }\n  ],\n  \"option\": {\n    \"showValue\": false,\n    \"unit\": \"\",\n    \"customColor\": [],\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"基础柱形图\",\n      \"show\": true,\n      \"textStyle\": {\n        \"color\": \"#464646\",\n        \"fontWeight\": \"normal\"\n      }\n    }\n  }\n}', '1', 'admin', '2024-10-24 19:07:22', 'admin', '2024-10-24 19:07:37');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1009395760485793792', '1009728871115423744', '动态环形图', 'JActiveRing', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": \"周口\",\n      \"value\": 55\n    },\n    {\n      \"name\": \"南阳\",\n      \"value\": 120\n    },\n    {\n      \"name\": \"西峡\",\n      \"value\": 78\n    },\n    {\n      \"name\": \"驻马店\",\n      \"value\": 66\n    },\n    {\n      \"name\": \"新乡\",\n      \"value\": 80\n    }\n  ],\n  \"option\": {\n    \"lineWidth\": 10,\n    \"radius\": 100,\n    \"activeRadius\": 100,\n    \"showOriginValue\": false,\n    \"customColor\": [],\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"动态环形图\",\n      \"show\": true,\n      \"textStyle\": {\n        \"color\": \"#464646\",\n        \"fontWeight\": \"normal\"\n      }\n    }\n  }\n}', '1', 'admin', '2024-10-24 19:45:13', 'admin', '2024-10-24 19:45:39');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1009679509282783232', '1009728871115423744', '排行榜', 'JScrollRankingBoard', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": \"苹果\",\n      \"value\": 1000879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"三星\",\n      \"value\": 3400879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"小米\",\n      \"value\": 2300879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"oppo\",\n      \"value\": 5400879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"vivo\",\n      \"value\": 3400879,\n      \"type\": \"手机品牌\"\n    }\n  ],\n  \"option\": {\n    \"waitTime\": 2000,\n    \"rowNum\": 5,\n    \"carousel\": \"single\",\n    \"sort\": true,\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"排行榜\",\n      \"show\": true,\n      \"textStyle\": {\n        \"color\": \"#464646\",\n        \"fontWeight\": \"normal\"\n      }\n    }\n  }\n}', '1', 'admin', '2024-10-25 14:32:44', 'admin', '2024-10-25 14:33:00');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1009694340236869632', '1009728871115423744', '轮播表', 'JScrollBoard', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    [\n      \"行1列1\",\n      \"行1列2\",\n      \"行1列3\"\n    ],\n    [\n      \"行2列1\",\n      \"行2列2\",\n      \"行2列3\"\n    ],\n    [\n      \"行3列1\",\n      \"行3列2\",\n      \"行3列3\"\n    ],\n    [\n      \"行4列1\",\n      \"行4列2\",\n      \"行4列3\"\n    ],\n    [\n      \"行5列1\",\n      \"行5列2\",\n      \"行5列3\"\n    ]\n  ],\n  \"option\": {\n    \"waitTime\": 2000,\n    \"rowNum\": 5,\n    \"carousel\": \"single\",\n    \"sort\": true,\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"轮播表\",\n      \"show\": true,\n      \"textStyle\": {\n        \"color\": \"#464646\",\n        \"fontWeight\": \"normal\"\n      }\n    }\n  }\n}', '1', 'admin', '2024-10-25 15:31:40', 'admin', '2024-10-25 15:32:08');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1009728871115423744', '0', '大屏', 'bigscreen', 'ant-design:fund-projection-screen-outlined', 100, NULL, NULL, '1', 'admin', '2024-10-25 17:48:53', 'admin', '2024-10-25 17:49:14');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1009728983979950080', '1009728871115423744', '边框', 'border', NULL, 100, NULL, NULL, '1', 'admin', '2024-10-25 17:49:20', 'admin', '2024-10-25 17:49:50');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1009729002476830720', '1009728871115423744', '装饰', 'decoration', NULL, 100, NULL, NULL, '1', 'admin', '2024-10-25 17:49:24', 'admin', '2024-10-25 17:50:05');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1010847514343669760', '1009728871115423744', '水波图', 'JLiquid', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"value\": 25\n    }\n  ],\n  \"option\": {\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"水波图\",\n      \"show\": true,\n      \"textStyle\": {\n        \"color\": \"#464646\",\n        \"fontWeight\": \"normal\"\n      }\n    }\n  }\n}', '1', 'admin', '2024-10-28 19:53:58', 'admin', '2024-10-28 19:54:17');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1011075798868328448', '1009728871115423744', '玉珏图', 'JRadialBar', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\":[\n      {\n          \"name\": \"A\",\n          \"value\": 297\n      },\n      {\n          \"name\": \"B\",\n          \"value\": 506\n      },\n      {\n          \"name\": \"C\",\n          \"value\": 805\n      },\n      {\n          \"name\": \"D\",\n          \"value\": 1478\n      },\n      {\n          \"name\": \"E\",\n          \"value\": 2029\n      },\n      {\n          \"name\": \"F\",\n          \"value\": 7100\n      },\n      {\n          \"name\": \"G\",\n          \"value\": 7346\n      },\n      {\n          \"name\": \"H\",\n          \"value\": 10178\n      }\n  ],\n  \"option\": {\n    \"type\": \"bar\",\n    \"radius\": 0.8,\n    \"innerRadius\": 0.2,\n    \"maxAngle\": 240,\n    \"radiuShow\": false,\n    \"bgShow\": false,\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"玉珏图\",\n      \"show\": true,\n      \"textStyle\": {\n        \"color\": \"#464646\",\n        \"fontWeight\": \"normal\"\n      }\n    }\n  }\n}', '1', 'admin', '2024-10-29 11:01:06', 'admin', '2024-10-29 11:01:35');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1011128533818966016', '1009728871115423744', '百分比条形图', 'JPercentBar', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"分组\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\":[\n      {\n          \"type\": \"Asia\",\n          \"name\": \"1750\",\n          \"value\": 502\n      },\n      {\n          \"type\": \"Asia\",\n          \"name\": \"1800\",\n          \"value\": 635\n      },\n      {\n          \"type\": \"Asia\",\n          \"name\": \"1850\",\n          \"value\": 809\n      },\n      {\n          \"type\": \"Asia\",\n          \"name\": \"1900\",\n          \"value\": 947\n      },\n      {\n          \"type\": \"Asia\",\n          \"name\": \"1950\",\n          \"value\": 1402\n      },\n      {\n          \"type\": \"Asia\",\n          \"name\": \"1999\",\n          \"value\": 3634\n      },\n      {\n          \"type\": \"Asia\",\n          \"name\": \"2050\",\n          \"value\": 5268\n      },\n      {\n          \"type\": \"Africa\",\n          \"name\": \"1750\",\n          \"value\": 106\n      },\n      {\n          \"type\": \"Africa\",\n          \"name\": \"1800\",\n          \"value\": 107\n      },\n      {\n          \"type\": \"Africa\",\n          \"name\": \"1850\",\n          \"value\": 111\n      },\n      {\n          \"type\": \"Africa\",\n          \"name\": \"1900\",\n          \"value\": 133\n      },\n      {\n          \"type\": \"Africa\",\n          \"name\": \"1950\",\n          \"value\": 221\n      },\n      {\n          \"type\": \"Africa\",\n          \"name\": \"1999\",\n          \"value\": 767\n      },\n      {\n          \"type\": \"Africa\",\n          \"name\": \"2050\",\n          \"value\": 1766\n      },\n      {\n          \"type\": \"Europe\",\n          \"name\": \"1750\",\n          \"value\": 163\n      },\n      {\n          \"type\": \"Europe\",\n          \"name\": \"1800\",\n          \"value\": 203\n      },\n      {\n          \"type\": \"Europe\",\n          \"name\": \"1850\",\n          \"value\": 276\n      },\n      {\n          \"type\": \"Europe\",\n          \"name\": \"1900\",\n          \"value\": 408\n      },\n      {\n          \"type\": \"Europe\",\n          \"name\": \"1950\",\n          \"value\": 547\n      },\n      {\n          \"type\": \"Europe\",\n          \"name\": \"1999\",\n          \"value\": 729\n      },\n      {\n          \"type\": \"Europe\",\n          \"name\": \"2050\",\n          \"value\": 628\n      }\n  ],\n  \"option\": {\n    \"yNameFontColor\": \"#fff\",\n    \"yNameFontSize\": 12,\n    \"xNameFontColor\": \"#fff\",\n    \"xNameFontSize\": 12,\n    \"legendLayout\": \"horizontal\",\n    \"legendPosition\": \"bottom\",\n    \"legendFontColor\": \"#fff\",\n    \"legendFontSize\": 16,\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"百分比图\",\n      \"show\": true,\n      \"textStyle\": {\n        \"color\": \"#464646\",\n        \"fontWeight\": \"normal\"\n      }\n    }\n  }\n}', '1', 'admin', '2024-10-29 14:30:39', 'admin', '2024-10-29 14:30:56');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1011137156657872896', '1009728871115423744', '矩形图', 'JRectangle', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": \"分类 1\",\n      \"value\": 560\n    },\n    {\n      \"name\": \"分类 2\",\n      \"value\": 500\n    },\n    {\n      \"name\": \"分类 3\",\n      \"value\": 150\n    },\n    {\n      \"name\": \"分类 4\",\n      \"value\": 140\n    },\n    {\n      \"name\": \"分类 5\",\n      \"value\": 115\n    },\n    {\n      \"name\": \"分类 6\",\n      \"value\": 95\n    },\n    {\n      \"name\": \"分类 7\",\n      \"value\": 90\n    },\n    {\n      \"name\": \"分类 8\",\n      \"value\": 75\n    },\n    {\n      \"name\": \"分类 9\",\n      \"value\": 98\n    },\n    {\n      \"name\": \"分类 10\",\n      \"value\": 60\n    },\n    {\n      \"name\": \"分类 11\",\n      \"value\": 45\n    },\n    {\n      \"name\": \"分类 12\",\n      \"value\": 40\n    },\n    {\n      \"name\": \"分类 13\",\n      \"value\": 40\n    },\n    {\n      \"name\": \"分类 14\",\n      \"value\": 35\n    },\n    {\n      \"name\": \"分类 15\",\n      \"value\": 40\n    },\n    {\n      \"name\": \"分类 16\",\n      \"value\": 40\n    },\n    {\n      \"name\": \"分类 17\",\n      \"value\": 40\n    },\n    {\n      \"name\": \"分类 18\",\n      \"value\": 30\n    },\n    {\n      \"name\": \"分类 19\",\n      \"value\": 28\n    },\n    {\n      \"name\": \"分类 20\",\n      \"value\": 16\n    }\n  ],\n  \"option\": {\n    \"theme\": \"default\",\n    \"titleFontSize\": 12,\n    \"titleColor\": \"#fff\",\n    \"tipFontSize\": 12,\n    \"tipColor\": \"#fff\",\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"基础矩形图\",\n      \"show\": true,\n      \"textStyle\": {\n        \"color\": \"#464646\",\n        \"fontWeight\": \"normal\"\n      }\n    }\n  }\n}', '1', 'admin', '2024-10-29 15:04:54', 'admin', '2024-10-29 15:05:11');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1011144678642974720', '1009728871115423744', '旋转饼图', 'JRotatePie', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": -1,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"value\": 1048,\n      \"name\": \"vivo\"\n    },\n    {\n      \"value\": 735,\n      \"name\": \"oppo\"\n    },\n    {\n      \"value\": 580,\n      \"name\": \"苹果\"\n    },\n    {\n      \"value\": 484,\n      \"name\": \"小米\"\n    },\n    {\n      \"value\": 300,\n      \"name\": \"三星\"\n    }\n  ],\n  \"option\": {\n    \"grid\": {\n      \"show\": false,\n      \"bottom\": 115\n    },\n    \"title\": {\n      \"text\": \"旋转饼图\",\n      \"subtext\": \"\",\n      \"left\": \"left\",\n      \"textStyle\": {\n        \"fontWeight\": \"normal\"\n      },\n      \"show\": true\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"tooltip\": {\n      \"trigger\": \"item\"\n    },\n    \"legend\": {\n      \"orient\": \"vertical\"\n    },\n    \"series\": [\n      {\n        \"name\": \"\",\n        \"type\": \"pie\",\n        \"data\": [],\n        \"emphasis\": {\n          \"itemStyle\": {\n            \"shadowBlur\": 10,\n            \"shadowOffsetX\": 0,\n            \"shadowColor\": \"rgba(0, 0, 0, 0.5)\"\n          }\n        }\n      }\n    ]\n  }\n}', '1', 'admin', '2024-10-29 15:34:48', 'admin', '2024-10-29 15:35:16');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1011160078130774016', '1009728871115423744', '视频', 'JVideoPlay', NULL, 100, NULL, '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/42/nav\",\n  \"timeOut\": 0,\n  \"background\": \"#4A90E2\",\n  \"dataMapping\": [\n    {\n      \"filed\": \"路径\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"src\": \"http://vjs.zencdn.net/v/oceans.mp4\"\n    }\n  ],\n  \"option\": {\n    \"autoPlay\": false,\n    \"loop\": true\n  }\n}', '1', 'admin', '2024-10-29 16:35:59', 'admin', '2024-10-29 16:36:14');

UPDATE `onl_drag_comp` SET `parent_id` = '1537764165146476546', `comp_name` = '普通散点图', `comp_type` = 'JScatter', `icon` = 'mdi:chart-scatter-plot', `order_num` = 100, `type_id` = NULL, `comp_config` = '{\r\n  \"w\": 12,\r\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": 200,\n      \"value\": 300\n    },\n    {\n      \"name\": 400,\n      \"value\": 500\n    },\n    {\n      \"name\": 150,\n      \"value\": 320\n    },\n    {\n      \"name\": 320,\n      \"value\": 320\n    },\n    {\n      \"name\": 170,\n      \"value\": 300\n    }\n  ],\n  \"option\": {\n    \"grid\": {\n      \"show\": false,\n      \"bottom\": 115\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"基础散点图\",\n      \"show\": true,\n      \"textStyle\": {\r\n				\"fontWeight\":\"normal\"\n      }\n    },\n    \"tooltip\": {\n      \"trigger\": \"item\",\n      \"formatter\": \"x:{b}<br/>y:{c}\",\n      \"axisPointer\": {\n        \"type\": \"shadow\",\n        \"label\": {\n          \"show\": true,\n          \"backgroundColor\": \"#333\"\n        }\n      }\n    },\n    \"yAxis\": {\n      \"splitLine\": {\n        \"interval\": 2\n      },\n      \"lineStyle\": {\n        \"color\": \"#f3f3f3\"\n      }\n    },\n    \"series\": [\n      {\n        \"data\": [],\n        \"type\": \"scatter\",\n        \"symbolSize\": 20,\r\n        \"itemStyle\": {\r\n          \"color\": \"#64b5f6\"\r\n        }\n      }\n    ]\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = '2022-06-16 14:16:07', `update_by` = NULL, `update_time` = '2022-06-16 17:10:52' WHERE `id` = '1537318081257291777';
UPDATE `onl_drag_comp` SET `parent_id` = '200200', `comp_name` = '基础柱形图', `comp_type` = 'JBar', `icon` = 'ic:baseline-bar-chart', `order_num` = NULL, `type_id` = NULL, `comp_config` = '{\r\n  \"w\": 12,\r\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": \"苹果\",\n      \"value\": 1000879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"三星\",\n      \"value\": 3400879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"小米\",\n      \"value\": 2300879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"oppo\",\n      \"value\": 5400879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"vivo\",\n      \"value\": 3400879,\n      \"type\": \"手机品牌\"\n    }\n  ],\n  \"option\": {\n    \"grid\": {\n      \"show\": false,\n      \"top\":90, \n      \"bottom\": 115,\r\n			\"containLabel\": true\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"基础柱形图\",\n      \"show\": true,\n      \"textStyle\": {\r\n				\"fontWeight\":\"normal\"\n      }\n    },\n    \"tooltip\": {\n      \"trigger\": \"axis\",\n      \"axisPointer\": {\n        \"type\": \"shadow\",\n        \"label\": {\n          \"show\": true,\n          \"backgroundColor\": \"#333\"\n        }\n      }\n    },\n    \"yAxis\": {\n      \"splitLine\": {\n        \"interval\": 2\n      },\n      \"lineStyle\": {\n        \"color\": \"#f3f3f3\"\n      }\n    },\n    \"series\": [\n      {\n        \"data\": [],\n        \"type\": \"bar\",\n        \"barWidth\": 40,\n        \"itemStyle\": {\n          \"color\": \"#64b5f6\",\n          \"borderRadius\": 0\n        }\n      }\n    ]\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-08-04 19:18:21' WHERE `id` = '200200201';
UPDATE `onl_drag_comp` SET `parent_id` = '200200', `comp_name` = '堆叠柱形图', `comp_type` = 'JStackBar', `icon` = 'ic:outline-stacked-bar-chart', `order_num` = NULL, `type_id` = NULL, `comp_config` = '{\r\n  \"w\": 12,\r\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/26/stackedBar\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"分组\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": \"1991\",\n      \"value\": 3,\n      \"type\": \"Lon\"\n    },\n    {\n      \"name\": \"1992\",\n      \"value\": 4,\n      \"type\": \"Lon\"\n    },\n    {\n      \"name\": \"1993\",\n      \"value\": 3.5,\n      \"type\": \"Lon\"\n    },\n    {\n      \"name\": \"1994\",\n      \"value\": 5,\n      \"type\": \"Lon\"\n    },\n    {\n      \"name\": \"1995\",\n      \"value\": 4.9,\n      \"type\": \"Lon\"\n    },\n    {\n      \"name\": \"1996\",\n      \"value\": 6,\n      \"type\": \"Lon\"\n    },\n    {\n      \"name\": \"1997\",\n      \"value\": 7,\n      \"type\": \"Lon\"\n    },\n    {\n      \"name\": \"1998\",\n      \"value\": 9,\n      \"type\": \"Lon\"\n    },\n    {\n      \"name\": \"1999\",\n      \"value\": 13,\n      \"type\": \"Lon\"\n    },\n    {\n      \"name\": \"1991\",\n      \"value\": 3,\n      \"type\": \"Bor\"\n    },\n    {\n      \"name\": \"1992\",\n      \"value\": 4,\n      \"type\": \"Bor\"\n    },\n    {\n      \"name\": \"1993\",\n      \"value\": 3.5,\n      \"type\": \"Bor\"\n    },\n    {\n      \"name\": \"1994\",\n      \"value\": 5,\n      \"type\": \"Bor\"\n    },\n    {\n      \"name\": \"1995\",\n      \"value\": 4.9,\n      \"type\": \"Bor\"\n    },\n    {\n      \"name\": \"1996\",\n      \"value\": 6,\n      \"type\": \"Bor\"\n    },\n    {\n      \"name\": \"1997\",\n      \"value\": 7,\n      \"type\": \"Bor\"\n    },\n    {\n      \"name\": \"1998\",\n      \"value\": 9,\n      \"type\": \"Bor\"\n    },\n    {\n      \"name\": \"1999\",\n      \"value\": 13,\n      \"type\": \"Bor\"\n    }\n  ],\n  \"option\": {\n    \"title\": {\n      \"text\": \"堆叠柱形图\",\r\n			\"textStyle\":{\r\n			  \"fontWeight\":\"normal\"\r\n			},\n      \"show\": true\n    },\n    \"grid\": {\n      \"bottom\": 115,\n          \"top\":90\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"tooltip\": {\n      \"trigger\": \"axis\",\n      \"axisPointer\": {\n        \"type\": \"shadow\",\n        \"label\": {\n          \"show\": true,\n          \"backgroundColor\": \"#333\"\n        }\n      }\n    },\n    \"series\": []\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = '2021-12-28 16:18:31', `update_by` = 'admin', `update_time` = '2022-08-04 19:18:32' WHERE `id` = '200200202';
UPDATE `onl_drag_comp` SET `parent_id` = '1537002903949037570', `comp_name` = '双轴图', `comp_type` = 'DoubleLineBar', `icon` = 'material-symbols:ssid-chart', `order_num` = 5, `type_id` = NULL, `comp_config` = '{\r\n  \"w\": 12,\r\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/26/stackedBar\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"分组\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"seriesType\": [\n    {\n      \"series\": \"降水量\",\n      \"type\": \"bar\"\n    },\n    {\n      \"series\": \"温度\",\n      \"type\": \"line\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": \"1991\",\n      \"value\": 110,\n      \"type\": \"降水量\"\n    },\n    {\n      \"name\": \"1992\",\n      \"value\": 130,\n      \"type\": \"降水量\"\n    },\n    {\n      \"name\": \"1993\",\n      \"value\": 113.5,\n      \"type\": \"降水量\"\n    },\n    {\n      \"name\": \"1994\",\n      \"value\": 150,\n      \"type\": \"降水量\"\n    },\n    {\n      \"name\": \"1995\",\n      \"value\": 240.9,\n      \"type\": \"降水量\"\n    },\n    {\n      \"name\": \"1996\",\n      \"value\": 160,\n      \"type\": \"降水量\"\n    },\n    {\n      \"name\": \"1997\",\n      \"value\": 97,\n      \"type\": \"降水量\"\n    },\n    {\n      \"name\": \"1998\",\n      \"value\": 290,\n      \"type\": \"降水量\"\n    },\n    {\n      \"name\": \"1999\",\n      \"value\": 230,\n      \"type\": \"降水量\"\n    },\n    {\n      \"name\": \"1991\",\n      \"value\": 33,\n      \"type\": \"温度\"\n    },\n    {\n      \"name\": \"1992\",\n      \"value\": 35,\n      \"type\": \"温度\"\n    },\n    {\n      \"name\": \"1993\",\n      \"value\": 37,\n      \"type\": \"温度\"\n    },\n    {\n      \"name\": \"1994\",\n      \"value\": 35,\n      \"type\": \"温度\"\n    },\n    {\n      \"name\": \"1995\",\n      \"value\": 34.9,\n      \"type\": \"温度\"\n    },\n    {\n      \"name\": \"1996\",\n      \"value\": 36,\n      \"type\": \"温度\"\n    },\n    {\n      \"name\": \"1997\",\n      \"value\": 37,\n      \"type\": \"温度\"\n    },\n    {\n      \"name\": \"1998\",\n      \"value\": 39,\n      \"type\": \"温度\"\n    },\n    {\n      \"name\": \"1999\",\n      \"value\": 33,\n      \"type\": \"温度\"\n    }\n  ],\n  \"option\": {\n    \"title\": {\n      \"text\": \"双轴图\",\n      \"show\": true,\n      \"textStyle\": {\n        \"fontWeight\": \"normal\",\n        \"fontSize\": \"14\"\n      }\n    },\n    \"legend\": {\n      \"t\": 4\n    },\n    \"grid\": {\n      \"bottom\": 115\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"tooltip\": {\n      \"trigger\": \"axis\",\n      \"axisPointer\": {\n        \"type\": \"shadow\",\n        \"label\": {\n          \"show\": true,\n          \"backgroundColor\": \"#333\"\n        }\n      }\n    },\n    \"yAxis\": [\n      {\n        \"type\": \"value\"\n      },\n      {\n        \"type\": \"value\"\n      }\n    ],\n    \"series\": []\n  }\n}', `status` = '1', `create_by` = 'jeecg', `create_time` = '2022-09-05 19:05:53', `update_by` = 'ldd', `update_time` = '2022-12-06 18:11:10' WHERE `id` = '726723325897637888';
UPDATE `onl_drag_comp` SET `parent_id` = '200', `comp_name` = '进度图', `comp_type` = 'JProgress', `icon` = 'ri:bar-chart-horizontal-line', `order_num` = 7, `type_id` = NULL, `comp_config` = '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": -1,\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": \"内存使用率\",\n      \"value\": 50\n    }\n  ],\n  \"option\": {\n    \"grid\": {\n      \"show\": false\n    },\n    \"title\": {\n      \"text\": \"基础进度图\",\n      \"show\": true,\n      \"textStyle\": {}\n    },\n    \"tooltip\": {\n      \"trigger\": \"axis\",\n      \"axisPointer\": {\n        \"type\": \"shadow\",\n        \"label\": {\n          \"show\": true,\n          \"backgroundColor\": \"#333\"\n        }\n      }\n    },\n    \"series\": [\n      {\n        \"barWidth\": 19,\n        \"label\": {\n          \"show\": true,\n          \"position\": \"right\",\n          \"offset\": [\n            0,\n            -40\n          ],\n          \"formatter\": \"{c}{a}\",\n          \"color\": \"black\",\n          \"fontSize\": 24\n        },\n        \"itemStyle\": {\n          \"normal\": {\n            \"barBorderRadius\": 10\n          }\n        },\n        \"color\": \"#151B87\",\n        \"zlevel\": 1\n      },\n      {\n        \"type\": \"bar\",\n        \"barGap\": \"-100%\",\n        \"color\": \"#eeeeee\",\n        \"barWidth\": 19,\n        \"itemStyle\": {\n          \"normal\": {\n            \"barBorderRadius\": 10\n          }\n        }\n      }\n    ]\n  }\n}', `status` = '1', `create_by` = 'jeecg', `create_time` = '2022-03-08 16:17:54', `update_by` = 'admin', `update_time` = '2022-04-28 20:58:49' WHERE `id` = '1501109939736690689';
UPDATE `onl_drag_comp` SET `parent_id` = '200200', `comp_name` = '背景柱形图', `comp_type` = 'JBackgroundBar', `icon` = 'ic:baseline-bar-chart', `order_num` = 2, `type_id` = NULL, `comp_config` = '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/33/chart\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"维度\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"name\": \"苹果\",\n      \"value\": 1000879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"三星\",\n      \"value\": 3400879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"小米\",\n      \"value\": 2300879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"oppo\",\n      \"value\": 5400879,\n      \"type\": \"手机品牌\"\n    },\n    {\n      \"name\": \"vivo\",\n      \"value\": 3400879,\n      \"type\": \"手机品牌\"\n    }\n  ],\n  \"option\": {\n    \"grid\": {\n      \"show\": false,\n      \"bottom\": 115,\n      \"top\": 90\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"背景柱形图\",\n      \"show\": true,\n      \"textStyle\": {\n        \"fontWeight\": \"normal\"\n      }\n    },\n    \"tooltip\": {\n      \"trigger\": \"axis\",\n      \"axisPointer\": {\n        \"type\": \"shadow\",\n        \"label\": {\n          \"show\": true,\n          \"backgroundColor\": \"#333\"\n        }\n      }\n    },\n    \"yAxis\": {\n      \"splitLine\": {\n        \"interval\": 2\n      },\n      \"lineStyle\": {\n        \"color\": \"#f3f3f3\"\n      }\n    },\n    \"series\": [\n      {\n        \"data\": [],\n        \"type\": \"bar\",\n        \"barWidth\": 40,\n        \"itemStyle\": {\n          \"color\": \"#5470c6\",\n          \"borderRadius\": 0\n        },\n        \"showBackground\": true,\n        \"backgroundStyle\": {\n          \"color\": \"#eee\"\n        }\n      }\n    ]\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = '2022-06-15 14:02:45', `update_by` = 'admin', `update_time` = '2022-08-04 19:18:56' WHERE `id` = '1536952329568276481';

UPDATE `onl_drag_comp` SET `parent_id` = '100', `comp_name` = '数值', `comp_type` = 'JNumber', `icon` = 'ant-design:field-number-outlined', `order_num` = 14, `type_id` = NULL, `comp_config` = '{\r\n  \"w\": 12,\r\n  \"h\": 30,\r\n  \"dataType\": 1,\r\n  \"timeOut\": 0,\r\n  \"turnConfig\": {\r\n    \"url\": \"\"\r\n  },\r\n  \"chartData\": {\r\n    \"value\": \"1024\"\r\n  },\r\n  \"analysis\": {\r\n    \"isCompare\": false,\r\n    \"compareType\": \"\",\r\n    \"trendType\": \"1\"\r\n  },\r\n  \"option\": {\r\n    \"isCompare\": false,\r\n    \"trendType\": \"1\",\r\n    \"card\": {\r\n      \"title\": \"\",\r\n      \"extra\": \"\",\r\n      \"rightHref\": \"\",\r\n      \"size\": \"small\",\r\n      \"textStyle\": {\r\n        \"fontSize\": 18,\r\n        \"fontWeight\": \"bold\",\r\n        \"color\": \"#464646\"\r\n      }\r\n    },\r\n    \"body\": {\r\n      \"text\": \"\",\r\n      \"fontWeight\": \"bold\"\r\n    }\r\n  }\r\n}', `status` = '1', `create_by` = 'jeecg', `create_time` = '2022-09-01 15:10:03', `update_by` = 'jeecg', `update_time` = '2022-09-02 16:52:23' WHERE `id` = '725214423934730240';

UPDATE `onl_drag_comp` SET `parent_id` = '100120', `comp_name` = '散点地图', `comp_type` = 'JBubbleMap', `icon` = 'ic:outline-scatter-plot', `order_num` = 1, `type_id` = NULL, `comp_config` = '{\n  \"w\": 12,\n  \"h\": 30,\n  \"activeKey\": 1,\n  \"dataType\": 1,\n  \"background\": \"#ffffff\",\n  \"url\": \"http://api.jeecg.com/mock/33/radar\",\n  \"timeOut\": 0,\n       \"dataMapping\": [{\n        \"filed\": \"区域\",\n        \"mapping\": \"\"\n    }, {\n        \"filed\": \"数值\",\n        \"mapping\": \"\"\n    }],\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"jsConfig\": \"\",\n  \"chartData\": [\n    {\n      \"name\": \"北京\",\n      \"value\": 199\n    },\n    {\n      \"name\": \"天津\",\n      \"value\": 42\n    },\n    {\n      \"name\": \"河北\",\n      \"value\": 102\n    },\n    {\n      \"name\": \"山西\",\n      \"value\": 81\n    },\n    {\n      \"name\": \"内蒙古\",\n      \"value\": 47\n    },\n    {\n      \"name\": \"辽宁\",\n      \"value\": 67\n    },\n    {\n      \"name\": \"吉林\",\n      \"value\": 82\n    },\n    {\n      \"name\": \"黑龙江\",\n      \"value\": 123\n    },\n    {\n      \"name\": \"上海\",\n      \"value\": 24\n    },\n    {\n      \"name\": \"江苏\",\n      \"value\": 92\n    },\n    {\n      \"name\": \"浙江\",\n      \"value\": 114\n    },\n    {\n      \"name\": \"安徽\",\n      \"value\": 109\n    },\n    {\n      \"name\": \"福建\",\n      \"value\": 116\n    },\n    {\n      \"name\": \"江西\",\n      \"value\": 91\n    },\n    {\n      \"name\": \"山东\",\n      \"value\": 119\n    },\n    {\n      \"name\": \"河南\",\n      \"value\": 137\n    },\n    {\n      \"name\": \"湖北\",\n      \"value\": 116\n    },\n    {\n      \"name\": \"湖南\",\n      \"value\": 114\n    },\n    {\n      \"name\": \"重庆\",\n      \"value\": 91\n    },\n    {\n      \"name\": \"四川\",\n      \"value\": 125\n    },\n    {\n      \"name\": \"贵州\",\n      \"value\": 62\n    },\n    {\n      \"name\": \"云南\",\n      \"value\": 83\n    },\n    {\n      \"name\": \"西藏\",\n      \"value\": 9\n    },\n    {\n      \"name\": \"陕西\",\n      \"value\": 80\n    },\n    {\n      \"name\": \"甘肃\",\n      \"value\": 56\n    },\n    {\n      \"name\": \"青海\",\n      \"value\": 10\n    },\n    {\n      \"name\": \"宁夏\",\n      \"value\": 18\n    },\n    {\n      \"name\": \"新疆\",\n      \"value\": 180\n    },\n    {\n      \"name\": \"广东\",\n      \"value\": 123\n    },\n    {\n      \"name\": \"广西\",\n      \"value\": 59\n    },\n    {\n      \"name\": \"海南\",\n      \"value\": 14\n    }\n  ],\n  \"commonOption\": {\n    \"barSize\": 10,\n    \"barColor\": \"#fff176\",\n    \"barColor2\": \"#fcc02e\",\n    \"gradientColor\": false,\n    \"areaColor\": {},\n    \"inRange\": {\n      \"color\": [\n        \"#04387b\",\n        \"#467bc0\"\n      ]\n    },\n    \"breadcrumb\": {\n      \"drillDown\": false,\n      \"textColor\": \"#000000\"\n    }\n  },\n  \"option\": {\n    \"drillDown\": false,\n    \"area\": {\n      \"markerCount\": 5,\n      \"shadowBlur\": 10,\n      \"markerOpacity\": 1,\n      \"markerColor\": \"#DDE330\",\n      \"shadowColor\": \"#DDE330\",\n      \"scatterLabelShow\": false,\n      \"markerType\": \"effectScatter\",\n      \"value\": [\n        \"china\"\n      ],\n      \"name\": [\n        \"中国\"\n      ]\n    },\n    \"graphic\": [],\n    \"grid\": {\n      \"show\": false,\n      \"bottom\": 115\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"\",\n      \"left\": 10,\r\n			\"textStyle\":{\r\n			  \"fontWeight\":\"normal\"\r\n			},\n      \"show\": true\n    },\n    \"legend\": {\n      \"data\": []\n    },\n    \"visualMap\": {\n      \"show\": false,\n      \"min\": 0,\n      \"type\": \"continuous\",\n      \"max\": 200,\n      \"left\": \"5%\",\n      \"top\": \"bottom\",\n      \"calculable\": true,\n      \"seriesIndex\": [\n        1\n      ]\n    },\n    \"geo\": {\n      \"top\": 30,\n      \"label\": {\n        \"emphasis\": {\n          \"show\": false,\n          \"color\": \"#fff\"\n        }\n      },\n      \"roam\": true,\n      \"zoom\": 1,\n      \"itemStyle\": {\n        \"normal\": {\n          \"borderWidth\": 1,\n          \"areaColor\": \"\",\n          \"shadowColor\": \"#80d9f8\",\n          \"shadowOffsetX\": 0,\n          \"shadowOffsetY\": 0,\n          \"shadowBlur\": 0\n        },\n        \"emphasis\": {\n          \"areaColor\": \"#fff59c\",\n          \"borderWidth\": 0\n        }\n      }\n    }\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-08-05 10:32:09' WHERE `id` = '100120100';
UPDATE `onl_drag_comp` SET `parent_id` = '100120', `comp_name` = '飞线地图', `comp_type` = 'JFlyLineMap', `icon` = 'la:plane', `order_num` = 1, `type_id` = NULL, `comp_config` = '{\n  \"w\": 12,\n  \"h\": 50,\n  \"dataType\": 1,\n  \"background\": \"#292626\",\n  \"url\": \"http://api.jeecg.com/mock/33/radar\",\n  \"timeOut\": 0,\n      \"dataMapping\": [\n    {\n      \"filed\": \"区域\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"chartData\": [\n    {\n      \"fromName\": \"江苏\",\n      \"toName\": \"贵州\",\n      \"fromLng\": 118.8062,\n      \"fromLat\": 31.9208,\n      \"toLng\": 106.6992,\n      \"toLat\": 26.7682,\n      \"value\": 100\n    },\n    {\n      \"fromName\": \"江苏\",\n      \"toName\": \"北京\",\n      \"fromLng\": 118.8062,\n      \"fromLat\": 31.9208,\n      \"toLng\": 116.46,\n      \"toLat\": 39.92,\n      \"value\": 100\n    },\n    {\n      \"fromName\": \"新疆\",\n      \"toName\": \"北京\",\n      \"fromLng\": 87.68,\n      \"fromLat\": 43.67,\n      \"toLng\": 116.46,\n      \"toLat\": 39.92,\n      \"value\": 100\n    }\n  ],\n  \"commonOption\": {\n    \"barSize\": 10,\n    \"barColor\": \"#D6F263\",\n    \"barColor2\": \"#A3DB6B\",\n    \"gradientColor\": false,\n    \"areaColor\": {},\n    \"inRange\": {\n      \"color\": [\n        \"#04387b\",\n        \"#467bc0\"\n      ]\n    },\n    \"effect\": {\n      \"show\": true,\n      \"trailLength\": 0,\n      \"period\": 6,\n      \"symbolSize\": 15\n    },\n    \"breadcrumb\": {\n      \"drillDown\": false,\n      \"textColor\": \"#ffffff\"\n    }\n  },\n  \"option\": {\n    \"area\": {\n      \"markerCount\": 5,\n      \"shadowBlur\": 10,\n      \"markerOpacity\": 1,\n      \"markerColor\": \"#DDE330\",\n      \"shadowColor\": \"#DDE330\",\n      \"scatterLabelShow\": false,\n      \"markerType\": \"effectScatter\",\n      \"value\": [\n        \"china\"\n      ],\n      \"name\": [\n        \"中国\"\n      ]\n    },\n    \"graphic\": [],\n    \"grid\": {\n      \"show\": false,\n      \"bottom\": 115\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"\",\n      \"padding\": [\n        5,\n        0,\n        0,\n        15\n      ],\n      \"show\": true\n    },\n    \"visualMap\": {\n      \"show\": false,\n      \"min\": 0,\n      \"type\": \"continuous\",\n      \"max\": 200,\n      \"left\": \"5%\",\n      \"top\": \"bottom\",\n      \"calculable\": true,\n      \"seriesIndex\": [\n        2\n      ]\n    },\n    \"geo\": {\n      \"top\": 80,\n      \"label\": {\n        \"emphasis\": {\n          \"show\": false,\n          \"color\": \"#fff\"\n        }\n      },\n      \"roam\": true,\n      \"zoom\": 1,\n      \"itemStyle\": {\n        \"normal\": {\n          \"borderColor\": \"#5A7864\",\n          \"borderWidth\": 1,\n          \"areaColor\": \"#323c48\",\n          \"shadowColor\": \"\",\n          \"shadowOffsetX\": 0,\n          \"shadowOffsetY\": 0,\n          \"shadowBlur\": 0\n        },\n        \"emphasis\": {\n          \"areaColor\": \"#EEDD78\",\n          \"borderWidth\": 0\n        }\n      }\n    }\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-08-05 11:16:54' WHERE `id` = '100120101';
UPDATE `onl_drag_comp` SET `parent_id` = '100120', `comp_name` = '柱形地图', `comp_type` = 'JBarMap', `icon` = 'uil:graph-bar', `order_num` = 1, `type_id` = NULL, `comp_config` = '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"background\": \"#ffffff\",\n  \"url\": \"http://api.jeecg.com/mock/33/radar\",\n  \"timeOut\": 0,\n      \"dataMapping\": [\n    {\n      \"filed\": \"区域\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"chartData\": [\n    {\n      \"name\": \"北京\",\n      \"value\": 900\n    },\n    {\n      \"name\": \"山西\",\n      \"value\": 1681\n    },\n    {\n      \"name\": \"内蒙古\",\n      \"value\": 47\n    },\n    {\n      \"name\": \"辽宁\",\n      \"value\": 1667\n    },\n    {\n      \"name\": \"福建\",\n      \"value\": 516\n    },\n    {\n      \"name\": \"江西\",\n      \"value\": 591\n    },\n    {\n      \"name\": \"山东\",\n      \"value\": 419\n    },\n    {\n      \"name\": \"河南\",\n      \"value\": 137\n    },\n    {\n      \"name\": \"云南\",\n      \"value\": 983\n    },\n    {\n      \"name\": \"西藏\",\n      \"value\": 9\n    },\n    {\n      \"name\": \"陕西\",\n      \"value\": 580\n    },\n    {\n      \"name\": \"甘肃\",\n      \"value\": 556\n    },\n    {\n      \"name\": \"海南\",\n      \"value\": 14\n    }\n  ],\n  \"commonOption\": {\n    \"barSize\": 12,\n    \"barColor\": \"#D6F263\",\n    \"barColor2\": \"#A3DB6B\",\n    \"gradientColor\": false,\n    \"areaColor\": {},\n    \"inRange\": {\n      \"color\": [\n        \"#04387b\",\n        \"#467bc0\"\n      ]\n    },\n    \"breadcrumb\": {\n      \"drillDown\": false,\n      \"textColor\": \"#000000\"\n    }\n  },\n  \"option\": {\n    \"drillDown\": false,\n    \"tooltip\": {\n      \"trigger\": \"item\",\n      \"show\": false,\n      \"enterable\": true,\n      \"textStyle\": {\n        \"fontSize\": 20,\n        \"color\": \"#fff\"\n      },\n      \"backgroundColor\": \"rgba(0,2,89,0.8)\"\n    },\n    \"area\": {\n      \"markerCount\": 5,\n      \"shadowBlur\": 10,\n      \"markerOpacity\": 1,\n      \"markerColor\": \"#DDE330\",\n      \"shadowColor\": \"#DDE330\",\n      \"scatterLabelShow\": false,\n      \"markerType\": \"effectScatter\",\n      \"value\": [\n        \"china\"\n      ],\n      \"name\": [\n        \"中国\"\n      ]\n    },\n    \"graphic\": [],\n    \"grid\": {\n      \"show\": false,\n      \"bottom\": 115\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"\",\r\n			\"textStyle\":{\r\n			  \"fontWeight\":\"normal\"\r\n			},\n      \"left\": 10,\n      \"show\": true\n    },\n    \"visualMap\": {\n      \"show\": false,\n      \"max\": 200,\n      \"seriesIndex\": [\n        0\n      ]\n    },\n    \"geo\": {\n      \"top\": 30,\n      \"roam\": true,\n      \"aspectScale\": 0.96,\n      \"zoom\": 1,\n      \"itemStyle\": {\n        \"normal\": {\n          \"borderColor\": \"#a9a9a9\",\n          \"borderWidth\": 1,\n          \"areaColor\": \"#37805B\",\n          \"shadowColor\": \"#80d9f8\",\n          \"shadowOffsetX\": 0,\n          \"shadowOffsetY\": 0,\n          \"shadowBlur\": 0\n        },\r\n        \"emphasis\": {\r\n          \"areaColor\": \"#fff59c\"\r\n        }\n      }\n    },\n    \"series \": []\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-08-05 11:17:01' WHERE `id` = '100120102';
UPDATE `onl_drag_comp` SET `parent_id` = '100120', `comp_name` = '热力地图', `comp_type` = 'JHeatMap', `icon` = 'carbon:heat-map-02', `order_num` = 1, `type_id` = NULL, `comp_config` = '{\n  \"w\": 12,\n  \"h\": 30,\n  \"dataType\": 1,\n  \"background\": \"#000000\",\n  \"url\": \"http://api.jeecg.com/mock/33/radar\",\n  \"timeOut\": 0,\n      \"dataMapping\": [\n    {\n      \"filed\": \"区域\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"chartData\": [\n    {\n      \"name\": \"海门\",\n      \"value\": 100\n    },\n    {\n      \"name\": \"鄂尔多斯\",\n      \"value\": 112\n    },\n    {\n      \"name\": \"招远\",\n      \"value\": 112\n    },\n    {\n      \"name\": \"舟山\",\n      \"value\": 112\n    },\n    {\n      \"name\": \"齐齐哈尔\",\n      \"value\": 114\n    },\n    {\n      \"name\": \"盐城\",\n      \"value\": 100\n    },\n    {\n      \"name\": \"赤峰\",\n      \"value\": 16\n    },\n    {\n      \"name\": \"青岛\",\n      \"value\": 450\n    },\n    {\n      \"name\": \"乳山\",\n      \"value\": 118\n    },\n    {\n      \"name\": \"金昌\",\n      \"value\": 119\n    },\n    {\n      \"name\": \"泉州\",\n      \"value\": 21\n    },\n    {\n      \"name\": \"莱西\",\n      \"value\": 300\n    },\n    {\n      \"name\": \"日照\",\n      \"value\": 121\n    },\n    {\n      \"name\": \"胶南\",\n      \"value\": 125\n    },\n    {\n      \"name\": \"南通\",\n      \"value\": 23\n    },\n    {\n      \"name\": \"拉萨\",\n      \"value\": 321\n    },\n    {\n      \"name\": \"云浮\",\n      \"value\": 444\n    },\n    {\n      \"name\": \"梅州\",\n      \"value\": 25\n    },\n    {\n      \"name\": \"文登\",\n      \"value\": 456\n    },\n    {\n      \"name\": \"上海\",\n      \"value\": 125\n    },\n    {\n      \"name\": \"攀枝花\",\n      \"value\": 125\n    },\n    {\n      \"name\": \"威海\",\n      \"value\": 25\n    },\n    {\n      \"name\": \"承德\",\n      \"value\": 25\n    },\n    {\n      \"name\": \"厦门\",\n      \"value\": 126\n    },\n    {\n      \"name\": \"汕尾\",\n      \"value\": 26\n    },\n    {\n      \"name\": \"潮州\",\n      \"value\": 247\n    },\n    {\n      \"name\": \"丹东\",\n      \"value\": 227\n    },\n    {\n      \"name\": \"太仓\",\n      \"value\": 427\n    },\n    {\n      \"name\": \"曲靖\",\n      \"value\": 327\n    },\n    {\n      \"name\": \"烟台\",\n      \"value\": 28\n    },\n    {\n      \"name\": \"福州\",\n      \"value\": 29\n    },\n    {\n      \"name\": \"瓦房店\",\n      \"value\": 30\n    },\n    {\n      \"name\": \"即墨\",\n      \"value\": 30\n    },\n    {\n      \"name\": \"抚顺\",\n      \"value\": 31\n    },\n    {\n      \"name\": \"玉溪\",\n      \"value\": 31\n    },\n    {\n      \"name\": \"张家口\",\n      \"value\": 31\n    },\n    {\n      \"name\": \"阳泉\",\n      \"value\": 31\n    },\n    {\n      \"name\": \"莱州\",\n      \"value\": 32\n    },\n    {\n      \"name\": \"湖州\",\n      \"value\": 32\n    },\n    {\n      \"name\": \"汕头\",\n      \"value\": 32\n    },\n    {\n      \"name\": \"昆山\",\n      \"value\": 33\n    },\n    {\n      \"name\": \"宁波\",\n      \"value\": 33\n    },\n    {\n      \"name\": \"湛江\",\n      \"value\": 33\n    },\n    {\n      \"name\": \"揭阳\",\n      \"value\": 34\n    },\n    {\n      \"name\": \"荣成\",\n      \"value\": 34\n    },\n    {\n      \"name\": \"连云港\",\n      \"value\": 35\n    },\n    {\n      \"name\": \"葫芦岛\",\n      \"value\": 35\n    },\n    {\n      \"name\": \"常熟\",\n      \"value\": 236\n    },\n    {\n      \"name\": \"东莞\",\n      \"value\": 336\n    },\n    {\n      \"name\": \"河源\",\n      \"value\": 36\n    },\n    {\n      \"name\": \"淮安\",\n      \"value\": 436\n    },\n    {\n      \"name\": \"泰州\",\n      \"value\": 236\n    },\n    {\n      \"name\": \"南宁\",\n      \"value\": 437\n    },\n    {\n      \"name\": \"营口\",\n      \"value\": 37\n    },\n    {\n      \"name\": \"惠州\",\n      \"value\": 337\n    },\n    {\n      \"name\": \"江阴\",\n      \"value\": 37\n    },\n    {\n      \"name\": \"蓬莱\",\n      \"value\": 37\n    },\n    {\n      \"name\": \"韶关\",\n      \"value\": 38\n    },\n    {\n      \"name\": \"嘉峪关\",\n      \"value\": 38\n    },\n    {\n      \"name\": \"广州\",\n      \"value\": 138\n    },\n    {\n      \"name\": \"延安\",\n      \"value\": 138\n    },\n    {\n      \"name\": \"太原\",\n      \"value\": 139\n    },\n    {\n      \"name\": \"清远\",\n      \"value\": 139\n    },\n    {\n      \"name\": \"中山\",\n      \"value\": 139\n    },\n    {\n      \"name\": \"昆明\",\n      \"value\": 139\n    },\n    {\n      \"name\": \"寿光\",\n      \"value\": 440\n    },\n    {\n      \"name\": \"盘锦\",\n      \"value\": 40\n    },\n    {\n      \"name\": \"长治\",\n      \"value\": 41\n    },\n    {\n      \"name\": \"深圳\",\n      \"value\": 41\n    },\n    {\n      \"name\": \"珠海\",\n      \"value\": 42\n    },\n    {\n      \"name\": \"宿迁\",\n      \"value\": 43\n    },\n    {\n      \"name\": \"咸阳\",\n      \"value\": 43\n    },\n    {\n      \"name\": \"铜川\",\n      \"value\": 44\n    },\n    {\n      \"name\": \"平度\",\n      \"value\": 44\n    },\n    {\n      \"name\": \"佛山\",\n      \"value\": 44\n    },\n    {\n      \"name\": \"海口\",\n      \"value\": 44\n    },\n    {\n      \"name\": \"江门\",\n      \"value\": 45\n    },\n    {\n      \"name\": \"章丘\",\n      \"value\": 45\n    },\n    {\n      \"name\": \"肇庆\",\n      \"value\": 46\n    },\n    {\n      \"name\": \"大连\",\n      \"value\": 47\n    },\n    {\n      \"name\": \"临汾\",\n      \"value\": 47\n    },\n    {\n      \"name\": \"吴江\",\n      \"value\": 47\n    },\n    {\n      \"name\": \"石嘴山\",\n      \"value\": 49\n    },\n    {\n      \"name\": \"沈阳\",\n      \"value\": 50\n    },\n    {\n      \"name\": \"苏州\",\n      \"value\": 50\n    },\n    {\n      \"name\": \"茂名\",\n      \"value\": 50\n    },\n    {\n      \"name\": \"嘉兴\",\n      \"value\": 51\n    },\n    {\n      \"name\": \"长春\",\n      \"value\": 51\n    },\n    {\n      \"name\": \"胶州\",\n      \"value\": 52\n    },\n    {\n      \"name\": \"银川\",\n      \"value\": 52\n    },\n    {\n      \"name\": \"张家港\",\n      \"value\": 52\n    },\n    {\n      \"name\": \"三门峡\",\n      \"value\": 53\n    },\n    {\n      \"name\": \"锦州\",\n      \"value\": 154\n    },\n    {\n      \"name\": \"南昌\",\n      \"value\": 154\n    },\n    {\n      \"name\": \"柳州\",\n      \"value\": 154\n    },\n    {\n      \"name\": \"三亚\",\n      \"value\": 154\n    },\n    {\n      \"name\": \"自贡\",\n      \"value\": 156\n    },\n    {\n      \"name\": \"吉林\",\n      \"value\": 156\n    },\n    {\n      \"name\": \"阳江\",\n      \"value\": 257\n    },\n    {\n      \"name\": \"泸州\",\n      \"value\": 157\n    },\n    {\n      \"name\": \"西宁\",\n      \"value\": 157\n    },\n    {\n      \"name\": \"宜宾\",\n      \"value\": 258\n    },\n    {\n      \"name\": \"呼和浩特\",\n      \"value\": 58\n    },\n    {\n      \"name\": \"成都\",\n      \"value\": 58\n    },\n    {\n      \"name\": \"大同\",\n      \"value\": 58\n    },\n    {\n      \"name\": \"镇江\",\n      \"value\": 59\n    },\n    {\n      \"name\": \"桂林\",\n      \"value\": 59\n    },\n    {\n      \"name\": \"张家界\",\n      \"value\": 59\n    },\n    {\n      \"name\": \"宜兴\",\n      \"value\": 59\n    },\n    {\n      \"name\": \"北海\",\n      \"value\": 60\n    },\n    {\n      \"name\": \"西安\",\n      \"value\": 61\n    },\n    {\n      \"name\": \"金坛\",\n      \"value\": 62\n    },\n    {\n      \"name\": \"东营\",\n      \"value\": 62\n    },\n    {\n      \"name\": \"牡丹江\",\n      \"value\": 63\n    },\n    {\n      \"name\": \"遵义\",\n      \"value\": 63\n    },\n    {\n      \"name\": \"绍兴\",\n      \"value\": 63\n    },\n    {\n      \"name\": \"扬州\",\n      \"value\": 64\n    },\n    {\n      \"name\": \"常州\",\n      \"value\": 64\n    },\n    {\n      \"name\": \"潍坊\",\n      \"value\": 65\n    },\n    {\n      \"name\": \"重庆\",\n      \"value\": 66\n    },\n    {\n      \"name\": \"台州\",\n      \"value\": 67\n    },\n    {\n      \"name\": \"南京\",\n      \"value\": 67\n    },\n    {\n      \"name\": \"滨州\",\n      \"value\": 70\n    },\n    {\n      \"name\": \"贵阳\",\n      \"value\": 71\n    },\n    {\n      \"name\": \"无锡\",\n      \"value\": 71\n    },\n    {\n      \"name\": \"本溪\",\n      \"value\": 71\n    },\n    {\n      \"name\": \"克拉玛依\",\n      \"value\": 72\n    },\n    {\n      \"name\": \"渭南\",\n      \"value\": 72\n    },\n    {\n      \"name\": \"马鞍山\",\n      \"value\": 72\n    },\n    {\n      \"name\": \"宝鸡\",\n      \"value\": 72\n    },\n    {\n      \"name\": \"焦作\",\n      \"value\": 75\n    },\n    {\n      \"name\": \"句容\",\n      \"value\": 75\n    },\n    {\n      \"name\": \"北京\",\n      \"value\": 79\n    },\n    {\n      \"name\": \"徐州\",\n      \"value\": 79\n    },\n    {\n      \"name\": \"衡水\",\n      \"value\": 80\n    },\n    {\n      \"name\": \"包头\",\n      \"value\": 80\n    },\n    {\n      \"name\": \"绵阳\",\n      \"value\": 80\n    },\n    {\n      \"name\": \"乌鲁木齐\",\n      \"value\": 84\n    },\n    {\n      \"name\": \"枣庄\",\n      \"value\": 84\n    },\n    {\n      \"name\": \"杭州\",\n      \"value\": 84\n    },\n    {\n      \"name\": \"淄博\",\n      \"value\": 85\n    },\n    {\n      \"name\": \"鞍山\",\n      \"value\": 86\n    },\n    {\n      \"name\": \"溧阳\",\n      \"value\": 86\n    },\n    {\n      \"name\": \"库尔勒\",\n      \"value\": 86\n    },\n    {\n      \"name\": \"安阳\",\n      \"value\": 190\n    },\n    {\n      \"name\": \"开封\",\n      \"value\": 390\n    },\n    {\n      \"name\": \"济南\",\n      \"value\": 292\n    },\n    {\n      \"name\": \"德阳\",\n      \"value\": 393\n    },\n    {\n      \"name\": \"温州\",\n      \"value\": 95\n    },\n    {\n      \"name\": \"九江\",\n      \"value\": 96\n    },\n    {\n      \"name\": \"邯郸\",\n      \"value\": 98\n    },\n    {\n      \"name\": \"临安\",\n      \"value\": 99\n    },\n    {\n      \"name\": \"兰州\",\n      \"value\": 99\n    },\n    {\n      \"name\": \"沧州\",\n      \"value\": 100\n    },\n    {\n      \"name\": \"临沂\",\n      \"value\": 103\n    },\n    {\n      \"name\": \"南充\",\n      \"value\": 104\n    },\n    {\n      \"name\": \"天津\",\n      \"value\": 105\n    },\n    {\n      \"name\": \"富阳\",\n      \"value\": 106\n    },\n    {\n      \"name\": \"泰安\",\n      \"value\": 112\n    },\n    {\n      \"name\": \"诸暨\",\n      \"value\": 112\n    },\n    {\n      \"name\": \"郑州\",\n      \"value\": 113\n    },\n    {\n      \"name\": \"哈尔滨\",\n      \"value\": 114\n    },\n    {\n      \"name\": \"聊城\",\n      \"value\": 116\n    },\n    {\n      \"name\": \"芜湖\",\n      \"value\": 117\n    },\n    {\n      \"name\": \"唐山\",\n      \"value\": 119\n    },\n    {\n      \"name\": \"平顶山\",\n      \"value\": 119\n    },\n    {\n      \"name\": \"邢台\",\n      \"value\": 119\n    },\n    {\n      \"name\": \"德州\",\n      \"value\": 120\n    },\n    {\n      \"name\": \"济宁\",\n      \"value\": 120\n    },\n    {\n      \"name\": \"荆州\",\n      \"value\": 127\n    },\n    {\n      \"name\": \"宜昌\",\n      \"value\": 130\n    },\n    {\n      \"name\": \"义乌\",\n      \"value\": 132\n    },\n    {\n      \"name\": \"丽水\",\n      \"value\": 133\n    },\n    {\n      \"name\": \"洛阳\",\n      \"value\": 134\n    },\n    {\n      \"name\": \"秦皇岛\",\n      \"value\": 136\n    },\n    {\n      \"name\": \"株洲\",\n      \"value\": 143\n    },\n    {\n      \"name\": \"石家庄\",\n      \"value\": 147\n    },\n    {\n      \"name\": \"莱芜\",\n      \"value\": 148\n    },\n    {\n      \"name\": \"常德\",\n      \"value\": 152\n    },\n    {\n      \"name\": \"保定\",\n      \"value\": 153\n    },\n    {\n      \"name\": \"湘潭\",\n      \"value\": 154\n    },\n    {\n      \"name\": \"金华\",\n      \"value\": 157\n    },\n    {\n      \"name\": \"岳阳\",\n      \"value\": 169\n    },\n    {\n      \"name\": \"长沙\",\n      \"value\": 175\n    },\n    {\n      \"name\": \"衢州\",\n      \"value\": 177\n    },\n    {\n      \"name\": \"廊坊\",\n      \"value\": 193\n    },\n    {\n      \"name\": \"菏泽\",\n      \"value\": 194\n    },\n    {\n      \"name\": \"合肥\",\n      \"value\": 229\n    },\n    {\n      \"name\": \"武汉\",\n      \"value\": 273\n    },\n    {\n      \"name\": \"大庆\",\n      \"value\": 279\n    }\n  ],\n  \"commonOption\": {\n    \"barSize\": 10,\n    \"barColor\": \"#D6F263\",\n    \"barColor2\": \"#A3DB6B\",\n    \"gradientColor\": false,\n    \"areaColor\": {},\n    \"heat\": {\n      \"pointSize\": 15,\n      \"blurSize\": 20,\n      \"maxOpacity\": 1\n    },\n    \"inRange\": {\n      \"color\": [\n        \"#E08D8D\",\n        \"#ff9800\"\n      ]\n    },\n    \"breadcrumb\": {\n      \"drillDown\": false,\n      \"textColor\": \"#ffffff\"\n    }\n  },\n  \"option\": {\n    \"drillDown\": false,\n    \"area\": {\n      \"markerCount\": 5,\n      \"shadowBlur\": 10,\n      \"markerOpacity\": 1,\n      \"markerColor\": \"#df2425\",\n      \"shadowColor\": \"#DDE330\",\n      \"scatterLabelShow\": false,\n      \"markerType\": \"effectScatter\",\n      \"value\": [\n        \"china\"\n      ],\n      \"name\": [\n        \"中国\"\n      ]\n    },\n    \"graphic\": [],\n    \"grid\": {\n      \"show\": false,\n      \"bottom\": 115\n    },\n    \"card\": {\n      \"title\": \"\",\n      \"extra\": \"\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"title\": {\n      \"text\": \"\",\n      \"left\": 10,\r\n			\"textStyle\":{\r\n			  \"fontWeight\":\"normal\"\r\n			},\n      \"show\": true\n    },\n    \"legend\": {\n      \"data\": []\n    },\n    \"visualMap\": {\n      \"show\": true,\n      \"min\": 0,\n      \"type\": \"continuous\",\n      \"max\": 200,\n      \"left\": \"5%\",\n      \"top\": \"bottom\",\n      \"calculable\": true,\n      \"seriesIndex\": [\n        1\n      ]\n    },\n    \"geo\": {\n      \"top\": 30,\n      \"label\": {\n        \"emphasis\": {\n          \"show\": false,\n          \"color\": \"#fff\"\n        }\n      },\n      \"roam\": true,\n      \"zoom\": 1,\n      \"itemStyle\": {\n        \"normal\": {\n          \"borderColor\": \"#a9a9a9\",\n          \"borderWidth\": 1,\n          \"areaColor\": \"\",\n          \"shadowColor\": \"#80d9f8\",\n          \"shadowOffsetX\": 0,\n          \"shadowOffsetY\": 0,\n          \"shadowBlur\": 0\n        },\n        \"emphasis\": {\n          \"areaColor\": \"#fff59c\",\n          \"borderWidth\": 0\n        }\n      }\n    }\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-08-05 11:17:24' WHERE `id` = '100120106';

INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736000', '1009728983979950080', '边框1', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"1\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736002', '1009728983979950080', '边框2', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"2\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n  }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736003', '1009728983979950080', '边框3', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"3\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n  }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736004', '1009728983979950080', '边框4', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"4\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736005', '1009728983979950080', '边框5', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"5\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736006', '1009728983979950080', '边框6', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"6\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736007', '1009728983979950080', '边框7', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"7\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736008', '1009728983979950080', '边框8', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"8\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736009', '1009728983979950080', '边框9', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"9\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736010', '1009728983979950080', '边框10', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"10\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736011', '1009728983979950080', '边框11', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"11\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736012', '1009728983979950080', '边框12', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"12\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008616402292736013', '1009728983979950080', '边框13', 'JDragBorder', 'ant-design:border-outer-outlined', 100, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"13\",\n    \"title\": \"边框\",\n    \"titleWidth\": 250,\n    \"mainColor\": \"#83bff6\",\n    \"subColor\": \"#00CED1\",\n    \"backgroundColor\": \"#ffffff00\",\n    \"reverse\": false,\n    \"dur\": 3\n   }\n}', '1', 'admin', '2024-10-22 16:08:20', 'admin', '2024-10-22 16:08:36');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893610', '1009729002476830720', '装饰10', 'JDragDecoration', 'ant-design:format-painter-filled', 10, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"10\",\n    \"title\": \"边框\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893611', '1009729002476830720', '装饰11', 'JDragDecoration', 'ant-design:format-painter-filled', 11, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"11\",\n    \"title\": \"装饰\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893612', '1009729002476830720', '装饰12', 'JDragDecoration', 'ant-design:format-painter-filled', 12, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"12\",\n    \"title\": \"装饰\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893691', '1009729002476830720', '装饰1', 'JDragDecoration', 'ant-design:format-painter-filled', 1, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"1\",\n    \"title\": \"边框\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893693', '1009729002476830720', '装饰3', 'JDragDecoration', 'ant-design:format-painter-filled', 3, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"3\",\n    \"title\": \"边框\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893694', '1009729002476830720', '装饰4', 'JDragDecoration', 'ant-design:format-painter-filled', 4, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"4\",\n    \"title\": \"边框\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893695', '1009729002476830720', '装饰5', 'JDragDecoration', 'ant-design:format-painter-filled', 5, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"5\",\n    \"title\": \"装饰\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893696', '1009729002476830720', '装饰6', 'JDragDecoration', 'ant-design:format-painter-filled', 6, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"6\",\n    \"title\": \"边框\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893697', '1009729002476830720', '装饰7', 'JDragDecoration', 'ant-design:format-painter-filled', 7, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"7\",\n    \"title\": \"边框\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893698', '1009729002476830720', '装饰8', 'JDragDecoration', 'ant-design:format-painter-filled', 8, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"8\",\n    \"title\": \"边框\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');
INSERT INTO `onl_drag_comp`(`id`, `parent_id`, `comp_name`, `comp_type`, `icon`, `order_num`, `type_id`, `comp_config`, `status`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1008622512340893699', '1009729002476830720', '装饰9', 'JDragDecoration', 'ant-design:format-painter-filled', 9, NULL, '{\n  \"w\": 12,\n  \"h\": 12,\n  \"dataType\": 1,\n  \"option\": {\n    \"type\": \"9\",\n    \"title\": \"装饰\",\n    \"mainColor\": \"#00CED1\",\n    \"subColor\": \"#FAD400\",\n    \"reverse\": false,\n    \"dur\": 3,\n    \"fontSize\": 15\n  }\n}', '1', 'admin', '2024-10-22 16:32:36', 'admin', '2024-10-22 16:32:48');

-- 文件夹加排序
ALTER TABLE jimu_report_category
    ADD COLUMN sort_no int NULL COMMENT '排序' AFTER tenant_id;
update jimu_report_category set sort_no = 0 where sort_no is null;
-- 大屏加字段
ALTER TABLE `onl_drag_page` ADD COLUMN `des_json` varchar(500) NULL COMMENT '仪表盘主配置JSON' AFTER `cover_url`;
-- 定时报表导出
DROP TABLE IF EXISTS `jimu_report_export_job`;
CREATE TABLE `jimu_report_export_job`  (
                                           `id` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT '主键',
                                           `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '任务名称',
                                           `begin_time` datetime NULL DEFAULT NULL COMMENT '开始时间',
                                           `end_time` datetime NULL DEFAULT NULL COMMENT '结束时间',
                                           `exec_interval` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '执行频率',
                                           `report_conf` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '导出报表配置',
                                           `last_run_time` datetime NULL DEFAULT NULL COMMENT '最后执行时间',
                                           `receiver_email` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL COMMENT '接收通知的邮件',
                                           `file_sync_path` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NULL DEFAULT NULL COMMENT '文件同步路径',
                                           `status` int(11) NULL DEFAULT NULL COMMENT '状态(0:停止;1:启动)',
                                           `create_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '创建人',
                                           `create_time` datetime NULL DEFAULT NULL COMMENT '创建时间',
                                           `update_by` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '修改人',
                                           `update_time` datetime NULL DEFAULT NULL COMMENT '修改时间',
                                           `tenant_id` varchar(10) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '多租户标识',
                                           PRIMARY KEY (`id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8mb4 COLLATE = utf8mb4_unicode_ci COMMENT = '积木报表导出计划表' ROW_FORMAT = Dynamic;
-- 仪表盘门户组件
UPDATE `onl_drag_comp` SET  `comp_config` = '{\n  \"w\": 12,\n  \"h\": 26,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/42/nav\",\n  \"timeOut\": -1,\n  \"linkageConfig\": [],\r\n	\"dataMapping\": [\r\n    {\r\n      \"filed\": \"标题\",\r\n      \"mapping\": \"\"\r\n    },\r\n    {\r\n      \"filed\": \"图标\",\r\n      \"mapping\": \"\"\r\n    },\r\n    {\r\n      \"filed\": \"颜色\",\r\n      \"mapping\": \"\"\r\n    },\r\n    {\r\n      \"filed\": \"跳转\",\r\n      \"mapping\": \"\"\r\n    }\r\n  ],\n  \"chartData\": [\n    {\n      \"title\": \"首页\",\n      \"icon\": \"icon-jeecg-homepage\",\n      \"color\": \"#1fdaca\"\n    },\n    {\n      \"title\": \"仪表盘\",\n      \"icon\": \"icon-jeecg-shijian\",\n      \"color\": \"#bf0c2c\"\n    },\n    {\n      \"title\": \"组件\",\n      \"icon\": \"icon-jeecg-dangan\",\n      \"color\": \"#e18525\"\n    },\n    {\n      \"title\": \"系统管理\",\n      \"icon\": \"icon-jeecg-shezhi\",\n      \"color\": \"#3fb27f\"\n    },\n    {\n      \"title\": \"权限管理\",\n      \"icon\": \"icon-jeecg-yuechi\",\n      \"color\": \"#4daf1bc9\"\n    },\n    {\n      \"title\": \"图表\",\n      \"icon\": \"icon-jeecg-fujin\",\n      \"color\": \"#00d8ff\"\n    }\n  ],\n  \"option\": {\n    \"icon\": {\n      \"scriptUrl\": \"//at.alicdn.com/t/font_3237315_b3fqd960glt.js\",\n      \"fontSize\": 30\n    },\n    \"card\": {\n      \"title\": \"快捷导航\",\n      \"extra\": \"更多\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"body\": {\n      \"column\": 3,\n      \"textAlign\": \"center\",\n      \"iconAlign\": \"top\"\n    }\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-04-29 19:50:38' WHERE `id` = '100103';
UPDATE `onl_drag_comp` SET  `comp_config` = '{\n  \"w\": 12,\n  \"h\": 19,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/42/nav\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"标题\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"图标\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"总计\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"前缀\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"颜色\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"单位\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"title\": \"访问数\",\n      \"icon\": \"icon-jeecg-qianbao\",\n      \"value\": 2000,\n      \"total\": 120000,\n      \"prefix\": \"$\",\n      \"color\": \"green\",\n      \"action\": \"月\"\n    },\n    {\n      \"title\": \"成交额\",\n      \"icon\": \"icon-jeecg-youhuiquan\",\n      \"value\": 20000,\n      \"total\": 500000,\n      \"prefix\": \"$\",\n      \"color\": \"blue\",\n      \"action\": \"月\"\n    },\n    {\n      \"title\": \"下载数\",\n      \"icon\": \"icon-jeecg-tupian\",\n      \"value\": 8000,\n      \"prefix\": \"$\",\n      \"total\": 120000,\n      \"color\": \"orange\",\n      \"action\": \"周\"\n    },\n    {\n      \"title\": \"成交数\",\n      \"icon\": \"icon-jeecg-jifen\",\n      \"value\": 5000,\n      \"prefix\": \"$\",\n      \"total\": 50000,\n      \"color\": \"purple\",\n      \"action\": \"年\"\n    }\n  ],\n  \"option\": {\n    \"icon\": {\n      \"scriptUrl\": \"//at.alicdn.com/t/font_3237315_b3fqd960glt.js\",\n      \"fontSize\": 20\n    },\n    \"card\": {\n      \"title\": \"统计卡片\",\n      \"extra\": \"更多\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"body\": {\n      \"horizontal\": 8,\n      \"vertical\": 8,\n      \"span\": 6\n    }\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-05-07 18:24:23' WHERE `id` = '100104100';
UPDATE `onl_drag_comp` SET  `comp_config` = '{\n  \"w\": 24,\n  \"h\": 14,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/42/nav\",\n  \"timeOut\": 0,\n  \"turnConfig\": {\n    \"url\": \"\"\n  },\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"标题\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"图标\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"数值\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"后缀\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"颜色\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"title\": \"访问数\",\n      \"icon\": \"icon-jeecg-qianbao\",\n      \"value\": 2000,\n      \"color\": \"green\",\n      \"suffix\": \"月\"\n    },\n    {\n      \"title\": \"成交额\",\n      \"icon\": \"icon-jeecg-youhuiquan\",\n      \"value\": 20000,\n      \"color\": \"blue\",\n      \"suffix\": \"月\"\n    },\n    {\n      \"title\": \"下载数\",\n      \"icon\": \"icon-jeecg-tupian\",\n      \"value\": 8000,\n      \"color\": \"orange\",\n      \"suffix\": \"周\"\n    },\n    {\n      \"title\": \"成交数\",\n      \"icon\": \"icon-jeecg-jifen\",\n      \"value\": 5000,\n      \"color\": \"purple\",\n      \"suffix\": \"年\"\n    }\n  ],\n  \"option\": {\n    \"icon\": {\n      \"fontSize\": 50\n    },\n    \"card\": {\n      \"title\": \"卡片\",\n      \"extra\": \"更多\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"body\": {\n      \"horizontal\": 8,\n      \"vertical\": 8,\n      \"span\": 6\n    }\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-05-07 18:24:23' WHERE `id` = '100104108';
UPDATE `onl_drag_comp` SET  `comp_config` = '{\n  \"w\": 12,\n  \"h\": 33,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/42/nav\",\n  \"timeOut\": -1,\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"标题\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"图标\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"分组\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"描述\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"时间\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"颜色\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"title\": \"Github\",\n      \"icon\": \"icon-jeecg-social-github\",\n      \"color\": \"\",\n      \"desc\": \"不要等待机会，而要创造机会。\",\n      \"group\": \"开源组\",\n      \"date\": \"2021-04-01\"\n    },\n    {\n      \"title\": \"Vue\",\n      \"icon\": \"icon-jeecg-social-buysellads\",\n      \"color\": \"#3fb27f\",\n      \"desc\": \"现在的你决定将来的你。\",\n      \"group\": \"算法组\",\n      \"date\": \"2021-04-01\"\n    },\n    {\n      \"title\": \"Html5\",\n      \"icon\": \"icon-jeecg-html5\",\n      \"color\": \"#e18525\",\n      \"desc\": \"没有什么才能比努力更重要。\",\n      \"group\": \"上班摸鱼\",\n      \"date\": \"2021-04-01\"\n    },\n    {\n      \"title\": \"Angular\",\n      \"icon\": \"icon-jeecg-social-product-hunt\",\n      \"color\": \"#bf0c2c\",\n      \"desc\": \"热情和欲望可以突破一切难关。\",\n      \"group\": \"UI\",\n      \"date\": \"2021-04-01\"\n    },\n    {\n      \"title\": \"React\",\n      \"icon\": \"icon-jeecg-social-skype\",\n      \"color\": \"#00d8ff\",\n      \"desc\": \"健康的身体是实目标的基石。\",\n      \"group\": \"技术牛\",\n      \"date\": \"2021-04-01\"\n    },\n    {\n      \"title\": \"Js\",\n      \"icon\": \"icon-jeecg-social-pengyou\",\n      \"color\": \"#4daf1bc9\",\n      \"desc\": \"路是走出来的，而不是空想出来的。\",\n      \"group\": \"架构组\",\n      \"date\": \"2021-04-01\"\n    }\n  ],\n  \"option\": {\n    \"icon\": {\n      \"scriptUrl\": \"//at.alicdn.com/t/font_3237315_b3fqd960glt.js\",\n      \"fontSize\": 30\n    },\n    \"card\": {\n      \"title\": \"项目列表\",\n      \"extra\": \"更多\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"body\": {\n      \"column\": 3\n    }\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-04-29 19:52:42' WHERE `id` = '100105';
UPDATE `onl_drag_comp` SET  `comp_config` = '{\n  \"w\": 12,\n  \"h\": 19,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/42/nav\",\n  \"timeOut\": -1,\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"标题\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"图标\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"描述\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"时间\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"chartData\": [\n    {\n      \"title\": \"待办公文\",\n      \"icon\": \"icon-jeecg-yudu\",\n      \"content\": 23,\n      \"desc\": \"今日已办 3\",\n      \"date\": \"2021-04-01\"\n    },\n    {\n      \"title\": \"待办流程\",\n      \"icon\": \"icon-jeecg-shuju\",\n      \"content\": 23,\n      \"desc\": \"今日已办 3\",\n      \"date\": \"2021-04-01\"\n    },\n    {\n      \"title\": \"待办任务\",\n      \"icon\": \"icon-jeecg-tongzhi\",\n      \"content\": 23,\n      \"desc\": \"今日已办 3 今日更新 5\",\n      \"date\": \"2021-04-01\"\n    }\n  ],\n  \"option\": {\n    \"icon\": {\n      \"scriptUrl\": \"//at.alicdn.com/t/font_3237315_b3fqd960glt.js\",\n      \"fontSize\": 25\n    },\n    \"card\": {\n      \"title\": \"待办事项\",\n      \"extra\": \"更多\",\n      \"rightHref\": \"\",\n      \"size\": \"default\"\n    },\n    \"body\": {\n      \"column\": 3\n    }\n  }\n}', `status` = '1', `create_by` = NULL, `create_time` = NULL, `update_by` = 'admin', `update_time` = '2022-04-29 19:52:49' WHERE `id` = '100106';
UPDATE `onl_drag_comp` SET  `comp_config` = '{\n  \"w\": 12,\n  \"h\": 28,\n  \"dataType\": 1,\n  \"url\": \"http://api.jeecg.com/mock/42/list\",\n  \"linkageConfig\": [],\n  \"dataMapping\": [\n    {\n      \"filed\": \"名称\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"描述\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"时间\",\n      \"mapping\": \"\"\n    },\n    {\n      \"filed\": \"头像\",\n      \"mapping\": \"\"\n    }\n  ],\n  \"timeOut\": -1,\n  \"option\": {\n    \"titleFontSize\": 18\n  },\n  \"chartData\": [\n    {\n      \"name\": \"威廉\",\n      \"date\": \"刚刚\",\n      \"desc\": \"在 <a>开源组</a> 创建了项目 <a>Vue</a>\",\n      \"avatar\": \"https://jeecgdev.oss-cn-beijing.aliyuncs.com/upload/test/320222_1646724689691.jpg\"\n    },\n    {\n      \"name\": \"艾文\",\n      \"date\": \"1个小时前\",\n      \"desc\": \"关注了 <a>威廉</a>\",\n      \"avatar\": \"https://jeecgdev.oss-cn-beijing.aliyuncs.com/upload/test/320305_1646724680756.jpg\"\n    },\n    {\n      \"name\": \"克里斯\",\n      \"date\": \"1天前\",\n      \"desc\": \"发布了 <a>个人动态</a>\",\n      \"avatar\": \"https://jeecgdev.oss-cn-beijing.aliyuncs.com/upload/test/299258_1646724675255.jpg\"\n    },\n    {\n      \"name\": \"Jeecg\",\n      \"date\": \"2天前\",\n      \"desc\": \"发表文章 <a>如何编写一个Vite插件</a>\",\n      \"avatar\": \"https://jeecgdev.oss-cn-beijing.aliyuncs.com/upload/test/2.4jeecg_1621512120602.png\"\n    }\n  ]\n}', `status` = '1', `create_by` = 'jeecg', `create_time` = '2022-03-09 14:07:54', `update_by` = 'admin', `update_time` = '2022-04-29 19:52:54' WHERE `id` = '1501439614397119490';



-- ---author:lvdandan---date:20241128-----for: 大屏模版配置---
INSERT INTO `onl_drag_page` (`id`, `name`, `path`, `background_color`, `background_image`, `design_type`, `theme`, `style`, `cover_url`, `des_json`, `template`, `protection_code`, `type`, `iz_template`, `create_by`, `create_time`, `update_by`, `update_time`, `low_app_id`, `tenant_id`, `update_count`, `visits_num`, `del_flag`) VALUES ('1011871598899679232', '北京税务在线监控', '/drag/page/view/1011871598899679232', '#1E0047', 'https://jeecgdev.oss-cn-beijing.aliyuncs.com/jimureport/images/bg2_1733208420102.png', 100, 'dark', 'bigScreen', NULL, '{\"width\":1920,\"height\":1080}', '[{\"component\":\"JDragBorder\",\"w\":1918,\"x\":-1,\"h\":1077,\"i\":\"0cc22009-cfe5-492f-9e3b-8708cbdbda81\",\"y\":-1,\"orderNum\":0,\"pageCompId\":\"1023816327790907392\",\"componentName\":\"边框1\",\"key\":\"f00c04db-0349-4afe-b0fc-da6789411877\"},{\"component\":\"JDragBorder\",\"w\":524,\"x\":389,\"h\":289,\"i\":\"0a3aa2ce-dae7-4507-916c-f04ac3040fee\",\"y\":159,\"orderNum\":1072,\"pageCompId\":\"1023816327832850432\",\"componentName\":\"边框1\",\"key\":\"54891ccd-ee91-4bc0-8f55-ad19e94021bf\"},{\"component\":\"JImg\",\"w\":1911,\"x\":0,\"h\":78,\"i\":\"90667f29-8fe9-42e1-bab7-3ba1737f3743\",\"y\":-1,\"orderNum\":0,\"pageCompId\":\"1023816327853821952\",\"componentName\":\"图片\",\"key\":\"01769c78-a893-430a-9ca3-6d44da9e18ef\"},{\"component\":\"JDragBorder\",\"w\":460,\"x\":1411,\"h\":320,\"i\":\"es-drager-1731470190655-12\",\"y\":732,\"orderNum\":1072,\"pageCompId\":\"1023816327891570688\",\"componentName\":\"边框1\",\"key\":\"40744a4e-1dcf-4d3a-aa5e-d7b428f82c8d\"},{\"component\":\"JDragBorder\",\"w\":447,\"x\":932,\"h\":321,\"i\":\"es-drager-1731047088918-3\",\"y\":729,\"orderNum\":1072,\"pageCompId\":\"1023816327916736512\",\"componentName\":\"边框1\",\"key\":\"53f91224-70cc-47d7-a12d-0740556219f6\"},{\"component\":\"JDragBorder\",\"w\":453,\"x\":932,\"h\":245,\"i\":\"es-drager-1731046742304-1\",\"y\":461,\"orderNum\":1072,\"pageCompId\":\"1023816327937708032\",\"componentName\":\"边框1\",\"key\":\"372ce922-3bcd-40e6-8dad-bd7a6ed66d78\"},{\"component\":\"JDragBorder\",\"w\":454,\"x\":1415,\"h\":286,\"i\":\"64fabe6b-c6c0-47c5-babe-f365769a5a57\",\"y\":154,\"orderNum\":0,\"pageCompId\":\"1023816327971262464\",\"componentName\":\"边框1\",\"key\":\"736f181f-e855-43a1-a3d4-670aa28c4f7e\"},{\"component\":\"JDragBorder\",\"w\":521,\"x\":386,\"h\":325,\"i\":\"es-drager-1731047055106-2\",\"y\":729,\"orderNum\":1072,\"pageCompId\":\"1023816327992233984\",\"componentName\":\"边框1\",\"key\":\"91f39508-ba29-4564-965e-dec1d7c0d429\"},{\"component\":\"JBar\",\"w\":444,\"x\":-22,\"h\":414,\"i\":\"492e7aed-5126-46b6-828d-c33ac0b52eea\",\"y\":381,\"orderNum\":0,\"pageCompId\":\"1023816328042565632\",\"componentName\":\"基础柱形图\",\"key\":\"f6099efc-cb26-4831-8eee-baa389523052\"},{\"component\":\"JText\",\"w\":666,\"x\":615,\"h\":85.00000000000006,\"i\":\"85a6c956-9417-4e56-87ab-b6828d82aa42\",\"y\":6,\"orderNum\":128,\"pageCompId\":\"1023816328071925760\",\"componentName\":\"文本\",\"key\":\"47e20d30-a16a-4d58-8d2e-b8fa2aee858a\"},{\"component\":\"JText\",\"w\":137,\"x\":4,\"h\":75.99999999999997,\"i\":\"ca03940c-8e02-46c1-af5b-5d256059e4e2\",\"y\":59,\"orderNum\":0,\"pageCompId\":\"1023816328109674496\",\"componentName\":\"文本\",\"key\":\"9076cce5-c821-49e9-977b-4836f77c10f7\"},{\"component\":\"JImg\",\"w\":129.0000000000001,\"x\":201,\"h\":61.99999999999994,\"i\":\"b3f25af5-b0bc-4bbf-a11c-5a7b01174b14\",\"y\":77,\"orderNum\":0,\"pageCompId\":\"1023816328130646016\",\"componentName\":\"图片\",\"key\":\"bc89e2fa-b84a-4a2f-bceb-6dd5cf389e54\"},{\"component\":\"JText\",\"w\":145,\"x\":194,\"h\":95.00000000000006,\"i\":\"4bfdb5e1-0fcc-445d-8b96-bad7d6a5d106\",\"y\":62,\"orderNum\":0,\"pageCompId\":\"1023816328151617536\",\"componentName\":\"文本\",\"key\":\"32e785e0-9553-4245-8e39-e7226439b457\"},{\"component\":\"JImg\",\"w\":125,\"x\":461,\"h\":54.000000000000064,\"i\":\"6e4f9a66-2884-45e0-932d-ca1638e76d02\",\"y\":83.00000000000001,\"orderNum\":0,\"pageCompId\":\"1023816328185171968\",\"componentName\":\"图片\",\"key\":\"f348f7f4-3233-4d6d-ac4e-14efc9009428\"},{\"component\":\"JImg\",\"w\":152.9999999999999,\"x\":680,\"h\":58,\"i\":\"74041015-3d1e-48c2-8651-5103b5f9d51c\",\"y\":92,\"orderNum\":0,\"pageCompId\":\"1023816328214532096\",\"componentName\":\"图片\",\"key\":\"93c2a4e6-98d8-4ddc-83f0-29feaec54e43\"},{\"component\":\"JImg\",\"w\":156,\"x\":939,\"h\":57.00000000000015,\"i\":\"215a7f44-2f53-4984-9eb8-2e03c157bb6f\",\"y\":98.99999999999999,\"orderNum\":0,\"pageCompId\":\"1023816328252280832\",\"componentName\":\"图片\",\"key\":\"e171bc62-1bd8-4e96-803d-e801f959d63e\"},{\"component\":\"JImg\",\"w\":149,\"x\":1205,\"h\":52.99999999999994,\"i\":\"630e71d8-c9bf-40ff-9dd4-04420343f500\",\"y\":101,\"orderNum\":0,\"pageCompId\":\"1023816328277446656\",\"componentName\":\"图片\",\"key\":\"d1a38d8e-6329-46b5-8d55-831008e6dbfb\"},{\"component\":\"JImg\",\"w\":159.9999999999999,\"x\":1426,\"h\":50.00000000000003,\"i\":\"25c7a576-aad7-42c9-8dec-3a7dc6d79f8b\",\"y\":104.99999999999999,\"orderNum\":0,\"pageCompId\":\"1023816328311001088\",\"componentName\":\"图片\",\"key\":\"01e6cbdb-6f02-45f4-8806-c265ed7bb999\"},{\"component\":\"JImg\",\"w\":150.0000000000001,\"x\":1665,\"h\":53.99999999999997,\"i\":\"d28acb12-4bf1-434a-b583-9eacadd9836e\",\"y\":102.00000000000001,\"orderNum\":0,\"pageCompId\":\"1023816328336166912\",\"componentName\":\"图片\",\"key\":\"03673620-0948-4454-bcaa-562d5cb94a7b\"},{\"component\":\"JText\",\"w\":117,\"x\":463,\"h\":68.99999999999989,\"i\":\"c126d088-629f-4657-8473-781dde4302a3\",\"y\":76,\"orderNum\":0,\"pageCompId\":\"1023816328352944128\",\"componentName\":\"文本\",\"key\":\"cbb9a863-b00e-4a3e-8bb8-65db6149e067\"},{\"component\":\"JText\",\"w\":173,\"x\":666,\"h\":60.00000000000003,\"i\":\"09c94616-d224-4fa8-8654-c017a7a7a8e4\",\"y\":91,\"orderNum\":0,\"pageCompId\":\"1023816328394887168\",\"componentName\":\"文本\",\"key\":\"3813482a-894a-48b9-b78b-77b3d38e24bc\"},{\"component\":\"JText\",\"w\":173.00000000000006,\"x\":929,\"h\":53.99999999999983,\"i\":\"00e87ff1-5149-4ec3-853b-107dfc90c947\",\"y\":102,\"orderNum\":0,\"pageCompId\":\"1023816328411664384\",\"componentName\":\"文本\",\"key\":\"8697d9bb-c7f9-4b72-bee0-6fa68df15693\"},{\"component\":\"JText\",\"w\":147,\"x\":1206,\"h\":56.00000000000001,\"i\":\"68992daa-bcb5-4bf9-879b-aeec9b24e105\",\"y\":99,\"orderNum\":0,\"pageCompId\":\"1023816328432635904\",\"componentName\":\"文本\",\"key\":\"ea0cd3c1-065b-443b-80f0-62dd61b5e3c5\"},{\"component\":\"JText\",\"w\":146,\"x\":1435,\"h\":54.00000000000007,\"i\":\"7da253f2-da2c-4483-8f7a-9b604269fee8\",\"y\":101.00000000000003,\"orderNum\":0,\"pageCompId\":\"1023816328457801728\",\"componentName\":\"文本\",\"key\":\"82463e99-1c67-4268-83de-e663a1bfa68f\"},{\"component\":\"JText\",\"w\":164,\"x\":1657,\"h\":59.999999999999794,\"i\":\"ffefd138-865e-4857-8268-8980c0eb3433\",\"y\":98.99999999999999,\"orderNum\":0,\"pageCompId\":\"1023816328482967552\",\"componentName\":\"文本\",\"key\":\"e7fca865-757a-4a39-aa07-cf434a3daebc\"},{\"component\":\"JText\",\"w\":171,\"x\":21,\"h\":53.99999999999997,\"i\":\"7a274443-2335-41d1-8edb-93595b5fb3eb\",\"y\":156,\"orderNum\":0,\"pageCompId\":\"1023816328512327680\",\"componentName\":\"文本\",\"key\":\"c7ac5314-df57-4055-a47e-ba307d4182c2\"},{\"component\":\"JPie\",\"w\":426,\"x\":-59,\"h\":267,\"i\":\"5f2a005a-facb-492d-9221-e8d5b641dc50\",\"y\":190,\"orderNum\":0,\"pageCompId\":\"1023816328533299200\",\"componentName\":\"饼图\",\"key\":\"480bff7a-7170-4cda-8c49-ee2ec18e9edb\"},{\"component\":\"JText\",\"w\":195.00000000000014,\"x\":32.999999999999886,\"h\":50.99999999999994,\"i\":\"4399b94e-3eca-4f0d-872a-6d8a33cf3f45\",\"y\":725,\"orderNum\":0,\"pageCompId\":\"1023816328550076416\",\"componentName\":\"文本\",\"key\":\"dc81d128-94f1-4bff-8e96-bc8d4ee6b0fc\"},{\"component\":\"JBar\",\"w\":407,\"x\":3,\"h\":360,\"i\":\"e05f2635-03f9-4718-a268-ee5513bf4f78\",\"y\":764,\"orderNum\":0,\"pageCompId\":\"1023816328587825152\",\"componentName\":\"基础柱形图\",\"key\":\"02002e38-c239-498c-9376-3cb65af8e201\"},{\"component\":\"JText\",\"w\":151.00000000000003,\"x\":410,\"h\":49.000000000000014,\"i\":\"d3edb23c-86fb-4021-9aff-e50ab1fe113e\",\"y\":161.99999999999997,\"orderNum\":0,\"pageCompId\":\"1023816328608796672\",\"componentName\":\"文本\",\"key\":\"a9d8c13a-b827-40b0-953f-2fb977c1dfa8\"},{\"component\":\"JBar\",\"w\":517,\"x\":390,\"h\":267,\"i\":\"7b7a1ca9-b9de-4a27-9d76-4e85f324edb3\",\"y\":158,\"orderNum\":0,\"pageCompId\":\"1023816328629768192\",\"componentName\":\"基础柱形图\",\"key\":\"e8c6130a-e499-4287-943f-f29ec145dcc8\"},{\"component\":\"JBar\",\"w\":434.00000000000006,\"x\":388,\"h\":246.99999999999994,\"i\":\"dc011315-c8cb-460e-8958-f89ec118789d\",\"y\":465,\"orderNum\":0,\"pageCompId\":\"1023816328667516928\",\"componentName\":\"基础柱形图\",\"key\":\"fd8d79e7-f546-4633-86e8-805de5866eb5\"},{\"component\":\"JText\",\"w\":203.99999999999983,\"x\":397.0000000000001,\"h\":59.99999999999996,\"i\":\"4f9d7602-3fb7-4f57-81f0-1c9c06f71109\",\"y\":450,\"orderNum\":0,\"pageCompId\":\"1023816328684294144\",\"componentName\":\"文本\",\"key\":\"20d2dbe0-a66b-456d-880a-f0558b563704\"},{\"component\":\"JText\",\"w\":145.9999999999999,\"x\":385,\"h\":72.99999999999997,\"i\":\"b084b430-2d26-4952-90c5-dd3778d98df6\",\"y\":711,\"orderNum\":0,\"pageCompId\":\"1023816328701071360\",\"componentName\":\"文本\",\"key\":\"5a67aed1-f3b2-45d7-8c3c-dbe521a3fd1e\"},{\"component\":\"JImg\",\"w\":44,\"x\":429,\"h\":42,\"i\":\"6b66ae21-a187-42e8-8de8-c43933e3baa5\",\"y\":797,\"orderNum\":0,\"pageCompId\":\"1023816328738820096\",\"componentName\":\"图片\",\"key\":\"db0c5c3a-a04b-4e71-8c52-1fbe2d548007\"},{\"component\":\"JImg\",\"w\":45.999999999999986,\"x\":426,\"h\":44.00000000000005,\"i\":\"d2c60790-219a-4c37-b82b-d625aba9ad95\",\"y\":875,\"orderNum\":0,\"pageCompId\":\"1023816328755597312\",\"componentName\":\"图片\",\"key\":\"64c8cf8b-ffba-429f-a78e-84bbd83a6494\"},{\"component\":\"JImg\",\"w\":37,\"x\":432,\"h\":35,\"i\":\"4ac90ff9-722a-4836-8056-681329419d0a\",\"y\":949,\"orderNum\":0,\"pageCompId\":\"1023816328768180224\",\"componentName\":\"图片\",\"key\":\"3d5b4124-523a-4843-8bf5-a7fca530a156\"},{\"component\":\"JText\",\"w\":133,\"x\":479,\"h\":50,\"i\":\"7e2ab80b-2abe-4a5b-ab57-3821d8e954ea\",\"y\":786,\"orderNum\":0,\"pageCompId\":\"1023816328801734656\",\"componentName\":\"文本\",\"key\":\"cd7c368d-9c78-4299-abf3-3d45aa962d10\"},{\"component\":\"JLine\",\"w\":425,\"x\":933,\"h\":204,\"i\":\"5add5568-a651-4150-802d-8e13fab4be54\",\"y\":210,\"orderNum\":0,\"pageCompId\":\"1023816328818511872\",\"componentName\":\"基础折线图\",\"key\":\"3737d2ec-7355-4678-8b15-23de79634383\"},{\"component\":\"JLiquid\",\"w\":209,\"x\":1432,\"h\":126,\"i\":\"1d2da469-9128-4339-8ffb-2f665b9c760c\",\"y\":203,\"orderNum\":0,\"pageCompId\":\"1023816328835289088\",\"componentName\":\"水波图\",\"key\":\"739835a3-0af5-48be-823a-f2aad83e3ec3\"},{\"component\":\"JRose\",\"w\":397,\"x\":948,\"h\":206,\"i\":\"f81fe9db-cf49-4461-8e8c-dcc43b3a9128\",\"y\":490,\"orderNum\":0,\"pageCompId\":\"1023816328864649216\",\"componentName\":\"南丁格尔玫瑰图\",\"key\":\"2d22b9d9-04e0-4d1c-8760-01a89ab517db\"},{\"component\":\"JLine\",\"w\":425,\"x\":943,\"h\":241,\"i\":\"c161f938-81ce-4033-8492-9203ddbfba85\",\"y\":797,\"orderNum\":0,\"pageCompId\":\"1023816328885620736\",\"componentName\":\"基础折线图\",\"key\":\"93ace0f6-c47f-4143-8a3d-3ecbd53e1947\"},{\"component\":\"JText\",\"w\":252,\"x\":919,\"h\":42,\"i\":\"b5644afc-7551-4690-98d7-a3b67ae76ab8\",\"y\":729,\"orderNum\":0,\"pageCompId\":\"1023816328906592256\",\"componentName\":\"文本\",\"key\":\"ebf198ba-0973-4223-8b2f-a8f14deab29e\"},{\"component\":\"JDragBorder\",\"w\":365,\"x\":14,\"h\":334,\"i\":\"b2390199-e9b6-4036-8032-c3657c90312f\",\"y\":728,\"orderNum\":1072,\"pageCompId\":\"1023816328935952384\",\"componentName\":\"边框1\",\"key\":\"b9612da1-0a05-48e5-bfa7-8287ee17bbf2\"},{\"component\":\"JDragBorder\",\"w\":370,\"x\":6,\"h\":551,\"i\":\"a6f4742b-49f3-4760-9243-ee7691f68c00\",\"y\":154,\"orderNum\":1072,\"pageCompId\":\"1023816328956923904\",\"componentName\":\"边框1\",\"key\":\"ade24c76-ac58-4b06-826a-7bc81324a1f8\"},{\"component\":\"JDragBorder\",\"w\":526,\"x\":388,\"h\":248,\"i\":\"7be4dcb2-744b-4f1a-9b83-6f586a730002\",\"y\":460,\"orderNum\":1072,\"pageCompId\":\"1023816328969506816\",\"componentName\":\"边框1\",\"key\":\"e6698dec-2d96-433c-809a-65a030e566b1\"},{\"component\":\"JDragBorder\",\"w\":449,\"x\":930,\"h\":277,\"i\":\"e692a49f-8747-4df5-9e31-b35cb080d875\",\"y\":160,\"orderNum\":0,\"pageCompId\":\"1023816328986284032\",\"componentName\":\"边框1\",\"key\":\"c87222c9-2274-4bc0-89b0-e21ecfcef07b\"},{\"component\":\"JLiquid\",\"w\":181.00000000000006,\"x\":1642,\"h\":136.99999999999997,\"i\":\"f7de9b5c-c4e8-41f1-9197-f7efc7a7126d\",\"y\":194,\"orderNum\":0,\"pageCompId\":\"1023816329019838464\",\"componentName\":\"水波图\",\"key\":\"65c8e18b-b906-45e7-b167-ba6ff88cf8c9\"},{\"component\":\"JText\",\"w\":194,\"x\":933,\"h\":31.0000000000001,\"i\":\"b3659810-6e9c-47ac-ba63-8e78044a2c63\",\"y\":167,\"orderNum\":0,\"pageCompId\":\"1023816329036615680\",\"componentName\":\"文本\",\"key\":\"e845dc37-a9af-4153-8a66-bf7204f8d3a1\"},{\"component\":\"JText\",\"w\":159,\"x\":1417,\"h\":52.00000000000011,\"i\":\"aaa6cdac-bcfc-40f3-8c0c-2605417665da\",\"y\":157,\"orderNum\":0,\"pageCompId\":\"1023816329057587200\",\"componentName\":\"文本\",\"key\":\"b258bd40-8c44-4cee-9bd3-483a7b71f15d\"},{\"component\":\"JText\",\"w\":133,\"x\":1479,\"h\":31.999999999999886,\"i\":\"3a0e298c-ee1b-49cf-82b3-9066d30920a0\",\"y\":360,\"orderNum\":0,\"pageCompId\":\"1023816329095335936\",\"componentName\":\"文本\",\"key\":\"99a13c51-11d4-4653-a3df-f901809aa8b3\"},{\"component\":\"JText\",\"w\":125.00000000000003,\"x\":1476,\"h\":43.00000000000007,\"i\":\"51138ed7-27f5-4b2f-bb91-92581db74f2a\",\"y\":320,\"orderNum\":300,\"pageCompId\":\"1023816329112113152\",\"componentName\":\"文本\",\"key\":\"7eedfdb5-7a0d-4188-8990-dcc6fba4ac91\"},{\"component\":\"JText\",\"w\":112.99999999999983,\"x\":1681,\"h\":75.00000000000009,\"i\":\"38e5ef36-5efc-4b1a-8c98-9707729f25b6\",\"y\":311,\"orderNum\":0,\"pageCompId\":\"1023816329149861888\",\"componentName\":\"文本\",\"key\":\"a3d81f8d-7a50-49da-979f-3644a9319ff1\"},{\"component\":\"JText\",\"w\":103.00000000000003,\"x\":1495,\"h\":58.99999999999993,\"i\":\"51933693-1a23-43a7-8d3d-9a117555a080\",\"y\":378,\"orderNum\":0,\"pageCompId\":\"1023816329166639104\",\"componentName\":\"文本\",\"key\":\"ce8e4be4-fa4b-4b4f-b62a-4c2ebf8cf912\"},{\"component\":\"JText\",\"w\":101,\"x\":1686,\"h\":55.999999999999915,\"i\":\"2c7c13a4-d842-4aeb-80e0-322baf38fcd4\",\"y\":349,\"orderNum\":0,\"angle\":0,\"pageCompId\":\"1023816329187610624\",\"componentName\":\"文本\",\"key\":\"cbd63feb-ac7a-44e5-8cd2-f876266ccde9\"},{\"component\":\"JText\",\"w\":187,\"x\":941,\"h\":44.99999999999998,\"i\":\"b46eb115-30ae-4109-9d3b-c9ebee84d462\",\"y\":456,\"orderNum\":0,\"pageCompId\":\"1023816329221165056\",\"componentName\":\"文本\",\"key\":\"5e32cb8d-3c0e-4ef0-bf35-21c5b22323f0\"},{\"component\":\"JText\",\"w\":117.00000000000001,\"x\":1417,\"h\":48.999999999999886,\"i\":\"086c850d-6552-4d12-8f7b-2a356e319fd5\",\"y\":460,\"orderNum\":0,\"pageCompId\":\"1023816329246330880\",\"componentName\":\"文本\",\"key\":\"a0c2319e-820f-4917-9183-c618e2191afb\"},{\"component\":\"JText\",\"w\":231.9999999999999,\"x\":1416,\"h\":36.00000000000006,\"i\":\"f2632fa7-5cd6-4508-bc8e-bed46dc4796b\",\"y\":734,\"orderNum\":0,\"pageCompId\":\"1023816329263108096\",\"componentName\":\"文本\",\"key\":\"537922e2-250e-4fc6-a285-6c9616408d12\"},{\"component\":\"JText\",\"w\":133,\"x\":588,\"h\":50,\"i\":\"es-drager-1731468997745-1\",\"y\":786,\"orderNum\":0,\"pageCompId\":\"1023816329292468224\",\"componentName\":\"文本\",\"key\":\"42d7fe19-dba1-49ce-977a-0a7f4c734d4d\"},{\"component\":\"JText\",\"w\":133,\"x\":689,\"h\":50,\"i\":\"es-drager-1731469045324-2\",\"y\":788,\"orderNum\":0,\"pageCompId\":\"1023816329309245440\",\"componentName\":\"文本\",\"key\":\"137deb59-8229-4443-a6db-1a32d3314f28\"},{\"component\":\"JText\",\"w\":156,\"x\":487,\"h\":50,\"i\":\"es-drager-1731469067745-3\",\"y\":816,\"orderNum\":0,\"pageCompId\":\"1023816329330216960\",\"componentName\":\"文本\",\"key\":\"6172c7db-0958-4695-8959-5383b8c7a813\"},{\"component\":\"JText\",\"w\":133,\"x\":475,\"h\":50,\"i\":\"es-drager-1731469093837-4\",\"y\":873,\"orderNum\":0,\"pageCompId\":\"1023816329363771392\",\"componentName\":\"文本\",\"key\":\"508cdaa6-76d8-4528-aa40-490ad090b798\"},{\"component\":\"JText\",\"w\":133,\"x\":593,\"h\":50,\"i\":\"es-drager-1731469107919-5\",\"y\":874,\"orderNum\":0,\"pageCompId\":\"1023816329376354304\",\"componentName\":\"文本\",\"key\":\"10e5279b-44d1-4ef4-8cd9-0471159b640d\"},{\"component\":\"JText\",\"w\":133,\"x\":473,\"h\":50,\"i\":\"es-drager-1731469125505-6\",\"y\":939,\"orderNum\":0,\"pageCompId\":\"1023816329397325824\",\"componentName\":\"文本\",\"key\":\"683165dd-c105-4cec-98eb-54e6d4770dbd\"},{\"component\":\"JDragBorder\",\"w\":459,\"x\":1409,\"h\":258,\"i\":\"es-drager-1731469576838-7\",\"y\":458,\"orderNum\":1072,\"pageCompId\":\"1023816329430880256\",\"componentName\":\"边框1\",\"key\":\"a4d4e644-4965-4aec-868f-8c53448ce113\"},{\"visible\":true,\"h\":216,\"i\":\"d8b90d85-f8b8-47c8-88bd-e498323150d8\",\"orderNum\":77,\"compTextName\":\"\",\"component\":\"JMultipleBar\",\"w\":422,\"x\":1423,\"y\":501,\"pageCompId\":\"1023816329451851776\",\"componentName\":\"对比柱形图\",\"key\":\"7d7a295f-e411-4d1e-8536-69699c32a7ce\"},{\"visible\":true,\"h\":159,\"i\":\"5f653b62-2148-406b-8d29-f6fe1a2e313a\",\"orderNum\":77,\"compTextName\":\"\",\"component\":\"JLiquid\",\"w\":239,\"x\":1411,\"y\":814,\"pageCompId\":\"1023816329468628992\",\"componentName\":\"水波图\",\"key\":\"47ca34b1-801c-41e2-84da-1fb9b2b846c5\"},{\"component\":\"JText\",\"w\":133,\"x\":1459,\"h\":50,\"i\":\"es-drager-1731469849535-8\",\"y\":964,\"orderNum\":0,\"pageCompId\":\"1023816329497989120\",\"componentName\":\"文本\",\"key\":\"58bfe70f-7c07-498d-815b-7b84b339b548\"},{\"visible\":true,\"h\":159,\"i\":\"es-drager-1731469860843-9\",\"orderNum\":77,\"compTextName\":\"\",\"component\":\"JLiquid\",\"w\":239,\"x\":1625,\"y\":810,\"pageCompId\":\"1023816329514766336\",\"componentName\":\"水波图\",\"key\":\"af4592a7-893a-4ac6-a8ad-f5858f5ce642\"},{\"component\":\"JText\",\"w\":133,\"x\":1682,\"h\":50,\"i\":\"es-drager-1731469871395-11\",\"y\":963,\"orderNum\":0,\"pageCompId\":\"1023816329539932160\",\"componentName\":\"文本\",\"key\":\"f073c7b6-f877-40c4-8360-02db29823dcb\"},{\"component\":\"JImg\",\"visible\":true,\"w\":372,\"x\":4,\"h\":563,\"i\":\"664afc6d-de2e-4ea3-add4-6a4775aecdb6\",\"y\":147,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329569292288\",\"key\":\"e426e43f-b306-4f10-b035-7750f520bd2f\"},{\"component\":\"JImg\",\"visible\":true,\"w\":370,\"x\":9,\"h\":342,\"i\":\"es-drager-1732616244282-1\",\"y\":722,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329594458112\",\"key\":\"458e2e3c-3736-4c8b-8b67-425facc62e01\"},{\"component\":\"JImg\",\"visible\":true,\"w\":530,\"x\":386,\"h\":246,\"i\":\"es-drager-1732616354696-2\",\"y\":459,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329615429632\",\"key\":\"7f23d65d-ed7f-4b03-97a4-5f0afcd1bc4c\"},{\"component\":\"JImg\",\"visible\":true,\"w\":529,\"x\":388,\"h\":289,\"i\":\"es-drager-1732616405643-3\",\"y\":157,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329640595456\",\"key\":\"c984532e-0bfa-4599-8c75-9bfcaae81138\"},{\"component\":\"JImg\",\"visible\":true,\"w\":525,\"x\":384,\"h\":330,\"i\":\"es-drager-1732616467619-4\",\"y\":724,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329665761280\",\"key\":\"73f250d3-e0e1-4e06-ad49-d93e9c802c05\"},{\"component\":\"JImg\",\"visible\":true,\"w\":456,\"x\":925,\"h\":284,\"i\":\"es-drager-1732616496825-5\",\"y\":155,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329682538496\",\"key\":\"a6e2b4fe-5795-4755-85f6-c4a6c5eff951\"},{\"component\":\"JImg\",\"visible\":true,\"w\":459,\"x\":928,\"h\":247,\"i\":\"es-drager-1732616524093-6\",\"y\":457,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329711898624\",\"key\":\"1924130e-9b87-4549-a316-2ac1fc858713\"},{\"component\":\"JImg\",\"visible\":true,\"w\":450,\"x\":930,\"h\":330,\"i\":\"es-drager-1732616572285-7\",\"y\":724,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329732870144\",\"key\":\"b321eb44-73a3-48e3-9560-37d2a279b018\"},{\"component\":\"JImg\",\"visible\":true,\"w\":457,\"x\":1414,\"h\":285,\"i\":\"es-drager-1732616606027-8\",\"y\":152,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329758035968\",\"key\":\"c9c3913f-b2ea-46ca-84df-8190b09f1707\"},{\"component\":\"JImg\",\"visible\":true,\"w\":462,\"x\":1405,\"h\":262,\"i\":\"es-drager-1732616641566-9\",\"y\":454,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329783201792\",\"key\":\"ae158e97-49b6-4e08-8d05-34ff82e43ddc\"},{\"component\":\"JImg\",\"visible\":true,\"w\":464,\"x\":1410,\"h\":323,\"i\":\"es-drager-1732616671162-10\",\"y\":729,\"orderNum\":1076,\"componentName\":\"图片\",\"pageCompId\":\"1023816329799979008\",\"key\":\"cb74b720-4a75-46bd-883c-ddb194c1f370\"}]', '', '2011441918119228928', '1', 'admin', '2024-10-31 15:43:19', 'admin', '2024-12-03 14:47:25', NULL, 3, 2, 70, 0);
INSERT INTO `onl_drag_page` (`id`, `name`, `path`, `background_color`, `background_image`, `design_type`, `theme`, `style`, `cover_url`, `des_json`, `template`, `protection_code`, `type`, `iz_template`, `create_by`, `create_time`, `update_by`, `update_time`, `low_app_id`, `tenant_id`, `update_count`, `visits_num`, `del_flag`) VALUES ('1011800681234354176', '医院实时数据监控', '/drag/page/view/1011800681234354176', '#1E0047', 'https://jeecgdev.oss-cn-beijing.aliyuncs.com/jimureport/images/医院大屏_1733208287062.png', 100, 'dark', 'bigScreen', NULL, '{\"width\":1920,\"height\":1080}', '[{\"component\":\"JText\",\"w\":119,\"x\":53,\"h\":92.00000000000006,\"i\":\"ab90426f-3d27-4321-98ab-6fa901c590a7\",\"y\":165,\"orderNum\":0,\"pageCompId\":\"1023815689401061376\",\"componentName\":\"文本\",\"key\":\"db8981ac-9e5b-464c-a184-793178df46f6\"},{\"component\":\"JText\",\"w\":161,\"x\":254,\"h\":121.99999999999991,\"i\":\"d0c51e1d-ebd7-482f-8df4-ecc556b21050\",\"y\":151,\"orderNum\":0,\"pageCompId\":\"1023815689434615808\",\"componentName\":\"文本\",\"key\":\"a9c1e4e0-3647-4f4c-89b0-920a728eceff\"},{\"component\":\"JText\",\"w\":171.99999999999983,\"x\":871,\"h\":89.00000000000011,\"i\":\"2bc4359f-2033-43a9-ad56-eaac0952f845\",\"y\":173,\"orderNum\":0,\"pageCompId\":\"1023815689451393024\",\"componentName\":\"文本\",\"key\":\"0c1082d3-8762-41f5-a44b-90f2cb3438d2\"},{\"component\":\"JText\",\"w\":186,\"x\":528,\"h\":96.00000000000011,\"i\":\"6f873e82-c961-46e0-8dc2-38f0f4e04eb1\",\"y\":169,\"orderNum\":0,\"pageCompId\":\"1023815689459781632\",\"componentName\":\"文本\",\"key\":\"4e908f5d-a9e0-4916-8a0c-145295ea4ccb\"},{\"component\":\"JText\",\"w\":210.99999999999994,\"x\":1188,\"h\":96.99999999999999,\"i\":\"1493c911-276d-4eaa-8dbe-f03c15b0de37\",\"y\":177,\"orderNum\":0,\"pageCompId\":\"1023815689468170240\",\"componentName\":\"文本\",\"key\":\"085a93eb-7833-4180-8734-0c4363b3083d\"},{\"component\":\"JText\",\"w\":94.99999999999989,\"x\":488,\"h\":44.999999999999886,\"i\":\"6f889970-99fb-498a-8fe0-297ac57eda2e\",\"y\":295,\"orderNum\":0,\"pageCompId\":\"1023815689476558848\",\"componentName\":\"文本\",\"key\":\"9ef95676-a1bb-45bc-8f0d-6441b261b98e\"},{\"component\":\"JText\",\"w\":84,\"x\":826,\"h\":31,\"i\":\"23ea496a-d7a5-4831-a685-d4c7c2adae08\",\"y\":300,\"orderNum\":0,\"pageCompId\":\"1023815689484947456\",\"componentName\":\"文本\",\"key\":\"fb1302ca-ce44-4e3c-817a-588064bf10a6\"},{\"component\":\"JText\",\"w\":77,\"x\":591,\"h\":40.99999999999987,\"i\":\"9a8177f4-f3d6-4727-80f2-893f9cbba466\",\"y\":299,\"orderNum\":300,\"pageCompId\":\"1023815689501724672\",\"componentName\":\"文本\",\"key\":\"1fc1308d-f00c-49dd-83fd-202e1ab622ad\"},{\"component\":\"JText\",\"w\":96,\"x\":671,\"h\":41.99999999999983,\"i\":\"54e8548b-7e1c-4e6d-961d-8dfe2d482e8d\",\"y\":300,\"orderNum\":300,\"pageCompId\":\"1023815689514307584\",\"componentName\":\"文本\",\"key\":\"f8f8b3c1-ced3-4da2-b9b6-1da3ea95599a\"},{\"component\":\"JText\",\"w\":100,\"x\":907,\"h\":37.99999999999994,\"i\":\"40da445c-ceda-481f-81a0-cf5708b4c017\",\"y\":300,\"orderNum\":0,\"pageCompId\":\"1023815689522696192\",\"componentName\":\"文本\",\"key\":\"ee593903-f28a-4679-aa7a-84da7bce394d\"},{\"component\":\"JText\",\"w\":100,\"x\":1008,\"h\":33,\"i\":\"c7992cee-df3b-4fc7-b6cc-8b52e7b2ec9c\",\"y\":300,\"orderNum\":0,\"pageCompId\":\"1023815689531084800\",\"componentName\":\"文本\",\"key\":\"fdd0f02a-555c-4633-8c80-0e71290e0ae7\"},{\"component\":\"JText\",\"w\":82,\"x\":1160,\"h\":39.00000000000006,\"i\":\"937d7716-e61f-4631-8bcb-973f651b63f5\",\"y\":300,\"orderNum\":0,\"pageCompId\":\"1023815689543667712\",\"componentName\":\"文本\",\"key\":\"e6c0c471-ef79-4d59-8819-422e420ae8f5\"},{\"component\":\"JText\",\"w\":59.000000000000114,\"x\":1268,\"h\":45.99999999999993,\"i\":\"eedf5469-0915-4d50-8e71-a172d6db3745\",\"y\":299,\"orderNum\":300,\"pageCompId\":\"1023815689552056320\",\"componentName\":\"文本\",\"key\":\"5b197f2a-63f9-4a7c-8483-0e23eb55a688\"},{\"component\":\"JText\",\"w\":79.99999999999989,\"x\":1354,\"h\":44.000000000000014,\"i\":\"539ed1da-ad37-45ae-8226-97beedb3b375\",\"y\":300,\"orderNum\":600,\"pageCompId\":\"1023815689560444928\",\"componentName\":\"文本\",\"key\":\"a895372a-5dc4-41bb-aeec-e08a1e257005\"},{\"component\":\"JText\",\"w\":85,\"x\":1543,\"h\":53,\"i\":\"f04165b9-f514-4179-8e6b-7e67a5d6daa5\",\"y\":207,\"orderNum\":0,\"pageCompId\":\"1023815689577222144\",\"componentName\":\"文本\",\"key\":\"743e46b9-df9b-41cc-b63b-71f3e0cd10f9\"},{\"component\":\"JText\",\"w\":78,\"x\":1808,\"h\":49.99999999999982,\"i\":\"df422e72-7ce7-4ef5-bdd3-97a259cb89a4\",\"y\":206,\"orderNum\":300,\"pageCompId\":\"1023815689589805056\",\"componentName\":\"文本\",\"key\":\"5d6087bd-cbe5-4d3d-8ee8-76367aba23bd\"},{\"component\":\"JPie\",\"w\":314,\"x\":65,\"h\":243.99999999999994,\"i\":\"6e13ccec-1d9c-49a8-8413-f57685b077f2\",\"y\":267,\"orderNum\":0,\"pageCompId\":\"1023815689598193664\",\"componentName\":\"饼图\",\"key\":\"4a5a4539-278f-48c3-819f-06a82ba8d3af\"},{\"component\":\"JMultipleLine\",\"w\":517,\"x\":486,\"h\":332,\"i\":\"b4749e4f-2319-4ceb-9a03-826cac8c805f\",\"y\":364,\"orderNum\":0,\"pageCompId\":\"1023815689606582272\",\"componentName\":\"对比折线图\",\"key\":\"c880dda6-05a4-41bc-8b60-e97ebf96db8b\"},{\"component\":\"JBar\",\"w\":754,\"x\":406,\"h\":392,\"i\":\"c2682077-7f2a-40e2-92ac-9ee50e8183f6\",\"y\":757,\"orderNum\":0,\"pageCompId\":\"1023815689619165184\",\"componentName\":\"基础柱形图\",\"key\":\"3b98fac0-1163-4894-8c0f-a5960bc5bc03\"},{\"component\":\"JRose\",\"w\":400,\"x\":1034,\"h\":222.99999999999994,\"i\":\"847f44b6-33d1-495d-8240-e28f132ae6e0\",\"y\":840,\"orderNum\":0,\"pageCompId\":\"1023815689627553792\",\"componentName\":\"南丁格尔玫瑰图\",\"key\":\"87e6c042-8fb2-4dca-b904-93fc32b8a9bb\"},{\"component\":\"JMultipleLine\",\"w\":566,\"x\":478,\"h\":313.00000000000006,\"i\":\"6a6ba5f6-32ef-486c-8280-720a57e5b482\",\"y\":550,\"orderNum\":0,\"pageCompId\":\"1023815689644331008\",\"componentName\":\"对比折线图\",\"key\":\"a20281a8-8ab0-4325-9030-30577e05483a\"},{\"component\":\"JDynamicBar\",\"w\":221,\"x\":982,\"h\":510,\"i\":\"44c310d1-5bfc-4bc6-9713-b3c95e7b07cf\",\"y\":317,\"orderNum\":0,\"pageCompId\":\"1023815689656913920\",\"componentName\":\"动态柱形图\",\"key\":\"ce2f34bf-d6bf-443d-8c0d-fc215f5977df\"},{\"component\":\"JDynamicBar\",\"w\":228.00000000000003,\"x\":1230,\"h\":424,\"i\":\"3ed7b3d0-b620-4612-a3ef-397063203669\",\"y\":341,\"orderNum\":0,\"pageCompId\":\"1023815689665302528\",\"componentName\":\"动态柱形图\",\"key\":\"78979e31-7e17-4967-88b5-66391930b627\"},{\"component\":\"JRose\",\"w\":221,\"x\":1485,\"h\":180,\"i\":\"ebaa226d-75b4-4416-8fd6-2288e24a1735\",\"y\":251,\"orderNum\":0,\"pageCompId\":\"1023815689677885440\",\"componentName\":\"南丁格尔玫瑰图\",\"key\":\"a6adb5a2-a7c9-41c1-8bc0-26d4db8eb0cb\"},{\"component\":\"JRose\",\"w\":215,\"x\":1662,\"h\":264.0000000000001,\"i\":\"e87986e7-b5ae-4fbd-ac9d-d791e75441eb\",\"y\":200,\"orderNum\":0,\"pageCompId\":\"1023815689686274048\",\"componentName\":\"南丁格尔玫瑰图\",\"key\":\"eef35e45-d1d0-4d64-9fa7-f79cf9495ecd\"},{\"component\":\"JBar\",\"w\":471.00000000000006,\"x\":1409,\"h\":387.00000000000006,\"i\":\"714c0b6f-b0fc-45e0-b0f8-9585076a8895\",\"y\":365,\"orderNum\":0,\"pageCompId\":\"1023815689694662656\",\"componentName\":\"基础柱形图\",\"key\":\"30b44812-618e-4ecc-bccc-9fd5b9218285\"},{\"component\":\"JPie\",\"w\":328,\"x\":1497,\"h\":300,\"i\":\"daa3d01f-ef70-43f4-a6cd-f4ff92537ce3\",\"y\":601,\"orderNum\":0,\"pageCompId\":\"1023815689707245568\",\"componentName\":\"饼图\",\"key\":\"7bb6691d-2fc3-403e-9c5d-d1b3733ba7e9\"},{\"component\":\"JBar\",\"w\":269.9999999999999,\"x\":1450,\"h\":297,\"i\":\"2880db1f-a5a1-492e-8d78-975c958cea96\",\"y\":825,\"orderNum\":0,\"pageCompId\":\"1023815689719828480\",\"componentName\":\"基础柱形图\",\"key\":\"5df76f0a-159f-41b4-80fb-375e2898cdc6\"},{\"component\":\"JScatter\",\"w\":212,\"x\":1688,\"h\":269,\"i\":\"534ae97f-fc40-497d-8ecb-854af3664b1c\",\"y\":846,\"orderNum\":0,\"pageCompId\":\"1023815689732411392\",\"componentName\":\"普通散点图\",\"key\":\"f3680c48-713e-499f-8904-cdf459f5b561\"},{\"component\":\"JScrollBoard\",\"visible\":true,\"w\":417,\"x\":23,\"h\":214,\"i\":\"20384464-b32d-4dad-8660-76370062042a\",\"y\":568,\"orderNum\":0,\"componentName\":\"轮播表\",\"pageCompId\":\"1023815689744994304\"},{\"component\":\"JScrollBoard\",\"visible\":true,\"w\":417,\"x\":23,\"h\":214,\"i\":\"es-drager-1732187641762-1\",\"y\":840,\"orderNum\":0,\"componentName\":\"轮播表\",\"pageCompId\":\"1023815689757577216\"}]', '', '2011441918119228928', '1', 'admin', '2024-10-31 11:01:31', 'admin', '2024-12-03 14:44:52', NULL, 3, 2, 0, 0);
INSERT INTO `onl_drag_page` (`id`, `name`, `path`, `background_color`, `background_image`, `design_type`, `theme`, `style`, `cover_url`, `des_json`, `template`, `protection_code`, `type`, `iz_template`, `create_by`, `create_time`, `update_by`, `update_time`, `low_app_id`, `tenant_id`, `update_count`, `visits_num`, `del_flag`) VALUES ('1011915958294990848', '军地大数据驾驶舱', '/drag/page/view/1011915958294990848', '#495A78', 'https://jeecgdev.oss-cn-beijing.aliyuncs.com/temp/bg2_1731048266718.png', 100, 'dark', 'bigScreen', NULL, '{\"width\":1920,\"height\":1080}', '[{\"visible\":true,\"h\":73.99999999999997,\"i\":\"d21ff181-9e4f-4232-8541-6eb1960fc562\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JText\",\"w\":446.00000000000006,\"x\":762,\"y\":20,\"pageCompId\":\"1023811507021467648\",\"componentName\":\"文本\",\"key\":\"6e5a3ecd-17c7-4a07-9b16-2d5ae6335ff9\"},{\"visible\":true,\"h\":268,\"i\":\"05e6432a-51b5-48fd-8ab6-a124d3a50aae\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JRose\",\"w\":426,\"x\":49,\"y\":23,\"pageCompId\":\"1023811507063410688\",\"componentName\":\"南丁格尔玫瑰图\",\"key\":\"c1577c67-fbef-4166-8af1-ea7981306105\"},{\"visible\":true,\"h\":492,\"i\":\"eadb74d9-d2ac-44f9-bf13-ea1a7dee4654\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JBubbleMap\",\"w\":635,\"x\":635,\"y\":115,\"pageCompId\":\"1023811507080187904\",\"componentName\":\"散点地图\",\"key\":\"041f1194-8fd0-46d3-bbd9-b71d48d2d404\"},{\"visible\":true,\"h\":60,\"i\":\"6f3bc67b-ab9f-4802-876b-95e5881d3407\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JCurrentTime\",\"w\":465,\"x\":695,\"y\":116,\"pageCompId\":\"1023811507101159424\",\"componentName\":\"当前时间\",\"key\":\"134efa53-4ce2-49ba-8c71-e8ff88494146\"},{\"visible\":true,\"h\":512,\"i\":\"53b9d837-ac93-4267-814d-2fb58de90959\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JImg\",\"w\":560,\"x\":707,\"y\":111,\"pageCompId\":\"1023811507117936640\",\"componentName\":\"图片\",\"key\":\"b6519495-5bc5-41bb-aa2e-d8847fff1623\"},{\"visible\":true,\"h\":328,\"i\":\"ea130c05-dbd4-420e-8e5b-7527dfc89349\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JMultipleBar\",\"w\":536,\"x\":44,\"y\":228,\"pageCompId\":\"1023811507130519552\",\"componentName\":\"对比柱形图\",\"key\":\"340b4328-86e9-4e2a-8fa1-cbcc67a1219a\"},{\"visible\":true,\"h\":305,\"i\":\"es-drager-1731053336142-4\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JMultipleLine\",\"w\":519,\"x\":38,\"y\":560,\"pageCompId\":\"1023811507138908160\",\"componentName\":\"对比折线图\",\"key\":\"d10f660e-e668-467d-910a-0c92ac105f85\"},{\"visible\":true,\"h\":286,\"i\":\"es-drager-1731054001741-5\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JMultipleBar\",\"w\":1259,\"x\":7,\"y\":770,\"pageCompId\":\"1023811507151491072\",\"componentName\":\"对\",\"key\":\"7b7de114-55f0-4040-8511-fafc5e890c0b\"},{\"visible\":true,\"h\":36.99999999999996,\"i\":\"8b80e585-cca1-4de4-8029-cdf6a11ecb01\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JText\",\"w\":99.00000000000006,\"x\":1809,\"y\":18,\"pageCompId\":\"1023811507180851200\",\"componentName\":\"文本\",\"key\":\"fdd9bf52-0641-412a-9073-8344018e4ce2\"},{\"visible\":true,\"h\":295,\"i\":\"c7ca60ee-3281-428d-975e-49195c8cb742\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JScrollBoard\",\"w\":510,\"x\":1383,\"y\":68,\"pageCompId\":\"1023811507189239808\",\"componentName\":\"轮播表\",\"key\":\"a348bf5a-bf05-4d38-8f7a-3141536de3f8\"},{\"visible\":true,\"h\":326,\"i\":\"5e3ac2b4-7262-4999-b3f8-eed7cde4aae0\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JRadar\",\"w\":540,\"x\":1344,\"y\":418,\"pageCompId\":\"1023811507201822720\",\"componentName\":\"普通雷达图\",\"key\":\"4cf7463a-80a4-4a94-8e0c-93ff64e01d13\"},{\"visible\":true,\"h\":36.99999999999996,\"i\":\"es-drager-1731055443036-8\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JText\",\"w\":171.00000000000006,\"x\":1732,\"y\":739,\"pageCompId\":\"1023811507214405632\",\"componentName\":\"文本\",\"key\":\"3adaa5fa-b8b2-4666-9671-c6a0f57a7793\"},{\"visible\":true,\"h\":150,\"i\":\"bc23259f-0db5-4ff9-8651-b04ab85bfd86\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JRingProgress\",\"w\":245,\"x\":1289,\"y\":778,\"pageCompId\":\"1023811507222794240\",\"componentName\":\"基础环形图\",\"key\":\"bff57100-8221-475f-8ae4-556f4f003623\"},{\"visible\":true,\"h\":145,\"i\":\"es-drager-1731464896011-1\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JRingProgress\",\"w\":206,\"x\":1490,\"y\":784,\"pageCompId\":\"1023811507247960064\",\"componentName\":\"基础环形图\",\"key\":\"af09d0dd-6ee8-4888-be1e-0aa70e8034a9\"},{\"visible\":true,\"h\":145,\"i\":\"es-drager-1731465032706-2\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JRingProgress\",\"w\":206,\"x\":1681,\"y\":789,\"pageCompId\":\"1023811507260542976\",\"componentName\":\"基础环形图\",\"key\":\"d14af176-59cc-4b63-bb63-e2c0359f90b5\"},{\"visible\":true,\"h\":148,\"i\":\"es-drager-1731465068621-3\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JRingProgress\",\"w\":225,\"x\":1310,\"y\":920,\"pageCompId\":\"1023811507273125888\",\"componentName\":\"基础环形图\",\"key\":\"b6f36278-68f0-4aac-8ccd-8b433a61a645\"},{\"visible\":true,\"h\":145,\"i\":\"es-drager-1731465078501-4\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JRingProgress\",\"w\":228,\"x\":1477,\"y\":920,\"pageCompId\":\"1023811507281514496\",\"componentName\":\"基础环形图\",\"key\":\"6417673f-2e1e-4484-8fd5-47a54765c64c\"},{\"visible\":true,\"h\":145,\"i\":\"es-drager-1731465083311-5\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JRingProgress\",\"w\":267,\"x\":1643,\"y\":924,\"pageCompId\":\"1023811507294097408\",\"componentName\":\"基础环形图\",\"key\":\"db7baa0d-98da-45d0-9a00-321e7469973e\"},{\"visible\":true,\"h\":55,\"i\":\"bbf1a7a0-2dd6-4a91-88de-e8f83d8a4d15\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JProgress\",\"w\":330,\"x\":618,\"y\":629,\"pageCompId\":\"1023811507319263232\",\"componentName\":\"进度图\",\"key\":\"51a1720e-f1f3-4fde-8b92-9fb184d1003b\"},{\"visible\":true,\"h\":55,\"i\":\"es-drager-1731661825946-1\",\"orderNum\":390,\"compTextName\":\"\",\"component\":\"JProgress\",\"w\":330,\"x\":614,\"y\":677,\"pageCompId\":\"1023811507331846144\",\"componentName\":\"进度图\",\"key\":\"f3ea9eff-ac32-405a-abf2-3a48a31763eb\"}]', '', '2011441918119228928', '1', 'admin', '2024-10-31 18:39:35', 'admin', '2024-12-03 14:28:15', NULL, 3, 2, 0, 0);
INSERT INTO `onl_drag_page` (`id`, `name`, `path`, `background_color`, `background_image`, `design_type`, `theme`, `style`, `cover_url`, `des_json`, `template`, `protection_code`, `type`, `iz_template`, `create_by`, `create_time`, `update_by`, `update_time`, `low_app_id`, `tenant_id`, `update_count`, `visits_num`, `del_flag`) VALUES ('1014376428645961728', '北京科技数字化云平台', '/drag/page/view/1014376428645961728', '#1E0047', '/img/bg/bg10.png', 100, 'dark', 'bigScreen', NULL, '{\"width\":1920,\"height\":1080}', '[{\"component\":\"JImg\",\"w\":1917.0000000000002,\"x\":-1,\"h\":80,\"i\":\"1c5b0dae-314f-4663-8ebc-529e7ef397a1\",\"y\":0,\"orderNum\":0,\"pageCompId\":\"1021338143312891904\",\"componentName\":\"图片\",\"key\":\"c6bb8c0a-1734-405f-82be-5b25699a1bc1\"},{\"component\":\"JText\",\"w\":420,\"x\":746,\"h\":77,\"i\":\"afe6932a-9fcd-4cc1-8037-eefcf1b0605f\",\"y\":2,\"orderNum\":80,\"pageCompId\":\"1021338143350640640\",\"componentName\":\"文本\",\"key\":\"2ce590fd-9d06-4a8d-9680-247a0fb4edef\"},{\"component\":\"JCurrentTime\",\"w\":421,\"x\":745,\"h\":35,\"i\":\"a1ce6897-c28b-4f42-a775-c8c34d495d5d\",\"y\":107,\"orderNum\":80,\"pageCompId\":\"1021338143363223552\",\"componentName\":\"当前时间\",\"key\":\"4aa4d128-8900-4bb3-8931-0de2329d594c\"},{\"component\":\"JImg\",\"w\":130,\"x\":82,\"h\":52,\"i\":\"df702a2c-c1bf-4b9a-a1c7-83ff51a74c19\",\"y\":21,\"orderNum\":80,\"pageCompId\":\"1021338143375806464\",\"componentName\":\"图片\",\"key\":\"0423a14c-aa58-4a24-88b5-9e72c803f2f3\"},{\"component\":\"JText\",\"w\":80,\"x\":104,\"h\":41,\"i\":\"30361f52-fd03-40ab-86b8-52f358f3aff4\",\"y\":28.00000000000003,\"orderNum\":80,\"pageCompId\":\"1021338143384195072\",\"componentName\":\"文本\",\"key\":\"6f310775-12f2-4e7b-851e-8ac90409239a\"},{\"component\":\"JImg\",\"w\":130,\"x\":327,\"h\":52,\"i\":\"bc141cf0-9e31-424b-bc6c-1698023529be\",\"y\":21,\"orderNum\":80,\"pageCompId\":\"1021338143392583680\",\"componentName\":\"图片\",\"key\":\"c3323f46-a868-4a34-814d-f95979d553cd\"},{\"component\":\"JText\",\"w\":80,\"x\":352,\"h\":40,\"i\":\"becd17b5-e053-40c1-ab20-936e08457e38\",\"y\":27,\"orderNum\":80,\"pageCompId\":\"1021338143405166592\",\"componentName\":\"文本\",\"key\":\"10d319c0-bcb7-46ea-8d7b-8aeced7cb4f8\"},{\"component\":\"JImg\",\"w\":130,\"x\":205,\"h\":52,\"i\":\"08856df6-2e3b-422d-9a27-ceb3e94ddbe1\",\"y\":22,\"orderNum\":80,\"pageCompId\":\"1021338143426138112\",\"componentName\":\"图片\",\"key\":\"bdd13a67-9d91-4ac0-973e-9149f2abeb12\"},{\"component\":\"JImg\",\"w\":130,\"x\":1327,\"h\":52,\"i\":\"36ab5497-269f-4aee-a4b6-3fe6a2c20d4b\",\"y\":22,\"orderNum\":340,\"pageCompId\":\"1021338143442915328\",\"componentName\":\"图片\",\"key\":\"c0961091-151c-4a65-81db-7c8263018832\"},{\"component\":\"JImg\",\"w\":130,\"x\":1454,\"h\":52,\"i\":\"9697caf8-8a85-44c2-b7a4-ff5624b29217\",\"y\":22,\"orderNum\":600,\"pageCompId\":\"1021338143455498240\",\"componentName\":\"图片\",\"key\":\"5bd5f33d-49d3-4c51-b6fc-dccc388a565b\"},{\"component\":\"JImg\",\"w\":130,\"x\":1701,\"h\":52,\"i\":\"3b70af8f-cb79-45fb-b493-67f9f3ba68cd\",\"y\":22,\"orderNum\":1120,\"pageCompId\":\"1021338143468081152\",\"componentName\":\"图片\",\"key\":\"bc96714a-6706-4a8a-8f21-7f9c26859c51\"},{\"component\":\"JImg\",\"w\":130,\"x\":1579,\"h\":52,\"i\":\"4190d49d-5234-4c6b-8092-311e77aff8e1\",\"y\":21,\"orderNum\":1380,\"pageCompId\":\"1021338143484858368\",\"componentName\":\"图片\",\"key\":\"541dc811-5fd0-4b3a-8deb-082e430c3ac4\"},{\"component\":\"JImg\",\"w\":130,\"x\":452,\"h\":52,\"i\":\"cf1d47c4-70d8-4792-ab2c-cfa33476c5e2\",\"y\":21,\"orderNum\":1640,\"pageCompId\":\"1021338143501635584\",\"componentName\":\"图片\",\"key\":\"f9ce5aba-f469-48d9-aad6-b7f82cf14ea4\"},{\"component\":\"JText\",\"w\":81,\"x\":229,\"h\":40,\"i\":\"65595a23-9092-4735-8f50-e43aa9b1090f\",\"y\":29,\"orderNum\":80,\"pageCompId\":\"1021338143514218496\",\"componentName\":\"文本\",\"key\":\"124b4e24-fc36-419d-b0e0-011c683512f2\"},{\"component\":\"JText\",\"w\":80,\"x\":477,\"h\":40,\"i\":\"c3f77106-d4d2-49e0-9d94-7836eb492869\",\"y\":27,\"orderNum\":380,\"pageCompId\":\"1021338143526801408\",\"componentName\":\"文本\",\"key\":\"647324c5-98a4-4bdd-9aa0-71e6d07ca55a\"},{\"component\":\"JText\",\"w\":80,\"x\":1351,\"h\":40,\"i\":\"73f50ee8-3743-466d-b2e3-87c05122a4fc\",\"y\":28,\"orderNum\":680,\"pageCompId\":\"1021338143539384320\",\"componentName\":\"文本\",\"key\":\"0c05486a-7cf8-42dd-8408-80d9b0d7467d\"},{\"component\":\"JText\",\"w\":80,\"x\":1726,\"h\":40,\"i\":\"e9c3ab9b-a254-47fd-8965-b871c21a19dc\",\"y\":29,\"orderNum\":980,\"pageCompId\":\"1021338143560355840\",\"componentName\":\"文本\",\"key\":\"2e9efc55-2346-41d8-8829-3fd8f83c16cd\"},{\"component\":\"JText\",\"w\":80,\"x\":1480,\"h\":40,\"i\":\"38a62dd0-f307-4f50-8fd6-c84c7026c875\",\"y\":29,\"orderNum\":1280,\"pageCompId\":\"1021338143577133056\",\"componentName\":\"文本\",\"key\":\"0390e889-22ba-4fde-8657-32d8be6bd605\"},{\"component\":\"JText\",\"w\":80,\"x\":1604,\"h\":40,\"i\":\"495b30ae-75f6-49cb-8fa8-c5ee1b178529\",\"y\":28,\"orderNum\":80,\"pageCompId\":\"1021338143593910272\",\"componentName\":\"文本\",\"key\":\"755692a6-4622-401e-a2f3-27e516fe3153\"},{\"component\":\"JImg\",\"w\":465,\"x\":51,\"h\":260,\"i\":\"73b633d2-20f2-4b52-8db7-c23650825fc4\",\"y\":134,\"orderNum\":80,\"pageCompId\":\"1021338143606493184\",\"componentName\":\"图片\",\"key\":\"76375940-b57f-4530-add1-cca8070a881e\"},{\"component\":\"JText\",\"w\":115,\"x\":104,\"h\":33.99999999999994,\"i\":\"88a76ab8-7f47-43a3-8c56-2208a412dc9b\",\"y\":140,\"orderNum\":80,\"pageCompId\":\"1021338143619076096\",\"componentName\":\"文本\",\"key\":\"74de6558-99ae-46eb-8fd1-9dd23c3e0b17\"},{\"component\":\"JText\",\"w\":267.00000000000006,\"x\":167.99999999999997,\"h\":42.999999999999886,\"i\":\"1a568920-26ed-4f2a-a3b2-ee30e9120783\",\"y\":183,\"orderNum\":80,\"pageCompId\":\"1021338143635853312\",\"componentName\":\"文本\",\"key\":\"064902ad-c58b-4c31-9a14-ba351374f686\"},{\"component\":\"JCountTo\",\"w\":87,\"x\":170,\"h\":40,\"i\":\"cf88897f-f8ed-4994-8825-4781822d6da4\",\"y\":254,\"orderNum\":80,\"pageCompId\":\"1021338143648436224\",\"componentName\":\"翻牌器\",\"key\":\"33006bad-0489-43c3-aecd-e7ad249e95e4\"},{\"component\":\"JCountTo\",\"w\":91.99999999999994,\"x\":318,\"h\":39.00000000000006,\"i\":\"7e11b52c-2c9c-49d9-8921-529e89f7e188\",\"y\":252,\"orderNum\":80,\"pageCompId\":\"1021338143665213440\",\"componentName\":\"翻牌器\",\"key\":\"14f4c518-fd66-41b7-ae24-69f4992e78b3\"},{\"component\":\"JText\",\"w\":80.00000000000006,\"x\":174,\"h\":32.99999999999994,\"i\":\"5e3aaf53-23db-40d7-8492-9ca6220991a8\",\"y\":302,\"orderNum\":80,\"pageCompId\":\"1021338143690379264\",\"componentName\":\"文本\",\"key\":\"cdd16d26-6bf3-4010-8a4f-198112383d83\"},{\"component\":\"JText\",\"w\":91.00000000000006,\"x\":323,\"h\":31.999999999999886,\"i\":\"b012cf61-412e-4a10-8131-e0d0c0ee722c\",\"y\":303.00000000000006,\"orderNum\":80,\"pageCompId\":\"1021338143711350784\",\"componentName\":\"文本\",\"key\":\"73a0a2a9-8b9b-41ad-ac84-70ad6fbab13c\"},{\"component\":\"JImg\",\"w\":468,\"x\":48,\"h\":632,\"i\":\"5440a659-599a-4f47-aedd-0dffeba16881\",\"y\":415,\"orderNum\":80,\"pageCompId\":\"1021338143728128000\",\"componentName\":\"图片\",\"key\":\"21fed81a-0e75-460d-bb02-5354b624135a\"},{\"component\":\"JBar\",\"w\":393,\"x\":90,\"h\":264,\"i\":\"293ea950-a869-4661-818d-2ddb042c5831\",\"y\":466,\"orderNum\":80,\"pageCompId\":\"1021338143744905216\",\"componentName\":\"基础柱形图\",\"key\":\"4b4ec44a-d4ad-4f25-803e-bc9d8d5a1c3f\"},{\"component\":\"JBar\",\"w\":391,\"x\":83,\"h\":266,\"i\":\"53e124ad-12e5-4e40-8bda-c4a3982df3f2\",\"y\":758,\"orderNum\":80,\"pageCompId\":\"1021338143761682432\",\"componentName\":\"基础柱形图\",\"key\":\"7bfd0d39-b4b8-44cb-8d6a-34fc5ebd1d47\"},{\"component\":\"JImg\",\"w\":857,\"x\":539,\"h\":483,\"i\":\"748d6c5f-c1ba-42a8-b853-d72e8cf86037\",\"y\":162,\"orderNum\":80,\"pageCompId\":\"1021338143786848256\",\"componentName\":\"图片\",\"key\":\"dc04036a-aac4-492a-8118-3fa7ebee2d65\"},{\"component\":\"JGauge\",\"w\":465,\"x\":941,\"h\":300,\"i\":\"62bbe478-2de0-4ba0-883e-7851a22525f8\",\"y\":166,\"orderNum\":80,\"pageCompId\":\"1021338143803625472\",\"componentName\":\"基础仪表盘\",\"key\":\"ee9ea87e-eb4c-4ecd-9637-6012763d69b6\"},{\"component\":\"JGauge\",\"w\":359,\"x\":563,\"h\":253,\"i\":\"72e4c8b5-9ad4-4209-8f91-232ec35404f3\",\"y\":410,\"orderNum\":380,\"pageCompId\":\"1021338143816208384\",\"componentName\":\"基础仪表盘\",\"key\":\"4d0dfcb4-5a66-4e40-b1f9-890f3a863827\"},{\"component\":\"JGauge\",\"w\":359,\"x\":798,\"h\":253,\"i\":\"c682e09f-78f2-4ad3-90e8-e5a8c29e87e2\",\"y\":411,\"orderNum\":680,\"pageCompId\":\"1021338143837179904\",\"componentName\":\"基础仪表盘\",\"key\":\"9433d861-11bc-478d-8826-3d37777cb5de\"},{\"component\":\"JGauge\",\"w\":359,\"x\":1033,\"h\":253,\"i\":\"24276840-64dc-4a3e-91df-3ee4ebc11dda\",\"y\":411,\"orderNum\":980,\"pageCompId\":\"1021338143853957120\",\"componentName\":\"基础仪表盘\",\"key\":\"87de9d63-8c51-4485-bb2b-0a02b396709d\"},{\"component\":\"JImg\",\"w\":859,\"x\":534,\"h\":390,\"i\":\"75acb749-0e0d-4786-82a8-00e95be9f438\",\"y\":655,\"orderNum\":80,\"pageCompId\":\"1021338143870734336\",\"componentName\":\"图片\",\"key\":\"c9ce4876-c35e-4b30-8c7a-8b94342f1f72\"},{\"component\":\"JText\",\"w\":184,\"x\":558,\"h\":44.000000000000064,\"i\":\"b3343cad-a2e4-4fe8-aee3-0df2011efdba\",\"y\":666,\"orderNum\":80,\"pageCompId\":\"1021338143895900160\",\"componentName\":\"文本\",\"key\":\"6efaa506-5e73-4b5c-9001-dfe627072b7f\"},{\"component\":\"JImg\",\"w\":465,\"x\":1416,\"h\":449,\"i\":\"64faccb2-3cdb-4f2c-893c-5500876b9814\",\"y\":134,\"orderNum\":80,\"pageCompId\":\"1021338143921065984\",\"componentName\":\"图片\",\"key\":\"849ff904-c1cd-417b-85e8-c628b3a94d94\"},{\"component\":\"JText\",\"w\":342,\"x\":1478,\"h\":51,\"i\":\"b026c26b-d67e-4d2a-abb0-faee39022d65\",\"y\":146,\"orderNum\":80,\"pageCompId\":\"1021338143933648896\",\"componentName\":\"文本\",\"key\":\"7ad15ec7-26ec-4311-a081-9ec6433ad949\"},{\"component\":\"JText\",\"w\":459,\"x\":1394,\"h\":80,\"i\":\"7a3e3767-a8c2-420b-8fb8-e7b0449b6ea0\",\"y\":188,\"orderNum\":80,\"pageCompId\":\"1021338143946231808\",\"componentName\":\"文本\",\"key\":\"c1ef9157-88d6-418f-8555-e4c0eb3a9910\"},{\"component\":\"JText\",\"w\":460,\"x\":1402,\"h\":80,\"i\":\"5b37cb7e-23f1-476d-8306-cce309220168\",\"y\":267,\"orderNum\":80,\"pageCompId\":\"1021338143958814720\",\"componentName\":\"文本\",\"key\":\"334c39ea-3d81-44f4-81a5-3f5becb7c238\"},{\"component\":\"JText\",\"w\":458,\"x\":1419,\"h\":80,\"i\":\"80333722-29ff-4703-80cc-6244600321cf\",\"y\":342,\"orderNum\":80,\"pageCompId\":\"1021338143983980544\",\"componentName\":\"文本\",\"key\":\"64176ba1-1726-4b3b-930a-60d78f55405d\"},{\"component\":\"JText\",\"w\":459,\"x\":1401,\"h\":80,\"i\":\"72fbb44c-32de-413d-8968-b7b7d7d4e701\",\"y\":420,\"orderNum\":80,\"pageCompId\":\"1021338143996563456\",\"componentName\":\"文本\",\"key\":\"2180452b-8354-41eb-8ca2-f8ac29a3d72d\"},{\"component\":\"JImg\",\"w\":465,\"x\":1415,\"h\":410,\"i\":\"c1d5b4eb-3891-4a0a-9a21-80e80259a176\",\"y\":634,\"orderNum\":80,\"pageCompId\":\"1021338144009146368\",\"componentName\":\"图片\",\"key\":\"6fbc13df-3fe5-4bd3-a66a-bd0c0f6fc52a\"},{\"component\":\"JText\",\"w\":340,\"x\":1477,\"h\":44,\"i\":\"44f731e0-fa94-4109-8d53-e216cab63b8a\",\"y\":647,\"orderNum\":80,\"pageCompId\":\"1021338144025923584\",\"componentName\":\"文本\",\"key\":\"d26580ba-97bd-4656-84eb-b176c458ad32\"},{\"component\":\"JText\",\"w\":465,\"x\":761,\"h\":57.99999999999997,\"i\":\"c0d264d8-2b60-4afd-b306-d265c58e8473\",\"y\":165,\"orderNum\":80,\"pageCompId\":\"1021338144046895104\",\"componentName\":\"文本\",\"key\":\"fd6b9ecb-a058-45ff-96af-7ff4429e58dd\"},{\"component\":\"JLine\",\"w\":466,\"x\":1414,\"h\":288,\"i\":\"0b1de716-468e-42ec-89b8-be233d3d8724\",\"y\":707,\"orderNum\":80,\"pageCompId\":\"1021338144063672320\",\"componentName\":\"基础折线图\",\"key\":\"34d49859-b94c-48e3-808f-da08b873426c\"},{\"compTextName\":\"\",\"component\":\"JScrollTable\",\"visible\":true,\"w\":852,\"x\":537,\"h\":329,\"i\":\"89e5576b-dbbf-4a06-9ceb-db690e7ad61c\",\"y\":712,\"orderNum\":80,\"pageCompId\":\"1021338144080449536\",\"componentName\":\"表格\"},{\"component\":\"JGauge\",\"w\":524,\"x\":543,\"h\":301,\"i\":\"9044d895-c38e-44ba-a793-826b086fec66\",\"y\":166,\"orderNum\":80,\"pageCompId\":\"1021338144088838144\",\"componentName\":\"基础仪表盘\",\"key\":\"331dc721-7c5e-4004-81b1-8aca324df4f8\"}]', '', '2011441918119228928', '1', 'admin', '2024-11-07 13:36:37', 'admin', '2024-11-26 18:39:59', NULL, 3, 2, 0, 0);
INSERT INTO `onl_drag_page` (`id`, `name`, `path`, `background_color`, `background_image`, `design_type`, `theme`, `style`, `cover_url`, `des_json`, `template`, `protection_code`, `type`, `iz_template`, `create_by`, `create_time`, `update_by`, `update_time`, `low_app_id`, `tenant_id`, `update_count`, `visits_num`, `del_flag`) VALUES ('1015895036886831104', '监狱狱政科数据展示', '/drag/page/view/1015895036886831104', NULL, 'https://jeecgdev.oss-cn-beijing.aliyuncs.com/jimureport/images/2背景_1731554307578.jpg', 100, 'dark', 'bigScreen', NULL, '{\"width\":1920,\"height\":1080}', '[{\"visible\":true,\"h\":39,\"i\":\"8a751a70-50ff-4a18-bb2a-e33c7d8bb055\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":18,\"y\":16,\"pageCompId\":\"1017321185898713088\",\"selected\":true,\"key\":\"3a9800ef-77ba-4d23-ad7f-93299a9746f5\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554341219-1\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":519,\"x\":695,\"y\":39,\"pageCompId\":\"1017321185940656128\",\"selected\":false,\"key\":\"87a516b1-654e-4385-8624-92b63e69dfce\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554641653-2\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":45,\"y\":129,\"pageCompId\":\"1017321185957433344\",\"selected\":false,\"key\":\"8bd60606-6457-4074-8251-67e8d476058c\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554650239-3\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":142,\"x\":621,\"y\":130,\"pageCompId\":\"1017321185974210560\",\"selected\":false,\"key\":\"1118e97a-1e3d-4e8d-839e-80485318ab38\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554657899-4\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":794,\"y\":130,\"pageCompId\":\"1017321185986793472\",\"selected\":false,\"key\":\"9c0a3cb7-aaba-472a-a1d7-cf692e2aa1c4\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554660718-5\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":969,\"y\":131,\"pageCompId\":\"1017321186003570688\",\"selected\":false,\"key\":\"7039875e-bec1-4c3a-9e15-3d2ee61e0d34\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554663509-6\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1140,\"y\":132,\"pageCompId\":\"1017321186024542208\",\"selected\":false,\"key\":\"506c148d-7747-4fb2-aa8f-6642cd48ecde\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554901305-7\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":615,\"y\":180,\"pageCompId\":\"1017321186041319424\",\"selected\":false,\"key\":\"7cb3629b-2812-4137-afba-1036dfd65e4c\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554904164-8\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":49,\"x\":820,\"y\":182,\"pageCompId\":\"1017321186053902336\",\"selected\":false,\"key\":\"fcad8b91-29ab-4094-8626-9d59e91797ef\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554906777-9\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":965,\"y\":181,\"pageCompId\":\"1017321186066485248\",\"selected\":false,\"key\":\"338a28fd-1ac4-4642-8267-7a9259379408\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554911018-10\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":89,\"x\":1173,\"y\":182,\"pageCompId\":\"1017321186095845376\",\"selected\":false,\"key\":\"6f8b961b-77b9-468d-8c6b-ff63b9a834a4\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554930989-11\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1338,\"y\":129,\"pageCompId\":\"1017321186108428288\",\"selected\":false,\"key\":\"0d699b4a-d448-40a2-9cc4-d7f20ecc125e\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554944783-12\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":211,\"x\":1337,\"y\":625,\"pageCompId\":\"1017321186121011200\",\"selected\":false,\"key\":\"97d874ca-f103-4830-8663-a3c68246e406\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554949510-13\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":192,\"x\":616,\"y\":623,\"pageCompId\":\"1017321186133594112\",\"selected\":false,\"key\":\"e36af5b1-f538-45d1-b609-6905b0924772\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731554956540-14\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":52,\"y\":625,\"pageCompId\":\"1017321186154565632\",\"selected\":false,\"key\":\"bcd21420-8a7f-44fe-891b-92600239e2e8\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731555036448-15\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":44,\"x\":853,\"y\":182,\"pageCompId\":\"1017321186175537152\",\"selected\":false,\"key\":\"445e208c-59a3-4fb9-b0d2-6def4f0179bd\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731555481413-16\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":52,\"y\":189,\"pageCompId\":\"1017321186188120064\",\"selected\":false,\"key\":\"d688d880-01bd-4e34-97cf-b76d90dce3e1\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731555488647-17\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":284,\"y\":185,\"pageCompId\":\"1017321186200702976\",\"selected\":false,\"key\":\"9e4d8375-3307-494b-9d50-f00ad07587ee\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731555491173-18\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":84,\"y\":225,\"pageCompId\":\"1017321186217480192\",\"selected\":false,\"key\":\"fb22424a-2a27-4ccc-bf06-e8d792580b94\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731555492397-19\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":308,\"y\":223,\"pageCompId\":\"1017321186238451712\",\"selected\":false,\"key\":\"a21ba509-1ec6-4450-8353-aa3929092dc3\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731555507249-20\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1311,\"y\":188,\"pageCompId\":\"1017321186251034624\",\"selected\":false,\"key\":\"7667dd74-acff-4fb6-8881-b8035d0ede80\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731555511061-21\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1541,\"y\":192,\"pageCompId\":\"1017321186263617536\",\"selected\":false,\"key\":\"40d56052-f72b-4eae-8c7e-1d77cae61013\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731555514595-22\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1343,\"y\":222,\"pageCompId\":\"1017321186280394752\",\"selected\":false,\"key\":\"8995191b-cfdc-4978-8428-2b43b1d9a046\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731555517774-23\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1610,\"y\":224,\"pageCompId\":\"1017321186305560576\",\"selected\":false,\"key\":\"4e2fb295-3f4e-4e35-ac37-7d85f35a9242\"},{\"visible\":true,\"h\":216,\"i\":\"8fc14384-c894-4c46-830c-9047ff569a66\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JMultipleBar\",\"w\":489,\"x\":55,\"y\":356,\"pageCompId\":\"1017321186322337792\",\"selected\":false,\"key\":\"a132eed8-6436-4fc5-86f6-dfda0f05eb95\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731556853370-24\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":63,\"y\":258,\"pageCompId\":\"1017321186334920704\",\"selected\":false,\"key\":\"40d94708-30eb-4c29-8e52-4b7d18036c1d\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731556856918-25\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":94,\"y\":297,\"pageCompId\":\"1017321186351697920\",\"selected\":false,\"key\":\"d95f5454-2a3f-49d3-a3fa-2e2854dec8da\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731556862766-26\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":311,\"y\":259,\"pageCompId\":\"1017321186376863744\",\"selected\":false,\"key\":\"07269e41-c8ce-4d70-8ff2-3abcf3ba247b\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731556870179-27\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":311,\"y\":299,\"pageCompId\":\"1017321186393640960\",\"selected\":false,\"key\":\"f11c4f40-34b9-4048-936a-cdcf2d4017e2\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731556893775-28\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1309,\"y\":268,\"pageCompId\":\"1017321186406223872\",\"selected\":false,\"key\":\"b55f7d17-91a2-4cb1-8c2f-60c10c073d5b\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731556897633-29\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1353,\"y\":306,\"pageCompId\":\"1017321186431389696\",\"selected\":false,\"key\":\"efeaefc7-4cd2-4563-a337-da451878a314\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731556900421-30\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1547,\"y\":269,\"pageCompId\":\"1017321186452361216\",\"selected\":false,\"key\":\"2e268466-8ded-4a7b-808a-8582b306e11f\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731556904681-31\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":153,\"x\":1609,\"y\":302,\"pageCompId\":\"1017321186464944128\",\"selected\":false,\"key\":\"920ee28a-be38-41ed-84be-9ca5d8b9e359\"},{\"visible\":true,\"h\":263,\"i\":\"810ae487-0402-45e4-839f-ae53fe327206\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JPie\",\"w\":412,\"x\":608,\"y\":298,\"pageCompId\":\"1017321186477527040\",\"selected\":false,\"key\":\"63730e7b-f8a1-493b-8094-684034d0c004\"},{\"visible\":true,\"h\":263,\"i\":\"es-drager-1731565807875-32\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JPie\",\"w\":412,\"x\":960,\"y\":295,\"pageCompId\":\"1017321186498498560\",\"selected\":false,\"key\":\"ce4dca14-edfc-488c-80e1-f3c908d5de65\"},{\"visible\":true,\"h\":236,\"i\":\"e546a2b1-0da9-45b4-95f6-c6fbcb6d1846\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JMultipleBar\",\"w\":529,\"x\":1339,\"y\":350,\"pageCompId\":\"1017321186515275776\",\"selected\":false,\"key\":\"448ab743-22ec-427a-945f-d44a48b56f0b\"},{\"visible\":true,\"h\":177,\"i\":\"96d5c689-2fc0-494a-92e1-9d446345c1e9\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JDynamicBar\",\"w\":464,\"x\":1336,\"y\":670,\"pageCompId\":\"1017321186532052992\",\"selected\":false,\"key\":\"a3c4101a-faeb-47d8-8db9-476d3133575d\"},{\"visible\":true,\"h\":171,\"i\":\"es-drager-1731571931624-1\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JDynamicBar\",\"w\":450,\"x\":1336,\"y\":838,\"pageCompId\":\"1017321186544635904\",\"selected\":false,\"key\":\"7de97686-514e-47d8-8dca-e3332bb1a101\"},{\"visible\":true,\"h\":321,\"i\":\"18f17713-c9a2-43c8-a1b4-8956526edf92\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JScrollBoard\",\"w\":534,\"x\":49,\"y\":684,\"pageCompId\":\"1017321186561413120\",\"selected\":false,\"key\":\"b9bbfb10-b8b6-4d69-839d-533cb6bc87b3\"},{\"visible\":true,\"h\":324,\"i\":\"es-drager-1731572436300-2\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JScrollBoard\",\"w\":676,\"x\":624,\"y\":686,\"pageCompId\":\"1017321186582384640\",\"selected\":false,\"key\":\"4e9900f0-25b3-4afe-8f4a-47fe3278f7d5\"},{\"compTextName\":\"\",\"component\":\"JCurrentTime\",\"visible\":true,\"w\":289,\"x\":1585,\"h\":33,\"i\":\"93f679fd-84cd-4e4e-8b1c-a6c832393f9f\",\"y\":18,\"orderNum\":0,\"pageCompId\":\"1017321186599161856\",\"selected\":false}]', '', '2011441918119228928', '1', 'admin', '2024-11-11 18:11:01', 'admin', '2024-11-15 16:38:02', NULL, 3, 2, 10, 0);
INSERT INTO `onl_drag_page` (`id`, `name`, `path`, `background_color`, `background_image`, `design_type`, `theme`, `style`, `cover_url`, `des_json`, `template`, `protection_code`, `type`, `iz_template`, `create_by`, `create_time`, `update_by`, `update_time`, `low_app_id`, `tenant_id`, `update_count`, `visits_num`, `del_flag`) VALUES ('1016497921022545920', '监狱财政科数据展示', '/drag/page/view/1016497921022545920', '#1E0047', 'https://jeecgdev.oss-cn-beijing.aliyuncs.com/jimureport/images/1背景_1731463744922.jpg', 100, 'dark', 'bigScreen', NULL, '{\"width\":1920,\"height\":1080}', '[{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":144,\"x\":27,\"h\":33,\"i\":\"bea2f336-12f8-4333-adb1-882c4a46f1ef\",\"y\":22,\"orderNum\":0,\"pageCompId\":\"1019836136064339968\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":466,\"x\":730,\"h\":45,\"i\":\"es-drager-1731575388068-1\",\"y\":40,\"orderNum\":0,\"pageCompId\":\"1019836136139837440\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":144,\"x\":46,\"h\":33,\"i\":\"es-drager-1731575453492-2\",\"y\":135,\"orderNum\":0,\"pageCompId\":\"1019836136160808960\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":144,\"x\":1332,\"h\":33,\"i\":\"es-drager-1731575564662-3\",\"y\":132,\"orderNum\":0,\"pageCompId\":\"1019836136177586176\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":177,\"x\":44,\"h\":33,\"i\":\"es-drager-1731575571643-4\",\"y\":630,\"orderNum\":0,\"pageCompId\":\"1019836136190169088\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":195,\"x\":619,\"h\":33,\"i\":\"es-drager-1731575574764-5\",\"y\":628,\"orderNum\":0,\"pageCompId\":\"1019836136206946304\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":144,\"x\":1338,\"h\":33,\"i\":\"es-drager-1731575579158-6\",\"y\":628,\"orderNum\":0,\"pageCompId\":\"1019836136232112128\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":55,\"h\":33,\"i\":\"es-drager-1731575591936-7\",\"y\":185,\"orderNum\":0,\"pageCompId\":\"1019836136248889344\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":298,\"h\":33,\"i\":\"es-drager-1731575650336-8\",\"y\":183,\"orderNum\":0,\"pageCompId\":\"1019836136261472256\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":57,\"h\":33,\"i\":\"es-drager-1731575655752-9\",\"y\":259,\"orderNum\":0,\"pageCompId\":\"1019836136274055168\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":151,\"x\":302,\"h\":33,\"i\":\"es-drager-1731575658548-10\",\"y\":259,\"orderNum\":0,\"pageCompId\":\"1019836136295026688\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":1364,\"h\":33,\"i\":\"es-drager-1731575662995-11\",\"y\":192,\"orderNum\":0,\"pageCompId\":\"1019836136311803904\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":1633,\"h\":33,\"i\":\"es-drager-1731575667327-12\",\"y\":192,\"orderNum\":0,\"pageCompId\":\"1019836136328581120\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":1367,\"h\":33,\"i\":\"es-drager-1731575676489-13\",\"y\":259,\"orderNum\":0,\"pageCompId\":\"1019836136336969728\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":1649,\"h\":33,\"i\":\"es-drager-1731575681208-14\",\"y\":263,\"orderNum\":0,\"pageCompId\":\"1019836136353746944\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":807,\"h\":33,\"i\":\"es-drager-1731575699841-15\",\"y\":124,\"orderNum\":0,\"pageCompId\":\"1019836136374718464\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":801,\"h\":33,\"i\":\"es-drager-1731575713035-16\",\"y\":202,\"orderNum\":0,\"pageCompId\":\"1019836136395689984\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":1166,\"h\":33,\"i\":\"es-drager-1731575720590-17\",\"y\":122,\"orderNum\":0,\"pageCompId\":\"1019836136412467200\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":1169,\"h\":33,\"i\":\"es-drager-1731575724256-18\",\"y\":205,\"orderNum\":0,\"pageCompId\":\"1019836136429244416\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":637,\"h\":33,\"i\":\"es-drager-1731575741874-19\",\"y\":145,\"orderNum\":0,\"pageCompId\":\"1019836136450215936\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":132,\"x\":1008,\"h\":33,\"i\":\"es-drager-1731575790320-20\",\"y\":136,\"orderNum\":0,\"pageCompId\":\"1019836136466993152\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":298,\"h\":33,\"i\":\"es-drager-1731576490851-23\",\"y\":218,\"orderNum\":0,\"pageCompId\":\"1019836136487964672\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":56,\"h\":33,\"i\":\"es-drager-1731576557313-24\",\"y\":219,\"orderNum\":0,\"pageCompId\":\"1019836136508936192\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":47,\"h\":33,\"i\":\"es-drager-1731576610256-25\",\"y\":290,\"orderNum\":0,\"pageCompId\":\"1019836136525713408\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":288,\"h\":33,\"i\":\"es-drager-1731576613557-26\",\"y\":294,\"orderNum\":0,\"pageCompId\":\"1019836136538296320\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":630,\"h\":33,\"i\":\"es-drager-1731576622559-27\",\"y\":195,\"orderNum\":0,\"pageCompId\":\"1019836136555073536\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":179,\"x\":988,\"h\":33,\"i\":\"es-drager-1731576628027-28\",\"y\":196,\"orderNum\":0,\"pageCompId\":\"1019836136563462144\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":1345,\"h\":33,\"i\":\"es-drager-1731576635331-29\",\"y\":225,\"orderNum\":0,\"pageCompId\":\"1019836136580239360\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":1389,\"h\":33,\"i\":\"es-drager-1731576638739-30\",\"y\":294,\"orderNum\":0,\"pageCompId\":\"1019836136592822272\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":1654,\"h\":33,\"i\":\"es-drager-1731576643262-31\",\"y\":225,\"orderNum\":0,\"pageCompId\":\"1019836136605405184\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":1659,\"h\":33,\"i\":\"es-drager-1731576941854-33\",\"y\":296,\"orderNum\":0,\"pageCompId\":\"1019836136622182400\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":803,\"h\":33,\"i\":\"es-drager-1731577225841-34\",\"y\":150,\"orderNum\":0,\"pageCompId\":\"1019836136638959616\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":782,\"h\":33,\"i\":\"es-drager-1731577276117-35\",\"y\":231,\"orderNum\":0,\"pageCompId\":\"1019836136655736832\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":1154,\"h\":33,\"i\":\"es-drager-1731577281301-36\",\"y\":146,\"orderNum\":0,\"pageCompId\":\"1019836136668319744\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":161,\"x\":1149,\"h\":33,\"i\":\"es-drager-1731577285085-37\",\"y\":231,\"orderNum\":0,\"pageCompId\":\"1019836136685096960\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":84,\"x\":850,\"h\":33,\"i\":\"es-drager-1731577430161-38\",\"y\":231,\"orderNum\":0,\"pageCompId\":\"1019836136693485568\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":84,\"x\":1220,\"h\":33,\"i\":\"es-drager-1731577464601-39\",\"y\":231,\"orderNum\":0,\"pageCompId\":\"1019836136710262784\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JMultipleBar\",\"visible\":true,\"w\":543,\"x\":47,\"h\":257,\"i\":\"f5598f5b-7aee-4b4a-aa98-3703c9f471f4\",\"y\":335,\"orderNum\":0,\"pageCompId\":\"1019836136727040000\",\"componentName\":\"对比柱形图\"},{\"compTextName\":\"\",\"component\":\"JMultipleLine\",\"visible\":true,\"w\":682,\"x\":628,\"h\":309,\"i\":\"0811e80e-d0df-43d7-92c6-d7f0e0d62fd7\",\"y\":297,\"orderNum\":0,\"pageCompId\":\"1019836136743817216\",\"componentName\":\"对比折线图\"},{\"compTextName\":\"\",\"component\":\"JArea\",\"visible\":true,\"w\":530,\"x\":1358,\"h\":258,\"i\":\"aeafbc37-dcbc-4385-8d24-643fa4dc4fcd\",\"y\":328,\"orderNum\":0,\"pageCompId\":\"1019836136756400128\",\"componentName\":\"面积图\"},{\"compTextName\":\"\",\"component\":\"JScrollBoard\",\"visible\":true,\"w\":531,\"x\":49,\"h\":326,\"i\":\"12b2c94e-529a-4668-a2de-9b2021e93f56\",\"y\":678,\"orderNum\":0,\"pageCompId\":\"1019836136764788736\",\"componentName\":\"轮播表\"},{\"compTextName\":\"\",\"component\":\"JScrollBoard\",\"visible\":true,\"w\":671,\"x\":626,\"h\":338,\"i\":\"es-drager-1731579827097-40\",\"y\":675,\"orderNum\":0,\"pageCompId\":\"1019836136777371648\",\"componentName\":\"轮播表\"},{\"compTextName\":\"\",\"component\":\"JScrollBoard\",\"visible\":true,\"w\":531,\"x\":1342,\"h\":326,\"i\":\"es-drager-1731579847826-41\",\"y\":681,\"orderNum\":0,\"pageCompId\":\"1019836136794148864\",\"componentName\":\"轮播表\"}]', '', '2011441918119228928', '1', 'admin', '2024-11-13 10:06:40', 'admin', '2024-11-22 15:11:33', NULL, 3, 2, 0, 0);
INSERT INTO `onl_drag_page` (`id`, `name`, `path`, `background_color`, `background_image`, `design_type`, `theme`, `style`, `cover_url`, `des_json`, `template`, `protection_code`, `type`, `iz_template`, `create_by`, `create_time`, `update_by`, `update_time`, `low_app_id`, `tenant_id`, `update_count`, `visits_num`, `del_flag`) VALUES ('1016994145836257280', '个性化组件大阅兵', '/drag/page/view/1016994145836257280', '#1E0047', '/img/bg/bg1.png', 100, 'dark', 'bigScreen', NULL, '{\"width\":1920,\"height\":2000}', '[{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":695,\"x\":606,\"h\":459,\"i\":\"es-drager-1731636172470-5\",\"y\":497,\"orderNum\":0,\"pageCompId\":\"1017225681378529280\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":690,\"x\":610,\"h\":385,\"i\":\"es-drager-1731636518160-9\",\"y\":968,\"orderNum\":0,\"pageCompId\":\"1017225681424666624\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":543,\"x\":41,\"h\":385,\"i\":\"es-drager-1731636444637-8\",\"y\":968,\"orderNum\":0,\"pageCompId\":\"1017225681441443840\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":543,\"x\":1311,\"h\":455,\"i\":\"es-drager-1731636204058-6\",\"y\":501,\"orderNum\":0,\"pageCompId\":\"1017225681454026752\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":688,\"x\":437,\"h\":385,\"i\":\"es-drager-1731635819511-1\",\"y\":96,\"orderNum\":0,\"pageCompId\":\"1017225681470803968\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":350,\"x\":1512.5302491103203,\"h\":385,\"i\":\"es-drager-1731635884970-3\",\"y\":97.09964412811388,\"orderNum\":0,\"pageCompId\":\"1017225681495969792\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":360,\"x\":1139.5302491103203,\"h\":385,\"i\":\"es-drager-1731635842921-2\",\"y\":93.09964412811388,\"orderNum\":0,\"pageCompId\":\"1017225681512747008\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":588,\"x\":710,\"h\":71,\"i\":\"93d57e1f-efe0-41d8-a970-cca353e07913\",\"y\":5,\"orderNum\":0,\"pageCompId\":\"1017225681525329920\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JFlashCloud\",\"visible\":true,\"w\":321,\"x\":77.53024911032026,\"h\":333,\"i\":\"60e1c0cf-8ed5-4069-8d45-4422daddd4fa\",\"y\":107.09964412811388,\"orderNum\":0,\"pageCompId\":\"1017225681588244480\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JGender\",\"visible\":true,\"w\":341,\"x\":1147,\"h\":284,\"i\":\"b704fde0-b83b-43c9-812f-00669da4fd26\",\"y\":130,\"orderNum\":0,\"pageCompId\":\"1017225681609216000\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JWeatherForecast\",\"visible\":true,\"w\":257,\"x\":1536.5302491103203,\"h\":47,\"i\":\"962e8a41-52bc-486b-8bac-a4d2bede7b60\",\"y\":239.09964412811385,\"orderNum\":0,\"pageCompId\":\"1017225681621798912\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JNegativeBar\",\"visible\":true,\"w\":515,\"x\":63,\"h\":429,\"i\":\"6f636ad2-1e9a-43ae-aa23-79e4066a5f09\",\"y\":511,\"orderNum\":0,\"pageCompId\":\"1017225681634381824\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JFlashList\",\"visible\":true,\"w\":498,\"x\":1353,\"h\":300,\"i\":\"70f4698c-332c-4278-aabe-fbfa06900b68\",\"y\":556,\"orderNum\":0,\"pageCompId\":\"1017225681655353344\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JPictorialBar\",\"visible\":true,\"w\":516,\"x\":55,\"h\":334,\"i\":\"56271f7e-e085-4bdc-81da-1223af3d1ba2\",\"y\":996,\"orderNum\":0,\"pageCompId\":\"1017225681676324864\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDevHistory\",\"visible\":true,\"w\":661,\"x\":620,\"h\":300,\"i\":\"21224e76-d6fe-4600-a16d-ae6e7f55bfbc\",\"y\":991,\"orderNum\":0,\"pageCompId\":\"1017225681697296384\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JRotatePie\",\"visible\":true,\"w\":450,\"x\":1345,\"h\":300,\"i\":\"3b9b8918-5afa-4bb9-83a7-d8b6d87338e3\",\"y\":1012,\"orderNum\":0,\"pageCompId\":\"1017225681714073600\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JColorBlock\",\"visible\":true,\"w\":1865,\"x\":23,\"h\":110,\"i\":\"d7661f3f-303c-4110-8128-32be407275a3\",\"y\":1389,\"orderNum\":0,\"pageCompId\":\"1017225681726656512\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":350,\"x\":58.09964412811388,\"h\":385,\"i\":\"30152f09-985b-4d7f-82a7-1d78251f1c2a\",\"y\":91,\"orderNum\":0,\"pageCompId\":\"1017225681743433728\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":545,\"x\":43,\"h\":468,\"i\":\"es-drager-1731635997743-4\",\"y\":492,\"orderNum\":0,\"pageCompId\":\"1017225681764405248\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":541,\"x\":1311,\"h\":379,\"i\":\"es-drager-1731636613880-10\",\"y\":972,\"orderNum\":0,\"pageCompId\":\"1017225681781182464\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JRectangle\",\"visible\":true,\"w\":662,\"x\":447,\"h\":364,\"i\":\"bbfdcef5-a32d-4d15-8f12-d7a4d5016e68\",\"y\":102,\"orderNum\":0,\"pageCompId\":\"1017225681793765376\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JPyramid3D\",\"visible\":true,\"w\":678,\"x\":625,\"h\":438,\"i\":\"014b738b-9fc6-49ca-8d27-a029b89f2dc0\",\"y\":511,\"orderNum\":0,\"pageCompId\":\"1017225681810542592\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":1878,\"x\":9,\"h\":130,\"i\":\"16e26ff8-0039-4ae7-a2c3-4b4a97e44e8b\",\"y\":1365,\"orderNum\":0,\"pageCompId\":\"1017225681823125504\",\"selected\":false}]', '', '2011441918119228928', '1', 'admin', '2024-11-14 18:58:29', 'admin', '2024-11-15 10:18:32', NULL, 3, 2, 0, 0);
INSERT INTO `onl_drag_page` (`id`, `name`, `path`, `background_color`, `background_image`, `design_type`, `theme`, `style`, `cover_url`, `des_json`, `template`, `protection_code`, `type`, `iz_template`, `create_by`, `create_time`, `update_by`, `update_time`, `low_app_id`, `tenant_id`, `update_count`, `visits_num`, `del_flag`) VALUES ('1016994272231608320', '旅游数据分析中心大屏', '/drag/page/view/1016994272231608320', '#1E0047', '/img/bg/bg1.png', 100, 'dark', 'bigScreen', NULL, '{\"width\":1920,\"height\":1080}', '[{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":801,\"x\":550,\"h\":926,\"i\":\"es-drager-1731642710947-12\",\"y\":128,\"orderNum\":300,\"pageCompId\":\"1021960592459091968\",\"componentName\":\"边框1\"},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":488,\"x\":20,\"h\":926,\"i\":\"5427a7d4-3c10-425f-a059-ecadd99cf9e0\",\"y\":127,\"orderNum\":300,\"pageCompId\":\"1021960592501035008\",\"componentName\":\"边框1\"},{\"compTextName\":\"\",\"component\":\"JDragBorder\",\"visible\":true,\"w\":507,\"x\":1398,\"h\":926,\"i\":\"es-drager-1731642738303-13\",\"y\":125,\"orderNum\":300,\"pageCompId\":\"1021960592526200832\",\"componentName\":\"边框1\"},{\"visible\":true,\"h\":88,\"i\":\"3ec5db86-1dc8-4fc1-84c0-e7db4e7934bd\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":636,\"x\":673,\"y\":13,\"pageCompId\":\"1021960592555560960\",\"componentName\":\"文本\",\"key\":\"b992d9d0-a169-4750-8b85-043a6db79675\"},{\"visible\":true,\"h\":39,\"i\":\"03c0a8d6-e38b-4b37-8158-d048079be048\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":139,\"x\":35,\"y\":139,\"pageCompId\":\"1021960592568143872\",\"componentName\":\"文本\",\"key\":\"08550975-dab7-48f8-8323-f12b93b7d579\"},{\"visible\":true,\"h\":74,\"i\":\"a2f9a2bc-f6cc-4811-add1-aa48cd7d499e\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JImg\",\"w\":91,\"x\":93.53557015642195,\"y\":202.6610746089451,\"pageCompId\":\"1021960592584921088\",\"componentName\":\"图片\",\"key\":\"233b45a6-858d-4486-9fb7-1c70503502c0\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731638452515-1\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":171,\"x\":47,\"y\":344,\"pageCompId\":\"1021960592601698304\",\"componentName\":\"文本\",\"key\":\"03718e74-b30f-44e9-873d-75eacf011834\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731638457909-2\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":231,\"x\":44,\"y\":650,\"pageCompId\":\"1021960592622669824\",\"componentName\":\"文本\",\"key\":\"9db0eb47-7974-4f3f-8c87-e761eba17b8d\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731638464024-3\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":200,\"x\":576,\"y\":136,\"pageCompId\":\"1021960592647835648\",\"componentName\":\"文本\",\"key\":\"ddacdb15-4f7f-4417-91f5-e2195199ed2f\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731638496760-4\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":212,\"x\":1079,\"y\":140,\"pageCompId\":\"1021960592664612864\",\"componentName\":\"文本\",\"key\":\"d064d0b9-1470-4d35-9fc4-c4b88efe63bd\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731638502084-5\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":267,\"x\":1427,\"y\":144,\"pageCompId\":\"1021960592681390080\",\"componentName\":\"文本\",\"key\":\"d4a88ee7-5091-4b8b-80f4-395b5af94a13\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731638509763-6\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":205,\"x\":1409,\"y\":309,\"pageCompId\":\"1021960592706555904\",\"componentName\":\"文本\",\"key\":\"f115414b-da0c-4606-9ecd-af9d464cd4a5\"},{\"visible\":true,\"h\":39,\"i\":\"es-drager-1731638514808-7\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":192,\"x\":1431,\"y\":678,\"pageCompId\":\"1021960592735916032\",\"componentName\":\"文本\",\"key\":\"b91f0e67-d931-49ab-98ce-43bbdf1f6c97\"},{\"visible\":true,\"h\":100,\"i\":\"1f05d4e8-af8b-43b9-bb80-0a1e803c9407\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JDragDecoration\",\"w\":443,\"x\":23,\"y\":16,\"pageCompId\":\"1021960592765276160\",\"componentName\":\"装饰1\",\"key\":\"053b7c8f-4c72-4230-a5f7-5eb46acce4e0\"},{\"visible\":true,\"h\":47,\"i\":\"16f505ae-dcc8-4329-841f-6816ed0f79fa\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JWeatherForecast\",\"w\":257,\"x\":202,\"y\":184,\"pageCompId\":\"1021960592786247680\",\"componentName\":\"滚动版\",\"key\":\"bf67a1de-364e-416a-88ff-ad9db3df8f5f\"},{\"visible\":true,\"h\":33,\"i\":\"1eb7afb8-829c-4ba6-a539-0b76f843d185\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JCurrentTime\",\"w\":270,\"x\":183,\"y\":238,\"pageCompId\":\"1021960592807219200\",\"componentName\":\"当前时间\",\"key\":\"e7bf2eb6-d0d3-4427-851c-4b6f7620d152\"},{\"visible\":true,\"h\":47,\"i\":\"9c8ccf30-2db6-4f5b-9a47-358748ce0077\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JDragDecoration\",\"w\":383,\"x\":74,\"y\":291,\"pageCompId\":\"1021960592844967936\",\"componentName\":\"装饰1\",\"key\":\"9f5b9308-ee8f-4a10-8bf5-74de1bd272fa\"},{\"visible\":true,\"h\":300,\"i\":\"e1437091-ec46-455b-851a-1b2262c9b427\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JLine\",\"w\":488,\"x\":31,\"y\":699,\"pageCompId\":\"1021960592861745152\",\"componentName\":\"基础折线图\",\"key\":\"c371e000-99f4-43c6-b660-5cd19ec59887\"},{\"visible\":true,\"h\":41,\"i\":\"es-drager-1731638963126-8\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JDragDecoration\",\"w\":396,\"x\":55,\"y\":607,\"pageCompId\":\"1021960592878522368\",\"componentName\":\"装饰1\",\"key\":\"bf2601e8-d445-49a6-a52d-9738278d633f\"},{\"visible\":true,\"h\":245,\"i\":\"ae124c04-e6d8-443b-9ddb-cb99c21300ed\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JGender\",\"w\":317,\"x\":98,\"y\":393,\"pageCompId\":\"1021960592899493888\",\"componentName\":\"男女占比\",\"key\":\"02cb5192-9972-4517-b00e-1382685803d2\"},{\"visible\":true,\"h\":100,\"i\":\"da3036d0-e3b7-4a05-a229-0d05389e7370\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JDragDecoration\",\"w\":604,\"x\":1326,\"y\":10,\"pageCompId\":\"1021960592941436928\",\"componentName\":\"装饰1\",\"key\":\"1712efe4-3815-46e2-aae4-2d08183b3e36\"},{\"visible\":true,\"h\":142,\"i\":\"c4fbcf36-1a87-499b-b0cb-46a26a2c2f5b\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JCountTo\",\"w\":712,\"x\":582,\"y\":218,\"pageCompId\":\"1021960592958214144\",\"componentName\":\"翻牌器\",\"key\":\"e4805388-607c-48a1-8b04-7ad672938721\"},{\"visible\":true,\"h\":527,\"i\":\"edd9d638-3fee-4e3e-84b4-9599bdc25a00\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JBubbleMap\",\"w\":718,\"x\":585,\"y\":393,\"pageCompId\":\"1021960592991768576\",\"componentName\":\"散点地图\",\"key\":\"07e69455-5f45-4b5a-874b-db3adf6a800b\"},{\"compTextName\":\"\",\"component\":\"JImg\",\"visible\":true,\"w\":54,\"x\":1451,\"h\":51,\"i\":\"5d6a9f04-f23e-493c-8825-59b784cef860\",\"y\":192,\"orderNum\":0,\"pageCompId\":\"1021960593008545792\",\"componentName\":\"图片\"},{\"compTextName\":\"\",\"component\":\"JDragDecoration\",\"visible\":true,\"w\":406,\"x\":1445,\"h\":47,\"i\":\"es-drager-1731641087446-9\",\"y\":247,\"orderNum\":0,\"pageCompId\":\"1021960593029517312\",\"componentName\":\"装饰1\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":134,\"x\":1524,\"h\":33,\"i\":\"3716ccfd-c753-400e-80ba-37d73732e967\",\"y\":199,\"orderNum\":300,\"pageCompId\":\"1021960593063071744\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":true,\"w\":128,\"x\":1678,\"h\":45,\"i\":\"es-drager-1731641329682-10\",\"y\":189,\"orderNum\":300,\"pageCompId\":\"1021960593079848960\",\"componentName\":\"文本\"},{\"compTextName\":\"\",\"component\":\"JRing\",\"visible\":true,\"w\":436,\"x\":1446,\"h\":300,\"i\":\"1fc939b3-3b6b-4d09-9c4e-cd37292f7ac5\",\"y\":334,\"orderNum\":300,\"pageCompId\":\"1021960593096626176\",\"componentName\":\"饼状环形图\"},{\"compTextName\":\"\",\"component\":\"JDragDecoration\",\"visible\":true,\"w\":421,\"x\":1435,\"h\":47,\"i\":\"es-drager-1731642551406-11\",\"y\":617,\"orderNum\":0,\"pageCompId\":\"1021960593121792000\",\"componentName\":\"装饰1\"},{\"compTextName\":\"\",\"component\":\"JCapsuleChart\",\"visible\":true,\"w\":450,\"x\":1427,\"h\":300,\"i\":\"37fa8779-2081-4f35-83ef-797ff9ddcce0\",\"y\":728,\"orderNum\":300,\"pageCompId\":\"1021960593138569216\",\"componentName\":\"胶囊图\"}]', '', '2011441918119228928', '1', 'admin', '2024-11-14 18:59:00', 'admin', '2024-11-28 11:53:23', NULL, 3, 2, 0, 0);
INSERT INTO `onl_drag_page` (`id`, `name`, `path`, `background_color`, `background_image`, `design_type`, `theme`, `style`, `cover_url`, `des_json`, `template`, `protection_code`, `type`, `iz_template`, `create_by`, `create_time`, `update_by`, `update_time`, `low_app_id`, `tenant_id`, `update_count`, `visits_num`, `del_flag`) VALUES ('1016994412900175872', '收视监控平台', '/drag/page/view/1016994412900175872', '#1E0047', '/img/bg/bg18.jpg', 100, 'dark', 'bigScreen', NULL, '{\"width\":1920,\"height\":2000}', '[{\"visible\":true,\"h\":52,\"i\":\"ae56fe51-65d1-4866-9789-f9229289964f\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":376,\"x\":779,\"y\":27,\"pageCompId\":\"1017286463101390848\",\"selected\":false,\"key\":\"33c6ecba-c0f5-46f2-9323-aab43e87eb63\"},{\"visible\":true,\"h\":45,\"i\":\"8ce1a978-3664-41d4-8d80-1b8f81deee0a\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JText\",\"w\":382,\"x\":774,\"y\":107,\"pageCompId\":\"1017286463134945280\",\"selected\":false,\"key\":\"936bc496-c82b-46b1-bc19-a9ee91929452\"},{\"visible\":true,\"h\":78,\"i\":\"04048a06-cefb-4dcd-ac0c-004da0229a9e\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JDragDecoration\",\"w\":403,\"x\":10,\"y\":52,\"pageCompId\":\"1017286463160111104\",\"selected\":false,\"key\":\"6cc237a4-89ad-4718-83c4-feb0b9a14ef9\"},{\"visible\":true,\"h\":33,\"i\":\"f69ec49c-ff6d-40f6-bcff-06a2d6742751\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JCurrentTime\",\"w\":270,\"x\":1629,\"y\":20,\"pageCompId\":\"1017286463176888320\",\"selected\":false,\"key\":\"1ac1bf52-506c-4d5b-95da-52f907854017\"},{\"visible\":true,\"h\":61,\"i\":\"5094172c-0de1-4f5d-84d8-fff43811bba5\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JImg\",\"w\":93,\"x\":1558,\"y\":10,\"pageCompId\":\"1017286463185276928\",\"selected\":false,\"key\":\"dd9f7e52-86bc-4fcb-8bb2-bbd62e1a7546\"},{\"visible\":true,\"h\":59,\"i\":\"3d154544-9fab-4177-8fa8-dce02ccf8b5e\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JWeatherForecast\",\"w\":267,\"x\":1635,\"y\":59,\"pageCompId\":\"1017286463202054144\",\"selected\":false,\"key\":\"375983aa-1c1b-4cd0-8d68-a67e55588edc\"},{\"visible\":true,\"h\":441,\"i\":\"9fe7eb28-0157-48ca-8535-34760368e2d7\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JDragBorder\",\"w\":599,\"x\":79,\"y\":190,\"pageCompId\":\"1017286463223025664\",\"selected\":false,\"key\":\"51cc5aff-ade9-40ef-9a31-891cc4779213\"},{\"visible\":true,\"h\":445,\"i\":\"es-drager-1731648824951-1\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JDragBorder\",\"w\":582,\"x\":699,\"y\":189,\"pageCompId\":\"1017286463235608576\",\"selected\":false,\"key\":\"8c08e246-f373-45e7-84cb-896b3c19c248\"},{\"visible\":true,\"h\":450,\"i\":\"es-drager-1731648851843-2\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JDragBorder\",\"w\":589,\"x\":1297,\"y\":187,\"pageCompId\":\"1017286463248191488\",\"selected\":false,\"key\":\"71fe25a3-4299-42c7-8a96-2415747940c9\"},{\"visible\":true,\"h\":405,\"i\":\"22aae23c-029e-456e-a1ac-0936cbfa6b6b\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JVideoJs\",\"w\":568,\"x\":93,\"y\":207,\"pageCompId\":\"1017286463260774400\",\"selected\":false,\"key\":\"41da84ee-4ced-4414-af4c-acbf4cf2232c\"},{\"visible\":true,\"h\":416,\"i\":\"9d1f25e6-5446-4f78-90c6-7f9bd674b058\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JVideoJs\",\"w\":560,\"x\":707,\"y\":201,\"pageCompId\":\"1017286463281745920\",\"selected\":false,\"key\":\"864aa918-532c-4407-9bb0-2e2041ae53f7\"},{\"visible\":true,\"h\":433,\"i\":\"85841a8f-e6cd-479a-9ba8-c36497b4e912\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JVideoJs\",\"w\":570,\"x\":1306,\"y\":194,\"pageCompId\":\"1017286463294328832\",\"selected\":false,\"key\":\"8f12407a-94af-46c1-bd13-1e28fcbfaee0\"},{\"visible\":true,\"h\":56,\"i\":\"b0c4361a-0dfb-4575-88cb-edb593d4e120\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JText\",\"w\":262,\"x\":81,\"y\":666,\"pageCompId\":\"1017286463311106048\",\"selected\":false,\"key\":\"245b1381-54f5-40fd-9475-e34e41587f37\"},{\"visible\":true,\"h\":417,\"i\":\"3ca04b91-c734-42b9-8eea-93dad3b04a7e\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JDragBorder\",\"w\":1790,\"x\":70,\"y\":747,\"pageCompId\":\"1017286463319494656\",\"selected\":false,\"key\":\"5627d105-4546-4692-abcd-42f2e61c3e45\"},{\"visible\":true,\"h\":335,\"i\":\"236cba9d-2c70-407e-8013-ee37e3d5d124\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JMultipleLine\",\"w\":485,\"x\":109,\"y\":797,\"pageCompId\":\"1017286463332077568\",\"selected\":false,\"key\":\"644ef67f-0b41-4cb5-8cc5-1cac198d745f\"},{\"visible\":true,\"h\":335,\"i\":\"es-drager-1731649759290-3\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JMultipleLine\",\"w\":485,\"x\":704,\"y\":797,\"pageCompId\":\"1017286463357243392\",\"selected\":false,\"key\":\"f92fba2e-d9c4-4e38-901d-d947f542e17b\"},{\"visible\":true,\"h\":335,\"i\":\"es-drager-1731649765690-4\",\"orderNum\":300,\"compTextName\":\"\",\"component\":\"JMultipleLine\",\"w\":485,\"x\":1292,\"y\":793,\"pageCompId\":\"1017286463369826304\",\"selected\":false,\"key\":\"3c1ab904-3923-4a51-80c5-d355c8516333\"},{\"visible\":true,\"h\":80,\"i\":\"3f014db1-34fe-41b7-bdff-ab4a23a7d6f6\",\"orderNum\":108,\"compTextName\":\"\",\"component\":\"JSelectRadio\",\"w\":400,\"x\":62,\"y\":7,\"pageCompId\":\"1017286463382409216\",\"selected\":false,\"key\":\"1fef29d3-cad8-4248-84d3-a778f7f1b389\"},{\"visible\":false,\"h\":351,\"i\":\"26735d51-f628-4ec6-8886-0ede0a7443af\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JVideoPlay\",\"w\":516,\"x\":121,\"y\":236,\"pageCompId\":\"1017286463394992128\",\"selected\":false,\"key\":\"861f9c1d-d8dc-418a-a8c6-19f9c8d3a7e1\"},{\"visible\":false,\"h\":361,\"i\":\"es-drager-1731650783569-1\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JVideoPlay\",\"w\":518,\"x\":730,\"y\":226,\"pageCompId\":\"1017286463411769344\",\"selected\":false,\"key\":\"9daa119e-566a-4c34-8643-49334e77701c\"},{\"visible\":false,\"h\":378,\"i\":\"es-drager-1731650792607-2\",\"orderNum\":0,\"compTextName\":\"\",\"component\":\"JVideoPlay\",\"w\":521,\"x\":1329,\"y\":222,\"pageCompId\":\"1017286463436935168\",\"selected\":false,\"key\":\"75211ac2-b0de-45bf-87ae-f84c8a712368\"},{\"compTextName\":\"\",\"component\":\"JBubble\",\"visible\":false,\"w\":851,\"x\":106,\"h\":360,\"i\":\"3acfc295-ea6d-4e16-83fd-bfd8d9022d8d\",\"y\":784,\"orderNum\":0,\"pageCompId\":\"1017286463449518080\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JText\",\"visible\":false,\"w\":268,\"x\":1037,\"h\":63,\"i\":\"f499c09e-61cc-40f1-8496-d57d2f98f82c\",\"y\":752,\"orderNum\":300,\"pageCompId\":\"1017286463462100992\",\"selected\":false},{\"compTextName\":\"\",\"component\":\"JRing\",\"visible\":false,\"w\":666,\"x\":944,\"h\":385,\"i\":\"a82c61b6-4287-422a-b8e7-1cb34d17859a\",\"y\":794,\"orderNum\":300,\"pageCompId\":\"1017286463478878208\",\"selected\":false}]', '', '2011441918119228928', '1', 'admin', '2024-11-14 18:59:33', 'admin', '2024-11-15 14:20:03', NULL, 3, 2, 0, 0);

INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689476558848', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"853652\",\"size\":{\"width\":94.99999999999989,\"height\":44.999999999999886},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689484947456', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"3652\",\"size\":{\"width\":84,\"height\":31.280575539568332},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689501724672', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"1353652\",\"size\":{\"width\":77,\"height\":40.99999999999987},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689514307584', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"1753652\",\"size\":{\"width\":96,\"height\":41.99999999999983},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689522696192', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"26023\",\"size\":{\"width\":100,\"height\":37.99999999999994},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689531084800', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"60230\",\"size\":{\"width\":100.00000000000011,\"height\":33.33093525179855},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689543667712', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"8023\",\"size\":{\"width\":82,\"height\":39.00000000000006},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689552056320', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"12023\",\"size\":{\"width\":59.000000000000114,\"height\":45.99999999999993},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689560444928', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"26023\",\"size\":{\"width\":79.99999999999989,\"height\":44.000000000000014},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689577222144', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"8012\",\"size\":{\"width\":85,\"height\":53},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689589805056', NULL, '1011800681234354176', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"26023\",\"size\":{\"width\":78,\"height\":49.99999999999982},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#05D6E9\",\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689598193664', NULL, '1011800681234354176', NULL, 'JPie', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[    {        \\\"name\\\": \\\"0-15岁\\\",        \\\"value\\\": 1000879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"16-40岁\\\",        \\\"value\\\": 3400879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"41-55岁\\\",        \\\"value\\\": 2300879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"56-70岁\\\",        \\\"value\\\": 5400879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"71+\\\",        \\\"value\\\": 3000,        \\\"url\\\": \\\"http://www.baidu.com\\\"    }]\",\"size\":{\"width\":314,\"height\":243.99999999999994},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"customColor\":[{\"color\":\"#83BFF6\"},{\"color\":\"#23B7E5\"},{\"color\":\"#9AA8D4\"},{\"color\":\"#188DF0\"},{\"color\":\"#564AA3\"}],\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"orient\":\"vertical\",\"show\":false},\"series\":[{\"data\":[],\"name\":\"\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"}},\"label\":{\"color\":\"#EEF1FA\"},\"type\":\"pie\",\"radius\":\"50%\"}],\"tooltip\":{\"trigger\":\"item\"},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":false,\"text\":\"基础饼图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689606582272', NULL, '1011800681234354176', NULL, 'JMultipleLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"1\\\",    \\\"value\\\": 2879,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"2\\\",    \\\"value\\\": 3879,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"3\\\",    \\\"value\\\": 1879,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"4\\\",    \\\"value\\\": 879,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"5\\\",    \\\"value\\\": 1879,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"6\\\",    \\\"value\\\": 779,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"7\\\",    \\\"value\\\": 279,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"8\\\",    \\\"value\\\": 339,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"1\\\",    \\\"value\\\": 1879,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"2\\\",    \\\"value\\\": 5879,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"3\\\",    \\\"value\\\": 4579,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"4\\\",    \\\"value\\\": 3879,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"5\\\",    \\\"value\\\": 179,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"6\\\",    \\\"value\\\": 979,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"7\\\",    \\\"value\\\": 179,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"8\\\",    \\\"value\\\": 2879,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"1\\\",    \\\"value\\\": 879,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"2\\\",    \\\"value\\\": 1879,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"3\\\",    \\\"value\\\": 979,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"4\\\",    \\\"value\\\": 3879,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"5\\\",    \\\"value\\\": 5179,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"6\\\",    \\\"value\\\": 3379,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"7\\\",    \\\"value\\\": 879,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"8\\\",    \\\"value\\\": 879,    \\\"type\\\": \\\"问诊未支付\\\"  }]\",\"size\":{\"width\":517,\"height\":332},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":90,\"bottom\":115},\"series\":[{\"lineType\":\"smooth\",\"label\":{\"color\":\"#EEF1FA\"}}],\"legend\":{\"show\":false},\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"show\":false,\"text\":\"多数据对比折线图\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689619165184', NULL, '1011800681234354176', NULL, 'JBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"图文\\\",    \\\"value\\\": 120879,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"视频\\\",    \\\"value\\\": 232879,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"面询\\\",    \\\"value\\\": 340879,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"电话\\\",    \\\"value\\\": 534790,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"量表\\\",    \\\"value\\\": 560879,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"随访\\\",    \\\"value\\\": 670879,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"提醒包\\\",    \\\"value\\\": 400879,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"药品\\\",    \\\"value\\\": 540879,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"复诊\\\",    \\\"value\\\": 200879,    \\\"type\\\": \\\"手机品牌\\\"  }]\",\"size\":{\"width\":754,\"height\":392},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"interval\":2}},\"grid\":{\"top\":90,\"left\":82,\"bottom\":115,\"show\":false,\"right\":101,\"containLabel\":true},\"series\":[{\"barWidth\":22,\"data\":[],\"itemStyle\":{\"color\":\"#64B5F6\",\"borderRadius\":0},\"label\":{\"color\":\"#EEF1FA\",\"show\":true,\"position\":\"top\"},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"show\":false,\"text\":\"基础柱形图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689627553792', NULL, '1011800681234354176', NULL, 'JRose', '{\"chartData\":\"[    {        \\\"name\\\": \\\"康宁\\\",        \\\"value\\\": 1000879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"安肯\\\",        \\\"value\\\": 3400879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"怡宁\\\",        \\\"value\\\": 2300879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"淳安\\\",        \\\"value\\\": 5400879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"医院\\\",        \\\"value\\\": 3000,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"其他\\\",        \\\"value\\\": 2000,        \\\"url\\\": \\\"http://www.baidu.com\\\"    }]\",\"size\":{\"width\":400,\"height\":222.99999999999994},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":12,\"dataType\":1,\"h\":30,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"option\":{\"customColor\":[{\"color\":\"#83BFF6\"},{\"color\":\"#23B7E5\"},{\"color\":\"#9AA8D4\"},{\"color\":\"#188DF0\"},{\"color\":\"#564AA3\"}],\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"orient\":\"vertical\"},\"series\":[{\"data\":[],\"roseType\":\"radius\",\"name\":\"南丁格尔玫瑰\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"}},\"type\":\"pie\",\"radius\":\"50%\"}],\"tooltip\":{\"trigger\":\"item\"},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":false,\"text\":\"基础饼图\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689644331008', NULL, '1011800681234354176', NULL, 'JMultipleLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"1\\\",    \\\"value\\\": 879,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"2\\\",    \\\"value\\\": 1879,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"3\\\",    \\\"value\\\": 779,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"4\\\",    \\\"value\\\": 879,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"5\\\",    \\\"value\\\": 3879,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"6\\\",    \\\"value\\\": 779,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"7\\\",    \\\"value\\\": 279,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"8\\\",    \\\"value\\\": 339,    \\\"type\\\": \\\"问诊订单总数\\\"  },  {    \\\"name\\\": \\\"1\\\",    \\\"value\\\": 1879,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"2\\\",    \\\"value\\\": 3879,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"3\\\",    \\\"value\\\": 4579,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"4\\\",    \\\"value\\\": 3879,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"5\\\",    \\\"value\\\": 179,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"6\\\",    \\\"value\\\": 979,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"7\\\",    \\\"value\\\": 179,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"8\\\",    \\\"value\\\": 2879,    \\\"type\\\": \\\"问诊已支付\\\"  },  {    \\\"name\\\": \\\"1\\\",    \\\"value\\\": 879,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"2\\\",    \\\"value\\\": 1879,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"3\\\",    \\\"value\\\": 979,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"4\\\",    \\\"value\\\": 3879,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"5\\\",    \\\"value\\\": 5179,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"6\\\",    \\\"value\\\": 3379,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"7\\\",    \\\"value\\\": 879,    \\\"type\\\": \\\"问诊未支付\\\"  },  {    \\\"name\\\": \\\"8\\\",    \\\"value\\\": 879,    \\\"type\\\": \\\"问诊未支付\\\"  }]\",\"size\":{\"width\":566,\"height\":313.00000000000006},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"top\":90,\"bottom\":115},\"series\":[{\"lineType\":\"smooth\"}],\"legend\":{\"show\":false},\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":false,\"text\":\"多数据对比折线图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689656913920', NULL, '1011800681234354176', NULL, 'JDynamicBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"妇科\\\",    \\\"value\\\": 160879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"儿科\\\",    \\\"value\\\": 348879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"儿科中医\\\",    \\\"value\\\": 288879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"内分泌科\\\",    \\\"value\\\": 120879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"耳鼻喉科\\\",    \\\"value\\\": 570879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"肩颈科\\\",    \\\"value\\\": 290849,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"产科\\\",    \\\"value\\\": 120079,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"过敏科\\\",    \\\"value\\\": 240079,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"中医科\\\",    \\\"value\\\": 440555,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"营养科\\\",    \\\"value\\\": 124079,    \\\"type\\\": \\\"Lon\\\"  }]\",\"size\":{\"width\":221,\"height\":510},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"xAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"show\":false,\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":82,\"left\":65,\"bottom\":67},\"series\":[{\"barWidth\":13,\"showBackground\":false,\"backgroundStyle\":{\"color\":\"#51626E\"},\"itemStyle\":{\"color\":\"#64B5F6\"}}],\"legend\":{\"show\":false},\"tooltip\":{\"show\":false,\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"show\":false,\"text\":\"动态柱形图\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689665302528', NULL, '1011800681234354176', NULL, 'JDynamicBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"医生\\\",    \\\"value\\\": 1000879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"患者\\\",    \\\"value\\\": 3400879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"咨询师\\\",    \\\"value\\\": 2300879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"导医\\\",    \\\"value\\\": 5400879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"患者\\\",    \\\"value\\\": 3400879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"咨询师\\\",    \\\"value\\\": 7400879,    \\\"type\\\": \\\"Lon\\\"  },  {    \\\"name\\\": \\\"咨询师\\\",    \\\"value\\\": 2400879,    \\\"type\\\": \\\"Lon\\\"  }]\",\"size\":{\"width\":228.00000000000003,\"height\":424},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"show\":false},\"grid\":{\"top\":90,\"left\":46,\"bottom\":81,\"right\":57},\"series\":[{\"barWidth\":17,\"itemStyle\":{\"color\":\"#A83240\"}}],\"legend\":{\"show\":false},\"tooltip\":{\"show\":false,\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":false,\"text\":\"动态柱形图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689677885440', NULL, '1011800681234354176', NULL, 'JRose', '{\"chartData\":\"[  {    \\\"name\\\": \\\"医生\\\",    \\\"value\\\": 1000879,    \\\"url\\\": \\\"http://jeecg.com\\\"  },  {    \\\"name\\\": \\\"医生\\\",    \\\"value\\\": 3400879,    \\\"url\\\": \\\"http://jeecg.com\\\"  },  {    \\\"name\\\": \\\"医生\\\",    \\\"value\\\": 2300879,    \\\"url\\\": \\\"http://jeecg.com\\\"  },  {    \\\"name\\\": \\\"医生\\\",    \\\"value\\\": 5400879,    \\\"url\\\": \\\"http://jeecg.com\\\"  },  {    \\\"name\\\": \\\"医生\\\",    \\\"value\\\": 3000,    \\\"url\\\": \\\"http://jeecg.com\\\"  },  {    \\\"name\\\": \\\"医生\\\",    \\\"value\\\": 2000,    \\\"url\\\": \\\"http://jeecg.com\\\"  }]\",\"size\":{\"width\":221,\"height\":180.46043165467626},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":12,\"dataType\":1,\"h\":30,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"option\":{\"customColor\":[{\"color\":\"#83BFF6\"},{\"color\":\"#23B7E5\"},{\"color\":\"#9AA8D4\"},{\"color\":\"#188DF0\"},{\"color\":\"#564AA3\"}],\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"orient\":\"vertical\",\"show\":false},\"series\":[{\"data\":[],\"roseType\":\"radius\",\"name\":\"南丁格尔玫瑰\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"}},\"type\":\"pie\",\"radius\":\"50%\"}],\"tooltip\":{\"trigger\":\"item\"},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":false,\"text\":\"基础饼图\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689686274048', NULL, '1011800681234354176', NULL, 'JRose', '{\"chartData\":\"[  {    \\\"value\\\": 1048,    \\\"name\\\": \\\"vivo\\\"  },  {    \\\"value\\\": 735,    \\\"name\\\": \\\"oppo\\\"  },  {    \\\"value\\\": 580,    \\\"name\\\": \\\"苹果\\\"  },  {    \\\"value\\\": 484,    \\\"name\\\": \\\"小米\\\"  },  {    \\\"value\\\": 300,    \\\"name\\\": \\\"三星\\\"  }]\",\"size\":{\"width\":215,\"height\":264.0000000000001},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":12,\"dataType\":1,\"h\":30,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"option\":{\"customColor\":[{\"color\":\"#83BFF6\"},{\"color\":\"#23B7E5\"},{\"color\":\"#9AA8D4\"},{\"color\":\"#188DF0\"},{\"color\":\"#564AA3\"}],\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"orient\":\"vertical\",\"show\":false},\"series\":[{\"data\":[],\"roseType\":\"radius\",\"name\":\"南丁格尔玫瑰\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"}},\"type\":\"pie\",\"radius\":\"50%\"}],\"tooltip\":{\"trigger\":\"item\"},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":false,\"text\":\"基础饼图\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689694662656', NULL, '1011800681234354176', NULL, 'JBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"医生\\\",    \\\"value\\\": 1079,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"咨询师\\\",    \\\"value\\\": 3479,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"小程序\\\",    \\\"value\\\": 2709,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"后台系统\\\",    \\\"value\\\": 5856,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"APP\\\",    \\\"value\\\": 3823,    \\\"type\\\": \\\"手机品牌\\\"  }]\",\"size\":{\"width\":471.00000000000006,\"height\":387.00000000000006},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"interval\":2}},\"grid\":{\"top\":90,\"left\":57,\"bottom\":130,\"show\":false,\"right\":1,\"containLabel\":true},\"series\":[{\"barWidth\":20,\"data\":[],\"itemStyle\":{\"color\":\"#64B5F6\",\"borderRadius\":0},\"label\":{\"color\":\"#EEF1FA\",\"show\":true,\"position\":\"top\"},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"show\":false,\"text\":\"基础柱形图\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689707245568', NULL, '1011800681234354176', NULL, 'JPie', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[    {        \\\"name\\\": \\\"1-15岁\\\",        \\\"value\\\": 1000879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"16-40\\\",        \\\"value\\\": 3400879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"41-55\\\",        \\\"value\\\": 2300879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"56-70\\\",        \\\"value\\\": 5400879,        \\\"url\\\": \\\"http://www.baidu.com\\\"    },    {        \\\"name\\\": \\\"71+\\\",        \\\"value\\\": 3000,        \\\"url\\\": \\\"http://www.baidu.com\\\"    }]\",\"size\":{\"width\":328,\"height\":300},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"customColor\":[{\"color\":\"#83BFF6\"},{\"color\":\"#23B7E5\"},{\"color\":\"#9AA8D4\"},{\"color\":\"#188DF0\"},{\"color\":\"#564AA3\"}],\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"orient\":\"vertical\",\"show\":false},\"series\":[{\"data\":[],\"name\":\"\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"}},\"label\":{\"color\":\"#EEF1FA\"},\"type\":\"pie\",\"radius\":\"50%\"}],\"tooltip\":{\"trigger\":\"item\"},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":false,\"text\":\"基础饼图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689719828480', NULL, '1011800681234354176', NULL, 'JBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"app\\\",    \\\"value\\\": 1879,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"小程序\\\",    \\\"value\\\": 3879,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"医生端\\\",    \\\"value\\\": 2879,    \\\"type\\\": \\\"手机品牌\\\"  }]\",\"size\":{\"width\":269.9999999999999,\"height\":297},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"interval\":2}},\"grid\":{\"top\":90,\"bottom\":115,\"show\":false,\"containLabel\":true},\"series\":[{\"barWidth\":16,\"data\":[],\"itemStyle\":{\"color\":\"#64B5F6\",\"borderRadius\":0},\"label\":{\"color\":\"#EEF1FA\",\"show\":true,\"position\":\"top\"},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"show\":false,\"text\":\"基础柱形图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"showUnit\":{\"numberLevel\":\"0\",\"show\":true}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689732411392', NULL, '1011800681234354176', NULL, 'JScatter', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": 1,    \\\"value\\\": 8.04  },  {    \\\"name\\\": 2,    \\\"value\\\": 6.95  },  {    \\\"name\\\": 1,    \\\"value\\\": 4.04  },  {    \\\"name\\\": 2,    \\\"value\\\": 3.95  }]\",\"size\":{\"width\":212,\"height\":269},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"interval\":2}},\"grid\":{\"bottom\":115,\"show\":false},\"series\":[{\"data\":[],\"symbolSize\":20,\"itemStyle\":{\"color\":\"#64b5f6\"},\"type\":\"scatter\"}],\"tooltip\":{\"formatter\":\"x:{b}<br/>y:{c}\",\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"item\"},\"title\":{\"show\":false,\"text\":\"基础散点图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689744994304', NULL, '1011800681234354176', NULL, 'JScrollBoard', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"key1\\\": \\\"01-18\\\",    \\\"key2\\\": \\\"张图\\\",    \\\"key3\\\": \\\"李木木\\\",    \\\"key4\\\": \\\"图文问诊\\\",    \\\"key5\\\": \\\"专家问诊\\\",    \\\"key6\\\": \\\"100\\\",    \\\"key7\\\": \\\"已支付\\\",    \\\"key8\\\": \\\"01-10\\\"  },  {    \\\"key1\\\": \\\"01-18\\\",    \\\"key2\\\": \\\"张图\\\",    \\\"key3\\\": \\\"李木木\\\",    \\\"key4\\\": \\\"图文问诊\\\",    \\\"key5\\\": \\\"专家问诊\\\",    \\\"key6\\\": \\\"100\\\",    \\\"key7\\\": \\\"已支付\\\",    \\\"key8\\\": \\\"01-10\\\"  },  {    \\\"key1\\\": \\\"01-18\\\",    \\\"key2\\\": \\\"张图\\\",    \\\"key3\\\": \\\"李木木\\\",    \\\"key4\\\": \\\"图文问诊\\\",    \\\"key5\\\": \\\"专家问诊\\\",    \\\"key6\\\": \\\"100\\\",    \\\"key7\\\": \\\"已支付\\\",    \\\"key8\\\": \\\"01-10\\\"  },  {    \\\"key1\\\": \\\"01-18\\\",    \\\"key2\\\": \\\"张图\\\",    \\\"key3\\\": \\\"李木木\\\",    \\\"key4\\\": \\\"图文问诊\\\",    \\\"key5\\\": \\\"专家问诊\\\",    \\\"key6\\\": \\\"100\\\",    \\\"key7\\\": \\\"已支付\\\",    \\\"key8\\\": \\\"01-10\\\"  },  {    \\\"key1\\\": \\\"01-18\\\",    \\\"key2\\\": \\\"张图\\\",    \\\"key3\\\": \\\"李木木\\\",    \\\"key4\\\": \\\"图文问诊\\\",    \\\"key5\\\": \\\"专家问诊\\\",    \\\"key6\\\": \\\"100\\\",    \\\"key7\\\": \\\"已支付\\\",    \\\"key8\\\": \\\"01-10\\\"  },  {    \\\"key1\\\": \\\"01-18\\\",    \\\"key2\\\": \\\"张图\\\",    \\\"key3\\\": \\\"李木木\\\",    \\\"key4\\\": \\\"图文问诊\\\",    \\\"key5\\\": \\\"专家问诊\\\",    \\\"key6\\\": \\\"100\\\",    \\\"key7\\\": \\\"已支付\\\",    \\\"key8\\\": \\\"01-10\\\"  },  {    \\\"key1\\\": \\\"01-18\\\",    \\\"key2\\\": \\\"张图\\\",    \\\"key3\\\": \\\"李木木\\\",    \\\"key4\\\": \\\"图文问诊\\\",    \\\"key5\\\": \\\"专家问诊\\\",    \\\"key6\\\": \\\"100\\\",    \\\"key7\\\": \\\"已支付\\\",    \\\"key8\\\": \\\"01-10\\\"  },  {    \\\"key1\\\": \\\"01-18\\\",    \\\"key2\\\": \\\"张图\\\",    \\\"key3\\\": \\\"李木木\\\",    \\\"key4\\\": \\\"图文问诊\\\",    \\\"key5\\\": \\\"专家问诊\\\",    \\\"key6\\\": \\\"100\\\",    \\\"key7\\\": \\\"已支付\\\",    \\\"key8\\\": \\\"01-10\\\"  }]\",\"size\":{\"width\":417,\"height\":214},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"oddRowBGC\":\"#07284B\",\"headShow\":true,\"hoverPause\":true,\"indexWidth\":80,\"index\":false,\"carousel\":\"single\",\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"evenRowBGC\":\"#06243D\",\"header\":[{\"width\":100,\"label\":\"创建时间\"},{\"width\":100,\"label\":\"患者姓名\"},{\"width\":100,\"label\":\"接诊医生\"},{\"width\":100,\"label\":\"服务类型\"},{\"width\":100,\"label\":\"订单类型\"},{\"width\":100,\"label\":\"支付金额\"},{\"width\":100,\"label\":\"支付状态\"},{\"width\":100,\"label\":\"预约时间\"}],\"headerBGC\":\"#072F48\",\"headerHeight\":45,\"waitTime\":2000,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023815689757577216', NULL, '1011800681234354176', NULL, 'JScrollBoard', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[    {        \\\"key1\\\": \\\"2022-01-18 15:11:55\\\",        \\\"key2\\\": \\\"张图\\\",        \\\"key3\\\": \\\"李木木\\\",        \\\"key4\\\": \\\"图文问诊\\\",        \\\"key5\\\": \\\"专家问诊\\\",        \\\"key6\\\": \\\"100\\\",        \\\"key7\\\": \\\"已支付\\\",        \\\"key8\\\": \\\"2022-01-10\\\"    },    {        \\\"key1\\\": \\\"2022-01-18 15:11:55\\\",        \\\"key2\\\": \\\"张图\\\",        \\\"key3\\\": \\\"李木木\\\",        \\\"key4\\\": \\\"图文问诊\\\",        \\\"key5\\\": \\\"专家问诊\\\",        \\\"key6\\\": \\\"100\\\",        \\\"key7\\\": \\\"已支付\\\",        \\\"key8\\\": \\\"2022-01-10\\\"    },    {        \\\"key1\\\": \\\"2022-01-18 15:11:55\\\",        \\\"key2\\\": \\\"张图\\\",        \\\"key3\\\": \\\"李木木\\\",        \\\"key4\\\": \\\"图文问诊\\\",        \\\"key5\\\": \\\"专家问诊\\\",        \\\"key6\\\": \\\"100\\\",        \\\"key7\\\": \\\"已支付\\\",        \\\"key8\\\": \\\"2022-01-10\\\"    },    {        \\\"key1\\\": \\\"2022-01-18 15:11:55\\\",        \\\"key2\\\": \\\"张图\\\",        \\\"key3\\\": \\\"李木木\\\",        \\\"key4\\\": \\\"图文问诊\\\",        \\\"key5\\\": \\\"专家问诊\\\",        \\\"key6\\\": \\\"100\\\",        \\\"key7\\\": \\\"已支付\\\",        \\\"key8\\\": \\\"2022-01-10\\\"    },    {        \\\"key1\\\": \\\"2022-01-18 15:11:55\\\",        \\\"key2\\\": \\\"张图\\\",        \\\"key3\\\": \\\"李木木\\\",        \\\"key4\\\": \\\"图文问诊\\\",        \\\"key5\\\": \\\"专家问诊\\\",        \\\"key6\\\": \\\"100\\\",        \\\"key7\\\": \\\"已支付\\\",        \\\"key8\\\": \\\"2022-01-10\\\"    },    {        \\\"key1\\\": \\\"2022-01-18 15:11:55\\\",        \\\"key2\\\": \\\"张图\\\",        \\\"key3\\\": \\\"李木木\\\",        \\\"key4\\\": \\\"图文问诊\\\",        \\\"key5\\\": \\\"专家问诊\\\",        \\\"key6\\\": \\\"100\\\",        \\\"key7\\\": \\\"已支付\\\",        \\\"key8\\\": \\\"2022-01-10\\\"    },    {        \\\"key1\\\": \\\"2022-01-18 15:11:55\\\",        \\\"key2\\\": \\\"张图\\\",        \\\"key3\\\": \\\"李木木\\\",        \\\"key4\\\": \\\"图文问诊\\\",        \\\"key5\\\": \\\"专家问诊\\\",        \\\"key6\\\": \\\"100\\\",        \\\"key7\\\": \\\"已支付\\\",        \\\"key8\\\": \\\"2022-01-10\\\"    },    {        \\\"key1\\\": \\\"2022-01-18 15:11:55\\\",        \\\"key2\\\": \\\"张图\\\",        \\\"key3\\\": \\\"李木木\\\",        \\\"key4\\\": \\\"图文问诊\\\",        \\\"key5\\\": \\\"专家问诊\\\",        \\\"key6\\\": \\\"100\\\",        \\\"key7\\\": \\\"已支付\\\",        \\\"key8\\\": \\\"2022-01-10\\\"    },    {        \\\"key1\\\": \\\"2022-01-18 15:11:55\\\",        \\\"key2\\\": \\\"张图\\\",        \\\"key3\\\": \\\"李木木\\\",        \\\"key4\\\": \\\"图文问诊\\\",        \\\"key5\\\": \\\"专家问诊\\\",        \\\"key6\\\": \\\"100\\\",        \\\"key7\\\": \\\"已支付\\\",        \\\"key8\\\": \\\"2022-01-10\\\"    }]\",\"size\":{\"width\":417,\"height\":214},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"oddRowBGC\":\"#07284B\",\"headShow\":true,\"hoverPause\":true,\"indexWidth\":80,\"index\":false,\"carousel\":\"single\",\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"evenRowBGC\":\"#06243D\",\"header\":[{\"width\":\"50\",\"label\":\"创建时间\"},{\"width\":100,\"label\":\"患者姓名\"},{\"width\":100,\"label\":\"接诊医生\"},{\"width\":100,\"label\":\"服务类型\"},{\"width\":100,\"label\":\"订单类型\"},{\"width\":100,\"label\":\"支付金额\"},{\"width\":100,\"label\":\"支付状态\"},{\"width\":100,\"label\":\"预约时间\"}],\"headerBGC\":\"#072F48\",\"headerHeight\":45,\"waitTime\":2000,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:44:52', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816327790907392', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":1918,\"height\":1077},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"1\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816327832850432', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":524.2374100719425,\"height\":289},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816327853821952', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":1911,\"height\":78},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"backgroundColor\":\"#4A4A4A00\",\"body\":{\"url\":\"https://jeecgdev.oss-cn-beijing.aliyuncs.com/upload/6头图片_1730965358518.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816327891570688', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":460,\"height\":320.8561151079137},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816327916736512', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":447,\"height\":321.47482014388487},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816327937708032', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":453,\"height\":245},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816327971262464', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":454,\"height\":286.61870503597123},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816327992233984', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":521,\"height\":325.8561151079137},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328042565632', NULL, '1011871598899679232', NULL, 'JBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"个体\\\",    \\\"value\\\": 2130,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"内资\\\",    \\\"value\\\": 1800,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"外资\\\",    \\\"value\\\": 1600,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"企业\\\",    \\\"value\\\": 2330,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"个人\\\",    \\\"value\\\": 1450,    \\\"type\\\": \\\"手机品牌\\\"  }]\",\"size\":{\"width\":444,\"height\":414},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"interval\":2}},\"grid\":{\"top\":90,\"bottom\":115,\"show\":false,\"containLabel\":true},\"series\":[{\"barWidth\":13,\"data\":[],\"itemStyle\":{\"color\":\"#00BABD\",\"borderRadius\":0},\"label\":{\"color\":\"#00BABD\",\"show\":true},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":false,\"text\":\"基础柱形图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328071925760', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"北京税务在线监控\",\"size\":{\"width\":666,\"height\":85.00000000000006},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"horseLamp\":false,\"body\":{\"color\":\"#13A6EF\",\"letterSpacing\":16,\"fontSize\":30,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":3},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328109674496', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"...........\",\"size\":{\"width\":137,\"height\":75.99999999999997},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#40AAFC\",\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328130646016', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":129.0000000000001,\"height\":61.99999999999994},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/导航框_1657782375184.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328151617536', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"【综合统计】\",\"size\":{\"width\":145,\"height\":95.00000000000006},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFB116\",\"fontSize\":22,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328185171968', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":125,\"height\":54.000000000000064},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/导航框_1657782375184.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328214532096', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":152.9999999999999,\"height\":58},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/导航框_1657782375184.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328252280832', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":156,\"height\":57.00000000000015},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/导航框_1657782375184.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328277446656', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":149,\"height\":52.99999999999994},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/导航框_1657782375184.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328311001088', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":159.9999999999999,\"height\":50.00000000000003},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/导航框_1657782375184.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328336166912', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":150.0000000000001,\"height\":53.99999999999997},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/导航框_1657782375184.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328352944128', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"三重一大\",\"size\":{\"width\":117,\"height\":68.99999999999989},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0FA9E2\",\"fontSize\":22,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:24', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328394887168', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"人事系统\",\"size\":{\"width\":173,\"height\":60.00000000000003},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0FA9E2\",\"fontSize\":22,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328411664384', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"投资管理\",\"size\":{\"width\":173.00000000000006,\"height\":53.99999999999983},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0FA9E2\",\"fontSize\":22,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328432635904', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"产权管理系统\",\"size\":{\"width\":147,\"height\":56.00000000000001},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0FA9E2\",\"fontSize\":22,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328457801728', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"责任追究系统\",\"size\":{\"width\":146,\"height\":54.00000000000007},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0FA9E2\",\"fontSize\":22,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328482967552', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"资金核算系统\",\"size\":{\"width\":164,\"height\":59.999999999999794},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0FA9E2\",\"fontSize\":22,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328512327680', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 大额支出情况\",\"size\":{\"width\":171,\"height\":53.99999999999997},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328533299200', NULL, '1011871598899679232', NULL, 'JPie', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[    {        \\\"name\\\": \\\"个体\\\",        \\\"value\\\": 210,        \\\"url\\\": \\\"http://jeecg.com\\\"    },    {        \\\"name\\\": \\\"外资\\\",        \\\"value\\\": 120,        \\\"url\\\": \\\"http://jeecg.com\\\"    },    {        \\\"name\\\": \\\"内资\\\",        \\\"value\\\": 110,        \\\"url\\\": \\\"http://jeecg.com\\\"    },    {        \\\"name\\\": \\\"个人\\\",        \\\"value\\\": 110,        \\\"url\\\": \\\"http://jeecg.com\\\"    }]\",\"size\":{\"width\":426,\"height\":267},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"customOption\":\"\",\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"orient\":\"vertical\",\"show\":false},\"series\":[{\"data\":[],\"name\":\"\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"}},\"label\":{\"color\":\"#EEF1FA\",\"show\":true},\"type\":\"pie\",\"radius\":\"50%\"}],\"pieLabelPosition\":\"outside\",\"tooltip\":{\"trigger\":\"item\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":false,\"text\":\"基础饼图\",\"textStyle\":{\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328550076416', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 外部监督线索统计\",\"size\":{\"width\":195.00000000000014,\"height\":50.99999999999994},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328587825152', NULL, '1011871598899679232', NULL, 'JBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"个体\\\",    \\\"value\\\": 160,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"内资\\\",    \\\"value\\\": 130,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"外资\\\",    \\\"value\\\": 190,    \\\"type\\\": \\\"手机品牌\\\"  }]\",\"size\":{\"width\":407,\"height\":360},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"interval\":2}},\"grid\":{\"top\":31,\"left\":8,\"bottom\":71,\"show\":false,\"containLabel\":true},\"series\":[{\"barWidth\":40,\"data\":[],\"itemStyle\":{\"color\":\"#FAD400\",\"borderRadius\":0},\"label\":{\"color\":\"#EEF1FA\",\"show\":true,\"fontSize\":14},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":false,\"text\":\"基础柱形图\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328608796672', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 债务风险统计\",\"size\":{\"width\":151.00000000000003,\"height\":49.000000000000014},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328629768192', NULL, '1011871598899679232', NULL, 'JBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"带息负债\\\",    \\\"value\\\": 1400,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"现金流负债\\\",    \\\"value\\\": 2100,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"速动比率\\\",    \\\"value\\\": 1300,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"流动比率\\\",    \\\"value\\\": 1660,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"资产负债率\\\",    \\\"value\\\": 1300,    \\\"type\\\": \\\"手机品牌\\\"  }]\",\"size\":{\"width\":517,\"height\":267.8129496402878},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#00CED1\"},\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"},\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#00CED1\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"nameTextStyle\":{\"color\":\"#00CED1\"}},\"grid\":{\"top\":29,\"left\":1,\"bottom\":27,\"show\":false,\"right\":8,\"containLabel\":true},\"series\":[{\"barWidth\":20,\"data\":[],\"itemStyle\":{\"color\":\"#00CED1\",\"borderRadius\":9},\"label\":{\"color\":\"#EEF1FA\"},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"show\":false,\"text\":\"基础柱形图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328667516928', NULL, '1011871598899679232', NULL, 'JBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"巡查发现\\\",    \\\"value\\\": 160,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"审计发现\\\",    \\\"value\\\": 520,    \\\"type\\\": \\\"手机品牌\\\"  },  {    \\\"name\\\": \\\"其他部门移送\\\",    \\\"value\\\": 190,    \\\"type\\\": \\\"手机品牌\\\"  }]\",\"size\":{\"width\":434.00000000000006,\"height\":246.99999999999994},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"interval\":2},\"show\":false},\"xAxis\":{\"axisLabel\":{\"color\":\"#1E90FF\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":14,\"left\":1,\"bottom\":29,\"show\":false,\"right\":10,\"containLabel\":true},\"series\":[{\"barWidth\":40,\"data\":[],\"itemStyle\":{\"color\":\"#90EE90\",\"borderRadius\":0},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":false,\"text\":\"基础柱形图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328684294144', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 内部监督线索统计\",\"size\":{\"width\":203.99999999999983,\"height\":59.99999999999996},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328701071360', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 投资分析\",\"size\":{\"width\":145.9999999999999,\"height\":72.99999999999997},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328738820096', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":44,\"height\":42},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/图1_1657782884131.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328755597312', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":45.999999999999986,\"height\":44.00000000000005},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/图2_1657782869186.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328768180224', NULL, '1011871598899679232', NULL, 'JImg', '{\"size\":{\"width\":37,\"height\":35},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":12,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/图3_1657782854545.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328801734656', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"新增投资(258)\",\"size\":{\"width\":133,\"height\":50},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":15,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328818511872', NULL, '1011871598899679232', NULL, 'JLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"value\\\": 50,    \\\"name\\\": \\\"个体\\\"  },  {    \\\"value\\\": 130,    \\\"name\\\": \\\"外资\\\"  },  {    \\\"value\\\": 60,    \\\"name\\\": \\\"内资\\\"  },  {    \\\"value\\\": 160,    \\\"name\\\": \\\"个人\\\"  },  {    \\\"value\\\": 90,    \\\"name\\\": \\\"企业\\\"  },  {    \\\"value\\\": 100,    \\\"name\\\": \\\"工商\\\"  }]\",\"size\":{\"width\":425,\"height\":204},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"customColor\":[{\"color\":\"#00FF00\"}],\"yAxis\":{\"axisLabel\":{\"color\":\"#00FF00\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#00FF00\"},\"show\":true},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#00FF00\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#00FF00\"}},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"},\"show\":true},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":21,\"left\":31,\"bottom\":48,\"show\":false,\"right\":1},\"series\":[{\"data\":[],\"lineType\":\"line\",\"itemStyle\":{\"color\":\"#64b5f6\"},\"type\":\"line\"}],\"tooltip\":{\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"subtext\":\"\",\"left\":10,\"show\":false,\"text\":\"基础折线图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328835289088', NULL, '1011871598899679232', NULL, 'JLiquid', '{\"chartData\":\"[  {    \\\"value\\\": 40  }]\",\"size\":{\"width\":209,\"height\":126},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":12,\"dataType\":1,\"h\":30,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"borderColor\":\"#FFD700\",\"color\":\"#FFD700\",\"distance\":2,\"borderWidth\":2,\"liquidType\":\"circle\",\"title\":{\"show\":true,\"text\":\"水波图\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"textColor\":\"#FFD700\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"strokeOpacity\":0}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328864649216', NULL, '1011871598899679232', NULL, 'JRose', '{\"chartData\":\"[  {    \\\"name\\\": \\\"外资\\\",    \\\"value\\\": 130,    \\\"url\\\": \\\"http://www.baidu.com\\\"  },  {    \\\"name\\\": \\\"内资\\\",    \\\"value\\\": 230,    \\\"url\\\": \\\"http://www.baidu.com\\\"  },  {    \\\"name\\\": \\\"个体工商户\\\",    \\\"value\\\": 140,    \\\"url\\\": \\\"http://www.baidu.com\\\"  }]\",\"size\":{\"width\":397,\"height\":206},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":12,\"dataType\":1,\"h\":30,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"option\":{\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"orient\":\"vertical\",\"show\":false},\"series\":[{\"data\":[],\"roseType\":\"radius\",\"name\":\"南丁格尔玫瑰\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"},\"label\":{\"color\":\"#FFFFFF\"}},\"label\":{\"color\":\"#EEF1FA\",\"show\":true},\"type\":\"pie\",\"radius\":\"50%\"}],\"tooltip\":{\"trigger\":\"item\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":false,\"text\":\"基础饼图\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328885620736', NULL, '1011871598899679232', NULL, 'JLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"value\\\": 50,    \\\"name\\\": \\\"个体\\\"  },  {    \\\"value\\\": 130,    \\\"name\\\": \\\"外资\\\"  },  {    \\\"value\\\": 60,    \\\"name\\\": \\\"内资\\\"  },  {    \\\"value\\\": 160,    \\\"name\\\": \\\"个人\\\"  },  {    \\\"value\\\": 90,    \\\"name\\\": \\\"企业\\\"  },  {    \\\"value\\\": 100,    \\\"name\\\": \\\"工商\\\"  }]\",\"size\":{\"width\":425.9496402877698,\"height\":241.4748201438849},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"top\":16,\"left\":31,\"bottom\":54,\"show\":false,\"right\":1},\"series\":[{\"data\":[],\"itemStyle\":{\"color\":\"#64b5f6\"},\"type\":\"line\"}],\"tooltip\":{\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"subtext\":\"\",\"left\":10,\"show\":false,\"text\":\"基础折线图\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328906592256', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 技术与科研队伍统计\",\"size\":{\"width\":252,\"height\":42.94964028776978},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328935952384', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":365,\"height\":334},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328956923904', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":370,\"height\":551.2877697841726},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328969506816', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":526.0503597122303,\"height\":248},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816328986284032', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":449,\"height\":277.61870503597123},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329019838464', NULL, '1011871598899679232', NULL, 'JLiquid', '{\"chartData\":\"[{\\\"value\\\":25}]\",\"size\":{\"width\":181.00000000000006,\"height\":136.99999999999997},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":6,\"dataType\":1,\"h\":30,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"textFontSize\":30,\"borderColor\":\"#1E90FF\",\"color\":\"#B0515C\",\"distance\":1,\"borderWidth\":2,\"liquidType\":\"circle\",\"count\":4,\"length\":128,\"title\":{\"show\":true,\"text\":\"水波图\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"textColor\":\"#FFFFFF\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"strokeOpacity\":0}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329036615680', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 资产质量统计\",\"size\":{\"width\":194,\"height\":31.0000000000001},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329057587200', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 告警统计\",\"size\":{\"width\":159,\"height\":52.00000000000011},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329095335936', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"已处理：3\",\"size\":{\"width\":133,\"height\":31.999999999999886},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":16,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329112113152', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"告警信息\",\"size\":{\"width\":125.00000000000003,\"height\":43.00000000000007},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#F8E71C00\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#F8E71C\",\"fontSize\":16,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329149861888', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"优化审批类\",\"size\":{\"width\":112.99999999999983,\"height\":75.00000000000009},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#7ED32100\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#B0515C\",\"fontSize\":16,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329166639104', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"未处理：1\",\"size\":{\"width\":103.00000000000003,\"height\":58.99999999999993},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":16,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329187610624', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"未处理：2\",\"size\":{\"width\":101,\"height\":55.999999999999915},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":16,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329221165056', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 企业布局结构统计\",\"size\":{\"width\":187,\"height\":44.99999999999998},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329246330880', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 人员统计\",\"size\":{\"width\":117.00000000000001,\"height\":48.999999999999886},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329263108096', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"▲ 经营投资损失情况统计\",\"size\":{\"width\":231.9999999999999,\"height\":36.00000000000006},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#3B9EEB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329292468224', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"暂缓投资(28)\",\"size\":{\"width\":133,\"height\":50},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":15,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329309245440', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"取消投资(25)\",\"size\":{\"width\":133,\"height\":50},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":15,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329330216960', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"新兴税务科创园项目\",\"size\":{\"width\":156,\"height\":50},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":15,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329363771392', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"智慧推广项目\",\"size\":{\"width\":133,\"height\":50},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":15,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329376354304', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"税务系统改造\",\"size\":{\"width\":133,\"height\":50},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":15,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329397325824', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"取消投资(25)\",\"size\":{\"width\":133,\"height\":50},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":15,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329430880256', NULL, '1011871598899679232', NULL, 'JDragBorder', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":459.8561151079137,\"height\":258},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":12,\"dataType\":1,\"h\":12,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329451851776', NULL, '1011871598899679232', NULL, 'JMultipleBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"个体\\\",    \\\"value\\\": 230,    \\\"type\\\": \\\"个体\\\"  },  {    \\\"name\\\": \\\"外资\\\",    \\\"value\\\": 656,    \\\"type\\\": \\\"个体\\\"  },  {    \\\"name\\\": \\\"内资\\\",    \\\"value\\\": 544,    \\\"type\\\": \\\"个体\\\"  },  {    \\\"name\\\": \\\"个体\\\",    \\\"value\\\": 110,    \\\"type\\\": \\\"外资\\\"  },  {    \\\"name\\\": \\\"外资\\\",    \\\"value\\\": 320,    \\\"type\\\": \\\"外资\\\"  },  {    \\\"name\\\": \\\"内资\\\",    \\\"value\\\": 160,    \\\"type\\\": \\\"外资\\\"  },  {    \\\"name\\\": \\\"个体\\\",    \\\"value\\\": 230,    \\\"type\\\": \\\"内资\\\"  },  {    \\\"name\\\": \\\"外资\\\",    \\\"value\\\": 160,    \\\"type\\\": \\\"内资\\\"  },  {    \\\"name\\\": \\\"内资\\\",    \\\"value\\\": 213,    \\\"type\\\": \\\"内资\\\"  }]\",\"size\":{\"width\":422,\"height\":216},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"}},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":5,\"containLabel\":true},\"series\":[{\"barWidth\":15,\"itemStyle\":{\"borderRadius\":22}}],\"legend\":{\"r\":20},\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329468628992', NULL, '1011871598899679232', NULL, 'JLiquid', '{\"chartData\":\"[  {    \\\"value\\\": 40  }]\",\"size\":{\"width\":239,\"height\":159},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"textFontSize\":30,\"borderColor\":\"#1E90FF\",\"color\":\"#F8E71C\",\"distance\":1,\"borderWidth\":2,\"liquidType\":\"circle\",\"count\":4,\"length\":128,\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"textColor\":\"#F8E71C\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"strokeOpacity\":0}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329497989120', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"损失事项\",\"size\":{\"width\":133,\"height\":50},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":15,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329514766336', NULL, '1011871598899679232', NULL, 'JLiquid', '{\"chartData\":\"[  {    \\\"value\\\": 40  }]\",\"size\":{\"width\":239,\"height\":159},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"textFontSize\":30,\"borderColor\":\"#1E90FF\",\"color\":\"#F8E71C\",\"distance\":1,\"borderWidth\":2,\"liquidType\":\"circle\",\"count\":4,\"length\":128,\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"textColor\":\"#F8E71C\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"strokeOpacity\":0}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329539932160', NULL, '1011871598899679232', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"挽回损失金\",\"size\":{\"width\":133,\"height\":50},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":12,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":15,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329569292288', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":372,\"height\":563.0503597122303},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329594458112', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":370,\"height\":342.8561151079137},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329615429632', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":530,\"height\":246.80575539568346},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329640595456', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":529,\"height\":289.52517985611513},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329665761280', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":525,\"height\":330.61870503597123},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329682538496', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":456,\"height\":284.1438848920863},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329711898624', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":459,\"height\":247.71223021582733},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329732870144', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":450.23741007194246,\"height\":330},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329758035968', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":457,\"height\":285.9064748201439},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329783201792', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":462.38129496402877,\"height\":262},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023816329799979008', NULL, '1011871598899679232', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":464,\"height\":323.568345323741},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/底1_1657188264377.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-12-03 14:47:25', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507021467648', NULL, '1011915958294990848', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"军地大数据驾驶舱\",\"size\":{\"width\":446.00000000000006,\"height\":73.99999999999997},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"letterSpacing\":12,\"fontSize\":30,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507063410688', NULL, '1011915958294990848', NULL, 'JRose', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"value\\\": 1048,    \\\"name\\\": \\\"海淀双拥办\\\"  },  {    \\\"value\\\": 1735,    \\\"name\\\": \\\"朝阳双拥办\\\"  },  {    \\\"value\\\": 780,    \\\"name\\\": \\\"昌平双拥办\\\"  },  {    \\\"value\\\": 484,    \\\"name\\\": \\\"西城双拥办\\\"  },  {    \\\"value\\\": 300,    \\\"name\\\": \\\"东城双拥办\\\"  }]\",\"size\":{\"width\":426,\"height\":268},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"customColor\":[{\"color\":\"#83BFF6\"},{\"color\":\"#D6AD33\"},{\"color\":\"#1F93FF\"},{\"color\":\"#F6903D\"},{\"color\":\"#61DDAA\"}],\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"orient\":\"vertical\",\"show\":false},\"series\":[{\"data\":[],\"roseType\":\"radius\",\"name\":\"南丁格尔玫瑰\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"},\"label\":{\"color\":\"#FFFFFF\"}},\"label\":{\"color\":\"#EEF1FA\",\"show\":true},\"type\":\"pie\",\"radius\":\"50%\"}],\"tooltip\":{\"trigger\":\"item\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":true,\"text\":\"本市各区问题解决数\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontSize\":16,\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507080187904', NULL, '1011915958294990848', NULL, 'JBubbleMap', '{\"borderColor\":\"#FFFFFF00\",\"commonOption\":{\"barSize\":10,\"gradientColor\":false,\"breadcrumb\":{\"drillDown\":false,\"textColor\":\"#000000\"},\"areaColor\":{\"color1\":\"#4F74E3\",\"color2\":\"#0A0909\"},\"barColor\":\"#fff176\",\"barColor2\":\"#fcc02e\",\"inRange\":{\"color\":[\"#04387b\",\"#467bc0\"]}},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"区域\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"jsConfig\":\"\",\"dataType\":1,\"h\":30,\"activeKey\":1,\"url\":\"http://api.jeecg.com/mock/33/radar\",\"timeOut\":0,\"chartData\":\"[{\\\"name\\\":\\\"北京\\\",\\\"value\\\":199},{\\\"name\\\":\\\"新疆\\\",\\\"value\\\":180},{\\\"name\\\":\\\"河南\\\",\\\"value\\\":137},{\\\"name\\\":\\\"四川\\\",\\\"value\\\":125},{\\\"name\\\":\\\"黑龙江\\\",\\\"value\\\":123},{\\\"name\\\":\\\"广东\\\",\\\"value\\\":123},{\\\"name\\\":\\\"山东\\\",\\\"value\\\":119},{\\\"name\\\":\\\"福建\\\",\\\"value\\\":116},{\\\"name\\\":\\\"湖北\\\",\\\"value\\\":116},{\\\"name\\\":\\\"浙江\\\",\\\"value\\\":114},{\\\"name\\\":\\\"湖南\\\",\\\"value\\\":114},{\\\"name\\\":\\\"安徽\\\",\\\"value\\\":109},{\\\"name\\\":\\\"河北\\\",\\\"value\\\":102},{\\\"name\\\":\\\"江苏\\\",\\\"value\\\":92},{\\\"name\\\":\\\"江西\\\",\\\"value\\\":91},{\\\"name\\\":\\\"重庆\\\",\\\"value\\\":91},{\\\"name\\\":\\\"云南\\\",\\\"value\\\":83},{\\\"name\\\":\\\"吉林\\\",\\\"value\\\":82},{\\\"name\\\":\\\"山西\\\",\\\"value\\\":81},{\\\"name\\\":\\\"陕西\\\",\\\"value\\\":80},{\\\"name\\\":\\\"辽宁\\\",\\\"value\\\":67},{\\\"name\\\":\\\"贵州\\\",\\\"value\\\":62},{\\\"name\\\":\\\"广西\\\",\\\"value\\\":59},{\\\"name\\\":\\\"甘肃\\\",\\\"value\\\":56},{\\\"name\\\":\\\"内蒙古\\\",\\\"value\\\":47},{\\\"name\\\":\\\"天津\\\",\\\"value\\\":42},{\\\"name\\\":\\\"上海\\\",\\\"value\\\":24},{\\\"name\\\":\\\"宁夏\\\",\\\"value\\\":18},{\\\"name\\\":\\\"海南\\\",\\\"value\\\":14},{\\\"name\\\":\\\"青海\\\",\\\"value\\\":10},{\\\"name\\\":\\\"西藏\\\",\\\"value\\\":9}]\",\"size\":{\"width\":635,\"height\":492},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"drillDown\":false,\"area\":{\"markerColor\":\"#DDE330\",\"shadowBlur\":10,\"markerCount\":5,\"markerOpacity\":1,\"name\":[\"中国\"],\"scatterLabelShow\":false,\"shadowColor\":\"#DDE330\",\"value\":[\"china\"],\"markerType\":\"effectScatter\"},\"geo\":{\"top\":30,\"itemStyle\":{\"normal\":{\"shadowOffsetX\":0,\"shadowOffsetY\":0,\"borderColor\":\"#93EBF8\",\"areaColor\":\"\",\"shadowBlur\":0,\"borderWidth\":1,\"shadowColor\":\"#80D9F8\"},\"emphasis\":{\"areaColor\":\"#FFF59C\",\"borderWidth\":0}},\"zoom\":1,\"label\":{\"emphasis\":{\"color\":\"#fff\",\"show\":false}},\"roam\":true},\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"data\":[]},\"title\":{\"left\":10,\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"graphic\":[],\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"visualMap\":{\"min\":0,\"top\":\"bottom\",\"max\":200,\"left\":\"5%\",\"calculable\":true,\"show\":false,\"type\":\"continuous\",\"seriesIndex\":[1]}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507101159424', NULL, '1011915958294990848', NULL, 'JCurrentTime', '{\"chartData\":\"\",\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":465,\"height\":60},\"background\":\"#15E85800\",\"w\":6,\"dataType\":1,\"h\":6,\"turnConfig\":{\"url\":\"\"},\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"showWeek\":\"show\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507117936640', NULL, '1011915958294990848', NULL, 'JImg', '{\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":560,\"height\":512},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"rotateTime\":5000,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/1_1657182043024.png\"},\"opacity\":1,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":true}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507130519552', NULL, '1011915958294990848', NULL, 'JMultipleBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"日常问题\\\",    \\\"value\\\": 131,    \\\"type\\\": \\\"地方双清单\\\"  },  {    \\\"name\\\": \\\"热点问题\\\",    \\\"value\\\": 320,    \\\"type\\\": \\\"地方双清单\\\"  },  {    \\\"name\\\": \\\"堵点问题\\\",    \\\"value\\\": 250,    \\\"type\\\": \\\"地方双清单\\\"  },  {    \\\"name\\\": \\\"日常问题\\\",    \\\"value\\\": 210,    \\\"type\\\": \\\"军队双清单\\\"  },  {    \\\"name\\\": \\\"热点问题\\\",    \\\"value\\\": 340,    \\\"type\\\": \\\"军队双清单\\\"  },  {    \\\"name\\\": \\\"堵点问题\\\",    \\\"value\\\": 230,    \\\"type\\\": \\\"军队双清单\\\"  }]\",\"size\":{\"width\":536,\"height\":328},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"customColor\":[{\"color\":\"#C039DB\"},{\"color\":\"#DE374B\"}],\"yAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"},\"show\":false},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"show\":true,\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"},\"show\":false},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":51,\"left\":32,\"bottom\":38,\"right\":1},\"series\":[{\"barWidth\":23,\"itemStyle\":{\"borderRadius\":19}}],\"legend\":{\"t\":1},\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"top\":0,\"left\":162,\"show\":true,\"text\":\"热点堵点分析\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507138908160', NULL, '1011915958294990848', NULL, 'JMultipleLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"6月\\\",    \\\"value\\\": 200,    \\\"type\\\": \\\"军队双清单任务\\\"  },  {    \\\"name\\\": \\\"7月\\\",    \\\"value\\\": 330,    \\\"type\\\": \\\"军队双清单任务\\\"  },  {    \\\"name\\\": \\\"8月\\\",    \\\"value\\\": 345,    \\\"type\\\": \\\"军队双清单任务\\\"  },  {    \\\"name\\\": \\\"9月\\\",    \\\"value\\\": 150,    \\\"type\\\": \\\"军队双清单任务\\\"  },  {    \\\"name\\\": \\\"10月\\\",    \\\"value\\\": 860,    \\\"type\\\": \\\"军队双清单任务\\\"  },  {    \\\"name\\\": \\\"11月\\\",    \\\"value\\\": 346,    \\\"type\\\": \\\"军队双清单任务\\\"  },  {    \\\"name\\\": \\\"12月\\\",    \\\"value\\\": 147,    \\\"type\\\": \\\"军队双清单任务\\\"  },  {    \\\"name\\\": \\\"6月\\\",    \\\"value\\\": 129,    \\\"type\\\": \\\"地方双清单任务\\\"  },  {    \\\"name\\\": \\\"7月\\\",    \\\"value\\\": 443,    \\\"type\\\": \\\"地方双清单任务\\\"  },  {    \\\"name\\\": \\\"8月\\\",    \\\"value\\\": 236,    \\\"type\\\": \\\"地方双清单任务\\\"  },  {    \\\"name\\\": \\\"9月\\\",    \\\"value\\\": 148,    \\\"type\\\": \\\"地方双清单任务\\\"  },  {    \\\"name\\\": \\\"10月\\\",    \\\"value\\\": 347,    \\\"type\\\": \\\"地方双清单任务\\\"  },  {    \\\"name\\\": \\\"11月\\\",    \\\"value\\\": 540,    \\\"type\\\": \\\"地方双清单任务\\\"  },  {    \\\"name\\\": \\\"12月\\\",    \\\"value\\\": 140,    \\\"type\\\": \\\"地方双清单任务\\\"  }]\",\"size\":{\"width\":519,\"height\":305},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"},\"show\":false},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#BD0C5E\"},{\"color\":\"#08A2DF\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":63,\"left\":38,\"bottom\":46,\"right\":8},\"series\":[{\"symbolSize\":6,\"lineType\":\"smooth\",\"label\":{\"color\":\"#EEF1FA\"},\"lineWidth\":3}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"show\":true,\"text\":\"完成效率分析（天/个）\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507151491072', NULL, '1011915958294990848', NULL, 'JMultipleBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"海淀区\\\",    \\\"value\\\": 53,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"朝阳区\\\",    \\\"value\\\": 52,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"大兴区\\\",    \\\"value\\\": 31,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"怀柔区\\\",    \\\"value\\\": 29,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"密云区\\\",    \\\"value\\\": 18,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"平谷区\\\",    \\\"value\\\": 16,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"顺义区\\\",    \\\"value\\\": 24,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"通州区\\\",    \\\"value\\\": 12,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"昌平区\\\",    \\\"value\\\": 29,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"东城区\\\",    \\\"value\\\": 28,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"西城区\\\",    \\\"value\\\": 23,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"门头沟\\\",    \\\"value\\\": 17,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"石景山\\\",    \\\"value\\\": 54,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"丰台区\\\",    \\\"value\\\": 14,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"房山区\\\",    \\\"value\\\": 25,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"延庆县\\\",    \\\"value\\\": 23,    \\\"type\\\": \\\"拥军支前工作\\\"  },  {    \\\"name\\\": \\\"海淀区\\\",    \\\"value\\\": 54,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"朝阳区\\\",    \\\"value\\\": 43,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"大兴区\\\",    \\\"value\\\": 27,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"怀柔区\\\",    \\\"value\\\": 24,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"密云区\\\",    \\\"value\\\": 13,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"平谷区\\\",    \\\"value\\\": 22,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"顺义区\\\",    \\\"value\\\": 25,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"通州区\\\",    \\\"value\\\": 22,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"昌平区\\\",    \\\"value\\\": 19,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"东城区\\\",    \\\"value\\\": 25,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"西城区\\\",    \\\"value\\\": 23,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"门头沟\\\",    \\\"value\\\": 22,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"石景山\\\",    \\\"value\\\": 13,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"丰台区\\\",    \\\"value\\\": 24,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"房山区\\\",    \\\"value\\\": 25,    \\\"type\\\": \\\"走访慰问部队\\\"  },  {    \\\"name\\\": \\\"延庆县\\\",    \\\"value\\\": 23,    \\\"type\\\": \\\"走访慰问部队\\\"  }]\",\"size\":{\"width\":1259,\"height\":286},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"customColor\":[{\"color\":\"#C039DB\"},{\"color\":\"#DE374B\"}],\"yAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"},\"show\":false},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"show\":true,\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"},\"show\":false},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":90,\"left\":40,\"bottom\":50,\"right\":15},\"series\":[{\"barWidth\":19,\"itemStyle\":{\"borderRadius\":7}}],\"legend\":{\"t\":16,\"show\":true},\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"top\":0,\"left\":124,\"show\":true,\"text\":\"支持部队建设资金分析（单位：百万）\",\"textStyle\":{\"color\":\"#ED1111\",\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507180851200', NULL, '1011915958294990848', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"机构排名\",\"size\":{\"width\":99.00000000000006,\"height\":36.99999999999996},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507189239808', NULL, '1011915958294990848', NULL, 'JScrollBoard', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  [    \\\"西城双拥办\\\",    \\\"130/145\\\",    \\\"138/145\\\"  ],  [    \\\"东城双拥办\\\",    \\\"108/145\\\",    \\\"108/145\\\"  ],  [    \\\"海淀双拥办\\\",    \\\"101/140\\\",    \\\"101/140\\\"  ],  [    \\\"朝阳双拥办\\\",    \\\"100/140\\\",    \\\"100/140\\\"  ],  [    \\\"昌平双拥办\\\",    \\\"105/135\\\",    \\\"105/135\\\"  ],  [    \\\"怀柔双拥办\\\",    \\\"102/130\\\",    \\\"102/130\\\"  ],  [    \\\"密云双拥办\\\",    \\\"100/130\\\",    \\\"100/130\\\"  ],  [    \\\"通州双拥办\\\",    \\\"99/120\\\",    \\\"99/120\\\"  ],  [    \\\"大兴双拥办\\\",    \\\"98/118\\\",    \\\"98/118\\\"  ]]\",\"size\":{\"width\":510,\"height\":295},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"oddRowBGC\":\"#0D1731\",\"headShow\":true,\"hoverPause\":true,\"indexWidth\":80,\"index\":true,\"carousel\":\"single\",\"title\":{\"show\":true,\"text\":\"轮播表\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"evenRowBGC\":\"#11274C\",\"header\":[{\"width\":100,\"label\":\"地区\"},{\"width\":100,\"label\":\"军队问题解决\"},{\"width\":100,\"label\":\"地方问题解决\"}],\"headerBGC\":\"#0D1731\",\"headerHeight\":70,\"waitTime\":2000,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507201822720', NULL, '1011915958294990848', NULL, 'JRadar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/radar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"value\\\": 75,    \\\"name\\\": \\\"地方志愿者\\\",    \\\"type\\\": \\\"NBA\\\",    \\\"max\\\": 100  },  {    \\\"value\\\": 65,    \\\"name\\\": \\\"军外人才\\\",    \\\"type\\\": \\\"NBA\\\",    \\\"max\\\": 100  },  {    \\\"value\\\": 55,    \\\"name\\\": \\\"军供站资源\\\",    \\\"type\\\": \\\"NBA\\\",    \\\"max\\\": 100  },  {    \\\"value\\\": 74,    \\\"name\\\": \\\"拥军物资\\\",    \\\"type\\\": \\\"NBA\\\",    \\\"max\\\": 100  },  {    \\\"value\\\": 38,    \\\"name\\\": \\\"民用运力\\\",    \\\"type\\\": \\\"NBA\\\",    \\\"max\\\": 100  },  {    \\\"value\\\": 88,    \\\"name\\\": \\\"人防工程\\\",    \\\"type\\\": \\\"NBA\\\",    \\\"max\\\": 100  }]\",\"size\":{\"width\":540,\"height\":326},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"radar\":[{\"indicator\":[]}],\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"data\":[],\"show\":false},\"series\":[{\"data\":[],\"type\":\"radar\"}],\"tooltip\":{\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"subtext\":\"最近一个月\",\"left\":296,\"show\":true,\"text\":\"拥军资源力度分析\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507214405632', NULL, '1011915958294990848', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"拥军资源投入情况\",\"size\":{\"width\":171.00000000000006,\"height\":36.99999999999996},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507222794240', NULL, '1011915958294990848', NULL, 'JRingProgress', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":200,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"name\\\": \\\"陆运支持\\\",    \\\"value\\\": 67  }]\",\"size\":{\"width\":245,\"height\":150},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"color\":\"#61DDAA\",\"bgColor\":\"#E8EDF3\",\"fontSize\":18,\"lineHeight\":0,\"radius\":0.9,\"innerRadius\":0.9,\"fontColor\":\"#FFFFFF\"}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507247960064', NULL, '1011915958294990848', NULL, 'JRingProgress', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":200,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"name\\\": \\\"空运支持\\\",    \\\"value\\\": 92  }]\",\"size\":{\"width\":206,\"height\":145},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"color\":\"#8B49BB\",\"bgColor\":\"#E8EDF3\",\"fontSize\":18,\"lineHeight\":0,\"radius\":0.9,\"innerRadius\":0.9,\"fontColor\":\"#FFFFFF\"}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507260542976', NULL, '1011915958294990848', NULL, 'JRingProgress', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":200,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"name\\\": \\\"海运支持\\\",    \\\"value\\\": 94  }]\",\"size\":{\"width\":206,\"height\":145},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"color\":\"#D6AD33\",\"bgColor\":\"#E8EDF3\",\"fontSize\":18,\"lineHeight\":0,\"radius\":0.9,\"innerRadius\":0.9,\"fontColor\":\"#FFFFFF\"}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507273125888', NULL, '1011915958294990848', NULL, 'JRingProgress', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":200,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"name\\\": \\\"防疫物资支持\\\",    \\\"value\\\": 50  }]\",\"size\":{\"width\":225,\"height\":148},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"color\":\"#6755FB\",\"bgColor\":\"#E8EDF3\",\"fontSize\":18,\"lineHeight\":0,\"radius\":0.9,\"innerRadius\":0.9,\"fontColor\":\"#FFFFFF\"}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507281514496', NULL, '1011915958294990848', NULL, 'JRingProgress', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":200,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"name\\\": \\\"慰问物资支持\\\",    \\\"value\\\": 40  }]\",\"size\":{\"width\":228,\"height\":145},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"color\":\"#F6903D\",\"bgColor\":\"#E8EDF3\",\"fontSize\":18,\"lineHeight\":0,\"radius\":0.9,\"innerRadius\":0.9,\"fontColor\":\"#FFFFFF\"}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507294097408', NULL, '1011915958294990848', NULL, 'JRingProgress', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":200,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"name\\\": \\\"医疗物资支持\\\",    \\\"value\\\": 70  }]\",\"size\":{\"width\":267,\"height\":145},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"color\":\"#A82A5A\",\"bgColor\":\"#E8EDF3\",\"fontSize\":18,\"lineHeight\":0,\"radius\":0.9,\"innerRadius\":0.9,\"fontColor\":\"#FFFFFF\"}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507319263232', NULL, '1011915958294990848', NULL, 'JProgress', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":100,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"name\\\": \\\"军队问题解决\\\",    \\\"value\\\": 89  }]\",\"size\":{\"width\":330,\"height\":55},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#FFFFFF\",\"fontSize\":16}},\"grid\":{\"top\":0,\"left\":0,\"bottom\":0,\"show\":false,\"right\":55,\"containLabel\":true},\"series\":[{\"barWidth\":19,\"color\":\"#F5A623\",\"itemStyle\":{\"normal\":{\"barBorderRadius\":10}},\"zlevel\":1,\"label\":{\"formatter\":\"{c}%\",\"color\":\"black\",\"show\":false,\"fontSize\":24,\"position\":\"left\"},\"realtimeSort\":true},{\"barWidth\":19,\"color\":\"#EEEEEE\",\"barGap\":\"-100%\",\"itemStyle\":{\"normal\":{\"barBorderRadius\":10}},\"label\":{\"formatter\":\"{c}\",\"color\":\"#FFFFFF\",\"show\":true,\"fontSize\":18,\"position\":\"right\",\"valueAnimation\":true},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"none\"},\"trigger\":\"axis\"},\"title\":{\"show\":false,\"text\":\"\",\"textStyle\":{\"color\":\"#EEF1FA\"}}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1023811507331846144', NULL, '1011915958294990848', NULL, 'JProgress', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":100,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"name\\\": \\\"地方问题解决\\\",    \\\"value\\\": 75  }]\",\"size\":{\"width\":330,\"height\":55},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#FFFFFF\",\"fontSize\":16}},\"grid\":{\"top\":0,\"left\":0,\"bottom\":0,\"show\":false,\"right\":55,\"containLabel\":true},\"series\":[{\"barWidth\":19,\"color\":\"#BD10E0\",\"itemStyle\":{\"normal\":{\"barBorderRadius\":10}},\"zlevel\":1,\"label\":{\"formatter\":\"{c}%\",\"color\":\"black\",\"show\":false,\"fontSize\":24,\"position\":\"left\"},\"realtimeSort\":true},{\"barWidth\":19,\"color\":\"#EEEEEE\",\"barGap\":\"-100%\",\"itemStyle\":{\"normal\":{\"barBorderRadius\":10}},\"label\":{\"formatter\":\"{c}\",\"color\":\"#FFFFFF\",\"show\":true,\"fontSize\":18,\"position\":\"right\",\"valueAnimation\":true},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"none\"},\"trigger\":\"axis\"},\"title\":{\"show\":false,\"text\":\"\",\"textStyle\":{\"color\":\"#EEF1FA\"}}}}', 'admin', '2024-12-03 14:28:15', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681378529280', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":695,\"height\":459},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681424666624', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":690,\"height\":385},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681441443840', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":543,\"height\":385},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681454026752', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":543,\"height\":455},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681470803968', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":688,\"height\":385},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681495969792', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":350,\"height\":385},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681512747008', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":360.0035587188612,\"height\":385},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681525329920', NULL, '1016994145836257280', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"个性化组件大阅兵\",\"size\":{\"width\":588,\"height\":71},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FAD400\",\"letterSpacing\":10,\"fontSize\":50,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681588244480', NULL, '1016994145836257280', NULL, 'JFlashCloud', '{\"chartData\":\"[    {        \\\"name\\\": \\\"欧莱雅\\\",        \\\"value\\\": 11638    },    {        \\\"name\\\": \\\"iPhone X\\\",        \\\"value\\\": 19651    },    {        \\\"name\\\": \\\"淘宝\\\",        \\\"value\\\": 3306    },    {        \\\"name\\\": \\\"oppo\\\",        \\\"value\\\": 6666    },    {        \\\"name\\\": \\\"小米\\\",        \\\"value\\\": 37410    },    {        \\\"name\\\": \\\"京东\\\",        \\\"value\\\": 3241    },    {        \\\"name\\\": \\\"抖音\\\",        \\\"value\\\": 2860    },    {        \\\"name\\\": \\\"天猫\\\",        \\\"value\\\": 1234    },    {        \\\"name\\\": \\\"百度\\\",        \\\"value\\\": 1756    },    {        \\\"name\\\": \\\"三星\\\",        \\\"value\\\": 4444    },    {        \\\"name\\\": \\\"Mac Pro\\\",        \\\"value\\\": 18341    },    {        \\\"name\\\": \\\"玛莎拉\\\",        \\\"value\\\": 10608    },    {        \\\"name\\\": \\\"小米手机\\\",        \\\"value\\\": 12550    },    {        \\\"name\\\": \\\"特斯拉\\\",        \\\"value\\\": 8298    },    {        \\\"name\\\": \\\"华为P20\\\",        \\\"value\\\": 17319    },    {        \\\"name\\\": \\\"华为\\\",        \\\"value\\\": 12000    },    {        \\\"name\\\": \\\"快手\\\",        \\\"value\\\": 3175    }]\",\"size\":{\"width\":321,\"height\":333},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"textSize\":14,\"zoom\":1,\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"textColor\":\"#fff\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681609216000', NULL, '1016994145836257280', NULL, 'JGender', '{\"chartData\":\"[{\\\"man\\\":50,\\\"woman\\\":35}]\",\"size\":{\"width\":341,\"height\":284},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"男\"},{\"mapping\":\"\",\"filed\":\"女\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/26/pictogram\",\"timeOut\":0,\"option\":{\"grid\":{\"bottom\":115},\"series\":[],\"title\":{\"show\":true,\"text\":\"\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681621798912', NULL, '1016994145836257280', NULL, 'JWeatherForecast', '{\"size\":{\"width\":257,\"height\":47},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":257,\"dataType\":1,\"h\":47,\"option\":{\"template\":94,\"bgColor\":\"\",\"city\":\"\",\"num\":2,\"fontSize\":16,\"fontColor\":\"#fff\",\"url\":\"\"}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681634381824', NULL, '1016994145836257280', NULL, 'JNegativeBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[{\\\"name\\\":\\\"周一\\\",\\\"value\\\":200,\\\"type\\\":\\\"利润\\\"},{\\\"name\\\":\\\"周二\\\",\\\"value\\\":170,\\\"type\\\":\\\"利润\\\"},{\\\"name\\\":\\\"周三\\\",\\\"value\\\":240,\\\"type\\\":\\\"利润\\\"},{\\\"name\\\":\\\"周四\\\",\\\"value\\\":244,\\\"type\\\":\\\"利润\\\"},{\\\"name\\\":\\\"周五\\\",\\\"value\\\":200,\\\"type\\\":\\\"利润\\\"},{\\\"name\\\":\\\"周六\\\",\\\"value\\\":220,\\\"type\\\":\\\"利润\\\"},{\\\"name\\\":\\\"周日\\\",\\\"value\\\":210,\\\"type\\\":\\\"利润\\\"},{\\\"name\\\":\\\"周一\\\",\\\"value\\\":320,\\\"type\\\":\\\"收入\\\"},{\\\"name\\\":\\\"周二\\\",\\\"value\\\":302,\\\"type\\\":\\\"收入\\\"},{\\\"name\\\":\\\"周三\\\",\\\"value\\\":341,\\\"type\\\":\\\"收入\\\"},{\\\"name\\\":\\\"周四\\\",\\\"value\\\":374,\\\"type\\\":\\\"收入\\\"},{\\\"name\\\":\\\"周五\\\",\\\"value\\\":390,\\\"type\\\":\\\"收入\\\"},{\\\"name\\\":\\\"周六\\\",\\\"value\\\":450,\\\"type\\\":\\\"收入\\\"},{\\\"name\\\":\\\"周日\\\",\\\"value\\\":420,\\\"type\\\":\\\"收入\\\"},{\\\"name\\\":\\\"周一\\\",\\\"value\\\":-120,\\\"type\\\":\\\"支出\\\"},{\\\"name\\\":\\\"周二\\\",\\\"value\\\":-132,\\\"type\\\":\\\"支出\\\"},{\\\"name\\\":\\\"周三\\\",\\\"value\\\":-101,\\\"type\\\":\\\"支出\\\"},{\\\"name\\\":\\\"周四\\\",\\\"value\\\":-134,\\\"type\\\":\\\"支出\\\"},{\\\"name\\\":\\\"周五\\\",\\\"value\\\":-190,\\\"type\\\":\\\"支出\\\"},{\\\"name\\\":\\\"周六\\\",\\\"value\\\":-230,\\\"type\\\":\\\"支出\\\"},{\\\"name\\\":\\\"周日\\\",\\\"value\\\":-210,\\\"type\\\":\\\"支出\\\"}]\",\"size\":{\"width\":515,\"height\":429},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"interval\":2}},\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"type\":\"value\"},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":40,\"containLabel\":true},\"series\":[],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681655353344', NULL, '1016994145836257280', NULL, 'JFlashList', '{\"chartData\":\"[{\\\"name\\\":\\\"苹果\\\",\\\"value\\\":1000,\\\"type\\\":\\\"手机品牌\\\"},{\\\"name\\\":\\\"三星\\\",\\\"value\\\":34008,\\\"type\\\":\\\"手机品牌\\\"},{\\\"name\\\":\\\"小米\\\",\\\"value\\\":2300,\\\"type\\\":\\\"手机品牌\\\"},{\\\"name\\\":\\\"oppo\\\",\\\"value\\\":5400,\\\"type\\\":\\\"手机品牌\\\"},{\\\"name\\\":\\\"vivo\\\",\\\"value\\\":3400,\\\"type\\\":\\\"手机品牌\\\"}]\",\"size\":{\"width\":498,\"height\":300},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":540,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"itemColor\":\"#00C2FF\",\"titleColor\":\"#00C2FF\",\"numberColor\":\"#00C2FF\",\"numberSize\":16,\"animateType\":\"zoomInUp\",\"titleShow\":true,\"zoom\":1,\"titleSize\":16,\"title\":\"排名统计\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681676324864', NULL, '1016994145836257280', NULL, 'JPictorialBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/pictogram\",\"timeOut\":0,\"chartData\":\"[{\\\"name\\\":\\\"驯鹿\\\",\\\"value\\\":123,\\\"symbol\\\":\\\"path://M-22.788,24.521c2.08-0.986,3.611-3.905,4.984-5.892 c-2.686,2.782-5.047,5.884-9.102,7.312c-0.992,0.005-0.25-2.016,0.34-2.362l1.852-0.41c0.564-0.218,0.785-0.842,0.902-1.347 c2.133-0.727,4.91-4.129,6.031-6.194c1.748-0.7,4.443-0.679,5.734-2.293c1.176-1.468,0.393-3.992,1.215-6.557 c0.24-0.754,0.574-1.581,1.008-2.293c-0.611,0.011-1.348-0.061-1.959-0.608c-1.391-1.245-0.785-2.086-1.297-3.313 c1.684,0.744,2.5,2.584,4.426,2.586C-8.46,3.012-8.255,2.901-8.04,2.824c6.031-1.952,15.182-0.165,19.498-3.937 c1.15-3.933-1.24-9.846-1.229-9.938c0.008-0.062-1.314-0.004-1.803-0.258c-1.119-0.771-6.531-3.75-0.17-3.33 c0.314-0.045,0.943,0.259,1.439,0.435c-0.289-1.694-0.92-0.144-3.311-1.946c0,0-1.1-0.855-1.764-1.98 c-0.836-1.09-2.01-2.825-2.992-4.031c-1.523-2.476,1.367,0.709,1.816,1.108c1.768,1.704,1.844,3.281,3.232,3.983 c0.195,0.203,1.453,0.164,0.926-0.468c-0.525-0.632-1.367-1.278-1.775-2.341c-0.293-0.703-1.311-2.326-1.566-2.711 c-0.256-0.384-0.959-1.718-1.67-2.351c-1.047-1.187-0.268-0.902,0.521-0.07c0.789,0.834,1.537,1.821,1.672,2.023 c0.135,0.203,1.584,2.521,1.725,2.387c0.102-0.259-0.035-0.428-0.158-0.852c-0.125-0.423-0.912-2.032-0.961-2.083 c-0.357-0.852-0.566-1.908-0.598-3.333c0.4-2.375,0.648-2.486,0.549-0.705c0.014,1.143,0.031,2.215,0.602,3.247 c0.807,1.496,1.764,4.064,1.836,4.474c0.561,3.176,2.904,1.749,2.281-0.126c-0.068-0.446-0.109-2.014-0.287-2.862 c-0.18-0.849-0.219-1.688-0.113-3.056c0.066-1.389,0.232-2.055,0.277-2.299c0.285-1.023,0.4-1.088,0.408,0.135 c-0.059,0.399-0.131,1.687-0.125,2.655c0.064,0.642-0.043,1.768,0.172,2.486c0.654,1.928-0.027,3.496,1,3.514 c1.805-0.424,2.428-1.218,2.428-2.346c-0.086-0.704-0.121-0.843-0.031-1.193c0.221-0.568,0.359-0.67,0.312-0.076 c-0.055,0.287,0.031,0.533,0.082,0.794c0.264,1.197,0.912,0.114,1.283-0.782c0.15-0.238,0.539-2.154,0.545-2.522 c-0.023-0.617,0.285-0.645,0.309,0.01c0.064,0.422-0.248,2.646-0.205,2.334c-0.338,1.24-1.105,3.402-3.379,4.712 c-0.389,0.12-1.186,1.286-3.328,2.178c0,0,1.729,0.321,3.156,0.246c1.102-0.19,3.707-0.027,4.654,0.269 c1.752,0.494,1.531-0.053,4.084,0.164c2.26-0.4,2.154,2.391-1.496,3.68c-2.549,1.405-3.107,1.475-2.293,2.984 c3.484,7.906,2.865,13.183,2.193,16.466c2.41,0.271,5.732-0.62,7.301,0.725c0.506,0.333,0.648,1.866-0.457,2.86 c-4.105,2.745-9.283,7.022-13.904,7.662c-0.977-0.194,0.156-2.025,0.803-2.247l1.898-0.03c0.596-0.101,0.936-0.669,1.152-1.139 c3.16-0.404,5.045-3.775,8.246-4.818c-4.035-0.718-9.588,3.981-12.162,1.051c-5.043,1.423-11.449,1.84-15.895,1.111 c-3.105,2.687-7.934,4.021-12.115,5.866c-3.271,3.511-5.188,8.086-9.967,10.414c-0.986,0.119-0.48-1.974,0.066-2.385l1.795-0.618 C-22.995,25.682-22.849,25.035-22.788,24.521z\\\",\\\"symbolSize\\\":[60,60]},{\\\"name\\\":\\\"飞机\\\",\\\"value\\\":60,\\\"symbol\\\":\\\"path://M1.112,32.559l2.998,1.205l-2.882,2.268l-2.215-0.012L1.112,32.559z M37.803,23.96 c0.158-0.838,0.5-1.509,0.961-1.904c-0.096-0.037-0.205-0.071-0.344-0.071c-0.777-0.005-2.068-0.009-3.047-0.009 c-0.633,0-1.217,0.066-1.754,0.18l2.199,1.804H37.803z M39.738,23.036c-0.111,0-0.377,0.325-0.537,0.924h1.076 C40.115,23.361,39.854,23.036,39.738,23.036z M39.934,39.867c-0.166,0-0.674,0.705-0.674,1.986s0.506,1.986,0.674,1.986 s0.672-0.705,0.672-1.986S40.102,39.867,39.934,39.867z M38.963,38.889c-0.098-0.038-0.209-0.07-0.348-0.073 c-0.082,0-0.174,0-0.268-0.001l-7.127,4.671c0.879,0.821,2.42,1.417,4.348,1.417c0.979,0,2.27-0.006,3.047-0.01 c0.139,0,0.25-0.034,0.348-0.072c-0.646-0.555-1.07-1.643-1.07-2.967C37.891,40.529,38.316,39.441,38.963,38.889z M32.713,23.96 l-12.37-10.116l-4.693-0.004c0,0,4,8.222,4.827,10.121H32.713z M59.311,32.374c-0.248,2.104-5.305,3.172-8.018,3.172H39.629 l-25.325,16.61L9.607,52.16c0,0,6.687-8.479,7.95-10.207c1.17-1.6,3.019-3.699,3.027-6.407h-2.138 c-5.839,0-13.816-3.789-18.472-5.583c-2.818-1.085-2.396-4.04-0.031-4.04h0.039l-3.299-11.371h3.617c0,0,4.352,5.696,5.846,7.5 c2,2.416,4.503,3.678,8.228,3.87h30.727c2.17,0,4.311,0.417,6.252,1.046c3.49,1.175,5.863,2.7,7.199,4.027 C59.145,31.584,59.352,32.025,59.311,32.374z M22.069,30.408c0-0.815-0.661-1.475-1.469-1.475c-0.812,0-1.471,0.66-1.471,1.475 s0.658,1.475,1.471,1.475C21.408,31.883,22.069,31.224,22.069,30.408z M27.06,30.408c0-0.815-0.656-1.478-1.466-1.478 c-0.812,0-1.471,0.662-1.471,1.478s0.658,1.477,1.471,1.477C26.404,31.885,27.06,31.224,27.06,30.408z M32.055,30.408 c0-0.815-0.66-1.475-1.469-1.475c-0.808,0-1.466,0.66-1.466,1.475s0.658,1.475,1.466,1.475 C31.398,31.883,32.055,31.224,32.055,30.408z M37.049,30.408c0-0.815-0.658-1.478-1.467-1.478c-0.812,0-1.469,0.662-1.469,1.478 s0.656,1.477,1.469,1.477C36.389,31.885,37.049,31.224,37.049,30.408z M42.039,30.408c0-0.815-0.656-1.478-1.465-1.478 c-0.811,0-1.469,0.662-1.469,1.478s0.658,1.477,1.469,1.477C41.383,31.885,42.039,31.224,42.039,30.408z M55.479,30.565 c-0.701-0.436-1.568-0.896-2.627-1.347c-0.613,0.289-1.551,0.476-2.73,0.476c-1.527,0-1.639,2.263,0.164,2.316 C52.389,32.074,54.627,31.373,55.479,30.565z\\\",\\\"symbolSize\\\":[65,35]},{\\\"name\\\":\\\"火箭\\\",\\\"value\\\":25,\\\"symbol\\\":\\\"path://M-244.396,44.399c0,0,0.47-2.931-2.427-6.512c2.819-8.221,3.21-15.709,3.21-15.709s5.795,1.383,5.795,7.325C-237.818,39.679-244.396,44.399-244.396,44.399z M-260.371,40.827c0,0-3.881-12.946-3.881-18.319c0-2.416,0.262-4.566,0.669-6.517h17.684c0.411,1.952,0.675,4.104,0.675,6.519c0,5.291-3.87,18.317-3.87,18.317H-260.371z M-254.745,18.951c-1.99,0-3.603,1.676-3.603,3.744c0,2.068,1.612,3.744,3.603,3.744c1.988,0,3.602-1.676,3.602-3.744S-252.757,18.951-254.745,18.951z M-255.521,2.228v-5.098h1.402v4.969c1.603,1.213,5.941,5.069,7.901,12.5h-17.05C-261.373,7.373-257.245,3.558-255.521,2.228zM-265.07,44.399c0,0-6.577-4.721-6.577-14.896c0-5.942,5.794-7.325,5.794-7.325s0.393,7.488,3.211,15.708C-265.539,41.469-265.07,44.399-265.07,44.399z M-252.36,45.15l-1.176-1.22L-254.789,48l-1.487-4.069l-1.019,2.116l-1.488-3.826h8.067L-252.36,45.15z\\\",\\\"symbolSize\\\":[50,60]},{\\\"name\\\":\\\"高铁\\\",\\\"value\\\":18,\\\"symbol\\\":\\\"path://M67.335,33.596L67.335,33.596c-0.002-1.39-1.153-3.183-3.328-4.218h-9.096v-2.07h5.371 c-4.939-2.07-11.199-4.141-14.89-4.141H19.72v12.421v5.176h38.373c4.033,0,8.457-1.035,9.142-5.176h-0.027 c0.076-0.367,0.129-0.751,0.129-1.165L67.335,33.596L67.335,33.596z M27.999,30.413h-3.105v-4.141h3.105V30.413z M35.245,30.413 h-3.104v-4.141h3.104V30.413z M42.491,30.413h-3.104v-4.141h3.104V30.413z M49.736,30.413h-3.104v-4.141h3.104V30.413z  M14.544,40.764c1.143,0,2.07-0.927,2.07-2.07V35.59V25.237c0-1.145-0.928-2.07-2.07-2.07H-9.265c-1.143,0-2.068,0.926-2.068,2.07 v10.351v3.105c0,1.144,0.926,2.07,2.068,2.07H14.544L14.544,40.764z M8.333,26.272h3.105v4.141H8.333V26.272z M1.087,26.272h3.105 v4.141H1.087V26.272z M-6.159,26.272h3.105v4.141h-3.105V26.272z M-9.265,41.798h69.352v1.035H-9.265V41.798z\\\",\\\"symbolSize\\\":[50,30]},{\\\"name\\\":\\\"轮船\\\",\\\"value\\\":12,\\\"symbol\\\":\\\"path://M16.678,17.086h9.854l-2.703,5.912c5.596,2.428,11.155,5.575,16.711,8.607c3.387,1.847,6.967,3.75,10.541,5.375 v-6.16l-4.197-2.763v-5.318L33.064,12.197h-11.48L20.43,15.24h-4.533l-1.266,3.286l0.781,0.345L16.678,17.086z M49.6,31.84 l0.047,1.273L27.438,20.998l0.799-1.734L49.6,31.84z M33.031,15.1l12.889,8.82l0.027,0.769L32.551,16.1L33.031,15.1z M22.377,14.045 h9.846l-1.539,3.365l-2.287-1.498h1.371l0.721-1.352h-2.023l-0.553,1.037l-0.541-0.357h-0.34l0.359-0.684h-2.025l-0.361,0.684 h-3.473L22.377,14.045z M23.695,20.678l-0.004,0.004h0.004V20.678z M24.828,18.199h-2.031l-0.719,1.358h2.029L24.828,18.199z  M40.385,34.227c-12.85-7.009-25.729-14.667-38.971-12.527c1.26,8.809,9.08,16.201,8.213,24.328 c-0.553,4.062-3.111,0.828-3.303,7.137c15.799,0,32.379,0,48.166,0l0.066-4.195l1.477-7.23 C50.842,39.812,45.393,36.961,40.385,34.227z M13.99,35.954c-1.213,0-2.195-1.353-2.195-3.035c0-1.665,0.98-3.017,2.195-3.017 c1.219,0,2.195,1.352,2.195,3.017C16.186,34.604,15.213,35.954,13.99,35.954z M23.691,20.682h-2.02l-0.588,1.351h2.023 L23.691,20.682z M19.697,18.199l-0.721,1.358h2.025l0.727-1.358H19.697z\\\",\\\"symbolSize\\\":[50,35]},{\\\"name\\\":\\\"汽车\\\",\\\"value\\\":9,\\\"symbol\\\":\\\"path://M49.592,40.883c-0.053,0.354-0.139,0.697-0.268,0.963c-0.232,0.475-0.455,0.519-1.334,0.475 c-1.135-0.053-2.764,0-4.484,0.068c0,0.476,0.018,0.697,0.018,0.697c0.111,1.299,0.697,1.342,0.931,1.342h3.7 c0.326,0,0.628,0,0.861-0.154c0.301-0.196,0.43-0.772,0.543-1.78c0.017-0.146,0.025-0.336,0.033-0.56v-0.01 c0-0.068,0.008-0.154,0.008-0.25V41.58l0,0C49.6,41.348,49.6,41.09,49.592,40.883L49.592,40.883z M6.057,40.883 c0.053,0.354,0.137,0.697,0.268,0.963c0.23,0.475,0.455,0.519,1.334,0.475c1.137-0.053,2.762,0,4.484,0.068 c0,0.476-0.018,0.697-0.018,0.697c-0.111,1.299-0.697,1.342-0.93,1.342h-3.7c-0.328,0-0.602,0-0.861-0.154 c-0.309-0.18-0.43-0.772-0.541-1.78c-0.018-0.146-0.027-0.336-0.035-0.56v-0.01c0-0.068-0.008-0.154-0.008-0.25V41.58l0,0 C6.057,41.348,6.057,41.09,6.057,40.883L6.057,40.883z M49.867,32.766c0-2.642-0.344-5.224-0.482-5.507 c-0.104-0.207-0.766-0.749-2.271-1.773c-1.522-1.042-1.487-0.887-1.766-1.566c0.25-0.078,0.492-0.224,0.639-0.241 c0.326-0.034,0.345,0.274,1.023,0.274c0.68,0,2.152-0.18,2.453-0.48c0.301-0.303,0.396-0.405,0.396-0.672 c0-0.268-0.156-0.818-0.447-1.146c-0.293-0.327-1.541-0.49-2.273-0.585c-0.729-0.095-0.834,0-1.022,0.121 c-0.304,0.189-0.32,1.919-0.32,1.919l-0.713,0.018c-0.465-1.146-1.11-3.452-2.117-5.269c-1.103-1.979-2.256-2.599-2.737-2.754 c-0.474-0.146-0.904-0.249-4.131-0.576c-3.298-0.344-5.922-0.388-8.262-0.388c-2.342,0-4.967,0.052-8.264,0.388 c-3.229,0.336-3.66,0.43-4.133,0.576s-1.633,0.775-2.736,2.754c-1.006,1.816-1.652,4.123-2.117,5.269L9.87,23.109 c0,0-0.008-1.729-0.318-1.919c-0.189-0.121-0.293-0.225-1.023-0.121c-0.732,0.104-1.98,0.258-2.273,0.585 c-0.293,0.327-0.447,0.878-0.447,1.146c0,0.267,0.094,0.379,0.396,0.672c0.301,0.301,1.773,0.48,2.453,0.48 c0.68,0,0.697-0.309,1.023-0.274c0.146,0.018,0.396,0.163,0.637,0.241c-0.283,0.68-0.24,0.524-1.764,1.566 c-1.506,1.033-2.178,1.566-2.271,1.773c-0.139,0.283-0.482,2.865-0.482,5.508s0.189,5.02,0.189,5.86c0,0.354,0,0.976,0.076,1.565 c0.053,0.354,0.129,0.697,0.268,0.966c0.232,0.473,0.447,0.516,1.334,0.473c1.137-0.051,2.779,0,4.477,0.07 c1.135,0.043,2.297,0.086,3.33,0.11c2.582,0.051,1.826-0.379,2.928-0.36c1.102,0.016,5.447,0.196,9.424,0.196 c3.976,0,8.332-0.182,9.423-0.196c1.102-0.019,0.346,0.411,2.926,0.36c1.033-0.018,2.195-0.067,3.332-0.11 c1.695-0.062,3.348-0.121,4.477-0.07c0.886,0.043,1.103,0,1.332-0.473c0.132-0.269,0.218-0.611,0.269-0.966 c0.086-0.592,0.078-1.213,0.078-1.565C49.678,37.793,49.867,35.408,49.867,32.766L49.867,32.766z M13.219,19.735 c0.412-0.964,1.652-2.9,2.256-3.244c0.145-0.087,1.426-0.491,4.637-0.706c2.953-0.198,6.217-0.276,7.73-0.276 c1.513,0,4.777,0.078,7.729,0.276c3.201,0.215,4.502,0.611,4.639,0.706c0.775,0.533,1.842,2.28,2.256,3.244 c0.412,0.965,0.965,2.858,0.861,3.116c-0.104,0.258,0.104,0.388-1.291,0.275c-1.387-0.103-10.088-0.216-14.185-0.216 c-4.088,0-12.789,0.113-14.184,0.216c-1.395,0.104-1.188-0.018-1.291-0.275C12.254,22.593,12.805,20.708,13.219,19.735 L13.219,19.735z M16.385,30.511c-0.619,0.155-0.988,0.491-1.764,0.482c-0.775,0-2.867-0.353-3.314-0.371 c-0.447-0.017-0.842,0.302-1.076,0.362c-0.23,0.06-0.688-0.104-1.377-0.318c-0.688-0.216-1.092-0.155-1.316-1.094 c-0.232-0.93,0-2.264,0-2.264c1.488-0.068,2.928,0.069,5.621,0.826c2.693,0.758,4.191,2.213,4.191,2.213 S17.004,30.357,16.385,30.511L16.385,30.511z M36.629,37.293c-1.23,0.164-6.386,0.207-8.794,0.207c-2.412,0-7.566-0.051-8.799-0.207 c-1.256-0.164-2.891-1.67-1.764-2.865c1.523-1.627,1.24-1.576,4.701-2.023C24.967,32.018,27.239,32,27.834,32 c0.584,0,2.865,0.025,5.859,0.404c3.461,0.447,3.178,0.396,4.699,2.022C39.521,35.623,37.887,37.129,36.629,37.293L36.629,37.293z  M48.129,29.582c-0.232,0.93-0.629,0.878-1.318,1.093c-0.688,0.216-1.145,0.371-1.377,0.319c-0.231-0.053-0.627-0.371-1.074-0.361 c-0.448,0.018-2.539,0.37-3.313,0.37c-0.772,0-1.146-0.328-1.764-0.481c-0.621-0.154-0.966-0.154-0.966-0.154 s1.49-1.464,4.191-2.213c2.693-0.758,4.131-0.895,5.621-0.826C48.129,27.309,48.361,28.643,48.129,29.582L48.129,29.582z\\\",\\\"symbolSize\\\":[40,30]},{\\\"name\\\":\\\"跑步\\\",\\\"value\\\":2,\\\"symbol\\\":\\\"path://M13.676,32.955c0.919-0.031,1.843-0.008,2.767-0.008v0.007c0.827,0,1.659,0.041,2.486-0.019 c0.417-0.028,1.118,0.325,1.14-0.545c0.014-0.637-0.156-1.279-0.873-1.367c-1.919-0.241-3.858-0.233-5.774,0.019 c-0.465,0.062-0.998,0.442-0.832,1.069C12.715,32.602,13.045,32.977,13.676,32.955z M14.108,29.013 c1.47-0.007,2.96-0.122,4.414,0.035c1.792,0.192,3.1-0.412,4.273-2.105c-3.044,0-5.882,0.014-8.719-0.01 c-0.768-0.005-1.495,0.118-1.461,1C12.642,28.731,13.329,29.014,14.108,29.013z M23.678,36.593c-0.666-0.69-1.258-1.497-2.483-1.448 c-2.341,0.095-4.689,0.051-7.035,0.012c-0.834-0.014-1.599,0.177-1.569,1.066c0.031,0.854,0.812,1.062,1.636,1.043 c1.425-0.033,2.852-0.01,4.278-0.01v-0.01c1.562,0,3.126,0.008,4.691-0.005C23.614,37.239,24.233,37.174,23.678,36.593z  M32.234,42.292h-0.002c-1.075,0.793-2.589,0.345-3.821,1.048c-0.359,0.193-0.663,0.465-0.899,0.799 c-1.068,1.623-2.052,3.301-3.117,4.928c-0.625,0.961-0.386,1.805,0.409,2.395c0.844,0.628,1.874,0.617,2.548-0.299 c1.912-2.573,3.761-5.197,5.621-7.814C33.484,42.619,33.032,42.387,32.234,42.292z M43.527,28.401 c-0.688-1.575-2.012-0.831-3.121-0.895c-1.047-0.058-2.119,1.128-3.002,0.345c-0.768-0.677-1.213-1.804-1.562-2.813 c-0.45-1.305-1.495-2.225-2.329-3.583c2.953,1.139,4.729,0.077,5.592-1.322c0.99-1.61,0.718-3.725-0.627-4.967 c-1.362-1.255-3.414-1.445-4.927-0.452c-1.933,1.268-2.206,2.893-0.899,6.11c-2.098-0.659-3.835-1.654-5.682-2.383 c-0.735-0.291-1.437-1.017-2.293-0.666c-2.263,0.927-4.522,1.885-6.723,2.95c-1.357,0.658-1.649,1.593-1.076,2.638 c0.462,0.851,1.643,1.126,2.806,0.617c0.993-0.433,1.994-0.857,2.951-1.374c1.599-0.86,3.044-0.873,4.604,0.214 c1.017,0.707,0.873,1.137,0.123,1.849c-1.701,1.615-3.516,3.12-4.933,5.006c-1.042,1.388-0.993,2.817,0.255,4.011 c1.538,1.471,3.148,2.869,4.708,4.315c0.485,0.444,0.907,0.896-0.227,1.104c-1.523,0.285-3.021,0.694-4.538,1.006 c-1.109,0.225-2.02,1.259-1.83,2.16c0.223,1.07,1.548,1.756,2.687,1.487c3.003-0.712,6.008-1.413,9.032-2.044 c1.549-0.324,2.273-1.869,1.344-3.115c-0.868-1.156-1.801-2.267-2.639-3.445c-1.964-2.762-1.95-2.771,0.528-5.189 c1.394-1.357,1.379-1.351,2.437,0.417c0.461,0.769,0.854,1.703,1.99,1.613c2.238-0.181,4.407-0.755,6.564-1.331 C43.557,30.447,43.88,29.206,43.527,28.401z\\\",\\\"symbolSize\\\":[50,50]},{\\\"name\\\":\\\"步行\\\",\\\"value\\\":1,\\\"symbol\\\":\\\"path://M29.902,23.275c1.86,0,3.368-1.506,3.368-3.365c0-1.859-1.508-3.365-3.368-3.365 c-1.857,0-3.365,1.506-3.365,3.365C26.537,21.769,28.045,23.275,29.902,23.275z M36.867,30.74c-1.666-0.467-3.799-1.6-4.732-4.199 c-0.932-2.6-3.131-2.998-4.797-2.998s-7.098,3.894-7.098,3.894c-1.133,1.001-2.1,6.502-0.967,6.769 c1.133,0.269,1.266-1.533,1.934-3.599c0.666-2.065,3.797-3.466,3.797-3.466s0.201,2.467-0.398,3.866 c-0.599,1.399-1.133,2.866-1.467,6.198s-1.6,3.665-3.799,6.266c-2.199,2.598-0.6,3.797,0.398,3.664 c1.002-0.133,5.865-5.598,6.398-6.998c0.533-1.397,0.668-3.732,0.668-3.732s0,0,2.199,1.867c2.199,1.865,2.332,4.6,2.998,7.73 s2.332,0.934,2.332-0.467c0-1.401,0.269-5.465-1-7.064c-1.265-1.6-3.73-3.465-3.73-5.265s1.199-3.732,1.199-3.732 c0.332,1.667,3.335,3.065,5.599,3.399C38.668,33.206,38.533,31.207,36.867,30.74z\\\",\\\"symbolSize\\\":[40,50]}]\",\"size\":{\"width\":516,\"height\":334},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"top\":60,\"left\":25,\"bottom\":18,\"right\":50,\"containLabel\":true},\"series\":[],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":true,\"text\":\"\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681697296384', NULL, '1016994145836257280', NULL, 'JDevHistory', '{\"chartData\":\"[{\\\"year\\\":\\\"2012\\\",\\\"title\\\":\\\"开源项目JEECG被\\\\\\\"CSDN专家访谈\\\\\\\"\\\"},{\\\"year\\\":\\\"2012\\\",\\\"title\\\":\\\"开源项目JEECG被\\\\\\\"ITeye专家访谈\\\"},{\\\"year\\\":\\\"2012\\\",\\\"title\\\":\\\"JEECG在Google Code上开源\\\"},{\\\"year\\\":\\\"2012\\\",\\\"title\\\":\\\"推出开源项目\\\\\\\"MiniDao(持久层解决方案）\\\\\\\"超越了Mybatis和 Hibernate\\\"},{\\\"year\\\":\\\"2012\\\",\\\"title\\\":\\\"JEECG参加“云计算成就创业梦想”第二届阿里云开发者大赛\\\\\\\"园\\\"},{\\\"year\\\":\\\"2013\\\",\\\"title\\\":\\\"应邀参加了\\\\\\\"SDCC 2013中国软件开发者大会\\\\\\\" （大会由CSDN和《程 序员》杂志倾力打造）\\\"},{\\\"year\\\":\\\"2013\\\",\\\"title\\\":\\\"2017.07，开发GBI区块链资讯信息平台\\\"},{\\\"year\\\":\\\"2013\\\",\\\"title\\\":\\\"成立JEECG开源团队，创立JEECG开源社区\\\"},{\\\"year\\\":\\\"2013\\\",\\\"title\\\":\\\"中国优秀开源项目评选-公开投票,“JEECG以887票位居第九\\\"},{\\\"year\\\":\\\"2013\\\",\\\"title\\\":\\\"2013年应邀参加\\\\\\\"开源群英会2013”的开源英雄\\\"},{\\\"year\\\":\\\"2014\\\",\\\"title\\\":\\\"12月份捷微jeewx与联通集团达成战略合作，负责联通集团微信公众 账号集团化运营\\\"},{\\\"year\\\":\\\"2014\\\",\\\"title\\\":\\\"8月份捷微jeewx2.0与百度达成战略合作，集成百度地图，增加地图 功能，附近商家团购等信息搜索\\\"},{\\\"year\\\":\\\"2014\\\",\\\"title\\\":\\\"推出当前最火的开源项目“JeeWx(捷微:敏捷微信开发平台）”，并 获得CSDN举办的“2014年开发者大会”公开投票第一名\\\"},{\\\"year\\\":\\\"2014\\\",\\\"title\\\":\\\"5月应邀参加中国科学院大学创新创业年度论坛，探讨“创业企业发 展、创新创业孵化”的主题\\\"},{\\\"year\\\":\\\"2015\\\",\\\"title\\\":\\\"推出微信H5活动营销平台，专业解决客户对H5互动活动需求（H5huo dong.com）\\\"},{\\\"year\\\":\\\"2015\\\",\\\"title\\\":\\\"开源中国最热开源项目TOP20，社区开源项目独占4份，前五名两位（ jeewx、jeecg）\\\"},{\\\"year\\\":\\\"2015\\\",\\\"title\\\":\\\"12月独创，微信插件开发机制（java）,推出H5活动平台（www.h5h uodong.com），致力于互动微信H5活动开发\\\"},{\\\"year\\\":\\\"2015\\\",\\\"title\\\":\\\"6月份捷微jeewx推出集企业号版本，与中国移动打成战略合作，推出 企业号营销新模式\\\"},{\\\"year\\\":\\\"2015\\\",\\\"title\\\":\\\"3月份捷微jeewx推出集团化微信运营版本，专注微信应用一体化，企 业系统集成，实现公众账号上下级，类似组织机构权限模式\\\"},{\\\"year\\\":\\\"2016\\\",\\\"title\\\":\\\"jeecg推出插件开发机制 jeecg-p3，主推通过jeecg解决未来SAAS项 目需求方案\\\"},{\\\"year\\\":\\\"2016\\\",\\\"title\\\":\\\"jeecg推出重大更新，提升移动开发能力（移动表单配置、移动报表配 置、移动OA，无需编码，通过配置实现移动PC互用）\\\"}]\",\"size\":{\"width\":661,\"height\":300},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"年份\"},{\"mapping\":\"\",\"filed\":\"标题\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"https://api.jeecg.com/mock/26/history\",\"timeOut\":0,\"option\":{\"typeFontColor\":\"#FFFFFF\",\"titleColor\":\"#1E90FF\",\"titleFontSize\":20,\"zoom\":1,\"typeBackColor\":\"#FF4500\",\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"waitTime\":4000,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681714073600', NULL, '1016994145836257280', NULL, 'JRotatePie', '{\"chartData\":\"[{\\\"value\\\":1048,\\\"name\\\":\\\"vivo\\\"},{\\\"value\\\":735,\\\"name\\\":\\\"oppo\\\"},{\\\"value\\\":580,\\\"name\\\":\\\"苹果\\\"},{\\\"value\\\":484,\\\"name\\\":\\\"小米\\\"},{\\\"value\\\":300,\\\"name\\\":\\\"三星\\\"}]\",\"size\":{\"width\":450,\"height\":300},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"option\":{\"typeFontColor\":\"#4A4A4A\",\"titleColor\":\"#4A4A4A\",\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"orient\":\"vertical\"},\"series\":[{\"data\":[],\"name\":\"\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"}},\"type\":\"pie\"}],\"tooltip\":{\"trigger\":\"item\"},\"typeBackColor\":\"#4A4A4A\",\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681726656512', NULL, '1016994145836257280', NULL, 'JColorBlock', '{\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"前缀\"},{\"mapping\":\"\",\"filed\":\"后缀\"},{\"mapping\":\"\",\"filed\":\"颜色\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":175,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"[  {    \\\"backgroundColor\\\": \\\"#67C23A\\\",    \\\"prefix\\\": \\\"朝阳总销售额\\\",    \\\"value\\\": \\\"12345\\\",    \\\"suffix\\\": \\\"亿\\\"  },  {    \\\"backgroundColor\\\": \\\"#409EFF\\\",    \\\"prefix\\\": \\\"昌平总销售额\\\",    \\\"value\\\": \\\"12345\\\",    \\\"suffix\\\": \\\"亿\\\"  },  {    \\\"backgroundColor\\\": \\\"#E6A23C\\\",    \\\"prefix\\\": \\\"海淀总销售额\\\",    \\\"value\\\": \\\"12345\\\",    \\\"suffix\\\": \\\"亿\\\"  },  {    \\\"backgroundColor\\\": \\\"#F56C6C\\\",    \\\"prefix\\\": \\\"西城总销售额\\\",    \\\"value\\\": \\\"12345\\\",    \\\"suffix\\\": \\\"亿\\\"  },  {    \\\"backgroundColor\\\": \\\"#F56C6C\\\",    \\\"prefix\\\": \\\"西城总销售额\\\",    \\\"value\\\": \\\"12345\\\",    \\\"suffix\\\": \\\"亿\\\"  },  {    \\\"backgroundColor\\\": \\\"#F56C6C\\\",    \\\"prefix\\\": \\\"西城总销售额\\\",    \\\"value\\\": \\\"12345\\\",    \\\"suffix\\\": \\\"亿\\\"  }]\",\"size\":{\"width\":1865,\"height\":110},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"padding\":5,\"suffixFontSize\":16,\"prefixColor\":\"#FFFFFF\",\"color\":\"#FFFFFF\",\"prefixSplitx\":0,\"textAlign\":\"center\",\"prefixSplity\":0,\"suffixFontWeight\":\"normal\",\"prefix\":\"\",\"whole\":false,\"suffix\":\"\",\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"prefixFontSize\":16,\"prefixFontWeight\":\"normal\",\"suffixSplitx\":40,\"suffixColor\":\"#FFFFFF\",\"width\":50,\"lineNum\":6,\"fontSize\":16,\"borderSplitx\":20,\"borderSplity\":20,\"fontWeight\":\"normal\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"height\":50}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681743433728', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":350,\"height\":385},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681764405248', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":545,\"height\":468},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681781182464', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":541,\"height\":379},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"12\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681793765376', NULL, '1016994145836257280', NULL, 'JRectangle', '{\"chartData\":\"[{\\\"name\\\":\\\"分类 1\\\",\\\"value\\\":560},{\\\"name\\\":\\\"分类 2\\\",\\\"value\\\":500},{\\\"name\\\":\\\"分类 3\\\",\\\"value\\\":150},{\\\"name\\\":\\\"分类 4\\\",\\\"value\\\":140},{\\\"name\\\":\\\"分类 5\\\",\\\"value\\\":115},{\\\"name\\\":\\\"分类 6\\\",\\\"value\\\":95},{\\\"name\\\":\\\"分类 7\\\",\\\"value\\\":90},{\\\"name\\\":\\\"分类 8\\\",\\\"value\\\":75},{\\\"name\\\":\\\"分类 9\\\",\\\"value\\\":98},{\\\"name\\\":\\\"分类 10\\\",\\\"value\\\":60},{\\\"name\\\":\\\"分类 11\\\",\\\"value\\\":45},{\\\"name\\\":\\\"分类 12\\\",\\\"value\\\":40},{\\\"name\\\":\\\"分类 13\\\",\\\"value\\\":40},{\\\"name\\\":\\\"分类 14\\\",\\\"value\\\":35},{\\\"name\\\":\\\"分类 15\\\",\\\"value\\\":40},{\\\"name\\\":\\\"分类 16\\\",\\\"value\\\":40},{\\\"name\\\":\\\"分类 17\\\",\\\"value\\\":40},{\\\"name\\\":\\\"分类 18\\\",\\\"value\\\":30},{\\\"name\\\":\\\"分类 19\\\",\\\"value\\\":28},{\\\"name\\\":\\\"分类 20\\\",\\\"value\\\":16}]\",\"size\":{\"width\":662,\"height\":364},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"tipColor\":\"#FFFFFF\",\"titleColor\":\"#FFFFFF\",\"titleFontSize\":12,\"theme\":\"default\",\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"tipFontSize\":12,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681810542592', NULL, '1016994145836257280', NULL, 'JPyramid3D', '{\"chartData\":\"[{\\\"name\\\":\\\"Java\\\",\\\"value\\\":800,\\\"color\\\":\\\"#45fed4\\\"},{\\\"name\\\":\\\"PHP\\\",\\\"value\\\":100,\\\"color\\\":\\\"#84a9ef\\\"},{\\\"name\\\":\\\"C#\\\",\\\"value\\\":50,\\\"color\\\":\\\"#f1e04f\\\"},{\\\"name\\\":\\\"Python\\\",\\\"value\\\":66,\\\"color\\\":\\\"#dbfe73\\\"}]\",\"size\":{\"width\":678,\"height\":438},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"},{\"mapping\":\"\",\"filed\":\"颜色\"}],\"w\":735,\"dataType\":1,\"h\":485,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"option\":{\"size\":\"default\",\"zoom\":1}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017225681823125504', NULL, '1016994145836257280', NULL, 'JDragBorder', '{\"size\":{\"width\":1878.9484040956538,\"height\":130},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 10:18:32', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463101390848', NULL, '1016994412900175872', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"收视监控平台\",\"size\":{\"width\":376,\"height\":52},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"letterSpacing\":5,\"fontSize\":50,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463134945280', NULL, '1016994412900175872', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"Viewing  Monitoring platform\",\"size\":{\"width\":382,\"height\":45},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":26,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463160111104', NULL, '1016994412900175872', NULL, 'JDragDecoration', '{\"size\":{\"width\":403,\"height\":78},\"w\":300,\"dataType\":1,\"h\":100,\"option\":{\"dur\":3,\"mainColor\":\"#00CED1\",\"fontSize\":15,\"type\":\"8\",\"title\":\"装饰8\",\"subColor\":\"#FAD400\",\"reverse\":false}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463176888320', NULL, '1016994412900175872', NULL, 'JCurrentTime', '{\"chartData\":\"\",\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":270,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":270,\"dataType\":1,\"h\":33,\"turnConfig\":{\"url\":\"\"},\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"option\":{\"bgColor\":\"#4A4A4A\",\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"showWeek\":\"hide\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"fontColor\":\"#4A4A4A\"}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463185276928', NULL, '1016994412900175872', NULL, 'JImg', '{\"size\":{\"width\":93,\"height\":61},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://jeecgos.oss-cn-beijing.aliyuncs.com/upload/test/1e80a2350e3a4b378a4ba7647aef9a17.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463202054144', NULL, '1016994412900175872', NULL, 'JWeatherForecast', '{\"size\":{\"width\":267,\"height\":59},\"w\":311,\"dataType\":1,\"h\":47,\"option\":{\"template\":11,\"bgColor\":\"\",\"city\":\"\",\"num\":2,\"fontSize\":16,\"fontColor\":\"#fff\",\"url\":\"\"}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463223025664', NULL, '1016994412900175872', NULL, 'JDragBorder', '{\"size\":{\"width\":599,\"height\":441},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463235608576', NULL, '1016994412900175872', NULL, 'JDragBorder', '{\"size\":{\"width\":582,\"height\":445},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463248191488', NULL, '1016994412900175872', NULL, 'JDragBorder', '{\"size\":{\"width\":589,\"height\":450},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463260774400', NULL, '1016994412900175872', NULL, 'JVideoJs', '{\"size\":{\"width\":568,\"height\":405},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":450,\"dataType\":1,\"h\":300,\"timeOut\":0,\"option\":{\"url\":\"http://vjs.zencdn.net/v/oceans.mp4\"}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463281745920', NULL, '1016994412900175872', NULL, 'JVideoJs', '{\"size\":{\"width\":560,\"height\":416},\"w\":450,\"dataType\":1,\"h\":300,\"timeOut\":0,\"option\":{\"url\":\"http://vjs.zencdn.net/v/oceans.mp4\"}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463294328832', NULL, '1016994412900175872', NULL, 'JVideoJs', '{\"size\":{\"width\":570,\"height\":433},\"w\":450,\"dataType\":1,\"h\":300,\"timeOut\":0,\"option\":{\"url\":\"http://vjs.zencdn.net/v/oceans.mp4\"}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463311106048', NULL, '1016994412900175872', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"全网实时收视率\",\"size\":{\"width\":262,\"height\":56},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":35,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463319494656', NULL, '1016994412900175872', NULL, 'JDragBorder', '{\"size\":{\"width\":1790,\"height\":417},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"2\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463332077568', NULL, '1016994412900175872', NULL, 'JMultipleLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"周一\\\",    \\\"value\\\": 80,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周二\\\",    \\\"value\\\": 30,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周三\\\",    \\\"value\\\": 40,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周四\\\",    \\\"value\\\": 80,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周五\\\",    \\\"value\\\": 20,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周一\\\",    \\\"value\\\": 30,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周二\\\",    \\\"value\\\": 60,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周三\\\",    \\\"value\\\": 80,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周四\\\",    \\\"value\\\": 20,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周五\\\",    \\\"value\\\": 30,    \\\"type\\\": \\\"下午\\\"  }]\",\"size\":{\"width\":485,\"height\":335},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"name\":\"\",\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#FFD700\"},{\"color\":\"#90EE90\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"}},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":40,\"containLabel\":true},\"series\":[{\"areaStyleOpacity\":0.5,\"symbolSize\":5,\"lineType\":\"smooth\",\"label\":{\"color\":\"#EEF1FA\"},\"lineWidth\":2}],\"legend\":{\"r\":1},\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463357243392', NULL, '1016994412900175872', NULL, 'JMultipleLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"周一\\\",    \\\"value\\\": 80,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周二\\\",    \\\"value\\\": 30,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周三\\\",    \\\"value\\\": 40,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周四\\\",    \\\"value\\\": 80,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周五\\\",    \\\"value\\\": 20,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周一\\\",    \\\"value\\\": 30,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周二\\\",    \\\"value\\\": 60,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周三\\\",    \\\"value\\\": 80,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周四\\\",    \\\"value\\\": 20,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周五\\\",    \\\"value\\\": 30,    \\\"type\\\": \\\"下午\\\"  }]\",\"size\":{\"width\":485,\"height\":335},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"show\":true,\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#1E86EB\"},{\"color\":\"#FF8C00\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":40,\"containLabel\":true},\"series\":[{\"symbolSize\":5,\"lineType\":\"smooth\",\"label\":{\"color\":\"#EEF1FA\"},\"lineWidth\":2}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463369826304', NULL, '1016994412900175872', NULL, 'JMultipleLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"周一\\\",    \\\"value\\\": 80,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周二\\\",    \\\"value\\\": 30,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周三\\\",    \\\"value\\\": 40,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周四\\\",    \\\"value\\\": 80,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周五\\\",    \\\"value\\\": 20,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": \\\"周一\\\",    \\\"value\\\": 30,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周二\\\",    \\\"value\\\": 60,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周三\\\",    \\\"value\\\": 80,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周四\\\",    \\\"value\\\": 20,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": \\\"周五\\\",    \\\"value\\\": 30,    \\\"type\\\": \\\"下午\\\"  }]\",\"size\":{\"width\":485,\"height\":335},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#C71585\"},{\"color\":\"#FF4500\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"}},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":40,\"containLabel\":true},\"series\":[{\"symbolSize\":5,\"lineType\":\"smooth\",\"lineWidth\":2}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463382409216', NULL, '1016994412900175872', NULL, 'JSelectRadio', '{\"compShowConfig\":[{\"compVals\":[\"22aae23c-029e-456e-a1ac-0936cbfa6b6b\",\"9d1f25e6-5446-4f78-90c6-7f9bd674b058\",\"85841a8f-e6cd-479a-9ba8-c36497b4e912\",\"236cba9d-2c70-407e-8013-ee37e3d5d124\",\"es-drager-1731649759290-3\",\"es-drager-1731649765690-4\"],\"selectVal\":\"1\"},{\"compVals\":[\"3acfc295-ea6d-4e16-83fd-bfd8d9022d8d\",\"f499c09e-61cc-40f1-8496-d57d2f98f82c\",\"a82c61b6-4287-422a-b8e7-1cb34d17859a\",\"26735d51-f628-4ec6-8886-0ede0a7443af\",\"es-drager-1731650783569-1\",\"es-drager-1731650792607-2\"],\"selectVal\":\"2\"}],\"chartData\":\"[  {    \\\"label\\\": \\\"中央卫视\\\",    \\\"value\\\": \\\"1\\\"  },  {    \\\"label\\\": \\\"地方卫视\\\",    \\\"value\\\": \\\"2\\\"  }]\",\"size\":{\"width\":400,\"height\":80},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"文本\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":400,\"dataType\":1,\"h\":80,\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"option\":{\"padding\":0,\"backgroundColor\":\"#39414d\",\"borderColor\":\"\",\"color\":\"#FFFFFF\",\"activeColor\":\"#fff\",\"activeBorderColor\":\"\",\"borderWidth\":0,\"activeBackgroundColor\":\"#0a73ff\",\"fontSize\":30,\"type\":\"radio\",\"activeBorderWidth\":0}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463394992128', NULL, '1016994412900175872', NULL, 'JVideoPlay', '{\"chartData\":\"[{\\\"src\\\":\\\"http://vjs.zencdn.net/v/oceans.mp4\\\"}]\",\"size\":{\"width\":516,\"height\":351},\"background\":\"#4A90E2\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"路径\"}],\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"option\":{\"loop\":true,\"autoPlay\":false}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463411769344', NULL, '1016994412900175872', NULL, 'JVideoPlay', '{\"chartData\":\"[{\\\"src\\\":\\\"http://vjs.zencdn.net/v/oceans.mp4\\\"}]\",\"size\":{\"width\":518,\"height\":361},\"background\":\"#4A90E2\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"路径\"}],\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"option\":{\"loop\":true,\"autoPlay\":false}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463436935168', NULL, '1016994412900175872', NULL, 'JVideoPlay', '{\"chartData\":\"[{\\\"src\\\":\\\"http://vjs.zencdn.net/v/oceans.mp4\\\"}]\",\"size\":{\"width\":521,\"height\":378},\"background\":\"#4A90E2\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"路径\"}],\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"option\":{\"loop\":true,\"autoPlay\":false}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463449518080', NULL, '1016994412900175872', NULL, 'JBubble', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": 4,    \\\"value\\\": 80,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": 5,    \\\"value\\\": 75,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": 6,    \\\"value\\\": 68,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": 7,    \\\"value\\\": 51,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": 8,    \\\"value\\\": 92,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": 9,    \\\"value\\\": 68,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": 10,    \\\"value\\\": 78,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": 11,    \\\"value\\\": 69,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": 12,    \\\"value\\\": 83,    \\\"type\\\": \\\"上午\\\"  },  {    \\\"name\\\": 11,    \\\"value\\\": 6,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": 10,    \\\"value\\\": 8,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": 9,    \\\"value\\\": 7,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": 8,    \\\"value\\\": 10,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": 7,    \\\"value\\\": 11,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": 6,    \\\"value\\\": 4,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": 10,    \\\"value\\\": 20,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": 8,    \\\"value\\\": 16,    \\\"type\\\": \\\"下午\\\"  },  {    \\\"name\\\": 7,    \\\"value\\\": 9,    \\\"type\\\": \\\"下午\\\"  }]\",\"size\":{\"width\":851,\"height\":360},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"interval\":2}},\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"}},\"grid\":{\"top\":50,\"left\":0,\"bottom\":18,\"right\":50,\"containLabel\":true},\"series\":[],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463462100992', NULL, '1016994412900175872', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"视频访问来源\",\"size\":{\"width\":268,\"height\":63},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":35,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017286463478878208', NULL, '1016994412900175872', NULL, 'JRing', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"value\\\": 1048,    \\\"name\\\": \\\"营销广告\\\"  },  {    \\\"value\\\": 735,    \\\"name\\\": \\\"搜索引擎\\\"  },  {    \\\"value\\\": 580,    \\\"name\\\": \\\"邮件营销\\\"  },  {    \\\"value\\\": 484,    \\\"name\\\": \\\"联盟广告\\\"  },  {    \\\"value\\\": 300,    \\\"name\\\": \\\"视频广告\\\"  }]\",\"size\":{\"width\":666,\"height\":385},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":480,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"top\":50,\"left\":50,\"show\":false},\"series\":[{\"data\":[],\"name\":\"Access From\",\"avoidLabelOverlap\":false,\"emphasis\":{\"label\":{\"color\":\"#FFFFFF\",\"show\":true,\"fontSize\":14,\"fontWeight\":\"bold\"}},\"label\":{\"color\":\"#EEF1FA\",\"show\":true,\"position\":\"center\"},\"labelLine\":{\"show\":false},\"type\":\"pie\",\"radius\":[\"40%\",\"70%\"]}],\"legend\":{\"show\":false},\"tooltip\":{\"trigger\":\"item\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-11-15 14:20:03', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321185898713088', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"XX省XX市监狱\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321185940656128', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"狱政科数据展示\",\"size\":{\"width\":519,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"letterSpacing\":15,\"fontSize\":32,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321185957433344', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"罪犯管理概况\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321185974210560', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月劳动产值\",\"size\":{\"width\":142,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321185986793472', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月劳改达标率\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186003570688', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月违规总人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186024542208', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"严格管教人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186041319424', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"615006\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0BE3E3\",\"fontSize\":32,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186053902336', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"98\",\"size\":{\"width\":49,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0E56F1\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186066485248', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"260\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0FB2F8\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186095845376', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"77\",\"size\":{\"width\":89,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FEB246\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186108428288', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"劳动改造情况\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186121011200', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"罪犯处遇等级变更情况\",\"size\":{\"width\":211,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186133594112', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"罪犯实时违规记录\",\"size\":{\"width\":192,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186154565632', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"罪犯进出狱名单\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186175537152', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"%\",\"size\":{\"width\":44,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186188120064', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当前在狱人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186200702976', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"狱外流动人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186217480192', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"5256\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0E56F1\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186238451712', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"102\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0E56F1\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186251034624', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"满分人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186263617536', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"良好人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186280394752', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"158\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0E56F1\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186305560576', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"502\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0BE3E3\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186322337792', NULL, '1015895036886831104', NULL, 'JMultipleBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"{    \\\"categories\\\": [        \\\"6月\\\",        \\\"7月\\\",        \\\"8月\\\",        \\\"9月\\\",        \\\"10月\\\",        \\\"11月\\\"    ],    \\\"series\\\": [        {            \\\"name\\\": \\\"入狱人数\\\",            \\\"data\\\": [                4,                26,                30,                16,                24,                12            ]        },        {            \\\"name\\\": \\\"出狱人数\\\",            \\\"data\\\": [                24,                12,                42,                26,                20,                24            ]        }    ]}\",\"size\":{\"width\":489,\"height\":216},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#0E56F1\"},{\"color\":\"#0BE3E3\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"}},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":5,\"containLabel\":true},\"series\":[{\"barWidth\":13,\"itemStyle\":{\"borderRadius\":0}}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186334920704', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月入狱人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186351697920', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"14\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0BE3E3\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186376863744', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月出狱人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186393640960', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"5\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0BE3E3\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186406223872', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"及格人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186431389696', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"2027\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0FB2F8\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186452361216', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"未达标人数\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186464944128', NULL, '1015895036886831104', NULL, 'JText', '{\"borderColor\":\"#F2D8D800\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"108\",\"size\":{\"width\":153,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FEB246\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186477527040', NULL, '1015895036886831104', NULL, 'JPie', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[    {        \\\"name\\\": \\\"普管\\\",        \\\"value\\\": 1600,        \\\"url\\\": \\\"http://jeecg.com\\\"    },    {        \\\"name\\\": \\\"严管\\\",        \\\"value\\\": 200,        \\\"url\\\": \\\"http://jeecg.com\\\"    },    {        \\\"name\\\": \\\"宽管\\\",        \\\"value\\\": 160,        \\\"url\\\": \\\"http://jeecg.com\\\"    },    {        \\\"name\\\": \\\"特殊管理\\\",        \\\"value\\\": 30,        \\\"url\\\": \\\"http://jeecg.com\\\"    }]\",\"size\":{\"width\":412,\"height\":263},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"customColor\":[{\"color\":\"#00EAFF\"},{\"color\":\"#01BBF2\"},{\"color\":\"#028CE5\"},{\"color\":\"#035ED7\"},{\"color\":\"#58D9F9\"}],\"grid\":{\"top\":53,\"left\":50,\"show\":false},\"legend\":{\"r\":26,\"orient\":\"horizontal\",\"show\":true},\"series\":[{\"data\":[],\"name\":\"\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"}},\"label\":{\"color\":\"#EEF1FA\",\"show\":true},\"type\":\"pie\",\"radius\":\"50%\"}],\"tooltip\":{\"trigger\":\"item\"},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186498498560', NULL, '1015895036886831104', NULL, 'JPie', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"[    {        \\\"name\\\": \\\"劳动岗位\\\",        \\\"value\\\": 1600,        \\\"url\\\": \\\"http://jeecg.com\\\"    },    {        \\\"name\\\": \\\"辅劳岗位\\\",        \\\"value\\\": 200,        \\\"url\\\": \\\"http://jeecg.com\\\"    },    {        \\\"name\\\": \\\"非劳岗位\\\",        \\\"value\\\": 160,        \\\"url\\\": \\\"http://jeecg.com\\\"    }]\",\"size\":{\"width\":412,\"height\":263},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"customColor\":[{\"color\":\"#00EAFF\"},{\"color\":\"#01BBF2\"},{\"color\":\"#028CE5\"},{\"color\":\"#035ED7\"},{\"color\":\"#58D9F9\"}],\"grid\":{\"top\":53,\"left\":50,\"show\":false},\"legend\":{\"r\":26,\"orient\":\"horizontal\",\"show\":true},\"series\":[{\"data\":[],\"name\":\"\",\"emphasis\":{\"itemStyle\":{\"shadowOffsetX\":0,\"shadowBlur\":10,\"shadowColor\":\"rgba(0, 0, 0, 0.5)\"}},\"label\":{\"color\":\"#EEF1FA\",\"show\":true},\"type\":\"pie\",\"radius\":\"50%\"}],\"tooltip\":{\"trigger\":\"item\"},\"title\":{\"subtext\":\"\",\"left\":\"left\",\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186515275776', NULL, '1015895036886831104', NULL, 'JMultipleBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"{    \\\"categories\\\": [        \\\"8月\\\",        \\\"9月\\\",        \\\"10月\\\",        \\\"11月\\\"    ],    \\\"series\\\": [        {            \\\"name\\\": \\\"满分\\\",            \\\"data\\\": [                240,                201,                192,                168            ]        },        {            \\\"name\\\": \\\"良好\\\",            \\\"data\\\": [                496,                680,                580,                480            ]        },        {            \\\"name\\\": \\\"及格\\\",            \\\"data\\\": [                2810,                2160,                2320,                2620            ]        },        {            \\\"name\\\": \\\"未达标\\\",            \\\"data\\\": [                168,                480,                360,                108            ]        }    ]}\",\"size\":{\"width\":529,\"height\":236},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#0E56F1\"},{\"color\":\"#0BE3E3\"},{\"color\":\"#0FB2F8\"},{\"color\":\"#FEB246\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":5,\"containLabel\":true},\"series\":[{\"barWidth\":15,\"itemStyle\":{\"borderRadius\":0}}],\"legend\":{\"r\":1,\"t\":1},\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186532052992', NULL, '1015895036886831104', NULL, 'JDynamicBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"{    \\\"categories\\\": [        \\\"8月\\\",        \\\"9月\\\",        \\\"10月\\\",        \\\"11月\\\"    ],    \\\"series\\\": [        {            \\\"name\\\": \\\"严管升普管人数\\\",            \\\"data\\\": [                86,                64,                182,                134            ]        },        {            \\\"name\\\": \\\"普管升宽管人数\\\",            \\\"data\\\": [                162,                42,                69,                97            ]        }    ]}\",\"size\":{\"width\":464,\"height\":177},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":30,\"containLabel\":true},\"series\":[{\"barWidth\":9,\"showBackground\":false,\"backgroundStyle\":{\"color\":\"#51626E\"},\"itemStyle\":{\"color\":\"#64B5F6\"}}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186544635904', NULL, '1015895036886831104', NULL, 'JDynamicBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"{    \\\"categories\\\": [        \\\"8月\\\",        \\\"9月\\\",        \\\"10月\\\",        \\\"11月\\\"    ],    \\\"series\\\": [        {            \\\"name\\\": \\\"普管降严管人数\\\",            \\\"data\\\": [                86,                64,                182,                134            ]        },        {            \\\"name\\\": \\\"宽管降普管人数\\\",            \\\"data\\\": [                162,                42,                69,                97            ]        }    ]}\",\"size\":{\"width\":450,\"height\":171},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":30,\"containLabel\":true},\"series\":[{\"barWidth\":9,\"showBackground\":false,\"backgroundStyle\":{\"color\":\"#51626E\"},\"itemStyle\":{\"color\":\"#64B5F6\"}}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186561413120', NULL, '1015895036886831104', NULL, 'JScrollBoard', '{\"chartData\":\"[    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"11014657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"入狱\\\",        \\\"number\\\": \\\"10年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"入狱\\\",        \\\"number\\\": \\\"1年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"入狱\\\",        \\\"number\\\": \\\"3年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"出狱\\\",        \\\"number\\\": \\\"无期\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"出狱\\\",        \\\"number\\\": \\\"无期\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"出狱\\\",        \\\"number\\\": \\\"5年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"入狱\\\",        \\\"number\\\": \\\"5年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"入狱\\\",        \\\"number\\\": \\\"5年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"入狱\\\",        \\\"number\\\": \\\"5年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"出狱\\\",        \\\"number\\\": \\\"3年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"入狱\\\",        \\\"number\\\": \\\"5年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"入狱\\\",        \\\"number\\\": \\\"5年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"出狱\\\",        \\\"number\\\": \\\"3年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"出狱\\\",        \\\"number\\\": \\\"10年\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"入狱\\\",        \\\"number\\\": \\\"无期\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"出狱\\\",        \\\"number\\\": \\\"无期\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    }]\",\"size\":{\"width\":534,\"height\":321},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"oddRowBGC\":\"#030C35\",\"headShow\":true,\"hoverPause\":true,\"indexWidth\":80,\"index\":false,\"carousel\":\"single\",\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"evenRowBGC\":\"#003A50\",\"header\":[{\"width\":\"100\",\"label\":\"罪犯姓名\"},{\"width\":\"100\",\"label\":\"罪犯编号\"},{\"width\":\"100\",\"label\":\"处遇等级\"},{\"width\":100,\"label\":\"状态\"},{\"width\":100,\"label\":\"刑期\"},{\"width\":100,\"label\":\"时间\"}],\"headerBGC\":\"#04183A\",\"headerHeight\":50,\"waitTime\":2000,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186582384640', NULL, '1015895036886831104', NULL, 'JScrollBoard', '{\"chartData\":\"[    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"安全违规操作\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"打架斗殴\\\",        \\\"price\\\": \\\"6分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"聚众赌博\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"安全违规操作\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"劳动迟到\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"劳动迟到\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"劳动迟到\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"安全违规操作\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"安全违规操作\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"安全违规操作\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"安全违规操作\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"安全违规操作\\\",        \\\"price\\\": \\\"3分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"大声喧哗\\\",        \\\"price\\\": \\\"6分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"大声喧哗\\\",        \\\"price\\\": \\\"6分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"散布谣言\\\",        \\\"price\\\": \\\"6分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"散布谣言\\\",        \\\"price\\\": \\\"6分\\\",        \\\"amount\\\": \\\"2\\\",        \\\"cost\\\": \\\"张警官\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    }]\",\"size\":{\"width\":676,\"height\":324},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"oddRowBGC\":\"#030C35\",\"headShow\":true,\"hoverPause\":true,\"indexWidth\":80,\"index\":false,\"carousel\":\"single\",\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"evenRowBGC\":\"#003A50\",\"header\":[{\"width\":\"100\",\"label\":\"罪犯姓名\"},{\"width\":\"100\",\"label\":\"罪犯编号\"},{\"width\":\"100\",\"label\":\"出狱等级\"},{\"width\":100,\"label\":\"违规事由\"},{\"width\":100,\"label\":\"扣分\"},{\"width\":100,\"label\":\"执行预警\"},{\"width\":100,\"label\":\"时间\"}],\"headerBGC\":\"#04183A\",\"headerHeight\":50,\"waitTime\":2000,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017321186599161856', NULL, '1015895036886831104', NULL, 'JCurrentTime', '{\"chartData\":\"\",\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":289,\"height\":33},\"background\":\"#FFFFFF00\",\"w\":270,\"dataType\":1,\"h\":33,\"turnConfig\":{\"url\":\"\"},\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"showWeek\":\"show\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-15 16:38:02', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136064339968', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"XX省XX市监狱\",\"size\":{\"width\":144,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136139837440', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"财务科数据展示\",\"size\":{\"width\":466,\"height\":45},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"letterSpacing\":10,\"fontSize\":32,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136160808960', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"物料采购概况\",\"size\":{\"width\":144,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136177586176', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"账户异常数据\",\"size\":{\"width\":144,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136190169088', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"药品领用实时数据\",\"size\":{\"width\":177,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136206946304', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"罪犯实时上下账数据\",\"size\":{\"width\":195,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136232112128', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"资金异常账户\",\"size\":{\"width\":144,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136248889344', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月商品采购金额\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136261472256', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月药品采购金额\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136274055168', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月被服采购金额\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136295026688', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月办公用品采购金额\",\"size\":{\"width\":151,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136311803904', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"资金异常账户数\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136328581120', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"异常资金总额\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136336969728', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"银行结账异常数\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136353746944', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"出所结算异常总额\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136374718464', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"同比增长金额\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":11,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136395689984', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"同比增长率\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":11,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136412467200', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"同比增长金额\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":11,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136429244416', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"同比增长率\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":11,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136450215936', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月上账资金总额\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136466993152', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"当月下账资金总额\",\"size\":{\"width\":132,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"fontSize\":14,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136487964672', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"56024.23\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#01BBF2\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136508936192', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"82216.68\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#00EAFF\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136525713408', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"1240.01\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#028CE5\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136538296320', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"3720.21\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#151FDD\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136555073536', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"15335.21\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0BE3E3\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136563462144', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"233500.06\",\"size\":{\"width\":179,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FEB246\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136580239360', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"311\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0E56F1\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136592822272', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"22216.02\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0FB2F8\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136605405184', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"34560.32\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FEB246\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136622182400', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"22216.68\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#00EAFF\",\"fontSize\":34,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136638959616', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"123602.23\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0BE3E3\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136655736832', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"7.23\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#0BE3E3\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136668319744', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"53602.23\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FEB246\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136685096960', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"4.23\",\"size\":{\"width\":161,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FEB246\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136693485568', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"%\",\"size\":{\"width\":84,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":16,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136710262784', NULL, '1016497921022545920', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"%\",\"size\":{\"width\":84,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#8AA7D0\",\"fontSize\":16,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136727040000', NULL, '1016497921022545920', NULL, 'JMultipleBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"{    \\\"categories\\\": [        \\\"7月\\\",        \\\"8月\\\",        \\\"9月\\\",        \\\"10月\\\",        \\\"11月\\\"    ],    \\\"series\\\": [        {            \\\"name\\\": \\\"商品采购占比\\\",            \\\"data\\\": [                12,                16,                13,                20,                24            ]        },        {            \\\"name\\\": \\\"药品采购占比\\\",            \\\"data\\\": [                28,                24,                25,                13,                12            ]        },        {            \\\"name\\\": \\\"被服采购占比\\\",            \\\"data\\\": [                34,                22,                32,                34,                40            ]        },        {            \\\"name\\\": \\\"办公用品采购占比\\\",            \\\"data\\\": [                26,                38,                30,                28,                16            ]        }    ]}\",\"size\":{\"width\":543,\"height\":257},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#00EAFF\"},{\"color\":\"#01BBF2\"},{\"color\":\"#028CE5\"},{\"color\":\"#151FDD\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":55,\"left\":0,\"bottom\":18,\"right\":5,\"containLabel\":true},\"series\":[{\"barWidth\":10,\"itemStyle\":{\"borderRadius\":0},\"label\":{\"color\":\"#EEF1FA\",\"show\":true,\"position\":\"top\"}}],\"legend\":{\"r\":13,\"t\":1},\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136743817216', NULL, '1016497921022545920', NULL, 'JMultipleLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"分组\"},{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/26/stackedBar\",\"timeOut\":0,\"chartData\":\"{    \\\"categories\\\": [        \\\"7月\\\",        \\\"8月\\\",        \\\"9月\\\",        \\\"10月\\\",        \\\"11月\\\"    ],    \\\"series\\\": [        {            \\\"name\\\": \\\"上账资金走势\\\",            \\\"data\\\": [                18100.09,                28781.31,                25654.2,                30398.73,                16560.39            ]        },        {            \\\"name\\\": \\\"下账资金走势\\\",            \\\"data\\\": [                20100.09,                16281.31,                18654.2,                20021.73,                31560.02            ]        }    ]}\",\"size\":{\"width\":682,\"height\":309},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#0BE3E3\"},{\"color\":\"#FEB246\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"}},\"grid\":{\"top\":55,\"left\":0,\"bottom\":18,\"right\":5,\"containLabel\":true},\"series\":[{\"symbol\":\"circle\",\"symbolSize\":5,\"lineType\":\"smooth\",\"label\":{\"color\":\"#EEF1FA\",\"show\":true},\"lineWidth\":3}],\"legend\":{\"r\":56},\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136756400128', NULL, '1016497921022545920', NULL, 'JArea', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":-1,\"chartData\":\"{    \\\"categories\\\": [        \\\"7月\\\",        \\\"8月\\\",        \\\"9月\\\",        \\\"10月\\\",        \\\"11月\\\"    ],    \\\"series\\\": [        {            \\\"name\\\": \\\"异常资金总额走势\\\",            \\\"data\\\": [                18100.09,                28781.31,                25654.2,                30398.73,                34560.39            ]        }    ]}\",\"size\":{\"width\":530,\"height\":258},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#FEB246\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"data\":[],\"axisLine\":{\"lineStyle\":{\"color\":\"#EEF1FA\"}},\"boundaryGap\":false,\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"izSmooth\":true,\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"right\":10,\"containLabel\":true},\"series\":[{\"areaStyleOpacity\":0.6,\"areaStyle\":{},\"data\":[],\"type\":\"line\"}],\"title\":{\"left\":10,\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136764788736', NULL, '1016497921022545920', NULL, 'JScrollBoard', '{\"chartData\":\"[    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"王来\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"咳嗽药\\\",        \\\"number\\\": \\\"3片\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    }]\",\"size\":{\"width\":531,\"height\":326},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"oddRowBGC\":\"#030D3A\",\"headShow\":true,\"hoverPause\":true,\"indexWidth\":80,\"index\":false,\"carousel\":\"single\",\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"evenRowBGC\":\"#003B51\",\"header\":[{\"width\":100,\"label\":\"罪犯姓名\"},{\"width\":100,\"label\":\"罪犯编号\"},{\"width\":100,\"label\":\"处遇等级\"},{\"width\":100,\"label\":\"领取药品\"},{\"width\":100,\"label\":\"数量\"},{\"width\":100,\"label\":\"时间\"}],\"headerBGC\":\"#041732\",\"headerHeight\":55,\"waitTime\":2000,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136777371648', NULL, '1016497921022545920', NULL, 'JScrollBoard', '{\"chartData\":\"[    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"上账\\\",        \\\"A\\\": \\\"244.50\\\",        \\\"B\\\": \\\"0.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"上账\\\",        \\\"A\\\": \\\"0.00\\\",        \\\"B\\\": \\\"1000.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"下账\\\",        \\\"A\\\": \\\"64.50\\\",        \\\"B\\\": \\\"0.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"下账\\\",        \\\"A\\\": \\\"0.00\\\",        \\\"B\\\": \\\"162.30\\\",        \\\"C\\\": \\\"16.71\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"上账\\\",        \\\"A\\\": \\\"2000.00\\\",        \\\"B\\\": \\\"0.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"上账\\\",        \\\"A\\\": \\\"20.10\\\",        \\\"B\\\": \\\"0.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"下账\\\",        \\\"A\\\": \\\"0.00\\\",        \\\"B\\\": \\\"120.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"上账\\\",        \\\"A\\\": \\\"244.10\\\",        \\\"B\\\": \\\"0.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"下账\\\",        \\\"A\\\": \\\"0.50\\\",        \\\"B\\\": \\\"0.00\\\",        \\\"C\\\": \\\"120.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"下账\\\",        \\\"A\\\": \\\"0.00\\\",        \\\"B\\\": \\\"1000.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"下账\\\",        \\\"A\\\": \\\"244.50\\\",        \\\"B\\\": \\\"0.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890\\\",        \\\"level\\\": \\\"宽管\\\",        \\\"item\\\": \\\"下账\\\",        \\\"A\\\": \\\"244.50\\\",        \\\"B\\\": \\\"0.00\\\",        \\\"C\\\": \\\"0.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    }]\",\"size\":{\"width\":671,\"height\":338},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"oddRowBGC\":\"#030D3A\",\"headShow\":true,\"hoverPause\":true,\"indexWidth\":80,\"index\":false,\"carousel\":\"single\",\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"evenRowBGC\":\"#003B51\",\"header\":[{\"width\":100,\"label\":\"罪犯姓名\"},{\"width\":100,\"label\":\"罪犯编号\"},{\"width\":100,\"label\":\"处遇等级\"},{\"width\":100,\"label\":\"流向\"},{\"width\":100,\"label\":\"A账户\"},{\"width\":100,\"label\":\"B账户\"},{\"width\":100,\"label\":\"C账户\"},{\"width\":100,\"label\":\"时间\"}],\"headerBGC\":\"#041732\",\"headerHeight\":55,\"waitTime\":2000,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1019836136794148864', NULL, '1016497921022545920', NULL, 'JScrollBoard', '{\"chartData\":\"[    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"出所结算\\\",        \\\"item\\\": \\\"205.32\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"出所结算\\\",        \\\"item\\\": \\\"68.32\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"银行结算\\\",        \\\"item\\\": \\\"381.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"银行结算\\\",        \\\"item\\\": \\\"381.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"出所结算\\\",        \\\"item\\\": \\\"8.32\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"出所结算\\\",        \\\"item\\\": \\\"68.32\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"银行结算\\\",        \\\"item\\\": \\\"381.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"银行结算\\\",        \\\"item\\\": \\\"381.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"出所结算\\\",        \\\"item\\\": \\\"68.32\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"银行结算\\\",        \\\"item\\\": \\\"32.24\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"李慧\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"银行结算\\\",        \\\"item\\\": \\\"381.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"银行结算\\\",        \\\"item\\\": \\\"381.00\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"出所结算\\\",        \\\"item\\\": \\\"68.32\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    },    {        \\\"name\\\": \\\"张三\\\",        \\\"SN\\\": \\\"1234657890023154\\\",        \\\"manage\\\": \\\"银行结算\\\",        \\\"item\\\": \\\"32.24\\\",        \\\"time\\\": \\\"2020-11-19 15:30:15\\\"    }]\",\"size\":{\"width\":531,\"height\":326},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"option\":{\"oddRowBGC\":\"#030D3A\",\"headShow\":true,\"hoverPause\":true,\"indexWidth\":80,\"index\":false,\"carousel\":\"single\",\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"evenRowBGC\":\"#003B51\",\"header\":[{\"width\":100,\"label\":\"罪犯姓名\"},{\"width\":100,\"label\":\"银行账户\"},{\"width\":100,\"label\":\"异常来源\"},{\"width\":100,\"label\":\"异常金额\"},{\"width\":100,\"label\":\"时间\"}],\"headerBGC\":\"#041732\",\"headerHeight\":55,\"waitTime\":2000,\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-22 15:11:33', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143312891904', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":1917.0000000000002,\"height\":80},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6%E5%A4%B4%E5%9B%BE%E7%89%87_1657175683138.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143350640640', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"北京科技数字化云平台\",\"size\":{\"width\":420,\"height\":77},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":7,\"fontSize\":27,\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":13,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143363223552', NULL, '1014376428645961728', NULL, 'JCurrentTime', '{\"chartData\":\"\",\"borderColor\":\"#FFFFFF00\",\"size\":{\"width\":421,\"height\":35},\"background\":\"#FFFFFF00\",\"w\":6,\"dataType\":1,\"h\":6,\"turnConfig\":{\"url\":\"\"},\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"option\":{\"body\":{\"color\":\"#13DADD\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"showWeek\":\"hide\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143375806464', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":130,\"height\":52},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6菱形_1657175841432.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143384195072', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"网关管理\",\"size\":{\"width\":80,\"height\":41},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143392583680', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":130,\"height\":52},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6菱形_1657175841432.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143405166592', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"云组态\",\"size\":{\"width\":80,\"height\":40},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143426138112', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":130,\"height\":52},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6菱形_1657175841432.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143442915328', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":130,\"height\":52},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6菱形_1657175841432.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143455498240', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":130,\"height\":52},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6菱形_1657175841432.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143468081152', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":130,\"height\":52},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6菱形_1657175841432.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143484858368', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":130,\"height\":52},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6菱形_1657175841432.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143501635584', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":130,\"height\":52},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6菱形_1657175841432.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143514218496', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"设备管理\",\"size\":{\"width\":81,\"height\":40},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143526801408', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"动态数据\",\"size\":{\"width\":80,\"height\":40},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143539384320', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"人员管理\",\"size\":{\"width\":80,\"height\":40},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143560355840', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"监控管理\",\"size\":{\"width\":80,\"height\":40},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143577133056', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"人员定位\",\"size\":{\"width\":80,\"height\":40},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143593910272', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"能源管理\",\"size\":{\"width\":80,\"height\":40},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143606493184', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":465,\"height\":260},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6左上_1657176154547.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143619076096', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"功耗总量\",\"size\":{\"width\":115,\"height\":33.99999999999994},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143635853312', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"电能耗|水能耗\",\"size\":{\"width\":267.00000000000006,\"height\":42.999999999999886},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":15,\"fontSize\":21,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143648436224', NULL, '1014376428645961728', NULL, 'JCountTo', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"17563\",\"size\":{\"width\":87.99999999999996,\"height\":40.52517985611512},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"suffixFontSize\":16,\"borderColor\":\"#31aefd\",\"prefixColor\":\"#FFFFFF\",\"color\":\"#FFFFFF\",\"suffixFontWeight\":\"normal\",\"prefix\":\"\",\"whole\":true,\"boxHeight\":50,\"suffix\":\"\",\"type\":\"img\",\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"prefixFontSize\":16,\"prefixFontWeight\":\"normal\",\"suffixColor\":\"#FFFFFF\",\"fontSize\":16,\"boxWidth\":50,\"fontWeight\":\"normal\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143665213440', NULL, '1014376428645961728', NULL, 'JCountTo', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"11163\",\"size\":{\"width\":91.99999999999994,\"height\":39.00000000000006},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#4A90E200\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"suffixFontSize\":16,\"borderColor\":\"#31aefd\",\"prefixColor\":\"#FFFFFF\",\"color\":\"#FFFFFF\",\"suffixFontWeight\":\"normal\",\"prefix\":\"\",\"whole\":true,\"boxHeight\":50,\"suffix\":\"\",\"type\":\"none\",\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"prefixFontSize\":16,\"prefixFontWeight\":\"normal\",\"suffixColor\":\"#FFFFFF\",\"fontSize\":16,\"boxWidth\":50,\"fontWeight\":\"normal\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143690379264', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"kw/h\",\"size\":{\"width\":80.00000000000006,\"height\":32.99999999999994},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":22,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143711350784', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"kw/h\",\"size\":{\"width\":91.00000000000006,\"height\":31.999999999999886},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":22,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143728128000', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":468,\"height\":632},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6左下_1657176316163.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143744905216', NULL, '1014376428645961728', NULL, 'JBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"一日\\\",    \\\"value\\\": 1280,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"二日\\\",    \\\"value\\\": 2000,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"三日\\\",    \\\"value\\\": 1756,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"四日\\\",    \\\"value\\\": 1240,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"五日\\\",    \\\"value\\\": 800,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"六日\\\",    \\\"value\\\": 1654,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"七日\\\",    \\\"value\\\": 2125,    \\\"type\\\": \\\"近七日电能耗\\\"  }]\",\"size\":{\"width\":393,\"height\":264},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":true,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#CCCCCC\"}},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"},\"show\":false},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":46,\"left\":1,\"bottom\":20,\"show\":false,\"right\":6,\"containLabel\":true},\"series\":[{\"barWidth\":12,\"data\":[],\"itemStyle\":{\"color\":\"#00CED1\",\"borderRadius\":3},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\"},\"title\":{\"subtext\":\"\",\"left\":137,\"show\":true,\"text\":\"近七日电能耗\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontSize\":17,\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143761682432', NULL, '1014376428645961728', NULL, 'JBar', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"name\\\": \\\"一日\\\",    \\\"value\\\": 1280,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"二日\\\",    \\\"value\\\": 2000,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"三日\\\",    \\\"value\\\": 1756,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"四日\\\",    \\\"value\\\": 1240,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"五日\\\",    \\\"value\\\": 800,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"六日\\\",    \\\"value\\\": 1654,    \\\"type\\\": \\\"近七日电能耗\\\"  },  {    \\\"name\\\": \\\"七日\\\",    \\\"value\\\": 2125,    \\\"type\\\": \\\"近七日电能耗\\\"  }]\",\"size\":{\"width\":391,\"height\":266},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"lineStyle\":{\"color\":\"#f3f3f3\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#909198\"},\"show\":true,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"xAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"axisLine\":{\"lineStyle\":{\"color\":\"#CCCCCC\"}},\"splitLine\":{\"lineStyle\":{\"color\":\"#F3F3F3\"},\"show\":false},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":46,\"left\":1,\"bottom\":20,\"show\":false,\"right\":6,\"containLabel\":true},\"series\":[{\"barWidth\":12,\"data\":[],\"itemStyle\":{\"color\":\"#00CED1\",\"borderRadius\":3},\"type\":\"bar\"}],\"tooltip\":{\"axisPointer\":{\"label\":{\"backgroundColor\":\"#333\",\"show\":true},\"type\":\"shadow\"},\"trigger\":\"axis\",\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"subtext\":\"\",\"left\":116,\"show\":true,\"text\":\"近七日水能耗\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontSize\":17,\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143786848256', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":857,\"height\":483},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6border16_1657176410080.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143803625472', NULL, '1014376428645961728', NULL, 'JGauge', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"名称\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/gauge\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"min\\\": 1,    \\\"max\\\": 210,    \\\"label\\\": \\\"名称\\\",    \\\"value\\\": 66,    \\\"unit\\\": \\\"%\\\"  }]\",\"size\":{\"width\":465,\"height\":300},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"bottom\":115},\"series\":[{\"axisLabel\":{\"show\":true,\"fontSize\":12},\"data\":[],\"splitLine\":{\"lineStyle\":{\"color\":\"#eee\",\"width\":4},\"length\":12},\"axisTick\":{\"lineStyle\":{\"color\":\"#eee\"},\"show\":true},\"progress\":{\"show\":true},\"itemStyle\":{\"color\":\"#64b5f6\"},\"detail\":{\"formatter\":\"{value}\",\"fontSize\":25},\"type\":\"gauge\"}],\"tooltip\":{\"formatter\":\"{a} <br/>{b} : {c}%\"},\"title\":{\"top\":213,\"left\":159,\"text\":\"二号机房功率\",\"textStyle\":{\"color\":\"#9AA8D4\",\"fontSize\":16,\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143816208384', NULL, '1014376428645961728', NULL, 'JGauge', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"名称\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/gauge\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"min\\\": 1,    \\\"max\\\": 210,    \\\"label\\\": \\\"名称\\\",    \\\"value\\\": 50,    \\\"unit\\\": \\\"%\\\"  }]\",\"size\":{\"width\":359,\"height\":253},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"bottom\":115},\"series\":[{\"axisLabel\":{\"show\":true,\"fontSize\":12},\"data\":[],\"splitLine\":{\"lineStyle\":{\"color\":\"#eee\",\"width\":4},\"length\":12},\"axisTick\":{\"lineStyle\":{\"color\":\"#eee\"},\"show\":true},\"progress\":{\"show\":true},\"itemStyle\":{\"color\":\"#64b5f6\"},\"detail\":{\"formatter\":\"{value}\",\"fontSize\":25},\"type\":\"gauge\"}],\"tooltip\":{\"formatter\":\"{a} <br/>{b} : {c}%\"},\"title\":{\"top\":179,\"left\":117,\"text\":\"三号机房功率\",\"textStyle\":{\"color\":\"#9AA8D4\",\"fontSize\":15,\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143837179904', NULL, '1014376428645961728', NULL, 'JGauge', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"名称\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/gauge\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"min\\\": 1,    \\\"max\\\": 210,    \\\"label\\\": \\\"名称\\\",    \\\"value\\\": 30,    \\\"unit\\\": \\\"%\\\"  }]\",\"size\":{\"width\":359,\"height\":253},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"bottom\":115},\"series\":[{\"axisLabel\":{\"show\":true,\"fontSize\":12},\"data\":[],\"splitLine\":{\"lineStyle\":{\"color\":\"#eee\",\"width\":4},\"length\":12},\"axisTick\":{\"lineStyle\":{\"color\":\"#eee\"},\"show\":true},\"progress\":{\"show\":true},\"itemStyle\":{\"color\":\"#64b5f6\"},\"detail\":{\"formatter\":\"{value}\",\"fontSize\":25},\"type\":\"gauge\"}],\"tooltip\":{\"formatter\":\"{a} <br/>{b} : {c}%\"},\"title\":{\"top\":177,\"left\":117,\"text\":\"四号机房功率\",\"textStyle\":{\"color\":\"#9AA8D4\",\"fontSize\":15,\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143853957120', NULL, '1014376428645961728', NULL, 'JGauge', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"名称\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/gauge\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"min\\\": 1,    \\\"max\\\": 210,    \\\"label\\\": \\\"名称\\\",    \\\"value\\\": 90,    \\\"unit\\\": \\\"%\\\"  }]\",\"size\":{\"width\":359,\"height\":253},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"bottom\":115},\"series\":[{\"axisLabel\":{\"show\":true,\"fontSize\":12},\"data\":[],\"splitLine\":{\"lineStyle\":{\"color\":\"#eee\",\"width\":4},\"length\":12},\"axisTick\":{\"lineStyle\":{\"color\":\"#eee\"},\"show\":true},\"progress\":{\"show\":true},\"itemStyle\":{\"color\":\"#64b5f6\"},\"detail\":{\"formatter\":\"{value}\",\"fontSize\":25},\"type\":\"gauge\"}],\"tooltip\":{\"formatter\":\"{a} <br/>{b} : {c}%\"},\"title\":{\"top\":177,\"left\":117,\"text\":\"五号机房功率\",\"textStyle\":{\"color\":\"#9AA8D4\",\"fontSize\":15,\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143870734336', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":859,\"height\":390},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6中下_1657176573600.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143895900160', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"设备列表\",\"size\":{\"width\":184,\"height\":44.000000000000064},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":17,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143921065984', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":465,\"height\":449},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6右上_1657176473804.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143933648896', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"信息\",\"size\":{\"width\":342,\"height\":51},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143946231808', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"站点号：0001\",\"size\":{\"width\":459,\"height\":80},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143958814720', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"设备状态：正常\",\"size\":{\"width\":460,\"height\":80},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143983980544', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"环境温度：36摄氏度\",\"size\":{\"width\":458,\"height\":80},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338143996563456', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"在线设备：20 台\",\"size\":{\"width\":459,\"height\":80},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":0,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338144009146368', NULL, '1014376428645961728', NULL, 'JImg', '{\"size\":{\"width\":465,\"height\":410},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":6,\"dataType\":1,\"h\":26,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/6右上_1657176473804.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338144025923584', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"近七日设备在线数\",\"size\":{\"width\":340,\"height\":44},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":15,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338144046895104', NULL, '1014376428645961728', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"设备功率信息\",\"size\":{\"width\":465,\"height\":57.99999999999997},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#13DADD\",\"letterSpacing\":17,\"fontSize\":18,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338144063672320', NULL, '1014376428645961728', NULL, 'JLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"value\\\": 20,    \\\"name\\\": \\\"1\\\"  },  {    \\\"value\\\": 19,    \\\"name\\\": \\\"2\\\"  },  {    \\\"value\\\": 20,    \\\"name\\\": \\\"3\\\"  },  {    \\\"value\\\": 17,    \\\"name\\\": \\\"4\\\"  },  {    \\\"value\\\": 18,    \\\"name\\\": \\\"5\\\"  },  {    \\\"value\\\": 20,    \\\"name\\\": \\\"6\\\"  },  {    \\\"value\\\": 20,    \\\"name\\\": \\\"7\\\"  },  {    \\\"value\\\": 16,    \\\"name\\\": \\\"8\\\"  },  {    \\\"value\\\": 17,    \\\"name\\\": \\\"9\\\"  },  {    \\\"value\\\": 19,    \\\"name\\\": \\\"10\\\"  }]\",\"size\":{\"width\":466,\"height\":288},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#EEF1FA\"},\"max\":30,\"axisLine\":{\"lineStyle\":{\"color\":\"#039199\"},\"show\":true},\"splitLine\":{\"lineStyle\":{\"color\":\"#CCCCCC\"},\"show\":false},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"grid\":{\"top\":9,\"left\":31,\"bottom\":41,\"show\":false,\"right\":1},\"series\":[{\"areaStyleOpacity\":0.5,\"data\":[],\"lineType\":\"area\",\"itemStyle\":{\"color\":\"#64b5f6\"},\"label\":{\"color\":\"#EEF1FA\",\"show\":false},\"type\":\"line\"}],\"tooltip\":{\"textStyle\":{\"color\":\"#EEF1FA\"}},\"title\":{\"subtext\":\"\",\"left\":10,\"show\":false,\"text\":\"基础折线图\",\"textStyle\":{\"color\":\"#EEF1FA\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338144080449536', NULL, '1014376428645961728', NULL, 'JScrollTable', '{\"borderColor\":\"#FFFFFF00\",\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[  {    \\\"type1\\\": \\\"0374\\\",    \\\"type2\\\": \\\"1号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"5322\\\",    \\\"type2\\\": \\\"2号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"185\\\"  },  {    \\\"type1\\\": \\\"1753\\\",    \\\"type2\\\": \\\"1号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"0022\\\",    \\\"type2\\\": \\\"2号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"8509\\\",    \\\"type2\\\": \\\"3号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"0374\\\",    \\\"type2\\\": \\\"4号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"5322\\\",    \\\"type2\\\": \\\"2号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"185\\\"  },  {    \\\"type1\\\": \\\"1753\\\",    \\\"type2\\\": \\\"1号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"0022\\\",    \\\"type2\\\": \\\"2号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"8509\\\",    \\\"type2\\\": \\\"3号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"0374\\\",    \\\"type2\\\": \\\"4号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"5322\\\",    \\\"type2\\\": \\\"2号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"185\\\"  },  {    \\\"type1\\\": \\\"1753\\\",    \\\"type2\\\": \\\"1号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"0022\\\",    \\\"type2\\\": \\\"2号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"8509\\\",    \\\"type2\\\": \\\"3号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"0374\\\",    \\\"type2\\\": \\\"4号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"5322\\\",    \\\"type2\\\": \\\"2号搅机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"185\\\"  },  {    \\\"type1\\\": \\\"1753\\\",    \\\"type2\\\": \\\"1号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"0022\\\",    \\\"type2\\\": \\\"2号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"8509\\\",    \\\"type2\\\": \\\"3号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  },  {    \\\"type1\\\": \\\"0374\\\",    \\\"type2\\\": \\\"4号机房\\\",    \\\"type3\\\": \\\"正常\\\",    \\\"type4\\\": \\\"180\\\"  }]\",\"size\":{\"width\":852,\"height\":329},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"evenColor\":\"#003B51\",\"headerBgColor\":\"#0A73FF\",\"fieldMapping\":[{\"name\":\"编号\",\"width\":150,\"key\":\"type1\"},{\"name\":\"设备名\",\"width\":300,\"key\":\"type2\"},{\"name\":\"设备状态\",\"width\":200,\"key\":\"type3\"},{\"name\":\"功率\",\"width\":150,\"key\":\"type4\"}],\"showHead\":true,\"scroll\":true,\"scrollTime\":5000,\"lineHeight\":50,\"fontSize\":24,\"bodyFontColor\":\"#FFFFFF\",\"showBorder\":true,\"oddColor\":\"#0A2732\",\"headerFontColor\":\"#FFFFFF\"}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021338144088838144', NULL, '1014376428645961728', NULL, 'JGauge', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"名称\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":30,\"url\":\"http://api.jeecg.com/mock/26/gauge\",\"timeOut\":-1,\"chartData\":\"[  {    \\\"min\\\": 1,    \\\"max\\\": 210,    \\\"label\\\": \\\"名称\\\",    \\\"value\\\": 70,    \\\"unit\\\": \\\"%\\\"  }]\",\"size\":{\"width\":524,\"height\":301},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":6,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"bottom\":115},\"series\":[{\"axisLabel\":{\"show\":true,\"fontSize\":12},\"data\":[],\"splitLine\":{\"lineStyle\":{\"color\":\"#EEEEEE\",\"width\":4},\"length\":12},\"axisTick\":{\"lineStyle\":{\"color\":\"#EEEEEE\"},\"show\":true},\"progress\":{\"show\":true},\"itemStyle\":{\"color\":\"#64b5f6\"},\"detail\":{\"formatter\":\"{value}\",\"fontSize\":25},\"type\":\"gauge\"}],\"tooltip\":{\"formatter\":\"{a} <br/>{b} : {c}%\"},\"title\":{\"top\":211,\"left\":159,\"text\":\"一号机房功率\",\"textStyle\":{\"color\":\"#9AA8D4\",\"fontSize\":16,\"fontWeight\":\"normal\"},\"subtextStyle\":{\"color\":\"#B9B8CE\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"headColor\":\"#1D1F26\",\"textStyle\":{\"color\":\"#FFFFFF\"},\"title\":\"\"}}}', 'admin', '2024-11-26 18:39:59', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592459091968', NULL, '1016994272231608320', NULL, 'JDragBorder', '{\"size\":{\"width\":801,\"height\":926},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592501035008', NULL, '1016994272231608320', NULL, 'JDragBorder', '{\"size\":{\"width\":488,\"height\":926},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592526200832', NULL, '1016994272231608320', NULL, 'JDragBorder', '{\"size\":{\"width\":507,\"height\":926},\"w\":450,\"dataType\":1,\"h\":300,\"option\":{\"dur\":3,\"backgroundColor\":\"#ffffff00\",\"mainColor\":\"#83BFF6\",\"titleWidth\":250,\"type\":\"8\",\"title\":\"边框\",\"subColor\":\"#00CED1\",\"reverse\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592555560960', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"旅游数据分析中心大屏\",\"size\":{\"width\":636,\"height\":88},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#E8E8E8\",\"letterSpacing\":5,\"fontSize\":50,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592568143872', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"实时天气\",\"size\":{\"width\":139,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#D9D9D9\",\"fontSize\":25,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592584921088', NULL, '1016994272231608320', NULL, 'JImg', '{\"size\":{\"width\":91,\"height\":74},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/晴天_1623315350106.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592601698304', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"游客性别统计\",\"size\":{\"width\":171,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#D9D9D9\",\"fontSize\":25,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592622669824', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"近七天游客流量统计\",\"size\":{\"width\":231,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#D9D9D9\",\"fontSize\":25,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592647835648', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"今日游客统计\",\"size\":{\"width\":200,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#D9D9D9\",\"fontSize\":25,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592664612864', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"截止到当前时间段\",\"size\":{\"width\":212.7698028883034,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#DDDDDB\",\"fontSize\":20,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592681390080', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"过去7天车辆抓拍总数\",\"size\":{\"width\":267,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#D9D9D9\",\"fontSize\":25,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592706555904', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"车辆类型统计\",\"size\":{\"width\":205,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#D9D9D9\",\"fontSize\":25,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592735916032', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"车辆归属地统计\",\"size\":{\"width\":192,\"height\":39},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#D9D9D9\",\"fontSize\":25,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592765276160', NULL, '1016994272231608320', NULL, 'JDragDecoration', '{\"size\":{\"width\":443,\"height\":100},\"w\":300,\"dataType\":1,\"h\":100,\"option\":{\"dur\":3,\"mainColor\":\"#00CED1\",\"fontSize\":15,\"type\":\"1\",\"title\":\"装饰1\",\"subColor\":\"#FAD400\",\"reverse\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592786247680', NULL, '1016994272231608320', NULL, 'JWeatherForecast', '{\"size\":{\"height\":47},\"w\":257,\"dataType\":1,\"h\":47,\"option\":{\"template\":94,\"bgColor\":\"\",\"city\":\"\",\"num\":2,\"fontSize\":16,\"fontColor\":\"#fff\",\"url\":\"\"}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592807219200', NULL, '1016994272231608320', NULL, 'JCurrentTime', '{\"chartData\":\"\",\"borderColor\":\"#FFFFFF00\",\"size\":{\"height\":33},\"background\":\"#FFFFFF00\",\"w\":270,\"dataType\":1,\"h\":33,\"turnConfig\":{\"url\":\"\"},\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"option\":{\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"showWeek\":\"show\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592844967936', NULL, '1016994272231608320', NULL, 'JDragDecoration', '{\"size\":{\"width\":383,\"height\":47},\"w\":300,\"dataType\":1,\"h\":27,\"option\":{\"dur\":3,\"mainColor\":\"#00CED1\",\"fontSize\":15,\"type\":\"10\",\"title\":\"装饰10\",\"subColor\":\"#FAD400\",\"reverse\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592861745152', NULL, '1016994272231608320', NULL, 'JLine', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[    {        \\\"name\\\": \\\"周一\\\",        \\\"value\\\": 1000879,        \\\"type\\\": \\\"手机品牌\\\"    },    {        \\\"name\\\": \\\"周二\\\",        \\\"value\\\": 3400879,        \\\"type\\\": \\\"手机品牌\\\"    },    {        \\\"name\\\": \\\"周三\\\",        \\\"value\\\": 2300879,        \\\"type\\\": \\\"手机品牌\\\"    },    {        \\\"name\\\": \\\"周四\\\",        \\\"value\\\": 5400879,        \\\"type\\\": \\\"手机品牌\\\"    },    {        \\\"name\\\": \\\"周五\\\",        \\\"value\\\": 3400879,        \\\"type\\\": \\\"手机品牌\\\"    },    {        \\\"name\\\": \\\"周六\\\",        \\\"value\\\": 7400879,        \\\"type\\\": \\\"手机品牌\\\"    },    {        \\\"name\\\": \\\"周日\\\",        \\\"value\\\": 8400879,        \\\"type\\\": \\\"手机品牌\\\"    }]\",\"size\":{\"width\":488,\"height\":300},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"yAxis\":{\"axisLabel\":{\"color\":\"#909198\"},\"splitLine\":{\"lineStyle\":{\"color\":\"#9B9B9B\"},\"show\":false,\"interval\":2},\"nameTextStyle\":{\"color\":\"#EEF1FA\"}},\"customColor\":[{\"color\":\"#EECC0C\"}],\"xAxis\":{\"axisLabel\":{\"color\":\"#909198\"}},\"grid\":{\"top\":12,\"left\":0,\"bottom\":18,\"show\":false,\"right\":40,\"containLabel\":true},\"series\":[{\"symbol\":\"circle\",\"data\":[],\"symbolSize\":12,\"itemStyle\":{\"color\":\"#64b5f6\"},\"type\":\"line\",\"lineWidth\":2}],\"title\":{\"subtext\":\"\",\"left\":10,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592878522368', NULL, '1016994272231608320', NULL, 'JDragDecoration', '{\"size\":{\"width\":396,\"height\":41},\"w\":300,\"dataType\":1,\"h\":27,\"option\":{\"dur\":3,\"mainColor\":\"#00CED1\",\"fontSize\":15,\"type\":\"10\",\"title\":\"装饰10\",\"subColor\":\"#FAD400\",\"reverse\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592899493888', NULL, '1016994272231608320', NULL, 'JGender', '{\"chartData\":\"[{\\\"man\\\":50,\\\"woman\\\":35}]\",\"size\":{\"width\":317,\"height\":245},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"男\"},{\"mapping\":\"\",\"filed\":\"女\"}],\"w\":450,\"dataType\":1,\"h\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"url\":\"http://api.jeecg.com/mock/26/pictogram\",\"timeOut\":0,\"option\":{\"grid\":{\"bottom\":115},\"series\":[],\"title\":{\"show\":true,\"text\":\"\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592941436928', NULL, '1016994272231608320', NULL, 'JDragDecoration', '{\"size\":{\"width\":604,\"height\":100},\"w\":300,\"dataType\":1,\"h\":100,\"option\":{\"dur\":3,\"mainColor\":\"#00CED1\",\"fontSize\":18,\"type\":\"2\",\"title\":\"装饰2\",\"subColor\":\"#FAD400\",\"reverse\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592958214144', NULL, '1016994272231608320', NULL, 'JCountTo', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":80,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"8745987\",\"size\":{\"width\":712,\"height\":142.9496402877698},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":300,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"suffixFontSize\":16,\"borderColor\":\"#31aefd\",\"prefixColor\":\"#FFFFFF\",\"color\":\"#EAC910\",\"suffixFontWeight\":\"normal\",\"prefix\":\"\",\"whole\":false,\"boxHeight\":95,\"suffix\":\"\",\"type\":\"img\",\"body\":{\"color\":\"#FFFFFF\",\"text\":\"\",\"fontWeight\":\"bold\",\"marginTop\":0,\"marginLeft\":0},\"prefixFontSize\":16,\"prefixFontWeight\":\"normal\",\"suffixColor\":\"#FFFFFF\",\"borderImg\":\"/img/bg/border/border1.png\",\"fontFamily\":\"DIGITALDREAMFAT\",\"gridY\":5,\"backgroundImg\":\"\",\"fontSize\":50,\"boxWidth\":90,\"fontWeight\":\"bold\",\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960592991768576', NULL, '1016994272231608320', NULL, 'JBubbleMap', '{\"borderColor\":\"#FFFFFF00\",\"commonOption\":{\"barSize\":10,\"gradientColor\":false,\"breadcrumb\":{\"drillDown\":false,\"textColor\":\"#000000\"},\"areaColor\":{\"color1\":\"#132937\",\"color2\":\"#0A0909\"},\"barColor\":\"#fff176\",\"barColor2\":\"#fcc02e\",\"inRange\":{\"color\":[\"#04387b\",\"#467bc0\"]}},\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"区域\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"jsConfig\":\"\",\"dataType\":1,\"h\":300,\"activeKey\":1,\"url\":\"http://api.jeecg.com/mock/33/radar\",\"timeOut\":0,\"chartData\":\"[{\\\"name\\\":\\\"北京\\\",\\\"value\\\":199},{\\\"name\\\":\\\"新疆\\\",\\\"value\\\":180},{\\\"name\\\":\\\"河南\\\",\\\"value\\\":137},{\\\"name\\\":\\\"四川\\\",\\\"value\\\":125},{\\\"name\\\":\\\"黑龙江\\\",\\\"value\\\":123},{\\\"name\\\":\\\"广东\\\",\\\"value\\\":123},{\\\"name\\\":\\\"山东\\\",\\\"value\\\":119},{\\\"name\\\":\\\"福建\\\",\\\"value\\\":116},{\\\"name\\\":\\\"湖北\\\",\\\"value\\\":116},{\\\"name\\\":\\\"浙江\\\",\\\"value\\\":114},{\\\"name\\\":\\\"湖南\\\",\\\"value\\\":114},{\\\"name\\\":\\\"安徽\\\",\\\"value\\\":109},{\\\"name\\\":\\\"河北\\\",\\\"value\\\":102},{\\\"name\\\":\\\"江苏\\\",\\\"value\\\":92},{\\\"name\\\":\\\"江西\\\",\\\"value\\\":91},{\\\"name\\\":\\\"重庆\\\",\\\"value\\\":91},{\\\"name\\\":\\\"云南\\\",\\\"value\\\":83},{\\\"name\\\":\\\"吉林\\\",\\\"value\\\":82},{\\\"name\\\":\\\"山西\\\",\\\"value\\\":81},{\\\"name\\\":\\\"陕西\\\",\\\"value\\\":80},{\\\"name\\\":\\\"辽宁\\\",\\\"value\\\":67},{\\\"name\\\":\\\"贵州\\\",\\\"value\\\":62},{\\\"name\\\":\\\"广西\\\",\\\"value\\\":59},{\\\"name\\\":\\\"甘肃\\\",\\\"value\\\":56},{\\\"name\\\":\\\"内蒙古\\\",\\\"value\\\":47},{\\\"name\\\":\\\"天津\\\",\\\"value\\\":42},{\\\"name\\\":\\\"上海\\\",\\\"value\\\":24},{\\\"name\\\":\\\"宁夏\\\",\\\"value\\\":18},{\\\"name\\\":\\\"海南\\\",\\\"value\\\":14},{\\\"name\\\":\\\"青海\\\",\\\"value\\\":10},{\\\"name\\\":\\\"西藏\\\",\\\"value\\\":9}]\",\"size\":{\"width\":718,\"height\":527},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"drillDown\":false,\"area\":{\"markerColor\":\"#DDE330\",\"shadowBlur\":10,\"markerCount\":5,\"markerOpacity\":1,\"name\":[\"中国\"],\"scatterLabelShow\":false,\"shadowColor\":\"#DDE330\",\"value\":[\"china\"],\"markerType\":\"effectScatter\"},\"geo\":{\"top\":25,\"itemStyle\":{\"normal\":{\"shadowOffsetX\":0,\"shadowOffsetY\":0,\"borderColor\":\"#068FA1\",\"areaColor\":\"\",\"shadowBlur\":0,\"borderWidth\":1,\"shadowColor\":\"#80D9F8\"},\"emphasis\":{\"areaColor\":\"#FFF59C\",\"borderWidth\":0}},\"zoom\":1.2,\"label\":{\"emphasis\":{\"color\":\"#fff\",\"show\":false}},\"roam\":true},\"grid\":{\"bottom\":115,\"show\":false},\"legend\":{\"data\":[]},\"title\":{\"top\":19,\"left\":224,\"show\":true,\"text\":\"全国游客分布情况\",\"textStyle\":{\"color\":\"#FFD700\",\"fontSize\":25,\"fontWeight\":\"normal\"}},\"graphic\":[],\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"visualMap\":{\"min\":0,\"top\":\"bottom\",\"max\":200,\"left\":\"5%\",\"calculable\":true,\"show\":false,\"type\":\"continuous\",\"seriesIndex\":[1]}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960593008545792', NULL, '1016994272231608320', NULL, 'JImg', '{\"size\":{\"width\":54,\"height\":51},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"w\":450,\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":-1,\"option\":{\"padding\":0,\"backgroundColor\":\"\",\"borderRadius\":0,\"rotateTime\":1000,\"opacity\":1,\"body\":{\"url\":\"https://static.jeecg.com/bigscreen/汽车用品_1623316498991.png\"},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"},\"izRotate\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960593029517312', NULL, '1016994272231608320', NULL, 'JDragDecoration', '{\"size\":{\"width\":406,\"height\":47},\"w\":300,\"dataType\":1,\"h\":27,\"option\":{\"dur\":3,\"mainColor\":\"#00CED1\",\"fontSize\":15,\"type\":\"10\",\"title\":\"装饰10\",\"subColor\":\"#FAD400\",\"reverse\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960593063071744', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"车辆抓拍总数\",\"size\":{\"width\":134,\"height\":33},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FAD400\",\"fontSize\":21,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960593079848960', NULL, '1016994272231608320', NULL, 'JText', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":33,\"url\":\"http://api.jeecg.com/mock/42/nav\",\"timeOut\":0,\"chartData\":\"12345\",\"size\":{\"width\":128,\"height\":45},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":100,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"body\":{\"color\":\"#FAD400\",\"fontSize\":44,\"text\":\"\",\"fontWeight\":\"normal\",\"marginTop\":0,\"marginLeft\":0},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960593096626176', NULL, '1016994272231608320', NULL, 'JRing', '{\"borderColor\":\"#FFFFFF00\",\"dataMapping\":[{\"mapping\":\"\",\"filed\":\"维度\"},{\"mapping\":\"\",\"filed\":\"数值\"}],\"dataType\":1,\"h\":300,\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[    {        \\\"name\\\": \\\"客车\\\",        \\\"value\\\": 1000879    },    {        \\\"name\\\": \\\"轿车\\\",        \\\"value\\\": 3400879    },    {        \\\"name\\\": \\\"SUV\\\",        \\\"value\\\": 2300879    },    {        \\\"name\\\": \\\"货车\\\",        \\\"value\\\": 5400879    },    {        \\\"name\\\": \\\"摩托车\\\",        \\\"value\\\": 3000    },    {        \\\"name\\\": \\\"自行车\\\",        \\\"value\\\": 2000    }]\",\"size\":{\"width\":436,\"height\":300},\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"background\":\"#FFFFFF00\",\"w\":480,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"option\":{\"grid\":{\"top\":50,\"left\":50,\"show\":false},\"series\":[{\"data\":[],\"name\":\"Access From\",\"avoidLabelOverlap\":false,\"emphasis\":{\"label\":{\"color\":\"#FFFFFF\",\"show\":true,\"fontSize\":14,\"fontWeight\":\"bold\"}},\"label\":{\"color\":\"#EEF1FA\",\"show\":true,\"position\":\"center\"},\"labelLine\":{\"show\":false},\"type\":\"pie\",\"radius\":[\"40%\",\"70%\"]}],\"legend\":{\"r\":1,\"orient\":\"vertical\",\"t\":1,\"show\":false},\"tooltip\":{\"trigger\":\"item\"},\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960593121792000', NULL, '1016994272231608320', NULL, 'JDragDecoration', '{\"size\":{\"width\":421,\"height\":47},\"w\":300,\"dataType\":1,\"h\":27,\"option\":{\"dur\":3,\"mainColor\":\"#00CED1\",\"fontSize\":15,\"type\":\"10\",\"title\":\"装饰10\",\"subColor\":\"#FAD400\",\"reverse\":false}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);
INSERT INTO `onl_drag_page_comp` (`id`, `parent_id`, `page_Id`, `comp_id`, `component`, `config`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1021960593138569216', NULL, '1016994272231608320', NULL, 'JCapsuleChart', '{\"dataMapping\":[{\"mapping\":\"name\",\"filed\":\"维度\"},{\"mapping\":\"value\",\"filed\":\"数值\"}],\"paramOption\":[],\"dataType\":2,\"dataSetName\":\"车辆归属地\",\"query\":[],\"h\":300,\"dataSetApi\":\"https://api.jeecg.com/mock/26/activering\",\"drillData\":[],\"url\":\"http://api.jeecg.com/mock/33/chart\",\"timeOut\":0,\"chartData\":\"[{\\\"name\\\":\\\"苹果\\\",\\\"value\\\":1000879,\\\"type\\\":\\\"手机品牌\\\"},{\\\"name\\\":\\\"三星\\\",\\\"value\\\":3400879,\\\"type\\\":\\\"手机品牌\\\"},{\\\"name\\\":\\\"小米\\\",\\\"value\\\":2300879,\\\"type\\\":\\\"手机品牌\\\"},{\\\"name\\\":\\\"oppo\\\",\\\"value\\\":5400879,\\\"type\\\":\\\"手机品牌\\\"},{\\\"name\\\":\\\"vivo\\\",\\\"value\\\":3400879,\\\"type\\\":\\\"手机品牌\\\"}]\",\"size\":{\"width\":450,\"height\":300},\"dataSetId\":\"1011805223195824128\",\"fieldOption\":[{\"label\":\"name\",\"text\":\"name\",\"value\":\"name\"},{\"label\":\"value\",\"text\":\"value\",\"value\":\"value\"}],\"dataSetType\":\"api\",\"actionConfig\":{\"operateType\":\"modal\",\"modalName\":\"\",\"url\":\"\"},\"seriesType\":[],\"w\":450,\"turnConfig\":{\"url\":\"\"},\"linkageConfig\":[],\"dataSetIzAgent\":\"0\",\"option\":{\"showValue\":false,\"unit\":\"\",\"customColor\":[],\"title\":{\"show\":true,\"text\":\"\",\"textStyle\":{\"color\":\"#464646\",\"fontWeight\":\"normal\"}},\"card\":{\"rightHref\":\"\",\"size\":\"default\",\"extra\":\"\",\"title\":\"\"}}}', 'admin', '2024-11-28 11:53:23', NULL, NULL);

INSERT INTO `onl_drag_dataset_head` (`id`, `name`, `code`, `parent_id`, `db_source`, `query_sql`, `content`, `iz_agent`, `data_type`, `api_method`, `create_time`, `create_by`, `update_time`, `update_by`, `low_app_id`, `tenant_id`) VALUES ('1011801324208574464', '大屏数据集', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, '2024-10-31 11:04:04', 'admin', NULL, NULL, NULL, 3);
INSERT INTO `onl_drag_dataset_head` (`id`, `name`, `code`, `parent_id`, `db_source`, `query_sql`, `content`, `iz_agent`, `data_type`, `api_method`, `create_time`, `create_by`, `update_time`, `update_by`, `low_app_id`, `tenant_id`) VALUES ('1011805223195824128', '车辆归属地', '', '1011801324208574464', '', 'https://api.jeecg.com/mock/26/activering', '', '0', 'api', 'get', '2024-10-31 11:19:34', 'admin', '2024-11-15 11:50:54', 'admin', NULL, 3);
INSERT INTO `onl_drag_dataset_head` (`id`, `name`, `code`, `parent_id`, `db_source`, `query_sql`, `content`, `iz_agent`, `data_type`, `api_method`, `create_time`, `create_by`, `update_time`, `update_by`, `low_app_id`, `tenant_id`) VALUES ('1011861146144657408', '拨打电话排行榜', '', '1011801324208574464', '', 'https://api.jeecg.com/mock/26/activering', '', '0', 'api', 'get', '2024-10-31 15:01:47', 'admin', NULL, NULL, NULL, 3);
INSERT INTO `onl_drag_dataset_item` (`id`, `head_id`, `field_name`, `field_txt`, `field_type`, `widget_type`, `dict_code`, `dict_table`, `dict_text`, `iz_show`, `iz_search`, `iz_total`, `search_mode`, `order_num`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1011861146174017536', '1011861146144657408', 'name', 'name', 'String', NULL, NULL, NULL, NULL, 'Y', NULL, NULL, NULL, 0, 'admin', '2024-10-31 15:01:47', NULL, NULL);
INSERT INTO `onl_drag_dataset_item` (`id`, `head_id`, `field_name`, `field_txt`, `field_type`, `widget_type`, `dict_code`, `dict_table`, `dict_text`, `iz_show`, `iz_search`, `iz_total`, `search_mode`, `order_num`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1011861146207571968', '1011861146144657408', 'value', 'value', 'String', NULL, NULL, NULL, NULL, 'Y', NULL, NULL, NULL, 1, 'admin', '2024-10-31 15:01:47', NULL, NULL);
INSERT INTO `onl_drag_dataset_item` (`id`, `head_id`, `field_name`, `field_txt`, `field_type`, `widget_type`, `dict_code`, `dict_table`, `dict_text`, `iz_show`, `iz_search`, `iz_total`, `search_mode`, `order_num`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017248926035136512', '1011805223195824128', 'name', 'name', 'String', NULL, NULL, NULL, NULL, 'Y', NULL, NULL, NULL, 0, 'admin', '2024-10-31 11:19:34', NULL, NULL);
INSERT INTO `onl_drag_dataset_item` (`id`, `head_id`, `field_name`, `field_txt`, `field_type`, `widget_type`, `dict_code`, `dict_table`, `dict_text`, `iz_show`, `iz_search`, `iz_total`, `search_mode`, `order_num`, `create_by`, `create_time`, `update_by`, `update_time`) VALUES ('1017248926102245376', '1011805223195824128', 'value', 'value', 'String', NULL, NULL, NULL, NULL, 'Y', NULL, NULL, NULL, 1, 'admin', '2024-10-31 11:19:34', NULL, NULL);
