/*
 * Decompiled with CFR 0.152.
 */
package dm.jdbc.util;

import dm.jdbc.b.h;
import dm.jdbc.b.l;
import dm.jdbc.driver.DBError;
import dm.jdbc.driver.DmDriver;
import dm.jdbc.driver.DmdbCallableStatement;
import dm.jdbc.driver.DmdbConnection;
import dm.jdbc.driver.DmdbPreparedStatement;
import dm.jdbc.driver.DmdbResultSet;
import dm.jdbc.driver.DmdbStatement;
import dm.jdbc.util.ByteArrayQueue;
import dm.jdbc.util.StringUtil;
import java.io.Closeable;
import java.io.File;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.UnknownHostException;
import java.sql.SQLException;
import java.util.Arrays;

public class DriverUtil {
    public static int compareDmdbVersion(String string, String string2) {
        String[] stringArray = string.split("\\.");
        String[] stringArray2 = string2.split("\\.");
        int n2 = 0;
        while (n2 < stringArray.length) {
            Integer n3 = Integer.valueOf(stringArray[n2]);
            Integer n4 = Integer.valueOf(stringArray2[n2]);
            if (n3 < n4) {
                return -1;
            }
            if (n3.intValue() != n4.intValue()) {
                return 1;
            }
            ++n2;
        }
        return 0;
    }

    public static boolean isLocalHost(String string) {
        String string2;
        String string3;
        if (StringUtil.isEmpty(string)) {
            return false;
        }
        if ("localhost".equalsIgnoreCase(string) || "127.0.0.1".equals(string) || "::1".equals(string)) {
            return true;
        }
        try {
            string3 = InetAddress.getByName(string).getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string3 = string;
        }
        try {
            string2 = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException unknownHostException) {
            string2 = null;
        }
        return string3.equalsIgnoreCase(string2);
    }

    public static String getHostMchName() {
        String string = "";
        try {
            InetAddress inetAddress = null;
            inetAddress = InetAddress.getLocalHost();
            if (inetAddress != null) {
                string = inetAddress.getHostName();
            }
        }
        catch (UnknownHostException unknownHostException) {}
        return string;
    }

    public static void executeWithNewConnection(DmdbConnection dmdbConnection, String string) {
        DmdbConnection dmdbConnection2 = null;
        try {
            dmdbConnection2 = DmDriver.fX.do_connect(dmdbConnection.ek);
            DriverUtil.execute(dmdbConnection2, string);
        }
        catch (Throwable throwable) {
            if (dmdbConnection2 != null) {
                try {
                    dmdbConnection2.do_close();
                }
                catch (SQLException sQLException) {}
            }
            throw throwable;
        }
        if (dmdbConnection2 != null) {
            try {
                dmdbConnection2.do_close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void execute(DmdbConnection dmdbConnection, String string, int n2) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbStatement dmdbStatement = null;
            try {
                dmdbStatement = dmdbConnection.do_createStatement();
                dmdbStatement.do_setQueryTimeout(n2);
                dmdbStatement.do_execute(string);
            }
            catch (Throwable throwable) {
                if (dmdbStatement != null) {
                    try {
                        dmdbStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbStatement != null) {
                try {
                    dmdbStatement.do_close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static void execute(DmdbConnection dmdbConnection, String string) {
        DmdbStatement dmdbStatement = null;
        try {
            dmdbStatement = dmdbConnection.do_createStatement();
            dmdbStatement.do_execute(string);
        }
        catch (Throwable throwable) {
            if (dmdbStatement != null) {
                try {
                    dmdbStatement.do_close();
                }
                catch (Exception exception) {}
            }
            throw throwable;
        }
        if (dmdbStatement != null) {
            try {
                dmdbStatement.do_close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePrepare(DmdbConnection dmdbConnection, String string, l[] lArray, boolean[] blArray) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbPreparedStatement dmdbPreparedStatement = null;
            try {
                dmdbPreparedStatement = dmdbConnection.do_prepareStatement(string);
                int n2 = 1;
                int n3 = 0;
                while (n3 < lArray.length) {
                    if (blArray[n3]) {
                        dmdbPreparedStatement.do_setObject(n2, lArray[n3].data);
                        ++n2;
                    }
                    ++n3;
                }
                dmdbPreparedStatement.do_executeUpdate();
            }
            catch (Throwable throwable) {
                if (dmdbPreparedStatement != null) {
                    try {
                        dmdbPreparedStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbPreparedStatement != null) {
                try {
                    dmdbPreparedStatement.do_close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executePrepareCursorUpdate(DmdbConnection dmdbConnection, String string, l[] lArray, boolean[] blArray, long l2) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbPreparedStatement dmdbPreparedStatement = null;
            try {
                dmdbPreparedStatement = dmdbConnection.do_prepareStatement(string);
                dmdbPreparedStatement.kK = false;
                dmdbPreparedStatement.kE = l2;
                int n2 = 1;
                int n3 = 0;
                while (n3 < lArray.length) {
                    if (blArray[n3]) {
                        if (lArray[n3].fg == null && lArray[n3].fh == null) {
                            dmdbPreparedStatement.do_setObject(n2, lArray[n3].data);
                        } else if (lArray[n3].fg != null && lArray[n3].fh != null) {
                            dmdbPreparedStatement.do_setObject(n2, lArray[n3].data, (int)lArray[n3].fg, lArray[n3].fh);
                        } else if (lArray[n3].fg != null) {
                            dmdbPreparedStatement.do_setObject(n2, lArray[n3].data, lArray[n3].fg);
                        } else {
                            DBError.throwRuntimeException("ResultSetUpdataData must have jtype when use scaleOrLength !");
                        }
                        ++n2;
                    }
                    ++n3;
                }
                dmdbPreparedStatement.do_execute();
            }
            catch (Throwable throwable) {
                if (dmdbPreparedStatement != null) {
                    try {
                        dmdbPreparedStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbPreparedStatement != null) {
                try {
                    dmdbPreparedStatement.do_close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCursorUpdate(DmdbConnection dmdbConnection, String string, long l2) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbPreparedStatement dmdbPreparedStatement = null;
            try {
                dmdbPreparedStatement = dmdbConnection.do_prepareStatement(string);
                dmdbPreparedStatement.kE = l2;
                dmdbPreparedStatement.kK = false;
                dmdbPreparedStatement.do_execute();
            }
            catch (Throwable throwable) {
                if (dmdbPreparedStatement != null) {
                    try {
                        dmdbPreparedStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbPreparedStatement != null) {
                try {
                    dmdbPreparedStatement.do_close();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object[] executePrepareCall(DmdbConnection dmdbConnection, String string, Object[] objectArray, Integer[] integerArray) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbCallableStatement dmdbCallableStatement = dmdbConnection.do_prepareCall(string);
            Object[] objectArray2 = new Object[objectArray.length];
            try {
                int n2 = 0;
                while (n2 < objectArray.length) {
                    if (objectArray[n2] != null) {
                        dmdbCallableStatement.do_setObject(n2 + 1, objectArray[n2]);
                    }
                    if (integerArray[n2] != null) {
                        dmdbCallableStatement.do_registerOutParameter(n2 + 1, (int)integerArray[n2]);
                    }
                    ++n2;
                }
                dmdbCallableStatement.do_execute();
                n2 = 0;
                while (n2 < integerArray.length) {
                    if (integerArray[n2] != null) {
                        objectArray2[n2] = dmdbCallableStatement.do_getObject(n2 + 1);
                    }
                    ++n2;
                }
            }
            catch (Throwable throwable) {
                if (dmdbCallableStatement != null) {
                    try {
                        dmdbCallableStatement.do_close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (dmdbCallableStatement != null) {
                try {
                    dmdbCallableStatement.do_close();
                }
                catch (Exception exception) {}
            }
            return objectArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DmdbResultSet executeQuery(DmdbConnection dmdbConnection, String string) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            DmdbStatement dmdbStatement = dmdbConnection.do_createStatement(1004, 1007, 1);
            dmdbStatement.do_closeOnCompletion();
            return dmdbStatement.do_executeQuery(string);
        }
    }

    public static String executeAndGetExplain(DmdbConnection dmdbConnection, String string) {
        DmdbConnection dmdbConnection2 = dmdbConnection;
        synchronized (dmdbConnection2) {
            String string2;
            block11: {
                DmdbStatement dmdbStatement = null;
                try {
                    dmdbStatement = dmdbConnection.do_createStatement();
                    dmdbStatement.do_execute(string);
                    string2 = dmdbStatement.jc.eP;
                    if (dmdbStatement == null) break block11;
                }
                catch (Throwable throwable) {
                    if (dmdbStatement != null) {
                        try {
                            dmdbStatement.do_close();
                        }
                        catch (Exception exception) {}
                    }
                    throw throwable;
                }
                try {
                    dmdbStatement.do_close();
                }
                catch (Exception exception) {}
            }
            return string2;
        }
    }

    public static boolean checkDbAlive(String string, int n2) {
        boolean bl;
        block14: {
            bl = false;
            Socket socket = null;
            try {
                try {
                    socket = new Socket();
                    InetSocketAddress inetSocketAddress = new InetSocketAddress(string, n2);
                    socket.connect(inetSocketAddress, 5000);
                    bl = true;
                }
                catch (Exception exception) {
                    if (socket != null) {
                        try {
                            socket.close();
                        }
                        catch (Exception exception2) {}
                    }
                    break block14;
                }
            }
            catch (Throwable throwable) {
                if (socket != null) {
                    try {
                        socket.close();
                    }
                    catch (Exception exception) {}
                }
                throw throwable;
            }
            if (socket != null) {
                try {
                    socket.close();
                }
                catch (Exception exception) {}
            }
        }
        return bl;
    }

    public static String formatDir(String string) {
        if (StringUtil.isNotEmpty(string = StringUtil.trimToEmpty(string)) && !string.endsWith(File.separator)) {
            string = String.valueOf(string) + File.separator;
        }
        return string;
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        throwable.printStackTrace(new PrintWriter(stringWriter));
        return stringWriter.toString();
    }

    public static int checkCompleteCharLen(ByteArrayQueue byteArrayQueue, int n2, int n3, String string) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n3) {
            n5 = DriverUtil.calcCharLen(byteArrayQueue, n6, string);
            if (n5 <= 0 || n4 + n5 > n3) break;
            n4 += n5;
            n6 += n5;
        }
        return n4;
    }

    public static int checkCompleteCharLen(byte[] byArray, int n2, int n3, String string) {
        int n4 = 0;
        int n5 = 0;
        int n6 = n2;
        while (n6 < n2 + n3) {
            n5 = DriverUtil.calcCharLen(byArray, n2, string);
            if (n5 <= 0 || n4 + n5 > n3) break;
            n4 += n5;
            n6 += n5;
        }
        return n4;
    }

    private static int calcCharLen(byte[] byArray, int n2, String string) {
        byte by;
        block20: {
            block18: {
                int n3;
                block19: {
                    try {
                        by = byArray[n2];
                        if (!StringUtil.equalsIgnoreCase(string, "GB18030")) break block18;
                        n3 = by & 0xFF;
                        if (n3 > 128) break block19;
                        return 1;
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }
                byte by2 = byArray[n2 + 1];
                n3 = by2 & 0xFF;
                if (n3 >= 64 && n3 <= 254 && n3 != 127) {
                    return 2;
                }
                return 4;
            }
            if (!StringUtil.equalsIgnoreCase(string, "EUC-KR")) break block20;
            int n4 = by & 0xFF;
            if (n4 <= 128) {
                return 1;
            }
            return 2;
        }
        int n5 = 1;
        if ((by & 0x80) == 0) {
            n5 = 1;
        } else if ((by & 0xE0) == 192) {
            n5 = 2;
        } else if ((by & 0xF0) == 224) {
            n5 = 3;
        } else if ((by & 0xF8) == 240) {
            n5 = 4;
        } else if ((by & 0xFC) == 248) {
            n5 = 5;
        } else if ((by & 0xFE) == 252) {
            n5 = 6;
        }
        return n5;
    }

    private static int calcCharLen(ByteArrayQueue byteArrayQueue, int n2, String string) {
        byte by;
        block20: {
            block18: {
                int n3;
                block19: {
                    try {
                        by = byteArrayQueue.getByte(n2);
                        if (!StringUtil.equalsIgnoreCase(string, "GB18030")) break block18;
                        n3 = by & 0xFF;
                        if (n3 > 128) break block19;
                        return 1;
                    }
                    catch (Exception exception) {
                        return -1;
                    }
                }
                byte by2 = byteArrayQueue.getByte(n2 + 1);
                n3 = by2 & 0xFF;
                if (n3 >= 64 && n3 <= 254 && n3 != 127) {
                    return 2;
                }
                return 4;
            }
            if (!StringUtil.equalsIgnoreCase(string, "EUC-KR")) break block20;
            int n4 = by & 0xFF;
            if (n4 <= 128) {
                return 1;
            }
            return 2;
        }
        int n5 = 1;
        if ((by & 0x80) == 0) {
            n5 = 1;
        } else if ((by & 0xE0) == 192) {
            n5 = 2;
        } else if ((by & 0xF0) == 224) {
            n5 = 3;
        } else if ((by & 0xF8) == 240) {
            n5 = 4;
        } else if ((by & 0xFC) == 248) {
            n5 = 5;
        } else if ((by & 0xFE) == 252) {
            n5 = 6;
        }
        return n5;
    }

    public static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (Exception exception) {}
    }

    public static void close(Socket socket) {
        try {
            socket.close();
        }
        catch (Exception exception) {}
    }

    public static void close(ServerSocket serverSocket) {
        try {
            serverSocket.close();
        }
        catch (Exception exception) {}
    }

    public static long murmurhash2_64(String string) {
        byte[] byArray = string.getBytes();
        int n2 = byArray.length;
        int n3 = -512093083;
        long l2 = (long)n3 & 0xFFFFFFFFL ^ (long)n2 * -4132994306676758123L;
        int n4 = n2 / 8;
        int n5 = 0;
        while (n5 < n4) {
            int n6 = n5 * 8;
            long l3 = ((long)byArray[n6 + 0] & 0xFFL) + (((long)byArray[n6 + 1] & 0xFFL) << 8) + (((long)byArray[n6 + 2] & 0xFFL) << 16) + (((long)byArray[n6 + 3] & 0xFFL) << 24) + (((long)byArray[n6 + 4] & 0xFFL) << 32) + (((long)byArray[n6 + 5] & 0xFFL) << 40) + (((long)byArray[n6 + 6] & 0xFFL) << 48) + (((long)byArray[n6 + 7] & 0xFFL) << 56);
            l3 *= -4132994306676758123L;
            l3 ^= l3 >>> 47;
            l2 ^= (l3 *= -4132994306676758123L);
            l2 *= -4132994306676758123L;
            ++n5;
        }
        switch (n2 % 8) {
            case 7: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 6] & 0xFF) << 48;
            }
            case 6: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 5] & 0xFF) << 40;
            }
            case 5: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 4] & 0xFF) << 32;
            }
            case 4: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 3] & 0xFF) << 24;
            }
            case 3: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 2] & 0xFF) << 16;
            }
            case 2: {
                l2 ^= (long)(byArray[(n2 & 0xFFFFFFF8) + 1] & 0xFF) << 8;
            }
            case 1: {
                l2 ^= (long)(byArray[n2 & 0xFFFFFFF8] & 0xFF);
                l2 *= -4132994306676758123L;
            }
        }
        l2 ^= l2 >>> 47;
        l2 *= -4132994306676758123L;
        l2 ^= l2 >>> 47;
        return l2;
    }

    public static final String[] split(String string, String string2) {
        int n2;
        if (string == null || string2 == null) {
            return null;
        }
        int[] nArray = new int[string.length()];
        int n3 = 0;
        int n4 = string.length();
        int n5 = string2.length();
        int n6 = 0;
        while (n6 < n4) {
            if (n6 == 0 && n4 >= n5 && string.substring(0, n5).equals(string2)) {
                n6 += n5 - 1;
            } else {
                n2 = 0;
                while (n2 < n5) {
                    if (string.charAt(n6) == string2.charAt(n2)) {
                        nArray[n3] = n6;
                        ++n3;
                        break;
                    }
                    ++n2;
                }
            }
            ++n6;
        }
        String[] stringArray = new String[n3 + 1];
        if (n3 == 0) {
            stringArray[0] = string;
            return stringArray;
        }
        stringArray[0] = string.substring(0, nArray[0]);
        n2 = 1;
        while (n2 < n3) {
            stringArray[n2] = string.substring(nArray[n2 - 1] + 1, nArray[n2]);
            ++n2;
        }
        stringArray[n3] = string.substring(nArray[n3 - 1] + 1, string.length());
        return stringArray;
    }

    public static void main(String[] stringArray) {
        h h2 = new h();
        h2.setProperty("host", "localhost");
        h2.setProperty("port", "5236");
        h2.setProperty("user", "SYSDBA");
        h2.setProperty("password", "SYSDBA");
        DmdbConnection dmdbConnection = new DmdbConnection(h2);
        Object[] objectArray = new Object[2];
        objectArray[1] = "MYCLS";
        Integer[] integerArray = new Integer[2];
        integerArray[0] = 2004;
        Object[] objectArray2 = DriverUtil.executePrepareCall(dmdbConnection, "BEGIN ? = SF_DESCRIBE_TYPE(?); END;", objectArray, integerArray);
        System.out.println(Arrays.toString(objectArray2));
    }
}

