/*
 * Decompiled with CFR 0.152.
 */
package org.jeecg.modules.htvideo.validator;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.jeecg.modules.htvideo.annotation.RequiredIfKeywordNotNull;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.util.StringUtils;

public class RequiredIfKeywordNotNullValidator
implements ConstraintValidator<RequiredIfKeywordNotNull, Object> {
    private String keywordFieldName;
    private String requiredFieldName;

    public void initialize(RequiredIfKeywordNotNull constraintAnnotation) {
        this.keywordFieldName = constraintAnnotation.keywordField();
        this.requiredFieldName = constraintAnnotation.requiredField();
    }

    public boolean isValid(Object value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        BeanWrapperImpl beanWrapper = new BeanWrapperImpl(value);
        Object keywordValue = beanWrapper.getPropertyValue(this.keywordFieldName);
        Object requiredValue = beanWrapper.getPropertyValue(this.requiredFieldName);
        return StringUtils.hasText((String)((String)keywordValue)) ? requiredValue != null : true;
    }
}

